<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb  d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="card">
        <div class="card-header py-3">
            <nav>
                  <div class="nav nav-tabs" id="nav-tab" role="tablist">
                    <button class="nav-link active" id="nav-eligibility-tab" data-bs-toggle="tab" data-bs-target="#nav-eligibility" type="button" role="tab" aria-controls="nav-eligibility" aria-selected="true">Check Eligibility</button>
                    <button class="nav-link" id="nav-quote-tab" data-bs-toggle="tab" data-bs-target="#nav-quote" type="button" role="tab" aria-controls="nav-quote" aria-selected="false">Get Free Quote</button>
                    <button class="nav-link" id="nav-partner-tab" data-bs-toggle="tab" data-bs-target="#nav-partner" type="button" role="tab" aria-controls="nav-partner" aria-selected="false">Become Partner</button>
                    <button class="nav-link" id="nav-applyloan-tab" data-bs-toggle="tab" data-bs-target="#nav-applyloan" type="button" role="tab" aria-controls="nav-applyloan" aria-selected="true">Apply Loan</button>                    
                    <button class="nav-link" id="nav-enquiry-tab" data-bs-toggle="tab" data-bs-target="#nav-enquiry" type="button" role="tab" aria-controls="nav-enquiry" aria-selected="false">Enquiry Loan</button>
                    <button class="nav-link" id="nav-call-tab" data-bs-toggle="tab" data-bs-target="#nav-call" type="button" role="tab" aria-controls="nav-call" aria-selected="false">Quick Call</button>
                    <button class="nav-link" id="nav-career-tab" data-bs-toggle="tab" data-bs-target="#nav-career" type="button" role="tab" aria-controls="nav-career" aria-selected="false">Career</button>
                    <button class="nav-link" id="nav-contact-tab" data-bs-toggle="tab" data-bs-target="#nav-contact" type="button" role="tab" aria-controls="nav-contact" aria-selected="false">Contact</button>
                  </div>
                </nav>
                <div class="tab-content" id="nav-tabContent">
                    
                  <div class="tab-pane fade show active" id="nav-eligibility" role="tabpanel" aria-labelledby="nav-eligibility-tab">
                          <div class="card-body">
                            <div class="table-responsive">
                              <table class="table align-middle table-striped" id="EligibilityTable">
                                <thead>
                                    <tr>
                                        <th>Sr.No</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>Agree</th>
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tab-pane fade" id="nav-quote" role="tabpanel" aria-labelledby="nav-quote-tab">
                        <div class="card-body">
                            <div class="table-responsive">
                              <table class="table align-middle table-striped" id="FreeQuoteTable">
                                <thead>
                                    <tr>
                                        <th>Sr.No</th>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>Loan Amount</th>
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tab-pane fade" id="nav-partner" role="tabpanel" aria-labelledby="nav-partner-tab">
                        <div class="card-body">
                            <div class="table-responsive">
                              <table class="table align-middle table-striped" id="PartnerTable">
                                <thead>
                                    <tr>
                                        <th>Sr.No</th>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>Address</th>
                                        <th>City</th>
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tab-pane fade" id="nav-applyloan" role="tabpanel" aria-labelledby="nav-applyloan-tab">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-middle table-striped" id="ApplyLoanTable">
                                    <thead>
                                        <tr>
                                            <th>Sr.No</th>
                                            <th>First Name</th>
                                            <th>Last Name</th>
                                            <th>Mobile</th>
                                            <th>Email</th>
                                            <th>Marital Status</th>
                                            <th>Gender</th>
                                            <th>Address</th>
                                            <th>State</th>
                                            <th>City</th>
                                            <th>Pincode</th>
                                            <th>Property</th>
                                            <th>Bank Service</th>
                                            <th>Property Value</th>
                                            <th>Property Pin</th>
                                            <th>Loan Amount</th>
                                            <th>Employment</th>
                                            <th>Annual Income</th>
                                            <th>Co-Applicant Income</th>
                                            <th>EMI</th>
                                            <th>Income Tax</th>
                                            <th>Documents</th>
                                            <th>Agree</th>
                                            <th>Created At</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                      
                    <div class="tab-pane fade" id="nav-enquiry" role="tabpanel" aria-labelledby="nav-enquiry-tab">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-middle table-striped" id="LoanEnquiryTable">
                                    <thead>
                                        <tr>
                                            <th>Sr.No</th>
                                            <th>Name</th>
                                            <th>Mobile</th>
                                            <th>Loan Amount</th>
                                            <th>Pincode</th>
                                            <th>Loan Type</th>
                                            <th>Created At</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tab-pane fade" id="nav-career" role="tabpanel" aria-labelledby="nav-career-tab">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-middle table-striped" id="CareerTable">
                                    <thead>
                                        <tr>
                                            <th>Sr.No</th>
                                            <th>Name</th>
                                            <th>Mobile</th>
                                            <th>Email</th>
                                            <th>About</th>
                                            <th>Resume</th>
                                            <th>Created At</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="nav-call" role="tabpanel" aria-labelledby="nav-call-tab">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-middle table-striped" id="CallTable">
                                    <thead>
                                        <tr>
                                            <th>Sr.No</th>
                                            <th>Mobile</th>
                                            <th>Created At</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-middle table-striped" id="ContactTable">
                                    <thead>
                                        <tr>
                                            <th>Sr.No</th>
                                            <th>Name</th>
                                            <th>Mobile</th>
                                            <th>Email</th>
                                            <th>Address</th>
                                            <th>City</th>
                                            <th>Created At</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
   

    </div>
</main>

<script>
$(document).ready(function() {
    var etable = $('#EligibilityTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_eligibility') ?>",
            "type": "POST"
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }, 
            { "data": 3 }, 
            { "data": 4 }, 
            { "data": 5 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    etable.buttons().container().appendTo('#EligibilityTable_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete_eli', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            etable.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    
      var qtable = $('#FreeQuoteTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_freequote') ?>",
            "type": "POST"
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }, 
            { "data": 3 }, 
            { "data": 4 }, 
            { "data": 5 }, 
            { "data": 6 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });
    
    
    // Move buttons container to a specific location if needed
    qtable.buttons().container().appendTo('#FreeQuoteTable_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete_quote', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            qtable.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    
      var ptable = $('#PartnerTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_partner') ?>",
            "type": "POST"
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }, 
            { "data": 3 }, 
            { "data": 4 }, 
            { "data": 5 }, 
            { "data": 6 },
            { "data": 7 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    ptable.buttons().container().appendTo('#PartnerTable_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete_partner', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            ptable.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    var ltable = $('#LoanEnquiryTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_loanenqury') ?>",
            "type": "POST"
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }, 
            { "data": 3 }, 
            { "data": 4 }, 
            { "data": 5 }, 
            { "data": 6 }, 
            { "data": 7 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    ltable.buttons().container().appendTo('#LoanEnquiryTable_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete_loanenq', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            ltable.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    var ctable = $('#CareerTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_career') ?>",
            "type": "POST"
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }, 
            { "data": 3 }, 
            { "data": 4 }, 
            { "data": 5 }, 
            { "data": 6 }, 
            { "data": 7 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    ctable.buttons().container().appendTo('#CareerTable_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete_career', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            cltable.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    var cltable = $('#CallTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_call') ?>",
            "type": "POST"
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }, 
            { "data": 3 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    cltable.buttons().container().appendTo('#CallTable_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete_call', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            cltable.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    
    var cttable = $('#ContactTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_contact') ?>",
            "type": "POST"
        },
        "columns": [
            { "data": 0 }, 
            { "data": 1 }, 
            { "data": 2 }, 
            { "data": 3 },
            { "data": 4 },
            { "data": 5 },
            { "data": 6 },
            { "data": 7 }
        ],
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    cttable.buttons().container().appendTo('#ContactTable_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete_contact', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            cttable.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    var columnCount = 25; // Total number of columns (from 0 to 24)

    var columnsArray = Array.from({ length: columnCount }, (_, index) => ({ "data": index }));
    
    var altable = $('#ApplyLoanTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_applyloan') ?>",
            "type": "POST"
        },
        "columns": columnsArray, // Use the dynamically generated array
        "lengthChange": true,
        "lengthMenu": [[50, 100, 150, 200, -1], [50, 100, 150, 200, "All"]],
        "dom": 'lBfrtip',
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Branches');
                }
            }
        ]
    });

    // Move buttons container to a specific location if needed
    altable.buttons().container().appendTo('#ApplyLoanTable_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete_apploan', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            altable.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
});

</script>
<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
</style>
