<main class="page-content">
    <!-- Breadcrumb -->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= htmlspecialchars($title) ?></div>
    </div>

    <!-- Card -->
    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                    <!-- Optional header tools -->
                </div>
            </div>
        </div>

        <div class="card-body">
            <!-- Filter Form -->
            <form id="filterForm" method="post">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label>Search</label>
                        <input type="text" class="form-control" id="search_data" name="search_data" placeholder="Name / RLMS ID / CBS No">
                    </div>

                    <div class="col-md-3 mb-3">
                        <br>
                        <button type="button" class="btn btn-success" id="filterSubmit">Filter</button>
                        <button type="button" class="btn btn-secondary" id="resetButton">Reset</button>
                    </div>
                </div>
            </form>

            <!-- DataTable -->
            <div class="table-responsive">
                <table class="table table-striped" id="Table">
                    <thead>
                        <tr>
                            <th>Sr. No</th>
                            <th>Partner Name</th>
                            <th>User Name</th>
                            <th>RLMS ID</th>
                            <th>CBS Account No</th>
                            <th>Archive</th>
                            <th>Login Code</th>
                            <th>Fin. Year</th>
                            <th>Created By</th>
                            <th>Add Date</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- DataTables Script -->
<script>
$(document).ready(function () {
    const table = $('#Table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?= base_url('admin/fetch_query') ?>",
            type: "POST",
            data: function (d) {
                d.search_data = $('#search_data').val();
            }
        },
        columns: [
            { data: null, orderable: false },
            { data: 1 }, // User Name
            { data: 2 }, // RLMS ID
            { data: 3 }, // CBS Account No
            { data: 4 }, // Archive
            { data: 5 },  // Login Code
            { data: 6 },  // Created By
            { data: 7 }, // Add Data
            { data: 8 },  // Status
            { data: 9 },  // Status
            { data: 10 }
        ],
        order: [[4, 'desc']],
        deferLoading: 0, // ✅ Prevent initial load
        columnDefs: [{
            targets: 0,
            render: function (data, type, row, meta) {
                return meta.row + meta.settings._iDisplayStart + 1;
            }
        }]
    });
    
     $('#filterSubmit').on('click', function () {
        table.draw(); // ✅ trigger AJAX load
    });

    $('#filterSubmit').on('click', function () {
        table.ajax.reload();
    });

    $('#resetButton').on('click', function () {
        $('#filterForm')[0].reset();
        //table.ajax.reload();
    });
});
</script>
