<!-- Financial Year Selection Modal -->
<div class="modal fade" id="financialYearModal" tabindex="-1" aria-labelledby="financialYearLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="financialYearLabel">Select Financial Year</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <select class="form-control" id="financial_year">
          <option value="">-- Select Financial Year --</option>
          <option value="24-25">2024-2025</option>
          <option value="25-26">2025-2026</option>
        </select>
      </div>
      <div class="modal-footer">
        <button type="button" id="confirmFinancialYear" class="btn btn-primary">Confirm</button>
      </div>
    </div>
  </div>
</div>


<main class="page-content">

    <div class="card">
              <div class="card-body">
            <form id="filterForm" action="<?php echo base_url('admin/manage_pb_sbi_branch_download'); ?>" method="post">
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label for="start_date">Start Date:</label>
                        <input class="form-control" type="date" id="start_date" name="start_date" value="<?php echo isset($_POST['start_date']) ? $_POST['start_date'] : ''; ?>">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="end_date">End Date:</label>
                        <input class="form-control" type="date" id="end_date" name="end_date" value="<?php echo isset($_POST['end_date']) ? $_POST['end_date'] : ''; ?>">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="branch">Branch</label>
                        <select class="single-select" id="branch" name="branch">
                            <option value="">Select Branch</option>
                            <?php foreach ($branch as $branchItem) : ?>
                                <option value="<?= $branchItem['id']; ?>" <?php echo isset($_POST['branch']) && $_POST['branch'] === $branchItem['id'] ? 'selected' : ''; ?>><?= $branchItem['branch_name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="circle">Circle</label>
                        <select class="single-select" id="circle" name="circle">
                            <option value="">Select Circle</option>
                            <?php foreach ($circle as $circleItem) : ?>
                                <option value="<?= $circleItem['id']; ?>" <?php echo isset($_POST['circle']) && $_POST['circle'] === $circleItem['id'] ? 'selected' : ''; ?>><?= $circleItem['c_name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                        <div class="col-md-2 mb-3">
                           <?php $rbo = $this->db->select("*")->from('mst_rbo')->where('active', 1)->get()->result_array(); ?>
                            <label for="rbo">RBO</label>
                            <select class="single-select" id="rbo" name="rbo">
                                <option value="">Select RBO</option>
                                <?php foreach ($rbo as $rboItem) { ?>
                                    <option value="<?= $rboItem['id']; ?>" <?php echo isset($_POST['rbo']) && $_POST['rbo'] === $rboItem['id'] ? 'selected' : ''; ?>>
                                        <?= $rboItem['rbo_name']; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>

                    <?php if($_SESSION['staff_type']==0){ ?>
                    <div class="col-md-2 mb-3">
                        <label for="connector">Partner</label>
                        <select class="single-select" id="connector" name="connector">
                            <option value="">Select Partner</option>
                            <?php foreach ($connector as $connectorItem) : ?>
                                <option value="<?= $connectorItem['staff_id']; ?>" <?php echo isset($_POST['connector']) && $_POST['connector'] === $connectorItem['staff_id'] ? 'selected' : ''; ?>><?= $connectorItem['staff_fullname']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="created_by_part">Created By Part.</label>
                        <select class="single-select" id="created_by_part" name="created_by_part">
                            <option value="">Select</option>
                            <?php foreach ($connector_created as $connectorItem1) : ?>
                                <option value="<?= $connectorItem1['staff_fullname']; ?>" <?php echo isset($_POST['created_by_part']) && $_POST['created_by_part'] === $connectorItem1['staff_fullname'] ? 'selected' : ''; ?>><?= $connectorItem1['staff_fullname']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <?php } ?>

                    <!--<div class="col-md-2 mb-3">
                        <label for="hlc_status">Payment Partner Status</label>
                        <select name="hlc_status" id="hlc_status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'paid' ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'partly paid' ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'excess paid' ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>-->
                    
                     <div class="col-md-2 mb-3">
                        <label for="hlc_status">Payment Partner Status</label>
                        <select name="hlc_status[]" id="hlc_status" class="multiple-select select2-hidden-accessible" multiple data-placeholder="--Select--">
                           
                            <option value="paid" <?php echo (isset($_POST['hlc_status']) && in_array('paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo (isset($_POST['hlc_status']) && in_array('unpaid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo (isset($_POST['hlc_status']) && in_array('partly paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo (isset($_POST['hlc_status']) && in_array('excess paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="partner_generated">Partner Generated</label>
                        <select name="partner_generated" id="partner_generated" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['partner_generated']) && $_POST['partner_generated'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['partner_generated']) && $_POST['partner_generated'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="pb_payment_status">Payment PB Status</label>
                        <select name="pb_payment_status[]" id="pb_payment_status" class="multiple-select select2-hidden-accessible" multiple>
                            
                            <option value="paid" <?php echo (isset($_POST['pb_payment_status']) && in_array('paid', $_POST['pb_payment_status'])) ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo (isset($_POST['pb_payment_status']) && in_array('unpaid', $_POST['pb_payment_status'])) ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo (isset($_POST['pb_payment_status']) && in_array('partly paid', $_POST['pb_payment_status'])) ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo (isset($_POST['pb_payment_status']) && in_array('excess paid', $_POST['pb_payment_status'])) ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>
                    <!--
                    <div class="col-md-2 mb-3">
                        <label for="pb_payment_status">Payment PB Status</label>
                        <select name="pb_payment_status" id="pb_payment_status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="paid" <?php echo isset($_POST['pb_payment_status']) && $_POST['pb_payment_status'] === 'paid' ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo isset($_POST['pb_payment_status']) && $_POST['pb_payment_status'] === 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo isset($_POST['pb_payment_status']) && $_POST['pb_payment_status'] === 'partly paid' ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo isset($_POST['pb_payment_status']) && $_POST['pb_payment_status'] === 'excess paid' ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>
                    -->
                    <div class="col-md-2 mb-3">
                        <label for="pb_generated">PB Generated</label>
                        <select name="pb_generated" id="pb_generated" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['pb_generated']) && $_POST['pb_generated'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['pb_generated']) && $_POST['pb_generated'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                   

                    <div class="col-md-2 mb-3">
                        <label for="state_id">State</label>
                        <select name="state_id" id="state_id" class="single-select">
                            <option value="">-Select-</option>
                            <?php foreach ($state as $value) { ?>
                                <option value="<?= $value['id']; ?>" <?php echo isset($_POST['state_id']) && $_POST['state_id'] === $value['id'] ? 'selected' : ''; ?>><?= $value['state_name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="city_id">City</label>
                        <select name="city_id[]" id="city_id" class="single-select" multiple> 
                            <option value="">-Select-</option>
                        </select>
                    </div>
                    <!--
                    <div class="col-md-2 mb-3">
                        <label for="city_id">City</label>
                        <select name="city_id" id="city_id" class="single-select">
                            <option value="">-Select-</option>
                        </select>
                    </div>
                    -->
                    <div class="col-md-2 mb-3">
                        <label for="month">Month</label>
                        <input type="month" name="month" id="month" class="form-control" value="<?php echo isset($_POST['month']) ? $_POST['month'] : ''; ?>">
                    </div>
                    
                     <div class="col-md-2 mb-3">
                        <label for="pb_branch_annx_no_blank">Is Branch Annx No Blank?</label>
                        <select name="pb_branch_annx_no_blank" id="pb_branch_annx_no_blank" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['pb_branch_annx_no_blank']) && $_POST['pb_branch_annx_no_blank'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['pb_branch_annx_no_blank']) && $_POST['pb_branch_annx_no_blank'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-3">
                        <label for="pb_branch_annx_date_blank">Is Branch Annx Date Blank?</label>
                        <select name="pb_branch_annx_date_blank" id="pb_branch_annx_date_blank" class="form-control">
                            <option value="">--Select--</option>
                            <option value="Yes" <?php echo isset($_POST['pb_branch_annx_date_blank']) && $_POST['pb_branch_annx_date_blank'] === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?php echo isset($_POST['pb_branch_annx_date_blank']) && $_POST['pb_branch_annx_date_blank'] === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </div>

                    <div class="col-md-3 mb-3">
                        <br>
                        <button type="button" class="btn btn-success" id="filterSubmit">Filter</button>
                        <button class="btn btn-info" type="button" id="resetButton">Reset</button>
                    </div>
                </div>
            </form>
            
           
            <div class="table-responsive">

                <table class="table align-middle table-striped" id="userTable">
                    
                    <?php if($_SESSION['staff_type']==0){ ?>
                        <div class="row mb-3 d-flex justify-content-between">
                            <div class="col-md-3">
                                    <button id="exportSelectedBtn" class="btn btn-primary btn-sm">Download Annx</button>
                            </div>
                        </div>
                    <?php } ?>


                     <thead>
                        <tr>
                             <th><input type="checkbox" id="select-all"></th>
                            <th>Sr.No.</th>
                            <th>Los Id & RLMS ID</th>
                            <th>CBS A/c NO</th>
                            <th>Name of Borrower</th>
                            <th>Type of Loan</th>
                            <th>Date of disb.</th>
                            <th>Loan Limit</th>
                            <th>Renumeration @ %</th>
                            <th>Remuneration</th>
                            <th>SPOC</th>
                            <th>Branch</th>
                            <th>Branch Code</th>
                            <th>TEAM</th>
                            <th>RBO</th>
                            <th>Add Date</th>
                            <th>Verify</th>
                            <th>Apr</th>
                           <!-- <th>FSL</th>-->
                            <th>POD</th>
                            <th>Branch Annx No</th>
                            <th>Branch Annx Date</th>
                            <!--<th>Action</th>-->
                        </tr>
                    </thead>
                    <tbody>          
                             
                   </tbody>
                  
                </div>
  </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
$(document).ready(function () {
    var staffType = <?php echo $_SESSION['staff_type']; ?>;
    var staffId = <?php echo $_SESSION['staff_id']; ?>;
    var columns = [
        { "data": "checkbox" },        
        { "data": "sr_no" },  
        { "data": "rlms_id" },
        { "data": "cbs_account_no" },
        { "data": "applicant_name" },
        { "data": "loan_type" },
        { "data": "disb_date" },
        { "data": "sanction_loan_amt" },
        { "data": "conn_commision" },
        { "data": "remuneration" },
        { "data": "SPOC" },
        { "data": "branch_name" },
        { "data": "branch_code" },
        { "data": "Team" },
        { "data": "rbo" },
        { "data": "add_date" },
        { "data": "verify_by" },
       
       
        /*{ "data": "hlc_name", "visible": (staffType == 0) },*/
        /*{ "data": "hlc_code", "visible": (staffType == 0) },*/
       
       /* { "data": "state" },
        { "data": "city" },
       */
       
        
        
        /*{ "data": "conn_commision", "visible": (staffId == 651 || staffId == 498 || staffId == 13 || staffId == 14 || staffId == 1 || staffId == 538 || staffId == 634)},
        { "data": "conn_payout_amt", "visible": (staffId == 651 || staffId == 498 || staffId == 13 || staffId == 14 || staffId == 538 ||  staffId == 1 || staffId == 634)},
        */
       /* { "data": "sbi_payout", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_commi_amt", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_ten_per", "visible": (staffId == 1 || staffId == 14) },
        { "data": "sbi_ninety_per", "visible": (staffId == 1 || staffId == 14) },*/
        
       /* { "data": "status" },
        { "data": "hlc_generated" },
        { "data": "hlc_payment_status" },
        { "data": "pb_generated", "visible": (staffType == 0)},
        { "data": "pb_payment_status" , "visible": (staffType == 0)},*/
      /*  { "data": "sbi_pb_invoice_no", "visible": (staffId == 498 || staffId == 14 || staffId == 13 || staffId==651)},
        { "data": "sbi_pb_payment_status", "visible": (staffId == 498 || staffId == 14 || staffId == 13 || staffId==651)},
        { "data": "pb_branch_conf_no", "visible": (staffId == 498 || staffId == 14 || staffId == 13 || staffId==651)},*/
        
       /* { "data": "sbi_generated", "visible": (staffType == 0) },
        { "data": "sbi_payment_status", "visible": (staffType == 0) },*/
       
       /*  { "data": "created_by", "visible": (staffId == 14 || staffId == 1 || staffId == 538 || staffId == 13 || staffId == 498 || staffId==651 || staffId==752) },*/
        //{ "data": "is_verify", "visible": (staffId == 498 || staffId == 13 || staffId == 28 || staffId==651 || staffId==14)},
        
       /* { "data": "agency_code" },
        { "data": "agency_name" },*/
        { "data": "appraisal_letter", "exportable": true },      
       /* { "data": "final_sanction_letter", "exportable": true },  */     
        { "data": "proof_disb", "exportable": true },
        { "data": "pb_branch_annx_no" },
        { "data": "pba_input_date" }
        /*{ "data": "edit" }*/
    ];

    var table = $('#userTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo base_url('admin/fetch_pb_sbi_branch_download'); ?>",
            "type": "POST",
            "data": function (d) {
                d.start_date = $('#start_date').val();
                d.end_date = $('#end_date').val();
                d.status = $('#status').val();
                d.connector = $('#connector').val();
                d.branch = $('#branch').val();
                d.hlc_status = $('#hlc_status').val();
                d.pb_payment_status = $('#pb_payment_status').val();
                d.pb_generated = $('#pb_generated').val();
                d.state_id = $('#state_id').val();
                d.city_id = $('#city_id').val();
                d.month = $('#month').val();
               
                d.branch_generated = $('#branch_generated').val();
                d.partner_generated = $('#partner_generated').val();
                d.rbo = $('#rbo').val();
                d.created_by_part = $('#created_by_part').val();
                d.team_leader = $('#team_leader').val();
                d.circle = $('#circle').val();
                d.pb_branch_annx_no_blank = $('#pb_branch_annx_no_blank').val();
                d.pb_branch_annx_date_blank = $('#pb_branch_annx_date_blank').val();
            },
            "error": function (jqXHR, textStatus, errorThrown) {
                console.error("Error loading data: ", textStatus, errorThrown);
            }
        },
        "language": {
        "processing": "<div class='spinner-border text-primary' role='status'></div>Loading data, please wait..." // Optional spinner
    },
        "columns": columns,
        "lengthChange": true,
        "lengthMenu": [[50,100,200,300,500,1000], [50,100,200,300,500,1000]],
        //"lengthMenu": [[50, 100, 300, -1], [50, 100, 300, "All"]],
        "pageLength": 50,
        "order": [[0, 'desc']],
        /*"dom": 'lBfrtip',*/
        "scrollX": true,
        "fixedColumns": {
          leftColumns: 0,
          rightColumns: 2,
        },/*,
           "buttons": [
      
        { extend: 'colvis', text: 'Column Visibility' }
    ],*/
     "drawCallback": function(settings) {
     
      // Adjust the height of the fixed columns to match the scrollable columns
      setTimeout(function() {
        var scrollBodyHeight = $('.dataTables_scrollBody').height();
        $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
        $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

        // Adjust the row heights to match
        $('#userTable tbody tr').each(function(index) {
          var rowHeight = $(this).height();
          $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
          $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
        });
      }, 10);
      
       calculateAndDisplayTotals();
       
       restoreCheckboxState();
     },
    "footerCallback": function (row, data, start, end, display) {
            calculateAndDisplayTotals();
        }
    });

    /*$('#filterSubmit').click(function() {
        table.draw();
    });*/
    var selectedCheckboxes = new Set();

    // Handle "Select All" checkbox
    $('#select-all').on('click', function () {
        var isChecked = this.checked;
        $('.row-checkbox').each(function () {
            this.checked = isChecked;
            var value = $(this).val();
            if (isChecked) {
                selectedCheckboxes.add(value);
            } else {
                selectedCheckboxes.delete(value);
            }
        });
    });

    // Handle individual row checkbox selection
    $('#userTable').on('click', '.row-checkbox', function () {
        var value = $(this).val();
        if (this.checked) {
            selectedCheckboxes.add(value);
        } else {
            selectedCheckboxes.delete(value);
        }

        // Update "Select All" checkbox state
        if ($('.row-checkbox:checked').length === $('.row-checkbox').length) {
            $('#select-all').prop('checked', true);
        } else {
            $('#select-all').prop('checked', false);
        }
    });

    // Restore checked checkboxes after table reloads
    function restoreCheckboxState() {
        $('.row-checkbox').each(function () {
            var value = $(this).val();
            this.checked = selectedCheckboxes.has(value);
        });

        // Update "Select All" checkbox based on current selection
        if ($('.row-checkbox:checked').length === $('.row-checkbox').length) {
            $('#select-all').prop('checked', true);
        } else {
            $('#select-all').prop('checked', false);
        }
    }
    
    $('#filterSubmit').click(function () {
    // Check if the month filter has a value
    var selectedMonth = $('#month').val();
    
    if (selectedMonth) {
        // If a month is selected, show all rows for that month
        table.page.len(-1).draw(); // Display all rows
    } else {
        // Otherwise, revert to default pagination (e.g., 100 rows per page)
        table.draw();
    }
});
    
    $('#resetButton').on('click', function() {
    $('#filterForm')[0].reset();
    
        $('.single-select,.multiple-select').each(function() {
            $(this).val('').trigger('change'); // Works for select2 or similar plugins
        });
    
    table.ajax.reload();
  });

    $('#state_id').change(function() {
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('Admin/get_cities') ?>',
                type: 'POST',
                data: { state_id: stateId },
                dataType: 'json',
                success: function(data) {
                    $('#city_id').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#city_id').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#city_id').empty().append('<option value="">-Select-</option>');
        }
    });

    $('#state_id').trigger('change');
    
   $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });

    $(document).on('click', '.delete', function () {
        var element = $(this);
        var id = element.attr('data-id'); // Use data-id attribute to get the ID
        var action = element.attr('action');

        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function (res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            table.ajax.reload(null, false);  // Reload the table data without resetting pagination
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
    
    
    $(document).on('click', '.commoon_active', function (e) {
    var element = $(this);
    var status = element.attr('active'); // Get the current status
    var id = element.parent('a').data('id'); // Get the data-id directly from the 'a' tag
    var action = element.attr('action'); // Get the action

    console.log("ID: " + id);
    $.ajax({
        type: 'POST',
        url: base_url + 'Admin/' + action + '/' + id + '/' + status,
    }).done(function (response) {
        var res = $.parseJSON(response);
        console.log(res);
        if (res.success == '1') {
            notify(res.type, res.message);
            table.ajax.reload(null, false);
            if (status == '0') { // If current status is 0, change to 1 (Non-verified to Verified)
                element.attr('active', '1'); // Update status attribute to 1
                element.html('Non-verified'); // Update text
                element.addClass('bg-danger').removeClass('bg-success');
                
            } else { // If current status is 1, change to 0 (Verified to Non-verified)
                element.attr('active', '0'); // Update status attribute to 0
                element.html('Verified'); // Update text
                element.addClass('bg-success').removeClass('bg-danger');
               
            }
        } else {
            notify(res.type, res.message);
             table.ajax.reload(null, false);
        }
    }).fail(function () {
        alert("Error in updating status. Please try again.");
    });
});

});


function calculateAndDisplayTotals() {
    var totalSanctionLoanAmt = 0;
    var totalpartnerPercentage = 0;
    var totalPartnerPayoutAmt = 0;
    var totalRemunerationAmt = 0;

    // Define column indices
    var sanctionLoanColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 7 : 7; ?>;
    //var partnerPercentageColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 12 : 0; ?>;
    var partnerPayoutColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 13 : 0; ?>;
    var remunerationColumnIndex = <?php echo ($_SESSION['staff_type'] == 0) ? 14 : 0; ?>;

    // Iterate through table rows to calculate totals
    $('#userTable tbody tr').each(function() {
        var sanctionLoanAmt = parseFloat($(this).find('td').eq(sanctionLoanColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        //var partnerPercentage = parseFloat($(this).find('td').eq(partnerPercentageColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        var partnerPayoutAmt = parseFloat($(this).find('td').eq(partnerPayoutColumnIndex).text().replace(/[^0-9.-]+/g, ""));
        var remunerationAmt = parseFloat($(this).find('td').eq(remunerationColumnIndex).text().replace(/[^0-9.-]+/g, ""));

        if (!isNaN(sanctionLoanAmt)) totalSanctionLoanAmt += sanctionLoanAmt;
       // if (!isNaN(partnerPercentage)) totalpartnerPercentage += partnerPercentage;
        if (!isNaN(partnerPayoutAmt)) totalPartnerPayoutAmt += partnerPayoutAmt;
        if (!isNaN(remunerationAmt)) totalRemunerationAmt += remunerationAmt;
    });

    // Remove existing tfoot if present
    $('#totalsFooter').remove();

    // Construct the tfoot with totals in the correct columns
    var tfootHtml = `
      <tfoot id="totalsFooter">
        <tr>
          <th colspan="${sanctionLoanColumnIndex}" style="text-align:right">Total</th>
          <th>${totalSanctionLoanAmt.toFixed(2)}</th>
          
        </tr>
      </tfoot>
    `;

    // Append the footer to the table
    $('#userTable').append(tfootHtml);
}





</script>

<style>
   .dataTables_length {
      margin-bottom: 13px;
  }
  .dataTables_filter {
      margin-top: 12px;
  }
    
    .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

</style>





<script>
$('#exportBtn').on('click', function() {
  var table = $('#userTable').DataTable();
  var data  = [];

  // 1) headers
  var headers = [];
  $('#userTable thead th:visible').each(function(){
    headers.push($(this).text().trim());
  });
  data.push(headers);

  // 2) rows
  table.rows({ search: 'applied' }).every(function() {
    var rowNode = this.node(),
        rowData = [];

    $(rowNode).find('td:visible').each(function(_, cell){
      var $cell = $(cell);

      if ($cell.find('input').length) {
        rowData.push($cell.find('input').val());
      }
      else if ($cell.find('select').length) {
        rowData.push($cell.find('select option:selected').text());
      }
      else if ($cell.find('.badge').length) {
        rowData.push($cell.find('.badge').text().trim());
      }
      else if ($cell.find('a').length) {
        // ← this block is new
        var href = $cell.find('a').attr('href'),
            txt  = $cell.find('a').text().trim();
        rowData.push({
          v: txt,
          t: 's',
          l: { Target: href, Tooltip: txt }
        });
      }
      else {
        rowData.push($cell.text().trim());
      }
    });

    data.push(rowData);
  });

  // 3) build and download
  var ws = XLSX.utils.aoa_to_sheet(data);
  var wb = XLSX.utils.book_new();
  XLSX.utils.book_append_sheet(wb, ws, 'PB_Users');
  XLSX.writeFile(
    wb,
    'PB_Applicants_' + new Date().toISOString().slice(0,10) + '.xlsx'
  );
});

  $(document).ready(function() {
        $('#city_id').select2({
            placeholder: "-Select-"
        });
    });
    
    
    
 $('#exportSelectedBtn').on('click', function () {
  var table = $('#userTable').DataTable();
  var data = [];

  // 1) Get Headers
  var headers = [];
  $('#userTable thead th:visible').each(function () {
    headers.push($(this).text().trim());
  });
  data.push(headers);

  // 2) Collect selected rows
  const selectedIds = [];
  $('.row-checkbox:checked').each(function () {
    selectedIds.push($(this).val());

    var row = $(this).closest('tr');
    var rowData = [];

    row.find('td:visible').each(function (_, cell) {
      var $cell = $(cell);

      if ($cell.find('input[type="checkbox"]').length) {
        rowData.push($cell.find('input').val());
      }
      else if ($cell.find('input[type="text"]').length) {
        rowData.push($cell.find('input').val());
      }
      else if ($cell.find('select').length) {
        rowData.push($cell.find('select option:selected').text());
      }
      else if ($cell.find('.badge').length) {
        rowData.push($cell.find('.badge').text().trim());
      }
      else if ($cell.find('a').length) {
        var href = $cell.find('a').attr('href') || '',
            txt = $cell.find('a').text().trim();
        rowData.push({
          v: txt,
          t: 's',
          l: { Target: href, Tooltip: txt }
        });
      }
      else {
        rowData.push($cell.text().trim());
      }
    });

    data.push(rowData);
  });

  if (data.length <= 1) {
    alert('Please select at least one record to download.');
    return;
  }

  // 3) Call backend to mark and get batch key
  $.post("<?= base_url('admin/update_pbsbi_branch_annx_download_status') ?>", { ids: selectedIds }, function (res) {
    if (res.success && res.batch_key) {
      // 4) Build Excel using that batch key
      var ws = XLSX.utils.aoa_to_sheet(data);
      var wb = XLSX.utils.book_new();
      XLSX.utils.book_append_sheet(wb, ws, 'PB_Selected');

      var fileName = 'PB_SBI_Branch_Annx_Selected_' + res.batch_key + '_' + new Date().toISOString().slice(0, 10) + '.xlsx';
      XLSX.writeFile(wb, fileName);

      // 5) Reload table
      table.ajax.reload(null, false);
    } else {
      alert(res.message || 'Failed to generate batch.');
    }
  }, 'json');
});

  

</script>



<style>
/* Hide default radio button appearance */
.form-check-input {
    position: absolute;
    opacity: 0;
   
}
.form-check {
    display: block;
    min-height: 1.5rem;
    padding-left: 0px !important;
    margin-bottom: .125rem;
}

/* Style the card as selectable */
.custom-card {
    cursor: pointer;
    width: 150px;
    margin-bottom: 20px;
    border: 2px solid #ccc;
    border-radius: 5px;
    transition: all 0.3s ease;
    display: inline-block;
    text-align: center;
}

/* Change border color and background when selected */
.form-check-input:checked + .custom-label {
    border-color: green;
    background-color: green;
    color: white;
    padding: 10px;
    border-radius: 5px;
    display: inline-block;
}

/* Style for the label to appear like a card */
.custom-label {
    display: inline-block;
    padding: 10px;
    border-radius: 5px;
    border: 2px solid #ccc;
    transition: all 0.3s ease;
    width: 100%;
}

/* Hover effect for the card */
.custom-card:hover .custom-label {
    border-color: green;
}

.dataTables_processing .spinner-border {
    width: 2rem;
    height: 2rem;
    margin-right: 10px;
    vertical-align: middle;
}
</style>
