<main class="page-content">
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>

<link href="<?= base_url() ?>admin_assets/css/new_style.css" rel="stylesheet" />

<style>
/* EXACT SAME NEW DESIGN (same as your new form above) */
.permissions-wrap {
    overflow: auto;
    border-radius: 6px;
    border: 1px solid #e1e1e6;
    margin-top: 10px;
    position: relative;
}

table.permissions-grid {
    border-collapse: collapse;
    width: 100%;
    min-width: 1200px;
}

/* HEADER (top row) */
table.permissions-grid thead th {
    position: sticky;
    top: 0;
    z-index: 3;
    color: #fff;
    text-align: left;
    vertical-align: middle;
    padding: 13px 10px;
    font-weight: 600;
    font-size: 12px;
    background: linear-gradient(183deg, #1A5CFF 0%, #0035b9 60%) !important;
    background-image: url('/mnt/data/4f024c94-80cb-410d-9bd7-03d32020ab1b.png');
    background-size: cover;
    background-position: center;
    border-right: 1px solid rgba(255,255,255,0.06);
    white-space: nowrap;
}

/* First header sticky-left */
table.permissions-grid thead th:first-child {
    background: transparent; 
    position: sticky;
    left: 0;
    z-index: 4;
    background-color: #fff;
    font-size: 13px;
    font-weight: 700;
}

/* LEFT COLUMN (permission names) */
table.permissions-grid tbody td:first-child {
    position: sticky;
    left: 0;
    z-index: 2;
    background: #fff;
    padding: 10px 14px;
    min-width: 260px;
    border-right: 1px solid #eee;
    font-weight: 500;
}

/* normal cells */
table.permissions-grid tbody td {
    padding: 8px 10px;
    border-bottom: 1px solid #eee;
    vertical-align: middle;
}

/* SECTION HEADER FIX */
.section-row td {
    padding: 0 !important;
    background: #f5f5f5;
    border-top: 1px solid #ddd;
}
.section-title {
    position: sticky;
    left: 0;
    z-index: 6;
    display: block;
    padding: 10px 14px;
    background: #f5f5f5;
    font-weight: 700;
    border-right: 1px solid #ddd;
    width: 260px;
}

/* Checkbox cells */
.perm-cell { text-align: center; }
.perm-cell input { transform: scale(1.05); }
</style>

<div class="top-controls">
        <div class="left-area"></div>
        <div class="right-area">
            <input type="text" class="search-box" id="tableSearch" placeholder="🔍 Search">
            <a href="<?= base_url('admin/role_form/') ?>" class="role-btn">+ Add Role</a>
        </div>
    </div>
<div class="permissions-wrap">
    <table class="permissions-grid">
        <thead>
            <tr>
                <th>Permissions</th>

                <?php foreach ($roles as $role_id => $role): ?>
                    <th class="role-header" data-staff-id="<?= $role->staff_id ?>">
                        <span class="role-title"><?= $role->role_name ?></span>
                       <!-- <span class="role-sub"><?= $role->staff_fullname ?> [<?= $role->staff_id ?>]</span>-->
                    </th>
                <?php endforeach; ?>
            </tr>
        </thead>

        <tbody>
            <?php
            // GROUP MENUS BY HEADING (same as your old design)
            $groupedMenus = [];
            foreach ($menus as $menu) {
                $groupedMenus[$menu->heading][] = $menu;
            }

            foreach ($groupedMenus as $heading => $menuItems):
            ?>

                <!-- Section heading -->
                <tr class="section-row">
                    <td colspan="<?= count($roles) + 1 ?>">
                        <span class="section-title"><?= $heading ?></span>
                    </td>
                </tr>

                <?php foreach ($menuItems as $menu): ?>
                    <tr>
                        <td><?= $menu->menu_name ?></td>

                        <?php foreach ($roles as $role_id => $role): ?>
                            <?php
                            $checked = in_array(
                                $menu->menu_name,
                                array_column($role->permissions, 'menu_name')
                            );
                            ?>
                            <td class="perm-cell">
                                <input type="checkbox"
                                       class="permission-checkbox"
                                       data-role-id="<?= $role_id ?>"
                                       data-menu-id="<?= $menu->id ?>"
                                       <?= $checked ? 'checked' : '' ?>>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>

            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
$(".permission-checkbox").change(function(){
    var roleId = $(this).data("role-id");
    var menuId = $(this).data("menu-id");
    var isChecked = $(this).is(":checked") ? 1 : 0;

    $.post("<?= base_url('admin/update_role_permission_menue') ?>", {
        role_id: roleId,
        menu_id: menuId,
        has_permission: isChecked
    });
});
</script>

</main>
