<!-- Edit Payment Log Modal (Bootstrap 5) -->
<!-- Bootstrap 5 Modal -->
<div class="modal fade" id="editPaymentModal" tabindex="-1" aria-labelledby="editPaymentModalLabel" aria-hidden="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editPaymentModalLabel">Edit Payment Log</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editPaymentForm">
                    <input type="hidden" id="edit_invoice_batchno" name="invoice_batchno">
                    <input type="hidden" id="edit_invoice_no_id" name="invoice_no_id">
                    
                    <div class="mb-3">
                        <label class="form-label">Pay Date:</label>
                        <input type="date" class="form-control" id="edit_payment_date" name="payment_date" required>
                    </div>

                   <!-- <div class="mb-3">
                        <label class="form-label">Pay Amount:</label>
                        <input type="number" step="0.01" class="form-control" id="edit_pay_amt" name="pay_amt" required>
                    </div>-->

                    <div class="mb-3">
                        <label class="form-label">Ref No/Cheq No:</label>
                         <textarea class="form-control" id="edit_bank_details" name="bank_details"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Remark:</label>
                        <textarea class="form-control" id="edit_remark" name="remark"></textarea>
                    </div>

                    <button type="submit" class="btn btn-success">Update Payment</button>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="editInvoiceDateModal" tabindex="-1" aria-labelledby="editInvoiceDateModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="invoiceDateForm">
        <div class="modal-header">
          <h5 class="modal-title">Edit Invoice Date</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="invoice_batchno" id="invoice_batchno">
          <label for="invoice_date">Invoice Date</label>
          <input type="date" name="invoice_date" id="invoice_date" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="modal fade" id="editInvoiceNumModal" tabindex="-1" aria-labelledby="editInvoiceNumModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="invoiceNumForm">
        <div class="modal-header">
          <h5 class="modal-title">Edit Invoice Number</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="invoice_batchno" id="invoice_batchno_num">
          <label for="invoice_num">Invoice Number</label>
          <input type="text" name="invoice_num" id="invoice_num" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<main class="page-content">
  <!--breadcrumb-->
  <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3"> <?= $title ?> </div>
  </div>
  <!--end breadcrumb-->
  <div class="card">
    <div class="card-body">
    <form id="filterForm" method="post">
        <div class="row">
          <div class="col-md-2">
            <label for="start_date">Start Date:</label>
            <input class="form-control" type="date" id="start_date" name="start_date">
          </div>
          <div class="col-md-2">
            <label for="end_date">End Date:</label>
            <input class="form-control" type="date" id="end_date" name="end_date">
          </div>
          <div class="col-md-2">
            <label for="branch">Branch</label>
            <select class="single-select" id="branch" name="branch">
                <option value="">Select Branch</option>
                <?php foreach ($branch as $branchItem) : ?>
                    <option value="<?= $branchItem['id']; ?>"><?= $branchItem['branch_name']; ?></option>
                <?php endforeach; ?>
            </select>
          </div>
          <?php if($_SESSION['staff_type']==0){ ?>
          <div class="col-md-2">
            <label for="connector">Partner</label>
            <select class="single-select" id="connector" name="connector">
              <option value="">Select Partner</option> 
              <?php foreach ($connector as $connectorItem) : ?> 
              <option value="<?= $connectorItem['staff_id']; ?>"><?= $connectorItem['staff_fullname']; ?></option>
              <?php endforeach; ?>
            </select>
          </div> 
          <?php } ?>
          <div class="col-md-2">
            <label for="hlc_status">Payment Partner Status</label>
                <select name="hlc_status[]" id="hlc_status" class="multiple-select select2-hidden-accessible" multiple data-placeholder="--Select--">
                   
                    <option value="paid" <?php echo (isset($_POST['hlc_status']) && in_array('paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Paid</option>
                    <option value="unpaid" <?php echo (isset($_POST['hlc_status']) && in_array('unpaid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Unpaid</option>
                    <option value="partly paid" <?php echo (isset($_POST['hlc_status']) && in_array('partly paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Partly Paid</option>
                    <option value="excess paid" <?php echo (isset($_POST['hlc_status']) && in_array('excess paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Excess paid</option>
                </select>
           <!-- <label for="hlc_status">Payment Partner Status</label>
            <select name="hlc_status" class="form-control" id="hlc_status">
              <option value="">--Select--</option>
              <option value="paid">Paid</option>
              <option value="unpaid">Unpaid</option>
              <option value="partly paid">Partly Paid</option>
              <option value="excess paid">Excess paid</option>
            </select>-->
          </div>
          <div class="col-md-2 mb-3">
            <label class="">State</label>
            <select name="state_id" class="single-select" id="state_id">
              <option value="">-Select-</option>
              <?php foreach ($state as $value) { ?>
              <option value="<?= $value['id']; ?>"><?= $value['state_name']; ?></option>
              <?php } ?>                           
            </select>                               
          </div> 
          <div class="col-md-2 mb-3">
           <label for="city_id">City</label>
                    <select name="city_id[]" id="city_id" class="single-select" multiple>
                        <option value="">-Select-</option>
                    </select>
          <!--  <label class="form-label">City</label>
            <select name="city_id" class="single-select" id="citySelect">
              <option value="">-Select-</option>
            </select>-->
          </div>
          <div class="col-md-2 mb-3">
            <label class="form-label">Disb Month</label>
            <input type="month" name="month" class="form-control" id="month">
          </div>
          <div class="col-md-2 mb-3">
            <label class="form-label">Payment Month</label>
            <input type="month" name="payment_month_hlc" class="form-control" id="payment_month_hlc">
          </div>
          <div class="col-md-3 mb-3">
              <br>
            <button class="btn btn-success" type="button" id="filterButton">Filter</button>
            <button class="btn btn-info" type="button" id="resetButton">Reset</button>
          </div>
        </div>
      </form>

      <hr class="mt-3">
     <!-- <ul class="nav nav-tabs" id="myTabs">
        <li class="nav-item">
          <a class="nav-link active" id="unclear-tab" data-bs-toggle="tab" href="#unclear">Invoices</a>
        </li>
       <li class="nav-item">
          <a class="nav-link" id="paid-tab" data-bs-toggle="tab" href="#paid">Paid</a>
        </li>
      
      </ul>-->
      <!-- Bootstrap Tab Content -->
      <div class="tab-content mt-2">
        <div class="tab-pane fade show active" id="unclear">
          <!--<h2>Unclear Invoices</h2>-->
         <!-- <form id="perPageForm" method="post" action="<?php echo base_url('admin/manage_invoice'); ?>">
              <select id="itemsPerPageSelector" name="per_page" onchange="updatePerPage()">
                <option value="">--select--</option>
                <option value="20">20 per page</option>
                <option value="100">100 per page</option>
                <option value="500">500 per page</option>
              </select>
            </form>-->
            
     <div class="table-responsive">
    <table class="table align-middle table-striped" id="invoiceTable">
       <div class="d-flex align-items-center">
    <?php if($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13){ ?>
        <div class="me-2 mb-3">
            <!-- Use a button with an onclick handler -->
            <button type="button" class="btn btn-success btn-sm" id="excelBtn" onclick="downloadExcel()">
                <i class="bi bi-file-excel"></i> Export Partner Paid
            </button>
        </div>
        
        <!--<div class="me-2 mb-3">
            <button type="button" class="btn btn-success btn-sm" id="exportPayoutBtn" onclick="downloadExcelPayout()">
                <i class="bi bi-file-excel"></i> Export to Payout
            </button>
        </div>-->
    <?php } ?>
</div>

<script>

function downloadExcelPayout() {
    // Collect all checked checkboxes (name = partner_id[])
    let selectedIds = [];
    document.querySelectorAll("input[name='partner_id[]']:checked").forEach((el) => {
        selectedIds.push(el.value);
    });

    if (selectedIds.length === 0) {
        alert("Please select at least one partner to export.");
        return;
    }

    // Create a temporary form
    let form = document.createElement("form");
    form.method = "POST";
    form.action = "<?= base_url('admin/export_payout_excel') ?>";

    // Add each selected ID as hidden input
    selectedIds.forEach(id => {
        let input = document.createElement("input");
        input.type = "hidden";
        input.name = "partner_id[]";   // 👈 matches your checkbox name
        input.value = id;
        form.appendChild(input);
    });

    document.body.appendChild(form);
    form.submit();
    form.remove();
}

async function downloadExcel() {
  const btn = document.getElementById('excelBtn');
  btn.disabled = true;
  btn.innerText = 'Please wait file downloading...';

  try {
    // Gather the filter form data as a query string
    const form = document.getElementById('filterForm');
    const formData = new FormData(form);
    const queryString = new URLSearchParams(formData).toString();
   console.log('Query String:', queryString); // Check the query parameters

    // Send the request to Mb_hlc_paid_excel with query params
    const response = await fetch('<?php echo base_url(); ?>Mb_hlc_paid_excel?' + queryString, {
      method: 'GET'
    });

    if (!response.ok) {
      throw new Error('Download failed');
    }

    // Convert the response to a Blob
    const blob = await response.blob();

    // Create a temporary URL for the Blob
    const url = window.URL.createObjectURL(blob);

    // Create a temporary link element
    const a = document.createElement('a');
    a.href = url;
    a.download = 'MB_HLC_Paid_List.xlsx'; // The filename for the download
    document.body.appendChild(a);
    a.click();

    // Clean up
    window.URL.revokeObjectURL(url);
    document.body.removeChild(a);

    // Re-enable the button and restore text
    btn.disabled = false;
    btn.innerText = 'Export Partner Paid';

  } catch (error) {
    console.error(error);
    alert('An error occurred while downloading the file.');
    // Re-enable the button if there's an error
    btn.disabled = false;
    btn.innerText = 'Export Partner Paid';
  }
}
</script>
        <thead>
            <tr>
                <th></th>
                <th>Sr.No</th>
                <th>Partner Name</th>
                <th>Split Partner Name</th>
                <th>City</th>
                <th>Applicant</th>
                <th>Inv Number</th>
                <th>Basic Amt</th>
                <th>CGST 9%</th>
                <th>SGST 9%</th>
                <th>IGST 18%</th>
                <th>Net Pay Amt</th>
                <th>TDS Amt</th>
                <th>Paid Amt</th>
                <th>Balance</th>
                <th>Invoice Date</th>
                <th>Payment Log</th>
                <th>Created Date</th>
                <th>Payment Status</th>
                <th>Created By</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>          
                             
        </tbody>
    </table>
</div>

<!-- Display Total Outside Table -->

        </div>
       <!-- <div class="tab-pane fade" id="paid">
        
        </div>-->
     
      </div>
    </div>
  </div>
</main>


<div class="modal fade" id="invoiceModal" tabindex="-1" aria-labelledby="invoiceModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content" style="overflow-y: auto !important; max-height: inherit;">
      <div class="modal-header">
        <h5 class="modal-title" id="invoiceModalLabel">Payment Status <span id="invoiceNumberLabel"></span></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
    <!--  <form id="invoiceForm" action="<?php echo base_url()?>admin/save_invoice_log_hlc" method="post" enctype="multipart/form-data">
        <div class="modal-body">
          <div class="row">
              <input type="hidden" id="invoiceId" name="invoiceId" value="">
              <input type="hidden" id="total_payable" name="total_payable" value="">
          
              <div class="col-lg-4">
                      <label class="form-label">Net Pay Amt</label>
                      <input type="text" class="form-control" id="tot_pay" value="" readonly>
              </div>
              <div class="col-lg-4">
                      <label class="form-label">Remaining Amt</label>
                      <input type="text" class="form-control" id="rem_amt" value="" readonly>
              </div>
              <div class="col-lg-4">
                    <label for="pay_amt" class="form-label">Pay Amount</label>
                    <input type="text" class="form-control" id="pay_amt" name="pay_amt" required>
                    <div id="error_message" style="color: red;"></div>
              </div>
              <div class="col-lg-4">
                    <label for="payment_date" class="form-label">Payment Date</label>
                    <input type="date" class="form-control" id="payment_date" name="payment_date" required>
              </div>
          </div>
           <div class="row">
                <div class="col-lg-6">
                    <label for="bankDetails" class="form-label">Ref No/Cheq No</label>
                   <textarea class="form-control"  name="bank_details" rows="2"></textarea>
              </div>
              <div class="col-lg-6">
                  <label for="remark" class="form-label">Remark</label>
                   <textarea class="form-control" id="remark" name="remark" rows="2"></textarea>
              </div>
          </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Submit</button>
      </div>
      </form>-->
      
      <!--New Payment form-->
      <form id="invoiceForm" action="<?php echo base_url()?>admin/save_invoice_log_hlc" method="post" enctype="multipart/form-data">
  <div class="modal-body p-4">
    <!-- Hidden fields -->
    <input type="hidden" id="invoiceId" name="invoiceId">
    <input type="hidden" id="total_payable" name="total_payable">
    <input type="hidden" id="invoice_date_pay" name="invoice_date_pay">
    <input type="hidden" id="gst_payable_hidden" name="gst_payable_hidden">

    <div class="mb-3 d-flex justify-content-between align-items-center">
      <small id="invoiceNumberLabel" class="text-muted"></small>
    </div>

    <!-- BASIC SECTION -->
    <div class="section-box mb-3">
      <div class="section-title">Basic</div>

      <div class="row gy-3">
        
        <div class="col-lg-6">
          <label class="form-label" id="tot_pay_label">Payable without GST (After TDS)</label>
          <input type="text" class="form-control boxed-input" id="tot_pay" readonly>
        </div>

        <div class="col-lg-6">
          <label class="form-label">Payment Amount</label>
          <input type="number" step="0.01" class="form-control boxed-input" id="pay_amt" name="pay_amt" required>
          <div id="error_message" class="text-danger small mt-1"></div>
        </div>

        <div class="col-lg-4">
          <label class="form-label">Payment Date</label>
          <input type="date" class="form-control boxed-input" id="payment_date" name="payment_date" required>
        </div>

        <div class="col-lg-4">
          <label class="form-label">Ref No / Cheq No</label>
          <textarea class="form-control boxed-input" id="bank_details" name="bank_details" rows="2"></textarea>
        </div>

        <div class="col-lg-4">
          <label class="form-label">Remark</label>
          <textarea class="form-control boxed-input" id="remark" name="remark" rows="2"></textarea>
        </div>

     <!--   <div class="col-lg-4">
          <label class="form-label">Remaining Amt</label>
          <input type="text" class="form-control boxed-input" id="rem_amt" readonly>
        </div>-->

      </div>
    </div>

 <!-- GST SECTION -->
<div id="gstSection" class="section-box mb-3">
  <div class="section-title">GST</div>

  <div class="row gy-3">
    <div class="col-lg-4">
      <label class="form-label">GST Payable</label>
      <input type="text" class="form-control boxed-input" id="gst_payable" readonly>
    </div>

    <div class="col-lg-4">
      <label class="form-label">GST Amount Payment</label>
      <input type="number" step="0.01" min="0" class="form-control boxed-input" id="gst_pay_amount" name="gst_pay_amount">
    </div>

    <div class="col-lg-4">
      <label class="form-label">GST Amt Payable Date</label>
      <input type="date" class="form-control boxed-input" id="gst_pay_date" name="gst_pay_date">
    </div>

    <div class="col-lg-4">
      <label class="form-label">Ref No (GST)</label>
      <textarea class="form-control boxed-input" id="gst_ref_no" name="gst_ref_no" rows="2"></textarea>
    </div>

    <div class="col-lg-8">
      <label class="form-label">Remark (GST)</label>
      <textarea class="form-control boxed-input" id="gst_remark" name="gst_remark" rows="2"></textarea>
    </div>
  </div>
</div>


    <!-- BUTTONS -->
    <div class="d-flex justify-content-end gap-2">
      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      <button type="submit" class="btn btn-primary">Submit</button>
    </div>
  </div>
</form>


<!-- Styles to mimic sketched boxed layout -->
<style>
  .section-box {
    border: 1px solid #cfcfcf;
    padding: 12px;
    border-radius: 6px;
    background: linear-gradient(180deg, rgba(255,255,255,0.95), rgba(250,250,250,0.95));
  }
  .section-title {
    font-weight: 600;
    margin-bottom: 8px;
    text-decoration: underline;
  }
  .boxed-input {
    border: 1px solid #9aa7c1;
    border-radius: 4px;
    padding: 10px 12px;
    background: #fff;
  }
  /* make the right top payment input narrower like the sketch */
  .mw-50 { max-width: 220px; width: 100%; }
  @media (max-width: 576px) {
    .mw-50 { max-width: 100%; }
  }
</style>

      <hr>
     
      <div class="container table-responsive">
        <h6>Payment History </h6>
               <table class="table" id="paymentHistoryTable">
                  <thead>
                    <tr>
                      <th>Sr. No.</th>
                      <th>Type</th>
                      <th>Payment Date</th>
                      <th>Pay Amt</th>
                      <th>Ref No/Cheq No</th>
                      <th>Remark</th>
                      <th>Status</th>
                    </tr>
                  </thead>
                  <tbody id="paymentHistoryBody">
                    <!-- Payment history rows will be inserted here dynamically -->
                  </tbody>
                </table>
         </div>
         
    </div>
  </div>
</div>




<script>
$(document).ready(function() {
  function getFilterParams() {
    return {
      start_date: $('#start_date').val(),
      end_date: $('#end_date').val(),
      branch: $('#branch').val(),
      connector: $('#connector').val(),
      hlc_status: $('#hlc_status').val(),
      state_id: $('#state_id').val(),
      city_id: $('#city_id').val(),
      month: $('#month').val(),
      payment_month_hlc: $('#payment_month_hlc').val(),
    };
  }

  var table = $('#invoiceTable').DataTable({
    "processing": true,
    "serverSide": true,
    "ajax": {
      "url": "<?= base_url('admin/fetch_invoice_data_hlc') ?>",
      "type": "POST",
      "data": function(d) {
        return $.extend({}, d, getFilterParams());
      }
    },
    "columns": [
      { "data": "checkbox" },  
      { "data": "sr_no" },
      { "data": "hlc_name" },
      { "data": "split_partner_name" },
      { "data": "city" },
      { "data": "applicant" },
      { "data": "inv_number" },
      { "data": "subtotal" },
      { "data": "cgst" },
      { "data": "sgst" },
      { "data": "igst" },
      { "data": "net_pay_amt" },
      { "data": "tds" },
      { "data": "paid_amt" },
      { "data": "balance" },
      { "data": "invoice_date" },
      { "data": "payment_log" },
      { "data": "created_date" },
      { "data": "payment_status" },
      { "data": "created_by" },
      { "data": "edit" }
    ],
    "order": [[10, 'desc']],
    "lengthChange": true,
    "lengthMenu": [[50,100, 300,1000,2000,-1], [50,100, 300,1000,2000,'All']],
    "pageLength": 50,
    "dom": 'lBfrtip',
    "scrollX": true,
    "fixedColumns": {
      leftColumns: 0,
      rightColumns: 1,
    },
    "buttons": [
      { extend: 'excel', text: 'Excel' }
    ],
   
    "drawCallback": function(settings) {
      $('[data-bs-toggle="tooltip"]').tooltip();

      // Adjust the height of the fixed columns to match the scrollable columns
      setTimeout(function() {
        var scrollBodyHeight = $('.dataTables_scrollBody').height();
        $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
        $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

        // Adjust the row heights to match
        $('#invoiceTable tbody tr').each(function(index) {
          var rowHeight = $(this).height();
          $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
          $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
        });
      }, 10);

       // Calculate and display totals
       calculateAndDisplayTotals();

    }
  });

  table.buttons().container().appendTo('#invoiceTable_wrapper .col-md-6:eq(0)');

  

  $('#filterButton').on('click', function() {
    table.ajax.reload();
  });

   $('#resetButton').on('click', function() {
    
        $('.single-select, .multiple-select').each(function() {
            $(this).val('').trigger('change');
        });
    $('#filterForm')[0].reset();
    table.ajax.reload();
  });

  // Fetch cities on state change
  $('#state_id').change(function() {
    var stateId = $(this).val();
    if (stateId !== '') {
      $.ajax({
        url: '<?= base_url('admin/get_cities') ?>',
        type: 'POST',
        data: { state_id: stateId },
        dataType: 'json',
        success: function(data) {
          $('#city_id').empty().append('<option value="">-Select-</option>');
          $.each(data, function(key, value) {
            $('#city_id').append('<option value="' + value.id + '">' + value.city_name + '</option>');
          });
        },
        error: function(xhr, status, error) {
          console.error(xhr.responseText);
        }
      });
    } else {
      $('#city_id').empty().append('<option value="">-Select-</option>');
    }
  });

  // Trigger change event on page load if state is already selected
  $('#state_id').trigger('change');

 function calculateAndDisplayTotals() {
  // Use DataTable API instead of DOM traversal for reliability
  // Column indexes based on your table header:
  // 0 checkbox,1 sr_no,2 partner,3 split,4 city,5 applicant,6 inv number,
  // 7 basic amt, 8 cgst, 9 sgst, 10 igst, 11 net_pay_amt, 12 tds_amt, 13 paid_amt, 14 balance
  var api = table; // DataTable instance

  // Helper to parse currency-like values
  function parseVal(v) {
    if (v === null || v === undefined) return 0;
    // remove non-number characters except minus and dot
    v = v.toString().replace(/[^0-9.-]+/g, '');
    var f = parseFloat(v);
    return isNaN(f) ? 0 : f;
  }

  // Columns to total (use column index)
  var colNetPay = 11;
  var colTdsAmt  = 12;
  var colPaidAmt = 13;
  var colBalance = 14;

  // Get data for current page (use {page:'current'}). This respects serverSide paging.
  var netPayData = api.column(colNetPay, { page: 'current' }).data();
  var tdsAmtData = api.column(colTdsAmt,  { page: 'current' }).data();
  var paidAmtData= api.column(colPaidAmt, { page: 'current' }).data();
  var balanceData= api.column(colBalance, { page: 'current' }).data();

  var totalNetPay = 0, totalTdsAmt = 0, totalPaid = 0, totalBalance = 0;

  netPayData.each(function(val) { totalNetPay += parseVal(val); });
  tdsAmtData.each(function(val) { totalTdsAmt += parseVal(val); });
  paidAmtData.each(function(val) { totalPaid += parseVal(val); });
  balanceData.each(function(val) { totalBalance += parseVal(val); });

  // Remove old tfoot and insert new one (keep it simple)
  $('#invoiceTable tfoot').remove();

  var tfootHtml = `
    <tfoot>
      <tr>
        <th colspan="11" style="text-align:right">Page Total:</th>
        <th>${totalNetPay.toFixed(2)}</th>
        <th>${totalTdsAmt.toFixed(2)}</th>
        <th>${totalPaid.toFixed(2)}</th>
        <th>${totalBalance.toFixed(2)}</th>
        <th colspan="5"></th>
      </tr>
    </tfoot>
  `;

  $('#invoiceTable').append(tfootHtml);
}




// GST VALIDATION
function validateGST() {
    let gstPayable = parseFloat($("#gst_payable").val()) || 0;
    let gstAmount = parseFloat($("#gst_pay_amount").val()) || 0;

    // Reset previous errors
    $("#gst_error").remove();
    $("#gst_pay_amount").removeClass("is-invalid");

    // Case 1: GST Payable = 0 AND user enters gst_amount
    if (gstPayable === 0 && gstAmount > 0) {
        $("#gst_pay_amount").addClass("is-invalid");
        $("#gst_pay_amount").after(`<div id="gst_error" class="text-danger small mt-1">
            GST Payable is 0.00 — you cannot enter GST Amount.
        </div>`);
        return false;
    }

    // Case 2: GST Amount > GST Payable
    if (gstAmount > gstPayable) {
        $("#gst_pay_amount").addClass("is-invalid");
        $("#gst_pay_amount").after(`<div id="gst_error" class="text-danger small mt-1">
            GST Amount cannot be greater than GST Payable (${gstPayable.toFixed(2)}).
        </div>`);
        return false;
    }

    return true;
}

// Trigger validation when user types GST amount
$("#gst_pay_amount").on("input", function () {
    validateGST();
});



 // Form submit handler (AJAX)
$("#invoiceForm").on("submit", function(event) {
  event.preventDefault(); // always prevent default because we submit via AJAX

  // run GST validation first
  if (typeof validateGST === "function") {
    if (!validateGST()) {
      // validation function already shows messages, so just stop
      return false;
    }
  }

  // parse numeric fields properly
  var payAmt = parseFloat($("#pay_amt").val()) || 0;
  var totalPayable = parseFloat($("#tot_pay").val()) || 0;
  var rem_amt = parseFloat($("#rem_amt").val()) || 0;

  // Validate that pay_amt is greater than zero
  if (payAmt <= 0) {
    alert('Pay Amount cannot be zero or empty.');
    return false;
  }

  // Optional: ensure payAmt does not exceed remaining amount
  if (rem_amt !== 0 && payAmt > rem_amt) {
    alert('Pay Amount cannot be greater than Remaining Amount (' + rem_amt.toFixed(2) + ').');
    return false;
  }

  // Disable submit button to avoid duplicate submits
  var $submitBtn = $(this).find('button[type="submit"]');
  $submitBtn.prop('disabled', true).addClass('disabled');

  // Collect form data
  var formData = new FormData(this);

  $.ajax({
    type: 'POST',
    url: $(this).attr('action'),
    data: formData,
    contentType: false,
    processData: false,
    success: function(response) {
      var parsedResponse;
      try {
        parsedResponse = (typeof response === 'object') ? response : JSON.parse(response);
      } catch (err) {
        console.error('Invalid JSON response', err, response);
        alert('Server returned invalid response. Check console.');
        return;
      }

      if (parsedResponse.success === '0' || parsedResponse.success === 0) {
        // success
        alert(parsedResponse.message || 'Saved successfully.');
        $('#invoiceModal').modal('hide');
        if (typeof table !== 'undefined' && $.isFunction(table.ajax.reload)) {
          table.ajax.reload(null, false); // reload DataTable if available
        } else {
          // fallback: reload page or update UI as needed
          // location.reload();
        }
      } else {
        // server returned error
        alert(parsedResponse.message || 'Something went wrong.');
      }
    },
    error: function(jqXHR, textStatus, errorThrown) {
      console.error('AJAX error', textStatus, errorThrown, jqXHR);
      alert('Request failed. See console for details.');
    },
    complete: function() {
      // re-enable submit button
      $submitBtn.prop('disabled', false).removeClass('disabled');
    }
  });

  return false;
});

window.openInvoiceModal = function(invoiceId, totalpayable, rem_amt, InvNum, InvDate, GstPayable) {
    // Convert to numbers and fixed format
    totalpayable = parseFloat(totalpayable) || 0;
    rem_amt = parseFloat(rem_amt) || 0;
    GstPayable = parseFloat(GstPayable) || 0;
    totalpayable = totalpayable.toFixed(2);
    rem_amt = rem_amt.toFixed(2);
    GstPayable = GstPayable.toFixed(2);

    const invoiceDate = new Date(InvDate);
    const cutoffDate = new Date('2025-11-12');

    // Update label based on cutoff
    if (invoiceDate >= cutoffDate) {
        $("#tot_pay_label").text("Payable without GST (After TDS)");
    } else {
        $("#tot_pay_label").text("Net Pay Amt");
    }

    // --- Reset user-editable fields (keep hidden/readonly ones) ---
    // Clear all inputs/textarea except the IDs we want to keep
    $('#invoiceForm').find('input, textarea, select').not([
        '#invoiceId',
        '#total_payable',
        '#tot_pay',
        '#gst_payable',
        '#gst_payable_hidden',
        '#rem_amt',
        '#invoice_date_pay'
    ].join(',')).each(function(){
        if ($(this).is(':checkbox') || $(this).is(':radio')) {
            $(this).prop('checked', false);
        } else {
            $(this).val('');
        }
    });

    // Now set main readonly/hidden values
    $("#invoiceId").val(invoiceId);
    $("#total_payable").val(totalpayable);
    $("#tot_pay").val(totalpayable);
    $("#rem_amt").val(rem_amt);
    $("#invoice_date_pay").val(InvDate);
    $("#invoiceNumberLabel").text("Invoice No: " + InvNum);

    // GST fields (always set hidden/display values)
    $("#gst_payable").val(GstPayable);
    $("#gst_payable_hidden").val(GstPayable);

    // Show or hide GST SECTION based on cutoff AND properly enable/disable & clear values
    if (invoiceDate >= cutoffDate) {
        $("#gstSection").show();
        $("#gstSection").find('input, textarea, select').prop('disabled', false);
        // optionally prefill gst_pay_amount:
        // $("#gst_pay_amount").val(GstPayable);
    } else {
        // hide GST section and clear its user inputs
        $("#gstSection").hide();
        $("#gst_pay_amount, #gst_pay_date, #gst_ref_no, #gst_remark").val('').prop('disabled', true);
        // keep readonly displayed gst_payable but don't submit it
        $("#gst_payable_hidden").val('0.00');
    }

    // SHOW MODAL
    $('#invoiceModal').modal('show');

    // Fetch payment history
    $.ajax({
        type: 'GET',
        url: '<?php echo base_url()?>admin/get_invoice_log/' + invoiceId,
        success: function(response) {
            updatePaymentHistoryTable(response);
        },
        error: function(err) {
            console.error(err);
        }
    });
};

// Extra safety: when modal is fully hidden, clear user inputs so next open starts clean
$('#invoiceModal').on('hidden.bs.modal', function () {
    $('#invoiceForm').find('input, textarea, select').not([
        '#invoiceId',
        '#total_payable',
        '#tot_pay',
        '#gst_payable',
        '#gst_payable_hidden',
        '#rem_amt',
        '#invoice_date_pay'
    ].join(',')).each(function(){
        if ($(this).is(':checkbox') || $(this).is(':radio')) {
            $(this).prop('checked', false);
        } else {
            $(this).val('');
        }
    });

    // Also hide GST section by default (optional)
    $("#gstSection").hide();
    $("#gstSection").find('input, textarea, select').prop('disabled', true);
});



  
  function formatDate(dateString) {
    // Parse the date in its current format (assuming it's in 'yyyy-mm-dd' format)
    var parts = dateString.split("-");
    var formattedDate = parts[2] + "-" + parts[1] + "-" + parts[0];
    return formattedDate;
  }

  function updatePaymentHistoryTable(paymentHistory) {
    // Clear existing rows and reset total
    $('#paymentHistoryBody').empty();
    var totalPayAmt = 0;

    // Append new rows based on payment history data
    $.each(paymentHistory, function(index, payment) {
        // Format payment date
        var formattedDate = formatDate(payment.payment_date);

        // Parse pay_amt as a float and accumulate totalPayAmt
        var payAmt = parseFloat(payment.pay_amt);
        totalPayAmt += payAmt;

        var row = '<tr>' +
            '<td>' + (index + 1) + '</td>' +
            '<td>' + payment.payment_type + '</td>' +
            '<td>' + formattedDate + '</td>' +
            '<td>' + payAmt.toFixed(2) + '</td>' + // Format payAmt with two decimal places
            '<td>' + payment.bank_details + '</td>' +
            '<td>' + payment.remark + '</td>' +
            '</tr>';

        $('#paymentHistoryBody').append(row);
    });

    // Format totalPayAmt with two decimal places
    var formattedTotal = totalPayAmt.toFixed(2);

    // Display total at the end of the table
    var totalRow = '<tr>' +
        '<td colspan="3"><strong>Total PayAmt:</strong></td>' +
        '<td><strong>' + formattedTotal + '</strong></td>' + // Display formattedTotal
        '<td colspan="5"></td>' +
        '</tr>';

    $('#paymentHistoryBody').append(totalRow);
  }

  window.DeletePaymentLog = function(invoiceNumber) {
    Swal.fire({
        title: 'Are you sure?',
        text: 'Do you want to delete this payment log?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            // Perform the AJAX request to delete the log
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url()?>admin/delete_payment_log_hlc',
                data: { invoice_number: invoiceNumber },
                success: function(response) {
                    var parsedResponse = JSON.parse(response);
                    if (parsedResponse.success === '1') {
                        Swal.fire(
                            'Deleted!',
                            'The payment log has been deleted.',
                            'success'
                        );
                        table.ajax.reload(null, false);
                    } else {
                        Swal.fire(
                            'Error!',
                            parsedResponse.message,
                            'error'
                        );
                    }
                },
                error: function(error) {
                    Swal.fire(
                        'Error!',
                        'There was an error deleting the payment log.',
                        'error'
                    );
                    console.error(error);
                }
            });
        }
    });
  };



  $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });

  // Ensure the form validation is correct for the pay amount
  $('#pay_amt').on('input', function() {
    var payAmt = parseFloat($(this).val());
    var remAmt = parseFloat($('#rem_amt').val());

    if (isNaN(payAmt)) {
        $('#error_message').text('Please enter a valid number.');
        $(this).val('');
    } /*else if (payAmt > remAmt) {
        $('#error_message').text('Pay Amount cannot be greater than Remaining Amount');
        $(this).val('');
    }*/ else {
        $('#error_message').text('');
    }
  });

  // Handle delete action with confirmation
  $(document).on('click', '.delete', function () {
    var element = $(this);
    var id = element.attr('data-id'); // Use data-id attribute to get the ID
    var action = element.attr('action');

    Swal.fire({
        title: 'Are you sure?',
        text: "Are you sure you want to delete this Invoice?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                type: 'POST',
                url: base_url + 'admin/' + action + '/' + id,
                dataType: 'json',
                success: function (res) {
                    if (res.success == '1') {
                        notify(res.type, res.message);
                        table.ajax.reload(null, false);  // Reload the table data without resetting pagination
                    } else {
                        notify(res.type, res.message);
                    }
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                    alert('Error occurred while deleting data. Please try again.');
                }
            });
        }
    });
  });
});


   $(document).on("click", ".edit-payment-log", function () {
 
    // Fetch values from data attributes
    let invoiceBatchNo = $(this).data("invoice") || "";
    let invoice_no_id = $(this).data("invoice_no_id") || "";
    let paymentDate = $(this).data("payment_date") || "";
    let payAmt = $(this).data("pay_amt") || "";
    let bankDetails = $(this).data("bank_details") || "";
    let remark = $(this).data("remark") || "";


    // Populate the modal fields
    $("#edit_invoice_batchno").val(invoiceBatchNo);
    $("#edit_invoice_no_id").val(invoice_no_id);
    $("#edit_payment_date").val(paymentDate);
    $("#edit_pay_amt").val(payAmt);
    $("#edit_bank_details").val(bankDetails);
    $("#edit_remark").val(remark);

    // Ensure Bootstrap modal is correctly initialized and shown
    /*let modal = new bootstrap.Modal(document.getElementById("editPaymentModal"));
    modal.show();*/
});



$(document).on("submit", "#editPaymentForm", function (e) {
    e.preventDefault(); // Prevent default form submission

    let formData = $(this).serialize(); // Serialize form data

    $.ajax({
        url: "<?= base_url('admin/update_payment_log') ?>", // Replace with actual controller name
        type: "POST",
        data: formData,
        dataType: "json",
        success: function (response) {
            if (response.status === "success") {
                alert("Payment log updated successfully!");
                $("#editPaymentModal").modal("hide"); // Close modal

                // Reload DataTable without full page refresh
                $('#invoiceTable').DataTable().ajax.reload(null, false);
            } else {
                alert("Error: " + response.message);
            }
        },
        error: function () {
            alert("An error occurred while updating payment.");
        },
    });
});



$(document).on('click', '.edit-invoice-date-btn', function () {
    let invoice = $(this).data('invoice');
    let currentDate = $(this).data('current-date');
    $('#invoice_batchno').val(invoice);
    $('#invoice_date').val(currentDate);
});
$('#invoiceDateForm').on('submit', function (e) {
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('admin/update_invoice_date') ?>',
        type: 'POST',
        data: $(this).serialize(),
        success: function (response) {
            let res = JSON.parse(response);
            if (res.success) {
                Swal.fire('Success', res.message, 'success');
                $('#editInvoiceDateModal').modal('hide');
                $('#invoiceTable').DataTable().ajax.reload(null, false);
            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});


$(document).on('click', '.edit-invoice-num-btn', function () {
     let invoice = $(this).data('invoice');
    let currentNum = $(this).data('current-num');

    $('#invoice_batchno_num').val(invoice);
    $('#invoice_num').val(currentNum);

    $('#editInvoiceNumModal').modal('show');
});
$('#invoiceNumForm').on('submit', function (e) {
    e.preventDefault();
    
      // 🔍 Log values to browser console
 //   console.log("invoice_batchno:", $('#invoice_batchno').val());
 //   console.log("invoice_num:", $('#invoice_num').val());
    
    $.ajax({
        url: '<?= base_url('admin/update_invoice_number') ?>',
        type: 'POST',
        data: $(this).serialize(),
        success: function (response) {
            let res = JSON.parse(response);
            if (res.success) {
                Swal.fire('Success', res.message, 'success');
                $('#editInvoiceNumModal').modal('hide');
                $('#invoiceTable').DataTable().ajax.reload(null, false);
            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});

</script>

<script>
 function deleteApplicantMBInvoice(invoiceId, userId, applicantName) {
     if (confirm('Are you sure you want to delete this invoice for ' + applicantName + '?')) {
        console.log({ invoice_id: invoiceId, user_id: userId });
        $.ajax({
            url: '<?= base_url("admin/delete_invoice_mb_applicant") ?>',
            type: 'POST',
            dataType: 'json', // Specify the expected data type
            data: {
                invoice_id: invoiceId,
                user_id: userId
            },
            success: function(response) {
                console.log(response);
                if (response.success) {
                    alert(response.message || 'Invoices Applicant deleted successfully!');
                    table.ajax.reload(null, false);
                } else {
                    alert(response.message || 'Cannot delete: MB Payment status is Paid');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                alert('Error occurred while processing the request.');
            }
        });
    }
}


</script>


<style>
  .dataTables_length {
      margin-bottom: 13px;
  }
  .dataTables_filter {
      margin-top: 12px;
  }


  .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

  

</style>

