<?php
function getIndianCurrency(float $amount) {
    $amount_after_decimal = round($amount - ($num = floor($amount)), 2) * 100;

    // Check if there is any number after decimal
    $amt_hundred = null;
    $count_length = strlen($num);
    $x = 0;
    $string = array();
    $change_words = array(
        0 => 'Zero', 1 => 'One', 2 => 'Two',
        3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
        7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
        10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
        13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
        16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
        19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
        40 => 'Fourty', 50 => 'Fifty', 60 => 'Sixty',
        70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
    );
    $here_digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
    while ($x < $count_length) {
        $get_divider = ($x == 2) ? 10 : 100;
        $amount = floor($num % $get_divider);
        $num = floor($num / $get_divider);
        $x += $get_divider == 10 ? 1 : 2;
        if ($amount) {
            $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
            $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
            $string[] = ($amount < 21) ? $change_words[$amount] . ' ' . $here_digits[$counter] . $add_plural . '
       ' . $amt_hundred : $change_words[floor($amount / 10) * 10] . ' ' . $change_words[$amount % 10] . '
       ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
        } else $string[] = null;
    }
    $implode_to_Rupees = implode('', array_reverse($string));
    $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[intval($amount_after_decimal / 10)] . "
   " . $change_words[$amount_after_decimal % 10]) . ' Paise' : '';
    return ($implode_to_Rupees ? $implode_to_Rupees . ' Rupees ' : '') . $get_paise;
}

function formatIndianNumber($number) {
  // Round up the number to two decimal places
    $rounded_number = round($number, 2);

    // Convert the rounded number to string
    $number_str = strval($rounded_number);

    // Split the number into integral and fractional parts
    $parts = explode('.', $number_str);

    // Format the integral part
    $integral_part = $parts[0];
    $formatted_integral = '';

    // Format the integral part with commas after every two digits if the number has six or more digits
    $len = strlen($integral_part);
    $i = $len - 1;
    $count = 0;
    while ($i >= 0) {
        $formatted_integral = $integral_part[$i] . $formatted_integral;
        $count++;
        if (($count == 3 || $count == 5 || $count == 7) && $i != 0) {
            $formatted_integral = ',' . $formatted_integral;
        }
        $i--;
    }

    // Format the fractional part
    $formatted_fractional = isset($parts[1]) ? '.' . str_pad($parts[1], 2, '0') : '.00';

    // Combine the formatted integral part with the formatted fractional part
    $formatted_number = $formatted_integral . $formatted_fractional;

    return $formatted_number;
}

?>

  

 <main class="page-content"> 
    <div class="card border shadow-none">
          <div class="card-header py-3">
                  <div class="row g-3">                   
                    <div class="col-12 col-lg-12 text-md-end">
                         <h1>Invoice for SBI</h1>
                      <a href="<?php echo base_url() ?>admin/manage_invoice_sbi" class="btn btn-sm btn-danger me-2"><i class="bi bi-arrow-return-left"></i> Back</a> 
                      <a href="javascript:;" onclick="printInvoice()" class="btn btn-sm btn-secondary"><i class="bi bi-printer-fill"></i> Print</a>
                    </div>
                  </div>
             </div>
    </div>
    
 <div class="card-body">
              <div id="invoice">
                  <style>
                      .table-bordered {
                        border-collapse: collapse;
                        border: 1px solid black; /* Border color */
                    }
                    
                    .table-bordered th,
                    .table-bordered td {
                        border: 1px solid black; /* Border color */
                        padding: 4px; /* Adjust padding as needed */
                    }
                    
                  </style>
                   <div class="card-body bg-white">
             
             
            
    <table class="table table-invoice table-bordered" id="gstTable" style="font-size:11px !important;">
        <thead>
                <tr>
                    <td colspan="12" style="font-size:16px;background-color:rgb(217, 225, 242);border-bottom:0.5pt solid windowtext;border-left:0.5pt solid windowtext;border-right-style:block;border-top:0.5pt solid windowtext;height:18.0pt;padding:3px;text-align:center;width:100%;">
                        <span style="color:black;"><strong>GST TAX INVOICE</strong></span>
                    </td>
               </tr>
               <tr>
                <td colspan="4" style="width: 32%;">
                         <p><strong>Name of HLC: MortgageBuddy Private Limited</strong></p>
                       
                        ADDRESS: Office No H 218, 2nd Floor, Tower No 3, Belapur Station Complex, CBD Belapur, Navi Mumbai - 400614, Maharashtra
                        
                </td>
               
                 <td colspan="5" rowspan="2" style="border-bottom: hidden;">
                       <center><img src="https://www.mortgagebuddy.in/myimg/logofinal.png" style="height:50px;"></center>
                        <center style="margin-top: 14px;"><span><strong>CORPORATE CHANNEL PARTNER OF SBI</strong></span></center>
                </td>
                <td colspan="4" rowspan="9">
                    <div style="margin-bottom: 30px !important;">
                    <strong>TO</strong>
                    <br><strong>STATE BANK OF INDIA</strong>
                    <br>
                        <!--Branch - <?= $branch->branch_name; ?>(<?= $branch->branch_code; ?>),<?= @$city->city_name; ?>, <?= @$state->state_name; ?>--> 
                        City - <?= @$city->city_name; ?>, State-<?= @$state->state_name; ?>
                    <br>
                        GSTIN NO - 27AAACS8577K2ZO
                    <br>
                        RBO -
                   <br>
                     </div>
                        <br><strong>Invoice No : <?= $invoice_num; ?></strong>
                        <br>
                        <strong>Invoice Date : <?= date('d-m-Y',strtotime($invoice_date))?></strong>
                    
                </td>
            </tr>
            <tr>
                <td colspan="4" rowspan="6">
                      HLC Code -MUMHLC03147
                     <br>GSTIN NO -27AAQCM2355K1ZZ
                     <br>PAN NO- AAQCM2355K
                     <br>Bank Account No : 41326113534
                  
                </td>
            </tr>
           
            <tr>
                <td colspan="5">
                    Office No- 022 46082235
                    <br>
                        Mobile - 8830394993
                    <br>
                        Email - Accounts@mortgagebuddy.in
                </td>
            </tr>
       
                   </thead>
        <tbody>
            <tr>
                <td rowspan="2" style="background: #d9e1f2;">
                    Sr. No.
                </td>
                <td rowspan="2"  style="background: #d9e1f2;" width="10%">
                    CBS A/c No
                </td>
               <td rowspan="2"  style="background: #d9e1f2;" width="10%">
                    Branch
                </td>
                <td rowspan="2"  style="background: #d9e1f2;">
                    HSN / SAC
                </td>
                <td style="border-bottom:.5pt solid black;width:48pt; background: #d9e1f2;" rowspan="2">
                    Taxable Value Rs
                </td>
                <td style="border-left-style:none;border-right:.5pt solid black;width:96pt; background: #d9e1f2;" colspan="2">
                    CGST
                </td>
                <td style="border-left-style:none;border-right:.5pt solid black;width:96pt; background: #d9e1f2;" colspan="2">
                    SGST
                </td>
                <td style="border-left-style:none;border-right:.5pt solid black;width:96pt; background: #d9e1f2;" colspan="2">
                    IGST
                </td>
                <td style="border-bottom:.5pt solid black;border-right:.5pt solid black;width:129pt; background: #d9e1f2;" rowspan="2">
                    TOTAL
                </td>
            </tr>
            
            <tr>
                <td style="border-left-style:none;border-top-style:none;height:28.8pt;width:48pt; background: #d9e1f2;">
                    Rate
                </td>
                <td style="border-left-style:none;border-top-style:none;width:48pt;background: #d9e1f2;">
                    Amount Rs
                </td>
                <td style="border-left-style:none;border-top-style:none;width:48pt;background: #d9e1f2;">
                    Rate
                </td>
                <td style="border-left-style:none;border-top-style:none;width:48pt;background: #d9e1f2;">
                    Amount Rs
                </td>
                <td style="border-left-style:none;border-top-style:none;width:48pt;background: #d9e1f2;">
                    Rate
                </td>
                <td style="border-left-style:none;border-top-style:none;width:48pt;background: #d9e1f2;">
                    Amount Rs
                </td>
            </tr>
             <?php
                     if (!empty($invoice_items)) {
                        $tot90percent_commi = 0;
                        $totcommissionRR = 0;
                        foreach ($invoice_items as $key => $row) { 
                            $user_data = $this->db->select("*")->from('mst_user')->where(['id' =>$row['user_id']])->get()->row();
                            $user_branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();
                            $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' =>$user_data->loan_type_id])->get()->row();
                            $tot90percent_commi += $row['90percent_commi'];
                            $totcommissionRR += $row['rr_fix_commi'];
                           ?>
            <tr class="invoice-row">
                <td style="height:14.4pt;">
                    <?= $key +1; ?>
                </td>
                <td style="border-left-style:none;width:95pt;">
                     <?php if($row['loan_type_id']==5){ ?>
                      <span class="text-inverse"><?= $user_data->rr_cbs_acct_no; ?></span>
                      <?php } else{ ?>
                      <span class="text-inverse"><?= $user_data->bank_acct_no; ?></span>
                      <?php } ?>
                </td>
                
                <td style="text-align:left;"><?= $user_branch->branch_name; ?><br>(<?= $user_branch->branch_code; ?>) </td> 
               
                <td>
                    9971
                </td>
                <td class="taxable-value">
                    <?= formatIndianNumber($row['90percent_commi']) ?>
                </td>
              
                <td>
                    9%
                </td>
                <td class="tot_amount1 cgst-amount">
                    <span><?= formatIndianNumber($row['90percent_commi']*9/100) ?></span>
                </td>
                <td>
                    9%
                </td>
                <td class="sgst-amount">
                    <?= formatIndianNumber($row['90percent_commi']*9/100) ?>
                </td>
                <td style="text-align:right;">
                    18.00%
                </td>
                <td style="text-align:center;">
                    -
                </td>
                <td class="total-amount" style="text-align:right;"></td>
                
                  <?php if($row['loan_type_id']==5){ ?>
                       <tr class="invoice-row">
                           
                           <td></td>
                         
                            <td>
                             <?php if($row['loan_type_id']==5){ ?>
                              <span class="text-inverse"><?= $user_data->rr_cbs_acct_no; ?></span>
                              <?php } else{ ?>
                              <span class="text-inverse"><?= $user_data->bank_acct_no; ?></span>
                              <?php } ?>
                            </td>
                           <td style="text-align:left;"><?= $user_branch->branch_name; ?><br>(<?= $user_branch->branch_code; ?>) </td> 
                           <td>9971</td>
                           <td class="taxable-value"><?= formatIndianNumber($row['rr_fix_commi']) ?></td> 
                           <td>9%</td>
                           <td class="tot_amount1 cgst-amount">
                               <span><?= formatIndianNumber($row['rr_fix_commi']*9/100) ?></span></td>
                           <td>9%</td>
                           <td class="sgst-amount"><?= formatIndianNumber($row['rr_fix_commi']*9/100) ?></td>
                            <td style="text-align:right;">
                                18.00%
                            </td>
                            <td style="text-align:center;">
                                -
                            </td>
                          <td class="total-amount" style="text-align:right;"></td>
                           
                     </tr>
                     <?php } ?> 
            </tr>
              <?php
                        }

                  } ?>
            
            <tr>
                <td style="height:14.4pt;">
                </td>
                <td style="border-left-style:none;width:95pt;">
                </td>
                <td>
                </td>
                <td>
                </td>
                <td>
                </td>
                <td>
                </td>
                <td>
                </td>
                <td>
                </td>
                <td>
                </td>
                
                <td>
                </td>
                <td style="text-align:center;">
                    -
                </td>
                <td style="text-align:right;">
                    -
                </td>
            </tr>
            <tr>
                <td style="border-top-style:none;height:14.4pt;width:31pt;">
                   
                </td>
                <td style="border-top-style:none;width:95pt;">
                   <b> Sub Total</b>
                </td>
                <td style="border-top-style:none;width:48pt;">
                    
                </td>
             
                <td>
                    
                </td>
                   <td id="totalAmount3"> 
                    <b>
                    <?php 
                         $totalAmount3 = formatIndianNumber($tot90percent_commi + $totcommissionRR);
                          echo $totalAmount3;
                    ?>
                    </b>
                </td>
                <td>
                    
                </td>
                <td id="totalAmount1">
                    
                </td>
                <td>
                   
                </td>
                <td id="totalAmount2">
                    
                </td>
                <td>
                   
                </td>
                <td style="text-align:center;">
                    -
                </td>
                <td style="text-align:right;" id="subtotal">
                    
                </td>
            </tr>
            <tr>
                <td style="height:25.6pt;" colspan="8" rowspan="2">
                    <span id="numtoword"></span>
                </td>
                <span id="cgst" class="text-white"></span>
                <span id="sgst" class="text-white"></span>
                
            </tr>
            
            
            <tr>
                <td style="text-align:center;background: #d9e1f2;" colspan="3">
                    <b>TOTAL GST</b>
                </td>
                <td style="text-align:right;background: #d9e1f2;" id="totalGST">
                </td>
            </tr>
             <!--<tr>
                <td colspan="12">
                </td>
            </tr>-->
            
        </tbody>
    </table>    
    <table class="table" style="font-size:11px;">
        <tr>
                <td colspan="4" rowspan="3" style="border: none;">
                <br>For Approval Rs. <span id="approvalSubtottal"></span>
                <br>Recommended  for HLC Commission
               <br> <br> <br>  <br><b>Regional manager (RBO)</b>
                </td>
                <td colspan="4" style="border: none;">
                  <br>  For Approval Rs <span id="approvalSubtottal2"></span> recommended
<br><br><br><br><br><b>Manager/Chief Manager</b> 
                </td>
                
                 
                        <td colspan="4" style="text-align:right;border: none;">
                            <div style="display: flex; align-items: center;">
                                <div style="text-align: center;">
                                    <img src="<?php echo base_url() ?>assets/site_img/Rubber_Stamp_MBPL_circle.png" style="height:100px;">
                                </div>
                                <div style="flex: 1; text-align: left; padding-left: 30px;">
                                    <br><b>For, Mortgagebuddy Private Limited<br>
                                    <img src="<?php echo base_url() ?>assets/site_img/Sign_bhushan.png" style="height:60px;"><br>
                                    Authorised Signatory</b>
                                </div>
                            </div>
                        </td>
                    
            </tr>
    </table>
                       
   <script>
   document.addEventListener("DOMContentLoaded", function() {
    var table = document.getElementById("gstTable");
    var total = 0;

    // Check if the table exists
    if (table) {
        // Loop through each row in the table
        for (var i = 0; i < table.rows.length; i++) {
            // Get the elements with the class "tot_amount1"
            var elements = table.rows[i].getElementsByClassName("tot_amount1");
            
            // Check if elements with the class "tot_amount1" exist in the current row
            if (elements.length > 0) {
                // Get the span element inside the cell
                var spanElement = elements[0].getElementsByTagName("span")[0];
                
                // Check if the span element exists
                if (spanElement) {
                    // Get the value from the span element
                    var cellValue = parseFloat(spanElement.textContent.replace(/,/g, '')); // Remove commas before parsing
                    
                    // Add the value to the total (if it's a valid number)
                    if (!isNaN(cellValue)) {
                        total += cellValue;
                    }
                }
            }
        }
    }

    // Display the total in the specified cell
    document.getElementById("totalAmount1").innerHTML = '<b>' + total.toLocaleString('en-US', {minimumFractionDigits: 2}) + '</b>';
    document.getElementById("totalAmount2").innerHTML = '<b>' + total.toLocaleString('en-US', {minimumFractionDigits: 2}) + '</b>';
    document.getElementById("cgst").innerHTML = '' + total.toLocaleString('en-US', {minimumFractionDigits: 2}) + '';
    document.getElementById("sgst").innerHTML = '' + total.toLocaleString('en-US', {minimumFractionDigits: 2}) + '';
  
    
});

document.addEventListener("DOMContentLoaded", function() {
    // Parse and remove formatting from totalAmount1
    var totalAmount1 = parseFloat(document.getElementById("totalAmount1").textContent.replace(/,/g, ''));
    // Parse and remove formatting from totalAmount2
    var totalAmount2 = parseFloat(document.getElementById("totalAmount2").textContent.replace(/,/g, ''));
    
    var totalAmount3 = parseFloat(document.getElementById("totalAmount3").textContent.replace(/,/g, ''));
    // Parse and remove formatting from cgst
    var cgst = parseFloat(document.getElementById("cgst").textContent.replace(/,/g, ''));
    // Parse and remove formatting from sgst
    var sgst = parseFloat(document.getElementById("sgst").textContent.replace(/,/g, ''));

    // Calculate the total GST
    var totalGST = cgst + sgst;

    // Display the total GST with number formatting
    document.getElementById("totalGST").innerHTML = '<b>' + totalGST.toLocaleString('en-US', {minimumFractionDigits: 2}) + '</b>';

    // Check if the values are valid numbers before proceeding with addition
    if (!isNaN(totalAmount1) && !isNaN(totalAmount2) && !isNaN(cgst) && !isNaN(sgst)) {
        // Perform addition
        var subtotal = <?= $tot90percent_commi + $totcommissionRR ?> + totalGST;

        // Format subtotal with comma separation
        var formattedSubtotal = formatIndianNumber(subtotal.toFixed(2));
        

        // Display the formatted subtotal in the specified element
        document.getElementById("subtotal").innerHTML = '<b>' + formattedSubtotal + '</b>';
        document.getElementById("approvalSubtottal").innerHTML = '' + formattedSubtotal + '';
        document.getElementById("approvalSubtottal2").innerHTML = '' + formattedSubtotal + '';
        
        var numword = getIndianCurrency(subtotal)
    
        document.getElementById("numtoword").innerHTML = 'In Word: ' + numword + '';
        
    }
});

function formatIndianNumber(number) {
    // Round up the number to two decimal places
    var roundedNumber = Math.round(number * 100) / 100;

    // Convert the rounded number to string
    var numberStr = roundedNumber.toString();

    // Split the number into integral and fractional parts
    var parts = numberStr.split('.');

    // Format the integral part
    var integralPart = parts[0];
    var formattedIntegral = '';

    // Format the integral part with commas after every two digits if the number has six or more digits
    var len = integralPart.length;
    var i = len - 1;
    var count = 0;
    while (i >= 0) {
        formattedIntegral = integralPart[i] + formattedIntegral;
        count++;
        if ((count === 3 || count === 5 || count === 7) && i !== 0) {
            formattedIntegral = ',' + formattedIntegral;
        }
        i--;
    }

    // Format the fractional part
    var formattedFractional = parts[1] ? '.' + parts[1].padEnd(2, '0') : '.00';

    // Combine the formatted integral part with the formatted fractional part
    var formattedNumber = formattedIntegral + formattedFractional;

    return formattedNumber;
}


function getIndianCurrency(number) {
    let words = {
        0: '', 1: 'One', 2: 'Two', 3: 'Three', 4: 'Four', 5: 'Five', 6: 'Six',
        7: 'Seven', 8: 'Eight', 9: 'Nine', 10: 'Ten', 11: 'Eleven', 12: 'Twelve',
        13: 'Thirteen', 14: 'Fourteen', 15: 'Fifteen', 16: 'Sixteen', 17: 'Seventeen',
        18: 'Eighteen', 19: 'Nineteen', 20: 'Twenty', 30: 'Thirty', 40: 'Forty',
        50: 'Fifty', 60: 'Sixty', 70: 'Seventy', 80: 'Eighty', 90: 'Ninety'
    };

    let numString = number.toString();

    // Splitting the integer and fractional parts
    let [integerPart, fractionalPart] = numString.split('.');

    // Converting integer part to words
    let integerWords = '';
    if (integerPart !== '0') {
        integerWords = convertToWords(integerPart);
    } else {
        integerWords = 'Zero';
    }

    // Converting fractional part to words
    let fractionalWords = '';
    if (fractionalPart !== undefined) {
        fractionalWords = `${words[parseInt(fractionalPart[0])] || ''} ${words[parseInt(fractionalPart[1])] || ''} Paise`;
    }

    // Constructing the output string
    let output = `${integerWords} Rupees`;
    if (fractionalPart !== undefined) {
        output += ` and ${fractionalWords}`;
    }

    return output;
}

function convertToWords(number) {
    let words = '';
    let ones = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
    let tens = ['', '', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
    let teens = ['Ten', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
    let num = parseInt(number);

    if (num === 0) {
        return 'Zero';
    }

    if (num >= 10000000) {
        words += convertToWords(Math.floor(num / 10000000)) + ' Crore ';
        num %= 10000000;
    }

    if (num >= 100000) {
        words += convertToWords(Math.floor(num / 100000)) + ' Lakh ';
        num %= 100000;
    }

    if (num >= 1000) {
        words += convertToWords(Math.floor(num / 1000)) + ' Thousand ';
        num %= 1000;
    }

    if (num >= 100) {
        words += ones[Math.floor(num / 100)] + ' Hundred ';
        num %= 100;
    }

    if (num >= 20) {
        words += tens[Math.floor(num / 10)] + ' ';
        num %= 10;
    }

    if (num >= 10) {
        words += teens[num - 10] + ' ';
        num = 0;
    }

    if (num > 0) {
        words += ones[num] + ' ';
    }

    return words.trim();
}


   </script>  
   
   
<!-------------------------HLC BILL-------------------------------------->       
<br>
 <style>
        .new-page {
            page-break-before: always; /* or page-break-after: always; */
        }
    </style>
     <div class="new-page"></div>
                <table class="table table-invoice table-bordered" style="font-size:11px !important;">
                  <thead>
                <tr>
                    <td colspan="12" style="font-size:16px;background-color:rgb(217, 225, 242);border-bottom:0.5pt solid windowtext;border-left:0.5pt solid windowtext;border-right-style:block;border-top:0.5pt solid windowtext;height:18.0pt;padding:3px;text-align:center;width:100%;">
                        <span style="color:black;"><strong>HLC BILL</strong></span>
                    </td>
               </tr>
               <tr>
                <td colspan="3" style="width: 30%;">
                         <p><strong>Name of HLC: MortgageBuddy Private Limited</strong></p>
                       
                       ADDRESS: Office No H 218, 2nd Floor, Tower No 3, Belapur Station Complex, CBD Belapur, Navi Mumbai - 400614, Maharashtra
                        
                </td>
               
                 <td colspan="4" rowspan="2" style="border-bottom: hidden;">
                       <center><img src="https://www.mortgagebuddy.in/myimg/logofinal.png" style="height:50px;"></center>
                        <center style="margin-top: 14px;"><span><strong>CORPORATE CHANNEL PARTNER OF SBI</strong></span></center>
                </td>
                <td colspan="5" rowspan="6">
                    <div style="margin-bottom: 16px !important;">
                    <strong>TO</strong>
                    <br><strong>STATE BANK OF INDIA</strong>
                    <br>
                        <b>City - <?= @$city->city_name; ?>, State-<?= @$state->state_name; ?></b>
                    <br>
                        <b>GSTIN NO - 27AAACS8577K2ZO</b>
                    <br>
                        <b>RBO -</b>
                  
                     </div>
                        <strong>Invoice No : <?= $invoice_num; ?></strong>
                        <br>
                        <strong>Invoice Date : <?= date('d-m-Y',strtotime($invoice_date))?></strong>
                    
                </td>
            </tr>
            <tr>
                <td colspan="3" rowspan="6">
                  
                      HLC Code -MUMHLC03147
                     <br>GSTIN NO -27AAQCM2355K1ZZ
                     <br>PAN NO- AAQCM2355K
                     <br>Bank Account No : 41326113534
                  
                </td>
            </tr>
           
            <tr>
                <td colspan="4">
                      Office No- 022 46082235
                    <br>
                        Mobile - 8830394993
                    <br>
                        Email - Accounts@mortgagebuddy.in
                   
                </td>
            </tr>
       
                   </thead>
                   <thead style="background: #d9e1f2;">
                      <tr>
                         <th class="text-center">Sr. No</th>
                         <th class="text-center" width="20%">LOS ID & RLMS<br>Name of Borrower</th>
                         <th class="text-center" width="10%">Branch</th>
                         <th class="text-center" width="10%">CBS A/c.</th>
                         <th class="text-center" width="10%">Type of Loan</th>
                         <th class="text-center" width="5%">Date of Disb</th>
                         <th class="text-center" width="6%">Loan Amount</th>
                         <th class="text-center" width="5%">Slab</th>
                         <th class="text-center" width="6%">Comm<br> %</th>
                         <th class="text-center" width="7%">Total<br>Comm</th>
                         <th class="text-center" width="7%">10% <br>Hold</th>
                         <th class="text-center" width="10%">Comm to be  <br>paid (90%)</th>
                        
                      </tr>
                   </thead>
                   <tbody>
                   <?php
                     if (!empty($invoice_items)) {
                        $totalLoanAmt = 0;
                        $totalCommisionAmt = 0;
                        $tot10percent_commi = 0;
                        $tot90percent_commi = 0;
                        $totcommissionRR = 0;

                        foreach ($invoice_items as $key => $row) { 
                            $user_data = $this->db->select("*")->from('mst_user')->where(['id' =>$row['user_id']])->get()->row();
                            $user_branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();
                            $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' =>$user_data->loan_type_id])->get()->row();
                            $totalLoanAmt += $row['loan_amt'];
                            $totalCommisionAmt += $row['total_commission'];
                            $tot10percent_commi += $row['10percent_commi'];
                            $tot90percent_commi += $row['90percent_commi'];
                            $totcommissionRR += $row['rr_fix_commi'];
                           
                           $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $row['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
                           ?>
                      <tr>
                         <td>                           
                         <?= $key + 1 ?>
                         </td>
                         <td style="text-align:left;"><?= $user_data->los_id; ?><br><span class="text-inverse"><?= $user_data->user_name; ?></span></td>
                         <td style="text-align:left;"><?= $user_branch->branch_name; ?><br>(<?= $user_branch->branch_code; ?>) </td>                         
                          <td style="text-align:center;">
                             <?php if($row['loan_type_id']==5){ ?>
                              <span class="text-inverse"><?= $user_data->rr_cbs_acct_no; ?></span>
                              <?php } else{ ?>
                              <span class="text-inverse"><?= $user_data->bank_acct_no; ?></span>
                              <?php } ?>
                         </td>
                         <td>
                            <span class="text-inverse"><?= $type_data->name; ?></span>
                         </td>
                         
                         <td>
                            <span class="text-inverse"><?= date('d.m.Y',strtotime($user_data->disb_date)); ?></span>
                         </td>
                         <td>
                            <span class="text-inverse"><?= formatIndianNumber($row['loan_amt']); ?></span>
                         </td>                        
                                            
                         <td>
                            <span class="text-inverse"><?= $user_data->commi_slab; ?></span>
                         </td>
                         <td>
                            <span class="text-inverse"><?= $user_data->sbi_commi; ?>%</span>
                         </td>
                         
                         <td>
                            <span class="text-inverse"><?= formatIndianNumber($row['total_commission']) ?></span>
                         </td>
                         
                          <td>
                            <span class="text-inverse"><?= formatIndianNumber($row['10percent_commi']) ?></span>
                         </td>
                         
                         <td>
                            <span class="text-inverse"><?= formatIndianNumber($row['90percent_commi']) ?></span>
                         </td>
                         
                       
                        
                    <?php if($row['loan_type_id']==5){ ?>
                       <tr>
                           
                           <td></td>
                           <td style="text-align:left;"><?= $user_data->los_id; ?><br><span class="text-inverse"><?= $user_data->user_name; ?></span></td>
                           <td style="text-align:left;"><?= $user_branch->branch_name; ?><br>(<?= $user_branch->branch_code; ?>) </td> 
                            <td style="text-align:center;">
                             <?php if($row['loan_type_id']==5){ ?>
                              <?= $user_data->rr_cbs_acct_no; ?>
                              <?php } else{ ?>
                             <?= $user_data->bank_acct_no; ?>
                              <?php } ?>
                            </td>
                           <td>RR Commission</td>
                           <td></td> 
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <td></td>
                           <?php
                                    if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) { 
                                        // Calculate commission based on different conditions
                                        @$rr_sanction_amt = $this->db->select("*")->where(['id' => $rr_aact->id])->from('mst_user')->get()->row();
                                        $sanctionAmt = @$rr_sanction_amt->sanction_amt;
                                        $premiumAmt = $user_data->rinnraksha_amt;
                                        $premiumCommission = $premiumAmt * $row['conn_commision_set'];
                                        
                                        if ($sanctionAmt >= 100000 && $sanctionAmt < 5000000) {
                                            $commission = 4000;
                                        } elseif ($sanctionAmt >= 5000000 && $sanctionAmt < 10000000) {
                                            $commission = 5000;
                                        } elseif ($sanctionAmt >= 10000000) {
                                            $commission = 6000;
                                        }
                                        // Output the commission
                                        echo '<td><span class="text-inverse">' . formatIndianNumber($commission) . '</span></td>';
                                    } else {
                                        // If condition fails, default to total commission
                                        echo '<td><span class="text-inverse">' .  formatIndianNumber($row['total_commission']) . '</span></td>';
                                    }
                                    ?>
                           
                     </tr>
                     <?php } ?> 
                      </tr>
                   <?php  }

                  } ?>   
                 
                 
                   
                     
                      <tr>
                        <?php $total90per = $tot90percent_commi+$totcommissionRR; 
                        $netPay = $total90per+$total90per * 18 / 100;
                        ?>
                        
                           <td colspan="7" rowspan="3"> <strong>In Word : <?= @getIndianCurrency($netPay); ?></strong></td>
                           <td colspan="2" style="text-align:right;"><b>Sub Total</b></td>
                           <td><b><?= formatIndianNumber($totalCommisionAmt); ?></b></td>
                           <td><b><?= formatIndianNumber($tot10percent_commi); ?></b></td>
                           <td><b><?= formatIndianNumber($total90per); ?></b></td>
                         
                     </tr>
                     
                     <tr>
                           <td colspan="2" style="text-align:right;"><b>Tax Amount Rs</b></td>
                           <td><b>CGST 9% <br><?= formatIndianNumber($total90per * 9 /100) ?></b></td>
                           <td><b>SGST 9% <br><?= formatIndianNumber($total90per * 9 /100) ?></b></td>
                           <td><b>IGST 18%<br>-</b></td>
                     </tr>
                     
                  
                     <tr>
                           <td colspan="3" style="text-align:right;"><b>TOTAL PAYABLE</b></td>
                           <td colspan="9" style="text-align:right;"><b><?= formatIndianNumber($total90per+$total90per * 18 / 100) ?></b></td>
                     </tr>
                     
                   </tbody>
                </table>
               
               <table class="table" style="font-size:11px;">
        <tr>
                <td colspan="4" rowspan="3" style="border: none;">
                <br>For Approval Rs. <?= formatIndianNumber($netPay); ?>
                <br>Recommended  for HLC Commission
               <br> <br> <br>  <br><b>Regional manager (RBO)</b>
                </td>
                <td colspan="4" style="border: none;">
                  <br>  For Approval Rs <?= formatIndianNumber($netPay); ?> recommended
<br><br><br><br><br><b>Manager/Chief Manager</b> 
                </td>
                
                 
                        <td colspan="4" style="text-align:right;border: none;">
                            <div style="display: flex; align-items: center;">
                                <div style="text-align: center;">
                                    <img src="<?php echo base_url() ?>assets/site_img/Rubber_Stamp_MBPL_circle.png" style="height:100px;">
                                </div>
                                <div style="flex: 1; text-align: left; padding-left: 30px;">
                                    <br><b>For, Mortgagebuddy Private Limited<br>
                                    <img src="<?php echo base_url() ?>assets/site_img/Sign_bhushan.png" style="height:60px;"><br>
                                    Authorised Signatory</b>
                                </div>
                            </div>
                        </td>
                    
            </tr>
    </table>
             </div>
             </div>

       
             
             </div>
      </main>
  </div>
  <!--end wrapper-->
 

  <script defer>
  function printInvoice() {
    var printContent = document.getElementById('invoice').outerHTML;
    var printWindow = window.open('', '_blank');
    
    // Include Bootstrap CSS
    printWindow.document.write('<link href="https://www.mortgagebuddy.in/online/admin_assets/css/bootstrap.min.css" rel="stylesheet">');
    printWindow.document.write('<link href="https://www.mortgagebuddy.in/online/admin_assets/css/style.css" rel="stylesheet">');
    printWindow.document.write('<link href="https://www.mortgagebuddy.in/online/admin_assets/css/invoice_style.css" rel="stylesheet">');
  
    
    printWindow.document.write(printContent);
   
  
    printWindow.document.close();
    printWindow.print();
    printWindow.onafterprint = function() {
      printWindow.close();
    };
  }
  
  
   function parseIndianNumber(numStr) {
            return parseFloat(numStr.replace(/,/g, ''));
        }

        function calculateTotals() {
            const rows = document.querySelectorAll('.invoice-row');
            rows.forEach(row => {
                const taxableValue = parseIndianNumber(row.querySelector('.taxable-value').textContent);
                const cgstAmount = parseIndianNumber(row.querySelector('.cgst-amount').textContent);
                const sgstAmount = parseIndianNumber(row.querySelector('.sgst-amount').textContent);
                //const igstAmount = parseIndianNumber(row.querySelector('.igst-amount').textContent);

                const totalAmount = taxableValue + cgstAmount + sgstAmount;
                row.querySelector('.total-amount').textContent = formatIndianNumber(totalAmount);
            });
        }

        document.addEventListener('DOMContentLoaded', calculateTotals);
</script>
<!-- Add these script tags in the head section -->
<style>
   .table-invoice th{
    font-size: 13px !important;
 }
 table {
      width: 100%;
      max-width: 100%;     
      }
      th, td {
          border: 1px solid black;
         
      }
</style>