<main class="page-content">
    <!-- Breadcrumb -->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= htmlspecialchars($title) ?></div>
    </div>
    <!-- End Breadcrumb -->

    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3"></div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
    <table class="table align-middle table-striped" id="Table">
    <thead>
        <tr>
            <th>Sr. No</th>
            <th>User Name</th>
            <th>Appraisal Letter 1</th>
            <th>Appraisal Letter 2</th>
            <th>Proof Disb</th>
            <th>Uploaded By</th>
            <th>Add Date</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($activity_logs)) : 
            $sr_no = 1;
            foreach ($activity_logs as $log) : 
                $appraisel_letter1 = !empty($log['appraisal_letter']) ? 
                        ' <a href="' . base_url('assets/uploads/documents/' . $log['appraisal_letter']) . '" target="_blank">View</a>' : 'N/A'; 
                $apprisal_letter_two = !empty($log['apprisal_letter_two']) ? 
                        ' <a href="' . base_url('assets/uploads/documents/' . $log['apprisal_letter_two']) . '" target="_blank">View</a>' : 'N/A'; 
                $proof_disb = !empty($log['proof_disb']) ? 
                        ' <a href="' . base_url('assets/uploads/documents/' . $log['proof_disb']) . '" target="_blank">View</a>' : 'N/A'; 
            ?>
                <tr>
                    <td><?= $sr_no++ ?></td>
                    <td><?= htmlspecialchars($log['user_name'] ?? 'N/A') ?></td>
                   <td><?= htmlspecialchars($log['appraisal_letter'] ?? ''); echo $appraisel_letter1; ?> </td>
                    <td><?= htmlspecialchars($log['apprisal_letter_two'] ?? ''); echo $apprisal_letter_two; ?></td>
                    <td><?= htmlspecialchars($log['proof_disb'] ?? ''); echo $proof_disb; ?></td>
                      <td><?= htmlspecialchars($log['staff_fullname'] ?? 'N/A') ?></td>
                    <td><?= date('F d, Y h:i A', strtotime($log['add_date'])) ?></td>
                </tr>
            <?php endforeach;
        else : ?>
            <tr>
                <td colspan="8" align="center">No activity logs available!</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>


            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "lengthChange": true,
        "searching": true,
        "lengthMenu": [[10, 25, 50, 200, -1], [10, 25, 50, 200, "All"]],
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Document Activity Log');
                }
            },
            { extend: 'colvis', text: 'Column Visibility' }
        ]
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
});
</script>