<style>
  /* Base wrapper (desktop) */
  .actions-wrapper {
    display: flex;
    flex-direction: row;
    align-items: center;
    gap: 12px;
    width: 900px;
    height: 70px;
    margin: 100px auto 0 auto; /* horizontally centered */
    padding: 0 12px;
    box-sizing: border-box;
    flex-wrap: nowrap;
  }

  /* Make wrapper fluid but constrain max width on large screens */
  @media (max-width: 1380px) {
    .actions-wrapper { width: calc(100% - 48px); max-width: 1246px; }
  }

  /* Main button (Figma) */
  .figma-btn {
    display: flex;
    flex-direction: column;
    align-items: flex-start;

    /* Use fluid width but respect Figma max */
    width: 302.5px;
    max-width: 312.5px;
    min-width: 0;
    height: 70px;
    min-height: 70px;

    padding: 24px;
    gap: 12px;

    background:linear-gradient(90.6deg, #F8DC8F 0.52%, #F6C960 99.68%);
    box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.2);
    border-radius: 4px;

    color: #fff;
    text-decoration: none;
    cursor: pointer;

    position: relative;
    transition: transform 0.18s ease, box-shadow 0.18s ease;
    box-sizing: border-box;
  }

  .figma-btn:hover,
  .figma-btn:focus {
    transform: translateY(-2px);
    box-shadow: 0px 6px 14px rgba(0,0,0,0.25);
    outline: none;
  }

  /* Inner row */
  .figma-btn-row {
    display: flex;
    flex-direction: row;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    height: 22px;
  }

  .figma-btn-text {
    display: flex;
    flex-direction: row;
    align-items: center;
    gap: 8px;
  }

  .figma-btn-label {
    font-family: Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
    font-size: 16px;
    font-weight: 500;
    line-height: 20px;
    color: #0a5ca8;
    display: inline-block;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  .figma-btn-icon-box {
    width: 22px;
    height: 22px;
    background: rgba(255,255,255,0.3);
    border-radius: 4px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
  }

  .figma-btn-plus {
   
    height: 16px;
    color: #0a5ca8;
    font-size: 18px;
    line-height: 1;
    font-weight: 700;
    display: inline-block;
    transform: translateY(-1px);
  }

  /* -------- Responsive rules -------- */

  /* Tablet: allow wrapping (two per row if space) */
  @media (max-width: 992px) {
    .actions-wrapper {
      flex-wrap: wrap;
      justify-content: center;
      gap: 16px;
      height: auto;
      margin-top: 48px;
      padding: 12px;
    }

    .figma-btn {
      /* allow multiple per row — use percentage basis so two per row */
      width: calc(50% - 20px);
      max-width: 312.5px;
      min-width: 220px;
      padding: 20px;
      height: 70px;
      min-height: 70px;
    }

    /* On narrow tablets, clamp width to 100% */
    @media (max-width: 720px) {
      .figma-btn { width: calc(100% - 24px); min-width: 0; max-width: 312.5px; }
    }
  }

  /* Mobile: stack buttons vertically and make full-width inside page padding */
  @media (max-width: 480px) {
    .actions-wrapper {
      flex-direction: column;
      align-items: center;
      gap: 12px;
      width: 100%;
      padding: 16px;
      margin: 24px auto;
      margin-top: 80px;
    }

    .figma-btn {
      width: 100%;
      max-width: 420px; /* limit so it doesn't touch the screen edge on big phones */
      min-width: 0;
      padding: 16px;          /* reduced padding for small screens */
      height: 64px;
      min-height: 64px;
      border-radius: 4px;
      gap: 8px;
    }

    .figma-btn-label {
      font-size: 15px;
      line-height: 18px;
    }

    .figma-btn-plus {
      font-size: 18px;
    }

    .figma-btn-icon-box { width: 26px; height: 26px; border-radius: 4px; }
  }

  /* Accessibility focus visible */
  .figma-btn:focus-visible {
    box-shadow: 0 0 0 3px rgba(202,164,63,0.25);
  }
</style>



    <div class="actions-wrapper">

        <a href="<?= base_url('admin/pb_user_form') ?>" target="_blank" class="figma-btn">
            <div class="figma-btn-row">
                <div class="figma-btn-text">
                    <span class="figma-btn-label">Add Applicant</span>
                </div>
                <div class="figma-btn-icon-box">
                    <span class="figma-btn-plus">+</span>
                </div>
            </div>
        </a>

        <a href="<?= base_url('admin/pending_rr_form') ?>" target="_blank" class="figma-btn">
            <div class="figma-btn-row">
                <div class="figma-btn-text">
                    <span class="figma-btn-label">Add Pending RR</span>
                </div>
                <div class="figma-btn-icon-box">
                    <span class="figma-btn-plus">+</span>
                </div>
            </div>
        </a>

        <?php if(in_array('Add Partner', $this->menu_permission)): ?>
            <a href="<?= base_url('admin/connectors_form') ?>" target="_blank" class="figma-btn">
                <div class="figma-btn-row">
                    <div class="figma-btn-text">
                        <span class="figma-btn-label">Add Partner</span>
                    </div>
                    <div class="figma-btn-icon-box">
                        <span class="figma-btn-plus">+</span>
                    </div>
                </div>
            </a>
        <?php endif; ?>

        <?php if(in_array('Query', $this->menu_permission)): ?>
            <a href="<?= base_url('admin/manage_query') ?>" target="_blank" class="figma-btn">
                <div class="figma-btn-row">
                    <div class="figma-btn-text">
                        <span class="figma-btn-label">Check Applicant</span>
                    </div>
                    <div class="figma-btn-icon-box">
                        <span class="figma-btn-plus">+</span>
                    </div>
                </div>
            </a>
        <?php endif; ?>

    </div>


<main class="page-content1">
    
              <div class="d-none d-md-block">
                <div class="card-body">
                  <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
                    <ol class="carousel-indicators">
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0" class="active" style="background-color: #0a5ca8;"></li>
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1" style="background-color: #0a5ca8;"></li>
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="2" style="background-color: #0a5ca8;"></li>
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="3" style="background-color: #0a5ca8;"></li>
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="4" style="background-color: #0a5ca8;"></li>
                    </ol>
                    <div class="carousel-inner">
                      <div class="carousel-item active">
                        <img src="admin_assets/uploads/desk_slider/MORTAGE BUDDY PC_page-0001.jpg" class="d-block w-100" alt="...">
                      </div>
                      <div class="carousel-item">
                        <img src="admin_assets/uploads/desk_slider/MORTAGE BUDDY PC_page-0002.jpg" class="d-block w-100" alt="...">
                      </div>
                      <div class="carousel-item">
                        <img src="admin_assets/uploads/desk_slider/MORTAGE BUDDY PC_page-0003.jpg" class="d-block w-100" alt="...">
                      </div>
                      <div class="carousel-item">
                        <img src="admin_assets/uploads/desk_slider/MORTAGE BUDDY PC_page-0004.jpg" class="d-block w-100" alt="...">
                      </div>
                      <div class="carousel-item">
                        <img src="admin_assets/uploads/desk_slider/MORTAGE BUDDY PC_page-0005.jpg" class="d-block w-100" alt="...">
                      </div>
                    </div>
                    <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-bs-slide="prev">	<span class="carousel-control-prev-icon" aria-hidden="true"></span>
                      <span class="visually-hidden">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-bs-slide="next">	<span class="carousel-control-next-icon" aria-hidden="true"></span>
                      <span class="visually-hidden">Next</span>
                    </a>
                  </div>
                </div>
              </div>
      </main>          
              
              <div class="d-block d-md-none">
                <div class="card-body">
                  <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
                   <!-- <ol class="carousel-indicators">
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0" class="active" style="background-color: #0a5ca8;"></li>
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1" style="background-color: #0a5ca8;"></li>
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="2" style="background-color: #0a5ca8;"></li>
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="3" style="background-color: #0a5ca8;"></li>
                      <li data-bs-target="#carouselExampleIndicators" data-bs-slide-to="4" style="background-color: #0a5ca8;"></li>
                    </ol>-->
                    <div class="carousel-inner">
                      <div class="carousel-item active">
                        <img src="admin_assets/uploads/mob_slider/MORTAGE BUDDY MOBILE_page-0001.jpg" class="d-block w-100" alt="...">
                      </div>
                      <div class="carousel-item">
                        <img src="admin_assets/uploads/mob_slider/MORTAGE BUDDY MOBILE_page-0002.jpg" class="d-block w-100" alt="...">
                      </div>
                      <div class="carousel-item">
                        <img src="admin_assets/uploads/mob_slider/MORTAGE BUDDY MOBILE_page-0003.jpg" class="d-block w-100" alt="...">
                      </div>
                      <div class="carousel-item">
                        <img src="admin_assets/uploads/mob_slider/MORTAGE BUDDY MOBILE_page-0004.jpg" class="d-block w-100" alt="...">
                      </div>
                     <div class="carousel-item">
                        <img src="admin_assets/uploads/mob_slider/MORTAGE BUDDY MOBILE_page-0005.jpg" class="d-block w-100" alt="...">
                      </div>
                    </div>
                    <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-bs-slide="prev">	<span class="carousel-control-prev-icon" aria-hidden="true"></span>
                      <span class="visually-hidden">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-bs-slide="next">	<span class="carousel-control-next-icon" aria-hidden="true"></span>
                      <span class="visually-hidden">Next</span>
                    </a>
                  </div>
                </div>
              </div>
      
 <!--<div class="welcome-section">
    <div class="banner">
        <h1>Welcome to <span>Mortgagebuddy Online Portal</span></h1>
        <p>Your one-stop solution for all mortgage needs!</p>
    </div>
</div>-->
<style>
    .page-content1 {
    margin-left: 246px;
    margin-top: 20px;
    /* padding: 1.5rem; */
    transition: all .2s;
}
</style>



<!-- Modal -->
<div class="modal fade" id="applicantFormModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="applicantFormModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="applicantFormModalLabel">Select Login Code</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formSelection" class="d-flex justify-content-around">
          <div class="form-check custom-card">
            <input class="form-check-input" type="radio" name="formType" id="paisabazar" value="PaisaBazaar" required>
            <label class="form-check-label custom-label" for="paisabazar">
             PaisaBazaar
            </label>
          </div>
          <div class="form-check custom-card">
            <input class="form-check-input" type="radio" name="formType" id="mortgagebuddy" value="Mortgagebuddy" required>
            <label class="form-check-label custom-label" for="mortgagebuddy">
              Mortgagebuddy
            </label>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        
        <button type="button" class="btn btn-primary" id="redirectBtn">Proceed</button>
      </div>
    </div>
  </div>
</div>

<script>
document.getElementById('redirectBtn').addEventListener('click', function() {
    // Get the selected radio button
    var selectedRadio = document.querySelector('input[name="formType"]:checked');
    
    // Check if any radio button is selected
    if (selectedRadio) {
        var selectedFormType = selectedRadio.value;

        // Create a hidden form element
        var form = document.createElement('form');
        form.method = 'POST';

        // Set form action URL based on the selected option
        if (selectedFormType === 'PaisaBazaar') {
            form.action = "<?php echo base_url('admin/pb_user_form'); ?>";  // Redirect to PaisaBazaar form
        } else if (selectedFormType === 'Mortgagebuddy') {
            form.action = "<?php echo base_url('admin/applicant_form'); ?>";  // Redirect to Mortgagebuddy form
        }

        // Create a hidden input field for the selected form type
        var input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'selectedFormType';
        input.value = selectedFormType;

        // Append the input to the form and submit it
        form.appendChild(input);
        document.body.appendChild(form);
        form.submit();
    } else {
        alert('Please select a Login Code.');
    }
});

// Handle modal close event to unselect radio buttons
$('#applicantFormModal').on('hide.bs.modal', function () {
    // Unselect any selected radio button
    var selectedRadio = document.querySelector('input[name="formType"]:checked');
    if (selectedRadio) {
        selectedRadio.checked = false;
    }
    
    // Optionally reset the form if you have more fields
    document.getElementById('formSelection').reset();
});

</script>
        
