<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class RBOInvoice_model extends CI_Model {
    
     public function __construct() {
        parent::__construct();
        
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
        
    }

    public function get_filtered_invoices($start, $length, $order, $search, $start_date, $end_date, $branch, $connector, $sbi_paid_status, $state_id, $city_id, $month, $payment_amount, $payment_date, $invoice_month) {
    $this->db->select('invoices.*, mst_user.disb_date, mst_user.user_name, mst_staff.staff_fullname, branch.branch_name, mst_city.city_name, mst_rbo.rbo_name');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
    $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
    $this->db->join('mst_staff as created', 'invoices.created_by = created.staff_id');
    $this->db->join('branch', 'invoices.branch_id = branch.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id');
    $this->db->where('invoices.invoice_type', 'inv_sbi');

    // Apply search filter
    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_user.user_name', $search);
        $this->db->or_like('invoices.invoice_number', $search);
        $this->db->or_like('mst_city.city_name', $search);
        $this->db->or_like('mst_rbo.rbo_name', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search); // Search by connector staff name
        $this->db->or_like('created.staff_fullname', $search); 
        $this->db->group_end();
    }

    // Apply additional filters from the form
    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where('invoices.add_date >=', $start_date);
        $this->db->where('invoices.add_date <=', $end_date);
    } else if (!empty($start_date)) {
        $this->db->where('invoices.add_date >=', $start_date);
    } else if (!empty($end_date)) {
        $this->db->where('invoices.add_date <=', $end_date);
    }
    
    if (!empty($branch)) {
        $this->db->where('invoices.branch_id', $branch);
    }
    if (!empty($connector)) {
        $this->db->where('invoices.connector_id', $connector);
    }
  /* if (!empty($sbi_paid_status)) {
        if ($sbi_paid_status === 'unpaid') {
            $this->db->where('invoices.sbi_status', NULL);
        } else {
            $this->db->where('invoices.sbi_status', $sbi_paid_status);            
        }
    }*/
    
    if (!empty($sbi_paid_status)) {
        $sbi_paid_status = (array)$sbi_paid_status;
    
        $this->db->group_start();
    
        if (in_array('unpaid', $sbi_paid_status)) {
            $this->db->or_where('invoices.sbi_status IS NULL', null, false);
        }
    
        $other_statuses = array_diff($sbi_paid_status, ['unpaid']);
    
        if (!empty($other_statuses)) {
            $this->db->or_where_in('invoices.sbi_status', $other_statuses);
        }
    
        $this->db->group_end();
    }

    
    if (!empty($state_id)) {
        $this->db->where('branch.state_id', $state_id);
    }
   /* if (!empty($city_id)) {
        $this->db->where('branch.city_id', $city_id);
    }*/
      if (!empty($city_id)) {
        if (!is_array($city_id)) {
            $city_id = [$city_id];
        }
        $this->db->where_in('branch.city_id', $city_id);
    }
    if (!empty($month)) {
        list($year, $month) = explode('-', $month);
        $this->db->where('YEAR(mst_user.disb_date)', $year);
        $this->db->where('MONTH(mst_user.disb_date)', $month);
    }
    if (!empty($invoice_month)) {
        list($year, $invoice_month) = explode('-', $invoice_month);
        $this->db->where('YEAR(invoices.invoice_date)', $year);
        $this->db->where('MONTH(invoices.invoice_date)', $invoice_month);
    }

    // Apply ordering safely
    $columns = ['invoices.add_date', 'mst_city.city_name', 'mst_rbo.rbo_name', 'mst_user.user_name', 'invoices.invoice_number'];
    if (!empty($order) && isset($order[0]['column'], $order[0]['dir']) && array_key_exists($order[0]['column'], $columns)) {
        $this->db->order_by($columns[$order[0]['column']], $order[0]['dir']);
    } else {
        $this->db->order_by('invoices.add_date', 'DESC');
    }

    // Apply limit and offset for pagination
    if ($length != -1) {
        $this->db->limit($length, $start);
    }
    
     if (!empty($payment_amount)) {
    $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');
    $this->db->where('invoice_log.pay_amt', $payment_amount);
    }
    if (!empty($payment_date)) {
        $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');
        $this->db->where('DATE(invoice_log.payment_date)', $payment_date);
    }

     $this->db->group_by('invoices.inv_batchno');
    
    $query = $this->db->get();
    return $query->result();
}



public function get_total_invoices($start_date, $end_date, $branch, $connector, $sbi_paid_status, $state_id, $city_id, $month, $payment_amount, $payment_date,$invoice_month, $search = '') {
    $this->db->select('invoices.inv_batchno, invoices.invoice_date, mst_user.disb_date, mst_user.user_name, mst_staff.staff_fullname, branch.branch_name, mst_city.city_name, mst_rbo.rbo_name');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
    $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
    $this->db->join('mst_staff as created', 'invoices.created_by = created.staff_id'); // Use alias 'created' for clarity
    $this->db->join('branch', 'invoices.branch_id = branch.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id');
    $this->db->where('invoices.invoice_type', 'inv_sbi');

    // Apply search filter
    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_user.user_name', $search);
        $this->db->or_like('invoices.invoice_number', $search);
        $this->db->or_like('mst_city.city_name', $search);
        $this->db->or_like('mst_rbo.rbo_name', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search); // Search by connector staff name
        $this->db->or_like('created.staff_fullname', $search);  // Search by created_by staff name
        $this->db->group_end();
    }

    // Apply additional filters from the form
    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where('invoices.add_date >=', $start_date);
        $this->db->where('invoices.add_date <=', $end_date);
    } elseif (!empty($start_date)) {
        $this->db->where('invoices.add_date >=', $start_date);
    } elseif (!empty($end_date)) {
        $this->db->where('invoices.add_date <=', $end_date);
    }

    if (!empty($branch)) {
        $this->db->where('invoices.branch_id', $branch);
    }

    if (!empty($connector)) {
        $this->db->where('invoices.connector_id', $connector);
    }

 /*   if (!empty($sbi_paid_status)) {
        if ($sbi_paid_status === 'unpaid') {
            $this->db->where('invoices.sbi_status', NULL);
        } else {
            $this->db->where('invoices.sbi_status', $sbi_paid_status);            
        }
    }*/
    
    if (!empty($sbi_paid_status)) {
        $sbi_paid_status = (array)$sbi_paid_status;
    
        $this->db->group_start();
    
        if (in_array('unpaid', $sbi_paid_status)) {
            $this->db->or_where('invoices.sbi_status IS NULL', null, false);
        }
    
        $other_statuses = array_diff($sbi_paid_status, ['unpaid']);
    
        if (!empty($other_statuses)) {
            $this->db->or_where_in('invoices.sbi_status', $other_statuses);
        }
    
        $this->db->group_end();
    }


    if (!empty($state_id)) {
        $this->db->where('branch.state_id', $state_id);
    }

  /*  if (!empty($city_id)) {
        $this->db->where('branch.city_id', $city_id);
    }*/
    
      if (!empty($city_id)) {
        if (!is_array($city_id)) {
            $city_id = [$city_id];
        }
        $this->db->where_in('branch.city_id', $city_id);
    }

    if (!empty($month)) {
        list($year, $month) = explode('-', $month);
        $this->db->where('YEAR(mst_user.disb_date)', $year);
        $this->db->where('MONTH(mst_user.disb_date)', $month);
    }
    
    if (!empty($invoice_month)) {
        list($year, $invoice_month) = explode('-', $invoice_month);
        $this->db->where('YEAR(invoices.invoice_date)', $year);
        $this->db->where('MONTH(invoices.invoice_date)', $invoice_month);
    }
    
    
    if (!empty($payment_amount)) {
    $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');
    $this->db->where('invoice_log.pay_amt', $payment_amount);
}
if (!empty($payment_date)) {
    $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');
    $this->db->where('DATE(invoice_log.payment_date)', $payment_date);
}

    
   $this->db->group_by('invoices.inv_batchno');

    return $this->db->count_all_results();
}



}
