<?php

class Hlc_model extends CI_Model {

public function __construct() {
        parent::__construct();
       
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
        
    }


public function get_invoice_data($start_date, $end_date, $conn_id, $branch_id, $limit, $offset, $hlc_paid_status, $city_id, $disb_month_year, $payment_month_hlc, $search = '') {
    $this->db->select('
        invoices.inv_batchno,
        invoices.invoice_number,
        invoices.invoice_date,
        invoices.add_date,
        mst_user.connector_id,
        invoices.created_by,
        mst_user.disb_date,
        mst_user.user_name,
        mst_user.id as user_id,
        mst_staff.staff_fullname,
        mst_staff.staff_id as staff_id,
        branch.branch_name,
        branch.id as branch_id,
        mst_city.city_name as hlc_city_name,
        mst_city.id as hlc_city_id
    ');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('branch', 'mst_user.branch_id = branch.id');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');

    if (!empty($start_date)) {
        $this->db->where("invoices.add_date >=", $start_date);
    }
    if (!empty($end_date)) {
        $this->db->where("invoices.add_date <=", $end_date);
    }
   
    if (!empty($conn_id)) {
        $this->db->where('mst_user.connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('branch.id', $branch_id);
    }
    if (!empty($city_id)) {
        $this->db->where_in('branch.city_id', $city_id);
    }
    if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year);
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
         if (!empty($hlc_paid_status)) {
        $this->db->group_start(); // Start OR group
    
        if (in_array('unpaid', $hlc_paid_status)) {
            $this->db->or_where('mst_user.hlc_payment_status IS NULL', null, false);
            $this->db->where('mst_user.disb_status', 'yes'); // Apply only if globally required
        }
    
        // Filter out 'unpaid' and handle the rest
        $other_hlc_statuses = array_diff($hlc_paid_status, ['unpaid']);
    
        if (!empty($other_hlc_statuses)) {
            $this->db->or_where_in('mst_user.hlc_payment_status', $other_hlc_statuses);
        }
    
        $this->db->group_end(); // End OR group
    }
    /*if (!empty($hlc_paid_status)) {
        if ($hlc_paid_status === 'unpaid') {
            $this->db->where('invoices.hlc_status', NULL);
        } else {
            $this->db->where('invoices.hlc_status', $hlc_paid_status);
        }
    }*/
    $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
        
    
    if (!empty($payment_month_hlc)) {
    $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');

    // Assuming $payment_month_hlc is in 'YYYY-MM' format
    $date_parts = explode('-', $payment_month_hlc); // Split the input into year and month
    $year = $date_parts[0]; // Extract year
    $month = $date_parts[1]; // Extract month

    // Use MySQL MONTH() and YEAR() functions for filtering
    $this->db->where('YEAR(invoice_log.payment_date)', $year);
    $this->db->where('MONTH(invoice_log.payment_date)', $month);
    $this->db->order_by('invoice_log.payment_date', 'asc');
}

    
    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_user.user_name', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search);
        $this->db->or_like('branch.branch_name', $search);
        $this->db->or_like('invoices.invoice_number', $search);
        $this->db->group_end();
    }

    $this->db->where('invoices.invoice_type', 'inv_hlc');
    $this->db->group_by('invoices.inv_batchno');

    $this->db->order_by('invoices.add_date', 'DESC');


    if ($limit != '' && $limit != -1) {
        $this->db->limit($limit, $offset);
    }
    
    $query = $this->db->get();
    return $query->result_array();
}



public function count_all_invoices($start_date, $end_date, $conn_id, $branch_id, $hlc_paid_status, $city_id, $disb_month_year, $payment_month_hlc,$search = '') {
    $this->db->select('invoices.inv_batchno');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
    $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
    $this->db->join('branch', 'invoices.branch_id = branch.id');

    if (!empty($start_date)) {
        $this->db->where("invoices.add_date >=", $start_date);
    }
    if (!empty($end_date)) {
        $this->db->where("invoices.add_date <=", $end_date);
    }
    if (!empty($conn_id)) {
        $this->db->where('invoices.connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('invoices.branch_id', $branch_id);
    }
    if (!empty($city_id)) {
        $this->db->where_in('branch.city_id', $city_id);
    }
    if (!empty($disb_month_year) && strpos($disb_month_year, '-') !== false) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year);
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
         if (!empty($hlc_paid_status)) {
        $this->db->group_start(); // Start OR group
    
        if (in_array('unpaid', $hlc_paid_status)) {
            $this->db->or_where('mst_user.hlc_payment_status IS NULL', null, false);
            $this->db->where('mst_user.disb_status', 'yes'); // Apply only if globally required
        }
    
        // Filter out 'unpaid' and handle the rest
        $other_hlc_statuses = array_diff($hlc_paid_status, ['unpaid']);
    
        if (!empty($other_hlc_statuses)) {
            $this->db->or_where_in('mst_user.hlc_payment_status', $other_hlc_statuses);
        }
    
        $this->db->group_end(); // End OR group
    }
   /* if (!empty($hlc_paid_status)) {
        if ($hlc_paid_status === 'unpaid') {
            $this->db->where('invoices.hlc_status', NULL);
        } else {
            $this->db->where('invoices.hlc_status', $hlc_paid_status);
        }
    }*/
    $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
        
       if (!empty($payment_month_hlc)) {
        $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');
    
        // Assuming $payment_month_hlc is in 'YYYY-MM' format
        $date_parts = explode('-', $payment_month_hlc); // Split the input into year and month
        $year = $date_parts[0]; // Extract year
        $month = $date_parts[1]; // Extract month
    
        // Use MySQL MONTH() and YEAR() functions for filtering
        $this->db->where('YEAR(invoice_log.payment_date)', $year);
        $this->db->where('MONTH(invoice_log.payment_date)', $month);
    }

    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_user.user_name', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search);
        $this->db->or_like('branch.branch_name', $search);
        $this->db->or_like('invoices.invoice_number', $search);
        $this->db->group_end();
    }
    $this->db->where('invoices.invoice_type', 'inv_hlc');
    $this->db->group_by('invoices.inv_batchno');

    return $this->db->count_all_results();
}

public function get_payout_invoice_data($start_date, $end_date, $conn_id, $branch_id, $limit, $offset, $hlc_paid_status, $city_id, $disb_month_year, $payment_month_hlc, $search = '') {
    $this->db->select('
        invoices.inv_batchno,
        invoices.invoice_number,
        invoices.invoice_date,
        invoices.add_date,
        mst_user.connector_id,
        invoices.created_by,
        mst_user.disb_date,
        mst_user.user_name,
        mst_user.id as user_id,
        mst_staff.staff_fullname,
        mst_staff.staff_id as staff_id,
        branch.branch_name,
        branch.id as branch_id,
        mst_city.city_name as hlc_city_name,
        mst_city.id as hlc_city_id
    ');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('branch', 'invoices.branch_id = branch.id');
    $this->db->join('mst_city', 'mst_staff.city_id = mst_city.id', 'left');
   
    
    if (!empty($start_date)) {
        $this->db->where("invoices.add_date >=", $start_date);
    }
    if (!empty($end_date)) {
        $this->db->where("invoices.add_date <=", $end_date);
    }
   
    if (!empty($conn_id)) {
        $this->db->where('mst_user.connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('invoices.branch_id', $branch_id);
    }
    if (!empty($city_id)) {
        $this->db->where_in('branch.city_id', $city_id);
    }
    if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year);
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
         if (!empty($hlc_paid_status)) {
        $this->db->group_start(); // Start OR group
    
        if (in_array('unpaid', $hlc_paid_status)) {
            $this->db->or_where('mst_user.hlc_payment_status IS NULL', null, false);
            $this->db->where('mst_user.disb_status', 'yes'); // Apply only if globally required
        }
    
        // Filter out 'unpaid' and handle the rest
        $other_hlc_statuses = array_diff($hlc_paid_status, ['unpaid']);
    
        if (!empty($other_hlc_statuses)) {
            $this->db->or_where_in('mst_user.hlc_payment_status', $other_hlc_statuses);
        }
    
        $this->db->group_end(); // End OR group
    }
    /*if (!empty($hlc_paid_status)) {
        if ($hlc_paid_status === 'unpaid') {
            $this->db->where('invoices.hlc_status', NULL);
        } else {
            $this->db->where('invoices.hlc_status', $hlc_paid_status);
        }
    }*/
    $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
        
    
    if (!empty($payment_month_hlc)) {
    $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');

    // Assuming $payment_month_hlc is in 'YYYY-MM' format
    $date_parts = explode('-', $payment_month_hlc); // Split the input into year and month
    $year = $date_parts[0]; // Extract year
    $month = $date_parts[1]; // Extract month

    // Use MySQL MONTH() and YEAR() functions for filtering
    $this->db->where('YEAR(invoice_log.payment_date)', $year);
    $this->db->where('MONTH(invoice_log.payment_date)', $month);
    $this->db->order_by('invoice_log.payment_date', 'asc');
}

    
    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_user.user_name', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search);
        $this->db->or_like('branch.branch_name', $search);
        $this->db->or_like('invoices.invoice_number', $search);
        $this->db->group_end();
    }
    $this->db->where('is_exported', 0);
    $this->db->where('invoices.invoice_type', 'inv_hlc');
    $this->db->group_by('invoices.inv_batchno');

    $this->db->order_by('invoices.add_date', 'DESC');


    if ($limit != '' && $limit != -1) {
        $this->db->limit($limit, $offset);
    }
    
    $query = $this->db->get();
    return $query->result_array();
}



public function count_payout_all_invoices($start_date, $end_date, $conn_id, $branch_id, $hlc_paid_status, $city_id, $disb_month_year, $payment_month_hlc,$search = '') {
    $this->db->select('invoices.inv_batchno');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
    $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
    $this->db->join('branch', 'invoices.branch_id = branch.id');
    $this->db->where('mst_staff.is_exported', 0);

    if (!empty($start_date)) {
        $this->db->where("invoices.add_date >=", $start_date);
    }
    if (!empty($end_date)) {
        $this->db->where("invoices.add_date <=", $end_date);
    }
    if (!empty($conn_id)) {
        $this->db->where('invoices.connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('invoices.branch_id', $branch_id);
    }
    if (!empty($city_id)) {
        $this->db->where_in('branch.city_id', $city_id);
    }
    if (!empty($disb_month_year) && strpos($disb_month_year, '-') !== false) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year);
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
         if (!empty($hlc_paid_status)) {
        $this->db->group_start(); // Start OR group
    
        if (in_array('unpaid', $hlc_paid_status)) {
            $this->db->or_where('mst_user.hlc_payment_status IS NULL', null, false);
            $this->db->where('mst_user.disb_status', 'yes'); // Apply only if globally required
        }
    
        // Filter out 'unpaid' and handle the rest
        $other_hlc_statuses = array_diff($hlc_paid_status, ['unpaid']);
    
        if (!empty($other_hlc_statuses)) {
            $this->db->or_where_in('mst_user.hlc_payment_status', $other_hlc_statuses);
        }
    
        $this->db->group_end(); // End OR group
    }
   /* if (!empty($hlc_paid_status)) {
        if ($hlc_paid_status === 'unpaid') {
            $this->db->where('invoices.hlc_status', NULL);
        } else {
            $this->db->where('invoices.hlc_status', $hlc_paid_status);
        }
    }*/
    $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
        
       if (!empty($payment_month_hlc)) {
        $this->db->join('invoice_log', 'invoice_log.invoice_batchno = invoices.inv_batchno', 'left');
    
        // Assuming $payment_month_hlc is in 'YYYY-MM' format
        $date_parts = explode('-', $payment_month_hlc); // Split the input into year and month
        $year = $date_parts[0]; // Extract year
        $month = $date_parts[1]; // Extract month
    
        // Use MySQL MONTH() and YEAR() functions for filtering
        $this->db->where('YEAR(invoice_log.payment_date)', $year);
        $this->db->where('MONTH(invoice_log.payment_date)', $month);
    }

    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_user.user_name', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search);
        $this->db->or_like('branch.branch_name', $search);
        $this->db->or_like('invoices.invoice_number', $search);
        $this->db->group_end();
    }
    $this->db->where('invoices.invoice_type', 'inv_hlc');
    $this->db->group_by('invoices.inv_batchno');

    return $this->db->count_all_results();
}

public function get_monthly_totals($year) {
    $query = $this->db->query("
        SELECT 
            SUM(CASE WHEN MONTH(disb_date) = 4 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as apr,
            SUM(CASE WHEN MONTH(disb_date) = 5 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as may,
            SUM(CASE WHEN MONTH(disb_date) = 6 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as jun,
            SUM(CASE WHEN MONTH(disb_date) = 7 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as jul,
            SUM(CASE WHEN MONTH(disb_date) = 8 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as aug,
            SUM(CASE WHEN MONTH(disb_date) = 9 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as sept,
            SUM(CASE WHEN MONTH(disb_date) = 10 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as oct,
            SUM(CASE WHEN MONTH(disb_date) = 11 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as nov,
            SUM(CASE WHEN MONTH(disb_date) = 12 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as `dec`,
            SUM(CASE WHEN MONTH(disb_date) = 1 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as jan,
            SUM(CASE WHEN MONTH(disb_date) = 2 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as feb,
            SUM(CASE WHEN MONTH(disb_date) = 3 THEN IF(loan_type_id != 5, sanction_amt, rinnraksha_amt) ELSE 0 END) as mar
        FROM mst_user
        WHERE YEAR(disb_date) = $year
    ");
    
    return $query->row_array();
}


/*public function get_monthly_totals_mb_pb($financialYearStart, $financialYearEnd) {
    $query = $this->db->query("
        SELECT 
            SUM(CASE WHEN MONTH(disb_date) = 4 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 4 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as apr_mb,
            SUM(CASE WHEN MONTH(disb_date) = 4 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 4 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as apr_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 5 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 5 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as may_mb,
            SUM(CASE WHEN MONTH(disb_date) = 5 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 5 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as may_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 6 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 6 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jun_mb,
            SUM(CASE WHEN MONTH(disb_date) = 6 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 6 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jun_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 7 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 7 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jul_mb,
            SUM(CASE WHEN MONTH(disb_date) = 7 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 7 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jul_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 8 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 8 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as aug_mb,
            SUM(CASE WHEN MONTH(disb_date) = 8 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 8 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as aug_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 9 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 9 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as sept_mb,
            SUM(CASE WHEN MONTH(disb_date) = 9 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 9 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as sept_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 10 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 10 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as oct_mb,
            SUM(CASE WHEN MONTH(disb_date) = 10 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 10 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as oct_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 11 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 11 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as nov_mb,
            SUM(CASE WHEN MONTH(disb_date) = 11 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 11 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as nov_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 12 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 12 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as dec_mb,
            SUM(CASE WHEN MONTH(disb_date) = 12 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 12 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as dec_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 1 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 1 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jan_mb,
            SUM(CASE WHEN MONTH(disb_date) = 1 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 1 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jan_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 2 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 2 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as feb_mb,
            SUM(CASE WHEN MONTH(disb_date) = 2 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 2 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as feb_pb,
            
            SUM(CASE WHEN MONTH(disb_date) = 3 AND login_code = 'Mortgagebuddy' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 3 AND login_code = 'Mortgagebuddy' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as mar_mb,
            SUM(CASE WHEN MONTH(disb_date) = 3 AND login_code = 'PaisaBazaar' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 3 AND login_code = 'PaisaBazaar' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as mar_pb
        FROM mst_user
        WHERE disb_date >= ? AND disb_date <= ?
        AND disb_date IS NOT NULL
        AND is_archive = 'No'
      
        AND login_code IS NOT NULL
    ", [$financialYearStart, $financialYearEnd]);

    return $query->row_array();
}
*/

public function get_monthly_totals_mb_pb($financialYearStart, $financialYearEnd) {
    $sql = "
        SELECT 
            -- APR
            SUM(CASE WHEN MONTH(disb_date) = 4 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 4 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as apr_mb,
            SUM(CASE WHEN MONTH(disb_date) = 4 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 4 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as apr_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 4 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 4 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as apr_pb,
            SUM(CASE WHEN MONTH(disb_date) = 4 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 4 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as apr_pb_non,

            -- MAY
            SUM(CASE WHEN MONTH(disb_date) = 5 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 5 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as may_mb,
            SUM(CASE WHEN MONTH(disb_date) = 5 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 5 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as may_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 5 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 5 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as may_pb,
            SUM(CASE WHEN MONTH(disb_date) = 5 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 5 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as may_pb_non,

            -- JUNE
            SUM(CASE WHEN MONTH(disb_date) = 6 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 6 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jun_mb,
            SUM(CASE WHEN MONTH(disb_date) = 6 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 6 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jun_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 6 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 6 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jun_pb,
            SUM(CASE WHEN MONTH(disb_date) = 6 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 6 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jun_pb_non,

            -- JUL
            SUM(CASE WHEN MONTH(disb_date) = 7 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 7 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jul_mb,
            SUM(CASE WHEN MONTH(disb_date) = 7 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 7 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jul_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 7 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 7 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jul_pb,
            SUM(CASE WHEN MONTH(disb_date) = 7 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 7 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jul_pb_non,

            -- AUG
            SUM(CASE WHEN MONTH(disb_date) = 8 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 8 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as aug_mb,
            SUM(CASE WHEN MONTH(disb_date) = 8 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 8 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as aug_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 8 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 8 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as aug_pb,
            SUM(CASE WHEN MONTH(disb_date) = 8 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 8 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as aug_pb_non,

            -- SEPT
            SUM(CASE WHEN MONTH(disb_date) = 9 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 9 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as sept_mb,
            SUM(CASE WHEN MONTH(disb_date) = 9 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 9 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as sept_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 9 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 9 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as sept_pb,
            SUM(CASE WHEN MONTH(disb_date) = 9 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 9 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as sept_pb_non,

            -- OCT
            SUM(CASE WHEN MONTH(disb_date) = 10 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 10 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as oct_mb,
            SUM(CASE WHEN MONTH(disb_date) = 10 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 10 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as oct_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 10 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 10 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as oct_pb,
            SUM(CASE WHEN MONTH(disb_date) = 10 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 10 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as oct_pb_non,

            -- NOV
            SUM(CASE WHEN MONTH(disb_date) = 11 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 11 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as nov_mb,
            SUM(CASE WHEN MONTH(disb_date) = 11 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 11 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as nov_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 11 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 11 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as nov_pb,
            SUM(CASE WHEN MONTH(disb_date) = 11 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 11 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as nov_pb_non,

            -- DEC
            SUM(CASE WHEN MONTH(disb_date) = 12 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 12 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as dec_mb,
            SUM(CASE WHEN MONTH(disb_date) = 12 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 12 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as dec_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 12 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 12 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as dec_pb,
            SUM(CASE WHEN MONTH(disb_date) = 12 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 12 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as dec_pb_non,

            -- JAN
            SUM(CASE WHEN MONTH(disb_date) = 1 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 1 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jan_mb,
            SUM(CASE WHEN MONTH(disb_date) = 1 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 1 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jan_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 1 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 1 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jan_pb,
            SUM(CASE WHEN MONTH(disb_date) = 1 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 1 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as jan_pb_non,

            -- FEB
            SUM(CASE WHEN MONTH(disb_date) = 2 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 2 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as feb_mb,
            SUM(CASE WHEN MONTH(disb_date) = 2 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 2 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as feb_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 2 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 2 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as feb_pb,
            SUM(CASE WHEN MONTH(disb_date) = 2 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 2 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as feb_pb_non,

            -- MAR
            SUM(CASE WHEN MONTH(disb_date) = 3 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 3 AND login_code = 'Mortgagebuddy' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as mar_mb,
            SUM(CASE WHEN MONTH(disb_date) = 3 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 3 AND login_code = 'Mortgagebuddy' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as mar_mb_non,
            SUM(CASE WHEN MONTH(disb_date) = 3 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 3 AND login_code = 'PaisaBazaar' AND is_verify = '1' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as mar_pb,
            SUM(CASE WHEN MONTH(disb_date) = 3 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id != 5 THEN sanction_amt 
                     WHEN MONTH(disb_date) = 3 AND login_code = 'PaisaBazaar' AND is_verify = '0' AND loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) as mar_pb_non

        FROM mst_user
        WHERE disb_date >= ? AND disb_date <= ?
        AND disb_date IS NOT NULL
        AND is_archive = 'No'
        AND login_code IS NOT NULL
    ";

    $query = $this->db->query($sql, [$financialYearStart, $financialYearEnd]);
    return $query->row_array();
}

//Partner Business Report

 private function apply_filters_partner_business($search, $year, $connector_id) {
    if (!empty($year)) {
        $this->db->group_start();
        $this->db->where('YEAR(mst_user.add_date)', $year);
        $this->db->or_group_start();
        $this->db->where('YEAR(mst_user.disb_date)', $year);
        $this->db->group_end();
        $this->db->group_end();
    }
    if (!empty($connector_id)) {
        $this->db->where('mst_user.connector_id', $connector_id);
    }
    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_staff.staff_fullname', $search);
        $this->db->or_like('mst_user.status', $search);
        $this->db->or_like('mst_city.city_name', $search);  // Search in city name
        $this->db->group_end();
    }
}

/*public function get_partner_business_data($search, $year, $connector_id, $limit, $offset, $order_by, $order_dir) {
    $this->db->select('
        mst_staff.staff_fullname as connector_name,
        mst_city.city_name,
        SUM(CASE WHEN mst_user.status = "Login Case" THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as login_case_total,
        SUM(CASE WHEN mst_user.status = "Disb Case" THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as disb_case_total,
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 4 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as apr_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 5 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as may_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 6 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as jun_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 7 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as jul_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 8 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as aug_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 9 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as sept_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 10 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as oct_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 11 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as nov_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 12 AND YEAR(mst_user.disb_date) = ' . $year . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as dec_' . $year . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 1 AND YEAR(mst_user.disb_date) = ' . ($year + 1) . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as jan_' . ($year + 1) . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 2 AND YEAR(mst_user.disb_date) = ' . ($year + 1) . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as feb_' . ($year + 1) . ',
        SUM(CASE WHEN mst_user.status = "Disb Case" AND MONTH(mst_user.disb_date) = 3 AND YEAR(mst_user.disb_date) = ' . ($year + 1) . ' THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as mar_' . ($year + 1) . '
    ');

    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_city', 'mst_staff.city_id = mst_city.id', 'left');
    $this->apply_filters_partner_business($search, $year, $connector_id);
    $this->db->group_by('mst_staff.staff_id');
    $this->db->order_by($order_by, $order_dir);

    if ($limit != -1) {
        $this->db->limit($limit, $offset);
    }

    $query = $this->db->get();
    return $query->result_array();
}*/

public function get_partner_business_data($search, $year, $connector_id, $limit, $offset, $order_by, $order_dir) {
    $financial_year_start = $year;
    $financial_year_end = $year + 1;

    $start_date = "$financial_year_start-04-01";
    $end_date = "$financial_year_end-03-31";

    $this->db->select('
        mst_staff.staff_fullname as connector_name,
        mst_city.city_name,
        SUM(CASE WHEN mst_user.status = "Login Case" THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as login_case_total,
        SUM(CASE WHEN mst_user.status = "Disb Case" THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) ELSE 0 END) as disb_case_total
    ');

    // Monthly columns
    for ($month = 1; $month <= 12; $month++) {
        $year_for_month = ($month >= 4 && $month <= 12) ? $financial_year_start : $financial_year_end;
        $month_name = strtolower(DateTime::createFromFormat('!m', $month)->format('M')); // apr, may, etc.
        $this->db->select("
            SUM(CASE 
                WHEN mst_user.status = 'Disb Case' 
                AND MONTH(mst_user.disb_date) = $month 
                AND YEAR(mst_user.disb_date) = $year_for_month 
                THEN IF(mst_user.loan_type_id != 5, mst_user.sanction_amt, mst_user.rinnraksha_amt) 
                ELSE 0 
            END) as {$month_name}_$year_for_month
        ");
    }

    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_city', 'mst_staff.city_id = mst_city.id', 'left');

    // Only data from selected financial year
    $this->db->where("mst_user.disb_date >=", $start_date);
    $this->db->where("mst_user.disb_date <=", $end_date);

    if (!empty($connector_id)) {
        $this->db->where('mst_user.connector_id', $connector_id);
    }

    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_staff.staff_fullname', $search);
        $this->db->or_like('mst_city.city_name', $search);
        $this->db->group_end();
    }

    $this->db->where('mst_user.is_archive', 'No');
    $this->db->group_by('mst_staff.staff_id');
    $this->db->order_by($order_by, $order_dir);

    if ($limit != -1) {
        $this->db->limit($limit, $offset);
    }

    return $this->db->get()->result_array();
}





public function count_all_partner_business() {
    $this->db->from('mst_staff');
    $this->db->where('staff_type', '1');
    $this->db->group_by('mst_staff.staff_id');
    return $this->db->count_all_results();
}

public function count_filtered_partner_business($search, $year, $connector_id) {
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_city', 'mst_staff.city_id = mst_city.id', 'left');
    $this->apply_filters_partner_business($search, $year, $connector_id);
    $this->db->group_by('mst_staff.staff_id');
    $query = $this->db->get();
    return $query->num_rows();
}


    public function get_existing_tds_by_quarter($connector_id, $quarter) {
    return $this->db->get_where('mst_tds_certificate', [
        'connector_id' => $connector_id,
        'quarter' => $quarter
    ])->row();
}


    public function update_tds($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('mst_tds_certificate', $data);
    }

    public function insert_tds($data) {
        return $this->db->insert('mst_tds_certificate', $data);
    }
    public function get_staff_fullname($connector_id) {
        $this->db->select('staff_fullname');
        $this->db->where('staff_id', $connector_id);
        $query = $this->db->get('mst_staff');
        return $query->row()->staff_fullname;
    }
    public function get_tds_certificate_by_id($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('mst_tds_certificate');
        return $query->row();
    }
    
    
    
public function getMonthlyTdsAmt($rboId, $month, $year) {
    $query = $this->db->query("
        SELECT SUM(il.tds_amt) AS total_tds_amt
        FROM invoice_log il
        JOIN invoices inv ON il.invoice_batchno = inv.inv_batchno
        JOIN mst_user ON inv.user_id = mst_user.id
        JOIN branch ON branch.id = mst_user.branch_id
        LEFT JOIN mst_rbo ON mst_rbo.id = branch.rbo_id
        WHERE il.invoice_type = 'inv_sbi'
          AND il.status IN ('paid', 'partly paid', 'excess paid')
          AND mst_rbo.id = ?
          AND MONTH(mst_user.disb_date) = ?
          AND YEAR(mst_user.disb_date) = ?
    ", [$rboId, $month, $year]);

    return $query->row()->total_tds_amt ?? 0;
}

public function getMonthlySbiPaidAmt($rboId, $month, $year) {
    $query = $this->db->query("
        SELECT SUM(il.pay_amt) AS total_sbi_paid_amt
        FROM invoice_log il
        JOIN invoices inv ON il.invoice_batchno = inv.inv_batchno
        JOIN mst_user ON inv.user_id = mst_user.id
        JOIN branch ON branch.id = mst_user.branch_id
        LEFT JOIN mst_rbo ON mst_rbo.id = branch.rbo_id
        WHERE il.invoice_type = 'inv_sbi'
          AND il.status IN ('paid', 'partly paid', 'excess paid')
          AND mst_rbo.id = ?
          AND MONTH(mst_user.disb_date) = ?
          AND YEAR(mst_user.disb_date) = ?
    ", [$rboId, $month, $year]);

    return $query->row()->total_sbi_paid_amt ?? 0;
}



}
?>
