<?php

class Applicant_Archive_model extends CI_Model {

    public function __construct() {
        parent::__construct();
       
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
        
    }

    private function apply_filters($filters = []) {
        
      // normalize shortcuts
        $search = $filters['search'] ?? '';
        $start_date = $filters['start_date'] ?? '';
        $add_month = $filters['add_month'] ?? '';
       // $end_date = $filters['end_date'] ?? '';
       // $status = $filters['status'] ?? '';
        $conn_id = $filters['conn_id'] ?? '';
        $branch_id = $filters['branch_id'] ?? '';
        $applicant_invoice_status = $filters['applicant_invoice_status'] ?? '';
      //  $sbi_genrated = $filters['sbi_genrated'] ?? '';
        $hlc_invoice_status = $filters['hlc_invoice_status'] ?? '';
        $hlc_paid_status = $filters['hlc_status'] ?? '';
        $city_id = $filters['city_id'] ?? '';
      //  $sbi_payment_status = $filters['sbi_payment_status'] ?? '';
        $pb_payment_status = $filters['pb_payment_status'] ?? '';
        $disb_month_year = $filters['disb_month_year'] ?? '';
        $pb_generated = $filters['app_generated'] ?? '';
        $branch_generated = $filters['branch_generated'] ?? '';
        $partner_generated = $filters['partner_generated'] ?? '';
        $rbo = $filters['rbo'] ?? '';
    //    $created_by_part = $filters['created_by_part'] ?? '';
    //    $team_leader = $filters['team_leader'] ?? '';
    //    $circle = $filters['circle'] ?? '';
    //    $non_verified = $filters['non_verified'] ?? '';
        $state_id = $filters['state_id'] ?? '';

log_message('debug', 'PB Payment Status Filter Value: ' . print_r($filters['pb_payment_status'], true));

        // add_date filter (month-year) -- expecting "YYYY-MM"
        if (!empty($start_date)) {
            if (strpos($start_date, '-') !== false) {
                list($start_year, $start_month) = explode('-', $start_date);
                $this->db->where('MONTH(mst_user.add_date)', $start_month);
                $this->db->where('YEAR(mst_user.add_date)', $start_year);
            }
        }

        // status
      /*  if (!empty($status)) {
            $this->db->where('mst_user.status', $status);
            if ($status === 'Disb Case') {
                $this->db->where('mst_user.disb_date IS NOT NULL', null, false);
            }
        }*/

        // connector / branch
        if (!empty($conn_id)) {
            $this->db->where('mst_user.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('mst_user.branch_id', $branch_id);
        }

        // applicant_invoice_status explicit filter
        if (isset($applicant_invoice_status) && $applicant_invoice_status !== '') {
            $aist = trim($applicant_invoice_status);
            if (strcasecmp($aist, 'No') === 0) {
                $this->db->group_start();
                $this->db->where('mst_user.applicant_invoice_status IS NULL', null, false);
                $this->db->or_where("mst_user.applicant_invoice_status = ''", null, false);
                $this->db->group_end();
            } elseif (strcasecmp($aist, 'Generated') === 0 || strcasecmp($aist, 'Yes') === 0) {
                $this->db->where('mst_user.applicant_invoice_status', 'Generated');
            } else {
                $this->db->where('mst_user.applicant_invoice_status', $aist);
            }
        }

      
        // hlc_invoice_status (if any)
        if (!empty($hlc_invoice_status)) {
            $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
        }

        // city (support array)
        if (!empty($city_id)) {
            if (is_array($city_id)) {
                $this->db->where_in('branch.city_id', $city_id);
            } else {
                $this->db->where('branch.city_id', $city_id);
            }
        }

        // hlc_paid_status (supports array with 'unpaid')
        if (!empty($hlc_paid_status)) {
            $this->db->group_start();
            if (is_array($hlc_paid_status) && in_array('unpaid', $hlc_paid_status)) {
                $this->db->or_where('mst_user.hlc_payment_status IS NULL', null, false);
                $this->db->where('mst_user.disb_status', 'yes');
            }
            $other_hlc_statuses = is_array($hlc_paid_status) ? array_diff($hlc_paid_status, ['unpaid']) : [];
            if (!empty($other_hlc_statuses)) {
                $this->db->or_where_in('mst_user.hlc_payment_status', $other_hlc_statuses);
            }
            $this->db->group_end();
        }

   
        // pb_payment_status (supports array with 'unpaid')
        if (!empty($pb_payment_status)) {
            $this->db->group_start();
            if (is_array($pb_payment_status) && in_array('unpaid', $pb_payment_status)) {
                $this->db->or_where('mst_user.pb_payment_status IS NULL', null, false);
              //  $this->db->where('mst_user.pb_genrated', 'Yes');
            }
            $other_statuses_pb = is_array($pb_payment_status) ? array_diff($pb_payment_status, ['unpaid']) : [];
            if (!empty($other_statuses_pb)) {
                $this->db->or_where_in('mst_user.pb_payment_status', $other_statuses_pb);
            }
            $this->db->group_end();
        }

        // disb month-year (YYYY-MM)
        if (!empty($disb_month_year) && strpos($disb_month_year, '-') !== false) {
            list($disb_year, $disb_month) = explode('-', $disb_month_year);
            $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
            $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
        }

        

        // branch_generated: treat 'No' as NULL/empty
        if (isset($branch_generated) && $branch_generated !== '') {
            $bg = trim($branch_generated);
            if (strcasecmp($bg, 'No') === 0) {
                $this->db->group_start();
                $this->db->where('mst_user.branch_genrated IS NULL', null, false);
                $this->db->or_where("mst_user.branch_genrated = ''", null, false);
                $this->db->group_end();
            } else {
                $this->db->where('mst_user.branch_genrated', $bg);
            }
        }

        // team leader
        if (!empty($team_leader)) {
            $this->db->where('created_by_staff.team_leader', $team_leader);
        }

        // partner_generated: 'No' => NULL/empty, 'Generated' or 'Yes' => 'Generated'
        if (isset($partner_generated) && $partner_generated !== '') {
            $pg = trim($partner_generated);
            if (strcasecmp($pg, 'No') === 0) {
                $this->db->group_start();
                $this->db->where('mst_user.applicant_invoice_status IS NULL', null, false);
                $this->db->or_where("mst_user.applicant_invoice_status = ''", null, false);
                $this->db->group_end();
            } elseif (strcasecmp($pg, 'Generated') === 0 || strcasecmp($pg, 'Yes') === 0) {
                $this->db->where('mst_user.applicant_invoice_status', 'Generated');
            } elseif (strcasecmp($pg, 'All') === 0) {
                // nothing
            } else {
                $this->db->where('mst_user.applicant_invoice_status', $pg);
            }
        }

        // rbo
        if (!empty($rbo)) {
            $this->db->where('branch.rbo_id', $rbo);
        }

        // created_by partial/fullname
        if (!empty($created_by_part)) {
            $this->db->where('created_by_staff.staff_fullname', $created_by_part);
        }

        // circle
        if (!empty($circle)) {
            $this->db->where('branch.circle_id', $circle);
        }

        // state filter (used in all_get/count_all)
        if (!empty($state_id)) {
            if (is_array($state_id)) {
                $this->db->where_in('branch.state_id', $state_id);
            } else {
                $this->db->where('branch.state_id', $state_id);
            }
        }

        // non_verified logic (original behaviour: staff_type 0 => only verified unless non_verified flag set)
        $staff_type = $this->session->userdata('staff_type');
        $this->db->where('mst_user.is_archive', 'Yes');
        
/*if ($staff_type == 0) {
    if (($filters['non_verified'] ?? 0) == 1) {
        // explicitly asked → only non-verified cases
        $this->db->where('mst_user.is_verify', 0);
    } else {
        // default → only verified cases
        $this->db->where('mst_user.is_verify', 1);
    }
}*/


        // Search
        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like('mst_user.user_name', $search);
            $this->db->or_like('mst_user.los_id', $search);
            $this->db->or_like('mst_user.bank_acct_no', $search);
            $this->db->or_like('mst_user.user_phone', $search);
            $this->db->or_like('mst_user.user_email', $search);
            $this->db->or_like('mst_user.user_address', $search);
            $this->db->or_like('mst_user.applicant_rr_id', $search);
            $this->db->or_like('mst_user.rr_cbs_acct_no', $search);
            $this->db->or_like('mst_user.sanction_amt', $search);
            $this->db->or_like('mst_user.status', $search);
            $this->db->or_like('mst_user.disb_status', $search);
            $this->db->or_like('mst_user.hlc_payment_status', $search);
          //  $this->db->or_like('mst_user.sbi_payment_status', $search);
            $this->db->or_like('branch.branch_name', $search);
            $this->db->or_like('branch.branch_code', $search);
            $this->db->or_like('mst_city.city_name', $search);
            $this->db->or_like('mst_city.agency_code', $search);
            $this->db->or_like('mst_city.agency_name', $search);
            $this->db->or_like('mst_rbo.rbo_name', $search);
            $this->db->or_like('mst_loan_type.name', $search);
            $this->db->or_like('mst_staff.staff_fullname', $search);
            $this->db->or_like('mst_staff.hlc_code', $search);
            $this->db->or_like('created_by_staff.staff_fullname', $search);
            $this->db->group_end();
        }

        // staff_type == 1 restricts connector_id
        if ($staff_type == 1) {
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
}

public function get_applicant_data($filters = [])
{
    $this->db->select('mst_user.*, 
                       mst_staff.staff_fullname, 
                       mst_loan_type.name as user_type, 
                       branch.branch_name, 
                       branch.branch_code, 
                       mst_city.city_name, 
                       mst_state.state_name,
                       mst_rbo.rbo_name');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'mst_user.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'branch.state_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');

    $this->db->where('mst_user.login_code!=', 'PaisaBazaar');
    $this->db->where('mst_user.is_archive', 'Yes');

    $this->apply_filters($filters);

    if (!empty($filters['limit']) && $filters['limit'] != -1) {
        if (!empty($filters['offset'])) {
            $this->db->limit($filters['limit'], $filters['offset']);
        } else {
            $this->db->limit($filters['limit']);
        }
    }

    $this->db->order_by('mst_user.add_date', 'desc');
    $query = $this->db->get();
    return $query->result_array();
}

public function count_applicant_data($filters = [])
{
    $this->db->select('COUNT(*) as total');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_state', 'branch.state_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->where('mst_user.is_archive', 'Yes');

    $this->apply_filters($filters);

    $query = $this->db->get();
    return $query->row()->total;
}

    
     public function get_all_applicant_data($filters = [])
    {
        $this->db->select('mst_user.*, 
                           mst_staff.staff_fullname, 
                           mst_loan_type.name as user_type, 
                           branch.branch_name, 
                           branch.branch_code, 
                           mst_state.state_name,
                           mst_city.city_name, 
                           mst_rbo.rbo_name');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
        $this->db->join('mst_state', 'branch.state_id = mst_state.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
        $this->db->where('mst_user.is_archive', 'Yes');
    
        // Apply filters
        $this->apply_filters($filters);
    
        // Limit & Offset
        if (!empty($filters['limit']) && $filters['limit'] != -1) {
            if (!empty($filters['offset'])) {
                $this->db->limit($filters['limit'], $filters['offset']);
            } else {
                $this->db->limit($filters['limit']);
            }
        }
    
        $this->db->order_by('mst_user.add_date', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function count_all_applicant_data($filters = [])
    {
        $this->db->select('COUNT(*) as total');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
        $this->db->join('mst_state', 'branch.state_id = mst_state.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
        $this->db->where('mst_user.is_archive', 'Yes');
    
        // Apply filters
        $this->apply_filters($filters);
    
        // Staff-specific restriction
        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
    
        $query = $this->db->get();
        return $query->row()->total;
    }
}
?>
