<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Include the Composer autoloader
require_once FCPATH . 'vendor_new/autoload.php';

// Import PhpSpreadsheet classes
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

class Mb_excel_applicant extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->model('common_model', 'ccm'); // Load your model
    }

    
      public function index() {
        // Fetch data
        $invoices = $this->ccm->get_invoice_mb_applicant_list();
       
        // Group the invoices by branch_code
        $grouped_invoices = [];
        foreach ($invoices as $invoice) {
            $loan_amount = ($invoice['loan_type_id'] == 5) ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];
            $commission_rate = floatval($invoice['pb_commi']) / 100;
           // $amt_100 = $this->calculatePB($invoice['loan_type_id'], $loan_amount);
            $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $invoice['invoice_id']])->get()->row();
            $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $invoice['branch_invoice_id']])->get()->row();
            $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $invoice['sbi_invoice_id']])->get()->row();
            $created_by = $this->db->select("*")->where(['staff_id' => $invoice['connector_id']])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $app_created_by = $this->db->select("*")->where(['staff_id' => $invoice['created_by']])->from('mst_staff')->get()->row();

            $grouped_invoices[$invoice['login_code']]['invoices'][] = array_merge($invoice, [
                'loan_amount' => $loan_amount,
                'hlc_inv_no' => @$inv_hlc_data->invoice_number,
                'branch_inv_no' => @$inv_branch_data->invoice_number,
                'sbi_inv_no' => @$inv_sbi_data->invoice_number,
                'hlc_created_by' => $admin_created_hlc->staff_fullname,
                'app_created_by' => @$app_created_by->staff_fullname
            ]);

            // Accumulate totals
          //  $grouped_invoices[$invoice['login_code']]['totals']['100_amt'] += $amt_100;
        }

        // Create a new spreadsheet instance
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

     
        
       $headers = [
        'Sr.No.', 'Partner Name', 'Partner Code', 'Name of Borrower', 'State', 'City',
        'Los Id & RLMS ID', 'CBS A/c NO', 'Branch', 'Branch Code', 'RBO', 'Type of Loan',
        'Sanction Loan Amt', 'Partner Payout %', 'Partner Payout Amt', 'SBI %', 'SBI Commi Amt',
        'SBI 10%', 'SBI 90% Commi', 'Date of disb.', 'Status', 'Partner Generated',
        'Partner Payment Status', 'Branch Generated', 'SBI Generated', 'SBI Payment Status',
        'Add date', 'Part. Created By', 'Created By', 'Appraisal'
    ];

         $colIndex = 1; // Start column index at 1 ('A')
    foreach ($headers as $header) {
        $colLetter = Coordinate::stringFromColumnIndex($colIndex); // Convert index to letter
        $sheet->setCellValue($colLetter . '1', $header);
        $sheet->getStyle($colLetter . '1')->getFont()->setBold(true);
        $sheet->getStyle($colLetter . '1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
        $colIndex++;
    }

        // Write data to the sheet
        $row = 2;
        $serial_number = 1;

        foreach ($grouped_invoices as $login_code => $group) {
            foreach ($group['invoices'] as $invoice) {
                // RR Commission row handling
                if ($invoice['loan_type_id'] == 5) {
                    $invoice['is_rr_commission'] = true;  // Mark as RR commission row
                    $invoice['commission'] = $this->calculate_rr_commission($invoice);  
                }

                // Regular invoice row
                $sheet->setCellValue('A' . $row, $serial_number++); 
                $sheet->setCellValue('B' . $row, $invoice['staff_fullname']);
                $sheet->setCellValue('C' . $row, $invoice['hlc_code']);
                $sheet->setCellValue('D' . $row, $invoice['user_name']);
                $sheet->setCellValue('E' . $row, $invoice['state_name']);
                $sheet->setCellValue('F' . $row, $invoice['city_name']);
                $sheet->setCellValue('G' . $row, $invoice['los_id']); 
                $sheet->getStyle('G' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
                $sheet->setCellValue('H' . $row, ($invoice['loan_type_id'] == 5) ? $invoice['rr_cbs_acct_no'] : $invoice['bank_acct_no']);
                 $sheet->setCellValue('I' . $row, $invoice['branch_name']);
                $sheet->setCellValue('J' . $row, $invoice['branch_code']);
                $sheet->setCellValue('K' . $row, $invoice['rbo_name']);
                $sheet->setCellValue('L' . $row, $invoice['account_type']); //type loan
                 $sheet->setCellValue('M' . $row, $invoice['loan_amount']);
                 $sheet->getStyle('M' . $row)->getNumberFormat()->setFormatCode('#,##0');
                 $sheet->setCellValue('N' . $row, ($invoice['loan_type_id'] == 4) ? number_format(0.20, 2).'%' : $invoice['part_payout']. '%');
                // Ensure loan_amount is numeric
$loan_amount = isset($invoice['loan_amount']) ? str_replace(',', '', $invoice['loan_amount']) : '0';
$loan_amount = is_numeric($loan_amount) ? (float) $loan_amount : 0;

// Ensure part_payout is numeric
$part_payout = isset($invoice['part_payout']) ? str_replace(',', '', $invoice['part_payout']) : '0';
$part_payout = is_numeric($part_payout) ? (float) $part_payout : 0;

// Calculate the rate
$rate = ($invoice['loan_type_id'] == 4) ? 0.20 / 100 : ($part_payout / 100);

// Safely set the cell value
$sheet->setCellValue('O' . $row, formatIndianNumber($loan_amount * $rate));

                  $sheet->setCellValue('P' . $row, $invoice['sbi_commi']);
                  
                  $sbi_comm = ($loan_amount * $invoice['sbi_commi']) / 100;
                  $sheet->setCellValue('Q' . $row, $sbi_comm);
                  $ten10_sbi = ($sbi_comm * 10) / 100;
                  $sheet->setCellValue('R' . $row, $ten10_sbi);  
                  $sheet->setCellValue('S' . $row, $sbi_comm - $ten10_sbi);
              
            $disbDate = isset($invoice['disb_date']) && !empty($invoice['disb_date']) ? strtotime($invoice['disb_date']) : null;

if ($disbDate) {
    $sheet->setCellValue('T' . $row, date('d-M-y', $disbDate));
} else {
    $sheet->setCellValue('T' . $row, 'N/A'); // Set 'N/A' or leave blank if date is invalid
}

              $sheet->setCellValue('U' . $row, $invoice['status']);
              
               $sheet->setCellValue('V' . $row, ($invoice['applicant_invoice_status'] == 'Generated') ? $invoice['hlc_inv_no'] : 'No');
                $sheet->setCellValue('W' . $row, $invoice['hlc_payment_status']);
                
                $sheet->setCellValue('X' . $row, ($invoice['branch_genrated'] == 'Yes') ? $invoice['branch_inv_no'] : 'No');
                
                $sheet->setCellValue('Y' . $row, ($invoice['sbi_genrated'] == 'Yes') ? $invoice['sbi_inv_no'] : 'No');
                $sheet->setCellValue('Z' . $row, $invoice['sbi_payment_status']);
                
                $sheet->setCellValue('AA' . $row, date('d-m-Y', strtotime($invoice['add_date'])));
                 $sheet->setCellValue('AB' . $row, $invoice['hlc_created_by']);
                 $sheet->setCellValue('AC' . $row, $invoice['app_created_by']);
                
                // Add attachment hyperlinks for regular row
                $this->add_attachment_hyperlinks($sheet, $row, $invoice);
            
                // If RR Commission, add a separate row
                if (isset($invoice['is_rr_commission'])) {
                    $row++;  // Move to the next row for RR Commission
                   $sheet->setCellValue('A' . $row, $serial_number++); 
                $sheet->setCellValue('B' . $row, $invoice['staff_fullname']);
                $sheet->setCellValue('C' . $row, $invoice['hlc_code']);
                $sheet->setCellValue('D' . $row, $invoice['user_name']);
                $sheet->setCellValue('E' . $row, $invoice['state_name']);
                $sheet->setCellValue('F' . $row, $invoice['city_name']);
                $sheet->setCellValue('G' . $row, $invoice['los_id']); 
                $sheet->getStyle('G' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);
                $sheet->setCellValue('H' . $row, ($invoice['loan_type_id'] == 5) ? $invoice['rr_cbs_acct_no'] : $invoice['bank_acct_no']);
                 $sheet->setCellValue('I' . $row, $invoice['branch_name']);
                $sheet->setCellValue('J' . $row, $invoice['branch_code']);
                $sheet->setCellValue('K' . $row, $invoice['rbo_name']);
                $sheet->setCellValue('L' . $row, 'RR Commision'); //type loan
                 $sheet->setCellValue('M' . $row, $invoice['commission']);
                 $sheet->getStyle('M' . $row)->getNumberFormat()->setFormatCode('#,##0');
                 /*$sheet->setCellValue('N' . $row, ($invoice['loan_type_id'] == 4) ? number_format(0.20, 2).'%' : $invoice['part_payout']. '%');
                // Ensure loan_amount is numeric
$loan_amount = isset($invoice['loan_amount']) ? str_replace(',', '', $invoice['loan_amount']) : '0';
$loan_amount = is_numeric($loan_amount) ? (float) $loan_amount : 0;

// Ensure part_payout is numeric
$part_payout = isset($invoice['part_payout']) ? str_replace(',', '', $invoice['part_payout']) : '0';
$part_payout = is_numeric($part_payout) ? (float) $part_payout : 0;*/

$cutoffTimestamp = strtotime('2025-10-02');
$apply_cutoff = false;

// ✅ Apply cutoff only if loan_type_id = 5 and disb_date exists
if ($invoice['loan_type_id'] == 5 && !empty($invoice['disb_date'])) {
    $disbTimestamp = strtotime($invoice['disb_date']);
    if ($disbTimestamp >= $cutoffTimestamp) {
        $apply_cutoff = true;
    }
}

// ✅ Set PB/Part Payout rate in column N
if ($apply_cutoff) {
    // disb_date >= cutoff => commission = 0%
    $sheet->setCellValue('N' . $row, '0.00%');
    $part_payout = 0;
} else {
    // Normal logic for all other cases
    if ($invoice['loan_type_id'] == 4) {
        $sheet->setCellValue('N' . $row, number_format(0.20, 2) . '%');
        $part_payout = 0.20; // since 0.20% means 0.20
    } else {
        $sheet->setCellValue('N' . $row, $invoice['part_payout'] . '%');
        $part_payout = isset($invoice['part_payout']) ? str_replace(',', '', $invoice['part_payout']) : '0';
        $part_payout = is_numeric($part_payout) ? (float)$part_payout : 0;
    }
}

// ✅ Ensure loan_amount is numeric
$loan_amount = isset($invoice['loan_amount']) ? str_replace(',', '', $invoice['loan_amount']) : '0';
$loan_amount = is_numeric($loan_amount) ? (float)$loan_amount : 0;



// Ensure sbi_commi is numeric
$sbi_commi = isset($invoice['sbi_commi']) ? str_replace(',', '', $invoice['sbi_commi']) : '0';
$sbi_commi = is_numeric($sbi_commi) ? (float) $sbi_commi : 0;

// Ensure loan_type_id is numeric
$loan_type_id = isset($invoice['loan_type_id']) ? (int) $invoice['loan_type_id'] : 0;

// Calculate the rate
$rate = ($loan_type_id == 4) ? 0.20 / 100 : ($part_payout / 100);

// Calculate SBI commission
$sbi_comm = ($loan_amount * $sbi_commi) / 100;

// Safely set the cell values
//$sheet->setCellValue('O' . $row, formatIndianNumber($loan_amount * $rate));
$sheet->setCellValue('O' . $row, $invoice['commission']);
$sheet->setCellValue('P' . $row, '');

                 //$sheet->setCellValue('Q' . $row, $sbi_comm);
                 $sheet->setCellValue('Q' . $row, $invoice['commission']);
                 
                  $ten10_sbi = ($invoice['commission'] * 10) / 100;
                  $sheet->setCellValue('R' . $row, $ten10_sbi);  
                  $sheet->setCellValue('S' . $row, $invoice['commission'] - $ten10_sbi);
              
            $disbDate = isset($invoice['disb_date']) && !empty($invoice['disb_date']) ? strtotime($invoice['disb_date']) : null;

if ($disbDate) {
    $sheet->setCellValue('T' . $row, date('d-M-y', $disbDate));
} else {
    $sheet->setCellValue('T' . $row, 'N/A'); // Set 'N/A' or leave blank if date is invalid
}

              $sheet->setCellValue('U' . $row, $invoice['status']);
              
               $sheet->setCellValue('V' . $row, ($invoice['applicant_invoice_status'] == 'Generated') ? $invoice['hlc_inv_no'] : 'No');
                $sheet->setCellValue('W' . $row, $invoice['hlc_payment_status']);
                
                $sheet->setCellValue('X' . $row, ($invoice['branch_genrated'] == 'Yes') ? $invoice['branch_inv_no'] : 'No');
                
                $sheet->setCellValue('Y' . $row, ($invoice['sbi_genrated'] == 'Yes') ? $invoice['sbi_inv_no'] : 'No');
                $sheet->setCellValue('Z' . $row, $invoice['sbi_payment_status']);
                
                $sheet->setCellValue('AA' . $row, date('d-m-Y', strtotime($invoice['add_date'])));
                 $sheet->setCellValue('AB' . $row, $invoice['hlc_created_by']);
                 $sheet->setCellValue('AC' . $row, $invoice['app_created_by']);
                
                // Add attachment hyperlinks for regular row
                $this->add_attachment_hyperlinks($sheet, $row, $invoice);
                 
                    
                }

                // Move to the next row
                $row++;
            }

            // Add a blank row after each branch group
            //$row++;
        }
          
          
      /* if ($row > 1) { // Ensure row is valid
            $sheet->getStyle('A:R' . ($row - 1)) // Subtract 1 to include the last data row
        ->getAlignment()
        ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        }

    
        // Auto-size columns
        foreach (range('A', 'R') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }*/

        // Clear output buffer before generating the file
        ob_end_clean();

        // Set headers for the file
        $filename = "MB_APPLICANT_LIST.xlsx";
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // Generate Excel file
        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
        exit;
    }



  private function add_attachment_hyperlinks($sheet, $row, $invoice) {
        // Fetch attachments for the current invoice
        $latest_letter_apprisal = $this->db->select('appraisal_letter')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('appraisal_letter IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        $latest_letter_fsl = $this->db->select('final_sanction_letter')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('final_sanction_letter IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        $latest_letter_pd = $this->db->select('proof_disb')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('proof_disb IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        // Add hyperlinks to the sheet for each attachment
        if (!empty($latest_letter_apprisal['appraisal_letter'])) {
            $link1 = base_url('assets/uploads/documents/' . $latest_letter_apprisal['appraisal_letter']);
            $sheet->setCellValue('AD' . $row, 'Click');
            $sheet->getCell('AD' . $row)->getHyperlink()->setUrl($link1);
            $sheet->getStyle('AD' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }

        if (!empty($latest_letter_fsl['final_sanction_letter'])) {
            $link2 = base_url('assets/uploads/documents/' . $latest_letter_fsl['final_sanction_letter']);
            $sheet->setCellValue('AE' . $row, 'Click');
            $sheet->getCell('AE' . $row)->getHyperlink()->setUrl($link2);
            $sheet->getStyle('AE' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }

        if (!empty($latest_letter_pd['proof_disb'])) {
            $link3 = base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']);
            $sheet->setCellValue('AF' . $row, 'Click');
            $sheet->getCell('AF' . $row)->getHyperlink()->setUrl($link3);
            $sheet->getStyle('AF' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }
    }
    
    // RR Commission calculation method
    private function calculate_rr_commission($invoice) {
    // Fetch the main account details
    $rr_main_account = $this->db->select("*")
        ->where(['applicant_rr_id' => @$invoice['id'], 'rinnraksha_status' => 'Yes'])
        ->from('mst_user')
        ->get()
        ->row();

    $commission = 0; // Initialize the commission

    // Apply commission slabs
    if (@$rr_main_account->sanction_amt < 5000000) { // Below 50 Lacs
        $commission = 4000;
    } elseif (@$rr_main_account->sanction_amt == 5000000) { // Exactly 50 Lacs
        $commission = 5000;
    } elseif (@$rr_main_account->sanction_amt > 5000000 && $rr_main_account->sanction_amt <= 10000000) { // Above 50 Lacs to 1 Cr
        $commission = 5000;
    } elseif (@$rr_main_account->sanction_amt > 10000000) { // Above 1 Cr
        $commission = 6000;
    }

    return $commission; // Return the calculated commission
}

    
    
    
    
    
    function calculatePB($loan_type, $loan_amount) {
    switch ($loan_type) {
       case '6': // LAP
            if ($loan_amount < 5000000) { // Less than Rs 50 Lacs
                return 0.30 * $loan_amount / 100; // 30% commission
            } elseif ($loan_amount == 5000000) { // Exactly Rs 50 Lacs
                return 0.30 * $loan_amount / 100; // 30% commission
            } elseif ($loan_amount > 5000000) { // Greater than Rs 50 Lacs
                return 0.35 * $loan_amount / 100; // 35% commission
            } else {
                return 0; // Default case to avoid null values
            }
        case '5': //RinnRaksha
                return 0.80 * $loan_amount / 100;
        case '1':  //New
        case '2': //Takeover
        case '3':  //Takeover+TopUp
            return 0.80 * $loan_amount / 100;
        case '4':  //Top Up
            return 0.20 * $loan_amount / 100;
        default:
            return null; // If loan type is not recognized
    }
}

function calculatePBPercent($loan_type, $loan_amount) {
    $result = null;

    switch ($loan_type) {
       case '6': // LAP
            if ($loan_amount <= 5000000) { // Up to Rs 50 Lacs
                $result = number_format(0.30, 2); // 30%
            } elseif ($loan_amount > 5000000) { // Above Rs 50 Lacs
                $result = number_format(0.35, 2); // 35%
            } else {
                $result = number_format(0.30, 2); // Default to 30%
            }
            break;
        case '5': // RinnRaksha
            $result = number_format(0.80, 2); // 80%
            break;
        case '1': // New
        case '2': // Takeover
        case '3': // Takeover+TopUp
            $result = number_format(0.80, 2); // 80%
            break;
        case '4': // Top Up
            $result = number_format(0.20, 2); // 20%
            break;
        default:
            $result = null; // Default case if loan type not recognized
    }

    // Log the inputs and calculated percentage
    log_message('info', 'calculatePBPercent - Loan Type: ' . $loan_type . ', Loan Amount: ' . $loan_amount . ', Result: ' . $result);

    return $result; // Return only the percentage
}





}
