
<?php
class Cron extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model('Hlc_model');
        $this->load->database(); // default: FY 24–25
        $this->load->helper('file');
        $this->load->helper('number');
    }

    public function corn_dump_email() {
        // --- FY 24-25 Data ---
        $start_24 = '2024-04-01';
        $end_24 = '2025-03-31';
        $selected_fy_24 = '24-25';

        $totals_24 = $this->Hlc_model->get_monthly_totals_mb_pb($start_24, $end_24);
        $html_24 = $this->build_html_table($totals_24, $selected_fy_24);

        // --- FY 25-26 Data ---
        $start_25 = '2025-04-01';
        $end_25 = '2026-03-31';
        $selected_fy_25 = '25-26';

        $fin_db = $this->load->database('fin_25_26', TRUE);
        $this->load->model('Hlc_model', 'Hlc_model_25', TRUE); // reload model with second DB
        $this->Hlc_model_25->db = $fin_db; // override DB in model

        $totals_25 = $this->Hlc_model_25->get_monthly_totals_mb_pb($start_25, $end_25);
        $html_25 = $this->build_html_table($totals_25, $selected_fy_25);

        // Combine both
        $combined_html = $html_24 . '<br><br>' . $html_25;

        // Send email
        $this->send_email_html_table($combined_html);
    }

    private function build_html_table($totals, $selected_fy) {
        $months = [
            'apr' => 'Apr', 'may' => 'May', 'jun' => 'Jun', 'jul' => 'Jul',
            'aug' => 'Aug', 'sept' => 'Sep', 'oct' => 'Oct', 'nov' => 'Nov',
            'dec' => 'Dec', 'jan' => 'Jan', 'feb' => 'Feb', 'mar' => 'Mar'
        ];

        $total_mb = 0;
        $total_pb = 0;
        $total_sanctions = 0;

        $html = '<h3 style="margin-bottom: 5px;">Dashboard – Financial Year ' . $selected_fy . '</h3>';
        $html .= '<table border="1" cellpadding="8" cellspacing="0" style="border-collapse: collapse; font-family: Arial; font-size: 14px;">
                    <thead>
                        <tr style="background-color: #f2f2f2;">
                            <th>Month</th>
                            <th>MB</th>
                            <th>PB</th>
                            <th>Total Amount</th>
                        </tr>
                    </thead>
                    <tbody>';

        foreach ($months as $key => $month) {
            $mb = isset($totals[$key . '_mb']) ? $totals[$key . '_mb'] : 0;
            $pb = isset($totals[$key . '_pb']) ? $totals[$key . '_pb'] : 0;
            $total = $mb + $pb;

            if ($mb > 0 || $pb > 0 || $total > 0) {
                $html .= '<tr>
                            <td>' . $month . '</td>
                            <td>' . $this->formatIndianNumber($mb) . '</td>
                            <td>' . $this->formatIndianNumber($pb) . '</td>
                            <td>' . $this->formatIndianNumber($total) . '</td>
                          </tr>';

                $total_mb += $mb;
                $total_pb += $pb;
                $total_sanctions += $total;
            }
        }

        $html .= '</tbody>
                  <tfoot>
                    <tr style="font-weight: bold; background-color: #e6f7ff;">
                        <td>Total</td>
                        <td>' . $this->formatIndianNumber($total_mb) . '</td>
                        <td>' . $this->formatIndianNumber($total_pb) . '</td>
                        <td>' . $this->formatIndianNumber($total_sanctions) . '</td>
                    </tr>
                  </tfoot>
                 </table>';

        return $html;
    }

    private function send_email_html_table($htmlContent) {
        $this->load->library('email');
        
        $config['mailtype'] = 'html'; // ✅ Important!
        $config['charset']  = 'utf-8';
        $config['newline']  = "\r\n";
        $config['crlf']     = "\r\n";

        $this->email->initialize($config);

        $this->email->from('admin@mortgagebuddy.in', 'MB Report Bot');
        $this->email->to('rrb@mortgagebuddy.in'); // Update this
        $this->email->subject('MB Daily Corn Report – FY 24-25 & 25-26');
        $this->email->set_mailtype("html");
        $this->email->message($htmlContent);

        if ($this->email->send()) {
            echo "Email sent successfully.";
        } else {
            echo "Failed to send email.";
            log_message('error', $this->email->print_debugger());
        }
    }

    private function formatIndianNumber($num) {
        $num = (float) $num;
        return number_format($num, 2, '.', ',');
    }
}

