<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3"></div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="Table">
                    <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Invoice Number</th>
                            <th>Branch Name</th>
                            <th>Users</th>
                            <th>Gross Amount</th>
                            <th>GST</th>
                            <th>PB Invoice Amount</th>
                            <th>Invoice Date</th>
                            <th>SBI Payment</th>
                            <th>Cancelled Date</th>
                            <th>Cancelled By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
if (!empty($cancelled_rbo_invoice)) {
    $group = [];
    foreach ($cancelled_rbo_invoice as $row) {
        // Group by invoice_number
        $group[$row['invoice_number']][] = $row;
    }

    $sr_no = 1;
    foreach ($group as $batch_no => $entries) {
        // Collect all user_ids from invoice_log
        $user_ids = [];
        foreach ($entries as $entry) {
            $invoice_data = json_decode($entry['invoice_log'], true);
            
            $branch_name = '-';
            if (!empty($invoice_data['branch_id'])) {
                $branch = $this->db->select('branch_name')
                    ->from('branch')
                    ->where('id', $invoice_data['branch_id'])
                    ->get()
                    ->row_array();
                $branch_name = !empty($branch['branch_name']) ? $branch['branch_name'] : '-';
            }
            $gross_amount     = !empty($invoice_data['pb_sbi_inv_basic_amt']) ? number_format($invoice_data['pb_sbi_inv_basic_amt'], 2) : '0.00';
            $gst              = !empty($invoice_data['pb_sbi_inv_tax_amt']) ? number_format($invoice_data['pb_sbi_inv_tax_amt'], 2) : '0.00';
            $pb_invoice_amt   = !empty($invoice_data['pb_sbi_inv_total_amt']) ? number_format($invoice_data['pb_sbi_inv_total_amt'], 2) : '0.00';
            $invoice_date     = !empty($invoice_data['pb_sbi_invoice_date']) ? date('F d, Y', strtotime($invoice_data['pb_sbi_invoice_date'])) : '-';
            $sbi_payment      = !empty($invoice_data['sbi_pb_payment_status']) ? $invoice_data['sbi_pb_payment_status'] : '-';

            if (!empty($invoice_data['id'])) {   // FIX: use 'id' instead of 'user_id'
                $user_ids[] = $invoice_data['id'];
            }
        }
        $user_ids = array_unique($user_ids);

        // Fetch user details
        $users = [];
        if (!empty($user_ids)) {
            $users = $this->db->select('
                        mst_user.user_name, 
                        mst_loan_type.name AS loan_type_name, 
                        mst_user.loan_type_id, 
                        mst_user.rinnraksha_amt, 
                        mst_user.sanction_amt
                    ')
                ->from('mst_user')
                ->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left')
                ->where_in('mst_user.id', $user_ids)
                ->get()
                ->result_array();
        }

        // Prepare the user list
        $user_list = !empty($users) 
            ? implode('<br>', array_map(
                function ($u, $index) {
                    $loan_amt = ($u['loan_type_id'] == 5) ? $u['rinnraksha_amt'] : $u['sanction_amt'];
                    return ($index + 1) . ') ' . $u['user_name'] . ' (' . $u['loan_type_name'] . ') - Loan Amt: ' . number_format($loan_amt, 2);
                },
                $users,
                array_keys($users)
            )) 
            : 'No users found';
        ?>
        <tr>
            <td><?= $sr_no++ ?></td>
            <td><?= $entries[0]['invoice_number'] ?></td>
            <td><?= $branch_name ?></td>
            <td><?= $user_list ?></td>
            <td><?= $gross_amount ?></td>
            <td><?= $gst ?></td>
            <td><?= $pb_invoice_amt ?></td>
            <td><?= $invoice_date ?></td>
            <td><?= $sbi_payment ?></td>
            <td><?= date('F d, Y h:i A', strtotime($entries[0]['cancelled_date'])) ?></td>
            <td><?= $entries[0]['staff_fullname'] ?></td>
        </tr>
        <?php
    }
} else {
    ?>
    <tr><td colspan="5" align="center">Sorry no records available!</td></tr>
<?php } ?>

                    </tbody>
                </table>
            </div>
            <?//= $pagination ?>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "lengthChange": true,
        "lengthMenu": [[10, 25, 50, 200, -1], [10, 25, 50, 200, "All"]],
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Cancelled RBO Invoice Log');
                }
            }
        ]
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
});
</script>

<style>
    .dataTables_length {
        margin-bottom: 13px;
    }
    .dataTables_filter {
        margin-top: 12px;
    }
</style>
