<?php

class Pbsbiannx_download_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
    }

    private function apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, 
    $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$team_leader,$circle,$pb_branch_annx_no_blank,$pb_branch_annx_date_blank) {
        // convert incoming dates to Y-m-d to be safe
        if (!empty($start_date) && !empty($end_date)) {
    $start = date('Y-m-d', strtotime($start_date));
    $end   = date('Y-m-d', strtotime($end_date));
    $this->db->where("DATE(mst_user.disb_date) BETWEEN '".$start."' AND '".$end."'");
}


        if (!empty($status)) {
            $this->db->where('mst_user.status', $status);
        }
        if (!empty($conn_id)) {
            $this->db->where('mst_user.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('mst_user.branch_id', $branch_id);
        }
        if (!empty($applicant_invoice_status)) {
            $this->db->where('mst_user.applicant_invoice_status IS NULL');
        }
        if (!empty($sbi_genrated)) {
            $this->db->where('mst_user.pb_genrated', $sbi_genrated);
        }
        if (!empty($hlc_invoice_status)) {
            $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
        }
        if (!empty($city_id)) {
            $this->db->where_in('mst_user.city_id', $city_id);
        }
        
       if (!empty($hlc_paid_status)) {
        $this->db->group_start(); // Start OR group
    
        if (in_array('unpaid', $hlc_paid_status)) {
            $this->db->or_where('mst_user.hlc_payment_status IS NULL', null, false);
            $this->db->where('mst_user.disb_status', 'yes'); // Apply only if globally required
        }
    
        // Filter out 'unpaid' and handle the rest
        $other_hlc_statuses = array_diff($hlc_paid_status, ['unpaid']);
    
        if (!empty($other_hlc_statuses)) {
            $this->db->or_where_in('mst_user.hlc_payment_status', $other_hlc_statuses);
        }
    
        $this->db->group_end(); // End OR group
    }


    if (!empty($pb_payment_status)) {
        $this->db->group_start(); // Start a group of OR conditions
    
        if (in_array('unpaid', $pb_payment_status)) {
            $this->db->or_where('mst_user.pb_payment_status IS NULL', null, false);
            $this->db->where('mst_user.pb_genrated', 'Yes'); // Keep outside if it applies to all
        }
    
        // Remove 'unpaid' and check remaining statuses
        $other_statuses = array_diff($pb_payment_status, ['unpaid']);
    
        if (!empty($other_statuses)) {
            $this->db->or_where_in('mst_user.pb_payment_status', $other_statuses);
        }
    
        $this->db->group_end(); // End OR group
    }


        if (!empty($disb_month_year)) {
            list($disb_year, $disb_month) = explode('-', $disb_month_year);
            $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
            $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
        }
         if (!empty($pb_generated)) {
            $this->db->where('mst_user.pb_genrated', $pb_generated);
        }
         if (!empty($branch_generated)) {
             if($branch_generated==='No'){
                 $this->db->where('mst_user.branch_genrated', NULL, true);
             }else{
                 $this->db->where('mst_user.branch_genrated', $branch_generated);
             }
        }
         if (!empty($partner_generated)) {
             if($partner_generated==='No'){
                 $this->db->where('mst_user.applicant_invoice_status', NULL, true);
             }else{
                 $this->db->where('mst_user.applicant_invoice_status', 'Generated');
             }
        }
        if (!empty($rbo)) {
        $this->db->where('branch.rbo_id', $rbo);
    }
    
    if (!empty($created_by_part)) {
            $this->db->where('created_by_staff.staff_fullname', $created_by_part);
        }
        
    if (!empty($team_leader)) {
        
        $this->db->where('created_by_staff.team_leader', $team_leader);
    }
    
    if (!empty($circle)) {
        $this->db->where('branch.circle_id', $circle);
    }
    
      if (!empty($pb_branch_annx_no_blank)) {
                if ($pb_branch_annx_no_blank === 'No') {
                    // Exclude NULL entries (Only show non-blank values)
                    $this->db->where('mst_user.pb_branch_annx_no IS NOT NULL', null, false);
                } elseif ($pb_branch_annx_no_blank === 'Yes') {
                    // Only show blank (NULL) entries
                    $this->db->where('mst_user.pb_branch_annx_no', NULL, true);
                } 
            }
      if (!empty($pb_branch_annx_date_blank)) {
                if ($pb_branch_annx_date_blank === 'No') {
                    // Exclude NULL entries (Only show non-blank values)
                    $this->db->where('mst_user.pba_input_date IS NOT NULL', null, false);
                } elseif ($pb_branch_annx_date_blank === 'Yes') {
                    // Only show blank (NULL) entries
                    $this->db->where('mst_user.pba_input_date', NULL, true);
                } 
            }
        
        

        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like('mst_user.user_name', $search);
            $this->db->or_like('mst_user.los_id', $search);
            $this->db->or_like('mst_user.bank_acct_no', $search);
            $this->db->or_like('mst_user.user_phone', $search);
            $this->db->or_like('mst_user.user_email', $search);
            $this->db->or_like('mst_user.user_address', $search);
            $this->db->or_like('mst_user.applicant_rr_id', $search);
            $this->db->or_like('mst_user.rr_cbs_acct_no', $search);
            $this->db->or_like('mst_user.sanction_amt', $search);
            $this->db->or_like('mst_user.status', $search);
            $this->db->or_like('mst_user.disb_status', $search);
            $this->db->or_like('mst_user.hlc_payment_status', $search);
            $this->db->or_like('mst_user.pb_payment_status', $search);
            $this->db->or_like('mst_user.login_code', $search);
            $this->db->or_like('branch.branch_name', $search);
            $this->db->or_like('branch.branch_code', $search);
            $this->db->or_like('mst_city.city_name', $search);
            $this->db->or_like('mst_city.agency_code', $search);
            $this->db->or_like('mst_city.agency_name', $search);
            $this->db->or_like('mst_rbo.rbo_name', $search);
            $this->db->or_like('mst_loan_type.name', $search);
            $this->db->or_like('mst_staff.staff_fullname', $search);
            $this->db->or_like('mst_staff.hlc_code', $search);
            $this->db->or_like('created_by_staff.staff_fullname', $search);
            $this->db->group_end();
        }

        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);            
        }
        
    }

    public function get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year ,$pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$team_leader,$circle,$pb_branch_annx_no_blank,$pb_branch_annx_date_blank) {
        $this->db->select('mst_user.*, mst_staff.staff_fullname, mst_loan_type.name as user_type, branch.branch_name, branch.branch_code, mst_city.city_name, mst_rbo.rbo_name,created_by_staff.staff_fullname as created_by_fullname,created_by_staff.team_leader');
        /* $this->db->select('mst_user.id, mst_user.user_name, mst_user.status, mst_user.sanction_amt, mst_user.disb_status,mst_user.loan_type_id,mst_user.invoice_id,
        mst_user.bank_acct_no, mst_user.rr_cbs_acct_no, mst_user.pb_payment_status, mst_user.hlc_payment_status, mst_user.part_payout,mst_user.state_id,mst_user.pb_invoice_id,
        mst_user.todays_payment,mst_user.payment_approve_status,mst_user.los_id,mst_user.rinnraksha_status,mst_user.applicant_invoice_status,mst_user.sbi_pb_payment_status,
        mst_user.connector_id, mst_user.branch_id, mst_user.city_id, mst_user.disb_date,mst_user.pb_genrated,mst_user.sbi_pb_invoice_no,mst_user.pb_branch_conf_no,mst_user.add_date,
        mst_user.verify_by,mst_user.is_verify,mst_user.archive_remark,mst_user.payment_act_remark,mst_user.user_phone,mst_user.user_email,mst_user.user_address,mst_user.rinnraksha_amt,
        mst_staff.staff_fullname, mst_loan_type.name as user_type, branch.branch_name, branch.branch_code, mst_city.city_name, mst_rbo.rbo_name,created_by_staff.staff_fullname as created_by_fullname');*/
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
        $this->db->join('mst_staff as created_by_staff', 'mst_staff.created_by = created_by_staff.staff_id', 'left');
        $this->db->where('mst_user.login_code', 'PaisaBazaar');
        $this->db->where('mst_user.is_archive', 'No');
        $this->db->where('mst_user.is_verify', 1);
        $this->db->where('mst_user.pbsbi_branch_annx_download_status', 0);
       
        $this->apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status,$disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$team_leader,$circle,$pb_branch_annx_no_blank,$pb_branch_annx_date_blank,$pb_branch_annx_date_blank);

        if ($limit != -1) {
            if ($limit != '' && $offset != '') {
                $this->db->limit($limit, $offset);
            } elseif ($limit != '') {
                $this->db->limit($limit);
            }
        }
        
      
        
        $this->db->order_by('mst_user.add_date', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year , $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$team_leader,$circle,$is_pb_branch_annx_no_blank,$pb_branch_annx_date_blank) {
        $this->db->select('COUNT(*) as total');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
         $this->db->join('mst_staff as created_by_staff', 'mst_staff.created_by = created_by_staff.staff_id', 'left');
        $this->db->where('mst_user.login_code', 'PaisaBazaar');
        $this->db->where('mst_user.is_archive', 'No');
        $this->db->where('mst_user.is_verify', 1);
        $this->db->where('mst_user.pbsbi_branch_annx_download_status', 0);
       
        $this->apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, 
        $hlc_paid_status, $city_id, $pb_payment_status, $disb_month_year , $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$team_leader,$circle,$is_pb_branch_annx_no_blank,$pb_branch_annx_date_blank);
        
        $staff_type = $this->session->userdata('staff_type');
         if ($staff_type == 1) {
        // If staff_type is 1, limit the data to the current staff
        $current_staff_id = $this->session->userdata('staff_id');
        $this->db->where('mst_user.connector_id', $current_staff_id);
        }
        
        $query = $this->db->get();
        return $query->row()->total;
    }
    
    
  



    
}
?>
