<?php

class Payment_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        
       
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
        
    }

    private function apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part) {
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("mst_user.add_date >=", $start_date);
            $this->db->where("mst_user.add_date <=", date('Y-m-d', strtotime($end_date . ' +1 day')));
        }
        if (!empty($status)) {
            $this->db->where('mst_user.status', $status);
            // Check if status is 'Disb Case' and add a condition for `disb_date` to not be null.
            if ($status === 'Disb Case') {
                $this->db->where('mst_user.disb_date IS NOT NULL');
            }
        }
        if (!empty($conn_id)) {
            $this->db->where('mst_user.connector_id', $conn_id);
        }
        if (!empty($branch_id)) {
            $this->db->where('mst_user.branch_id', $branch_id);
        }
        
        if (!empty($applicant_invoice_status)) {
            $this->db->where('mst_user.applicant_invoice_status IS NULL');
        }
        if (!empty($sbi_genrated)) {
            $this->db->where('mst_user.sbi_genrated', $sbi_genrated);
        }
        if (!empty($hlc_invoice_status)) {
            $this->db->where('mst_user.applicant_invoice_status', $hlc_invoice_status);
        }
        if (!empty($city_id)) {
            $this->db->where('mst_user.city_id', $city_id);
        }
        if (!empty($hlc_paid_status)) {
            if ($hlc_paid_status === 'unpaid') {
                $this->db->where('mst_user.hlc_payment_status', NULL, true);
                $this->db->where('mst_user.disb_status', 'yes');
            } else {
                $this->db->where('mst_user.hlc_payment_status', $hlc_paid_status);
            }
        }
        if (!empty($sbi_payment_status)) {
            if ($sbi_payment_status === 'unpaid') {
                $this->db->where('mst_user.sbi_payment_status', NULL, true);
                $this->db->where('mst_user.sbi_genrated', 'Yes');
            } else {
                $this->db->where('mst_user.sbi_payment_status', $sbi_payment_status);
            }
        }
        if (!empty($disb_month_year)) {
            list($disb_year, $disb_month) = explode('-', $disb_month_year);
            $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
            $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
        }
         if (!empty($sbi_generated)) {
            $this->db->where('mst_user.sbi_genrated', $sbi_generated);
        }
         if (!empty($branch_generated)) {
             if($branch_generated==='No'){
                 $this->db->where('mst_user.branch_genrated', NULL, true);
             }else{
                 $this->db->where('mst_user.branch_genrated', $branch_generated);
             }
        }
         if (!empty($partner_generated)) {
             if($partner_generated==='No'){
                 $this->db->where('mst_user.applicant_invoice_status', NULL, true);
             }else{
                 $this->db->where('mst_user.applicant_invoice_status', 'Generated');
             }
        }
        
        if (!empty($rbo)) {
            $this->db->where('branch.rbo_id', $rbo);
        }
        if (!empty($created_by_part)) {
            $this->db->where('created_by_staff.staff_fullname', $created_by_part);
        }

        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like('mst_user.user_name', $search);
            $this->db->or_like('mst_user.los_id', $search);
            $this->db->or_like('mst_user.bank_acct_no', $search);
            $this->db->or_like('mst_user.user_phone', $search);
            $this->db->or_like('mst_user.user_email', $search);
            $this->db->or_like('mst_user.user_address', $search);
            $this->db->or_like('mst_user.applicant_rr_id', $search);
            $this->db->or_like('mst_user.rr_cbs_acct_no', $search);
            $this->db->or_like('mst_user.sanction_amt', $search);
            $this->db->or_like('mst_user.status', $search);
            $this->db->or_like('mst_user.disb_status', $search);
            $this->db->or_like('mst_user.hlc_payment_status', $search);
            $this->db->or_like('mst_user.sbi_payment_status', $search);
            $this->db->or_like('branch.branch_name', $search);
            $this->db->or_like('branch.branch_code', $search);
             $this->db->or_like('mst_city.city_name', $search);
            $this->db->or_like('mst_city.agency_code', $search);
            $this->db->or_like('mst_city.agency_name', $search);
            $this->db->or_like('mst_rbo.rbo_name', $search);
            $this->db->or_like('mst_loan_type.name', $search);
            $this->db->or_like('mst_staff.staff_fullname', $search);
            $this->db->or_like('mst_staff.hlc_code', $search);
            $this->db->or_like('created_by_staff.staff_fullname', $search);
            $this->db->group_end();
        }

        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
    }

    public function get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $sbi_payment_status, $disb_month_year ,$sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part) {
        $this->db->select('mst_user.*, mst_staff.staff_fullname, mst_loan_type.name as user_type, branch.branch_name, branch.branch_code, mst_city.city_name, mst_city.agency_code,mst_city.agency_name, mst_rbo.rbo_name,created_by_staff.staff_fullname as created_by_fullname');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'mst_user.city_id = mst_city.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
        $this->db->join('mst_staff as created_by_staff', 'mst_staff.created_by = created_by_staff.staff_id', 'left');
        $this->db->where('mst_user.is_archive', 'No');
        $this->db->where('mst_user.todays_payment', 'Yes');
        $this->db->where("(mst_user.payment_approve_status = 1 OR mst_user.payment_approve_status IS NULL)", NULL, FALSE);

       
        $this->apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part);

        if ($limit != -1) {
            if ($limit != '' && $offset != '') {
                $this->db->limit($limit, $offset);
            } elseif ($limit != '') {
                $this->db->limit($limit);
            }
        }
        
      
        
        $this->db->order_by('mst_user.add_date', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $sbi_payment_status, $disb_month_year , $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part) {
        $this->db->select('COUNT(*) as total');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'mst_user.city_id = mst_city.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
        $this->db->join('mst_staff as created_by_staff', 'mst_staff.created_by = created_by_staff.staff_id', 'left');
        $this->db->where('mst_user.is_archive', 'No');
        $this->db->where('mst_user.todays_payment', 'Yes');
       $this->db->where("(mst_user.payment_approve_status = 1 OR mst_user.payment_approve_status IS NULL)", NULL, FALSE);

       
        $this->apply_filters($search, $start_date, $end_date, $status, $conn_id, $branch_id, $applicant_invoice_status, $sbi_genrated, $hlc_invoice_status, $hlc_paid_status, $city_id, $sbi_payment_status, $disb_month_year , $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part);
        
        $staff_type = $this->session->userdata('staff_type');
         if ($staff_type == 1) {
        // If staff_type is 1, limit the data to the current staff
        $current_staff_id = $this->session->userdata('staff_id');
        $this->db->where('mst_user.connector_id', $current_staff_id);
        }
        
        $query = $this->db->get();
        return $query->row()->total;
    }
}
?>
