<?php

class Partner_unpaid_model extends CI_Model {

public function __construct() {
    
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
        
    }


public function get_invoice_data($start_date, $end_date, $conn_id, $branch_id, $limit, $offset, $city_id, $disb_month_year, $search = '') {
    $this->db->select('
        invoices.inv_batchno,
        invoices.invoice_number,
        invoices.invoice_date,
        invoices.partner_unpaid_remark,
        invoices.add_date,
        mst_user.connector_id,
        invoices.created_by,
        mst_user.disb_date,
        mst_user.user_name,
        mst_user.id as user_id,
        mst_staff.staff_fullname,
        mst_staff.staff_id as staff_id,
        branch.branch_name,
        branch.id as branch_id,
        mst_city.city_name as hlc_city_name,
        mst_city.id as hlc_city_id
    ');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('branch', 'invoices.branch_id = branch.id');
    $this->db->join('mst_city', 'mst_staff.city_id = mst_city.id', 'left');

    if (!empty($start_date)) {
        $this->db->where("invoices.disb_date >=", $start_date);
    }
    if (!empty($end_date)) {
        $this->db->where("invoices.disb_date <=", $end_date);
    }
   
    if (!empty($conn_id)) {
        $this->db->where('mst_user.connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('invoices.branch_id', $branch_id);
    }
    if (!empty($city_id)) {
        $this->db->where('branch.city_id', $city_id);
    }
    if (!empty($disb_month_year)) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year);
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
    
    $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }
    
    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_user.user_name', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search);
        $this->db->or_like('branch.branch_name', $search);
        $this->db->or_like('invoices.invoice_number', $search);
        $this->db->group_end();
    }

    $this->db->where('invoices.invoice_type', 'inv_hlc');
    $this->db->where('invoices.hlc_status IS NULL',null, false);
    $this->db->group_by('invoices.inv_batchno');
    $this->db->order_by('invoices.add_date', 'DESC');


    if ($limit != '' && $limit != -1) {
        $this->db->limit($limit, $offset);
    }
    
    $query = $this->db->get();
    return $query->result_array();
}



public function count_all_invoices($start_date, $end_date, $conn_id, $branch_id, $city_id, $disb_month_year,$search = '') {
    $this->db->select('invoices.inv_batchno');
    $this->db->from('invoices');
    $this->db->join('mst_user', 'invoices.user_id = mst_user.id');
    $this->db->join('mst_staff', 'invoices.connector_id = mst_staff.staff_id');
    $this->db->join('branch', 'invoices.branch_id = branch.id');

    if (!empty($start_date)) {
        $this->db->where("invoices.add_date >=", $start_date);
    }
    if (!empty($end_date)) {
        $this->db->where("invoices.add_date <=", $end_date);
    }
    if (!empty($conn_id)) {
        $this->db->where('invoices.connector_id', $conn_id);
    }
    if (!empty($branch_id)) {
        $this->db->where('invoices.branch_id', $branch_id);
    }
    if (!empty($city_id)) {
        $this->db->where('branch.city_id', $city_id);
    }
    if (!empty($disb_month_year) && strpos($disb_month_year, '-') !== false) {
        list($disb_year, $disb_month) = explode('-', $disb_month_year);
        $this->db->where('MONTH(mst_user.disb_date)', $disb_month);
        $this->db->where('YEAR(mst_user.disb_date)', $disb_year);
    }
    $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            // If staff_type is 1, limit the data to the current staff
            $current_staff_id = $this->session->userdata('staff_id');
            $this->db->where('mst_user.connector_id', $current_staff_id);
        }

    if (!empty($search)) {
        $this->db->group_start();
        $this->db->like('mst_user.user_name', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search);
        $this->db->or_like('branch.branch_name', $search);
        $this->db->or_like('invoices.invoice_number', $search);
        $this->db->group_end();
    }
    $this->db->where('invoices.invoice_type', 'inv_hlc');
    $this->db->where('invoices.hlc_status IS NULL', null, false);
    $this->db->group_by('invoices.inv_batchno');
    return $this->db->count_all_results();
}



}
?>
