<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Include the Composer autoloader
require_once FCPATH . 'vendor_new/autoload.php';

// Import PhpSpreadsheet classes
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Pb_excel_applicant extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->model('common_model', 'ccm'); // Load your model
    }

    
      public function index() {
          
        $start_date        = $this->input->get('start_date');
        $end_date          = $this->input->get('end_date');
        $branch            = $this->input->get('branch');
        $connector         = $this->input->get('connector');
        $hlc_status        = $this->input->get('hlc_status');
        $state_id          = $this->input->get('state_id');
        $city_id           = $this->input->get('city_id');
        $disb_month        = $this->input->get('month');
       
   
        // 2. Build an array of filters
        $filters = [
            'start_date'         => $start_date,
            'end_date'           => $end_date,
            'branch'             => $branch,
            'connector'          => $connector,
            'hlc_status'         => $hlc_status,
            'state_id'           => $state_id,
            'city_id'            => $city_id,
            'disb_month'         => $disb_month
        ];


        // Fetch data
        $invoices = $this->ccm->get_invoice_pb_applicant_list($filters);
       
        // Group the invoices by branch_code
        $grouped_invoices = [];
        foreach ($invoices as $invoice) {
            $loan_amount = ($invoice['loan_type_id'] == 5) ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];
            $commission_rate = floatval($invoice['pb_commi']) / 100;
            $amt_100 = $this->calculatePB($invoice['loan_type_id'], $loan_amount);
            $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $invoice['invoice_id']])->get()->row();
            $inv_pb_data = $this->db->select("*")->from('invoices')->where(['id' => $invoice['pb_invoice_id']])->get()->row();
            $created_by = $this->db->select("*")->where(['staff_id' => $invoice['connector_id']])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $admin_verify_applicant = $this->db->select('staff_fullname')->where(['staff_id' => $invoice['verify_by']])->from('mst_staff')->get()->row();
            if($invoice['is_verify'] == 1){
                $pb_verified = 'Verified';
            }else{
                $pb_verified = 'Non-verified';
            }

            $grouped_invoices[$invoice['login_code']]['invoices'][] = array_merge($invoice, [
                'loan_amount' => $loan_amount,
                '100_amt' => $amt_100,
                'hlc_inv_no' => @$inv_hlc_data->invoice_number,
                'pb_inv_no' => @$inv_pb_data->invoice_number,
                'hlc_created_by' => $admin_created_hlc->staff_fullname,
                'verified' => $pb_verified,
                'verify_by' => @$admin_verify_applicant->staff_fullname,
            ]);

            // Accumulate totals
           // $grouped_invoices[$invoice['login_code']]['totals']['100_amt'] += $amt_100;
        }

        // Create a new spreadsheet instance
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Set table header
        $headers = [
            'Sr.No.', 'Los Id & RLMS ID', 
            'CBS A/c NO', 'Name of Borrower', 'Type of Loan', 
            'Date of disb.', 'Loan Limit', 'Renumeration @ %', 'Remuneration', 'SPOC', 'Branch', 'Branch Code', 'TEAM', 'RBO',
            'Partner Name','Partner Code','State','City','Partner Payout %','Partner Payout Amt','Status','Partner Generated','Partner Payment Status','PB Generated',
            'PB Payment Status','Add Date','Created By','Verify','Verified By','Appraisal','FSL','Proof Disb','Agency Code','Agency Name','SBI PB Invoice No','SBI Payment Status','Remuneration(0.95%)' 
        ];

        $colIndex = 'A';
        foreach ($headers as $header) {
            $sheet->setCellValue($colIndex . '1', $header);
            $sheet->getStyle($colIndex . '1')->getFont()->setBold(true);
            $colIndex++;
        }

        // Write data to the sheet
        $row = 2;
        $serial_number = 1;

        foreach ($grouped_invoices as $login_code => $group) {
            foreach ($group['invoices'] as $invoice) {
                // RR Commission row handling
                if ($invoice['loan_type_id'] == 5) {
                    $invoice['is_rr_commission'] = true;  // Mark as RR commission row
                    $invoice['commission'] = $this->calculate_rr_commission($invoice);  
                }

                // Regular invoice row
                $sheet->setCellValue('A' . $row, $serial_number++);   
                
                $sheet->setCellValue('B' . $row, $invoice['los_id']); 
                $sheet->getStyle('B' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);

                $sheet->setCellValue('C' . $row, ($invoice['loan_type_id'] == 5) ? $invoice['rr_cbs_acct_no'] : $invoice['bank_acct_no']);
                $sheet->setCellValue('D' . $row, $invoice['user_name']);
                $sheet->setCellValue('E' . $row, $invoice['account_type']); //type loan
                $disb_date = !empty($invoice['disb_date']) ? strtotime($invoice['disb_date']) : null;

                $sheet->setCellValue('F' . $row, $disb_date ? date('d-M-y', $disb_date) : '');

                
                $sheet->setCellValue('G' . $row, $invoice['loan_amount']);
                $sheet->getStyle('G' . $row)->getNumberFormat()->setFormatCode('#,##0');
                
                $sheet->setCellValue('H' . $row, $this->calculatePBPercent($invoice['loan_type_id'],$invoice['loan_amount']) . '%');
                
                $sheet->setCellValue('I' . $row, $invoice['100_amt']);
                $sheet->getStyle('I' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
                
                $sheet->setCellValue('J' . $row, 'MORTGAGEBUDDY PRIVATE LIMITED');
                
                
                $sheet->setCellValue('K' . $row, $invoice['branch_name']);
                $sheet->setCellValue('L' . $row, $invoice['branch_code']);
                $sheet->getStyle('L' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                
                $sheet->setCellValue('M' . $row, 'MB-'.$invoice['city_name']);
                
                $sheet->setCellValue('N' . $row, $invoice['rbo_name']);
                
                $sheet->setCellValue('O' . $row, $invoice['staff_fullname']);
                $sheet->setCellValue('P' . $row, $invoice['hlc_code']);
                $sheet->setCellValue('Q' . $row, $invoice['state_name']);
                $sheet->setCellValue('R' . $row, $invoice['city_name']);
                $sheet->setCellValue('S' . $row, ($invoice['loan_type_id'] == 4) ? number_format(0.20, 2).'%' : $invoice['part_payout']. '%');
                $loan_amount = str_replace(',', '', $invoice['loan_amount']); // Remove commas if present
$loan_amount = is_numeric($loan_amount) ? (float) $loan_amount : 0; // Convert to float safely

$part_payout = str_replace(',', '', $invoice['part_payout']); // Remove commas if present
$part_payout = is_numeric($part_payout) ? (float) $part_payout : 0; // Convert to float safely

$rate = ($invoice['loan_type_id'] == 4) ? 0.20 / 100 : ($part_payout / 100);

$sheet->setCellValue('T' . $row, formatIndianNumber($loan_amount * $rate));

                $sheet->setCellValue('U' . $row, $invoice['status']);
                $sheet->setCellValue('V' . $row, ($invoice['applicant_invoice_status'] == 'Generated') ? $invoice['hlc_inv_no'] : 'No');
                $sheet->setCellValue('W' . $row, $invoice['hlc_payment_status']);
                $sheet->setCellValue('X' . $row, ($invoice['pb_genrated'] == 'Yes') ? $invoice['pb_inv_no'] : 'No');
                $sheet->setCellValue('Y' . $row, $invoice['pb_payment_status']);
                $sheet->setCellValue('Z' . $row, date('d-m-Y', strtotime($invoice['add_date'])));
                $sheet->setCellValue('AA' . $row, $invoice['hlc_created_by']);
                $sheet->setCellValue('AB' . $row, $invoice['verified']);
                 $sheet->setCellValue('AC' . $row, $invoice['verify_by']);
                
                // Add attachment hyperlinks for regular row
                $this->add_attachment_hyperlinks($sheet, $row, $invoice);
                
                $sheet->setCellValue('AG' . $row, $invoice['agency_code']);
                $sheet->setCellValue('AH' . $row, $invoice['agency_name']);
                $sheet->setCellValue('AI' . $row, $invoice['sbi_pb_invoice_no']);
                $sheet->setCellValue('AJ' . $row, $invoice['sbi_pb_payment_status']);
                
                $rateRemu = ($invoice['loan_type_id'] == 4) ? 0.20 / 100 : (0.95 / 100);
                $sheet->setCellValue('AK' . $row, ($loan_amount * $rateRemu));
                
                // If RR Commission, add a separate row
                if (isset($invoice['is_rr_commission'])) {
                    $row++;  // Move to the next row for RR Commission
                    $sheet->setCellValue('A' . $row, $serial_number++);
                    $sheet->setCellValue('B' . $row, $invoice['los_id']);
                    $sheet->getStyle('B' . $row)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_NUMBER);

                    $sheet->setCellValue('C' . $row, $invoice['rr_cbs_acct_no']);
                    $sheet->setCellValue('D' . $row, $invoice['user_name']);
                    $sheet->setCellValue('E' . $row, 'RR Commission');  // Mark as RR Commission ln type
                    $disb_date = isset($invoice['disb_date']) && !empty($invoice['disb_date']) ? strtotime($invoice['disb_date']) : null;

$sheet->setCellValue('F' . $row, $disb_date ? date('d-M-y', $disb_date) : '');

                    $sheet->setCellValue('G' . $row, '');  // No loan amount for RR Commission
                    
                    $sheet->setCellValue('H' . $row, 'Fixed');  // Fixed commission
                    $sheet->setCellValue('I' . $row, $invoice['commission']);  // RR Commission amount
                    $sheet->getStyle('I' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
                    $sheet->setCellValue('J' . $row, 'MORTGAGEBUDDY PRIVATE LIMITED');
                    $sheet->setCellValue('K' . $row, $invoice['branch_name']);
                    $sheet->setCellValue('L' . $row, $invoice['branch_code']);
                    $sheet->getStyle('L' . $row)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                    
                    $sheet->setCellValue('M' . $row, 'MB-'.$invoice['city_name']);
                    
                    $sheet->setCellValue('N' . $row, $invoice['rbo_name']);
                    
                    $sheet->setCellValue('O' . $row, $invoice['staff_fullname']);
                    $sheet->setCellValue('P' . $row, $invoice['hlc_code']);
                    $sheet->setCellValue('Q' . $row, $invoice['state_name']);
                    $sheet->setCellValue('R' . $row, $invoice['city_name']);
                    $sheet->setCellValue('S' . $row, ($invoice['loan_type_id'] == 4) ? number_format(0.20, 2).'%' : $invoice['part_payout']. '%');
                    // Ensure loan_amount is numeric
                    $loan_amount = isset($invoice['loan_amount']) ? str_replace(',', '', $invoice['loan_amount']) : '0';
                    $loan_amount = is_numeric($loan_amount) ? (float) $loan_amount : 0;
                    
                    // Ensure part_payout is numeric
                    $part_payout = isset($invoice['part_payout']) ? str_replace(',', '', $invoice['part_payout']) : '0';
                    $part_payout = is_numeric($part_payout) ? (float) $part_payout : 0;
                    
                    // Calculate percentage based on loan_type_id
                    $rate = ($invoice['loan_type_id'] == 4) ? 0.20 / 100 : ($part_payout / 100);
                    
                    // Apply calculation safely
                    $sheet->setCellValue('T' . $row, formatIndianNumber($loan_amount * $rate));

                    $sheet->setCellValue('U' . $row, $invoice['status']);
                    $sheet->setCellValue('V' . $row, ($invoice['applicant_invoice_status'] == 'Generated') ? $invoice['hlc_inv_no'] : 'No');
                    $sheet->setCellValue('W' . $row, $invoice['hlc_payment_status']);
                    $sheet->setCellValue('X' . $row, ($invoice['pb_genrated'] == 'Yes') ? $invoice['pb_inv_no'] : 'No');
                    $sheet->setCellValue('Y' . $row, $invoice['pb_payment_status']);
                    $sheet->setCellValue('Z' . $row, date('d-m-Y', strtotime($invoice['add_date'])));
                     $sheet->setCellValue('AA' . $row, $invoice['hlc_created_by']);
                     $sheet->setCellValue('AB' . $row, $invoice['verified']);
                     $sheet->setCellValue('AC' . $row, $invoice['verify_by']);

                    
                    // Add attachment hyperlinks for RR Commission row as well
                    $this->add_attachment_hyperlinks($sheet, $row, $invoice);
                    
                    $sheet->setCellValue('AG' . $row, $invoice['agency_code']);
                    $sheet->setCellValue('AH' . $row, $invoice['agency_name']);
                    $sheet->setCellValue('AI' . $row, $invoice['sbi_pb_invoice_no']);
                    $sheet->setCellValue('AJ' . $row, $invoice['sbi_pb_payment_status']);
                  
                    
                }

                // Move to the next row
                $row++;
            }

            // Add a blank row after each branch group
            //$row++;
        }
          
          
       $sheet->getStyle('A1:R' . $row)
    ->getAlignment()
    ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    
        // Auto-size columns
        foreach (range('A', 'R') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }

        // Clear output buffer before generating the file
       // Clear output buffer before generating the file
        if (ob_get_level() > 0) {
            ob_end_clean();
        }


        // Set headers for the file
        $filename = "PB_APPLICANT_LIST_" . date('Ymd') . ".xlsx";
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // Generate Excel file
        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
        exit;
    }



  private function add_attachment_hyperlinks($sheet, $row, $invoice) {
        // Fetch attachments for the current invoice
        $latest_letter_apprisal = $this->db->select('appraisal_letter')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('appraisal_letter IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        $latest_letter_fsl = $this->db->select('final_sanction_letter')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('final_sanction_letter IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        $latest_letter_pd = $this->db->select('proof_disb')
            ->from('appraisal_letters')
            ->where('user_id', $invoice['id'])
            ->where('proof_disb IS NOT NULL')
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row_array();

        // Add hyperlinks to the sheet for each attachment
        if (!empty($latest_letter_apprisal['appraisal_letter'])) {
            $link1 = base_url('assets/uploads/documents/' . $latest_letter_apprisal['appraisal_letter']);
            $sheet->setCellValue('AD' . $row, 'Click');
            $sheet->getCell('AD' . $row)->getHyperlink()->setUrl($link1);
            $sheet->getStyle('AD' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }

        if (!empty($latest_letter_fsl['final_sanction_letter'])) {
            $link2 = base_url('assets/uploads/documents/' . $latest_letter_fsl['final_sanction_letter']);
            $sheet->setCellValue('AE' . $row, 'Click');
            $sheet->getCell('AE' . $row)->getHyperlink()->setUrl($link2);
            $sheet->getStyle('AE' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }

        if (!empty($latest_letter_pd['proof_disb'])) {
            $link3 = base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']);
            $sheet->setCellValue('AF' . $row, 'Click');
            $sheet->getCell('AF' . $row)->getHyperlink()->setUrl($link3);
            $sheet->getStyle('AF' . $row)->applyFromArray([
                'font' => ['color' => ['rgb' => '0000FF'], 'underline' => 'single']
            ]);
        }
    }
    
    // RR Commission calculation method
    private function calculate_rr_commission($invoice) {
    // Fetch the main account details
    $rr_main_account = $this->db->select("*")
        ->where(['applicant_rr_id' => $invoice['id'], 'rinnraksha_status' => 'Yes'])
        ->from('mst_user')
        ->get()
        ->row();

    $commission = 0; // Initialize the commission

    // Apply commission slabs
    if ($rr_main_account->sanction_amt < 5000000) { // Below 50 Lacs
        $commission = 4000;
    } elseif ($rr_main_account->sanction_amt == 5000000) { // Exactly 50 Lacs
        $commission = 5000;
    } elseif ($rr_main_account->sanction_amt > 5000000 && $rr_main_account->sanction_amt <= 10000000) { // Above 50 Lacs to 1 Cr
        $commission = 5000;
    } elseif ($rr_main_account->sanction_amt > 10000000) { // Above 1 Cr
        $commission = 6000;
    }

    return $commission; // Return the calculated commission
}

    
    
   function calculatePB($loan_type, $loan_amount) {
    // Ensure loan_amount is a valid numeric value
    $loan_amount = str_replace(',', '', $loan_amount); // Remove commas if present
    $loan_amount = is_numeric($loan_amount) ? (float) $loan_amount : 0; // Convert to float safely

    switch ($loan_type) {
        case '6': // LAP
            if ($loan_amount < 5000000) { // Less than Rs 50 Lacs
                return (0.30 * $loan_amount) / 100; // 30% commission
            } elseif ($loan_amount == 5000000) { // Exactly Rs 50 Lacs
                return (0.30 * $loan_amount) / 100; // 30% commission
            } elseif ($loan_amount > 5000000) { // Greater than Rs 50 Lacs
                return (0.35 * $loan_amount) / 100; // 35% commission
            } else {
                return 0; // Default case to avoid null values
            }

        case '5': // RinnRaksha
            return (0.80 * $loan_amount) / 100;

        case '1':  // New
        case '2': // Takeover
        case '3':  // Takeover+TopUp
            return (0.80 * $loan_amount) / 100;

        case '4':  // Top Up
            return (0.20 * $loan_amount) / 100;

        default:
            return 0; // Return 0 instead of null to avoid unexpected issues
    }
}
 
    
    
    /*function calculatePB($loan_type, $loan_amount) {
    switch ($loan_type) {
       case '6': // LAP
            if ($loan_amount < 5000000) { // Less than Rs 50 Lacs
                return 0.30 * $loan_amount / 100; // 30% commission
            } elseif ($loan_amount == 5000000) { // Exactly Rs 50 Lacs
                return 0.30 * $loan_amount / 100; // 30% commission
            } elseif ($loan_amount > 5000000) { // Greater than Rs 50 Lacs
                return 0.35 * $loan_amount / 100; // 35% commission
            } else {
                return 0; // Default case to avoid null values
            }
        case '5': //RinnRaksha
                return 0.80 * $loan_amount / 100;
        case '1':  //New
        case '2': //Takeover
        case '3':  //Takeover+TopUp
            return 0.80 * $loan_amount / 100;
        case '4':  //Top Up
            return 0.20 * $loan_amount / 100;
        default:
            return null; // If loan type is not recognized
    }
}*/

function calculatePBPercent($loan_type, $loan_amount) {
    $result = null;

    switch ($loan_type) {
       case '6': // LAP
            if ($loan_amount <= 5000000) { // Up to Rs 50 Lacs
                $result = number_format(0.30, 2); // 30%
            } elseif ($loan_amount > 5000000) { // Above Rs 50 Lacs
                $result = number_format(0.35, 2); // 35%
            } else {
                $result = number_format(0.30, 2); // Default to 30%
            }
            break;
        case '5': // RinnRaksha
            $result = number_format(0.80, 2); // 80%
            break;
        case '1': // New
        case '2': // Takeover
        case '3': // Takeover+TopUp
            $result = number_format(0.80, 2); // 80%
            break;
        case '4': // Top Up
            $result = number_format(0.20, 2); // 20%
            break;
        default:
            $result = null; // Default case if loan type not recognized
    }

    // Log the inputs and calculated percentage
   // log_message('info', 'calculatePBPercent - Loan Type: ' . $loan_type . ', Loan Amount: ' . $loan_amount . ', Result: ' . $result);

    return $result; // Return only the percentage
}





}
