<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Invoice_pdf_hlc extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->library('Invoice_order_hlc');
    }
    
 
function calculateRinnrakshaCommission($sanctionAmt, $commissionRate, $rrStatus, $applicantRRID) {
    $premiumCommission = 0;
    if ($rrStatus == 'Yes' && empty($applicantRRID)) {
        $premiumCommission = $sanctionAmt * $commissionRate / 100;
    }
    return $premiumCommission;
}

function calculatePremiumAmountCommission($sanctionAmtP) {
    $commissionRR = 0;
    if ($sanctionAmtP >= 100000 && $sanctionAmtP < 5000000) {
        $commissionRR = 4000;
    } elseif ($sanctionAmtP >= 5000000 && $sanctionAmtP < 10000000) {
        $commissionRR = 5000;
    } elseif ($sanctionAmtP >= 10000000) {
        $commissionRR = 6000;
    }
    return $commissionRR;
}



function calculateTotalCommission($user_data, $commissionRate ,$loan_type_id) {
    $totalCommission = 0;
    $sanctionAmt =0;
    $regularCommission =0;

    // Calculate Rinnraksha Commission  
    $rinnrakshaCommission = $this->calculateRinnrakshaCommission($user_data->rinnraksha_amt, $commissionRate, $user_data->rinnraksha_status, $user_data->applicant_rr_id);
     
    $rr_aact = $this->db->select("*")->where(['applicant_rr_id' =>  $user_data->id, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
    if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                $rr_sanction_amt = $this->db->select("*")->where(['id' => @$rr_aact->id])->from('mst_user')->get()->row();
                $sanctionAmt = @$rr_sanction_amt->sanction_amt;
    }
     $premiumAmountCommission = $this->calculatePremiumAmountCommission($sanctionAmt);

    // Sum both Rinnraksha commissions
    $totalRinnrakshaCommission = $rinnrakshaCommission + $premiumAmountCommission;

    // Calculate Regular Commission
    if($loan_type_id!=5){
         $regularCommission = $user_data->sanction_amt * $commissionRate / 100;
    }
    
    // Sum both commissions
    $totalCommission = $totalRinnrakshaCommission + $regularCommission;
    
    //echo $totalCommission;

    return $totalCommission;
}


public function generatePDF($invoice_no) {
   
    $data['invoice_items'] = $this->db
    ->select('*')
    ->from('invoices')
    ->where(['inv_batchno' => $invoice_no])
    ->order_by('id', 'asc')
    ->get()
    ->result_array();

    $firstInvoiceItem = reset($data['invoice_items']);
    $connectorID = isset($firstInvoiceItem['connector_id']) ? $firstInvoiceItem['connector_id'] : null;
    $userID = isset($firstInvoiceItem['user_id']) ? $firstInvoiceItem['user_id'] : null;
    $branchID = isset($firstInvoiceItem['branch_id']) ? $firstInvoiceItem['branch_id'] : null;
    $invoiceDate = isset($firstInvoiceItem['invoice_date']) ? $firstInvoiceItem['invoice_date'] : null;
    $invoiceType = isset($firstInvoiceItem['invoice_type']) ? $firstInvoiceItem['invoice_type'] : null;
    $invoiceNumber = isset($firstInvoiceItem['invoice_number']) ? $firstInvoiceItem['invoice_number'] : null;

    $hlc_user = $this->db->select("*")->from('mst_user')->where(['id' => $userID])->get()->row();
    $connector = $this->db->select("*")->from('mst_staff')->where(['staff_id' => $hlc_user->connector_id, 'staff_type' => 1])->get()->row();
    $data['branch'] = $this->db->select("*")->from('branch')->where(['id' => $branchID])->get()->row();
    $paid_invoice = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoice_no])->order_by('add_date', 'DESC')->limit(1)->get()->row();
  
    $data['invoice_date'] = $invoiceDate;
    $data['invoice_type'] = $invoiceType;
    $data['invoice_num'] = $invoiceNumber;

    // Create new TCPDF instance
    $pdf = new Invoice_order_hlc('P', 'mm', 'A4', true, 'UTF-8', false);
    
    $inv_no = str_replace('/', '_', $invoiceNumber);

    // Set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Mortgagebuddy');
    $pdf->SetTitle($invoiceNumber);
    $pdf->SetSubject('Invoice');
    $pdf->SetKeywords('Invoice, PDF, Example');

    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM); // Set auto page breaks

    // Set font
    $pdf->SetFont('dejavusans', '', 6);
    $pdf->SetCellPaddings(1, 2, 1, 1);
    $pdf->SetMargins(10, 20, 10);
    $pdf->AddPage();
    $pdf->SetMargins(10, 45, 10);

    // Set some content to display
    //$html = $this->load->view('admin/manage_invoice/invoice_hlc_pdf', $data, true);
     
    
    $html = '
        <table width="100%">
            <tr>
                <td style="text-align: left; padding-left: 0;">
                    <strong>From</strong><br>
                    Name: ' . $connector->staff_fullname . '<br>
                    Address: <address>' . $connector->staff_address . '</address><br>
                    PAN No.: ' . $connector->pan_no . '<br>
                    GSTIN No.:' . $connector->gst_no . '<br>
                    Mobile No.: ' . $connector->mobile . '<br>
                    E-mail ID:' . $connector->email . '
                </td>
                <td style="text-align: left; padding-left: 0;">
                    <strong>To</strong><br>
                    MORTGAGEBUDDY PRIVATE LIMITED<br>
                    GSTIN NO: 27AAQCM2355K1ZZ<br>
                    HSN Code:
                </td>
                <td style="text-align: left; padding-left: 0;">
                    <strong>Date:</strong> '.date('F d,Y',strtotime($data['invoice_date'])).'<br>
                    <strong>Invoice No:</strong> '.$invoiceNumber.'
                </td>
            </tr>
        </table>
        ';
        
        $html .= '<style>
    .table-bordered {
        border-collapse: collapse;
       
    }
    .table-bordered th,
    .table-bordered td {
        border: 0.1px solid #00; /* Border color */
        padding: 8px; /* Adjust padding as needed */
    }
</style>
<br><br><br>
<table class="table table-invoice table-bordered">
    <thead>
        <tr style="background-color: #d9e1f2;text-align:center;">
            <th style="width:4%;">Sr. No</th>
            <th style="width:12%;">Los ID</th>
            <th style="width:13%;">Name Of Customer</th>
            <th>Loan Type</th>
            <th>Branch Name</th>
            <th style="width:11%;">CBS A/C No</th>
            <th>Disburs Date</th>
            <th>Sanctioned Loan Amount</th>
            <th>Commission<br> %</th>
            <th>Commission Amount Rs</th>
        </tr>
    </thead>
    <tbody>
';

if (!empty($data['invoice_items'])) {
     $totalLoanAmt = 0;
    $totalCommisionAmt = 0;
    $cgst = 0; 
    $sgst = 0; 
    $igst = 0;
    foreach ($data['invoice_items'] as $key => $row) {
        $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $row['user_id']])->get()->row();
        $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' => $user_data->loan_type_id])->get()->row();
        $branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();

        $totalLoanAmt += $row['loan_type_id'] == 5 ? $user_data->rinnraksha_amt : $user_data->sanction_amt;
      
        $commissionRate = $user_data->part_payout;

        // Calculate Total Commission using the dynamic function
        $totalCommission = calculateTotalCommission1($this->db, $user_data, $commissionRate , $row['loan_type_id'],$invoice_no);
        
        $totalCommisionAmt += $totalCommission;

        $mbgstcode = 27;
       
        if ($mbgstcode == $connector->state_id) {
            $cgst = empty($connector->gst_no) ? 0 : (9 / 100 * $totalCommisionAmt);
            $sgst = empty($connector->gst_no) ? 0 : (9 / 100 * $totalCommisionAmt);
        } else {
            $igst = empty($connector->gst_no) ? 0 : (18 / 100 * $totalCommisionAmt);
        }

        $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $row['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();

        $html .= '
        <tr>
            <td style="width:4%;">' . ($key + 1) . '</td>
            <td style="width:12%;">' . $user_data->los_id . '</td>
            <td style="width:13%;">' . $user_data->user_name . '</td>
            <td>' . $type_data->name . '</td>
            <td>' . $branch->branch_name . ' [' . $branch->branch_code . ']</td>
            <td style="width:11%;">' . ($row['loan_type_id'] == 5 ? $user_data->rr_cbs_acct_no : $user_data->bank_acct_no) . '</td>
            <td>' . date('d.m.Y', strtotime($user_data->disb_date)) . '</td>
            <td>' . formatIndianNumber($row['loan_type_id'] == 5 ? $user_data->rinnraksha_amt : $user_data->sanction_amt) . '</td>
            <td>' . $user_data->part_payout . '%</td>
        ';

        if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
            $premiumAmt = $user_data->rinnraksha_amt;
            $premiumCommission = $premiumAmt * $user_data->part_payout / 100;
            $html .= '<td>' . formatIndianNumber($premiumCommission) . '</td>';
        } else {
                if($user_data->loan_type_id == 4 && $user_data->id == 7247) { 
                    $html .= '<td>720</td>';
                } elseif ($user_data->loan_type_id == 4 && $user_data->sanction_amt >= 100000 && $user_data->sanction_amt < 1000000) {
                    $html .= '<td>2000</td>';
                } else {
                    $html .= '<td>' . formatIndianNumber($user_data->sanction_amt * $user_data->part_payout / 100) . '</td>';
                }

                                
           // $html .= '<td>' . formatIndianNumber($user_data->sanction_amt*$user_data->part_payout /100) . '</td>';
        }

        $html .= '</tr>';

        if ($row['loan_type_id'] == 5) {
            $html .= '
            <tr>
                <td style="width:4%;"></td>
                <td style="width:12%;">' . $user_data->los_id . '</td>
                <td style="width:13%;">' . $user_data->user_name . '</td>
                <td style="text-align:left;">RR Commission</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            ';
            $commission = 0;
            if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                $rr_sanction_amt = $this->db->select("*")->where(['id' => @$rr_aact->id])->from('mst_user')->get()->row();
                $sanctionAmt = @$rr_sanction_amt->sanction_amt;
               
                if ($sanctionAmt >= 100000 && $sanctionAmt < 5000000) {
                    $commission = 4000;
                } elseif ($sanctionAmt >= 5000000 && $sanctionAmt < 10000000) {
                    $commission = 5000;
                } elseif ($sanctionAmt >= 10000000) {
                    $commission = 6000;
                } 
                
                $eligible_accounts = ['43834971612', '43916591164', '43925342796','43936109245','43289254253','43936164069','43958834381','43986307180','43967990282',
                '43977965425','43982487224','43733838473','43969386776','44014640234','44014386843','43960181234','43954036385','43989889073','43960342181','43960084503','43985460887'];
                
                $eligible_accounts_6k = ['43967718498'];
                
                $eligible_accounts_5k = ['43972742119','43969400157','43989937211'];
                
                

                // Check if rr_cbs_acct_no is in the eligible list
                if (isset($user_data->bank_acct_no) && in_array($user_data->bank_acct_no, $eligible_accounts, true)) {
                    $commission = 4000;
                }
                
                // Check if rr_cbs_acct_no is in the eligible list
                if (isset($user_data->bank_acct_no) && in_array($user_data->bank_acct_no, $eligible_accounts_5k, true)) {
                    $commission = 5000;
                }
                
                if (isset($user_data->bank_acct_no) && in_array($user_data->bank_acct_no, $eligible_accounts_6k, true)) {
                    $commission = 6000;
                }
                
                
                if($invoice_no=='inv_hlc20250121234834_397'){
                    $commission = '4000';
                }
                  $html .= '<td>' . formatIndianNumber($commission) . '</td>';
            } else {
                if ($user_data->loan_type_id == 4 && $user_data->id == 7247) { 
                     $html .= '<td>720</td>';
                }
                 else if ($user_data->loan_type_id == 4 && $user_data->sanction_amt >= 100000 && $user_data->sanction_amt < 1000000) {
                                   $html .= '<td>' . formatIndianNumber(2000) . '</td>';
                                } else {
                                    $html .= '<td>' . formatIndianNumber($user_data->sanction_amt*$user_data->part_payout /100) . '</td>';
                                }
            }

            $html .= '</tr>';
        }
        
    }
}

 $gstPercentage = empty($connector->gst_no) ? 0 : 18; 
 $gst = $gstPercentage / 100 * $totalCommisionAmt;
 $netPayamt = $totalCommisionAmt;
 $invoiceTimestamp = strtotime($data['invoice_date']);

// Define the threshold date (1st October 2024)
$thresholdDate = strtotime('2024-10-01');

// Check if the invoice date is on or after 1st October 2024
if ($invoiceTimestamp >= $thresholdDate) {
    // Apply 2% TDS
    $tdsPer = 2;
    $tds = $netPayamt * 2 / 100;
} else {
    // Apply 5% TDS
    $tdsPer = 5;
    $tds = $netPayamt * 5 / 100;
}
 $grossTotal = $netPayamt + $gst;
 $netTotal = $grossTotal - $tds;
 
 $html .='<tr>
          <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td>-</td>
           <td>-</td>
        </tr>
        <tr>
           <td colspan="5" rowspan="7">';
          if (@$paid_invoice->status == "paid") {
            $html .= '
                <table style="width:100%;">
                    <tr>
                        <td style="width:40%;">
                            <img src="'.base_url().'assets/site_img/paid-stamp.png" height="100">
                        </td>
                        <td style="width:60%; text-align:left;">
                            <p>Payment Date: '.date('d-m-Y',strtotime($paid_invoice->payment_date)).'</p>
                            <p>Payment Amount: Rs '.$paid_invoice->pay_amt.'</p>
                            <p>Ref No/Cheq No: '.$paid_invoice->bank_details.'</p>
                        </td>
                    </tr>
                </table>';
        }elseif (@$paid_invoice->status == "partly paid") {
            $html .= '
                <table style="width:100%;">
                    <tr>
                        <td style="width:40%;">
                        Partly Paid
                        </td>
                        <td style="width:60%; text-align:left;">
                            <p>Payment Date: '.date('d-m-Y',strtotime($paid_invoice->payment_date)).'</p>
                            <p>Payment Amount: Rs '.$paid_invoice->pay_amt.'</p>
                            <p>Ref No/Cheq No: '.$paid_invoice->bank_details.'</p>
                        </td>
                    </tr>
                </table>';
        }elseif (@$paid_invoice->status == "excess paid") {
            $html .= '
                <table style="width:100%;">
                    <tr>
                        <td style="width:40%;">
                        Excess Paid
                        </td>
                        <td style="width:60%; text-align:left;">
                            <p>Payment Date: '.date('d-m-Y',strtotime($paid_invoice->payment_date)).'</p>
                            <p>Payment Amount: Rs '.$paid_invoice->pay_amt.'</p>
                            <p>Ref No/Cheq No: '.$paid_invoice->bank_details.'</p>
                        </td>
                    </tr>
                </table>';
        } else {
            $html .= 'unpaid';
        }

    $html .='</td>
           <td colspan="2" style="text-align:right;"><b>Sub Total</b></td>
            <td><strong>'.formatIndianNumber($totalLoanAmt).'</strong></td>
           <td></td>
           <td><strong>'.formatIndianNumber($totalCommisionAmt).'</strong></td>
        </tr>
        <tr>
           <td colspan="2" style="text-align:right;"><b>Tax Amount - CGST 9%</b></td>
            <td></td>
           <td>-</td>
           <td>'. (empty($cgst) ? '-' : formatIndianNumber($cgst)) . '</td>
        </tr>
        <tr>
          
           <td colspan="2" style="text-align:right;"><b>Tax Amount - SGST 9%</b></td>
            <td></td>
          
           <td>-</td>
            <td>'. (empty($sgst) ? '-' : formatIndianNumber($sgst)) . '</td>
        </tr>
         <tr>
         
           <td colspan="2" style="text-align:right;"><b>Tax Amount - IGST 18%</b></td>
            <td></td>
            <td>-</td>
            <td>'. (empty($igst) ? '-' : formatIndianNumber($igst)) . '</td>
        </tr>
        <tr>
           
           <td colspan="2" style="text-align:right;"><b>Gross Total</b></td>
            <td></td>
           <td></td>
           <td><strong>'. formatIndianNumber($grossTotal).'</strong></td>
        </tr>
        <tr>
           
           <td colspan="2" style="text-align:right;"><b>Less: TDS @ '.$tdsPer.'%</b></td>
            <td></td>
           <td></td>
           <td><strong>'.formatIndianNumber($tds).'</strong></td>
        </tr>
        <tr>
          
           <td colspan="2" style="text-align:right;"><b>Net Total</b></td>
            <td></td>
           <td></td>
           <td><strong>'.formatIndianNumber($netTotal).'</strong></td>
        </tr>
                    
                   </tbody>
                </table>
 <p>I confrim that above housing proposal has been disbursed from mentioned branch on MortgageBuddy Private Limited HLC code(MUMHLC03147).</p>
 <br><br>
 <table class="table">
    <tr class="align-items-center mt-5">
       <td width="40%">
            <p class="mb-0"><strong>Rs.(In words): '. ucfirst(getIndianCurrency($netTotal)) . ' only</strong></p>
        </td>
        <td width="30%">
           
        </td>
        <td width="40%" style="text-algin:right;">
            <p class="mb-0">Signature</p>
        </td>
    </tr>
</table>
<br><br><br><br>
 <table style="width:30%;">
            <tr>
                <td><strong>Type of Account :</strong></td>
                <td>'.$connector->bank_acct_type.'</td>
            </tr>
            <tr>
                <td><strong>Account No. :</strong></td>
                <td>'.$connector->bank_acct_no.'</td>
            </tr>
            <tr>
                <td><strong>IFSC code:</strong></td>
                <td>'.$connector->bank_ifsc.'</td>
            </tr>
        </table>
';

    // Write the HTML content to the PDF
    $pdf->writeHTML($html, true, false, true, false, '');
    

    // Get the output as a string and force download
    $pdfOutput = $pdf->Output($invoiceNumber.'.pdf', 'I');
}

   
    
    
}


?>
