<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Invoice_pdf_branch extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->library('Invoice_order_sbi');
    }
    


public function generatePDF($invoice_no) {
   
    $data['invoice_items'] = $this->db
    ->select('*')
    ->from('invoices')
    ->where(['inv_batchno' => $invoice_no])
    ->order_by('id', 'asc')
    ->get()
    ->result_array();

    $data['invoice_items'] = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoice_no])->get()->result_array();

            $firstInvoiceItem = reset($data['invoice_items']);
            $userID = isset($firstInvoiceItem['user_id']) ? $firstInvoiceItem['user_id'] : null;
            $connectorID = isset($firstInvoiceItem['connector_id']) ? $firstInvoiceItem['connector_id'] : null;
            $branchID = isset($firstInvoiceItem['branch_id']) ? $firstInvoiceItem['branch_id'] : null;
            $invoiceDate = isset($firstInvoiceItem['invoice_date']) ? $firstInvoiceItem['invoice_date'] : null;
            $invoiceType = isset($firstInvoiceItem['invoice_type']) ? $firstInvoiceItem['invoice_type'] : null;
            $invoiceNumber = isset($firstInvoiceItem['invoice_number']) ? $firstInvoiceItem['invoice_number'] : null;
            $signature_id = isset($firstInvoiceItem['signature_id']) ? $firstInvoiceItem['signature_id'] : null;

            $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['staff_id' => $connectorID, 'staff_type' => 1])->get()->row();
            $data['applicant_user'] = $this->db->select("*")->from('mst_user')->where(['id' => $userID, 'active' => 1])->get()->row();
            $data['branch'] = $this->db->select("*")->from('branch')->where(['id' =>  $data['applicant_user']->branch_id, 'active' => 1])->get()->row();
            $data['rbo'] = $this->db->select("*")->from('mst_rbo')->where(['id' => $data['branch']->rbo_id])->get()->row();
            
    $data['state'] = $this->db->select("*")->from('mst_state')->where(['id' => $data['branch']->state_id])->get()->row();
    $data['city'] = $this->db->select("*")->from('mst_city')->where(['id' => $data['branch']->city_id])->get()->row();
    $data['invoice_date'] = $invoiceDate;
    $data['invoice_type'] = $invoiceType;
    $data['invoice_num'] = $invoiceNumber;
    $data['signature_id'] = $signature_id;
    
    
    

    // Create new TCPDF instance
    $pdf = new Invoice_order_sbi('L', 'mm', 'A4', true, 'UTF-8', false);

$pdf->setPrintFooter(false); // Double-check footer is disabled

    
    $inv_no = str_replace('/', '_', $invoiceNumber);

    // Set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Mortgagebuddy');
    $pdf->SetTitle($invoiceNumber);
    $pdf->SetSubject('Invoice');
    $pdf->SetKeywords('Invoice, PDF, Example');

    $pdf->SetAutoPageBreak(TRUE, 2); // Set auto page breaks

    // Set font
    $pdf->SetFont('dejavusans', '', 7);
    $pdf->SetCellPaddings(1, 2, 1, 1);
    $pdf->SetMargins(10, 2, 10);
    $pdf->AddPage();
    $pdf->SetMargins(10, 2, 10);

    // Set some content to display
    $html = $this->load->view('admin/manage_invoice_branch/invoice_branch_pdf', $data, true);

    // Write the HTML content to the PDF
    $pdf->writeHTML($html, true, false, true, false, '');
    

    // Get the output as a string and force download
    $pdfOutput = $pdf->Output($invoiceNumber.'.pdf', 'I');
}

   
    
    
}


?>
