<?php


class Admin extends CI_Controller {
  //HLC

    public function __construct() {

        parent::__construct(); 
        
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
         $this->load->library('user_agent');
    
         $this->load->library('form_validation');
         $this->load->library('PHPMailerLib');
       
         $this->load->model('Hlc_model');

        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('common_model', 'ccm');
        
        // Check if user is logged in
            if (!isset($_SESSION['staff_id']) || !isset($_SESSION['staff_type'])) {
                redirect('admin_login');
            } else {
                // Fetch admin profile
                $this->admin_profile = $this->db->where('staff_id', $_SESSION['staff_id'])->get('mst_staff')->row();
                // Fetch menu permissions for the logged-in user
                $this->menu_permission = $this->ccm->get_permissions_by_user($_SESSION['staff_id']);
            }
              //print_r($_SESSION);
               

    }



   public function index() {
    if($_SESSION['staff_type'] != 1) {
        if (!has_menu_permission($_SESSION['staff_id'], 'Dashboard')) {
            show_error('You do not have permission to access this page.', 403);
        }
    }
    
    
    
    $data['current_page'] = 'Dashboard';
    
    $this->updatePartPayout();
    $this->delete_appraisal_letter_for_user_zero();
    
    
    /*$oldDB_branch = $this->load->database('default', TRUE);
    $newDB_branch = $this->load->database('fin_25_26', TRUE);
    $data_branch = $oldDB_branch->get('branch')->result_array();
    foreach ($data_branch as $row_branch) {
        $newDB_branch->insert('branch', $row_branch);
    }
    
    
    $oldDB_rbo = $this->load->database('default', TRUE);
    $newDB_rbo = $this->load->database('fin_25_26', TRUE);
    $data_rbo = $oldDB_rbo->get('mst_rbo')->result_array();
    foreach ($data_rbo as $row_rbo) {
        $newDB_rbo->insert('mst_rbo', $row_rbo);
    }
    
    $oldDB_city = $this->load->database('default', TRUE);
    $newDB_city = $this->load->database('fin_25_26', TRUE);
    $data_city = $oldDB_city->get('mst_city')->result_array();
    foreach ($data_city as $row_city) {
        $newDB_city->insert('mst_city', $row_city);
    }
    
    $oldDB_staff = $this->load->database('default', TRUE);
    $newDB_staff = $this->load->database('fin_25_26', TRUE);
    $data_staff = $oldDB_staff->get('mst_staff')->result_array();
    foreach ($data_staff as $row_staff) {
        $newDB_staff->insert('mst_staff', $row_staff);
    }
    
    
    $oldDB_mst_menus = $this->load->database('default', TRUE);
    $newDB_mst_menus = $this->load->database('fin_25_26', TRUE);
    $data_mst_menus = $oldDB_mst_menus->get('mst_menus')->result_array();
    foreach ($data_mst_menus as $row_mst_menus) {
        $newDB_mst_menus->insert('mst_menus', $row_mst_menus);
    }
    
    $oldDB_menu_permissions = $this->load->database('default', TRUE);
    $newDB_menu_permissions = $this->load->database('fin_25_26', TRUE);
    $data_menu_permissions = $oldDB_menu_permissions->get('menu_permissions')->result_array();
    foreach ($data_menu_permissions as $row_menu_permissions) {
        $newDB_menu_permissions->insert('menu_permissions', $row_menu_permissions);
    }
    */
    
    
    
     $this->sync_tables_bidirectionally();
    
    
    
    
   /* $query = $this->db->select("COUNT(*) as total")
        ->from('mst_staff')
        ->where(['staff_type' => 1]);
    
    if (in_array('Self Created Partner Show', $this->menu_permission)) {
        $query->where('created_by', $_SESSION['staff_id']);
    }
    $data['tot_connector'] = $query->get()->row()->total;
    
    if ($_SESSION['staff_type'] == 0) {
        // Get count of all staff
        $data['tot_applicant'] = $this->db->select("COUNT(*) as total")->from('mst_user')->get()->row()->total;
    } else {
        $data['tot_applicant'] = $this->db
            ->where(['connector_id' => $_SESSION['staff_id']])
            ->from('mst_user')
            ->count_all_results();
    }*/
    
    /*$totalPaidHLC = $this->ccm->getTotalPaidForHLC();
    $data['totalPaidHLC'] = $totalPaidHLC; 
    
    $totalPaidSBI = $this->ccm->getTotalPaidForSBI();
    $data['totalPaidSBI'] = $totalPaidSBI; */
    
   /* $unpaid_hlc_count = $this->ccm->get_unpaid_hlc_invoices_count();
    $data['unpaid_hlc_counts'] = $unpaid_hlc_count;*/
    
  /*  $sbi_invoices_count = $this->ccm->get_sbi_invoices_count_for_month();
    $data['sbi_invoices_count'] = $sbi_invoices_count;*/
    
   // $data['sbiPaymentReceived'] = $this->ccm->get_sbi_payment_received();
    
   /*$this->db->select('
    SUM(CASE WHEN loan_type_id = 5 THEN rinnraksha_amt ELSE 0 END) +
    SUM(CASE WHEN loan_type_id != 5 THEN sanction_amt ELSE 0 END) AS total_loan_amt
');
$this->db->from('mst_user');
$this->db->where('is_archive', 'No');
$this->db->where('disb_date IS NOT NULL');
$this->db->where('login_code IS NOT NULL');
$query = $this->db->get();

$result = $query->row();
$total_loan_amt = $result->total_loan_amt;

$data['totalSumSanctionAmt'] = $total_loan_amt;

*/
        

    // (in_array('Self Created Partner Show', $this->menu_permission)) {
        //$this->manage_connectors();
    //} else {
        $data['title'] = 'Dashboard';
        $data['viewfile'] = "admin/dashboard";
        $this->load->view('admin/layout', $data);
   // }
}


public function sync_tables_bidirectionally()
{
    // Table name => Primary key column
    $tables = [
        'branch' => 'id',
        'mst_rbo' => 'id',
        'mst_city' => 'id',
        'mst_staff' => 'staff_id',
        'mst_menus' => 'id',
        'menu_permissions' => 'id'
    ];

    $oldDB = $this->load->database('default', TRUE);
    $newDB = $this->load->database('fin_25_26', TRUE);

    foreach ($tables as $table => $primaryKey) {
        // Sync from oldDB to newDB
        $old_data = $oldDB->get($table)->result_array();
        foreach ($old_data as $row) {
            if (!isset($row[$primaryKey])) continue; // Skip if PK missing
            $newDB->where($primaryKey, $row[$primaryKey]);
            $exists = $newDB->get($table)->row();
            if (!$exists) {
                $newDB->insert($table, $row);
            }
        }

        // Sync from newDB to oldDB
        $new_data = $newDB->get($table)->result_array();
        foreach ($new_data as $row) {
            if (!isset($row[$primaryKey])) continue; // Skip if PK missing
            $oldDB->where($primaryKey, $row[$primaryKey]);
            $exists = $oldDB->get($table)->row();
            if (!$exists) {
                $oldDB->insert($table, $row);
            }
        }
    }

    //echo "Data synced successfully.";
}





public function changeYear()
{
    $year = $this->input->get('year');
    
    // Default database (2024-25)
    $db_group = 'default';
    
    // If 2025-26 is selected, change database
    if ($year == '25-26') {
    $db_group = 'fin_25_26';
    }
    
    // Load the correct database
    $this->db = $this->load->database($db_group, TRUE);
    $this->session->set_userdata('db_group', $db_group); // Store DB group in session
    $this->session->set_userdata('financial_year', $year);
  
    // Redirect to the previous page
    redirect($this->agent->referrer());
}


public function manage_roles() {
    
        if (!in_array('Roles', $this->menu_permission)) {
           echo 'You do not have permission to access this page.'; die;
        }
        
        
        $this->load->library('pagination');
        $config['base_url'] = base_url() . 'admin/manage_roles';
        $config['total_rows'] = $this->ccm->get_all_count('role', 'role_name', '', 'add_date');
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['reuse_query_string'] = TRUE;
        $config['full_tag_open'] = '<ul class="pagination pagination-split justify-content-end">';
        $config['full_tag_close'] = '</ul>';
        $config['nue_tag_open'] = "<li class = 'page-item'>";
        $config['nue_tag_close'] = "</li>";
        $config['cur_tag_open'] = " <li class = 'page-item active'> <a class = 'page-link '>";
        $config['cur_tag_close'] = "</a></li>";
        $config['attributes'] = array('class' => 'page-link');
        $config['first_tag_open'] = '<div class="first">';
        $config['first_tag_close'] = '</div>';
        $config['last_tag_open'] = '<div class="last">';
        $config['last_tag_close'] = '</div>';
        $config['next_tag_open'] = '<div class="next">';
        $config['next_tag_close'] = '</div>';
        $config['prev_tag_open'] = '<div class="prev">';
        $config['prev_tag_close'] = '</div>';
        $this->pagination->initialize($config);

        $data['pagination'] = $this->pagination->create_links();

        $data['current_page'] = 'manage_roles';
        $data['title'] = 'List  Role';
        $data['role'] = $this->ccm->get_all_data(
            'role',                          // Table name
            15,                                       // Limit
            'role.role_name',                  // Order by column
            '',                                       // Group value (if any)
            [ 'role.role_name',    
             'role.add_date', 
             'role.active', 
            ], 
            '',                                        // Additional WHERE conditions
            '',                                        // Where IN column
            ''                                         // Where IN values
        );
//       print("<pre>".print_r( $data['leads'],true)."</pre>"); die;
        $data['viewfile'] = "admin/manage_role/manage_roles";
        $this->load->view('admin/layout', $data);

    }

public function role_form($id = '') {
        if (!in_array('Roles', $this->menu_permission)) {
           echo 'You do not have permission to access this page.'; die;
        }
        
        $data['current_page'] = 'manage_roles';

        if ($id != '') {
            $data['title'] = 'Edit Role';
            $data['role'] = $this->ccm->get_single_row('role', array('id' => $id));
        } else {
            $data['title'] = 'Add Role';
        }
        
            // Fetch sites for the Site ID dropdown
        $data['viewfile'] = 'admin/manage_role/role_form';

        $this->load->view('admin/layout', $data);

    }

   public function submit_role() {
       
        if (!in_array('Roles', $this->menu_permission)) {
           echo 'You do not have permission to access this page.'; die;
        }
        
        if ($_POST) {
            
            // Collecting POST Data into an Array
            $data = array(
                'role_name' => $this->input->post('role_name'),
                // 'created_by' => $_SESSION['staff_id'],
            );
    
            $data = array_filter($data); // Remove any empty values
            $data = $this->security->xss_clean($data); // XSS Clean the data
            $r_id = isset($_POST['r_id']) ? $_POST['r_id'] : 0;

            if (!empty($r_id)) {
                // Update Existing Bank
                $this->db->where('id', $r_id);
                $res = $this->db->update('role', $data);
                $msg = 'Role Updated Successfully!';
                
            } else {
                // Check if Bank Account Number Already Exists
                if ($this->ccm->get_row_count('role', array('role_name' => $this->input->post('role_name'))) != 0) {
                    $data = array('type' => 'error', 'message' => 'Role already exists. Please change it.', 'success' => 0);
                    echo json_encode($data);
                    exit;
                }
    
                // Insert Beneficiary
                $res = $this->db->insert('role', $data);
                $msg = 'Role Added Successfully!';
                $r_id = $this->db->insert_id();

                }
    
            // Set Response Message
            if ($res) {
                $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
                $this->session->set_flashdata('response_message', $message);
            } else {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Role not added. Please try again later.');
            }
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Please fill in the details before submitting.');
        }
    
        echo json_encode($message);
    }


 public function delete_user($id) {
    
    $this->db->where('id', $id);
    $this->db->where('applicant_invoice_status IS NOT NULL'); 
    $user_with_invoice = $this->db->get('mst_user')->row();
    
        $this->db->where('id', $id);
        $this->db->where('applicant_rr_id IS NOT NULL', null, false); 
        $this->db->where('applicant_rr_id !=', '');
        $user_with_rr = $this->db->get('mst_user')->row();
        
        if ($user_with_rr) {
            $message = array(
                'success' => '0',
                'type' => 'error',
                'message' => 'First delete RR account this case.'
            );
            echo json_encode($message);
            return;
        }


    if ($user_with_invoice) {
        // If the user has an invoice generated, return an error message
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Cannot delete Applicant. An invoice has been generated for this Applicant.');
    } else {
        // Start transaction to delete user and log data
        $this->db->trans_start(); // Start a transaction

        // Fetch user data
        $this->db->where('id', $id);
        $user_data = $this->db->get('mst_user')->row_array();

        if (!empty($user_data)) {
            // Insert user data into deleted_user_log table
            $deleted_data = [
                'deleted_user_data' => json_encode($user_data), // Store user data as JSON
                'deleted_by' => $this->session->userdata('staff_id'), // Get current user ID from session
                'deleted_date' => date('Y-m-d H:i:s'), // Current timestamp
                'remark' => 'User deletion performed.' // Optional remarks
            ];
            $this->db->insert('deleted_user_log', $deleted_data);
        }
        
        $this->db->where('applicant_rr_id', $id);
        $this->db->update('mst_user', ['applicant_rr_id' => NULL]);

        // Delete user
        $this->db->where('id', $id);
        $res = $this->db->delete("mst_user");

        if ($res) {
            // If the delete operation was successful
            // Delete any associated appraisal letters
            $appraisal_letters = $this->db->select('appraisal_letter, apprisal_letter_two, final_sanction_letter, proof_disb')
                ->from('appraisal_letters')
                ->where('user_id', $id)
                ->get()
                ->result();

            // Loop through appraisal letters and delete the files
            foreach ($appraisal_letters as $letter) {
                if (!empty($letter->appraisal_letter) && file_exists(FCPATH . 'assets/uploads/documents/' . $letter->appraisal_letter)) {
                    @unlink(FCPATH . 'assets/uploads/documents/' . $letter->appraisal_letter);
                }
                if (!empty($letter->apprisal_letter_two) && file_exists(FCPATH . 'assets/uploads/documents/' . $letter->apprisal_letter_two)) {
                    @unlink(FCPATH . 'assets/uploads/documents/' . $letter->apprisal_letter_two);
                }
                if (!empty($letter->final_sanction_letter) && file_exists(FCPATH . 'assets/uploads/documents/' . $letter->final_sanction_letter)) {
                    @unlink(FCPATH . 'assets/uploads/documents/' . $letter->final_sanction_letter);
                }
                if (!empty($letter->proof_disb) && file_exists(FCPATH . 'assets/uploads/documents/' . $letter->proof_disb)) {
                    @unlink(FCPATH . 'assets/uploads/documents/' . $letter->proof_disb);
                }
            }

            // Delete the appraisal letter entries from the database
            $this->db->where('user_id', $id);
            $this->db->delete('appraisal_letters');

            $this->db->trans_complete(); // Complete the transaction

            if ($this->db->trans_status() === FALSE) {
                // If there was an issue during deletion, roll back
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Deletion failed. Please try again later.');
            } else {
                // If everything went fine
                $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully...!');
            }
        } else {
            // If the user deletion failed
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Deletion failed. Please try again later.');
        }
    }

    echo json_encode($message);
}





     public function change_theme($val = '') {

        $_SESSION['theme_type'] = $val;

        $this->db->where('staff_id', $_SESSION['staff_id']);

        $this->db->update('mst_staff', array('theme_type' => $val));

        echo 0;

    }



   public function signOut() {
    // Unset all session data
    $this->session->unset_userdata([
        'staff_id',
        'staff_type',
        'staff_username'
    ]);

    // Destroy the session completely
    $this->session->sess_destroy();

    // Redirect to login page
    redirect(base_url() . 'admin_login');
}



    public function change_password() {
        $this->db->where('staff_id', $_SESSION['staff_id']);

        $res = $this->db->update('mst_staff', array('staff_password' => $_POST['a_password']));
        redirect('admin/signOut');
    }
   


 public function partner_bank_report() {

        if ($this->session->userdata('staff_type') == 0) {

        $data['current_page'] = 'Bank Report';
        $data['title'] = 'Bank Report';
        $data['viewfile'] = "admin/manage_connectors/partner_bank_details_report";

        $this->load->view('admin/layout', $data);

        }else{
            // Redirect or show an error message
            echo 'unauthorized_access'; 
            return;
        }
        

    }
    
public function fetch_partner_bank_details() {
    $columns = array(
        0 => 'staff_id',
        1 => 'staff_fullname',
        2 => 'Bank Details',
        3 => 'bank_details_file'
    );

    $limit = $this->input->post('length') != -1 ? $this->input->post('length') : null;
    $start = $this->input->post('start');
    $order = $columns[$this->input->post('order')[0]['column']];
    $dir = $this->input->post('order')[0]['dir'];

    $this->db->select('mst_staff.*, mst_state.state_name, mst_city.city_name');
    $this->db->from('mst_staff');
    $this->db->join('mst_state', 'mst_staff.state_id = mst_state.id', 'left');
    $this->db->join('mst_city', 'mst_staff.city_id = mst_city.id', 'left');
   
    $this->db->where('mst_staff.staff_type', 1);
    
    $totalData = $this->db->count_all_results('', false); // Count all results and keep the query

    if(empty($this->input->post('search')['value'])) {
        if ($limit) {
            $this->db->limit($limit, $start);
        }
        $this->db->order_by($order, $dir);
        $query = $this->db->get();
        $totalFiltered = $totalData; // Set totalFiltered to totalData when there's no search
    } else {
        $search = $this->input->post('search')['value'];

        $this->db->group_start();
        $this->db->like('mst_staff.hlc_code', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search);
        $this->db->or_like('mst_staff.bank_acct_no', $search);
        $this->db->or_like('mst_city.city_name', $search);
        $this->db->group_end();
        if ($limit) {
            $this->db->limit($limit, $start);
        }
        $this->db->order_by($order, $dir);
        $query = $this->db->get();
        $totalFiltered = $query->num_rows(); // Set totalFiltered to the number of filtered rows
    }

    $data = array();

    if($query->num_rows() > 0) {
        $serial_number = $start + 1;
        foreach ($query->result() as $row) {
            $city = $this->db->select("*")->where(['id' => $row->city_id])->from('mst_city')->get()->row();
            $state = $this->db->select("*")->where(['id' => $row->state_id])->from('mst_state')->get()->row();
            
            $nestedData = array();
            $nestedData[] = $serial_number++;
            $nestedData[] = $row->staff_fullname;
            $nestedData[] = '<p><strong>Account No:</strong> '.$row->bank_acct_no.'</p>
                             <p><strong>IFSC:</strong> '.$row->bank_ifsc.'</p>
                             <p><strong>Account Type:</strong> '.$row->bank_acct_type.'</p>';
            $nestedData[] = !empty($row->bank_details_file) ? '<a href="'.base_url('assets/uploads/documents/'.$row->bank_details_file).'" target="_blank"><button class="btn btn-sm btn-info">View Cheque</button></a>' : '';
            
            $data[] = $nestedData;
        }
    }

    $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($totalData),
        "recordsFiltered" => intval($totalFiltered),
        "data" => $data
    );

    echo json_encode($json_data);
}


    //Connector

    public function manage_connectors() {
        
        $this->sync_tables_bidirectionally();

        if ($this->session->userdata('staff_type') == 0) {

        $data['current_page'] = 'HLC';
        $data['title'] = 'List Partner';
        $data['viewfile'] = "admin/manage_connectors/manage_connectors";

        $this->load->view('admin/layout', $data);

        }else{
            // Redirect or show an error message
            echo 'unauthorized_access'; 
            return;
        }
        

    }


public function fetch_connectors() {
    $columns = array(
        0 => 'staff_id',
        1 => 'hlc_code',
        2 => 'staff_fullname',
        3 => 'conn_commi',
        4 => 'dob',
        5 => 'Mobile',
        6 => 'Email',
        7 => 'pan_no',
        8 => 'pan_file',
        9 => 'adhar_file',
        10 => 'gst_file',
        11 => 'bank_details_file',
        12 => 'agreement_file',
        13 => 'state_name',
        14 => 'city_name',
        16 => 'remark',
        17 => 'created_by',
        18 => 'created_date',
        19 => 'active',
        20 => 'action'
    );

    $limit = $this->input->post('length') != -1 ? $this->input->post('length') : null;
    $start = $this->input->post('start');
    $order = $columns[$this->input->post('order')[0]['column']];
    $dir = $this->input->post('order')[0]['dir'];

    $this->db->select('mst_staff.*, mst_state.state_name, mst_city.city_name, creator.staff_fullname as created_by_name');
    $this->db->from('mst_staff');
    $this->db->join('mst_state', 'mst_staff.state_id = mst_state.id', 'left');
    $this->db->join('mst_city', 'mst_staff.city_id = mst_city.id', 'left');
    $this->db->join('mst_staff as creator', 'mst_staff.created_by = creator.staff_id', 'left');
    $this->db->where('mst_staff.staff_type', 1);

    if (in_array('Self Created Partner Show', $this->menu_permission)) {
        $this->db->where('mst_staff.created_by', $_SESSION['staff_id']);
    }

    $totalData = $this->db->count_all_results('', false); // Count all results and keep the query

    if(empty($this->input->post('search')['value'])) {
        if ($limit) {
            $this->db->limit($limit, $start);
        }
        $this->db->order_by($order, $dir);
        $query = $this->db->get();
        $totalFiltered = $totalData; // Set totalFiltered to totalData when there's no search
    } else {
        $search = $this->input->post('search')['value'];

        $this->db->group_start();
        $this->db->like('mst_staff.hlc_code', $search);
        $this->db->or_like('mst_staff.staff_fullname', $search);
        $this->db->or_like('mst_staff.pan_no', $search);
        $this->db->or_like('mst_state.state_name', $search);
        $this->db->or_like('mst_city.city_name', $search);
        $this->db->or_like('creator.staff_fullname', $search);
        $this->db->or_like('mst_staff.mobile', $search);
        $this->db->or_like('mst_staff.email', $search);
        $this->db->or_like('mst_staff.conn_commision', $search);
        $this->db->group_end();
        if ($limit) {
            $this->db->limit($limit, $start);
        }
        $this->db->order_by($order, $dir);
        $query = $this->db->get();

        $totalFiltered = $query->num_rows(); // Set totalFiltered to the number of filtered rows
    }

    $data = array();

    if($query->num_rows() > 0) {
        $serial_number = $start + 1;
        foreach ($query->result() as $row) {
            $city = $this->db->select("*")->where(['id' => $row->city_id])->from('mst_city')->get()->row();
            $state = $this->db->select("*")->where(['id' => $row->state_id])->from('mst_state')->get()->row();
            $created_by = $this->db->select("*")->where(['staff_id' => $row->created_by])->from('mst_staff')->get()->row();
            
            $nestedData = array();
            $nestedData[] = $serial_number++;
            $nestedData[] = $row->hlc_code;
            $nestedData[] = $row->staff_fullname;
            $nestedData[] = $row->conn_commision;
            $nestedData[] = empty($row->dob) ? '' : date('d-m-Y', strtotime($row->dob));
            if ($_SESSION['staff_id'] == $row->created_by || $_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 1) {
                $nestedData[] = $row->mobile; // Show the mobile number
            } else {
                $nestedData[] = ''; // Hide the mobile number
            }
            $nestedData[] = $row->email;
            $nestedData[] = $row->pan_no;
            $nestedData[] = !empty($row->pan_file) ? '<a href="'.base_url('assets/uploads/documents/'.$row->pan_file).'" target="_blank"><button class="btn btn-sm btn-info">View PAN Card</button></a>' : '';
            $nestedData[] = !empty($row->adhar_file) ? '<a href="'.base_url('assets/uploads/documents/'.$row->adhar_file).'" target="_blank"><button class="btn btn-sm btn-info">View Adhar Card</button></a>' : '';
            $nestedData[] = !empty($row->gst_file) ? '<a href="'.base_url('assets/uploads/documents/'.$row->gst_file).'" target="_blank"><button class="btn btn-sm btn-info">View GST Certificate</button></a>' : '';
            $nestedData[] = !empty($row->bank_details_file) ? '<a href="'.base_url('assets/uploads/documents/'.$row->bank_details_file).'" target="_blank"><button class="btn btn-sm btn-info">View Cheque</button></a>' : '';
            $nestedData[] = !empty($row->agreement_file) ? '<a href="'.base_url('assets/uploads/documents/'.$row->agreement_file).'" target="_blank"><button class="btn btn-sm btn-info">View Agreement Copy</button></a>' : '';
            $nestedData[] = @$state->state_name;
            $nestedData[] = @$city->city_name;
            $nestedData[] = @$row->remark;
            $nestedData[] = $created_by->staff_fullname;
            $nestedData[] = empty($row->add_date) ? '' : date('d-m-Y', strtotime($row->add_date));
            /*if ($row->active == 1) {
                            $nestedData[] = '<a href="javascript:void(0);">
                                                <span class="badge rounded-pill bg-success commoon_active_partner" 
                                                      action="active_Connectors" 
                                                      active="0" 
                                                      data-id="'.$row->staff_id.'">Active</span>
                                             </a>';
                        } elseif ($row->active == 0) {
                            $nestedData[] = '<a href="javascript:void(0);">
                                                <span class="badge rounded-pill bg-danger commoon_active_partner" 
                                                      action="active_Connectors" 
                                                      active="1" 
                                                      data-id="'.$row->staff_id.'">Deactive</span>
                                             </a>';
                        } elseif ($row->active == 3) {
                            $nestedData[] = '<a href="javascript:void(0);">
                                                <span class="badge rounded-pill bg-warning commoon_active_partner" 
                                                      action="active_Connectors" 
                                                      active="3" 
                                                      data-id="'.$row->staff_id.'">Inprocess</span>
                                             </a>';
                        }*/
                        
                    $bgClass = '';
                    if ($row->active == 1) {
                        $bgClass = 'bg-success'; // Green for Active
                    } elseif ($row->active == 0) {
                        $bgClass = 'bg-danger'; // Red for Deactive
                    } elseif ($row->active == 3) {
                        $bgClass = 'bg-warning'; // Yellow for Inprocess
                    }
                    
                    $nestedData[] = '<select class="form-select form-select-sm commoon_active_partner ' . $bgClass . '" style="width:100px;"
                                          data-id="'.$row->staff_id.'" 
                                          action="active_Connectors">
                                        <option value="1" '.($row->active == 1 ? 'selected' : '').'>Active</option>
                                        <option value="0" '.($row->active == 0 ? 'selected' : '').'>Deactive</option>
                                        <option value="3" '.($row->active == 3 ? 'selected' : '').'>Inprocess</option>
                                     </select>';
        
            $modal = '<div class="modal fade" id="userDetailsModal'.$row->staff_id.'" tabindex="-1" aria-labelledby="userDetailsModalLabel'.$row->staff_id.'" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="userDetailsModalLabel'.$row->staff_id.'">HLC Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p><strong>HLC Name:</strong> '.$row->staff_fullname.'</p>
                                           
                                            <p><strong>Email:</strong> '.$row->email.'</p>
                                            <p><strong>Commision:</strong> '.$row->conn_commision.'</p>
                                            <p><strong>Address:</strong></p>
                                            <p style="white-space: pre-line;">'.$row->staff_address.'</p>
                                            <hr>
                                            <h5>Documents</h5>
                                            <p><strong>Photo:</strong>'.(!empty($row->pass_photo) ? '<a href="'.base_url().'assets/uploads/documents/'.$row->pass_photo.'" target="_blank"><button class="btn btn-sm btn-info">View Photo</button></a>' : '').'</p>
                                            <p><strong>PAN Number:</strong> '.$row->pan_no.'</p>
                                            <p><strong>PAN File:</strong>'.(!empty($row->pan_file) ? '<a href="'.base_url().'assets/uploads/documents/'.$row->pan_file.'" target="_blank"><button class="btn btn-sm btn-info">View PAN File</button></a>' : '').'</p>
                                            <p><strong>GST Number:</strong> '.$row->gst_no.'</p>
                                            <p><strong>GST Certificate:</strong>'.(!empty($row->gst_file) ? '<a href="'.base_url().'assets/uploads/documents/'.$row->gst_file.'" target="_blank"><button class="btn btn-sm btn-info">View GST Certificate</button></a>' : '').'</p>
                                            <p><strong>Addhar File:</strong>'.(!empty($row->adhar_file) ? '<a href="'.base_url().'assets/uploads/documents/'.$row->adhar_file.'" target="_blank"><button class="btn btn-sm btn-info">View Adhar File</button></a>' : '').'</p>
                                            <hr>
                                            <h5>Bank Details</h5>
                                            <p><strong>Bank Name:</strong> '.$row->bank_name.'</p>
                                            <p><strong>Bank IFSC:</strong> '.$row->bank_ifsc.'</p>
                                            <p><strong>Bank Acct. No.:</strong> '.$row->bank_acct_no.'</p>
                                            <p><strong>Acct. Type:</strong> '.$row->bank_acct_type.'</p>
                                            <p><strong>Cheque Details File:</strong>'.(!empty($row->bank_details_file) ? '<a href="'.base_url().'assets/uploads/documents/'.$row->bank_details_file.'" target="_blank"><button class="btn btn-sm btn-info">View Cheque File</button></a>' : '').'</p>
                                        </div>
                                    </div>
                                </div>
                            </div>';
                         
                        $editLink = '';
                        if ($_SESSION['staff_id'] == $row->created_by || $_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 1 || $_SESSION['staff_id'] == 538) {
                            $editLink = '<a href="'.base_url('admin/connectors_form/'.$row->staff_id).'" class="text-warning" title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>';
                        }
                        
                        $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">
                                            <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal'.$row->staff_id.'" title="View detail" aria-label="View"><i class="bi bi-eye-fill"></i></a>
                                            ' . $editLink . '
                                        </div>'.$modal;
                        
                        $data[] = $nestedData;

        }
    }

    $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($totalData),
        "recordsFiltered" => intval($totalFiltered),
        "data" => $data
    );

    echo json_encode($json_data);
}




  public function active_Connectors($id, $status) {
    $data["active"] = $status;
    $this->db->where('staff_id', $id);

    if ($this->db->update("mst_staff", $data)) {
        if ($status == 0) {
            $message = array('success' => '1', 'type' => 'success', 'message' => 'Activated...!');
        } elseif ($status == 1) {
            $message = array('success' => '1', 'type' => 'success', 'message' => 'Deactivated...!');
        } elseif ($status == 3) {
            $message = array('success' => '1', 'type' => 'success', 'message' => 'Marked as Inprocess...!');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Update failed. Please try again later.');
    }

    echo json_encode($message);
}




    public function delete_Connectors($id) {

        $data["active"] = '2';

        $this->db->where('staff_id', $id);

        $res = $this->db->update("mst_staff", $data);

        if ($res == 1) {

            $message = array('success' => '1', 'type' => 'error', 'message' => 'Connectors Deleted Successfully...!');

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Connectors did not deleted please try after some time..!');

        }

        echo json_encode($message);

    }



    public function submit_Connectors() {
        if ($this->session->userdata('staff_type') == 0) {
           
        if ($_POST) {
            $data = array(
                'staff_fullname' => $this->input->post('e_fullname'),               
                'staff_password' => $this->input->post('e_password'),
                'staff_address' => $this->input->post('e_address'),
                'mobile' => $this->input->post('mobile'),
                'email' => $this->input->post('email'),                
                'remark' => $this->input->post('remark'),                
                'dob' => $this->input->post('dob'),                
                'bank_name' => $this->input->post('bank_name'),
                'bank_acct_no' => $this->input->post('bank_acct_no'),
                'bank_ifsc' => $this->input->post('bank_ifsc'),
                'bank_acct_type' => $this->input->post('bank_acct_type'),
                'bank_ifsc' => $this->input->post('bank_ifsc'),
                'pan_no' => $this->input->post('pan_no'),                
                'gst_no' => $this->input->post('gst_no'),                
                'conn_commision' => $this->input->post('conn_commision'),                
                'circle_id' => $this->input->post('circle_id'),                
                'state_id' => $this->input->post('state_id'),                
                'pincode' => $this->input->post('pincode'),                
                'hlc_code' => $this->input->post('hlc_code'),                
                'city_id' => $this->input->post('city_id'),   
                'slab_one' => $this->input->post('slab_one'),
                'slab_two' => $this->input->post('slab_two'),
                'slab_three' => $this->input->post('slab_three'),
                 'slab_one_commi' => $this->input->post('slab_one_commi'),
                'slab_two_commi' => $this->input->post('slab_two_commi'),
                'slab_three_commi' => $this->input->post('slab_three_commi'),
                'part_user_type' => $this->input->post('part_user_type'),
                'partner_type' => $this->input->post('partner_type'),
                'sales_coordinator' => $this->input->post('sales_id'),
                'area_sales_mgr' => $this->input->post('asm_id'),
                'zonal_sales_mgr' => $this->input->post('zonal_id'),
                'regional_sales_mgr' => $this->input->post('rsm_id'),
                'sales_aggr' => $this->input->post('aggr_id'),
                'staff_type' => 1,
                'created_by' => $_SESSION['staff_id'],
            );
    
                // File upload configuration
                $config['upload_path'] = realpath('./assets/uploads/documents/');
                $config['allowed_types'] = 'jpeg|jpg|jpeg|png|pdf'; // Add or modify file types as needed
                $config['max_size'] = 10240; // Maximum file size in kilobytes

                // Adhar file upload
                $config['file_name'] = 'adhar_' . date('dmYhis') . '_' . rand(0, 999999); // You may want to use a unique name for each file
                $this->load->library('upload', $config, 'adhar_upload');
                if ($this->adhar_upload->do_upload('adhar_file')) {
                    $data['adhar_file'] = $this->adhar_upload->data('file_name');
                }
                
                // Adhar file 2 upload
                $config['file_name'] = 'adhar_2' . date('dmYhis') . '_' . rand(0, 999999); // You may want to use a unique name for each file
                $this->load->library('upload', $config, 'adhar_2_upload');
                if ($this->adhar_upload->do_upload('adhar_file_2')) {
                    $data['adhar_file_2'] = $this->adhar_upload->data('file_name');
                }

                // GST certificate file upload
                $config['file_name'] = 'gst_certificate_' . date('dmYhis') . '_' . rand(0, 999999);
                $this->load->library('upload', $config, 'gst_file_upload');
                if ($this->gst_file_upload->do_upload('gst_file')) {
                    $data['gst_file'] = $this->gst_file_upload->data('file_name');
                }

                // Passport photo file upload
                $config['file_name'] = 'pass_photo_' . date('dmYhis') . '_' . rand(0, 999999);
                $this->load->library('upload', $config, 'pass_photo_upload');
                if ($this->pass_photo_upload->do_upload('pass_photo')) {
                    $data['pass_photo'] = $this->pass_photo_upload->data('file_name');
                }

                // PAN file upload
                $config['file_name'] = 'pan_' . date('dmYhis') . '_' . rand(0, 999999);
                $this->load->library('upload', $config, 'pan_upload');
                if ($this->pan_upload->do_upload('pan_file')) {
                    $data['pan_file'] = $this->pan_upload->data('file_name');
                }
                
                // PAN file upload
                $config['file_name'] = 'bank_details_' . date('dmYhis') . '_' . rand(0, 999999);
                $this->load->library('upload', $config, 'bank_details_file_upload');
                if ($this->bank_details_file_upload->do_upload('bank_details_file')) {
                    $data['bank_details_file'] = $this->bank_details_file_upload->data('file_name');
                }
                
                // Agreement file upload
                $config['file_name'] = 'agreement_file_' . date('dmYhis') . '_' . rand(0, 999999);
                $this->load->library('upload', $config, 'agreement_file_upload');
                if ($this->agreement_file_upload->do_upload('agreement_file')) {
                    $data['agreement_file'] = $this->agreement_file_upload->data('file_name');
                }
            
            $e_id = 0;
    
            if ($_POST['e_id'] != '') {
                $e_id = $_POST['e_id'];
                
                 $oldData = $this->db->get_where('mst_staff', array('staff_id' => $e_id))->row();

                // Check if conn_commision has changed
                /*if ($oldData && $oldData->conn_commision != $this->input->post('conn_commision')) {
                    $data['active'] = 3; 
                }*/
                    // Check if a new file is being uploaded before deleting the old one
                    if ($_FILES['adhar_file']['name']) {
                        $this->deleteFile($oldData->adhar_file);
                    }
                    if ($_FILES['adhar_file_2']['name']) {
                        $this->deleteFile($oldData->adhar_file_2);
                    }
                    if ($_FILES['gst_file']['name']) {
                        $this->deleteFile($oldData->gst_file);
                    }
                    if ($_FILES['pass_photo']['name']) {
                        $this->deleteFile($oldData->pass_photo);
                    }
                    if ($_FILES['pan_file']['name']) {
                        $this->deleteFile($oldData->pan_file);
                    }
                    if ($_FILES['bank_details_file']['name']) {
                        $this->deleteFile($oldData->bank_details_file);
                    }
                    if ($_FILES['agreement_file']['name']) {
                        $this->deleteFile($oldData->agreement_file);
                    }

                $this->db->where('staff_id', $_POST['e_id']);
                $res = $this->db->update('mst_staff', $data);
                
                 /* Start Insertion Partner Director Details */
                   
                    $partner_names   = $this->input->post('pd_name');
                    $partner_emails  = $this->input->post('pd_email');
                    $partner_mobiles = $this->input->post('pd_mobile');
                    $partner_dobs    = $this->input->post('pd_dob');
                   
                    // Ensure all are arrays
                    $partner_names   = is_array($partner_names) ? $partner_names : [];
                    $partner_emails  = is_array($partner_emails) ? $partner_emails : [];
                    $partner_mobiles = is_array($partner_mobiles) ? $partner_mobiles : [];
                    $partner_dobs    = is_array($partner_dobs) ? $partner_dobs : [];
                    
                   
                    $attach1 = $_FILES['partner_attach1'];
                    $attach2 = $_FILES['partner_attach2'];
                    
                    foreach ($partner_names as $i => $name) {
                        if (empty($name)) continue;
                    
                        $filename1 = '';
                        $filename2 = '';
                    
                        // Upload partner_attach1
                        if (isset($attach1['error'][$i]) && $attach1['error'][$i] === UPLOAD_ERR_OK) {
                            $originalName1 = pathinfo($attach1['name'][$i], PATHINFO_FILENAME);
                            $ext1 = pathinfo($attach1['name'][$i], PATHINFO_EXTENSION);
                            $filename1 = $originalName1 . '_' . uniqid() . "_$i." . $ext1;
                            $upload_path1 = './assets/uploads/documents/' . $filename1;
                            move_uploaded_file($attach1['tmp_name'][$i], $upload_path1);
                        }
                    
                        // Upload partner_attach2
                        if (isset($attach2['error'][$i]) && $attach2['error'][$i] === UPLOAD_ERR_OK) {
                            $originalName2 = pathinfo($attach2['name'][$i], PATHINFO_FILENAME);
                            $ext2 = pathinfo($attach2['name'][$i], PATHINFO_EXTENSION);
                            $filename2 = $originalName2 . '_' . uniqid() . "_$i." . $ext2;
                            $upload_path2 = './assets/uploads/documents/' . $filename2;
                            move_uploaded_file($attach2['tmp_name'][$i], $upload_path2);
                        }
                    
                        // Prepare partner data
                        $partner_data = array(
                            'staff_id'    => $e_id,
                            'pd_name'     => $name,
                            'pd_email'    => $partner_emails[$i],
                            'pd_mobile'   => $partner_mobiles[$i],
                            'pd_dob'      => $partner_dobs[$i],
                        );
                    
                        // Add file paths only if new file was uploaded
                        if (!empty($filename1)) $partner_data['attachment1'] = $filename1;
                        if (!empty($filename2)) $partner_data['attachment2'] = $filename2;
                    
                        // Check if record already exists for this staff and mobile
                        $existing = $this->db->get_where('multi_user', [
                            'staff_id' => $e_id,
                            'pd_mobile' => $partner_mobiles[$i]
                        ])->row();
                    
                        if ($existing) {
                            // Update existing entry
                            $this->db->where('id', $existing->id);
                            $this->db->update('multi_user', $partner_data);
                        } else {
                            // Insert new entry
                            $this->db->insert('multi_user', $partner_data);
                        }
                    }

                /* End Partner Director */
                
                
               /* if ($data['active'] == 1) {
                    $this->sendEmailOnHLCAdd($data);
                }*/
               
                $msg = 'Updated Successfully..!';
            } else {
                // Check if it's a new record, then validate username, mobile number, and email uniqueness
                if (!$this->isPanUnique("pan_no", "mst_staff", $data['pan_no'])) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'PAN number is already registered. Please use a different one.');
                    echo json_encode($message);
                    exit;
                }
                
    
                if (!$this->isMobileUnique("mobile","mst_staff",$data['mobile'])) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Mobile number is already registered. Please use a different one.');
                    echo json_encode($message);
                    exit;
                }
    
                if (!$this->isEmailUnique($data['email'])) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Email is already registered. Please use a different one.');
                    echo json_encode($message);
                    exit;
                }

                if (!$this->isBankacctnoUnique($data['bank_acct_no'],"mst_staff","bank_acct_no")) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Bank Account is already registered. Please use a different one.');
                    echo json_encode($message);
                    exit;
                }
                
                 $query = $this->db->query("SELECT MAX(sr_no) as last_staff_id FROM mst_staff");
                    if ($query->num_rows() > 0) {
                        $row = $query->row();
                        $data['sr_no'] = $row->last_staff_id + 1;
                    }
    
                $res = $this->db->insert('mst_staff', $data);
                $msg = 'Added Successfully..!';
                $e_id = $this->db->insert_id();
                $this->sendEmailOnHLCAdd($data);
                
                     /* Start Insertion Partner Director Details */
                   
                    $partner_names   = $this->input->post('pd_name');
                    $partner_emails  = $this->input->post('pd_email');
                    $partner_mobiles = $this->input->post('pd_mobile');
                    $partner_dobs    = $this->input->post('pd_dob');
                   
                    // Ensure all are arrays
                    $partner_names   = is_array($partner_names) ? $partner_names : [];
                    $partner_emails  = is_array($partner_emails) ? $partner_emails : [];
                    $partner_mobiles = is_array($partner_mobiles) ? $partner_mobiles : [];
                    $partner_dobs    = is_array($partner_dobs) ? $partner_dobs : [];
                    
                   
                    $attach1 = $_FILES['partner_attach1'];
                    $attach2 = $_FILES['partner_attach2'];
                    
                    foreach ($partner_names as $i => $name) {
                        if (empty($name)) continue;
                    
                        $filename1 = '';
                        $filename2 = '';
                    
                        // Upload partner_attach1
                        if (isset($attach1['error'][$i]) && $attach1['error'][$i] === UPLOAD_ERR_OK) {
                            $originalName1 = pathinfo($attach1['name'][$i], PATHINFO_FILENAME);
                            $ext1 = pathinfo($attach1['name'][$i], PATHINFO_EXTENSION);
                            $filename1 = $originalName1 . '_' . uniqid() . "_$i." . $ext1;
                            $upload_path1 = './assets/uploads/documents/' . $filename1;
                            move_uploaded_file($attach1['tmp_name'][$i], $upload_path1);
                        }
                    
                        // Upload partner_attach2
                        if (isset($attach2['error'][$i]) && $attach2['error'][$i] === UPLOAD_ERR_OK) {
                            $originalName2 = pathinfo($attach2['name'][$i], PATHINFO_FILENAME);
                            $ext2 = pathinfo($attach2['name'][$i], PATHINFO_EXTENSION);
                            $filename2 = $originalName2 . '_' . uniqid() . "_$i." . $ext2;
                            $upload_path2 = './assets/uploads/documents/' . $filename2;
                            move_uploaded_file($attach2['tmp_name'][$i], $upload_path2);
                        }
                    
                        // Prepare partner data
                        $partner_data = array(
                            'staff_id'    => $e_id,
                            'pd_name'     => $name,
                            'pd_email'    => $partner_emails[$i],
                            'pd_mobile'   => $partner_mobiles[$i],
                            'pd_dob'      => $partner_dobs[$i],
                        );
                    
                        // Add file paths only if new file was uploaded
                        if (!empty($filename1)) $partner_data['attachment1'] = $filename1;
                        if (!empty($filename2)) $partner_data['attachment2'] = $filename2;
                    
                      
                        // Insert new entry
                        $this->db->insert('multi_user', $partner_data);
                        
                    }

                /* End Partner Director */
                
            }
    
            if ($res == 1) {
                $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
                $this->session->set_flashdata('response_message', $message);
            } else {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Didnt Added. Please try after some time..!');
            }
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');
        }
    
        echo json_encode($message);
    }else{
        die;
    }
    }
    

    
    private function sendEmailOnHLCAdd($data)
{ 
    
    $phpMailerLib = new PHPMailerLib();

    // Email content
    $to = $data['email'];
    $subject = 'Welcome to MortgageBuddy Online Portal';
    $message = "Hello " . $data['staff_fullname'] . ",<br><br>";
    $message .= "Greetings! <br><br>";
    $message .= "Thank you for registering with MortgageBuddy Private Limited, India's leading Corporate Home Loan HLC for State Bank of India.! <br><br>";
    $message .= "Your HLC Code with us is: " . $data['hlc_code'] . "<br>";
    $message .= "Your Online Portal Username is: " . $data['email'] . "<br>";
    $message .= "Your password is: " . $data['staff_password'] . "<br><br>";
    $message .= "You can log in using the following link: <a href='https://mortgagebuddy.in/online/'>Login</a><br><br>";
    $message .= "<p>In case of business-related query, you can contact - Mr Swapnil Gugale (9082102228) or Mr Hardik Chandvania (88888121777)</p>";
    $message .= "<p style='margin-top:-12px;'>In case of accounts, taxes, and payment related queries, you can contact - Ms Manisha Shelar or Mr Krishna Pal (Mobile - 8830394993, Email - <a href='mailto:accounts@mortgagebuddy.in'>accounts@mortgagebuddy.in</a>)</p><br>";
    
    $message .= "<b><p>Wish you all the best!</p></b><br>";
    $message .= "<b><p style='color:#7f6000'>Thanks & Regards,</p></b>";
    $message .= "<b><p style='color:#7f6000;margin-top:-12px;'>Admin Team</p></b>";
    $message .= "<img src='" . base_url() . "assets/site_img/mailfooterlogo.jpg' alt='MortgageBuddy Logo'>";

    
    // Send email
    if ($phpMailerLib->sendEmail($to, $subject, $message)) {
        //echo 'Email sent successfully';
    } else {
        //echo 'Email could not be sent';
    }

}

public function testmail()
{ 
    
    $phpMailerLib = new PHPMailerLib();

    // Email content
    $to = 'tech@loanmani.com';
   // $to = 'deepalisangale3@gmail.com';
    $subject = 'Welcome to MortgageBuddy Online Portal';
    $message = "Hello Admin,<br><br>";
    $message .= "Greetings! <br><br>";
    $message .= "Thank you for registering with MortgageBuddy Private Limited, India's leading Corporate Home Loan HLC for State Bank of India.! <br><br>";
    $message .= "Your HLC Code with us is: MAHB000121<br>";
    $message .= "Your Online Portal Username is: tech@loanmani.com <br>";
    $message .= "Your password is: 123456<br><br>";
    $message .= "You can log in using the following link: <a href='https://mortgagebuddy.in/online/'>Login</a><br><br>";
    $message .= "<p>In case of business-related query, you can contact - Mr Swapnil Gugale (9082102228) or Mr Hardik Chandvania (88888121777)</p>";
    $message .= "<p style='margin-top: -12px;'>In case of accounts, taxes, and payment related queries, you can contact - Ms Manisha Shelar or Mr Krishna Pal (Mobile - 8830394993, Email - <a href='mailto:accounts@mortgagebuddy.in'>accounts@mortgagebuddy.in</a>)</p><br>";
    
    $message .= "<b><p>Wish you all the best!</p></b><br>";
    $message .= "<b><p style='color:#7f6000'>Thanks & Regards,</p></b>";
    $message .= "<b><p style='color:#7f6000;margin-top: -12px;'>Admin Team</p></b>";
    $message .= "<img src='" . base_url() . "assets/site_img/mailfooterlogo.jpg' alt='MortgageBuddy Logo'>";


    
    // Send email
    if ($phpMailerLib->sendEmail($to, $subject, $message)) {
        echo 'Email sent successfully';
    } else {
        echo 'Email could not be sent';
    }

}
    private function deleteFile($filename) {
        $filepath = './assets/uploads/documents/' . $filename;
        if (file_exists($filepath)) {
            @unlink($filepath);
        }
    }

    // Function to check if the mobile number is unique
    private function isMobileUnique($var_name,$tblname,$colname) {
        $this->db->where($var_name, $colname);
        return $this->db->get($tblname)->num_rows() == 0;
    }
    
    // Function to check if the email is unique
    private function isEmailUnique($email) {
        $this->db->where('email', $email);
        return $this->db->get('mst_staff')->num_rows() == 0;
    }
    // Function to check if the isBankacctnoUnique is unique
    private function isBankacctnoUnique($Bankacctno,$tblname,$colname) {
        $this->db->where($colname, $Bankacctno);
        return $this->db->get($tblname)->num_rows() == 0;
    }

    // Model function to check if PAN number is unique
public function isPanUnique($field, $table, $panNumber) {
    $this->db->where($field, $panNumber);
    $query = $this->db->get($table);

    return $query->num_rows() === 0; // Returns true if PAN number is unique
}

    



    public function connectors_form($id = '') {

        $data['current_page'] = 'Connectors';

        $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
        $data['circle'] = $this->db->select("*")->from('mst_circle')->where('active', 1)->get()->result_array();
        $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
        
        $data['SalesCo'] = $this->db->select("*")->from('mst_staff')->where('role_id', '7')->get()->result_array();
        $data['ASM'] = $this->db->select("*")->from('mst_staff')->where('role_id', '8')->get()->result_array();  // Area Sales Manager
        $data['Zonal'] = $this->db->select("*")->from('mst_staff')->where('role_id', '9')->get()->result_array();  // Zonal Sales Manager 
        $data['RSM'] = $this->db->select("*")->from('mst_staff')->where('role_id', '10')->get()->result_array();  // Regional Sales Manager 
        $data['aggr'] = $this->db->select("*")->from('mst_staff')->where('role_id', '11')->get()->result_array();  // Sales Aggregator 

        if ($id != '') {

            $data['title'] = 'Edit Partner';

            $data['Connectors'] = $this->ccm->get_single_row('mst_staff', array('staff_id' => $id));
            
            $data['Partners'] = $this->db->select("*")->from('multi_user')->where('staff_id', $id)->get()->result_array();

        } else {

            $data['title'] = 'Add Partner';

        }

        $data['viewfile'] = 'admin/manage_connectors/connectors_form';

        $this->load->view('admin/layout', $data);

    }

 public function get_last_serial_number_hlc() {
    // Load the database library
    $this->load->database();

    // Write your direct database query
    $query = $this->db->query("SELECT MAX(sr_no) as last_staff_id FROM mst_staff");

    // Prepare response
    $response = array(
        'success' => false,
        'serial_number' => ''
    );

    if ($query->num_rows() > 0) {
        $row = $query->row();
        $response['success'] = true;
        $response['serial_number'] = $row->last_staff_id + 1;
    }

    // Send JSON response
    $this->output
        ->set_content_type('application/json')
        ->set_output(json_encode($response));
}



//pending RR
public function pending_rr_form($id = ''){

    $data['current_page'] = 'Users';
   
    $data['title'] = 'RR Account';

    $data['viewfile'] = 'admin/manage_users/rr_form';

    $this->load->view('admin/layout', $data);

}

public function get_details_applicant() {
        $los_id = $this->input->post('los_id');
        $user_details = $this->ccm->get_user_details_by_los_id($los_id);

        if ($user_details) {
            if ($user_details->rinnraksha_status == 'Yes') {
                echo json_encode(array('error' => 'Already RR account created for this LOS ID.'));
            } else {
                echo json_encode(array('user_name' => $user_details->user_name));
            }
        } else {
            echo json_encode(array('error' => 'No details found for this LOS ID.'));
        }
    }
 
 public function submit_pending_rr() { 
 $applicant_data = $this->ccm->get_user_details_by_los_id($_POST['los_id']);
 $additional_entry_data = array(
                    'loan_type_id' => 5,
                    'connector_id' => $applicant_data->connector_id,
                    'branch_id' => $applicant_data->branch_id,
                    'user_name' => $applicant_data->user_name,
                    'user_phone' => $applicant_data->user_phone,
                    'user_email' => $applicant_data->user_email,
                    'state_id' => $applicant_data->state_id,
                    'city_id' => $applicant_data->city_id,
                    'user_address' => $applicant_data->user_address,
                    'los_id' => $applicant_data->los_id,
                    'bank_acct_no' => $applicant_data->bank_acct_no,
                    'rinnraksha_status' => $_POST['rinnraksha_status'],
                    'sanction_amt' => $_POST['rinnraksha_amt'],
                    'rinnraksha_amt' => $_POST['rinnraksha_amt'],
                    'rr_cbs_acct_no' => $_POST['rr_cbs_acct_no'],
                    'disb_date' => $_POST['disb_date'],
                    'status' => $_POST['status'],
                    'login_code' => $applicant_data->login_code,
                    'created_by' => $_SESSION['staff_id']
                   
                );
                // Insert the additional entry
               $res = $this->db->insert('mst_user', $additional_entry_data);
                $rr_id = $this->db->insert_id();
                $this->db->where('id', $applicant_data->id);
                $rr_data['applicant_rr_id']= $rr_id;
                $rr_data['rinnraksha_status']= 'Yes';
                $this->db->update('mst_user', $rr_data);
                
                $config['upload_path'] = realpath('./assets/uploads/documents/');
                $config['allowed_types'] = 'jpg|jpeg|png|pdf'; // Add or modify file types as needed
                $config['max_size'] = 3072; // Maximum file size in kilobytes
                $config['file_name'] = 'proof_disb' . date('dmYhis') . '_' . rand(0, 999999);
                $this->upload->initialize($config);
            
                    if ($this->upload->do_upload('proof_disb')) {
                        // Save appraisal letter information to appraisal_letters table
                        $appraisal_letter_data2 = array(
                            'user_id' => $rr_id,
                            'proof_disb' => $this->upload->data('file_name'),
                            'add_date' => date('Y-m-d H:i:s'),
                            'uploaded_by' => $_SESSION['staff_id']
                        );
                        $this->db->insert('appraisal_letters', $appraisal_letter_data2);
                    } else {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => $this->upload->display_errors()));
                        return;
                    }
                
               $msg = 'Added Successfully..!';  
              if ($res == 1) {
                $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
                $this->session->set_flashdata('response_message', $message);
             } else {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Didnt Added. Please try after some time..!');
             }
                 echo json_encode($message);
                 
 }
 
 public function check_duplicate_rr_cbs_acct_no() {
        $rr_cbs_acct_no = $this->input->post('rr_cbs_acct_no');
        $is_duplicate = $this->ccm->is_duplicate_rr_cbs_acct_no($rr_cbs_acct_no);

        if ($is_duplicate) {
            echo json_encode(array('error' => 'Duplicate RR CBS Account Number'));
        } else {
            echo json_encode(array('success' => 'RR CBS Account Number is unique.'));
        }
    }
 
 
 
    public function submit_tds_certificate() {
    if ($_POST) {
        $ids = $this->input->post('id');
        $connector_ids = $this->input->post('connector_id');
        $quarters = $this->input->post('quarter'); // Fetch the quarter input
        $files = $_FILES['tds_file'];
        $res = false;
        $msg = '';

        // Iterate through each row in the form
        for ($i = 0; $i < count($connector_ids); $i++) {
            $id = isset($ids[$i]) ? $ids[$i] : null;
            $connector_id = $connector_ids[$i];
            $quarter = $quarters[$i];
            $file_name = $files['name'][$i] ?? '';
            $staff_fullname = $this->Hlc_model->get_staff_fullname($connector_id); // Fetch staff full name

            // Check if a file exists for upload
            $uploaded_file = '';
            if (!empty($file_name)) {
                $uploaded_file = $this->upload_file_tds($files, $i, $quarter, $staff_fullname); // Adjusted for quarter
                if (!$uploaded_file) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'File upload failed.');
                    echo json_encode($message);
                    return;
                }
            }

            // Determine whether to update or insert
            if ($id) {
                // Existing record: Update
                $existing_tds = $this->Hlc_model->get_tds_certificate_by_id($id);
                if ($existing_tds && !empty($uploaded_file)) {
                    // Delete old file if a new one is uploaded
                    $old_file_path = './assets/uploads/tds/' . $existing_tds->tds_file;
                    if (file_exists($old_file_path)) {
                        unlink($old_file_path);
                    }
                }
                $data = [
                    'connector_id' => $connector_id,
                    'quarter' => $quarter,
                    'tds_file' => !empty($uploaded_file) ? $uploaded_file : $existing_tds->tds_file,
                    'created_by' => $_SESSION['staff_id']
                ];
                $res = $this->Hlc_model->update_tds($id, $data);
                $msg = 'Updated Successfully!';
            } else {
                // New record: Insert
                $existing_tds = $this->Hlc_model->get_existing_tds_by_quarter($connector_id, $quarter); // Updated method
                if ($existing_tds) {
                    // Handle duplicate record
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'TDS certificate for this partner and quarter already exists.');
                    echo json_encode($message);
                    return;
                }
                $data = [
                    'connector_id' => $connector_id,
                    'quarter' => $quarter,
                    'tds_file' => $uploaded_file,
                    'created_by' => $_SESSION['staff_id']
                ];
                $res = $this->Hlc_model->insert_tds($data);
                $msg = 'Added Successfully!';
            }
        }

        // Set response message
        if ($res) {
            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Operation failed. Please try again later.');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please fill out the form before submitting.');
    }

    echo json_encode($message);
}



    private function upload_file_tds($files, $index, $month, $staff_fullname) {
        $_FILES['file']['name'] = $files['name'][$index];
        $_FILES['file']['type'] = $files['type'][$index];
        $_FILES['file']['tmp_name'] = $files['tmp_name'][$index];
        $_FILES['file']['error'] = $files['error'][$index];
        $_FILES['file']['size'] = $files['size'][$index];

        $monthName = date('FY', strtotime($month)); // Get month name from the month value
        $uniqueID = uniqid(); // Generate a unique ID
        $extension = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION); // Get the file extension
        $staff_fullname_sanitized = preg_replace('/[^a-zA-Z0-9_]/', '_', $staff_fullname); // Sanitize the staff full name
        $newFileName = $staff_fullname_sanitized . '_' . $monthName . '_' . $uniqueID . '.' . $extension; // Concatenate staff full name, month name, and unique ID with extension

        $config['upload_path'] = './assets/uploads/tds/';
        $config['allowed_types'] = 'jpg|png|jpeg|pdf';
        $config['max_size'] = 2048; // 2MB
        $config['file_name'] = $newFileName; // Set the new file name

        $this->upload->initialize($config);

        if ($this->upload->do_upload('file')) {
            return $this->upload->data('file_name');
        } else {
            return false;
        }
    }
    
   public function tds_certificate_form($id = ''){

    $data['current_page'] = 'TDS Certificate';
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
   
    if ($id != '') {
    $data['title'] = 'Details';
    $data['tds'] = $this->ccm->get_single_row('mst_tds_certificate', ['id' => $id]);
    
    //print_r($data['tds']); die;

    // Fetch all TDS files for the selected connector
    if (!empty($data['tds'])) {
        $data['tds_files'] = $this->db->select('*')
                                      ->from('mst_tds_certificate')
                                      ->where(['connector_id' => $data['tds']->connector_id])
                                      ->get()
                                      ->result_array();
            } else {
                $data['tds_files'] = [];
            }
        } else {
            $data['title'] = 'TDS Certificate';
            $data['tds_files'] = [];
        }



    $data['viewfile'] = 'admin/manage_connectors/tds_certificate_form';
    $this->load->view('admin/layout', $data);

} 

public function manage_tds_certificate() {  
    $data['current_page'] = 'TDS Certificate';
    $data['title'] = 'TDS Certificate';
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['viewfile'] = "admin/manage_connectors/manage_tds_certificate";
    $this->load->view('admin/layout', $data);
}

/*public function fetch_tds_certificate() {
    $requestData = $_REQUEST;
    
    $columns = [
        0 => 'id',
        1 => 'staff_fullname',       
        2 => 'quarter',
        3 => 'tds_file',     
        4 => 'action'
    ];

    // Fetch total records without any filtering
    $totalData = $this->db->count_all('mst_tds_certificate');

    // Fetch filtered data
    $this->db->select('tds.*, s.staff_fullname');
    $this->db->from('mst_tds_certificate tds');
    $this->db->join('mst_staff s', 'tds.connector_id = s.staff_id', 'left');

    // Filter by staff_type
    if ($_SESSION['staff_type'] == 1) {
        $this->db->where('tds.connector_id', $_SESSION['staff_id']);
    }

    if (!empty($requestData['search']['value'])) {
        $this->db->group_start();
        $this->db->like('tds.month', $requestData['search']['value']);
        $this->db->or_like('s.staff_fullname', $requestData['search']['value']);
        $this->db->group_end();
    }

    if (!empty($requestData['filter_month'])) {
        $this->db->where('tds.month', $requestData['filter_month']);
    }

    if (!empty($requestData['filter_connector'])) {
        $this->db->where('tds.connector_id', $requestData['filter_connector']);
    }

    $totalFiltered = $this->db->count_all_results('', false);

    if ($requestData['length'] != -1) {
        $this->db->limit($requestData['length'], $requestData['start']);
    }

    $query = $this->db->get();

    $data = [];
    $ser = 1;
    foreach ($query->result_array() as $key => $row) {
        $nestedData = [];
        $nestedData[] = $ser++; // Sr.No
        $nestedData[] = $row['staff_fullname'];      
        $nestedData[] = $row['quarter'];
        $nestedData[] = '<a href="' . base_url('assets/uploads/tds/' . $row['tds_file']) . '" target="_blank">View TDS</a>';
        if ($_SESSION['staff_type'] == 0) {
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">
                                <a href="' . base_url('admin/tds_certificate_form/' . $row['id']) . '" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>
                                <a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_tds_certificate"><i class="bi bi-trash-fill"></i></a>
                             </div>';
        } else {
            $nestedData[] = ''; // No action for non-admin users
        }

        $data[] = $nestedData;
    }


    $json_data = [
        "draw"            => intval($requestData['draw']),
        "recordsTotal"    => intval($totalData),
        "recordsFiltered" => intval($totalFiltered),
        "data"            => $data
    ];

    echo json_encode($json_data);
}*/


public function fetch_tds_certificate() {
    $requestData = $_REQUEST;

    $columns = [
        0 => 'id',
        1 => 'staff_fullname',
        2 => 'quarter',
        3 => 'tds_file',
    ];

    // Fetch total records without any filtering
    $totalData = $this->db->count_all('mst_tds_certificate');

    // Fetch filtered data
    $this->db->select('tds.connector_id, s.staff_fullname, GROUP_CONCAT(CONCAT(tds.quarter, "::", tds.tds_file, "::", tds.id) ORDER BY tds.quarter ASC SEPARATOR "|") AS grouped_files');

    $this->db->from('mst_tds_certificate tds');
    $this->db->join('mst_staff s', 'tds.connector_id = s.staff_id', 'left');

    // Filter by staff_type
    if ($_SESSION['staff_type'] == 1) {
        $this->db->where('tds.connector_id', $_SESSION['staff_id']);
    }

    if (!empty($requestData['search']['value'])) {
        $this->db->group_start();
        $this->db->like('s.staff_fullname', $requestData['search']['value']);
        $this->db->or_like('tds.quarter', $requestData['search']['value']);
        $this->db->group_end();
    }

    if (!empty($requestData['filter_connector'])) {
        $this->db->where('tds.connector_id', $requestData['filter_connector']);
    }

    // Group by connector and order entries by connector_id descending
    $this->db->group_by('tds.connector_id');
    //$this->db->order_by('tds.connector_id', 'DESC');
     $this->db->order_by('MAX(tds.add_date)', 'DESC');

    $totalFiltered = $this->db->count_all_results('', false);

    if ($requestData['length'] != -1) {
        $this->db->limit($requestData['length'], $requestData['start']);
    }

    $query = $this->db->get();

    // Build the data for DataTable
    $data = [];
    $ser = 1;
    foreach ($query->result_array() as $row) {
        $nestedData = [];
        $nestedData[] = $ser++; // Sr.No
        $nestedData[] = $row['staff_fullname'];

        // Combine files information for the connector
        $filesInfo = '';
        $groupedFiles = explode('|', $row['grouped_files']);
     foreach ($groupedFiles as $fileInfo) {
    list($quarter, $file, $fileId) = explode('::', $fileInfo); // Extract file ID
    $filesInfo .= '<a href="' . base_url('assets/uploads/tds/' . $file) . '" target="_blank">View TDS - ' . $quarter . '</a>';
    if ($_SESSION['staff_type'] == 0) {
        // Pass the file ID for deletion
        $filesInfo .= ' <a href="javascript:;" class="text-danger delete_tds" data-id="' . $fileId . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_tds_certificate"><i class="bi bi-trash-fill"></i></a>';
    }
    $filesInfo .= '<br>';
}



        $nestedData[] = $filesInfo;

        $data[] = $nestedData;
    }

    $json_data = [
        "draw"            => intval($requestData['draw']),
        "recordsTotal"    => intval($totalData),
        "recordsFiltered" => intval($totalFiltered),
        "data"            => $data
    ];

    echo json_encode($json_data);
}






public function delete_tds_certificate() {
    $id = $this->input->post('id');

    // Get the TDS certificate record
    $this->db->select('tds_file');
    $this->db->where('id', $id);
    $query = $this->db->get('mst_tds_certificate');
    $tds_certificate = $query->row();

    if ($tds_certificate) {
        // Delete the file
        $file_path = './assets/uploads/tds/' . $tds_certificate->tds_file;
        if (file_exists($file_path)) {
            unlink($file_path);
        }

        // Delete the record from the database
        $this->db->where('id', $id);
        $res = $this->db->delete('mst_tds_certificate');

        if ($res) {
            $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully...!');
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Failed to delete. Please try again later..!');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'TDS certificate not found.');
    }

    echo json_encode($message);
}

//paisabazar 
public function manage_pb_users() {  
  
    $data['current_page'] = 'Applicants PB';
    $data['title'] = 'Applicants Report';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['connector_created'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 0])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
    
    $this->updatePartPayout();

    $data['viewfile'] = "admin/manage_users/manage_pb_users";
    $this->load->view('admin/layout', $data);
}

public function manage_archive_pb_users() {  
    $data['current_page'] = 'manage_archive_pb_users';
    $data['title'] = 'Applicants Archive PB';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_users/archive_user_pb";
    $this->load->view('admin/layout', $data);
}


public function manage_pb_users_nonverified() {  
    $data['current_page'] = 'List PB Non-verified';
    $data['title'] = 'Applicants PB';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_users/manage_pb_users_nonverified";
    $this->load->view('admin/layout', $data);
}



public function verify_pb_user($id, $status) {
    $data["is_verify"] = $status;
    $data["verify_by"] = $_SESSION['staff_id'];
    $this->db->where('id', $id);

    if ($this->db->update("mst_user", $data)) {
        if ($status == 0) {
            $message = array('success' => '1', 'type' => 'success', 'message' => 'Applicant has been marked as Non-Verified.');
        } else {
            $message = array('success' => '1', 'type' => 'success', 'message' => 'Applicant has been successfully verified.');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Update failed. Please try again later.');
    }

    echo json_encode($message);
}

public function pb_user_form($id = ''){

    $data['current_page'] = 'Add Applicant';
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['loan_type'] = $this->db->select("*")->from('mst_loan_type')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
    $data['circle'] = $this->db->select("*")->from('mst_circle')->where('active', 1)->get()->result_array();
    $data['selectedLoginType'] = $this->input->post('selectedFormType');

    if ($id != '') {
        $data['user'] = $this->ccm->get_single_row('mst_user', array('id' => $id));
        $data['title'] = 'Applicant Details-'. $data['user']->login_code;
        
      
        $user_id = $id;

        // Fetch appraisal letters
        $this->db->where('user_id', $user_id);
        $this->db->order_by('add_date', 'DESC');
        $query = $this->db->get('appraisal_letters');
        $data['appraisal_letters'] = $query->result();
        $data['final_sanction_letter'] = $query->result();
        $data['proof_disb'] = $query->result();

        
    } else {
        $data['title'] = 'Applicants PB';
    }
    $data['viewfile'] = 'admin/manage_users/pb_user_form';
    $this->load->view('admin/layout', $data);

}

public function fetch_pb_user() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $created_by_part = $this->input->post('created_by_part');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $pb_payment_status = $this->input->post('pb_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $pb_generated = $this->input->post('pb_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $rbo = $this->input->post('rbo');
    $team_leader = $this->input->post('team_leader');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('Paisabazar_model');

    $total_data = $this->Paisabazar_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$team_leader);
    $total_filtered = $this->Paisabazar_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$team_leader);

    $user_data = $this->Paisabazar_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$team_leader);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("rbo_id,branch_name,branch_code")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("state_name")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("city_name,agency_code, agency_name")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("rbo_name")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("inv_batchno,invoice_number")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_pb_data = $this->db->select("inv_batchno,invoice_number")->from('invoices')->where(['id' => $row['pb_invoice_id']])->get()->row();
        //$inv_sbi_data = $this->db->select("inv_batchno,invoice_number")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        //$inv_branch_data = $this->db->select("inv_batchno,invoice_number")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }
        
        if($row['pb_payment_status']=='paid'){
            $statusPB = 'paid';
        } elseif($row['pb_payment_status']=='excess paid') {
            $statusPB = "excess paid";
        } elseif($row['pb_payment_status']=='partly paid') {
            $statusPB = "partly paid";
        } elseif($row['pb_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusPB = "unpaid";
        } else {
            $statusPB = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }
        
        if($statusPB == "unpaid") {
            $badge_class_bp = "badge bg-danger";
        } elseif($statusPB=="paid") {
            $badge_class_bp = "badge bg-success";
        } elseif($statusPB=="excess paid") {
            $badge_class_bp = "badge bg-warning";
        } elseif($statusPB=="partly paid") {
            $badge_class_bp = "badge bg-info";
        } else {
            $badge_class_bp = '';
        }
        

        // SBI payment status
       /* if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }*/

        $nestedData = array();
             $cbsNoCheck = ($row['loan_type_id'] == 5) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];

            if (!empty($row['los_id']) && !empty($cbsNoCheck) && !empty($row['disb_date'])) {
                $nestedData['checkbox'] = '<input type="checkbox" class="row-checkbox" value="' . $row['id'] . '">';
            }else {
                // If conditions not met, add an empty placeholder to prevent DataTables error
                $nestedData['checkbox'] = '';
            }
           if($row['todays_payment'] == 'Yes'){
                $nestedData['checkbox'] = '';
            } 
           if($row['payment_approve_status'] == '0'){
               $nestedData['checkbox'] = '<input type="checkbox" class="row-checkbox" value="' . $row['id'] . '">';
            } 

        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $loanAmt = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) 
            ? $row['rinnraksha_amt'] 
            : $row['sanction_amt'];
        
        // Ensure $loanAmt is a valid numeric value
        $loanAmt = str_replace(',', '', $loanAmt); // Remove commas if present
        $loanAmt = is_numeric($loanAmt) ? (float) $loanAmt : 0; // Convert to float safely

        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_commision'] = ($row['loan_type_id'] == 4) ? '0.20' : $row['part_payout'];
        $nestedData['remuneration'] = formatIndianNumber($loanAmt * 0.95 / 100);
       
        $nestedData['conn_payout_amt'] = formatIndianNumber($loanAmt * (($row['loan_type_id'] == 4) ? 0.20 / 100 : ($row['part_payout'] / 100)));
    
        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        $nestedData['hlc_generated'] = ($row['applicant_invoice_status'] == 'Generated') ? '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/{$inv_hlc_data->inv_batchno}") . '" target="_BLANK">' . $inv_hlc_data->invoice_number . '</a>' : 'No';
        $nestedData['hlc_payment_status'] = "<span class=\"{$badge_class}\">{$statusP}</span>";
     
   
        $nestedData['pb_generated'] = ($row['pb_genrated'] == 'Yes') ? '<a href="' . base_url("Invoice_pdf_pb/generatePDF/{$inv_pb_data->inv_batchno}") . '" target="_BLANK">' . $inv_pb_data->invoice_number . '</a>' : 'No';
        $nestedData['pb_payment_status'] = "<span class=\"{$badge_class_bp}\">{$statusPB}</span>";
        
        $nestedData['sbi_pb_invoice_no'] = '<input type="text" class="form-control sbi-pb-invoice-no-input" data-id="'.$row['id'].'" value="'.$row['sbi_pb_invoice_no'].'" style="width: 200px;" />';
      
                $bgClass = '';
                if ($row['sbi_pb_payment_status'] == 'paid') {
                    $bgClass = 'bg-success'; // Green for Paid
                } elseif ($row['sbi_pb_payment_status'] === NULL || $row['sbi_pb_payment_status'] == 'unpaid') {
                    $bgClass = 'bg-danger'; // Red for unpaid
                }
                
        $nestedData['sbi_pb_payment_status'] = '<select class="form-select form-select-sm commoon_paid_unpaid_sbi_pb_invoice ' . $bgClass . '" style="width: 100px;"
                                                      data-id="' . $row['id'] . '" 
                                                      action="' . base_url('admin/paid_unpaid_sbi_pb_invoice') . '">
                                                       <option value="paid" ' . ($row['sbi_pb_payment_status'] == 'paid' ? 'selected' : '') . '>Paid</option>
                                                       <option value="unpaid" ' . (($row['sbi_pb_payment_status'] === NULL || $row['sbi_pb_payment_status'] == 'unpaid') ? 'selected' : '') . '>Unpaid</option>
                                                     </select>';
        
        $nestedData['pb_branch_conf_no'] = '<input type="text" class="form-control pb-branch-conf-no-input" data-id="'.$row['id'].'" value="'.$row['pb_branch_conf_no'].'" style="width: 200px;" />';
      

     
   
      /*  $nestedData['branch_generated'] = ($row['branch_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_branch/generatePDF/{$inv_branch_data->inv_batchno}") . '" target="_BLANK">' . $inv_branch_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_generated'] = ($row['sbi_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_sbi/generatePDF/{$inv_sbi_data->inv_batchno}") . '" target="_BLANK">' . $inv_sbi_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_payment_status'] = "<span class=\"{$badge_class_sbi}\">{$sbistatusP}</span>";*/
        
       
        
            // Get today's date as a DateTime object
$today = date('Y-m-d');
// Convert 'add_date' to Y-m-d format
$add_date = date('Y-m-d', strtotime($row['add_date']));

// Calculate the difference in days based on dates only
$days_difference = (strtotime($today) - strtotime($add_date)) / (60 * 60 * 24);

// Determine the color class based on the difference
if ($days_difference == 0) {
    $dot_color_class = 'green'; // Today
    $dot_text= 'Low';
} elseif ($days_difference <= 2) {
    $dot_color_class = 'orange'; // 2 days ago
    $dot_text= 'Medium';
} elseif ($days_difference == 3) {
    $dot_color_class = 'red'; // 3 days ago
    $dot_text= 'High';
} else {
    $dot_color_class = 'red';
    $dot_text= 'High';// Default (no color)
}
            
            // Add data to $nestedData
            $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
           
           

      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $admin_verify_applicant = $this->db->select('staff_fullname')->where(['staff_id' => $row['verify_by']])->from('mst_staff')->get()->row();
            
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
            
            $nestedData['is_verify'] = ($row['is_verify'] == 1) 
                                    ? '<a href="javascript:void(0);" data-id="'.$row['id'].'">
                                          <span class="badge rounded-pill bg-success commoon_active" action="verify_pb_user" active="0">Verified</span>
                                       </a>'
                                    : '<a href="javascript:void(0);" data-id="'.$row['id'].'">
                                          <span class="badge rounded-pill bg-danger commoon_active" action="verify_pb_user" active="1">Non-verified</span>
                                       </a>';

            $nestedData['verify_by'] = @$admin_verify_applicant->staff_fullname; 
            
             $nestedData['agency_code'] = @$city->agency_code;
             $nestedData['agency_name'] = @$city->agency_name;
 
 
 if($row['loan_type_id'] == 5){
     $doc = 'RR';
 }else{
     $doc = '';
 }
            
            $user_id = $row['id']; // Assuming user ID is in the 'id' field of $row
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); 
$query = $this->db->get();
// Fetch all results as an array of associative arrays
$appraisal_letters = $query->result_array();

// Prepare the appraisal letter links
$appraisalLetterLink = ''; // Initialize an empty string to hold all the links
if (!empty($appraisal_letters)) {
    // Loop through each appraisal letter record
    foreach ($appraisal_letters as $letter) {
        if (!empty($letter['appraisal_letter'])) {
            $appraisalLetterLink .= '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $letter['appraisal_letter'] . '" target="_blank">View</a> ';
        }
    }
} else {
    $appraisalLetterLink = $doc;
}

// Fetch the latest final sanction letter
$this->db->select('final_sanction_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('final_sanction_letter IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query2 = $this->db->get();
$latest_letter_fsl = $query2->row_array(); // Fetch as an associative array

// Prepare the final sanction letter link
$finalSanctionLetterLink = !empty($latest_letter_fsl['final_sanction_letter']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_fsl['final_sanction_letter']) . '" target="_blank">View</a>'
    : '';

// Fetch the latest proof of disbursement
$this->db->select('proof_disb');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('proof_disb IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query3 = $this->db->get();
$latest_letter_pd = $query3->row_array(); // Fetch as an associative array

// Prepare the proof of disbursement link
$proofDisbLink = !empty($latest_letter_pd['proof_disb']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']) . '" target="_blank">View</a>'
    : '';

// Add the links to the nested data array
$nestedData['appraisal_letter'] = $appraisalLetterLink;
$nestedData['final_sanction_letter'] = 
    ($statusPB == 'unpaid' ? '<span class="dot ' . $dot_color_class . '"></span> ' . $dot_text . ' ' : '') . 
    $finalSanctionLetterLink;
    

$nestedData['proof_disb'] = $proofDisbLink;

 


        $archiveModalHtml = '
    <div class="modal fade" id="archiveUserModal' . $row['id'] . '" tabindex="-1" aria-labelledby="archiveUserModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="archiveUserModalLabel' . $row['id'] . '">Archive User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="' . base_url('admin/archive_user') . '" class="archive-form">
                    <div class="modal-body">
                        <p>Are you sure you want to archive this user?</p>
                        <div class="mb-3">
                            <label for="archiveRemark' . $row['id'] . '" class="form-label">Remark</label>
                            <textarea class="form-control" id="archiveRemark' . $row['id'] . '" name="archive_remark" rows="3" required>' . $row['archive_remark'] . '</textarea>
                        </div>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>';
    
    //for today payment
    $partPaymentModalHtml = '
    <div class="modal fade" id="partPaymentModal' . $row['id'] . '" tabindex="-1" aria-labelledby="partPaymentModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="partPaymentModal' . $row['id'] . '">Payment Part. - ' . capitalize_first_three_words($conn->staff_fullname) . '</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
               
                    <div class="modal-body">
                        <p><b>A/c Remark: </b>' . $row['payment_act_remark'] . '</p>
                        <p><b>RLMS: </b>' . $row['los_id'] . '</p>
                        <p><b>Applicant: </b>' . ($row['user_name']) . '</p>
                        <p><b>CBS No: </b>' . (( $row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                        <p><b>Disb Date: </b>' . (!empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A') . '</p>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    
                </form>
            </div>
        </div>
    </div>';

    
         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
    
             $archiveButton = '';
                if ($_SESSION['staff_id'] == 14) {
                    $archiveButton = '
                        <a href="javascript:;" class="text-info" data-bs-toggle="modal" data-bs-target="#archiveUserModal' . $row['id'] . '" data-bs-placement="bottom" title="Archive User" aria-label="Archive">
                            <i class="bi bi-archive-fill"></i>
                        </a>';
                }
                
            $todayPaymentButton = '';

// Determine CBS No based on loan_type_id


if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 1 || $_SESSION['staff_id'] == 13 || $_SESSION['staff_id']== 634) {
    if ($row['todays_payment'] == 'Yes' && $row['payment_approve_status'] != 0) {
        $todayPaymentButton = '
            <span class="text-success" title="Payment already in process">
                <i class="bi bi-check-circle-fill"></i>
            </span>';
    } elseif ($row['payment_approve_status'] === '0') {
        $todayPaymentButton = '
            <a href="javascript:;" class="text-success" data-bs-toggle="modal" data-bs-target="#partPaymentModal' . $row['id'] . '" data-bs-placement="bottom" title="Payment User" aria-label="Payment">
                <img src="' . base_url('assets/site_img/Reject.png') . '" alt="Reject" height="30" width="30">
            </a>';
    }else{
        $todayPaymentButton = "";
    }
}



                 
                $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
                    <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                        <i class="bi bi-eye-fill"></i>
                    </a>
                    <a href="' . base_url('admin/pb_user_form/' . $row['id']) . '" target="_blank" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit info" aria-label="Edit">
                        <i class="bi bi-pencil-fill"></i>
                    </a>';
                
                if ($_SESSION['staff_type'] == 0) {
                    $nestedData['edit'] .= '<a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_user">
                        <i class="bi bi-trash-fill"></i>
                    </a>';
                }
                
                $nestedData['edit'] .= $archiveButton . $todayPaymentButton . '</div>' . $modal_html . $archiveModalHtml . $partPaymentModalHtml;


        $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}

public function fetch_pb_user_archive() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $pb_payment_status = $this->input->post('pb_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $pb_generated = $this->input->post('pb_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('Paisabazar_Archive_model');

    $total_data = $this->Paisabazar_Archive_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo);
    $total_filtered = $this->Paisabazar_Archive_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo);

    $user_data = $this->Paisabazar_Archive_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_pb_data = $this->db->select("*")->from('invoices')->where(['id' => $row['pb_invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }
        
        if($row['pb_payment_status']=='paid'){
            $statusPB = 'paid';
        } elseif($row['pb_payment_status']=='excess paid') {
            $statusPB = "excess paid";
        } elseif($row['pb_payment_status']=='partly paid') {
            $statusPB = "partly paid";
        } elseif($row['pb_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusPB = "unpaid";
        } else {
            $statusPB = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }
        
        if($statusPB == "unpaid") {
            $badge_class_bp = "badge bg-danger";
        } elseif($statusPB=="paid") {
            $badge_class_bp = "badge bg-success";
        } elseif($statusPB=="excess paid") {
            $badge_class_bp = "badge bg-warning";
        } elseif($statusPB=="partly paid") {
            $badge_class_bp = "badge bg-info";
        } else {
            $badge_class_bp = '';
        }
        

        // SBI payment status
       /* if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }*/

        $nestedData = array();
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $loanAmt = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) 
            ? $row['rinnraksha_amt'] 
            : $row['sanction_amt'];
        
        // Ensure $loanAmt is a valid numeric value
        $loanAmt = str_replace(',', '', $loanAmt); // Remove commas if present
        $loanAmt = is_numeric($loanAmt) ? (float) $loanAmt : 0; // Convert to float safely
        
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_commision'] = ($row['loan_type_id'] == 4) ? '0.20' : $row['part_payout'];
        $nestedData['remuneration'] = formatIndianNumber($loanAmt * 0.95 / 100);
       
        $nestedData['conn_payout_amt'] = formatIndianNumber($loanAmt * (($row['loan_type_id'] == 4) ? 0.20 / 100 : ($row['part_payout'] / 100)));
        
     /*   $nestedData['sbi_payout'] = $row['sbi_commi'];
        $sbi_comm = ($loanAmount * $row['sbi_commi']) / 100;
        $nestedData['sbi_commi_amt'] = formatIndianNumber($sbi_comm);
        $ten10_sbi = ($sbi_comm * 10) / 100;
        $nestedData['sbi_ten_per'] = formatIndianNumber($ten10_sbi);
        
        $nestedData['sbi_ninety_per'] = formatIndianNumber($sbi_comm - $ten10_sbi);
*/
        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        $nestedData['hlc_generated'] = ($row['applicant_invoice_status'] == 'Generated') ? '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/{$inv_hlc_data->inv_batchno}") . '" target="_BLANK">' . $inv_hlc_data->invoice_number . '</a>' : 'No';
        $nestedData['hlc_payment_status'] = "<span class=\"{$badge_class}\">{$statusP}</span>";
     
   
        $nestedData['pb_generated'] = ($row['pb_genrated'] == 'Yes') ? '<a href="' . base_url("Invoice_pdf_pb/generatePDF/{$inv_pb_data->inv_batchno}") . '" target="_BLANK">' . $inv_pb_data->invoice_number . '</a>' : 'No';
        $nestedData['pb_payment_status'] = "<span class=\"{$badge_class_bp}\">{$statusPB}</span>";
     
   
      /*  $nestedData['branch_generated'] = ($row['branch_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_branch/generatePDF/{$inv_branch_data->inv_batchno}") . '" target="_BLANK">' . $inv_branch_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_generated'] = ($row['sbi_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_sbi/generatePDF/{$inv_sbi_data->inv_batchno}") . '" target="_BLANK">' . $inv_sbi_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_payment_status'] = "<span class=\"{$badge_class_sbi}\">{$sbistatusP}</span>";*/
        
       
        
            $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $admin_verify_applicant = $this->db->select('staff_fullname')->where(['staff_id' => $row['verify_by']])->from('mst_staff')->get()->row();
            
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
            
            $nestedData['is_verify'] = ($row['is_verify'] == 1) 
                                    ? '<a href="javascript:void(0);" data-id="'.$row['id'].'">
                                          <span class="badge rounded-pill bg-success commoon_active" action="verify_pb_user" active="0">Verified</span>
                                       </a>'
                                    : '<a href="javascript:void(0);" data-id="'.$row['id'].'">
                                          <span class="badge rounded-pill bg-danger commoon_active" action="verify_pb_user" active="1">Non-verified</span>
                                       </a>';

            $nestedData['verify_by'] = @$admin_verify_applicant->staff_fullname;                       
            
            if($row['loan_type_id'] == 5){
     $doc = 'RR';
 }else{
     $doc = '';
 }
 
            $user_id = $row['id']; // Assuming user ID is in the 'id' field of $row
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); 
$query = $this->db->get();
// Fetch all results as an array of associative arrays
$appraisal_letters = $query->result_array();

// Prepare the appraisal letter links
$appraisalLetterLink = ''; // Initialize an empty string to hold all the links
if (!empty($appraisal_letters)) {
    // Loop through each appraisal letter record
    foreach ($appraisal_letters as $letter) {
        if (!empty($letter['appraisal_letter'])) {
            $appraisalLetterLink .= '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $letter['appraisal_letter'] . '" target="_blank">View</a> ';
        }
    }
} else {
    $appraisalLetterLink = $doc;
}

// Fetch the latest final sanction letter
$this->db->select('final_sanction_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('final_sanction_letter IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query2 = $this->db->get();
$latest_letter_fsl = $query2->row_array(); // Fetch as an associative array

// Prepare the final sanction letter link
$finalSanctionLetterLink = !empty($latest_letter_fsl['final_sanction_letter']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_fsl['final_sanction_letter']) . '" target="_blank">View</a>'
    : '';

// Fetch the latest proof of disbursement
$this->db->select('proof_disb');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('proof_disb IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query3 = $this->db->get();
$latest_letter_pd = $query3->row_array(); // Fetch as an associative array

// Prepare the proof of disbursement link
$proofDisbLink = !empty($latest_letter_pd['proof_disb']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']) . '" target="_blank">View</a>'
    : '';

// Add the links to the nested data array
$nestedData['appraisal_letter'] = $appraisalLetterLink;
$nestedData['final_sanction_letter'] = $finalSanctionLetterLink;
$nestedData['proof_disb'] = $proofDisbLink;


         $archiveModalHtml = '
    <div class="modal fade" id="archiveUserModal' . $row['id'] . '" tabindex="-1" aria-labelledby="archiveUserModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="archiveUserModalLabel' . $row['id'] . '">Archive User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="' . base_url('admin/un_archive_user') . '" class="unarchive-form">
                    <div class="modal-body">
                        <p>Are you sure you want to unarchive this user?</p>
                        <div class="mb-3">
                            <label for="archiveRemark' . $row['id'] . '" class="form-label">Remark</label>
                            <textarea class="form-control" id="archiveRemark' . $row['id'] . '" name="archive_remark" rows="3" required></textarea>
                        </div>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>';
    
         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
    
             $archiveButton = '';
                if ($_SESSION['staff_id'] == 14) {
                    $archiveButton = '
                        <a href="javascript:;" class="text-info" data-bs-toggle="modal" data-bs-target="#archiveUserModal' . $row['id'] . '" data-bs-placement="bottom" title="Archive User" aria-label="Archive">
                            <i class="bi bi-archive-fill"></i>
                        </a>';
                }
                
                $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
                    <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                        <i class="bi bi-eye-fill"></i>
                    </a>
                    <a href="' . base_url('admin/pb_user_form/' . $row['id']) . '" target="_blank" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit">
                        <i class="bi bi-pencil-fill"></i>
                    </a>
                    <a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete" action="delete_user">
                        <i class="bi bi-trash-fill"></i>
                    </a>
                    ' . $archiveButton . '
                </div>' . $modal_html . $archiveModalHtml;


        $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}

public function fetch_pb_user_nonverified() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $sbi_payment_status = $this->input->post('sbi_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $sbi_generated = $this->input->post('sbi_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('Pbnon_model');

    $total_data = $this->Pbnon_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated);
    $total_filtered = $this->Pbnon_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated);

    $user_data = $this->Pbnon_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }

        // SBI payment status
        if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }

        $nestedData = array();
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_commision'] = ($row['loan_type_id'] == 4) ? '0.20' : $row['part_payout'];
        
        $loanAmount = $row['loan_type_id'] == 5 ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_payout_amt'] = formatIndianNumber($loanAmount * (($row['loan_type_id'] == 4) ? 0.20 / 100 : ($row['part_payout'] / 100)));
        
        $nestedData['sbi_payout'] = $row['sbi_commi'];
        $sbi_comm = ($loanAmount * $row['sbi_commi']) / 100;
        $nestedData['sbi_commi_amt'] = formatIndianNumber($sbi_comm);
        $ten10_sbi = ($sbi_comm * 10) / 100;
        $nestedData['sbi_ten_per'] = formatIndianNumber($ten10_sbi);
        
        $nestedData['sbi_ninety_per'] = formatIndianNumber($sbi_comm - $ten10_sbi);

        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        $nestedData['hlc_generated'] = ($row['applicant_invoice_status'] == 'Generated') ? '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/{$inv_hlc_data->inv_batchno}") . '" target="_BLANK">' . $inv_hlc_data->invoice_number . '</a>' : 'No';
        $nestedData['hlc_payment_status'] = "<span class=\"{$badge_class}\">{$statusP}</span>";
     
   
        $nestedData['branch_generated'] = ($row['branch_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_branch/generatePDF/{$inv_branch_data->inv_batchno}") . '" target="_BLANK">' . $inv_branch_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_generated'] = ($row['sbi_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_sbi/generatePDF/{$inv_sbi_data->inv_batchno}") . '" target="_BLANK">' . $inv_sbi_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_payment_status'] = "<span class=\"{$badge_class_sbi}\">{$sbistatusP}</span>";
        
       
        
            $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $admin_verify_applicant = $this->db->select('staff_fullname')->where(['staff_id' => $row['verify_by']])->from('mst_staff')->get()->row();
            
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
            
            $nestedData['is_verify'] = ($row['is_verify'] == 1) 
                                    ? '<a href="javascript:void(0);" data-id="'.$row['id'].'">
                                          <span class="badge rounded-pill bg-success commoon_active" action="verify_pb_user" active="0">Verified</span>
                                       </a>'
                                    : '<a href="javascript:void(0);" data-id="'.$row['id'].'">
                                          <span class="badge rounded-pill bg-danger commoon_active" action="verify_pb_user" active="1">Non-verified</span>
                                       </a>';

            $nestedData['verify_by'] = @$admin_verify_applicant->staff_fullname;    
            
           $nestedData['remark'] = '<input type="text" class="form-control remark-input" data-id="'.$row['id'].'" value="'.$row['remark'].'" style="width: 300px;" />';

            if($row['loan_type_id'] == 5){
     $doc = 'RR';
 }else{
     $doc = '';
 }
           $user_id = $row['id']; // Assuming user ID is in the 'id' field of $row
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); // Only the latest record
$query = $this->db->get();
// Fetch all results as an array of associative arrays
$appraisal_letters = $query->result_array();

// Prepare the appraisal letter links
$appraisalLetterLink = ''; // Initialize an empty string to hold all the links
if (!empty($appraisal_letters)) {
    // Loop through each appraisal letter record
    foreach ($appraisal_letters as $letter) {
        if (!empty($letter['appraisal_letter'])) {
            $appraisalLetterLink .= '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $letter['appraisal_letter'] . '" target="_blank">View</a> ';
        }
    }
} else {
    $appraisalLetterLink = $doc;
}

// Fetch the latest final sanction letter
$this->db->select('final_sanction_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('final_sanction_letter IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query2 = $this->db->get();
$latest_letter_fsl = $query2->row_array(); // Fetch as an associative array

// Prepare the final sanction letter link
$finalSanctionLetterLink = !empty($latest_letter_fsl['final_sanction_letter']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_fsl['final_sanction_letter']) . '" target="_blank">View</a>'
    : '';

// Fetch the latest proof of disbursement
$this->db->select('proof_disb');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('proof_disb IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query3 = $this->db->get();
$latest_letter_pd = $query3->row_array(); // Fetch as an associative array

// Prepare the proof of disbursement link
$proofDisbLink = !empty($latest_letter_pd['proof_disb']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']) . '" target="_blank">View</a>'
    : '';

// Add the links to the nested data array
$nestedData['appraisal_letter'] = $appraisalLetterLink;
$nestedData['final_sanction_letter'] = $finalSanctionLetterLink;
$nestedData['proof_disb'] = $proofDisbLink;


        
         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
    
        $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
            <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                <i class="bi bi-eye-fill"></i>
            </a>
            <a href="' . base_url('admin/pb_user_form/' . $row['id']) . '" target="_blank" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>
            <a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete"  action="delete_user"><i class="bi bi-trash-fill"></i></a>
        </div>' . $modal_html;

        $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}


public function manage_pb_users_pending_approval() {  
    $data['current_page'] = 'list_pb_pending_approval';
    $data['title'] = 'PB Pending Approval';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_users/manage_pb_users_pending_approval.php";
    $this->load->view('admin/layout', $data);
}

public function fetch_pb_user_pending_approval() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $sbi_payment_status = $this->input->post('sbi_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $sbi_generated = $this->input->post('sbi_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('Pbpendingapproval_model');

    $total_data = $this->Pbpendingapproval_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated);
    $total_filtered = $this->Pbpendingapproval_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated);

    $user_data = $this->Pbpendingapproval_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }

        // SBI payment status
        if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }

        $nestedData = array();
        
        $nestedData['checkbox'] = '<input type="checkbox" class="row-checkbox" value="' . $row['id'] . '">';
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_commision'] = ($row['loan_type_id'] == 4) ? '0.20' : $row['part_payout'];
        
        $loanAmount = $row['loan_type_id'] == 5 ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_payout_amt'] = formatIndianNumber($loanAmount * (($row['loan_type_id'] == 4) ? 0.20 / 100 : ($row['part_payout'] / 100)));
        
        $nestedData['sbi_payout'] = $row['sbi_commi'];
        $sbi_comm = ($loanAmount * $row['sbi_commi']) / 100;
        $nestedData['sbi_commi_amt'] = formatIndianNumber($sbi_comm);
        $ten10_sbi = ($sbi_comm * 10) / 100;
        $nestedData['sbi_ten_per'] = formatIndianNumber($ten10_sbi);
        
        $nestedData['sbi_ninety_per'] = formatIndianNumber($sbi_comm - $ten10_sbi);

        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        $nestedData['hlc_generated'] = ($row['applicant_invoice_status'] == 'Generated') ? '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/{$inv_hlc_data->inv_batchno}") . '" target="_BLANK">' . $inv_hlc_data->invoice_number . '</a>' : 'No';
        $nestedData['hlc_payment_status'] = "<span class=\"{$badge_class}\">{$statusP}</span>";
     
   
        $nestedData['branch_generated'] = ($row['branch_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_branch/generatePDF/{$inv_branch_data->inv_batchno}") . '" target="_BLANK">' . $inv_branch_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_generated'] = ($row['sbi_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_sbi/generatePDF/{$inv_sbi_data->inv_batchno}") . '" target="_BLANK">' . $inv_sbi_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_payment_status'] = "<span class=\"{$badge_class_sbi}\">{$sbistatusP}</span>";
        
       
        
            $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $admin_verify_applicant = $this->db->select('staff_fullname')->where(['staff_id' => $row['verify_by']])->from('mst_staff')->get()->row();
            
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
            
            $nestedData['is_verify'] = ($row['is_verify'] == 1) 
                                    ? '<a href="javascript:void(0);" data-id="'.$row['id'].'">
                                          <span class="badge rounded-pill bg-success commoon_active" action="verify_pb_user" active="0">Verified</span>
                                       </a>'
                                    : '<a href="javascript:void(0);" data-id="'.$row['id'].'">
                                          <span class="badge rounded-pill bg-danger commoon_active" action="verify_pb_user" active="1">Non-verified</span>
                                       </a>';

            $nestedData['verify_by'] = @$admin_verify_applicant->staff_fullname;    
            
                    $bgClass = '';
                    if ($row['pb_pending_approve'] == 1) {
                        $bgClass = 'bg-success'; // Green for Approved
                    } elseif ($row['pb_pending_approve'] === NULL || $row['pb_pending_approve'] == 0) {
                        $bgClass = 'bg-warning'; // Yellow for Pending
                    }

                        $nestedData['pb_pending_approve'] = '<select class="form-select form-select-sm commoon_active_pb_approve ' . $bgClass . '" style="width:100px;"
                                      data-id="'.$row['id'].'" 
                                      action="active_pb_approval">
                                    <option value="1" '.($row['pb_pending_approve'] == 1 ? 'selected' : '').'>Approved</option>
                                    <option value="0" '.(($row['pb_pending_approve'] === NULL || $row['pb_pending_approve'] == 0) ? 'selected' : '').'>Pending</option>
                                 </select>';

            
           $nestedData['remark'] = '<input type="text" class="form-control remark-input" data-id="'.$row['id'].'" value="'.$row['remark'].'" style="width: 300px;" />';

            $nestedData['agency_code'] = @$city->agency_code;
             $nestedData['agency_name'] = @$city->agency_name;
             
           $user_id = $row['id']; // Assuming user ID is in the 'id' field of $row
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); // Only the latest record
$query = $this->db->get();
// Fetch all results as an array of associative arrays
$appraisal_letters = $query->result_array();

// Prepare the appraisal letter links
$appraisalLetterLink = ''; // Initialize an empty string to hold all the links
if (!empty($appraisal_letters)) {
    // Loop through each appraisal letter record
    foreach ($appraisal_letters as $letter) {
        if (!empty($letter['appraisal_letter'])) {
            $appraisalLetterLink .= '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $letter['appraisal_letter'] . '" target="_blank">View</a> ';
        }
    }
} else {
    $appraisalLetterLink = '';
}

// Fetch the latest final sanction letter
$this->db->select('final_sanction_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('final_sanction_letter IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query2 = $this->db->get();
$latest_letter_fsl = $query2->row_array(); // Fetch as an associative array

// Prepare the final sanction letter link
$finalSanctionLetterLink = !empty($latest_letter_fsl['final_sanction_letter']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_fsl['final_sanction_letter']) . '" target="_blank">View</a>'
    : '';

// Fetch the latest proof of disbursement
$this->db->select('proof_disb');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('proof_disb IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query3 = $this->db->get();
$latest_letter_pd = $query3->row_array(); // Fetch as an associative array

// Prepare the proof of disbursement link
$proofDisbLink = !empty($latest_letter_pd['proof_disb']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']) . '" target="_blank">View</a>'
    : '';

// Add the links to the nested data array
$nestedData['appraisal_letter'] = $appraisalLetterLink;
$nestedData['final_sanction_letter'] = $finalSanctionLetterLink;
$nestedData['proof_disb'] = $proofDisbLink;


        
         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
    
        $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
            <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                <i class="bi bi-eye-fill"></i>
            </a>
            <a href="' . base_url('admin/pb_user_form/' . $row['id']) . '" target="_blank" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>
            <a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete"  action="delete_user"><i class="bi bi-trash-fill"></i></a>
        </div>' . $modal_html;

        $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}


public function manage_pb_sbi_branch_annx_ajax() {  
  
    $data['current_page'] = 'manage_pb_sbi_branch_annx';
    $data['title'] = 'PB Branch Annx';
    
    $data['branch'] = $this->db->select("id,branch_name,branch_code")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("staff_fullname,staff_id,hlc_code")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['connector_created'] = $this->db->select("staff_fullname,staff_id,hlc_code")->from('mst_staff')->where(['active' => 1, 'staff_type' => 0])->get()->result_array();
    $data['state'] = $this->db->select("id,state_name")->from('mst_state')->where('active', 1)->get()->result_array();
    

    $data['viewfile'] = "admin/manage_users/manage_pb_sbi_branch_annx_ajax";
    $this->load->view('admin/layout', $data);
} 

public function fetch_pb_sbi_branch_annx_ajax() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $created_by_part = $this->input->post('created_by_part');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $pb_payment_status = $this->input->post('pb_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $pb_generated = $this->input->post('pb_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $pb_sbi_branch_annx_blank = $this->input->post('pb_branch_annx_no');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    // Load model
    $this->load->model('PBsbibranchannx_model');

    // Fetch optimized data
    $result = $this->PBsbibranchannx_model->get_optimized_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated, $branch_generated, $partner_generated, $rbo, $created_by_part, $pb_sbi_branch_annx_blank);

    // Return JSON response
     header("Content-Type: application/json");
    echo json_encode($result);
}



public function manage_pb_sbi_branch_annx() {  
  
    $data['current_page'] = 'manage_pb_sbi_branch_annx';
    $data['title'] = 'PB Branch Annx';
    
    $data['branch'] = $this->db->select("id,branch_name,branch_code")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("staff_fullname,staff_id,hlc_code")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['connector_created'] = $this->db->select("staff_fullname,staff_id,hlc_code")->from('mst_staff')->where(['active' => 1, 'staff_type' => 0])->get()->result_array();
    $data['state'] = $this->db->select("id,state_name")->from('mst_state')->where('active', 1)->get()->result_array();
    

    $data['viewfile'] = "admin/manage_users/manage_pb_sbi_branch_annx";
    $this->load->view('admin/layout', $data);
}


public function fetch_pb_sbi_branch_annx() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $created_by_part = $this->input->post('created_by_part');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $pb_payment_status = $this->input->post('pb_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $pb_generated = $this->input->post('pb_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $pb_sbi_branch_annx_blank = $this->input->post('pb_branch_annx_no');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('PBsbibranchannx_model');

    $total_data = $this->PBsbibranchannx_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_branch_annx_blank);
    $total_filtered = $this->PBsbibranchannx_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_branch_annx_blank);

    $user_data = $this->PBsbibranchannx_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_branch_annx_blank);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("id,branch_name,rbo_id,state_id,city_id,branch_code")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("staff_fullname,staff_id,hlc_code")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("id,state_name")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("id,state_id,city_name")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
      
   

        $nestedData = array();
             
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $loanAmt = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) 
            ? $row['rinnraksha_amt'] 
            : $row['sanction_amt'];
        
        // Ensure $loanAmt is a valid numeric value
        $loanAmt = str_replace(',', '', $loanAmt); // Remove commas if present
        $loanAmt = is_numeric($loanAmt) ? (float) $loanAmt : 0; // Convert to float safely
        
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
      
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
  
        $readonly = !empty($row['pb_branch_annx_no']) ? 'readonly' : '';
        $readonly_date = !empty($row['pb_branch_annx_date']) ? 'readonly' : '';
        
        $nestedData['pb_branch_annx_no'] = '
            <input type="text" class="form-control pb-branch-annx-no" 
                   data-id="'.$row['id'].'" value="'.$row['pb_branch_annx_no'].'" 
                   style="width: 200px;" '.$readonly.' />';
        
        $nestedData['pb_branch_annx_date'] = '
            <input type="date" class="form-control pb-branch-annx-date" 
                   data-id="'.$row['id'].'" value="'.$row['pb_branch_annx_date'].'" 
           style="width: 150px;" '.$readonly_date.' />';

      
       
        // Add data to $nestedData
            $nestedData['pba_input_date'] = !empty($row['pba_input_date']) ? date('d-m-Y', strtotime($row['pba_input_date'])) : '';

            $pb_sbi_input_by = $this->db->select('staff_fullname')->where(['staff_id' => $row['pb_sbi_input_by']])->from('mst_staff')->get()->row();
            
          
            
            $nestedData['pb_sbi_input_by'] = @$pb_sbi_input_by->staff_fullname; 
           

        $editBtn = '';
if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 498 || $_SESSION['staff_id'] == 752 || $_SESSION['staff_id'] == 651) {
    $editBtn = '
        <a href="javascript:void(0);" class="text-info edit-btn" data-id="'.$row['id'].'" title="Edit">
            <i class="bi bi-pencil-fill fs-5"></i>
        </a>';
}

$nestedData['edit'] = $editBtn;

  
        $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}


//list of branch annx
public function manage_list_pb_sbi_branch_annx() {  
  
    $data['current_page'] = 'manage_list_pb_sbi_branch_annx';
    $data['title'] = 'PB Branch Annx';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['connector_created'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 0])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
    

    $data['viewfile'] = "admin/manage_users/manage_list_pb_sbi_branch_annx";
    $this->load->view('admin/layout', $data);
}


public function fetch_list_pb_sbi_branch_annx() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $created_by_part = $this->input->post('created_by_part');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $pb_payment_status = $this->input->post('pb_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $pb_generated = $this->input->post('pb_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $pb_sbi_invoice_blank = $this->input->post('sbi_pb_invoice_no');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('PB_list_sbibranchannx_model');

    $total_data = $this->PB_list_sbibranchannx_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_invoice_blank);
    $total_filtered = $this->PB_list_sbibranchannx_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_invoice_blank);

    $user_data = $this->PB_list_sbibranchannx_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_invoice_blank);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        //$conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        //$circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
       /* $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();*/
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
       // $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
       
        $applicantLog = $this->db->select("
        mst_user.user_name, 
        mst_user.rr_cbs_acct_no, 
        mst_user.bank_acct_no, 
        mst_user.los_id, 
        mst_user.id AS link_user_id, 
        mst_user.login_code, 
        mst_user.disb_date, 
        mst_loan_type.name AS loan_type_name, 
        CASE 
            WHEN mst_user.loan_type_id = 5 THEN mst_user.rinnraksha_amt 
            ELSE mst_user.sanction_amt 
        END AS loan_amt,
        CASE 
            WHEN mst_user.loan_type_id = 5 THEN mst_user.rr_cbs_acct_no 
            ELSE mst_user.bank_acct_no 
        END AS cbs_account_no,
        mst_state.state_name, 
        branch.branch_name,
        branch.branch_code,
        mst_rbo.rbo_name
    ", false) // 'false' prevents CI from adding backticks
    ->from('mst_user')
    ->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id')
    ->join('mst_state', 'mst_user.state_id = mst_state.id', 'left') 
    ->join('mst_city', 'mst_user.city_id = mst_city.id', 'left') 
    ->join('branch', 'mst_user.branch_id = branch.id', 'left') 
    ->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left') 
    ->where(['mst_user.pb_branch_annx_no' => $row['pb_branch_annx_no']])
    ->get()
    ->result_array();

            $formattedApplicants = '';
            $total_loan_amt = 0;
            foreach ($applicantLog as $sr => $val) {
                $total_loan_amt += $val['loan_amt'];
                // Create a link based on the login_code
                $link = ($val['login_code'] === 'PaisaBazaar') 
                    ? base_url('admin/pb_user_form/' . $val['link_user_id']) 
                    : base_url('admin/applicant_form/' . $val['link_user_id']);
            
                // Add applicant's details with State and City
                $formattedApplicants .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' 
                . $val['user_name'] . '</a> \ ' . $val['loan_type_name'] . ' \ '
                . 'State - ' . $val['state_name'] . ' \ City - ' . $val['city_name'] . ' \ '
                . 'Loan Amt - ' . formatIndianNumber($val['loan_amt']) . ' \ '
                . 'RLMS ID - ' . $val['los_id'] . ' \ '
                . 'CBS No - ' . $val['cbs_account_no'] . ' \ '
                . 'Branch - ' . $val['branch_name'] . ' (' . $val['branch_code'] . ')' . ' \ '
                . 'RBO - ' . $val['rbo_name'] . ' \ '
                . 'Disb Date - ' . (!empty($val['disb_date']) ? date('d-m-Y', strtotime($val['disb_date'])) : 'N/A') . '<br>';
            }

                      
                        $partnerLog = $this->db->select('mst_staff.staff_fullname,mst_staff.hlc_code, mst_user.user_name, mst_user.disb_date,mst_user.id as link_user_id,mst_user.login_code')
                            ->from('mst_staff')
                            ->join('mst_user', 'mst_staff.staff_id = mst_user.connector_id')
                            ->where(['mst_user.pb_branch_annx_no' => $row['pb_branch_annx_no']])
                            ->get()
                            ->result_array();
                              
                                // Generate formatted applicants list
                                    $formattedPartnerLog = '';
                                    $formattedPartnerHLCCODELog = '';
                                    foreach($partnerLog as $srp => $val) {
                                        $formattedPartnerLog .= ($srp + 1) . ')' . $val['staff_fullname'];
                                        $formattedPartnerLog .= '<br>';
                                        
                                        $formattedPartnerHLCCODELog .= ($srp + 1) . ')' . $val['hlc_code'];
                                        $formattedPartnerHLCCODELog .= '<br>';
                                    }

        $nestedData = array();
             
        $nestedData['sr_no'] = $key + 1;
        
        $nestedData['pb_branch_annx_no'] = $row['pb_branch_annx_no'];
        $nestedData['pb_branch_annx_date'] = date('d/m/y',strtotime($row['pb_branch_annx_date']));
       
        $nestedData['hlc_name'] = $formattedPartnerLog;
        $nestedData['hlc_code'] = $formattedPartnerHLCCODELog;
      
        $nestedData['applicant_name'] = $formattedApplicants;
        $nestedData['total_loan_amt'] = formatIndianNumber($total_loan_amt);
        
        $nestedData['rbo'] = @$rbo->rbo_name; 
      
    
          
            $pblba_handover_by = $this->db->select('staff_fullname')->where(['staff_id' => $row['pblba_handover_by']])->from('mst_staff')->get()->row();
            
             $readonly = !empty($row['sbi_pb_invoice_no']) ? 'readonly' : '';
             $readonly_pblba_handoverto = !empty($row['sbi_pb_invoice_no']) ? 'readonly' : '';
             $readonly_pb_sbi_invoice_date = !empty($row['pb_sbi_invoice_date']) ? 'readonly' : '';
            
             
            $nestedData['pblba_handoverto'] = '
                                           <input type="text" class="form-control pblba-handoverto" 
                                           data-id="'.$row['id'].'" value="'.$row['pblba_handoverto'].'" 
                                           style="width: 200px;" '.$readonly_pblba_handoverto.' />';
                                           
            /*$nestedData['sbi_pb_invoice_no'] = '
                                           <input type="text" class="form-control sbi-pb-invoice-no-input" 
                                           data-id="'.$row['id'].'" value="'.$row['sbi_pb_invoice_no'].'" 
                                           style="width: 200px;" '.$readonly.' />';*/
            $nestedData['sbi_pb_invoice_no'] = '
                                                <input type="text" class="form-control sbi-pb-invoice-no-input" 
                                                data-pb_branch_annx_no="'.$row['pb_branch_annx_no'].'" 
                                                data-id="'.$row['id'].'" value="'.$row['sbi_pb_invoice_no'].'" 
                                                style="width: 200px;" '.$readonly.' />';
                                           
            $nestedData['pb_sbi_invoice_date'] = '
                                                <input type="date" class="form-control pb-sbi-invoice-date" 
                                                       data-id="'.$row['id'].'" value="'.$row['pb_sbi_invoice_date'].'" 
                                                style="width: 150px;" '.$readonly_pb_sbi_invoice_date.' />';
                                               
            $nestedData['pblba_handover_by'] = @$pblba_handover_by->staff_fullname; 
            
            $nestedData['pblba_handover_date'] = !empty($row['pblba_handover_date']) 
            ? date('d-m-Y', strtotime($row['pblba_handover_date'])) 
            : '';

            
               
            $files = json_decode($row['pblba_ack_file'], true);
$fileLinks = '';
$staff_id = $this->session->userdata('staff_id'); // Get logged-in staff_id

if (!empty($files)) {
    $files = array_reverse($files); // Show latest file first

    foreach ($files as $index => $file) {
        $fileLinks .= '<div style="display:flex; align-items:center; gap:8px;">
            <a href="' . base_url('assets/uploads/ack_files/' . $file) . '" target="_blank">View ' . ($index + 1) . '</a>';

        // Show delete icon only for staff_id = 14
        if ($staff_id == 14) {
            $fileLinks .= '<a href="javascript:;" class="text-danger delete-file" 
                data-user-id="' . $row['id'] . '" 
                data-file-name="' . $file . '" 
                data-bs-toggle="tooltip" data-bs-placement="bottom" 
                title="Delete File">
                <i class="bi bi-trash-fill"></i>
            </a>';
        }

        $fileLinks .= '</div>';
    }
} else {
    $fileLinks = 'No File';
}

$nestedData['pblba_ack_file'] = '
    <input type="file" class="form-control pb-ack-file-input" 
           data-id="'.$row['id'].'" accept=".pdf,.jpg,.jpeg,.png" style="width: 200px;" />
    ' . $fileLinks;


      
            
            $editBtn = '';
            if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 498 || $_SESSION['staff_id'] == 752 || $_SESSION['staff_id'] == 651) {
                $editBtn = '
                    <a href="javascript:void(0);" class="text-info edit-btn" data-id="'.$row['id'].'" title="Edit">
                        <i class="bi bi-pencil-fill fs-5"></i>
                    </a>';
            }

        $nestedData['edit'] = $editBtn;

  
        $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}



//list of  annx rbo
public function manage_list_pb_sbi_rbo_invoices() {  
  
    $data['current_page'] = 'manage_list_pb_sbi_rbo_invoices';
    $data['title'] = 'PB Branch Annx';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['connector_created'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 0])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
    

    $data['viewfile'] = "admin/manage_users/manage_list_pb_sbi_rbo_invoices";
    $this->load->view('admin/layout', $data);
}


public function fetch_list_pb_sbi_rbo_invoices() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $created_by_part = $this->input->post('created_by_part');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $pb_payment_status = $this->input->post('pb_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $pb_generated = $this->input->post('pb_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $rbo = $this->input->post('rbo');
    $pb_sbi_invoice_blank = $this->input->post('pb_sbi_invoice_blank');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('PB_list_rbo_invoices_model');

    $total_data = $this->PB_list_rbo_invoices_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_invoice_blank);
    $total_filtered = $this->PB_list_rbo_invoices_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_invoice_blank);

    $user_data = $this->PB_list_rbo_invoices_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $pb_payment_status, $disb_month_year, $pb_generated,$branch_generated,$partner_generated,$rbo,$created_by_part,$pb_sbi_invoice_blank);

    $data = array();

    foreach ($user_data as $key => $row) {
       // $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        //$conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        //$circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
       /* $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();*/
       // $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
       // $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
       
        $applicantLog = $this->db->select("
        mst_user.user_name, 
        mst_user.pb_branch_annx_no, 
        mst_user.rr_cbs_acct_no, 
        mst_user.bank_acct_no, 
        mst_user.los_id, 
        mst_user.id AS link_user_id, 
        mst_user.login_code, 
        mst_user.disb_date, 
        mst_loan_type.name AS loan_type_name, 
        CASE 
            WHEN mst_user.loan_type_id = 5 THEN mst_user.rinnraksha_amt 
            ELSE mst_user.sanction_amt 
        END AS loan_amt,
        CASE 
            WHEN mst_user.loan_type_id = 5 THEN mst_user.rr_cbs_acct_no 
            ELSE mst_user.bank_acct_no 
        END AS cbs_account_no,
        mst_state.state_name, 
        branch.branch_name,
        branch.branch_code,
        mst_rbo.rbo_name
    ", false) // 'false' prevents CI from adding backticks
    ->from('mst_user')
    ->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id')
    ->join('mst_state', 'mst_user.state_id = mst_state.id', 'left') 
    ->join('mst_city', 'mst_user.city_id = mst_city.id', 'left') 
    ->join('branch', 'mst_user.branch_id = branch.id', 'left') 
    ->join('mst_rbo', 'branch.rbo_id = mst_rbo.id') 
    ->where(['mst_user.sbi_pb_invoice_no' => $row['sbi_pb_invoice_no']])
    ->get()
    ->result_array();

            $formattedApplicants = '';
            $totalLoanAmount = 0;
            foreach ($applicantLog as $sr => $val) {
                // Create a link based on the login_code
                $link = ($val['login_code'] === 'PaisaBazaar') 
                    ? base_url('admin/pb_user_form/' . $val['link_user_id']) 
                    : base_url('admin/applicant_form/' . $val['link_user_id']);
            
                // Add applicant's details with State and City
                $formattedApplicants .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' 
                . $val['user_name'] . '</a> \ ' . $val['loan_type_name'] . ' \ '
                . 'State - ' . $val['state_name'] . ' \ City - ' . $val['city_name'] . ' \ '
                . 'Loan Amt - ' . formatIndianNumber($val['loan_amt']) . ' \ '
                . 'RLMS ID - ' . $val['los_id'] . ' \ '
                . 'CBS No - ' . $val['cbs_account_no'] . ' \ '
                . 'Branch - ' . $val['branch_name'] . ' (' . $val['branch_code'] . ')' . ' \ '
                . 'RBO - ' . $val['rbo_name'] . ' \ '
                . 'Disb Date - ' . (!empty($val['disb_date']) ? date('d-m-Y', strtotime($val['disb_date'])) : 'N/A') . ' \ '
                . 'Branch Annx No - ' . $val['pb_branch_annx_no'] . '<br>';
                
                
                 $totalLoanAmount += $val['loan_amt'];
            }

                      
                        $partnerLog = $this->db->select('mst_staff.staff_fullname,mst_staff.hlc_code, mst_user.user_name, mst_user.disb_date,mst_user.id as link_user_id,mst_user.login_code')
                            ->from('mst_staff')
                            ->join('mst_user', 'mst_staff.staff_id = mst_user.connector_id')
                            ->where(['mst_user.sbi_pb_invoice_no' => $row['sbi_pb_invoice_no']])
                            ->get()
                            ->result_array();
                              
                                // Generate formatted applicants list
                                    $formattedPartnerLog = '';
                                    $formattedPartnerHLCCODELog = '';
                                    foreach($partnerLog as $srp => $val) {
                                        $formattedPartnerLog .= ($srp + 1) . ')' . $val['staff_fullname'];
                                        $formattedPartnerLog .= '<br>';
                                        
                                        $formattedPartnerHLCCODELog .= ($srp + 1) . ')' . $val['hlc_code'];
                                        $formattedPartnerHLCCODELog .= '<br>';
                                    }

        $nestedData = array();
             
        $nestedData['sr_no'] = $key + 1;
        
        $nestedData['sbi_pb_invoice_no'] = $row['sbi_pb_invoice_no'];
        $nestedData['pb_sbi_invoice_date'] = date('d/m/y',strtotime($row['pb_sbi_invoice_date']));
       
        $nestedData['hlc_name'] = $formattedPartnerLog;
        $nestedData['hlc_code'] = $formattedPartnerHLCCODELog;
      
        $nestedData['applicant_name'] = $formattedApplicants;
        $nestedData['total_sanction_amt'] = formatIndianNumber($totalLoanAmount);
      
    
          
            $pbrbo_invoices_handover_input_by = $this->db->select('staff_fullname')->where(['staff_id' => $row['pbrbo_invoices_handover_input_by']])->from('mst_staff')->get()->row();
            
           
             $readonly_pbrbo_invoices_handover_to = !empty($row['pbrbo_invoices_handover_to']) ? 'readonly' : '';
            $nestedData['pbrbo_invoices_handover_to'] = '
                                           <input type="text" class="form-control pbrbo_invoices_handover_to" 
                                           data-id="'.$row['id'].'" value="'.$row['pbrbo_invoices_handover_to'].'" 
                                           style="width: 200px;" '.$readonly_pbrbo_invoices_handover_to.' />';
                                           
           
             $bgClass = '';
                if ($row['sbi_pb_payment_status'] == 'paid') {
                    $bgClass = 'bg-success'; // Green for Paid
                } elseif ($row['sbi_pb_payment_status'] === NULL || $row['sbi_pb_payment_status'] == 'unpaid') {
                    $bgClass = 'bg-danger'; // Red for unpaid
                }
                
            $nestedData['sbi_pb_payment_status'] = '<select class="form-select form-select-sm commoon_paid_unpaid_sbi_pb_invoice ' . $bgClass . '" style="width: 100px;"
                                                      data-id="' . $row['id'] . '" 
                                                      action="' . base_url('admin/paid_unpaid_sbi_pb_invoice') . '">
                                                       <option value="paid" ' . ($row['sbi_pb_payment_status'] == 'paid' ? 'selected' : '') . '>Paid</option>
                                                       <option value="unpaid" ' . (($row['sbi_pb_payment_status'] === NULL || $row['sbi_pb_payment_status'] == 'unpaid') ? 'selected' : '') . '>Unpaid</option>
                                                     </select>';
                                                     
                                               
            $nestedData['pbrbo_invoices_handover_input_by'] = @$pbrbo_invoices_handover_input_by->staff_fullname; 
            
            $nestedData['pbrbo_invoices_handover_input_date'] = !empty($row['pbrbo_invoices_handover_input_date']) 
            ? date('d-m-Y', strtotime($row['pbrbo_invoices_handover_input_date'])) 
            : '';

                                               
            $files = json_decode($row['pbrbo_invoices_ack_file'], true);
            $fileLinks = '';
            $staff_id = $this->session->userdata('staff_id'); // Get logged-in staff_id

if (!empty($files)) {
    $files = array_reverse($files); // Show latest file first

    foreach ($files as $index => $file) {
        $fileLinks .= '<div style="display:flex; align-items:center; gap:8px;">
            <a href="' . base_url('assets/uploads/ack_files/' . $file) . '" target="_blank">View ' . ($index + 1) . '</a>';

        // Show delete icon only for staff_id = 14
        if ($staff_id == 14) {
            $fileLinks .= '<a href="javascript:;" class="text-danger delete-file-pbrboack" 
                data-user-id="' . $row['id'] . '" 
                data-file-name="' . $file . '" 
                data-bs-toggle="tooltip" data-bs-placement="bottom" 
                title="Delete File">
                <i class="bi bi-trash-fill"></i>
            </a>';
        }

        $fileLinks .= '</div>';
    }
} else {
    $fileLinks = 'No File';
}

$nestedData['pbrbo_invoices_ack_file'] = '
    <input type="file" class="form-control pbrbo_invoices_ack_file" 
           data-id="'.$row['id'].'" accept=".pdf,.jpg,.jpeg,.png" style="width: 200px;" />
    ' . $fileLinks;


      
            
            $editBtn = '';
            if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 498 || $_SESSION['staff_id'] == 752 || $_SESSION['staff_id'] == 651) {
                $editBtn = '
                    <a href="javascript:void(0);" class="text-info edit-btn" data-id="'.$row['id'].'" title="Edit">
                        <i class="bi bi-pencil-fill fs-5"></i>
                    </a>';
            }

        $nestedData['edit'] = $editBtn;

  
        $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}


public function update_pbrbo_invoices_handover_to() {
    $user_id = $this->input->post('user_id');
    $pbrbo_invoices_handover_to = $this->input->post('pbrbo_invoices_handover_to');

    $this->db->where('id', $user_id);
    $this->db->update('mst_user', [
    'pbrbo_invoices_handover_to' => $pbrbo_invoices_handover_to, 
    'pbrbo_invoices_handover_input_by'     => $_SESSION['staff_id'],
    'pbrbo_invoices_handover_input_date'    => date('Y-m-d H:i:s')
]);
    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}


public function delete_pblba_ack_file() {
    $user_id = $this->input->post('user_id');
    $file_name = $this->input->post('file_name');
    $staff_id = $this->session->userdata('staff_id');

    if ($staff_id != 14) {
        echo json_encode(['success' => false, 'message' => 'Unauthorized access.']);
        return;
    }

    if (!$user_id || !$file_name) {
        echo json_encode(['success' => false, 'message' => 'Invalid request.']);
        return;
    }

    // Fetch existing files
    $query = $this->db->select('pblba_ack_file')->where('id', $user_id)->get('mst_user');
    $user = $query->row();

    if ($user && !empty($user->pblba_ack_file)) {
        $existingFiles = json_decode($user->pblba_ack_file, true);
        
        // Remove the requested file
        $newFiles = array_filter($existingFiles, function ($file) use ($file_name) {
            return $file !== $file_name;
        });

        // Update DB with the new file list
        $this->db->where('id', $user_id);
        $this->db->update('mst_user', ['pblba_ack_file' => json_encode(array_values($newFiles))]);

        // Delete file from server
        $filePath = FCPATH . 'assets/uploads/ack_files/' . $file_name;
        if (file_exists($filePath)) {
            unlink($filePath);
        }

        echo json_encode(['success' => true]);
        return;
    }

    echo json_encode(['success' => false, 'message' => 'File not found.']);
}

public function delete_pbrbo_invoices_ack_file() {
    $user_id = $this->input->post('user_id');
    $file_name = $this->input->post('file_name');
    $staff_id = $this->session->userdata('staff_id');

    if ($staff_id != 14) {
        echo json_encode(['success' => false, 'message' => 'Unauthorized access.']);
        return;
    }

    if (!$user_id || !$file_name) {
        echo json_encode(['success' => false, 'message' => 'Invalid request.']);
        return;
    }

    // Fetch existing files
    $query = $this->db->select('pbrbo_invoices_ack_file')->where('id', $user_id)->get('mst_user');
    $user = $query->row();

    if ($user && !empty($user->pbrbo_invoices_ack_file)) {
        $existingFiles = json_decode($user->pbrbo_invoices_ack_file, true);
        
        // Remove the requested file
        $newFiles = array_filter($existingFiles, function ($file) use ($file_name) {
            return $file !== $file_name;
        });

        // Update DB with the new file list
        $this->db->where('id', $user_id);
        $this->db->update('mst_user', ['pbrbo_invoices_ack_file' => json_encode(array_values($newFiles))]);

        // Delete file from server
        $filePath = FCPATH . 'assets/uploads/ack_files/' . $file_name;
        if (file_exists($filePath)) {
            unlink($filePath);
        }

        echo json_encode(['success' => true]);
        return;
    }

    echo json_encode(['success' => false, 'message' => 'File not found.']);
}


public function upload_pblba_ack_file() {
    $user_id = $this->input->post('user_id');

    if (!$user_id) {
        echo json_encode(['success' => false, 'message' => 'Invalid user ID.']);
        return;
    }

    // Ensure a file is selected
    if (empty($_FILES['pblba_ack_file']['name'])) {
        echo json_encode(['success' => false, 'message' => 'No file selected for upload.']);
        return;
    }

    // Fetch existing file names
    $query = $this->db->select('pblba_ack_file')->where('id', $user_id)->get('mst_user');
    $user = $query->row();

    $existingFiles = [];
    if ($user && !empty($user->pblba_ack_file)) {
        $existingFiles = json_decode($user->pblba_ack_file, true) ?? [];
    }

    // Ensure upload directory exists
    $uploadPath = FCPATH . 'assets/uploads/ack_files/';
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0777, true);
    }

    // File upload configuration
    $config = [
        'upload_path'   => $uploadPath,
        'allowed_types' => 'pdf|jpg|jpeg|png',
        'max_size'      => 3048, // 3MB limit
        'file_name'     => 'ack_' . $user_id . '_' . time(),
    ];

    // Load upload library and initialize config
    $this->load->library('upload');
    $this->upload->initialize($config);

    if (!$this->upload->do_upload('pblba_ack_file')) {
        echo json_encode(['success' => false, 'message' => strip_tags($this->upload->display_errors())]);
        return;
    }

    $fileData = $this->upload->data();
    $fileName = $fileData['file_name'];

    // Append new file to existing list
    $existingFiles[] = $fileName;

    // Update database with new file list
    $this->db->where('id', $user_id);
    if ($this->db->update('mst_user', ['pblba_ack_file' => json_encode($existingFiles)])) {
        echo json_encode(['success' => true, 'file' => $fileName, 'all_files' => $existingFiles]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Database update failed.']);
    }
}


public function upload_pbrbo_invoices_ack_file() {
    $user_id = $this->input->post('user_id');

    if (!$user_id) {
        echo json_encode(['success' => false, 'message' => 'Invalid user ID.']);
        return;
    }

    // Ensure a file is selected
    if (empty($_FILES['pbrbo_invoices_ack_file']['name'])) {
        echo json_encode(['success' => false, 'message' => 'No file selected for upload.']);
        return;
    }

    // Fetch existing file names
    $query = $this->db->select('pbrbo_invoices_ack_file')->where('id', $user_id)->get('mst_user');
    $user = $query->row();

    $existingFiles = [];
    if ($user && !empty($user->pbrbo_invoices_ack_file)) {
        $existingFiles = json_decode($user->pbrbo_invoices_ack_file, true) ?? [];
    }

    // Ensure upload directory exists
    $uploadPath = FCPATH . 'assets/uploads/ack_files/';
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0777, true);
    }

    // File upload configuration
    $config = [
        'upload_path'   => $uploadPath,
        'allowed_types' => 'pdf|jpg|jpeg|png',
        'max_size'      => 3048, // 3MB limit
        'file_name'     => 'rbopback_' . $user_id . '_' . time(),
    ];

    // Load upload library and initialize config
    $this->load->library('upload');
    $this->upload->initialize($config);

    if (!$this->upload->do_upload('pbrbo_invoices_ack_file')) {
        echo json_encode(['success' => false, 'message' => strip_tags($this->upload->display_errors())]);
        return;
    }

    $fileData = $this->upload->data();
    $fileName = $fileData['file_name'];

    // Append new file to existing list
    $existingFiles[] = $fileName;

    // Update database with new file list
    $this->db->where('id', $user_id);
    if ($this->db->update('mst_user', ['pbrbo_invoices_ack_file' => json_encode($existingFiles)])) {
        echo json_encode(['success' => true, 'file' => $fileName, 'all_files' => $existingFiles]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Database update failed.']);
    }
}



 public function active_pb_approval($id, $status) {
    $data["pb_pending_approve"] = $status;
    $this->db->where('id', $id);

    if ($this->db->update("mst_user", $data)) {
        if ($status == 0) {
            $message = array('success' => '1', 'type' => 'success', 'message' => 'Marked as Pending...!');
        } elseif ($status == 1) {
            $message = array('success' => '1', 'type' => 'success', 'message' => 'Marked as Approved...!');
        } 
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Update failed. Please try again later.');
    }

    echo json_encode($message);
}


public function send_to_bulk_pb_pending_approval() {
    $ids = $this->input->post('ids'); // Get the array of selected IDs

    if (empty($ids)) {
        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'No records selected.'));
        return;
    }

    $data = array("pb_pending_approve" => 1); // Set status to Approved (1)
    $this->db->where_in('id', $ids);

    if ($this->db->update("mst_user", $data)) {
        echo json_encode(array('success' => '1', 'type' => 'success', 'message' => 'Selected records have been approved.'));
    } else {
        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'Update failed. Please try again later.'));
    }
}



public function update_remark() {
    $user_id = $this->input->post('user_id');
    $remark = $this->input->post('remark');

    $this->db->where('id', $user_id);
    $this->db->update('mst_user', ['remark' => $remark]); 

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}

public function update_remark_payment_act() {
    $user_id = $this->input->post('user_id');
    $remark = $this->input->post('remark');

    $this->db->where('id', $user_id);
    $this->db->update('mst_user', ['payment_act_remark' => $remark]); 

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}

/*public function update_sbi_pb_invoice_no() {
    $user_id = $this->input->post('user_id');
    $sbi_pb_invoice_no = $this->input->post('sbi_pb_invoice_no');

    $this->db->where('id', $user_id);

    // Check if the input is empty or null, and set it to NULL explicitly
    if ($sbi_pb_invoice_no === '' || $sbi_pb_invoice_no === null) {
        $this->db->set('sbi_pb_invoice_no', 'NULL', false); // Use SQL NULL
    } else {
        $this->db->set('sbi_pb_invoice_no', $sbi_pb_invoice_no);
    }

    $this->db->set('pb_sbi_input_by', $_SESSION['staff_id']);
    $this->db->set('pba_input_date', date('Y-m-d H:i:s')); // Inserts current datetime

    $this->db->update('mst_user');

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}
*/


public function update_sbi_pb_invoice_no_batch() {
    $pb_branch_annx_no = $this->input->post('pb_branch_annx_no');
    $sbi_pb_invoice_no = $this->input->post('sbi_pb_invoice_no');

    if (!$pb_branch_annx_no) {
        echo json_encode(['success' => false, 'message' => 'Batch number is missing']);
        return;
    }

    $this->db->where('pb_branch_annx_no', $pb_branch_annx_no); // Update all applicants in this batch

    // Check if input is empty and set to NULL explicitly
    if ($sbi_pb_invoice_no === '' || $sbi_pb_invoice_no === null) {
        $this->db->set('sbi_pb_invoice_no', null); // Use NULL instead of empty string
    } else {
        $this->db->set('sbi_pb_invoice_no', $sbi_pb_invoice_no);
    }

    $this->db->set('pb_sbi_input_by', $_SESSION['staff_id']);
    $this->db->set('pba_input_date', date('Y-m-d H:i:s')); // Current timestamp

    $this->db->update('mst_user');

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'No records updated']);
    }
}


public function update_sbi_pb_branch_annx_date() {
    $user_id = $this->input->post('user_id');
    $pb_branch_annx_date = $this->input->post('pb_branch_annx_date');

    $this->db->where('id', $user_id);

    // Check if the input is empty or null, and set it to NULL explicitly
    if ($pb_branch_annx_date === '' || $pb_branch_annx_date === null) {
        $this->db->set('pb_branch_annx_date', 'NULL', false); // Use SQL NULL
    } else {
        $this->db->set('pb_branch_annx_date', $pb_branch_annx_date);
    }

    $this->db->set('pb_sbi_input_by', $_SESSION['staff_id']);
    $this->db->set('pba_input_date', date('Y-m-d H:i:s'));

    $this->db->update('mst_user');

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}




public function update_pb_branch_annx_no() {
    $user_id = $this->input->post('user_id');
    $pb_branch_annx_no = $this->input->post('pb_branch_annx_no');

    $this->db->where('id', $user_id);

    // Use IF condition to explicitly set NULL in SQL
    if ($pb_branch_annx_no === '' || $pb_branch_annx_no === null) {
        $this->db->set('pb_branch_annx_no', 'NULL', false); // Use SQL NULL
    } else {
        $this->db->set('pb_branch_annx_no', $pb_branch_annx_no);
    }

    $this->db->set('pb_sbi_input_by', $_SESSION['staff_id']);
    $this->db->set('pba_input_date', date('Y-m-d H:i:s'));

    $this->db->update('mst_user');

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}





public function update_pblba_handoverto() {
    $user_id = $this->input->post('user_id');
    $pblba_handoverto = $this->input->post('pblba_handoverto');

    $this->db->where('id', $user_id);
    $this->db->update('mst_user', [
    'pblba_handoverto' => $pblba_handoverto, 
    'pblba_handover_by'     => $_SESSION['staff_id'],
    'pblba_handover_date'    => date('Y-m-d H:i:s')
]);
    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}


public function update_pb_sbi_invoice_date() {
    $user_id = $this->input->post('user_id');
    $pb_sbi_invoice_date = $this->input->post('pb_sbi_invoice_date');

    $this->db->where('id', $user_id);

    // Check if the input is empty or null, and set it to NULL explicitly
    if ($pb_sbi_invoice_date === '' || $pb_sbi_invoice_date === null) {
        $this->db->set('pb_sbi_invoice_date', 'NULL', false); // Use SQL NULL
    } else {
        $this->db->set('pb_sbi_invoice_date', $pb_sbi_invoice_date);
    }

    $this->db->set('pblba_handover_by', $_SESSION['staff_id']);
    $this->db->set('pblba_handover_date', date('Y-m-d H:i:s'));

    $this->db->update('mst_user');

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}



public function update_pb_branch_conf_no() {
    $user_id = $this->input->post('user_id');
    $pb_branch_conf_no = $this->input->post('pb_branch_conf_no');

    $this->db->where('id', $user_id);
    $this->db->update('mst_user', ['pb_branch_conf_no' => $pb_branch_conf_no]); 

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false]);
    }
}

public function paid_unpaid_sbi_pb_invoice() {
    // Decode the JSON payload from the AJAX request
    $postData = json_decode(file_get_contents('php://input'), true);

    // Extract the ID and status from the payload
    $id = isset($postData['id']) ? $postData['id'] : null;
    $status = isset($postData['status']) ? $postData['status'] : null;

    // Validate inputs
    if (empty($id) || !in_array($status, ['paid', 'unpaid'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid input data']);
        return;
    }

    // Update the database with the new status
    $updateData = ['sbi_pb_payment_status' => $status];
    $this->db->where('id', $id);
    $update = $this->db->update('mst_user', $updateData);

    // Check if the update was successful
    if ($update) {
        echo json_encode(['success' => true, 'message' => 'Payment status updated successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update payment status']);
    }
}



public function submit_pb_user() {
    if ($_POST) {
        $data = $_POST;

        if ($data['status'] === 'Disb Case') {
            $data['disb_status'] = 'yes';
        } else {
            $data['disb_status'] = null;
        }

        if (empty($data['disb_date'])) {
            $data['disb_date'] = null; // Set to null if date is not provided
        }

       


        // Check and handle branch information
        if (!empty($_POST['other_branch'])) {
            // Check if the branch already exists in the branch master table
            $existing_branch = $this->db->get_where('branch', array('branch_code' => $_POST['other_branch_code'] ?? ''))->row();
            if ($existing_branch) {
                // Use the existing branch ID
                $branch_id = $existing_branch->id;
            } else {
                // Insert the new branch details into the branch master table
                $branch_data = array(
                    'branch_name' => $_POST['other_branch'],
                    'branch_code' => $_POST['other_branch_code'] ?? '',
                    'state_id' => $_POST['other_branch_state_id'],
                    'city_id' => $_POST['other_branch_city_id'],
                    'circle_id' => $_POST['other_branch_circle_id'],
                );
                $this->db->insert('branch', $branch_data);
                // Get the inserted branch ID
                $branch_id = $this->db->insert_id();
            }
            // Assign the branch ID to the user data
            $data['branch_id'] = $branch_id;
        } else {
            $data['branch_id'] = $_POST['branch_id'];
        }

        $e_id = 0;

        // Check for duplicate CBS account numbers
        if (empty($_POST['id'])) {
            $this->db->where('bank_acct_no', $_POST['bank_acct_no']);
            $this->db->where('loan_type_id !=', 5);
            $this->db->where('bank_acct_no IS NOT NULL');
            $this->db->where('bank_acct_no !=', '');
            $cbs_exists = $this->db->get('mst_user')->row();
            if ($cbs_exists) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. CBS Account No are unique.');
                echo json_encode($message);
                return;
            }
        } else {
            // Check for duplicate CBS account number during update, excluding the current user's record
            $this->db->where('bank_acct_no', $_POST['bank_acct_no']);
            $this->db->where('loan_type_id !=', 5);
            $this->db->where('id !=', $_POST['id']);
            $this->db->where('bank_acct_no IS NOT NULL');
            $this->db->where('bank_acct_no !=', '');
            $cbs_exists = $this->db->get('mst_user')->row();
            if ($cbs_exists) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. CBS Account No are unique.');
                echo json_encode($message);
                return;
            }
        }

        // Check for duplicate RR CBS account numbers
        if (empty($_POST['id'])) {
            $this->db->where('rr_cbs_acct_no', @$_POST['rr_cbs_acct_no']);
            $this->db->where('loan_type_id', 5);
            $this->db->where('rr_cbs_acct_no IS NOT NULL');
            $this->db->where('rr_cbs_acct_no !=', '');
            $cbs_exists_rr = $this->db->get('mst_user')->row();
            if ($cbs_exists_rr) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. RR CBS Account No are unique.');
                echo json_encode($message);
                return;
            }
        } else {
            $this->db->where('rr_cbs_acct_no', @$_POST['rr_cbs_acct_no']);
            $this->db->where('id !=', $_POST['id']);
            $this->db->where('loan_type_id', 5);
            $this->db->where('rr_cbs_acct_no IS NOT NULL');
            $this->db->where('rr_cbs_acct_no !=', '');
            $cbs_exists_rr = $this->db->get('mst_user')->row();
            if ($cbs_exists_rr) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. RR CBS Account No are unique.');
                echo json_encode($message);
                return;
            }
        }

        // Update or Insert user information
        if (!empty($_POST['id'])) {
            $e_id = $data['id'];
            $data['branch_id'] = $_POST['branch_id'];
            $current_rr_status = $this->db->get_where('mst_user', array('id' => $e_id))->row()->rinnraksha_status;

            if ($current_rr_status == 'No' && $_POST['rinnraksha_status'] == 'Yes') {
                // Create data for the additional entry
                $additional_entry_data = array(
                    'loan_type_id' => 5,
                    'connector_id' => $_POST['connector_id'],
                    'branch_id' => $data['branch_id'],
                    'state_id' => $_POST['state_id'],
                    'city_id' => $_POST['city_id'],
                    'user_name' => $_POST['user_name'],
                    'user_phone' => $_POST['user_phone'],
                    'user_email' => $_POST['user_email'],
                    'user_address' => $_POST['user_address'],
                    'disb_date' => $data['disb_date'],
                    'disb_status' => $data['disb_status'],
                    'los_id' => $_POST['los_id'],
                    'bank_acct_no' => null,
                    'rinnraksha_status' => @$_POST['rinnraksha_status'],
                    'sanction_amt' => $_POST['rinnraksha_amt'],
                    'rinnraksha_amt' => $_POST['rinnraksha_amt'],
                    'rr_cbs_acct_no' => $_POST['rr_cbs_acct_no'],
                    'status' => $_POST['status'],
                    'login_code' => $_POST['login_code'],
                    'created_by' => $_SESSION['staff_id']
                );

                // Insert the additional entry
                $this->db->insert('mst_user', $additional_entry_data);
                $rr_id = $this->db->insert_id();

                $data['applicant_rr_id'] = $rr_id;
            }

            if ($current_rr_status == 'Yes' && @$_POST['rinnraksha_status'] == 'Yes') {
                $data['loan_type_id'] = 5;
                $data['sanction_amt'] = $_POST['rinnraksha_amt'];
                $data['rinnraksha_status'] = 'Yes';
                $data['rinnraksha_amt'] = $_POST['rinnraksha_amt'];
            }

            if ($current_rr_status == 'Yes' && @$_POST['rinnraksha_status'] == 'No') {
                $invoice_generated = $this->db->get_where('mst_user', array('id' => $e_id, 'applicant_invoice_status' => 'Generated'))->row();
                if (!$invoice_generated) {
                    // Delete entry if rinnraksha_status is 'no' and invoice has not been generated
                    $del_data = array(
                        'rinnraksha_status' => 'No',
                        'rinnraksha_amt' => '0',
                        'applicant_rr_id' => NULL
                    );
                    $this->db->where('applicant_rr_id', $data['id']);
                    $this->db->update('mst_user', $del_data);
                    $this->db->where('id', $e_id);
                    $this->db->delete('mst_user');

                    // Set the message to notify the user
                    $message = array('success' => '1', 'type' => 'success', 'message' => 'Entry deleted as invoice was not generated.');
                    echo json_encode($message);
                    return;
                } else {
                    // Set the message to notify the user that the invoice has been generated
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Cannot delete entry as invoice has already been generated.');
                    echo json_encode($message);
                    return;
                }
            }
            
              // Track Changes and Add Activities
        $activity_logs = []; // Array to hold activity logs
        if (!empty($_POST['id'])) {
            // Existing user, fetch current data
            $existing_data = $this->db->get_where('mst_user', ['id' => $_POST['id']])->row_array();

            // Compare existing data with new data and log changes
            foreach ($data as $key => $new_value) {
                if (isset($existing_data[$key]) && $existing_data[$key] != $new_value) {
                    $activity_logs[] = [
                        'user_id' => $_POST['id'],
                        'field_name' => $key,
                        'old_value' => $existing_data[$key],
                        'new_value' => $new_value,
                        'updated_by' => $_SESSION['staff_id'],
                        'updated_at' => date('Y-m-d H:i:s'),
                        'ip_address' => $_SERVER['REMOTE_ADDR'],
                        'device_name' =>$_SERVER['HTTP_USER_AGENT']
                    ];
                }
            }
        } else {
            // New user, log all fields as new entries
            foreach ($data as $key => $new_value) {
                $activity_logs[] = [
                    'user_id' => null, // Will be updated after insert
                    'field_name' => $key,
                    'old_value' => null,
                    'new_value' => $new_value,
                    'updated_by' => $_SESSION['staff_id'],
                    'updated_at' => date('Y-m-d H:i:s'),
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                    'device_name' =>$_SERVER['HTTP_USER_AGENT']
                ];
            }
        }

            $this->db->where('id', $data['id']);
            $res = $this->db->update('mst_user', $data);
            $msg = 'Updated Successfully..!';
        } else {
            
            $data['created_by'] = $_SESSION['staff_id'];
            
            $res = $this->db->insert('mst_user', $data);
            $msg = 'Added Successfully..!';
            $e_id = $this->db->insert_id();
            
             foreach ($activity_logs as &$log) {
                $log['user_id'] = $e_id;
            }

            // If rinnraksha_status is 'Yes', add an additional entry
            if ($_POST['rinnraksha_status'] == 'Yes') {
                // Create data for the additional entry
                $additional_entry_data = array(
                    'loan_type_id' => 5,
                    'connector_id' => $_POST['connector_id'],
                    'branch_id' => $data['branch_id'],
                    'user_name' => $_POST['user_name'],
                    'user_phone' => $_POST['user_phone'],
                    'user_email' => $_POST['user_email'],
                    'state_id' => $_POST['state_id'],
                    'city_id' => $_POST['city_id'],
                    'user_address' => $_POST['user_address'],
                    'disb_date' => $data['disb_date'],
                    'disb_status' => $data['disb_status'],
                    'los_id' => $_POST['los_id'],
                    'bank_acct_no' => null,
                    'rinnraksha_status' => $_POST['rinnraksha_status'],
                    'sanction_amt' => $_POST['rinnraksha_amt'],
                    'rinnraksha_amt' => $_POST['rinnraksha_amt'],
                    'rr_cbs_acct_no' => $_POST['rr_cbs_acct_no'],
                    'status' => $_POST['status'],
                    'login_code' => $_POST['login_code'],
                    'created_by' => $_SESSION['staff_id']
                );

                // Insert the additional entry
                $this->db->insert('mst_user', $additional_entry_data);
                $rr_id = $this->db->insert_id();
                $this->db->where('id', $e_id);
                $rr_data['applicant_rr_id'] = $rr_id;
                $this->db->update('mst_user', $rr_data);
            }
        }
        
        
        // File upload configuration
            $config['upload_path'] = realpath('./assets/uploads/documents/');
            $config['allowed_types'] = '*'; // Add or modify file types as needed
            $config['max_size'] = 3072; // Maximum file size in kilobytes
            
            if (isset($_FILES['apprisal_letter_file']) && !empty($_FILES['apprisal_letter_file']['name'][0])) {
                $files = $_FILES;
                $file_count = count($_FILES['apprisal_letter_file']['name']);
                $user_id = !empty($_POST['id']) ? $_POST['id'] : $e_id;  // Use provided ID if it's an update; otherwise, use the last inserted ID.
            
                for ($i = 0; $i < $file_count; $i++) {
                    $_FILES['apprisal_letter_file']['name'] = $files['apprisal_letter_file']['name'][$i];
                    $_FILES['apprisal_letter_file']['type'] = $files['apprisal_letter_file']['type'][$i];
                    $_FILES['apprisal_letter_file']['tmp_name'] = $files['apprisal_letter_file']['tmp_name'][$i];
                    $_FILES['apprisal_letter_file']['error'] = $files['apprisal_letter_file']['error'][$i];
                    $_FILES['apprisal_letter_file']['size'] = $files['apprisal_letter_file']['size'][$i];
            
                    if ($_FILES['apprisal_letter_file']['size'] > $config['max_size'] * 1024) {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'Appraisal Letter file must be less than 3 MB.'));
                        return;
                    }
            
                    $config['file_name'] = 'apprisal_letter' . date('dmYhis') . '_' . str_replace(' ', '_', $_POST['user_name']);
                    $this->upload->initialize($config);
            
                    if ($this->upload->do_upload('apprisal_letter_file')) {
                        // Save appraisal letter information to appraisal_letters table
                        $appraisal_letter_data = array(
                            'user_id' => $user_id,
                            'appraisal_letter' => $this->upload->data('file_name'),
                            'add_date' => date('Y-m-d H:i:s'),
                             'uploaded_by' => $_SESSION['staff_id']
                        );
                        $this->db->insert('appraisal_letters', $appraisal_letter_data);
                    } else {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => $this->upload->display_errors()));
                        return;
                    }
                }
            }
            
            if (isset($_FILES['final_sanction_letter']) && !empty($_FILES['final_sanction_letter']['name'][0])) {
                $files = $_FILES;
                $file_count = count($_FILES['final_sanction_letter']['name']);
                $user_id = !empty($_POST['id']) ? $_POST['id'] : $e_id;  // Use provided ID if it's an update; otherwise, use the last inserted ID.
            
                for ($i = 0; $i < $file_count; $i++) {
                    $_FILES['final_sanction_letter']['name'] = $files['final_sanction_letter']['name'][$i];
                    $_FILES['final_sanction_letter']['type'] = $files['final_sanction_letter']['type'][$i];
                    $_FILES['final_sanction_letter']['tmp_name'] = $files['final_sanction_letter']['tmp_name'][$i];
                    $_FILES['final_sanction_letter']['error'] = $files['final_sanction_letter']['error'][$i];
                    $_FILES['final_sanction_letter']['size'] = $files['final_sanction_letter']['size'][$i];
            
                    if ($_FILES['final_sanction_letter']['size'] > $config['max_size'] * 1024) {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'File must be less than 3 MB.'));
                        return;
                    }
            
                    $config['file_name'] = 'final_sanction_letter' . date('dmYhis') . '_' . str_replace(' ', '_', $_POST['user_name']);
                    $this->upload->initialize($config);
            
                    if ($this->upload->do_upload('final_sanction_letter')) {
                        // Save appraisal letter information to appraisal_letters table
                        $final_sanction_letter_data = array(
                            'user_id' => $user_id,
                            'final_sanction_letter' => $this->upload->data('file_name'),
                            'add_date' => date('Y-m-d H:i:s'),
                             'uploaded_by' => $_SESSION['staff_id']
                        );
                        $this->db->insert('appraisal_letters', $final_sanction_letter_data);
                    } else {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => $this->upload->display_errors()));
                        return;
                    }
                }
            }
            
            if (isset($_FILES['proof_disb']) && !empty($_FILES['proof_disb']['name'][0])) {
                $files = $_FILES;
                $file_count = count($_FILES['proof_disb']['name']);
                $user_id = !empty($_POST['id']) ? $_POST['id'] : $e_id;  // Use provided ID if it's an update; otherwise, use the last inserted ID.
            
                for ($i = 0; $i < $file_count; $i++) {
                    $_FILES['proof_disb']['name'] = $files['proof_disb']['name'][$i];
                    $_FILES['proof_disb']['type'] = $files['proof_disb']['type'][$i];
                    $_FILES['proof_disb']['tmp_name'] = $files['proof_disb']['tmp_name'][$i];
                    $_FILES['proof_disb']['error'] = $files['proof_disb']['error'][$i];
                    $_FILES['proof_disb']['size'] = $files['proof_disb']['size'][$i];
            
                    if ($_FILES['proof_disb']['size'] > $config['max_size'] * 1024) {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'File must be less than 3 MB.'));
                        return;
                    }
            
                    $config['file_name'] = 'proof_disb' . date('dmYhis') . '_' . str_replace(' ', '_', $_POST['user_name']);
                    $this->upload->initialize($config);
            
                    if ($this->upload->do_upload('proof_disb')) {
                        // Save appraisal letter information to appraisal_letters table
                        $proof_disb = array(
                            'user_id' => $user_id,
                            'proof_disb' => $this->upload->data('file_name'),
                            'add_date' => date('Y-m-d H:i:s'),
                             'uploaded_by' => $_SESSION['staff_id']
                        );
                        $this->db->insert('appraisal_letters', $proof_disb);
                    } else {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => $this->upload->display_errors()));
                        return;
                    }
                }
            }
            
        if (!empty($activity_logs)) {
            $this->db->insert_batch('applicant_user_activity', $activity_logs);
        }
        
        if ($res) {
            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
            $this->session->set_flashdata('response_message', $message);
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didn\'t add. Please try again later.');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please fill out the details before submitting.');
    }

    echo json_encode($message);
}

//Applicants

public function manage_users() {  
    $data['current_page'] = 'Applicants';
    $data['title'] = 'Applicants Report';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['connector_created'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 0])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
    
    $this->updatePartPayout();

    $data['viewfile'] = "admin/manage_users/manage_users";
    $this->load->view('admin/layout', $data);
}

public function fetch_applicants() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $created_by_part = $this->input->post('created_by_part');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $sbi_payment_status = $this->input->post('sbi_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $sbi_generated = $this->input->post('sbi_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('Applicant_model');

    $total_data = $this->Applicant_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part);
    $total_filtered = $this->Applicant_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part);

    $user_data = $this->Applicant_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }

        // SBI payment status
        if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }

        $nestedData = array();
        
        $nestedData['checkbox'] = '<input type="checkbox" class="row-checkbox" value="' . $row['id'] . '">';
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        //$nestedData['conn_commision'] = ($row['loan_type_id'] == 4) ? '0.20' : $conn->conn_commision;
        $nestedData['conn_commision'] = $row['part_payout'];
        
    // Ensure loanAmount is numeric
$loanAmount = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) 
    ? $row['rinnraksha_amt'] 
    : $row['sanction_amt'];

$loanAmount = isset($loanAmount) ? str_replace(',', '', $loanAmount) : '0';
$loanAmount = is_numeric($loanAmount) ? (float) $loanAmount : 0;

// Ensure conn_comm is numeric
$conn_comm = ($row['loan_type_id'] == 4) ? 0.20 : $row['part_payout'];

$conn_comm = isset($conn_comm) ? str_replace(',', '', $conn_comm) : '0';
$conn_comm = is_numeric($conn_comm) ? (float) $conn_comm : 0;

// Safely calculate the value
$nestedData['conn_payout_amt'] = formatIndianNumber($loanAmount * ($conn_comm / 100));

        
        $nestedData['sbi_payout'] = $row['sbi_commi'];
        $sbi_comm = ($loanAmount * $row['sbi_commi']) / 100;
        $nestedData['sbi_commi_amt'] = formatIndianNumber($sbi_comm);
        $ten10_sbi = ($sbi_comm * 10) / 100;
        $nestedData['sbi_ten_per'] = formatIndianNumber($ten10_sbi);
        
        $nestedData['sbi_ninety_per'] = formatIndianNumber($sbi_comm - $ten10_sbi);

        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        $nestedData['hlc_generated'] = ($row['applicant_invoice_status'] == 'Generated') ? '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/{$inv_hlc_data->inv_batchno}") . '" target="_BLANK">' . $inv_hlc_data->invoice_number . '</a>' : 'No';
        $nestedData['hlc_payment_status'] = "<span class=\"{$badge_class}\">{$statusP}</span>";
     
   
        $nestedData['branch_generated'] = ($row['branch_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_branch/generatePDF/{$inv_branch_data->inv_batchno}") . '" target="_BLANK">' . $inv_branch_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_generated'] = ($row['sbi_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_sbi/generatePDF/{$inv_sbi_data->inv_batchno}") . '" target="_BLANK">' . $inv_sbi_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_payment_status'] = "<span class=\"{$badge_class_sbi}\">{$sbistatusP}</span>";
        
       
        
                    // Get today's date as a DateTime object
$today = date('Y-m-d');
// Convert 'add_date' to Y-m-d format
$add_date = date('Y-m-d', strtotime($row['add_date']));

// Calculate the difference in days based on dates only
$days_difference = (strtotime($today) - strtotime($add_date)) / (60 * 60 * 24);

// Determine the color class based on the difference
if ($days_difference == 0) {
    $dot_color_class = 'green'; // Today
    $dot_text= 'Low';
} elseif ($days_difference <= 2) {
    $dot_color_class = 'orange'; // 2 days ago
    $dot_text= 'Medium';
} elseif ($days_difference == 3) {
    $dot_color_class = 'red'; // 3 days ago
    $dot_text= 'High';
} else {
    $dot_color_class = 'red';
    $dot_text= 'High';// Default (no color)
}
            
            // Add data to $nestedData
            $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $app_created_by = $this->db->select("*")->where(['staff_id' => $row['created_by']])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
            $nestedData['app_created_by'] = capitalize_first_three_words($app_created_by->staff_fullname);
            $nestedData['login_code'] = @$row['login_code'];
            
            // Assuming user ID is in the 'id' field of $row
             if($row['loan_type_id'] == 5){
     $doc = 'RR';
 }else{
     $doc = '';
 }
$user_id = $row['id'];

// Fetch only the latest appraisal letter for the user
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); // Only the latest record
$query = $this->db->get();

// Fetch the result
$appraisal_letter = $query->row_array(); // Fetch single row as an associative array

// Prepare the appraisal letter link
$appraisalLetterLink = ''; // Initialize as an empty string

if (!empty($appraisal_letter) && !empty($appraisal_letter['appraisal_letter'])) {
    $appraisalLetterLink = '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $appraisal_letter['appraisal_letter'] . '" target="_blank">View</a>';
} else {
    $appraisalLetterLink = $doc; // No appraisal letter found
}

// Add the link to the nested data array
//$nestedData['appraisal_letter'] = $appraisalLetterLink;
$nestedData['appraisal_letter'] = 
    ($statusP == 'unpaid' ? '<span class="dot ' . $dot_color_class . '"></span> ' . $dot_text . ' ' : '') . 
    $appraisalLetterLink;

     $archiveModalHtml = '
    <div class="modal fade" id="archiveUserModal' . $row['id'] . '" tabindex="-1" aria-labelledby="archiveUserModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="archiveUserModalLabel' . $row['id'] . '">Archive User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="' . base_url('admin/archive_user') . '" class="archive-form">
                    <div class="modal-body">
                        <p>Are you sure you want to archive this user?</p>
                        <div class="mb-3">
                            <label for="archiveRemark' . $row['id'] . '" class="form-label">Remark</label>
                            <textarea class="form-control" id="archiveRemark' . $row['id'] . '" name="archive_remark" rows="3" required></textarea>
                        </div>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>';

         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
    
                        $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
                        <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                            <i class="bi bi-eye-fill"></i>
                        </a>
                        <a href="' . base_url('admin/applicant_form/' . $row['id']) . '" target="_blank" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit">
                            <i class="bi bi-pencil-fill"></i>
                        </a>';
                         if ($_SESSION['staff_type'] == 0) {
                        $nestedData['edit'] .= '
                        <a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete" action="delete_user">
                            <i class="bi bi-trash-fill"></i>
                        </a>';
                         }
                    if ($_SESSION['staff_id'] == 14) {
                        $nestedData['edit'] .= '
                        <a href="javascript:;" class="text-info" data-bs-toggle="modal" data-bs-target="#archiveUserModal' . $row['id'] . '" data-bs-placement="bottom" title="Archive User" aria-label="Archive">
                            <i class="bi bi-archive-fill"></i>
                        </a>';
                    }

$nestedData['edit'] .= '</div>' . $modal_html . $archiveModalHtml;

                
                $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}





//RBO Paid Applicant MB


public function manage_rbo_paid_applicants() {  
    $data['current_page'] = 'rbo_paid_applicants';
    $data['title'] = 'RBO Paid Applicants';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_users/manage_rbo_paid_applicant";
    $this->load->view('admin/layout', $data);
}

public function fetch_applicants_rbo_paid() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $sbi_payment_status = $this->input->post('sbi_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $sbi_generated = $this->input->post('sbi_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('ApplicantRbo_paid_model');

    $total_data = $this->ApplicantRbo_paid_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);
    $total_filtered = $this->ApplicantRbo_paid_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);

    $user_data = $this->ApplicantRbo_paid_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }

        // SBI payment status
        if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }

        $nestedData = array();
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_commision'] = ($row['loan_type_id'] == 4) ? '0.20' : $row['part_payout'];
        
        $loanAmount = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        if($row['loan_type_id'] == 4){
            $conn_comm= 0.20;
        }else{
            $conn_comm = $row['part_payout'];
        }
        $nestedData['conn_payout_amt'] = formatIndianNumber($loanAmount * $conn_comm / 100);
        
        $nestedData['sbi_payout'] = $row['sbi_commi'];
        $sbi_comm = ($loanAmount * $row['sbi_commi']) / 100;
        $nestedData['sbi_commi_amt'] = formatIndianNumber($sbi_comm);
        $ten10_sbi = ($sbi_comm * 10) / 100;
        $nestedData['sbi_ten_per'] = formatIndianNumber($ten10_sbi);
        
        $nestedData['sbi_ninety_per'] = formatIndianNumber($sbi_comm - $ten10_sbi);

        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        $nestedData['hlc_generated'] = ($row['applicant_invoice_status'] == 'Generated') ? '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/{$inv_hlc_data->inv_batchno}") . '" target="_BLANK">' . $inv_hlc_data->invoice_number . '</a>' : 'No';
        $nestedData['hlc_payment_status'] = "<span class=\"{$badge_class}\">{$statusP}</span>";
     
   
        $nestedData['branch_generated'] = ($row['branch_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_branch/generatePDF/{$inv_branch_data->inv_batchno}") . '" target="_BLANK">' . $inv_branch_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_generated'] = ($row['sbi_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_sbi/generatePDF/{$inv_sbi_data->inv_batchno}") . '" target="_BLANK">' . $inv_sbi_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_payment_status'] = "<span class=\"{$badge_class_sbi}\">{$sbistatusP}</span>";
        
       
        
        $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
            $nestedData['login_code'] = @$row['login_code'];
            
            // Assuming user ID is in the 'id' field of $row
             if($row['loan_type_id'] == 5){
     $doc = 'RR';
 }else{
     $doc = '';
 }
$user_id = $row['id'];

// Fetch only the latest appraisal letter for the user
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); // Only the latest record
$query = $this->db->get();

// Fetch the result
$appraisal_letter = $query->row_array(); // Fetch single row as an associative array

// Prepare the appraisal letter link
$appraisalLetterLink = ''; // Initialize as an empty string

if (!empty($appraisal_letter) && !empty($appraisal_letter['appraisal_letter'])) {
    $appraisalLetterLink = '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $appraisal_letter['appraisal_letter'] . '" target="_blank">View</a>';
} else {
    $appraisalLetterLink = $doc; // No appraisal letter found
}

// Add the link to the nested data array
$nestedData['appraisal_letter'] = $appraisalLetterLink;

     $archiveModalHtml = '
    <div class="modal fade" id="archiveUserModal' . $row['id'] . '" tabindex="-1" aria-labelledby="archiveUserModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="archiveUserModalLabel' . $row['id'] . '">Archive User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="' . base_url('admin/archive_user') . '" class="archive-form">
                    <div class="modal-body">
                        <p>Are you sure you want to archive this user?</p>
                        <div class="mb-3">
                            <label for="archiveRemark' . $row['id'] . '" class="form-label">Remark</label>
                            <textarea class="form-control" id="archiveRemark' . $row['id'] . '" name="archive_remark" rows="3" required></textarea>
                        </div>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>';

         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
    
                        $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
                        <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                            <i class="bi bi-eye-fill"></i>
                        </a>
                        <a href="' . base_url('admin/applicant_form/' . $row['id']) . '" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit">
                            <i class="bi bi-pencil-fill"></i>
                        </a>
                        <a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete" action="delete_user">
                            <i class="bi bi-trash-fill"></i>
                        </a>';
                    
                    if ($_SESSION['staff_id'] == 14) {
                        $nestedData['edit'] .= '
                        <a href="javascript:;" class="text-info" data-bs-toggle="modal" data-bs-target="#archiveUserModal' . $row['id'] . '" data-bs-placement="bottom" title="Archive User" aria-label="Archive">
                            <i class="bi bi-archive-fill"></i>
                        </a>';
                    }

$nestedData['edit'] .= '</div>' . $modal_html . $archiveModalHtml;

                
                $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}


//RBO Unpaid applicant mb

public function manage_rbo_unpaid_applicants() {  
    $data['current_page'] = 'rbo_unpaid_applicants';
    $data['title'] = 'RBO Unpaid Applicants';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_users/manage_rbo_unpaid_applicant";
    $this->load->view('admin/layout', $data);
}

public function fetch_applicants_rbo_unpaid() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $sbi_payment_status = $this->input->post('sbi_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $sbi_generated = $this->input->post('sbi_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('ApplicantRbo_unpaid_model');

    $total_data = $this->ApplicantRbo_unpaid_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);
    $total_filtered = $this->ApplicantRbo_unpaid_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);

    $user_data = $this->ApplicantRbo_unpaid_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }

        // SBI payment status
        if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }

        $nestedData = array();
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_commision'] = ($row['loan_type_id'] == 4) ? '0.20' : $row['part_payout'];
        
        $loanAmount = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        if($row['loan_type_id'] == 4){
            $conn_comm= 0.20;
        }else{
            $conn_comm = $row['part_payout'];
        }
        $nestedData['conn_payout_amt'] = formatIndianNumber($loanAmount * $conn_comm / 100);
        
        $nestedData['sbi_payout'] = $row['sbi_commi'];
        $sbi_comm = ($loanAmount * $row['sbi_commi']) / 100;
        $nestedData['sbi_commi_amt'] = formatIndianNumber($sbi_comm);
        $ten10_sbi = ($sbi_comm * 10) / 100;
        $nestedData['sbi_ten_per'] = formatIndianNumber($ten10_sbi);
        
        $nestedData['sbi_ninety_per'] = formatIndianNumber($sbi_comm - $ten10_sbi);

        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        $nestedData['hlc_generated'] = ($row['applicant_invoice_status'] == 'Generated') ? '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/{$inv_hlc_data->inv_batchno}") . '" target="_BLANK">' . $inv_hlc_data->invoice_number . '</a>' : 'No';
        $nestedData['hlc_payment_status'] = "<span class=\"{$badge_class}\">{$statusP}</span>";
     
   
        $nestedData['branch_generated'] = ($row['branch_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_branch/generatePDF/{$inv_branch_data->inv_batchno}") . '" target="_BLANK">' . $inv_branch_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_generated'] = ($row['sbi_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_sbi/generatePDF/{$inv_sbi_data->inv_batchno}") . '" target="_BLANK">' . $inv_sbi_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_payment_status'] = "<span class=\"{$badge_class_sbi}\">{$sbistatusP}</span>";
        
       
        
        $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
            $nestedData['login_code'] = @$row['login_code'];
            
            // Assuming user ID is in the 'id' field of $row
             if($row['loan_type_id'] == 5){
     $doc = 'RR';
 }else{
     $doc = '';
 }
$user_id = $row['id'];

// Fetch only the latest appraisal letter for the user
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); // Only the latest record
$query = $this->db->get();

// Fetch the result
$appraisal_letter = $query->row_array(); // Fetch single row as an associative array

// Prepare the appraisal letter link
$appraisalLetterLink = ''; // Initialize as an empty string

if (!empty($appraisal_letter) && !empty($appraisal_letter['appraisal_letter'])) {
    $appraisalLetterLink = '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $appraisal_letter['appraisal_letter'] . '" target="_blank">View</a>';
} else {
    $appraisalLetterLink = $doc; // No appraisal letter found
}

// Add the link to the nested data array
$nestedData['appraisal_letter'] = $appraisalLetterLink;

     $archiveModalHtml = '
    <div class="modal fade" id="archiveUserModal' . $row['id'] . '" tabindex="-1" aria-labelledby="archiveUserModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="archiveUserModalLabel' . $row['id'] . '">Archive User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="' . base_url('admin/archive_user') . '" class="archive-form">
                    <div class="modal-body">
                        <p>Are you sure you want to archive this user?</p>
                        <div class="mb-3">
                            <label for="archiveRemark' . $row['id'] . '" class="form-label">Remark</label>
                            <textarea class="form-control" id="archiveRemark' . $row['id'] . '" name="archive_remark" rows="3" required></textarea>
                        </div>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>';

         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
    
                        $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
                        <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                            <i class="bi bi-eye-fill"></i>
                        </a>
                        <a href="' . base_url('admin/applicant_form/' . $row['id']) . '" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit">
                            <i class="bi bi-pencil-fill"></i>
                        </a>
                        <a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete" action="delete_user">
                            <i class="bi bi-trash-fill"></i>
                        </a>';
                    
                    if ($_SESSION['staff_id'] == 14) {
                        $nestedData['edit'] .= '
                        <a href="javascript:;" class="text-info" data-bs-toggle="modal" data-bs-target="#archiveUserModal' . $row['id'] . '" data-bs-placement="bottom" title="Archive User" aria-label="Archive">
                            <i class="bi bi-archive-fill"></i>
                        </a>';
                    }

$nestedData['edit'] .= '</div>' . $modal_html . $archiveModalHtml;

                
                $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}


public function manage_archive_user_mb() {  
    $data['current_page'] = 'archive_user_mb';
    $data['title'] = 'Applicants Archive';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_users/archive_user_mb";
    $this->load->view('admin/layout', $data);
}

public function fetch_applicants_archive_mb() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $sbi_payment_status = $this->input->post('sbi_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $sbi_generated = $this->input->post('sbi_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('Applicant_Archive_model');

    $total_data = $this->Applicant_Archive_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);
    $total_filtered = $this->Applicant_Archive_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);

    $user_data = $this->Applicant_Archive_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }

        // SBI payment status
        if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }

        $nestedData = array();
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
      
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
        $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        $nestedData['conn_commision'] = ($row['loan_type_id'] == 4) ? '0.20' : $row['part_payout'];
        
        $loanAmount = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
        if($row['loan_type_id'] == 4){
            $conn_comm= 0.20;
        }else{
            $conn_comm = $row['part_payout'];
        }
        $nestedData['conn_payout_amt'] = formatIndianNumber($loanAmount * $conn_comm / 100);
        
        $nestedData['sbi_payout'] = $row['sbi_commi'];
        $sbi_comm = ($loanAmount * $row['sbi_commi']) / 100;
        $nestedData['sbi_commi_amt'] = formatIndianNumber($sbi_comm);
        $ten10_sbi = ($sbi_comm * 10) / 100;
        $nestedData['sbi_ten_per'] = formatIndianNumber($ten10_sbi);
        
        $nestedData['sbi_ninety_per'] = formatIndianNumber($sbi_comm - $ten10_sbi);

        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        $nestedData['hlc_generated'] = ($row['applicant_invoice_status'] == 'Generated') ? '<a href="' . base_url("Invoice_pdf_hlc/generatePDF/{$inv_hlc_data->inv_batchno}") . '" target="_BLANK">' . $inv_hlc_data->invoice_number . '</a>' : 'No';
        $nestedData['hlc_payment_status'] = "<span class=\"{$badge_class}\">{$statusP}</span>";
     
   
        $nestedData['branch_generated'] = ($row['branch_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_branch/generatePDF/{$inv_branch_data->inv_batchno}") . '" target="_BLANK">' . $inv_branch_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_generated'] = ($row['sbi_genrated']=='Yes') ? '<a href="' . base_url("Invoice_pdf_sbi/generatePDF/{$inv_sbi_data->inv_batchno}") . '" target="_BLANK">' . $inv_sbi_data->invoice_number . '</a>' : 'No';
        $nestedData['sbi_payment_status'] = "<span class=\"{$badge_class_sbi}\">{$sbistatusP}</span>";
        
       
        
        $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
            $nestedData['login_code'] = @$row['login_code'];
            
            // Assuming user ID is in the 'id' field of $row
$user_id = $row['id'];

// Fetch only the latest appraisal letter for the user
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); // Only the latest record
$query = $this->db->get();

// Fetch the result
$appraisal_letter = $query->row_array(); // Fetch single row as an associative array

// Prepare the appraisal letter link
$appraisalLetterLink = ''; // Initialize as an empty string

if (!empty($appraisal_letter) && !empty($appraisal_letter['appraisal_letter'])) {
    $appraisalLetterLink = '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $appraisal_letter['appraisal_letter'] . '" target="_blank">View</a>';
} else {
    $appraisalLetterLink = ''; // No appraisal letter found
}

// Add the link to the nested data array
$nestedData['appraisal_letter'] = $appraisalLetterLink;

     $archiveModalHtml = '
    <div class="modal fade" id="archiveUserModal' . $row['id'] . '" tabindex="-1" aria-labelledby="archiveUserModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="archiveUserModalLabel' . $row['id'] . '">Archive User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="' . base_url('admin/un_archive_user') . '" class="unarchive-form">
                    <div class="modal-body">
                        <p>Are you sure you want to unarchive this user?</p>
                        <div class="mb-3">
                            <label for="archiveRemark' . $row['id'] . '" class="form-label">Remark</label>
                            <textarea class="form-control" id="archiveRemark' . $row['id'] . '" name="archive_remark" rows="3" required>' . $row['archive_remark'] . '</textarea>
                        </div>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>';

         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
    
                       $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
                        <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                            <i class="bi bi-eye-fill"></i>
                        </a>
                        <a href="' . base_url('admin/applicant_form/' . $row['id']) . '" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit">
                            <i class="bi bi-pencil-fill"></i>
                        </a>
                        <a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete" action="delete_user">
                            <i class="bi bi-trash-fill"></i>
                        </a>';
                    
                    if ($_SESSION['staff_id'] == 14) {
                        $nestedData['edit'] .= '
                        <a href="javascript:;" class="text-info" data-bs-toggle="modal" data-bs-target="#archiveUserModal' . $row['id'] . '" data-bs-placement="bottom" title="Archive User" aria-label="Archive">
                            <i class="bi bi-archive-fill"></i>
                        </a>';
                    }
                    
                    $nestedData['edit'] .= '</div>' . $modal_html . $archiveModalHtml;

                
                $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}

public function archive_user()
{
    $user_id = $this->input->post('user_id');
    $remark = $this->input->post('archive_remark');

    // Validate inputs
    if (!$user_id || !$remark) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);
        return;
    }

    // Update the database
    $this->db->where('id', $user_id);
    $this->db->update('mst_user', [
        'is_archive' => 'Yes',
        'archive_remark' => $remark
    ]);

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Applicant archived successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to archive applicant.']);
    }
}




public function send_to_finance()
{
    $user_ids = $this->input->post('ids'); 

    // Validate inputs
    if (empty($user_ids) || !is_array($user_ids)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);
        return;
    }

    // Update the database for multiple users
    $this->db->where_in('id', $user_ids);
    $this->db->update('mst_user', [
        'todays_payment' => 'Yes',
        'payment_approve_status' => NULL,
        'payment_verified_by' => $_SESSION['staff_id'],
        'payment_send_date' => date('Y-m-d H:i:s')
    ]);

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Submitted successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to send records.']);
    }
}



public function remove_todays_payment_user()
{
    $user_id = $this->input->post('user_id');

    // Validate input
    if (empty($user_id)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);
        return;
    }

    // Update the database
    $this->db->where('id', $user_id);
    $this->db->update('mst_user', [
        'todays_payment'       => 'No',
        'payment_approved_by'  => NULL,
        'payment_approve_status' => NULL,
        'payment_act_remark'   => NULL,
        'payment_send_date'    => NULL,
        'payment_approval_date' => NULL,
        'payment_verified_by'  => NULL
    ]);

    // Check affected rows
    if ($this->db->affected_rows() >= 0) {  // Allow 0 affected rows as success
        echo json_encode(['status' => 'success', 'message' => 'Submitted successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update.']);
    }
}


public function un_archive_user()
{
    $user_id = $this->input->post('user_id');
    $remark = $this->input->post('archive_remark');

    // Validate inputs
    if (!$user_id || !$remark) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);
        return;
    }

    // Update the database
    $this->db->where('id', $user_id);
    $this->db->update('mst_user', [
        'is_archive' => 'No',
        'archive_remark' => $remark
    ]);

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Applicant unarchived successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to unarchive applicant.']);
    }
}



public function applicant_form($id = ''){

    $data['current_page'] = 'Users';
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['loan_type'] = $this->db->select("*")->from('mst_loan_type')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
    $data['circle'] = $this->db->select("*")->from('mst_circle')->where('active', 1)->get()->result_array();
    $data['selectedLoginType'] = $this->input->post('selectedFormType');

    if ($id != '') {
        $data['user'] = $this->ccm->get_single_row('mst_user', array('id' => $id));
        $data['title'] = 'Applicant Details-'. $data['user']->login_code;
        
    } else {
        $data['title'] = 'Applicants';
    }



    $data['viewfile'] = 'admin/manage_users/users_form';
    $this->load->view('admin/layout', $data);

}




public function manage_split_payment() {  
    
    $data['current_page'] = 'Split Payment';
    $data['title'] = 'Split Payment';
    
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();

    //$start_date = $this->input->post('start_date');
    //$end_date = $this->input->post('end_date');
 
    $conn_id = $this->input->post('connector');
  
   
    $data['user'] = $this->ccm->get_split_payment_data($conn_id);
    $data['viewfile'] = "admin/manage_split_payment/manage_split_payment";
    $this->load->view('admin/layout', $data);

}




public function split_payment_form($id = ''){

    $data['current_page'] = 'Split Payment';
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
  
    if ($id != '') {
        $data['title'] = 'Details';
        $data['user'] = $this->ccm->get_single_row('split_payment', array('id' => $id));
    } else {
        $data['title'] = 'Split Payment';
    }



    $data['viewfile'] = 'admin/manage_split_payment/split_payment_form';

    $this->load->view('admin/layout', $data);

}


public function submit_split_payment() {
    if ($_POST) {
        $data = $_POST;
        $data = array_filter($data);
        $data = $this->security->xss_clean($data);
        $data['sub_hlc_id'] = json_encode($_POST['sub_hlc_id']);
        $data['created_by'] = $_SESSION['staff_id'];
        $e_id = 0;
        if ($_POST['id'] != '') {
            $e_id = $_POST['id'];
            $this->db->where('id', $_POST['id']);
            $res = $this->db->update('split_payment', $data);
            $msg = 'Updated Successfully..!';

        } else {
            if ($this->ccm->get_row_count('split_payment', array('connector_id' => $this->input->post('connector_id'))) != 0) {
                $data = array('type' => 'error', 'message' => 'already exists Please change it...!', 'success' => 0);
                echo json_encode($data);
                exit;

            }
            $res = $this->db->insert('split_payment', $data);
            $msg = 'Added Successfully..!';
            $e_id = $this->db->insert_id();

        }

       

        if ($res == 1) {
            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
            $this->session->set_flashdata('response_message', $message);

        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didnt Added, Please try after some time..!');
        }
    } else {

        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');

    }
    echo json_encode($message);

}


public function delete_split_payment($id) {
    $this->db->where('id', $id);
    $res = $this->db->delete('split_payment');

    if ($res) {
        $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully...!');
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Failed to delete. Please try again later..!');
    }
    echo json_encode($message);
}


public function menu_permission_form($id = ''){
    
            if (!has_menu_permission($_SESSION['staff_id'],'Menu Permission')) {
                show_error('You do not have permission to access this page.', 403);
            }

    $data['current_page'] = 'Menu Permission';
    $data['roles'] = $this->ccm->get_roles_with_permissions();
    $data['menus'] = $this->db->get('mst_menus')->result();
  
    if ($id != '') {
        $data['title'] = 'Permission';
        $data['user'] = $this->ccm->get_single_row('menu_permission', array('id' => $id));
    } else {
        $data['title'] = 'Permission';
    }

    $data['viewfile'] = 'admin/manage_menu_permission/menu_permission_form';

    $this->load->view('admin/layout', $data);

}


public function update_permission_menue() {
    $role_id = $this->input->post('role_id');
    $menu_id = $this->input->post('menu_id');
    $has_permission = $this->input->post('has_permission');

    if ($has_permission == 'true') {
        // Grant permission
        $this->db->insert('menu_permissions', [
            'role_id' => $role_id,
            'menu_id' => $menu_id
        ]);
    } else {
        // Revoke permission
        $this->db->delete('menu_permissions', [
            'role_id' => $role_id,
            'menu_id' => $menu_id
        ]);
    }

    echo json_encode(['message' => 'Permission updated successfully.']);
}



//applicant



/*public function submit_user() {
    if ($_POST) {
        $data = $_POST;
       
        if ($data['status'] === 'Disb Case') {
            $data['disb_status'] = 'yes';
        } else {
            $data['disb_status'] = null;
        }
        
        if (empty($data['disb_date'])) {
            $data['disb_date'] = null; // Set to null if date is not provided
        }
        
        // File upload configuration
        $config['upload_path'] = realpath('./assets/uploads/documents/');
        $config['allowed_types'] = 'jpg|jpeg|png|pdf'; // Add or modify file types as needed
        $config['max_size'] = 3072; // Maximum file size in kilobytes
        
        // Check and upload apprisal_letter_file
        if (isset($_FILES['apprisal_letter_file']) && $_FILES['apprisal_letter_file']['size'] > 0) {
            if ($_FILES['apprisal_letter_file']['size'] > $config['max_size'] * 1024) {
                echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'Apprisal Letter file must be less than 3 MB.'));
                return;
            }

            $config['file_name'] = 'apprisal_letter' . date('dmYhis') . '_' . rand(0, 999999);
            $this->upload->initialize($config);
            if ($this->upload->do_upload('apprisal_letter_file')) {
                $data['apprisal_letter'] = $this->upload->data('file_name');
            } else {
                echo json_encode(array('success' => '0', 'type' => 'error', 'message' => $this->upload->display_errors()));
                return;
            }
        }

        // Check and upload apprisal_letter_two
        if (isset($_FILES['apprisal_letter_two']) && $_FILES['apprisal_letter_two']['size'] > 0) {
            if ($_FILES['apprisal_letter_two']['size'] > $config['max_size'] * 1024) {
                echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'Apprisal Letter Page 2 file must be less than 3 MB.'));
                return;
            }

            $config['file_name'] = 'apprisal_letter_page2_' . date('dmYhis') . '_' . rand(0, 999999);
            $this->upload->initialize($config);
            if ($this->upload->do_upload('apprisal_letter_two')) {
                $data['apprisal_letter_two'] = $this->upload->data('file_name');
            } else {
                echo json_encode(array('success' => '0', 'type' => 'error', 'message' => $this->upload->display_errors()));
                return;
            }
        }
        
        if (!empty($_POST['other_branch'])) {
            // Check if the branch already exists in the branch master table
            $existing_branch = $this->db->get_where('branch', array('branch_code' => $_POST['other_branch_code'] ?? ''))->row();
            if ($existing_branch) {
                // Use the existing branch ID
                $branch_id = $existing_branch->id;
            } else {
                // Insert the new branch details into the branch master table
                $branch_data = array(
                    'branch_name' => $_POST['other_branch'],
                    'branch_code' => $_POST['other_branch_code'] ?? '',
                    'state_id' => $_POST['other_branch_state_id'],
                    'city_id' => $_POST['other_branch_city_id'],
                    'circle_id' => $_POST['other_branch_circle_id'],
                );
                $this->db->insert('branch', $branch_data);
                // Get the inserted branch ID
                $branch_id = $this->db->insert_id();
            }
            // Assign the branch ID to the user data
            $data['branch_id'] = $branch_id;
        } else {
            $data['branch_id'] = $_POST['branch_id'];
        }

        $e_id = 0;

         if (empty($_POST['id'])) {
                // Only check for duplicate CBS account number during insertion
                $this->db->where('bank_acct_no', $_POST['bank_acct_no']);
                $this->db->where('loan_type_id !=', 5);
                $this->db->where('bank_acct_no IS NOT NULL');
                $this->db->where('bank_acct_no !=', '');
                $cbs_exists = $this->db->get('mst_user')->row();
                if ($cbs_exists) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. CBS Account No are unique.');
                    echo json_encode($message);
                    return;
                }
            } else {
                // Check for duplicate CBS account number during update, excluding the current user's record
                $this->db->where('bank_acct_no', $_POST['bank_acct_no']);
                $this->db->where('loan_type_id !=', 5);
                $this->db->where('id !=', $_POST['id']);
                $this->db->where('bank_acct_no IS NOT NULL');
                $this->db->where('bank_acct_no !=', '');
                $cbs_exists = $this->db->get('mst_user')->row();
                if ($cbs_exists) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. CBS Account No are unique.');
                    echo json_encode($message);
                    return;
                }
            }

        
            if (empty($_POST['id'])) {
                 $this->db->where('rr_cbs_acct_no', @$_POST['rr_cbs_acct_no']);
                 $this->db->where('loan_type_id', 5);
                 $this->db->where('rr_cbs_acct_no IS NOT NULL');
                 $this->db->where('rr_cbs_acct_no !=', '');
                $cbs_exists_rr = $this->db->get('mst_user')->row();
                if ($cbs_exists_rr) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. RR CBS Account No are unique.');
                    echo json_encode($message);
                    return;
                }
            } else {
                $this->db->where('rr_cbs_acct_no', @$_POST['rr_cbs_acct_no']);
                $this->db->where('id !=', $_POST['id']);
                $this->db->where('loan_type_id', 5);
                 $this->db->where('rr_cbs_acct_no IS NOT NULL');
                 $this->db->where('rr_cbs_acct_no !=', '');
                $cbs_exists_rr = $this->db->get('mst_user')->row();
                if ($cbs_exists_rr) {
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. RR CBS Account No are unique.');
                    echo json_encode($message);
                    return;
                }
            }

        if (!empty($_POST['id'])) {
            $e_id = $data['id'];
            $data['branch_id'] = $_POST['branch_id'];
            $current_rr_status = $this->db->get_where('mst_user', array('id' => $e_id))->row()->rinnraksha_status;
            
            if ($current_rr_status == 'No' && $_POST['rinnraksha_status'] == 'Yes') {
                // Create data for the additional entry
                $additional_entry_data = array(
                    'loan_type_id' => 5,
                    'connector_id' => $_POST['connector_id'],
                    'branch_id' => $data['branch_id'],
                    'state_id' => $_POST['state_id'],
                    'city_id' => $_POST['city_id'],
                    'user_name' => $_POST['user_name'],
                    'user_phone' => $_POST['user_phone'],
                    'user_email' => $_POST['user_email'],
                    'user_address' => $_POST['user_address'],
                    'disb_date' => $data['disb_date'],
                    'disb_status' => $data['disb_status'],
                    'los_id' => $_POST['los_id'],
                    'bank_acct_no' => null,
                    'rinnraksha_status' => @$_POST['rinnraksha_status'],
                    'sanction_amt' => $_POST['rinnraksha_amt'],
                    'rinnraksha_amt' => $_POST['rinnraksha_amt'],
                    'rr_cbs_acct_no' => $_POST['rr_cbs_acct_no'],
                    'status' => $_POST['status']
                );
                
              
                // Insert the additional entry
                $this->db->insert('mst_user', $additional_entry_data);
                $rr_id = $this->db->insert_id();
                
                $data['applicant_rr_id'] = $rr_id;
            }

            if ($current_rr_status == 'Yes' && @$_POST['rinnraksha_status'] == 'Yes') {
                $data['loan_type_id'] = 5;
                $data['sanction_amt'] = $_POST['rinnraksha_amt'];
                $data['rinnraksha_status'] = 'Yes';
                $data['rinnraksha_amt'] = $_POST['rinnraksha_amt'];
            }

            if ($current_rr_status == 'Yes' && @$_POST['rinnraksha_status'] == 'No') {
                $invoice_generated = $this->db->get_where('mst_user', array('id' => $e_id, 'applicant_invoice_status' => 'Generated'))->row();
                if (!$invoice_generated) {
                    // Delete entry if rinnraksha_status is 'no' and invoice has not been generated
                    $del_data = array(
                        'rinnraksha_status' => 'No',
                        'rinnraksha_amt' => '0',
                        'applicant_rr_id' => NULL
                    );
                    $this->db->where('applicant_rr_id', $data['id']);
                    $this->db->update('mst_user', $del_data);
                    $this->db->where('id', $e_id);
                    $this->db->delete('mst_user');
            
                    // Set the message to notify the user
                    $message = array('success' => '1', 'type' => 'success', 'message' => 'Entry deleted as invoice was not generated.');
                    echo json_encode($message);
                    return;
                } else {
                    // Set the message to notify the user that the invoice has been generated
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Cannot delete entry as invoice has already been generated.');
                    echo json_encode($message);
                    return;
                }
            }
            
            $oldData = $this->db->get_where('mst_user', array('id' => $e_id))->row();

            // Check if a new file is being uploaded before deleting the old one
            if ($_FILES['apprisal_letter_file']['name']) {
                $this->deleteFile($oldData->apprisal_letter);
            }

            // Check if a new file is being uploaded before deleting the old one
            if ($_FILES['apprisal_letter_two']['name']) {
                $this->deleteFile($oldData->apprisal_letter_two);
            }

            $this->db->where('id', $data['id']);
            $res = $this->db->update('mst_user', $data);
            $msg = 'Updated Successfully..!';
        } else {
            $res = $this->db->insert('mst_user', $data);
            $msg = 'Added Successfully..!';
            $e_id = $this->db->insert_id();

            // If rinnraksha_status is 'Yes', add an additional entry
            if ($_POST['rinnraksha_status'] == 'Yes') {
                // Create data for the additional entry
                $additional_entry_data = array(
                    'loan_type_id' => 5,
                    'connector_id' => $_POST['connector_id'],
                    'branch_id' => $data['branch_id'],
                    'user_name' => $_POST['user_name'],
                    'user_phone' => $_POST['user_phone'],
                    'user_email' => $_POST['user_email'],
                    'state_id' => $_POST['state_id'],
                    'city_id' => $_POST['city_id'],
                    'user_address' => $_POST['user_address'],
                    'disb_date' => $data['disb_date'],
                    'disb_status' => $data['disb_status'],
                    'los_id' => $_POST['los_id'],
                    'bank_acct_no' => null,
                    'rinnraksha_status' => $_POST['rinnraksha_status'],
                    'sanction_amt' => $_POST['rinnraksha_amt'],
                    'rinnraksha_amt' => $_POST['rinnraksha_amt'],
                    'rr_cbs_acct_no' => $_POST['rr_cbs_acct_no'],
                    'status' => $_POST['status']
                );
                
               

                // Insert the additional entry
                $this->db->insert('mst_user', $additional_entry_data);
                $rr_id = $this->db->insert_id();
                $this->db->where('id', $e_id);
                $rr_data['applicant_rr_id'] = $rr_id;
                $this->db->update('mst_user', $rr_data);
            }
        }

        if ($res) {
            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
            $this->session->set_flashdata('response_message', $message);
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didn\'t add. Please try again later.');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please fill out the details before submitting.');
    }

    echo json_encode($message);
}
*/
                

public function submit_user() {
    if ($_POST) {
        $data = $_POST;

        if ($data['status'] === 'Disb Case') {
            $data['disb_status'] = 'yes';
        } else {
            $data['disb_status'] = null;
        }

        if (empty($data['disb_date'])) {
            $data['disb_date'] = null; // Set to null if date is not provided
        }

       


        // Check and handle branch information
        if (!empty($_POST['other_branch'])) {
            // Check if the branch already exists in the branch master table
            $existing_branch = $this->db->get_where('branch', array('branch_code' => $_POST['other_branch_code'] ?? ''))->row();
            if ($existing_branch) {
                // Use the existing branch ID
                $branch_id = $existing_branch->id;
            } else {
                // Insert the new branch details into the branch master table
                $branch_data = array(
                    'branch_name' => $_POST['other_branch'],
                    'branch_code' => $_POST['other_branch_code'] ?? '',
                    'state_id' => $_POST['other_branch_state_id'],
                    'city_id' => $_POST['other_branch_city_id'],
                    'circle_id' => $_POST['other_branch_circle_id'],
                );
                $this->db->insert('branch', $branch_data);
                // Get the inserted branch ID
                $branch_id = $this->db->insert_id();
            }
            // Assign the branch ID to the user data
            $data['branch_id'] = $branch_id;
        } else {
            $data['branch_id'] = $_POST['branch_id'];
        }

        $e_id = 0;

        // Check for duplicate CBS account numbers
        if (empty($_POST['id'])) {
            $this->db->where('bank_acct_no', $_POST['bank_acct_no']);
            $this->db->where('loan_type_id !=', 5);
            $this->db->where('bank_acct_no IS NOT NULL');
            $this->db->where('bank_acct_no !=', '');
            $cbs_exists = $this->db->get('mst_user')->row();
            if ($cbs_exists) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. CBS Account No are unique.');
                echo json_encode($message);
                return;
            }
        } else {
            // Check for duplicate CBS account number during update, excluding the current user's record
            $this->db->where('bank_acct_no', $_POST['bank_acct_no']);
            $this->db->where('loan_type_id !=', 5);
            $this->db->where('id !=', $_POST['id']);
            $this->db->where('bank_acct_no IS NOT NULL');
            $this->db->where('bank_acct_no !=', '');
            $cbs_exists = $this->db->get('mst_user')->row();
            if ($cbs_exists) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. CBS Account No are unique.');
                echo json_encode($message);
                return;
            }
        }

        // Check for duplicate RR CBS account numbers
        if (empty($_POST['id'])) {
            $this->db->where('rr_cbs_acct_no', @$_POST['rr_cbs_acct_no']);
            $this->db->where('loan_type_id', 5);
            $this->db->where('rr_cbs_acct_no IS NOT NULL');
            $this->db->where('rr_cbs_acct_no !=', '');
            $cbs_exists_rr = $this->db->get('mst_user')->row();
            if ($cbs_exists_rr) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. RR CBS Account No are unique.');
                echo json_encode($message);
                return;
            }
        } else {
            $this->db->where('rr_cbs_acct_no', @$_POST['rr_cbs_acct_no']);
            $this->db->where('id !=', $_POST['id']);
            $this->db->where('loan_type_id', 5);
            $this->db->where('rr_cbs_acct_no IS NOT NULL');
            $this->db->where('rr_cbs_acct_no !=', '');
            $cbs_exists_rr = $this->db->get('mst_user')->row();
            if ($cbs_exists_rr) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'Duplicate entry detected. RR CBS Account No are unique.');
                echo json_encode($message);
                return;
            }
        }

        // Update or Insert user information
        if (!empty($_POST['id'])) {
            $e_id = $data['id'];
            $data['branch_id'] = $_POST['branch_id'];
            $current_rr_status = $this->db->get_where('mst_user', array('id' => $e_id))->row()->rinnraksha_status;

            if ($current_rr_status == 'No' && $_POST['rinnraksha_status'] == 'Yes') {
                // Create data for the additional entry
                $additional_entry_data = array(
                    'loan_type_id' => 5,
                    'connector_id' => $_POST['connector_id'],
                    'branch_id' => $data['branch_id'],
                    'state_id' => $_POST['state_id'],
                    'city_id' => $_POST['city_id'],
                    'user_name' => $_POST['user_name'],
                    'user_phone' => $_POST['user_phone'],
                    'user_email' => $_POST['user_email'],
                    'user_address' => $_POST['user_address'],
                    'disb_date' => $data['disb_date'],
                    'disb_status' => $data['disb_status'],
                    'los_id' => $_POST['los_id'],
                    'bank_acct_no' => null,
                    'rinnraksha_status' => @$_POST['rinnraksha_status'],
                    'sanction_amt' => $_POST['sanction_amt'],
                    'rinnraksha_amt' => $_POST['rinnraksha_amt'],
                    'rr_cbs_acct_no' => $_POST['rr_cbs_acct_no'],
                    'status' => $_POST['status'],
                    'login_code' => $_POST['login_code'],
                    'created_by' => $_SESSION['staff_id']
                );

                // Insert the additional entry
                $this->db->insert('mst_user', $additional_entry_data);
                $rr_id = $this->db->insert_id();

                $data['applicant_rr_id'] = $rr_id;
            }

            if ($current_rr_status == 'Yes' && @$_POST['rinnraksha_status'] == 'Yes') {
                $data['loan_type_id'] = 5;
                $data['sanction_amt'] = $_POST['rinnraksha_amt'];
                $data['rinnraksha_status'] = 'Yes';
                $data['rinnraksha_amt'] = $_POST['rinnraksha_amt'];
            }

            if ($current_rr_status == 'Yes' && @$_POST['rinnraksha_status'] == 'No') {
                $invoice_generated = $this->db->get_where('mst_user', array('id' => $e_id, 'applicant_invoice_status' => 'Generated'))->row();
                if (!$invoice_generated) {
                    // Delete entry if rinnraksha_status is 'no' and invoice has not been generated
                    $del_data = array(
                        'rinnraksha_status' => 'No',
                        'rinnraksha_amt' => '0',
                        'applicant_rr_id' => NULL
                    );
                    $this->db->where('applicant_rr_id', $data['id']);
                    $this->db->update('mst_user', $del_data);
                    $this->db->where('id', $e_id);
                    $this->db->delete('mst_user');

                    // Set the message to notify the user
                    $message = array('success' => '1', 'type' => 'success', 'message' => 'Entry deleted as invoice was not generated.');
                    echo json_encode($message);
                    return;
                } else {
                    // Set the message to notify the user that the invoice has been generated
                    $message = array('success' => '0', 'type' => 'error', 'message' => 'Cannot delete entry as invoice has already been generated.');
                    echo json_encode($message);
                    return;
                }
            }
            
            // Track Changes and Add Activities
        $activity_logs = []; // Array to hold activity logs
        if (!empty($_POST['id'])) {
            // Existing user, fetch current data
            $existing_data = $this->db->get_where('mst_user', ['id' => $_POST['id']])->row_array();

            // Compare existing data with new data and log changes
            foreach ($data as $key => $new_value) {
                if (isset($existing_data[$key]) && $existing_data[$key] != $new_value) {
                    $activity_logs[] = [
                        'user_id' => $_POST['id'],
                        'field_name' => $key,
                        'old_value' => $existing_data[$key],
                        'new_value' => $new_value,
                        'updated_by' => $_SESSION['staff_id'],
                        'updated_at' => date('Y-m-d H:i:s'),
                        'ip_address' => $_SERVER['REMOTE_ADDR'],
                        'device_name' =>$_SERVER['HTTP_USER_AGENT']
                    ];
                }
            }
        } else {
            // New user, log all fields as new entries
            foreach ($data as $key => $new_value) {
                $activity_logs[] = [
                    'user_id' => null, // Will be updated after insert
                    'field_name' => $key,
                    'old_value' => null,
                    'new_value' => $new_value,
                    'updated_by' => $_SESSION['staff_id'],
                    'updated_at' => date('Y-m-d H:i:s'),
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                    'device_name' =>$_SERVER['HTTP_USER_AGENT']
                ];
            }
        }

            
            
            $this->db->where('id', $data['id']);
            $res = $this->db->update('mst_user', $data);
            $msg = 'Updated Successfully..!';
            
            foreach ($activity_logs as &$log) {
                $log['user_id'] = $e_id;
            }
            
        } else {
            $data['created_by'] = $_SESSION['staff_id'];
            $res = $this->db->insert('mst_user', $data);
            $msg = 'Added Successfully..!';
            $e_id = $this->db->insert_id();
            
            foreach ($activity_logs as &$log) {
                $log['user_id'] = $e_id;
            }

            // If rinnraksha_status is 'Yes', add an additional entry
            if ($_POST['rinnraksha_status'] == 'Yes') {
                // Create data for the additional entry
                $additional_entry_data = array(
                    'loan_type_id' => 5,
                    'connector_id' => $_POST['connector_id'],
                    'branch_id' => $data['branch_id'],
                    'user_name' => $_POST['user_name'],
                    'user_phone' => $_POST['user_phone'],
                    'user_email' => $_POST['user_email'],
                    'state_id' => $_POST['state_id'],
                    'city_id' => $_POST['city_id'],
                    'user_address' => $_POST['user_address'],
                    'disb_date' => $data['disb_date'],
                    'disb_status' => $data['disb_status'],
                    'los_id' => $_POST['los_id'],
                    'bank_acct_no' => null,
                    'rinnraksha_status' => $_POST['rinnraksha_status'],
                    'sanction_amt' => null,
                    'rinnraksha_amt' => $_POST['rinnraksha_amt'],
                    'rr_cbs_acct_no' => $_POST['rr_cbs_acct_no'],
                    'status' => $_POST['status'],
                    'login_code' => $_POST['login_code'],
                    'created_by' => $_SESSION['staff_id']
                );
              // print_r($additional_entry_data); die;
                // Insert the additional entry
                $this->db->insert('mst_user', $additional_entry_data);
              
                $rr_id = $this->db->insert_id();
                $this->db->where('id', $e_id);
                $rr_data['applicant_rr_id'] = $rr_id;
                $this->db->update('mst_user', $rr_data);
            }
            
            $this->globle_update_sbi_commi();
            $this->updatePartPayout();
        }
        
        
        // File upload configuration
            $config['upload_path'] = realpath('./assets/uploads/documents/');
            $config['allowed_types'] = 'jpg|jpeg|png|pdf'; // Add or modify file types as needed
            $config['max_size'] = 3072; // Maximum file size in kilobytes
            
            if (isset($_FILES['apprisal_letter_file']) && !empty($_FILES['apprisal_letter_file']['name'][0])) {
                $files = $_FILES;
                $file_count = count($_FILES['apprisal_letter_file']['name']);
                $user_id = !empty($_POST['id']) ? $_POST['id'] : $e_id;  // Use provided ID if it's an update; otherwise, use the last inserted ID.
            
                for ($i = 0; $i < $file_count; $i++) {
                    $_FILES['apprisal_letter_file']['name'] = $files['apprisal_letter_file']['name'][$i];
                    $_FILES['apprisal_letter_file']['type'] = $files['apprisal_letter_file']['type'][$i];
                    $_FILES['apprisal_letter_file']['tmp_name'] = $files['apprisal_letter_file']['tmp_name'][$i];
                    $_FILES['apprisal_letter_file']['error'] = $files['apprisal_letter_file']['error'][$i];
                    $_FILES['apprisal_letter_file']['size'] = $files['apprisal_letter_file']['size'][$i];
            
                    if ($_FILES['apprisal_letter_file']['size'] > $config['max_size'] * 1024) {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'Appraisal Letter file must be less than 3 MB.'));
                        return;
                    }
            
                    $config['file_name'] = 'apprisal_letter' . date('dmYhis') . '_' . str_replace(' ', '_', $_POST['user_name']);
                    $this->upload->initialize($config);
                    
            
                    if ($this->upload->do_upload('apprisal_letter_file')) {
                        
                        // Save appraisal letter information to appraisal_letters table
                        $appraisal_letter_data = array(
                            'user_id' => $user_id,
                            'appraisal_letter' => $this->upload->data('file_name'),
                            'add_date' => date('Y-m-d H:i:s'),
                            'uploaded_by' => $_SESSION['staff_id']
                        );
                        $this->db->insert('appraisal_letters', $appraisal_letter_data);
                        
                        $file_path = $this->upload->data('full_path');
                        $ocr_text = $this->extract_text_from_image($file_path);
                        
                        $parsed_data = $this->parse_appraisal_text($ocr_text);
                        $parsed_data['user_id'] = $user_id;
                        $this->db->insert('tbl_appraisal_reports', $parsed_data);
    
    
                    } else {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => $this->upload->display_errors()));
                        return;
                    }
                }
            }
            
            if (isset($_FILES['apprisal_letter_two']) && !empty($_FILES['apprisal_letter_two']['name'][0])) {
                $files = $_FILES;
                $file_count = count($_FILES['apprisal_letter_two']['name']);
                $user_id = !empty($_POST['id']) ? $_POST['id'] : $e_id;  // Use provided ID if it's an update; otherwise, use the last inserted ID.
            
                for ($i = 0; $i < $file_count; $i++) {
                    $_FILES['apprisal_letter_two']['name'] = $files['apprisal_letter_two']['name'][$i];
                    $_FILES['apprisal_letter_two']['type'] = $files['apprisal_letter_two']['type'][$i];
                    $_FILES['apprisal_letter_two']['tmp_name'] = $files['apprisal_letter_two']['tmp_name'][$i];
                    $_FILES['apprisal_letter_two']['error'] = $files['apprisal_letter_two']['error'][$i];
                    $_FILES['apprisal_letter_two']['size'] = $files['apprisal_letter_two']['size'][$i];
            
                    if ($_FILES['apprisal_letter_two']['size'] > $config['max_size'] * 1024) {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => 'Appraisal Letter file must be less than 3 MB.'));
                        return;
                    }
            
                    $config['file_name'] = 'apprisal_letter' . date('dmYhis') . '_' . str_replace(' ', '_', $_POST['user_name']);
                    $this->upload->initialize($config);
            
                    if ($this->upload->do_upload('apprisal_letter_two')) {
                        // Save appraisal letter information to appraisal_letters table
                        $appraisal_letter_data2 = array(
                            'user_id' => $user_id,
                            'apprisal_letter_two' => $this->upload->data('file_name'),
                            'add_date' => date('Y-m-d H:i:s'),
                             'uploaded_by' => $_SESSION['staff_id']
                        );
                        $this->db->insert('appraisal_letters', $appraisal_letter_data2);
                    } else {
                        echo json_encode(array('success' => '0', 'type' => 'error', 'message' => $this->upload->display_errors()));
                        return;
                    }
                }
            }
            
        if (!empty($activity_logs)) {
            $this->db->insert_batch('applicant_user_activity', $activity_logs);
        }
        
        if ($res) {
            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
            $this->session->set_flashdata('response_message', $message);
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didn\'t add. Please try again later.');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please fill out the details before submitting.');
    }

    echo json_encode($message);
}



private function extract_text_from_image($image_path)
{
    $apiKey = 'K85899459188957'; // OCR.Space key
    $url = 'https://api.ocr.space/parse/image';

    $postFields = [
        'apikey' => $apiKey,
        'language' => 'eng',
        'isOverlayRequired' => false,
        'OCREngine' => 2,
    ];

    $postFields['file'] = new CURLFile($image_path);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);

    $result = curl_exec($ch);
    curl_close($ch);

    $response = json_decode($result, true);
    return $response['ParsedResults'][0]['ParsedText'] ?? '';
}


private function parse_appraisal_text($text)
{
    $data = [];

    $data['sourcing_channel_ref_no'] = $this->extract_field($text, '/Sourcing Channel Reference No[:\.]?\s*(\S+)/i');
    $data['rlms_app_id'] = $this->extract_field($text, '/RLMS Application ID No[:\.]?\s*(\d+)/i');
    $data['sourcing_group'] = $this->extract_field($text, '/Sourcing Group[:\.]?\s*(.+)/i');
    $data['branch_name_code'] = $this->extract_field($text, '/Sourcing Branch Name with Code[:\.]?\s*(.+)/i');
    $data['officer_name_code'] = $this->extract_field($text, '/Sourcing Officer Name and Code[:\.]?\s*(.+)/i');
    $data['agency_type'] = $this->extract_field($text, '/Agency Channel Type[:\.]?\s*(.+)/i');
    $data['agency_code'] = $this->extract_field($text, '/Agency Channel Code[:\.]?\s*(.+)/i');
    $data['agency_name'] = $this->extract_field($text, '/Agency Channel Name[:\.]?\s*(.+)/i');
    $data['referrer_group'] = $this->extract_field($text, '/Referrer Group[:\.]?\s*(.+)/i');
    $data['referrer_code_name'] = $this->extract_field($text, '/Referrer Code\s*-\s*Name[:\.]?\s*(.+)/i');
    $data['receipt_date'] = $this->parse_date($this->extract_field($text, '/Date of receipt of Application.*?(\d{2}[\/\-]\d{2}[\/\-]\d{4})/i'));
    $data['loan_purpose'] = $this->extract_field($text, '/Loan Purpose[:\.]?\s*(.+)/i');
    $data['product_code'] = $this->extract_field($text, '/Product Code.*?:\s*(.+)/i');
    $data['scheme'] = $this->extract_field($text, '/Scheme[:\.]?\s*(.+)/i');
    $data['project_cost'] = $this->extract_amount($text, '/Project Cost\s*[₹Rs.:]*\s*([\d,\.]+)/i');
    $data['requested_loan_amt'] = $this->extract_amount($text, '/Requested Loan Amount\s*[₹Rs.:]*\s*([\d,\.]+)/i');
    $data['recommended_loan_amt'] = $this->extract_amount($text, '/Recommended Loan Amount.*?[₹Rs.:]*\s*([\d,\.]+)/i');
    $data['pre_emi_interest'] = $this->extract_amount($text, '/Pre EMI Interest[:\.]?\s*[₹Rs.]*\s*([\d,\.]+)/i');
    $data['total_sanctioned_amt'] = $this->extract_amount($text, '/Total Sanctioned Amount[:\.]?\s*[₹Rs.]*\s*([\d,\.]+)/i');


    return $data;
}


private function extract_field($text, $pattern)
{
    if (preg_match($pattern, $text, $matches)) {
        return trim($matches[1]);
    }
    return null;
}

private function extract_amount($text, $pattern)
{
    if (preg_match($pattern, $text, $matches)) {
        return str_replace(',', '', $matches[1]); // Remove commas for decimals
    }
    return null;
}

private function parse_date($date)
{
    $date = str_replace('/', '-', $date);
    return date('Y-m-d', strtotime($date));
}


public function update_row_values_applicant() {
    $rowId = $this->input->post('row_id');
    $sanctionAmt = $this->input->post('sanction_amt');
    $sanctionDate = $this->input->post('disb_date');
    //print_r($sanctionDate); die;
    $disbStatus = $this->input->post('disb_status');
    

    // If $sanctionDate is '0000-00-00', set it to NULL
    $sanctionDate = ($sanctionDate == '') ? null : $sanctionDate;

    // Prepare data for update
    $data = array(
        'sanction_amt' => $sanctionAmt,
        'disb_date' => $sanctionDate,
        'disb_status' => $disbStatus
    );

    // If disb_status is 'yes', update 'status' to 'Disb Case'
    if ($disbStatus == 'yes') {
        $data['status'] = 'Disb Case';
    } elseif ($disbStatus == 'no') {
        $data['status'] = 'Login Case';
    }

    // Update the row in 'mst_user' table
    $this->db->where('id', $rowId);
    $this->db->update('mst_user', $data);

    // Send a response (e.g., success message)
    echo json_encode(['status' => 'success']);
}


public function update_row_part_payout() {
    $rowId = $this->input->post('row_id');
    $part_payout = $this->input->post('part_payout');
    

    // Prepare data for update
    $data = array(
        'part_payout' => $part_payout
    );
    // Update the row in 'mst_user' table
    $this->db->where('id', $rowId);
    $this->db->update('mst_user', $data);

    // Send a response (e.g., success message)
    echo json_encode(['status' => 'success']);
}


public function update_row_values_sbi_commi() {
    $rowId = $this->input->post('row_id');
    $sbi_commi = $this->input->post('sbi_commi');
    $commi_slab = $this->input->post('commi_slab');

    // Prepare data for update
    $data = array(
        'sbi_commi' => $sbi_commi,
        'commi_slab' => $commi_slab
    );
  
    // Update the row in 'mst_user' table
    $this->db->where('id', $rowId);
    $this->db->update('mst_user', $data);

    // Send a response (e.g., success message)
    echo json_encode(['status' => 'success']);
}


public function update_row_values_pb_commi() {
    $rowId = $this->input->post('row_id');
    $pb_commi = $this->input->post('pb_commi');
    $commi_slab = $this->input->post('commi_slab');

    // Prepare data for update
    $data = array(
        'pb_commi' => $pb_commi,
        'commi_slab' => $commi_slab
    );
  
    // Update the row in 'mst_user' table
    $this->db->where('id', $rowId);
    $this->db->update('mst_user', $data);

    // Send a response (e.g., success message)
    echo json_encode(['status' => 'success']);
}


//hlc invoice cases
public function manage_invoice_cases() {  
   
    $data['current_page'] = 'Applicants';
    $data['title'] = 'Applicants Report';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();

    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $stauts = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');  
    $city_id = $this->input->post('city_id');
    
    $disb_month_year = $this->input->post('month');
    
    $offset = $this->input->get('per_page');

    $applicant_invoice_status = 'Generated';
  
    $data['user'] = $this->ccm->get_applicant_data($start_date,$end_date,$stauts,$conn_id,$branch_id,'','',$applicant_invoice_status,'','','',$city_id,$disb_month_year);
    


    $data['viewfile'] = "admin/manage_invoice_cases/manage_invoice_cases";

    $this->load->view('admin/layout', $data);

}


//SBI invoice cases
public function manage_invoice_cases_sbi() { 
    if (in_array('Create Invoices RBO', $this->menu_permission)){
        
    $data['current_page'] = 'Create Invoice SBI';
    $data['title'] = 'Create Invoice SBI';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
   
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();

    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $stauts = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch'); 
    $city_id = $this->input->post('city_id'); 
    $disb_month_year = $this->input->post('month');
    $rbo = $this->input->post('rbo');
   // print_r($_POST); die;
   
     
    $offset = $this->input->get('per_page');

    $hlc_invoice_status = 'Generated';
    $branch_genrated = 'Yes';
    $sbi_genrated = 'No';
    $data['user'] = $this->ccm->get_applicant_data_rbo($start_date,$end_date,$stauts,$conn_id,$branch_id,'','',$sbi_genrated,$hlc_invoice_status,'',$city_id,$branch_genrated,$disb_month_year,$rbo);


    $data['viewfile'] = "admin/manage_invoice_cases/manage_invoice_cases_sbi";

    $this->load->view('admin/layout', $data);
    }
    else{
        echo 'No Permission This Menue';
    }

}


//SBI invoice cases branch
public function manage_invoice_branch_confirmation() {  
   
    $data['current_page'] = 'Create Invoice Branch';
    $data['title'] = 'Create Invoice SBI Branch';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $stauts = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');  
    $disb_month_year = $this->input->post('month');
    $rbo = $this->input->post('rbo');
    
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    
    $offset = $this->input->get('per_page');

    $hlc_invoice_status = 'Generated';
    $branch_genrated = null;
    $data['user'] = $this->ccm->get_applicant_data_branch($start_date,$end_date,$stauts,$conn_id,$branch_id,'','','', $branch_genrated, $hlc_invoice_status, $disb_month_year, $rbo, $city_id);


    $data['viewfile'] = "admin/manage_invoice_branch/create_invoice_branch.php";

    $this->load->view('admin/layout', $data);

}

public function manage_invoice_branch() {
    $perPage = $this->input->post('per_page') ? $this->input->post('per_page') : 20;


    $data['current_page'] = 'Invoices Branch';

    $data['title'] = 'List Invoices Branch';

    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();

  //print("<pre>".print_r( $data['inv'],true)."</pre>"); die;

    $data['viewfile'] = "admin/manage_invoice_branch/manage_invoice_branch.php";

    $this->load->view('admin/layout', $data);

}

public function fetch_invoice_data_branch_conf()
{
    $this->load->model('Branchconf_model');
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $branch_id = $this->input->post('branch');
    $conn_id = $this->input->post('connector');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');

    $data = $this->Branchconf_model->fetch_invoice_data_branch($start_date, $end_date, $conn_id, $branch_id, $disb_month_year, $state_id, $city_id);

    $result = array();
    $sr_no = $_POST['start'] + 1;

    foreach ($data as $row) {
        $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $row['user_id']])->get()->row();     
        $branch_data = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $city = $this->db->select("*")->where(['id' => $branch_data->city_id])->from('mst_city')->get()->row();
        $invoiceNumber = $row['inv_batchno'];

                $applicantLog = $this->db->select('invoices.*, mst_user.user_name, mst_user.id as link_user_id, mst_user.login_code, mst_loan_type.name as loan_type_name')
                    ->from('invoices')
                    ->join('mst_user', 'invoices.user_id = mst_user.id') // Join with mst_user
                    ->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id') // Join with mst_loan_type
                    ->where(['invoices.inv_batchno' => $invoiceNumber])
                    ->order_by('invoices.id', 'asc')
                    ->get()
                    ->result_array();
                
                $formattedApplicants = '';
                foreach ($applicantLog as $sr => $val) {
                    // Create a link based on the login_code
                    $link = ($val['login_code'] === 'PaisaBazaar') 
                        ? base_url('admin/pb_user_form/' . $val['link_user_id']) 
                        : base_url('admin/applicant_form/' . $val['link_user_id']);
                    
                    // Add the applicant's name with the link
                    $formattedApplicants .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' . $val['user_name'] . '</a> (' . $val['loan_type_name'] . ') ';
                    
                    // Add delete icon for staff_id = 14
                    if (isset($_SESSION['staff_id']) && $_SESSION['staff_id'] == 14) {
                        $formattedApplicants .= '<i class="bi bi-trash text-danger" style="cursor: pointer;" onclick="deleteApplicantBranchInvoice(' . $val['id'] . ', ' . $val['user_id'] . ', \'' . addslashes($val['user_name']) . '\')"></i>';
                    }
                
                    $formattedApplicants .= '<br>';
                }

        
        

        $invoice_items = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceNumber])->get()->result_array();

        $totalLoanAmt = 0;
        $sumTotalCommiCol = 0;
        $sumTotalten10_commiCol = 0;
        $sum_fix_commi_rr = 0;
        $sum10_rr_Col = 0;
        
        foreach ($invoice_items as $key => $rows) {
            $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $rows['user_id']])->get()->row();
            $loanAmount = $user_data->loan_type_id == 5 ? $user_data->rinnraksha_amt : $user_data->sanction_amt;
            $totalLoanAmt += $loanAmount;
            if ($user_data->loan_type_id == 5) { 
                $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $user_data->id, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
                if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                    $rr_sanction_amt = $this->db->select("*")->where(['id' => $rr_aact->id])->from('mst_user')->get()->row();
                    $sanctionAmt = $rr_sanction_amt->sanction_amt ?? 0;
                    if ($sanctionAmt == 5000000) {
                        // If the sanction amount is exactly 50 lakh, set commission to 4000
                        $commission = 4000;
                    } elseif ($sanctionAmt > 100000 && $sanctionAmt < 5000000) {
                        $commission = 4000;
                    } elseif ($sanctionAmt > 5000000 && $sanctionAmt < 10000000) {
                        $commission = 5000;
                    } elseif ($sanctionAmt >= 10000000) {
                        $commission = 6000;
                    } else {
                        $commission = 0;
                    }
                    
                    $sum_fix_commi_rr += $commission;
                    
                    $ten10_rr_comm = $commission * 10 / 100;
                    $sum10_rr_Col += round($ten10_rr_comm);
                    
                    $rr_commision_row = $commission - ($ten10_rr_comm);
                }
            }
            $total_commi_row = round($loanAmount * $user_data->sbi_commi / 100);
            $sumTotalCommiCol += $total_commi_row;
            $ten10_commi_row = $total_commi_row * 10 / 100;
            $sumTotalten10_commiCol += $ten10_commi_row;
            $ninty90_comm_row = $total_commi_row - $ten10_commi_row;
        }
        $ninety90_col_sum = round($sumTotalCommiCol + $sum_fix_commi_rr) - round($sumTotalten10_commiCol + $sum10_rr_Col);
        $netPayamt = $ninety90_col_sum + $ninety90_col_sum * 18 / 100;

        $edit_links = '<div class="d-flex align-items-center gap-3 fs-6">
                        <a href="' . base_url() . 'Invoice_pdf_branch/generatePDF/' . $invoiceNumber . '" target="_BLANK" class="text-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="View Invoice" aria-label="Views">
                            <i class="bi bi-printer"></i>
                        </a>';

        if ($this->admin_profile->is_right_delete == 'yes') {
            $edit_links .= '<a href="javascript:;" class="text-danger delete" data-bs-toggle="tooltip" data-id="'.$invoiceNumber.'" data-bs-placement="bottom" title="" data-bs-original-title="Delete" aria-label="Delete" action="delete_invoice_branch">
                                <i class="bi bi-trash-fill"></i>
                            </a>';
        }

        $edit_links .= '</div>';
        
        
        $allowed_staff_ids = [14, 13, 538, 889];
        $session_staff_id = $this->session->userdata('staff_id');
        
        $invoice_date_html = '
            <span class="editable-invoice-date" 
                  data-invoice="' . $row['inv_batchno'] . '" 
                  data-current-date="' . $row['invoice_date'] . '">
                ' . date('d.m.Y', strtotime($row['invoice_date'])) . '
            </span>';
        
        if (in_array($session_staff_id, $allowed_staff_ids)) {
            $invoice_date_html .= '
                <i class="bi bi-pencil-square edit-brinvoice-date-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Date"
                   data-invoice="' . $row['inv_batchno'] . '" 
                   data-current-date="' . $row['invoice_date'] . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editBrInvoiceDateModal">
                </i>';
        }
        
        
        $invoice_num_html = '<a target="_BLANK" href="'.base_url().'Invoice_pdf_branch/generatePDF/'.$invoiceNumber.'">'.$row['invoice_number'].'</a>';
        
         if (in_array($session_staff_id, $allowed_staff_ids = [14])) {
            $invoice_num_html .= '
                <i class="bi bi-pencil-square edit-brinvoice-num-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Number"
                   data-invoice="' . $row['inv_batchno'] . '" 
                   data-current-num="' . $row['invoice_number'] . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editBrInvoiceNumModal">
                </i>';
        }

        $result[] = array(
            "sr_no" => $sr_no++,
            "branch_name" => $row['branch_name'],
            "city_name" => $city->city_name,
            "applicant" => $formattedApplicants,
            "invoice_number" => $invoice_num_html,
            "net_pay_amt" => $this->formatIndianNumber($netPayamt),
            "invoice_date" => $invoice_date_html,
            "created_date" => date('d.m.Y', strtotime($row['add_date'])),
            "edit" => $edit_links
        );
    }

    echo json_encode(array(
        "draw" => intval($_POST['draw']),
        "recordsTotal" => intval($this->Branchconf_model->count_all()),
        "recordsFiltered" => intval($this->Branchconf_model->count_filtered($start_date, $end_date, $conn_id, $branch_id, $disb_month_year,$state_id, $city_id)),
        "data" => $result
    ));
}

public function merge_invoices() {
    $staff_id = $_SESSION['staff_id'];
    
     // Only allow if staff admin is Rrb 
    if ($staff_id !== '14' && $staff_id !== '13') {
        show_error('You are not authorized to access this page.', 403);
        return;
    }
  
    $data['current_page'] = 'merge_invoices';
    $data['title'] = 'Merge Invoices';
    
    $this->db->where('staff_id', $staff_id);
    $data['staffname'] = $this->db->get('mst_staff')->row()->staff_fullname;
    $data['viewfile'] = "admin/manage_invoice/merge_invoices";
    $this->load->view('admin/layout', $data);
}

public function save_merged_invoices()
{
    $from_invoice_no = $this->input->post('from_invoice_no');
    $to_invoice_no = $this->input->post('to_invoice_no'); 
    $remark = $this->input->post('remark'); 
    
     $to_invoice = $this->db->select("*")->where(['invoice_number' => $to_invoice_no])->from('invoices')->get()->row();
     $to_inv_batchno = $to_invoice->inv_batchno;
     $to_invoice_date = $to_invoice->invoice_date;
     $to_invoice_type = $to_invoice->invoice_type;
     
    
     
    $from_invoice = $this->db
            ->get_where('invoices', ['invoice_number' => $from_invoice_no])
            ->row();
        
        if (!$from_invoice) {
            echo json_encode([
                'success' => '0',
                'type' => 'error',
                'message' => 'From Invoice not found.'
            ]);
            return;
        }
        
        $from_invoice_type = $from_invoice->invoice_type;
        $from_inv_batchno = $from_invoice->inv_batchno;
        
    $merged_details = 'This invoice '.$from_invoice_no.'Batch no- '.$from_inv_batchno.' merged in invoice- '.$to_invoice_no;
    $merged_date = date('Y-m-d H:i:s');
             
     if (($from_invoice_type !== $to_invoice_type) || ($to_invoice_type !== $from_invoice_type)) { 
        $message = array(
            'success' => '0',
            'type' => 'error',
            'message' => 'Both invoice types must be the same.'
        );
        echo json_encode($message); 
        return; // Stop further execution
    }
    
     $invoice_types = [
    'inv_sbi' => 'sbi_status',
    'inv_hlc' => 'hlc_status',
    'inv_pb'  => 'pb_pay_status',
    ];
    
    foreach ($invoice_types as $type => $status_field) {
        if ($from_invoice_type == $type || $to_invoice_type == $type) {
            if (!empty($from_invoice->$status_field) || !empty($to_invoice->$status_field)) {
                $message = array(
                    'success' => '0',
                    'type'    => 'error',
                    'message' => 'This is paid invoice. Not allowed to merge.'
                );
                echo json_encode($message);
                return;
            }
        }
    }
     
     // Update from invoice 
    $this->db->where('invoice_number', $from_invoice_no);
    $this->db->where('invoice_type', $to_invoice_type);
    $updated = $this->db->update('invoices', [
        'inv_batchno' => $to_inv_batchno,
        'invoice_number' => $to_invoice_no,
        'invoice_date' => $to_invoice_date,
        'merged_details' => $merged_details,
        'merged_date' => $merged_date,
        'merged_by' => $_SESSION['staff_id'],
        'remark' => $remark
    ]);

    if ($updated) {
         $message = array('success' => '1', 'type' => 'success', 'message' => 'Invoices merged successfully.');

        $this->session->set_flashdata('success', $message);
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Failed to merge invoices.');
    }

    echo json_encode($message);
   
}


public function manage_hlc_payments() {
  
    $data['current_page'] = 'manage_hlc_payment';
    $data['title'] = 'List Partner Payment';

    //$data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['connector_created'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 0])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_invoice/manage_hlc_payment";
    $this->load->view('admin/layout', $data);
}

public function fetch_hlc_payment_part() {
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $status = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $created_by_part = $this->input->post('created_by_part');
    $branch_id = $this->input->post('branch');    
    $hlc_paid_st = $this->input->post('hlc_status');   
    $sbi_payment_status = $this->input->post('sbi_payment_status');   
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $sbi_generated = $this->input->post('sbi_generated');
    $branch_generated = $this->input->post('branch_generated');
    $partner_generated = $this->input->post('partner_generated');
    $rbo = $this->input->post('rbo');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('Payment_model');

    $total_data = $this->Payment_model->count_applicant_data('', $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part);
    $total_filtered = $this->Payment_model->count_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part);

    $user_data = $this->Payment_model->get_applicant_data($search, $start_date, $end_date, $status, $conn_id, $branch_id, $limit, $offset, '', '', '', $hlc_paid_st, $city_id, $sbi_payment_status, $disb_month_year, $sbi_generated,$branch_generated,$partner_generated,$rbo,$created_by_part);

    $data = array();

    foreach ($user_data as $key => $row) {
        $branch = $this->db->select("*")->where(['id' => $row['branch_id']])->from('branch')->get()->row();
        $conn = $this->db->select("*")->where(['staff_id' => $row['connector_id']])->from('mst_staff')->get()->row();
        $circle = $this->db->select("*")->where(['id' => $conn->circle_id])->from('mst_circle')->get()->row();
        $state = $this->db->select("*")->where(['id' => $row['state_id']])->from('mst_state')->get()->row();
        $city = $this->db->select("*")->where(['id' => $row['city_id']])->from('mst_city')->get()->row();
        $rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => @$branch->rbo_id])->get()->row();
        $racpc = $this->db->select("*")->from('mst_racpc')->where(['id' => @$branch->racpc_id])->get()->row();
        $inv_hlc_data = $this->db->select("*")->from('invoices')->where(['id' => $row['invoice_id']])->get()->row();
        $inv_sbi_data = $this->db->select("*")->from('invoices')->where(['id' => $row['sbi_invoice_id']])->get()->row();
        $inv_branch_data = $this->db->select("*")->from('invoices')->where(['id' => $row['branch_invoice_id']])->get()->row();

        if($row['hlc_payment_status']=='paid'){
            $statusP = 'paid';
        } elseif($row['hlc_payment_status']=='excess paid') {
            $statusP = "excess paid";
        } elseif($row['hlc_payment_status']=='partly paid') {
            $statusP = "partly paid";
        } elseif($row['hlc_payment_status']==NULL && $row['disb_status']=='yes') {
            $statusP = "unpaid";
        } else {
            $statusP = '';
        }

        // Define the badge color based on payment status
        if($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif($statusP=="paid") {
            $badge_class = "badge bg-success";
        } elseif($statusP=="excess paid") {
            $badge_class = "badge bg-warning";
        } elseif($statusP=="partly paid") {
            $badge_class = "badge bg-info";
        } else {
            $badge_class = '';
        }

        // SBI payment status
        if($row['sbi_payment_status']=='paid'){
            $sbistatusP = 'paid';
        } elseif($row['sbi_payment_status']=='excess paid') {
            $sbistatusP = "excess paid";
        } elseif($row['sbi_payment_status']=='partly paid') {
            $sbistatusP = "partly paid";
        } elseif($row['sbi_payment_status']==NULL && $row['disb_status']=='yes') {
            $sbistatusP = "unpaid";
        } else {
            $sbistatusP = '';
        }

        if($sbistatusP == "unpaid") {
            $badge_class_sbi = "badge bg-danger";
        } elseif($sbistatusP=="paid") {
            $badge_class_sbi = "badge bg-success";
        } elseif($sbistatusP=="excess paid") {
            $badge_class_sbi = "badge bg-warning";
        } elseif($sbistatusP=="partly paid") {
            $badge_class_sbi = "badge bg-info";
        } else {
            $badge_class_sbi = '';
        }
        
         $loanAmount = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];

        $nestedData = array();
        $nestedData['sr_no'] = $key + 1;
       
        $nestedData['hlc_name'] = capitalize_first_three_words($conn->staff_fullname);
        $nestedData['hlc_code'] = $conn->hlc_code;
        $nestedData['applicant_name'] = capitalize_first_letter_of_each_word2($row['user_name']);
       // $nestedData['state'] = @$state->state_name;
        $nestedData['city'] = @$city->city_name;
        $nestedData['rlms_id'] = $row['los_id'];
        $nestedData['cbs_account_no'] = ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id'])) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];
        $nestedData['branch_name'] = $branch->branch_name . "[" . $branch->branch_code . "]";
        $nestedData['rbo'] = @$rbo->rbo_name;
        $nestedData['loan_type'] = $row['user_type'];
        $nestedData['sanction_loan_amt'] = ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id'])) ? $row['rinnraksha_amt'] : $row['sanction_amt'];
         $nestedData['rr_commission'] = ($row['loan_type_id'] == 5) ? calculatePremiumAmountCommission1($loanAmount) : "";

        $nestedData['conn_commision'] = $row['part_payout']."%";
        
       
        if($row['loan_type_id'] == 4){
            $conn_comm= 0.20;
        }else{
            $conn_comm = $row['part_payout'];
        }
        $nestedData['conn_payout_amt'] = formatIndianNumber(($loanAmount * $conn_comm) / 100);

        $tdsPer = 2; 
        $nestedData['tds_per'] = "{$tdsPer}%";
        
        $tds_amt = ($loanAmount * $conn_comm * $tdsPer) / 10000; // Directly calculate from original amount to avoid precision issues
        $nestedData['tds_amt'] = formatIndianNumber($tds_amt);
        
        /*$gstPercentage = !empty($conn->gst_no) ? 18 : ""; 
        $nestedData['gst_per'] = ($gstPercentage !== "") ? "{$gstPercentage}%" : "";*/
        
        $netAmount = ($loanAmount * $conn_comm) / 100 - $tds_amt;
        $nestedData['net_amt'] = formatIndianNumber($netAmount);
        
        $nestedData['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        
        $nestedData['gst_amt'] = ""; // Placeholder for future GST calculations if needed

        
       // $nestedData['status'] = ($row['disb_status']=='yes') ? 'Disb Case' : $row['status'];
        
                    // Get today's date as a DateTime object
$today = date('Y-m-d');
// Convert 'add_date' to Y-m-d format
$add_date = date('Y-m-d', strtotime($row['add_date']));

// Calculate the difference in days based on dates only
$days_difference = (strtotime($today) - strtotime($add_date)) / (60 * 60 * 24);

// Determine the color class based on the difference
if ($days_difference == 0) {
    $dot_color_class = 'green'; // Today
    $dot_text= 'Low';
} elseif ($days_difference <= 2) {
    $dot_color_class = 'orange'; // 2 days ago
    $dot_text= 'Medium';
} elseif ($days_difference == 3) {
    $dot_color_class = 'red'; // 3 days ago
    $dot_text= 'High';
} else {
    $dot_color_class = 'red';
    $dot_text= 'High';// Default (no color)
}
            
            // Add data to $nestedData
            $nestedData['add_date'] = date('d-m-Y', strtotime($row['add_date']));
      
            $created_by = $this->db->select("*")->where(['staff_id' => $conn->staff_id])->from('mst_staff')->get()->row();
            $payment_verified_by = $this->db->select("*")->where(['staff_id' => $row['payment_verified_by']])->from('mst_staff')->get()->row();
            $payment_approved_by = $this->db->select("*")->where(['staff_id' => $row['payment_approved_by']])->from('mst_staff')->get()->row();
            //$app_created_by = $this->db->select("*")->where(['staff_id' => $row['created_by']])->from('mst_staff')->get()->row();
            $admin_created_hlc = $this->db->select("*")->where(['staff_id' => $created_by->created_by])->from('mst_staff')->get()->row();
            $nestedData['created_by'] = capitalize_first_three_words($admin_created_hlc->staff_fullname);
           // $nestedData['app_created_by'] = capitalize_first_three_words($app_created_by->staff_fullname);
           // $nestedData['login_code'] = @$row['login_code'];
            
     $nestedData['verified_by'] = capitalize_first_three_words($payment_verified_by->staff_fullname);
   /*  $nestedData['payment_act_remark'] = '<input type="text" class="form-control remark-input" data-id="'.$row['id'].'" value="'.$row['payment_act_remark'].'" style="width: 300px;" />';*/
                   $bgClass = '';
                if ($row['payment_approve_status'] == 1) {
                    $bgClass = 'bg-success'; // Green for Approved
                } elseif ($row['payment_approve_status'] === '0') { // Ensure strict check for "0"
                    $bgClass = 'bg-danger'; // Red for Rejected
                }
                
                // Default selected option
                $selectedApproved = ($row['payment_approve_status'] == 1) ? 'selected' : '';
                $selectedRejected = ($row['payment_approve_status'] === '0') ? 'selected' : '';
                $selectedDefault = (empty($row['payment_approve_status']) && $row['payment_approve_status'] !== '0') ? 'selected' : ''; // Default select
                
                $nestedData['payment_approve_status'] = '<select class="form-select form-select-sm commoon_active_pb_approve_payment ' . $bgClass . '" style="width:100px;"
                    data-id="'.$row['id'].'" 
                    action="active_pb_approval_payment">
                    <option value="" '.$selectedDefault.'>-Select-</option>
                    <option value="1" '.$selectedApproved.'>Approved</option>
                    <option value="0" '.$selectedRejected.'>Reject</option>
                </select>';

     $nestedData['payment_approved_by'] = capitalize_first_three_words($payment_approved_by->staff_fullname);
     $nestedData['agency_code'] = @$city->agency_code;
     $nestedData['agency_name'] = @$city->agency_name;
     
            // Assuming user ID is in the 'id' field of $row
             if($row['loan_type_id'] == 5){
     $doc = 'RR';
 }else{
     $doc = '';
 }
$user_id = $row['id'];

// Fetch only the latest appraisal letter for the user
$this->db->select('appraisal_letter');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('appraisal_letter !=', '');
$this->db->where('appraisal_letter IS NOT NULL', null, false); 
$this->db->order_by('add_date', 'DESC');
$this->db->limit(1); // Only the latest record
$query = $this->db->get();

// Fetch the result
$appraisal_letter = $query->row_array(); // Fetch single row as an associative array

// Prepare the appraisal letter link
$appraisalLetterLink = ''; // Initialize as an empty string

if (!empty($appraisal_letter) && !empty($appraisal_letter['appraisal_letter'])) {
    $appraisalLetterLink = '<a class="btn btn-sm btn-link" href="' . base_url() . 'assets/uploads/documents/' . $appraisal_letter['appraisal_letter'] . '" target="_blank">View</a>';
} else {
    $appraisalLetterLink = $doc; // No appraisal letter found
}

// Add the link to the nested data array
//$nestedData['appraisal_letter'] = $appraisalLetterLink;
$nestedData['appraisal_letter'] = 
    ($statusP == 'unpaid' ? '<span class="dot ' . $dot_color_class . '"></span> ' . $dot_text . ' ' : '') . 
    $appraisalLetterLink;
    
    
// Fetch the latest proof of disbursement
$this->db->select('proof_disb');
$this->db->from('appraisal_letters');
$this->db->where('user_id', $user_id);
$this->db->where('proof_disb IS NOT NULL'); // Ensure it has a value
$this->db->order_by('id', 'DESC'); // Get the most recent one
$this->db->limit(1); // Limit to one record
$query3 = $this->db->get();
$latest_letter_pd = $query3->row_array(); // Fetch as an associative array

// Prepare the proof of disbursement link
$proofDisbLink = !empty($latest_letter_pd['proof_disb']) 
    ? '<a class="btn btn-sm btn-link" href="' . base_url('assets/uploads/documents/' . $latest_letter_pd['proof_disb']) . '" target="_blank">View</a>'
    : '';

// Add the links to the nested data array
$nestedData['appraisal_letter'] = $appraisalLetterLink;
$nestedData['final_sanction_letter'] = 
    ($statusPB == 'unpaid' ? '<span class="dot ' . $dot_color_class . '"></span> ' . $dot_text . ' ' : '') . 
    $finalSanctionLetterLink;
    

$nestedData['proof_disb'] = $proofDisbLink;

     $archiveModalHtml = '
    <div class="modal fade" id="archiveUserModal' . $row['id'] . '" tabindex="-1" aria-labelledby="archiveUserModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="archiveUserModalLabel' . $row['id'] . '">Archive User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="' . base_url('admin/archive_user') . '" class="archive-form">
                    <div class="modal-body">
                        <p>Are you sure you want to archive this user?</p>
                        <div class="mb-3">
                            <label for="archiveRemark' . $row['id'] . '" class="form-label">Remark</label>
                            <textarea class="form-control" id="archiveRemark' . $row['id'] . '" name="archive_remark" rows="3" required></textarea>
                        </div>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>';

         $modal_html = '
                <div class="modal fade" id="userDetailsModal' . $row['id'] . '" tabindex="-1" aria-labelledby="userDetailsModalLabel' . $row['id'] . '" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="userDetailsModalLabel' . $row['id'] . '">Applicant Details</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Name:</strong> ' . $row['user_name'] . '</p>
                                <p><strong>Branch Name:</strong> ' . $branch->branch_name . '[' . $branch->branch_code . ']</p>
                                <p><strong>Mobile:</strong> ' . $row['user_phone'] . '</p>
                                <p><strong>Email:</strong> ' . $row['user_email'] . '</p>
                                <p><strong>Address:</strong> <br>' . nl2br($row['user_address']) . '</p>
                                <hr>
                                <p><strong>Loan Type:</strong> ' . $row['user_type'] . '</p>
                                <p><strong>RLMS ID:</strong> ' . $row['los_id'] . '</p>
                                <p><strong>CBS Account No:</strong> ' . ($row['rinnraksha_status']=='Yes' && empty($row['applicant_rr_id']) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                                <p><strong>Sanction Loan Amt:</strong> ' . ($row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ? $row['rinnraksha_amt'] : $row['sanction_amt']) . '</p>
                                <p><strong>Status:</strong> ' . $row['status'] . '</p>
                                <hr>
                                
                            </div>
                        </div>
                    </div>
                </div>';
                
                //for today payment
    $partPaymentModalHtml2 = '
    <div class="modal fade" id="partPaymentModal' . $row['id'] . '" tabindex="-1" aria-labelledby="partPaymentModalLabel' . $row['id'] . '" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="partPaymentModal' . $row['id'] . '">Payment Part. - ' . capitalize_first_three_words($conn->staff_fullname) . '</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="' . base_url('admin/remove_todays_payment_user') . '" class="archive-form">
                    <div class="modal-body">
                        <h6>Are you sure you want to remove it from the payment bucket?</h6><br>
                        <p><b>RLMS: </b>' . $row['los_id'] . '</p>
                        <p><b>Applicant: </b>' . ($row['user_name']) . '</p>
                        <p><b>CBS No: </b>' . (( $row['rinnraksha_status'] == 'Yes' && empty($row['applicant_rr_id']) ) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no']) . '</p>
                        <p><b>Disb Date: </b>' . (!empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A') . '</p>
                        <input type="hidden" name="user_id" value="' . $row['id'] . '">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Yes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>';
    
                        $nestedData['edit'] = '<div class="d-flex align-items-center gap-3 fs-6">
                        <a href="javascript:;" class="text-primary" data-bs-toggle="modal" data-bs-target="#userDetailsModal' . $row['id'] . '" data-bs-placement="bottom" title="View detail" aria-label="Views">
                            <i class="bi bi-eye-fill"></i>
                        </a>
                        <a href="' . base_url('admin/applicant_form/' . $row['id']) . '" target="_blank" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit">
                            <i class="bi bi-pencil-fill"></i>
                        </a>';
                    
                    if($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 1 || $_SESSION['staff_id'] == 13 || $_SESSION['staff_id']== 634) {
                        $nestedData['edit'] .= '
                        <a href="javascript:;" class="text-success" data-bs-toggle="modal" data-bs-target="#partPaymentModal' . $row['id'] . '" data-bs-placement="bottom" title="Payment User" aria-label="Payment">
                            <i class="bi bi-currency-dollar"></i>
                        </a>';
                    }

$nestedData['edit'] .= '</div>' . $modal_html . $partPaymentModalHtml2;

                
                $data[] = $nestedData;
    }

     $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data
    );

    echo json_encode($json_data);
}


public function approve_payment()
{
    $user_id = $this->input->post('id');
    $status = $this->input->post('status');
    $remark = $this->input->post('remark');

    if (!$user_id || ($status !== '1' && $status !== '0')) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);
        return;
    }

    $this->db->where('id', $user_id);
    $this->db->update('mst_user', [
        'payment_approve_status' => $status,
        'payment_act_remark' => $remark,
        'payment_approved_by' => $_SESSION['staff_id'],
        'payment_approval_date' => date('Y-m-d H:i:s')
    ]);

    if ($this->db->affected_rows() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Status updated successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update.']);
    }
}



public function manage_tds_report() {
  
    $data['current_page'] = 'manage_tds_report';

    $data['title'] = 'List TDS Report';

    //$data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    //$data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_invoice/part_tds_report";
    $this->load->view('admin/layout', $data);

}


public function fetch_tds_data_part() {
    
     
    // Get parameters for server-side processing
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $branch_id = $this->input->post('branch');
    $conn_id = $this->input->post('connector');
    $hlc_paid_status = $this->input->post('hlc_status');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $payment_month_hlc = $this->input->post('payment_month_hlc');
    $invoice_month_hlc = $this->input->post('invoice_month_hlc');
    
    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    $this->load->model('Tds_model');
    // Fetch data
    $invoices = $this->Tds_model->get_tds_data($start_date, $end_date, $conn_id, $branch_id, $limit, $offset, $hlc_paid_status, $city_id, $disb_month_year, $payment_month_hlc, $invoice_month_hlc,$search);

    // Get total records
    $totalRecords = $this->Tds_model->count_all_tds($start_date, $end_date, $conn_id, $branch_id, $hlc_paid_status, $city_id, $disb_month_year, $payment_month_hlc, $invoice_month_hlc, $search);
    
    // Prepare response
    $data = array();
    $sr_no = $offset + 1;
    foreach ($invoices as $invoice) {
        $invoiceNumber = $invoice['inv_batchno'];

        // Fetch additional data
        $applicant_log = $this->db->select('invoices.inv_batchno, mst_user.user_name, mst_user.id, mst_user.login_code')
            ->from('invoices')
            ->join('mst_user', 'invoices.user_id = mst_user.id')
            ->where(['inv_batchno' => $invoiceNumber])
            ->get()
            ->result_array();
        
            $paid_log = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceNumber])->order_by('payment_date', 'DESC')->get()->result_array();
      
            $invoice_items = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceNumber])->get()->result_array();
    
            // Calculate net pay amount
            $totalCommisionAmt = 0;
            foreach ($invoice_items as $item) {
                $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $item['user_id']])->get()->row();
                $totalCommission = calculateTotalCommission1($this->db, $user_data, $user_data->part_payout, $item['loan_type_id'],$invoiceNumber);
                 if ($user_data->loan_type_id == 4 && $user_data->sanction_amt >= 100000 && $user_data->sanction_amt < 1000000) {
                      $totalCommission = 2000;
                    } 
                $totalCommisionAmt += $totalCommission;
            }
    
            $hlc_data = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $invoice['connector_id']])->get()->row();
             $created_by = $this->db->select('*')->where(['staff_id' => $invoice['created_by']])->from('mst_staff')->get()->row();
            $gstPercentage = empty($hlc_data->gst_no) ? 0 : 18; 
            $gst = $gstPercentage / 100 * $totalCommisionAmt;
            $netPayamt = $totalCommisionAmt;
            
            $invoiceTimestamp = strtotime($invoice['invoice_date']);
            // Define the threshold date (1st October 2024)
            $thresholdDate = strtotime('2024-10-01');
            // Check if the invoice date is on or after 1st October 2024
            if ($invoiceTimestamp >= $thresholdDate) {
                // Apply 2% TDS
                $tdsPer = 2;
                $tds = $netPayamt * 2 / 100;
            } else {
                // Apply 5% TDS
                $tdsPer = 5;
                $tds = $netPayamt * 5 / 100;
            }

           
            $grossTotal = $netPayamt + $gst;
            $netTotal = $grossTotal - $tds;
    
            // Calculate total paid amount and balance
            $totalpayamt = 0;
            foreach ($paid_log as $val) {
                $totalpayamt += $val['pay_amt'];
            }
            $tot_paid_amt = $totalpayamt;
            $rmain_bal = $netTotal - $tot_paid_amt;

      

        // Payment status
        $payment = $this->db->select("*")->where(['invoice_batchno' => $invoiceNumber, 'invoice_type' => 'inv_hlc'])->from('invoice_log')->order_by('add_date', 'DESC')->get()->row();
        $statusP = isset($payment) && isset($payment->status) ? $payment->status : "unpaid";
      
       $paidTotal = $this->db
    ->select_sum('pay_amt', 'total_paid') // 'total_paid' will be the alias for the sum
    ->from('invoice_log')
    ->where([
        'invoice_batchno' => $invoiceNumber,
        'invoice_type'    => 'inv_hlc'
    ])
    ->get()
    ->row();

// Retrieve the sum or default to 0 if null
$paid_amt_sum = $paidTotal && $paidTotal->total_paid ? $paidTotal->total_paid : 0;

        // Define the badge color based on payment status
        if ($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif ($statusP == "paid") {
            $badge_class = "badge bg-success";
        } elseif ($statusP == "excess paid") {
            $badge_class = "badge bg-warning";
        } elseif ($statusP == "partly paid") {
            $badge_class = "badge bg-info";
        }

        /*$applicant_names = '';
        foreach ($applicant_log as $sr => $val) {
            $link = ($val['login_code'] === 'PaisaBazaar') 
                ? base_url('admin/pb_user_form/' . $val['id']) 
                : base_url('admin/applicant_form/' . $val['id']);
            
            $applicant_names .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' . $val['user_name'] . '</a><br>';
        }*/


        $data[] = array(
            "sr_no" => $sr_no++,
           /* "city" => $invoice['hlc_city_name'],
            "applicant" => $applicant_names,*/
            "inv_number" => '<a href="'.base_url("Invoice_pdf_hlc/generatePDF/{$invoice['inv_batchno']}").'" target="_BLANK">'.$invoice['invoice_number'].'</a>',
            "nature_of_tds" => '194H',
            "pan_no" => $hlc_data->pan_no,
           "hlc_name" => '<a href="'.base_url("admin/connectors_form/".$hlc_data->staff_id).'" target="_BLANK">'.capitalize_first_three_words($invoice['staff_fullname']).'</a>',
            "gross_amt" => formatIndianNumber($grossTotal),
            //"paid_amt" => formatIndianNumber($tot_paid_amt),
            "tds" => formatIndianNumber($tds),
            "net_pay_amt" => formatIndianNumber($netTotal),
            "total_paid_hlc" => formatIndianNumber($paid_amt_sum),
            "payment_status" => $this->format_payment_log_hlc_pay_date(json_encode($paid_log)).$statusP
          /*  "balance" => number_format($rmain_bal, 2),
            "invoice_date" => date('d.m.Y', strtotime($invoice['invoice_date'])),
            "payment_log" => $this->format_payment_log_hlc_pay_date(json_encode($paid_log)),
            "created_date" => date('d.m.Y', strtotime($invoice['add_date'])),
           
            "created_by" => $created_by->staff_fullname,
            "edit" => $this->generate_edit_buttons_hlc($invoice['inv_batchno'], $netTotal, $rmain_bal, $invoice['invoice_number'])*/
        );
    }

    $response = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => $totalRecords,
        "recordsFiltered" => $totalRecords,
        "data" => $data
    );

    echo json_encode($response);
}



public function manage_invoice() {
  
    $data['current_page'] = 'Invoices';

    $data['title'] = 'List Invoices';

    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $data['viewfile'] = "admin/manage_invoice/manage_invoice";
    $this->load->view('admin/layout', $data);

}

public function fetch_invoice_data_hlc() {
    

    // Get parameters for server-side processing
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $branch_id = $this->input->post('branch');
    $conn_id = $this->input->post('connector');
    $hlc_paid_status = $this->input->post('hlc_status');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $disb_month_year = $this->input->post('month');
    $payment_month_hlc = $this->input->post('payment_month_hlc');
    
    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];

    // Fetch data
    $invoices = $this->Hlc_model->get_invoice_data($start_date, $end_date, $conn_id, $branch_id, $limit, $offset, $hlc_paid_status, $city_id, $disb_month_year, $payment_month_hlc, $search);

    // Get total records
    $totalRecords = $this->Hlc_model->count_all_invoices($start_date, $end_date, $conn_id, $branch_id, $hlc_paid_status, $city_id, $disb_month_year, $payment_month_hlc, $search);
    
    // Prepare response
    $data = array();
    $sr_no = $offset + 1;
    foreach ($invoices as $invoice) {
        $invoiceNumber = $invoice['inv_batchno'];

        // Fetch additional data
        $applicant_log = $this->db->select('invoices.inv_batchno, mst_user.user_name, mst_user.id, mst_user.login_code')
            ->from('invoices')
            ->join('mst_user', 'invoices.user_id = mst_user.id')
            ->where(['inv_batchno' => $invoiceNumber])
            ->get()
            ->result_array();
        
            $paid_log = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceNumber])->order_by('payment_date', 'DESC')->get()->result_array();
      
            $invoice_items = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceNumber])->get()->result_array();
    
            // Calculate net pay amount
            $totalCommisionAmt = 0;
            foreach ($invoice_items as $item) {
                $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $item['user_id']])->get()->row();
                $totalCommission = calculateTotalCommission1($this->db, $user_data, $user_data->part_payout, $item['loan_type_id'],$invoiceNumber);
                 if ($user_data->loan_type_id == 4 && $user_data->sanction_amt >= 100000 && $user_data->sanction_amt < 1000000) {
                      $totalCommission = 2000;
                    } 
                $totalCommisionAmt += $totalCommission;
            }
    
            $hlc_data = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $invoice['connector_id']])->get()->row();
             $created_by = $this->db->select('*')->where(['staff_id' => $invoice['created_by']])->from('mst_staff')->get()->row();
            $gstPercentage = empty($hlc_data->gst_no) ? 0 : 18; 
            $gst = $gstPercentage / 100 * $totalCommisionAmt;
            $netPayamt = $totalCommisionAmt;
            
            $invoiceTimestamp = strtotime($invoice['invoice_date']);
            // Define the threshold date (1st October 2024)
            $thresholdDate = strtotime('2024-10-01');
            // Check if the invoice date is on or after 1st October 2024
            if ($invoiceTimestamp >= $thresholdDate) {
                // Apply 2% TDS
                $tdsPer = 2;
                $tds = $netPayamt * 2 / 100;
            } else {
                // Apply 5% TDS
                $tdsPer = 5;
                $tds = $netPayamt * 5 / 100;
            }

           
            $grossTotal = $netPayamt + $gst;
            $netTotal = $grossTotal - $tds;
    
            // Calculate total paid amount and balance
            $totalpayamt = 0;
            foreach ($paid_log as $val) {
                $totalpayamt += $val['pay_amt'];
            }
            $tot_paid_amt = $totalpayamt;
            $rmain_bal = $netTotal - $tot_paid_amt;

      

        // Payment status
        $payment = $this->db->select("*")->where(['invoice_batchno' => $invoiceNumber, 'invoice_type' => 'inv_hlc'])->from('invoice_log')->order_by('add_date', 'DESC')->get()->row();
        $statusP = isset($payment) && isset($payment->status) ? $payment->status : "unpaid";

        // Define the badge color based on payment status
        if ($statusP == "unpaid") {
            $badge_class = "badge bg-danger";
        } elseif ($statusP == "paid") {
            $badge_class = "badge bg-success";
        } elseif ($statusP == "excess paid") {
            $badge_class = "badge bg-warning";
        } elseif ($statusP == "partly paid") {
            $badge_class = "badge bg-info";
        }

        $applicant_names = '';
        foreach ($applicant_log as $sr => $val) {
            $link = ($val['login_code'] === 'PaisaBazaar') 
                ? base_url('admin/pb_user_form/' . $val['id']) 
                : base_url('admin/applicant_form/' . $val['id']);
            
            $applicant_names .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' . $val['user_name'] . '</a><br>';
        }
        
        
        $allowed_staff_ids = [14, 13, 538, 889];
        $session_staff_id = $this->session->userdata('staff_id');
        
        $invoice_date_html = '
            <span class="editable-invoice-date" 
                  data-invoice="' . $invoice['inv_batchno'] . '" 
                  data-current-date="' . $invoice['invoice_date'] . '">
                ' . date('d.m.Y', strtotime($invoice['invoice_date'])) . '
            </span>';
        
        if (in_array($session_staff_id, $allowed_staff_ids)) {
            $invoice_date_html .= '
                <i class="bi bi-pencil-square edit-invoice-date-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Date"
                   data-invoice="' . $invoice['inv_batchno'] . '" 
                   data-current-date="' . $invoice['invoice_date'] . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editInvoiceDateModal">
                </i>';
        }

         $invoice_num_html = '<a href="'.base_url("Invoice_pdf_hlc/generatePDF/{$invoice['inv_batchno']}").'" target="_BLANK">'.$invoice['invoice_number'].'</a>';
        
         if (in_array($session_staff_id, $allowed_staff_ids = [14])) {
            $invoice_num_html .= '
                <i class="bi bi-pencil-square edit-invoice-num-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Number"
                   data-invoice="' . $invoice['inv_batchno'] . '" 
                   data-current-num="' . $invoice['invoice_number'] . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editInvoiceNumModal">
                </i>';
        }


        $data[] = array(
            "sr_no" => $sr_no++,
            "hlc_name" => capitalize_first_three_words($invoice['staff_fullname']),
            "city" => $invoice['hlc_city_name'],
            "applicant" => $applicant_names,
            "inv_number" => $invoice_num_html,
            "net_pay_amt" => formatIndianNumber($netTotal),
            "paid_amt" => formatIndianNumber($tot_paid_amt),
            "tds" => formatIndianNumber($tds),
            "balance" => number_format($rmain_bal, 2),
             "invoice_date" => $invoice_date_html,
            "payment_log" => $this->format_payment_log_hlc(json_encode($paid_log), $invoice['inv_batchno']),
            "created_date" => date('d.m.Y', strtotime($invoice['add_date'])),
            "payment_status" => "<span class='$badge_class'>$statusP</span>",
            "created_by" => $created_by->staff_fullname,
            "edit" => $this->generate_edit_buttons_hlc($invoice['inv_batchno'], $netTotal, $rmain_bal, $invoice['invoice_number'])
        );
    }

    $response = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => $totalRecords,
        "recordsFiltered" => $totalRecords,
        "data" => $data
    );

    echo json_encode($response);
}

private function format_payment_log_hlc($payment_log, $invoice_batchno) {
    $log_entries = json_decode($payment_log, true); // Decode JSON into an array
    if (empty($log_entries)) {
        return "No payment logs available.";
    }

    $formatted_log = '';
    foreach ($log_entries as $entry) {
        // Ensure values are not null
        $payment_date = !empty($entry['payment_date']) ? $entry['payment_date'] : '';
        $pay_amt = !empty($entry['pay_amt']) ? $entry['pay_amt'] : '';
        $bank_details = !empty($entry['bank_details']) ? $entry['bank_details'] : '';
        $remark = !empty($entry['remark']) ? $entry['remark'] : '';
        $payment_id = !empty($entry['id']) ? $entry['id'] : '';

        $formatted_log .= 'Pay Date: ' . date('d.m.Y', strtotime($payment_date)) . '<br>';
        $formatted_log .= 'Pay Amt: ' . $pay_amt . '<br>';
        $formatted_log .= 'Ref No/Cheq No: ' . $bank_details . '<br>';
        $formatted_log .= 'Remark: ' . $remark . '<br>';

        // Show the Edit button only for staff_id = 14
        if ($this->session->userdata('staff_id') == 14 || $this->session->userdata('staff_id') == 13) {
            $formatted_log .= '<a href="javascript:void(0);" 
                class="text-primary edit-payment-log" 
                data-invoice="' . htmlspecialchars($invoice_batchno, ENT_QUOTES, 'UTF-8') . '" 
                data-invoice_no_id="' . htmlspecialchars($payment_id, ENT_QUOTES, 'UTF-8') . '" 
                data-payment_date="' . htmlspecialchars($payment_date, ENT_QUOTES, 'UTF-8') . '" 
                data-pay_amt="' . htmlspecialchars($pay_amt, ENT_QUOTES, 'UTF-8') . '" 
                data-bank_details="' . htmlspecialchars($bank_details, ENT_QUOTES, 'UTF-8') . '" 
                data-remark="' . htmlspecialchars($remark, ENT_QUOTES, 'UTF-8') . '" 
                data-bs-toggle="modal" 
                data-bs-target="#editPaymentModal"
                title="Edit">
                <i class="bi bi-pencil-square"></i>
            </a>';
        }

        $formatted_log .= '<br><br>'; // Add space for readability
    }

    return $formatted_log;
}


private function format_payment_log_hlc_pay_date($payment_log) {
    $log_entries = json_decode($payment_log, true); // Assuming the log is stored as a JSON-encoded string
    if (empty($log_entries)) {
        return "";
    }

    $formatted_log = '';
    foreach ($log_entries as $entry) {
        $formatted_log .= 'Pay Date: ' . date('d.m.Y', strtotime($entry['payment_date'])) . '<br>';
    }

    return $formatted_log;
}

private function generate_edit_buttons_hlc($invoiceNumber, $netTotal, $rmain_bal, $invoiceNumberLabel) {
    $edit_buttons = "<div class='d-flex align-items-center gap-3 action-buttons'>";
    if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13 || $_SESSION['staff_id'] == 1 || $_SESSION['staff_id'] == 538 || $_SESSION['staff_id'] == 889) {
        $edit_buttons .= "<a href='javascript:;' class='text-primary edit-status' data-bs-toggle='tooltip' data-bs-placement='bottom' title='Payment Status' aria-label='Views' onclick='openInvoiceModal(\"$invoiceNumber\",\"$netTotal\",\"$rmain_bal\",\"$invoiceNumberLabel\")'>
        <img src='".base_url()."assets/site_img/payment.png' height='17' width='17'>
        </a>";
    }
    
    if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13) {
        $edit_buttons .= "<a href='javascript:;' class='text-primary' data-bs-toggle='tooltip' data-bs-placement='bottom' title='Delete Payment' aria-label='Views' onclick='DeletePaymentLog(\"$invoiceNumber\")'>
        <img src='".base_url()."assets/site_img/payment_delete.png' height='18' width='18'>
        </a>";
    }
    
    $edit_buttons .= "<a href='".base_url("Invoice_pdf_hlc/generatePDF/$invoiceNumber")."' target='_BLANK' class='text-danger' data-bs-toggle='tooltip' data-bs-placement='bottom' title='View Invoice' aria-label='Views'>
    <i class='bi bi-file-earmark-pdf-fill'></i>
    </a>";
    if ($this->admin_profile->is_right_delete == 'yes') {
        $edit_buttons .= "<a href='javascript:;' class='text-danger delete' data-bs-toggle='tooltip' data-bs-placement='bottom' title='Delete Invoice' aria-label='Delete' data-id='$invoiceNumber' action='delete_invoice_hlc'>
        <i class='bi bi-trash-fill'></i>
        </a>";
    }
    $edit_buttons .= "</div>";
    return $edit_buttons;
}


public function update_payment_log() {
    $invoice_batchno = $this->input->post('invoice_batchno');
    $payment_date = $this->input->post('payment_date');
    $pay_amt = $this->input->post('pay_amt');
    $bank_details = $this->input->post('bank_details');
    $remark = $this->input->post('remark');
    $invoice_id = $this->input->post('invoice_no_id');

    // Validate inputs
    if (empty($invoice_batchno) || empty($payment_date) || empty($pay_amt)) {
        echo json_encode(["status" => "error", "message" => "All fields are required."]);
        return;
    }

    // Prepare data for update
    $data = [
        "payment_date" => $payment_date,
        "pay_amt" => $pay_amt,
        "bank_details" => $bank_details,
        "remark" => $remark
    ];

    // Update database
    $this->db->where('id', $invoice_id);
    $update = $this->db->update('invoice_log', $data);

    if ($update) {
        echo json_encode(["status" => "success"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to update payment log."]);
    }
}



public function update_invoice_date() {
    $invoice_batchno = $this->input->post('invoice_batchno');
    $invoice_date = $this->input->post('invoice_date');

    if (!empty($invoice_batchno) && !empty($invoice_date)) {
        $this->db->where('inv_batchno', $invoice_batchno);
        $updated = $this->db->update('invoices', ['invoice_date' => $invoice_date]);

        if ($updated) {
            echo json_encode(['success' => true, 'message' => 'Invoice date updated successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid input.']);
    }
}


public function update_invoice_number() {
    $invoice_batchno = $this->input->post('invoice_batchno');
    $invoice_num = $this->input->post('invoice_num');

    if (!empty($invoice_batchno) && !empty($invoice_num)) {
        
         // Check if the invoice number already exists (excluding the current batch number)
        $this->db->where('invoice_number', $invoice_num);
        $this->db->where('inv_batchno !=', $invoice_batchno); // Exclude current invoice if updating
        $query = $this->db->get('invoices');

        if ($query->num_rows() > 0) {
            echo json_encode(['success' => false, 'message' => 'Invoice number already exists.']);
            return;
        }
        
        $this->db->where('inv_batchno', $invoice_batchno);
        $updated = $this->db->update('invoices', ['invoice_number' => $invoice_num]);

        if ($updated) {
            echo json_encode(['success' => true, 'message' => 'Invoice number updated successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid input.']);
    }
}


public function invoice_hlc() {

    $invoice_no = $this->input->get('invoice');

    
    $data['invoice_items'] = $this->db
    ->select('*')
    ->from('invoices')
    ->where(['inv_batchno' => $invoice_no])
    ->order_by('id', 'asc')
    ->get()
    ->result_array();

    $firstInvoiceItem = reset($data['invoice_items']);
    $connectorID = isset($firstInvoiceItem['connector_id']) ? $firstInvoiceItem['connector_id'] : null;
    $branchID = isset($firstInvoiceItem['branch_id']) ? $firstInvoiceItem['branch_id'] : null;
    $invoiceDate = isset($firstInvoiceItem['invoice_date']) ? $firstInvoiceItem['invoice_date'] : null;
    $invoiceType = isset($firstInvoiceItem['invoice_type']) ? $firstInvoiceItem['invoice_type'] : null;
    $invoiceNumber = isset($firstInvoiceItem['invoice_number']) ? $firstInvoiceItem['invoice_number'] : null;

    
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['staff_id' => $connectorID, 'staff_type' => 1])->get()->row();
    $data['branch'] = $this->db->select("*")->from('branch')->where(['id' => $branchID])->get()->row();
    $data['invoice_date'] = $invoiceDate;
    $data['invoice_type'] = $invoiceType;
    $data['invoice_num'] = $invoiceNumber;
    $data['invoice_batchno'] = $invoice_no;

   

    $data['current_page'] = 'Invoice';
    $data['viewfile'] = "admin/manage_invoice/invoice_hlc";   
    $this->load->view('admin/layout', $data);


   
}

public function invoice_view_branch() {

    $invoice_no = $this->input->get('invoice');
    
    $data['invoice_items'] = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoice_no])->get()->result_array();

    $firstInvoiceItem = reset($data['invoice_items']);
    $connectorID = isset($firstInvoiceItem['connector_id']) ? $firstInvoiceItem['connector_id'] : null;
    $branchID = isset($firstInvoiceItem['branch_id']) ? $firstInvoiceItem['branch_id'] : null;
    $invoiceDate = isset($firstInvoiceItem['invoice_date']) ? $firstInvoiceItem['invoice_date'] : null;
    $invoiceType = isset($firstInvoiceItem['invoice_type']) ? $firstInvoiceItem['invoice_type'] : null;
    $invoiceNumber = isset($firstInvoiceItem['invoice_number']) ? $firstInvoiceItem['invoice_number'] : null;

    
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['staff_id' => $connectorID, 'staff_type' => 1])->get()->row();
    $data['branch'] = $this->db->select("*")->from('branch')->where(['id' => $branchID, 'active' => 1])->get()->row();
    $data['state'] = $this->db->select("*")->from('mst_state')->where(['id' => $data['branch']->state_id])->get()->row();
    $data['city'] = $this->db->select("*")->from('mst_city')->where(['id' => $data['branch']->city_id])->get()->row();
    $data['invoice_date'] = $invoiceDate;
    $data['invoice_type'] = $invoiceType;
    $data['invoice_num'] = $invoiceNumber;

   

    $data['current_page'] = 'Invoices Branch';
  
    $data['viewfile'] = "admin/manage_invoice_branch/invoice_view_branch";
   
       
    $this->load->view('admin/layout', $data);
   
}

public function invoice_view_sbi() {

    $invoice_no = $this->input->get('invoice');
    
    $data['invoice_items'] = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoice_no])->get()->result_array();

    $firstInvoiceItem = reset($data['invoice_items']);
    $connectorID = isset($firstInvoiceItem['connector_id']) ? $firstInvoiceItem['connector_id'] : null;
    $branchID = isset($firstInvoiceItem['branch_id']) ? $firstInvoiceItem['branch_id'] : null;
    $invoiceDate = isset($firstInvoiceItem['invoice_date']) ? $firstInvoiceItem['invoice_date'] : null;
    $invoiceType = isset($firstInvoiceItem['invoice_type']) ? $firstInvoiceItem['invoice_type'] : null;
    $invoiceNumber = isset($firstInvoiceItem['invoice_number']) ? $firstInvoiceItem['invoice_number'] : null;

    
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['staff_id' => $connectorID, 'staff_type' => 1])->get()->row();
    $data['branch'] = $this->db->select("*")->from('branch')->where(['id' => $branchID, 'active' => 1])->get()->row();
    $data['state'] = $this->db->select("*")->from('mst_state')->where(['id' => $data['branch']->state_id])->get()->row();
    $data['city'] = $this->db->select("*")->from('mst_city')->where(['id' => $data['branch']->city_id])->get()->row();
    $data['invoice_date'] = $invoiceDate;
    $data['invoice_type'] = $invoiceType;
    $data['invoice_num'] = $invoiceNumber;

   

    $data['current_page'] = 'Invoice SBI';
  
    $data['viewfile'] = "admin/manage_invoice/invoice_sbi";
   
       
    $this->load->view('admin/layout', $data);
   
}

/*public function manage_invoice_sbi() {
    $perPage = $this->input->post('per_page') ? $this->input->post('per_page') : 20;
    /*$where = ' and staff_type=1';
  
    $this->load->library('pagination');

    $config['base_url'] = base_url() . 'admin/manage_invoice_sbi';

    $config['total_rows'] = $this->ccm->get_all_count_invoice('invoices', 'add_date', 'desc', '');

    
    $config['per_page'] = $perPage;

    $config['page_query_string'] = TRUE;

    $config['reuse_query_string'] = TRUE;

    $config['full_tag_open'] = '<ul class="pagination pagination-split justify-content-end">';

    $config['full_tag_close'] = '</ul>';

    $config['nue_tag_open'] = "<li class = 'page-item'>";

    $config['nue_tag_close'] = "</li>";

    $config['cur_tag_open'] = " <li class = 'page-item active'> <a class = 'page-link '>";

    $config['cur_tag_close'] = "</a></li>";

    $config['attributes'] = array('class' => 'page-link');

    $config['first_tag_open'] = '<div class="first">';

    $config['first_tag_close'] = '</div>';

    $config['last_tag_open'] = '<div class="last">';

    $config['last_tag_close'] = '</div>';

    $config['next_tag_open'] = '<div class="next">';

    $config['next_tag_close'] = '</div>';

    $config['prev_tag_open'] = '<div class="prev">';

    $config['prev_tag_close'] = '</div>';


    $this->pagination->initialize($config);

    $data['pagination'] = $this->pagination->create_links();*/

  /*  $data['current_page'] = 'Invoices SBI';

    $data['title'] = 'List Invoices';

    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $inv_type = $this->input->post('inv_type');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch');   
    $city_id = $this->input->post('city_id');   
    $disb_month_year = $this->input->post('month');  
    $sbi_paid_status = $this->input->post('sbi_status');
    
    $offset = $this->input->get('per_page');   
    
    $data['inv'] = $this->ccm->get_invoice_data_sbi($start_date, $end_date, $inv_type,$conn_id,$branch_id,'','',$sbi_paid_status,$city_id,$disb_month_year);

//  print("<pre>".print_r( $data['leads'],true)."</pre>"); die;

    $data['viewfile'] = "admin/manage_invoice_sbi/manage_invoice_sbi";

    $this->load->view('admin/layout', $data);

}*/

public function manage_invoice_sbi() {
        $data['title'] = 'List Invoices';
        $data['current_page'] = 'Invoices SBI';
        // Load the required data for dropdowns
        $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
        $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
        $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

        $data['viewfile'] = "admin/manage_invoice_sbi/manage_invoice_sbi";
        $this->load->view('admin/layout', $data); // Load the view
    }

   
    public function fetch_invoice_data_rbo() {
        
    $this->load->model('RBOInvoice_model'); 
     // DataTables parameters
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $order = $this->input->post("order");
    $search = $this->input->post("search")['value'];

    // Filter parameters from the form
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $branch = $this->input->post('branch');
    $connector = $this->input->post('connector');
    $sbi_paid_status = $this->input->post('sbi_status');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $month = $this->input->post('month');
    $payment_amount = $this->input->post('payment_amount');
    $payment_date = $this->input->post('payment_date');
      $invoice_month = $this->input->post('invoice_month');
    
  

    // Fetch records from model
    $invoices = $this->RBOInvoice_model->get_filtered_invoices($start, $length, $order, $search, $start_date, $end_date, $branch, $connector, $sbi_paid_status, $state_id, $city_id, $month, $payment_amount ,$payment_date, $invoice_month);
    $totalInvoices = $this->RBOInvoice_model->get_total_invoices($search, $start_date, $end_date, $branch, $connector, $sbi_paid_status, $state_id, $city_id, $month, $payment_amount ,$payment_date, $invoice_month);


    // Prepare the data for JSON response
    $data = [];
    foreach ($invoices as $index => $invoice) {
        // Perform Calculations
        $totalLoanAmt = 0;
        $sumTotalCommiCol = 0;
        $sumTotalten10_commiCol = 0;
        $sum_fix_commi_rr = 0;
        $sum10_rr_Col = 0;

        // Fetch related invoice items to perform detailed calculations
        $invoiceItems = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoice->inv_batchno])->get()->result_array();
        
        $applicantLog = $this->db->select('invoices.*, mst_user.user_name, mst_user.id as link_user_id, mst_user.login_code, mst_loan_type.name as loan_type_name')
                        ->from('invoices')
                        ->join('mst_user', 'invoices.user_id = mst_user.id') // Join with mst_user
                        ->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id') // Join with mst_loan_type
                        ->where(['invoices.inv_batchno' => $invoice->inv_batchno])
                        ->order_by('invoices.id', 'asc')
                        ->get()
                        ->result_array();
                    
                    $formattedApplicants = '';
                    foreach ($applicantLog as $sr => $val) {
                        // Create a link based on the login_code
                        $link = ($val['login_code'] === 'PaisaBazaar') 
                            ? base_url('admin/pb_user_form/' . $val['link_user_id']) 
                            : base_url('admin/applicant_form/' . $val['link_user_id']);
                        
                        // Add the applicant's name as a clickable link
                        $formattedApplicants .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' . $val['user_name'] . '</a> (' . $val['loan_type_name'] . ') ';
                        
                        // Add delete option for staff_id = 14
                        if (isset($_SESSION['staff_id']) && in_array($_SESSION['staff_id'], [13, 14])) {
                            $formattedApplicants .= '<i class="bi bi-trash text-danger" style="cursor: pointer;" onclick="deleteApplicantRBOInvoice(' . $val['id'] . ', ' . $val['user_id'] . ', \'' . addslashes($val['user_name']) . '\')"></i>';
                        }
                    
                        $formattedApplicants .= '<br>';
                    }

       
        
        foreach ($invoiceItems as $item) {
            $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $item['user_id']])->get()->row();
            $loanAmount = $user_data->loan_type_id == 5 ? $user_data->rinnraksha_amt : $user_data->sanction_amt;
            $totalLoanAmt += $loanAmount;
         
            if ($user_data->loan_type_id == 5) {
                $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $user_data->id, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
                
                if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                    $rr_sanction_amt = $this->db->select("*")->where(['id' => @$rr_aact->id])->from('mst_user')->get()->row();
                    $sanctionAmt = $rr_sanction_amt->sanction_amt ?? 0;

                    // Calculate commission based on different conditions
                    if ($sanctionAmt == 5000000) {
                        // If the sanction amount is exactly 50 lakh, set commission to 4000
                        $commission = 4000;
                    } elseif ($sanctionAmt >= 100000 && $sanctionAmt < 5000000) {
                        $commission = 4000;
                    } elseif ($sanctionAmt > 5000000 && $sanctionAmt < 10000000) {
                        $commission = 5000;
                    } elseif ($sanctionAmt >= 10000000) {
                        $commission = 6000;
                    } else {
                        $commission = 0;
                    }
                    $sum_fix_commi_rr += $commission;

                    $ten10_rr_comm = $commission * 10 / 100;
                    $sum10_rr_Col += round($ten10_rr_comm);

                    $rr_commision_row = $commission - ($ten10_rr_comm);
                }
            }

            // General Commission Calculations
            $total_commi_row = $loanAmount * $user_data->sbi_commi / 100;
            $sumTotalCommiCol += $total_commi_row;
            $ten10_commi_row = $total_commi_row * 10 / 100;
            $sumTotalten10_commiCol += $ten10_commi_row;
        }

        // Net Payable Amount Calculation
        $ninety90_col_sum = round($sumTotalCommiCol + $sum_fix_commi_rr) - round($sumTotalten10_commiCol + $sum10_rr_Col);
        $netPayamt = $ninety90_col_sum + $ninety90_col_sum * 18 / 100;  // Including tax

        // Calculate Total Paid Amount and Remaining Balance
        $invoiceLogs = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoice->inv_batchno])->get()->result_array();
        $totalpayamt = 0;
        $totalTDSamt = 0;

        foreach ($invoiceLogs as $log) {
            $totalpayamt += $log['pay_amt'];
            $totalTDSamt += $log['tds_amt'];
        }

        $tot_paid_amt = $totalpayamt;
        $TDS_amt = $totalTDSamt;
        $rmain_bal = $netPayamt - $TDS_amt - $tot_paid_amt;

        // Determine payment status and corresponding badge class
        $payment = $this->db->select("*")->where(['invoice_batchno' => $invoice->inv_batchno, 'invoice_type' => 'inv_sbi'])->from('invoice_log')->order_by('add_date', 'DESC')->get()->row();
        $statusP = isset($payment) && isset($payment->status) ? $payment->status : "unpaid";
        $badge_class = $this->get_badge_class($statusP);
        $created_by = $this->db->select("*")->where(['staff_id' => $invoice->created_by])->from('mst_staff')->get()->row();

        $allowed_staff_ids = [14, 13, 538, 889];
        $session_staff_id = $this->session->userdata('staff_id');
        
        $invoice_date_html = '
            <span class="editable-invoice-date" 
                  data-invoice="' . $invoice->inv_batchno . '" 
                  data-current-date="' . $invoice->invoice_date . '">
                ' . date('d.m.Y', strtotime($invoice->invoice_date)) . '
            </span>';
        
        if (in_array($session_staff_id, $allowed_staff_ids)) {
            $invoice_date_html .= '
                <i class="bi bi-pencil-square edit-rboinvoice-date-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Date"
                   data-invoice="' . $invoice->inv_batchno . '" 
                   data-current-date="' . $invoice->invoice_date . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editRboInvoiceDateModal">
                </i>';
        }
        
        
        $invoice_num_html = '<a target="_BLANK" href="' . base_url() . 'Invoice_pdf_sbi/generatePDF/' . $invoice->inv_batchno . '">' . $invoice->invoice_number . '</a>';
         
        if (in_array($session_staff_id, $allowed_staff_ids = [14])) {
            $invoice_num_html .= '
                <i class="bi bi-pencil-square edit-rboinvoice-num-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Number"
                   data-invoice="' . $invoice->inv_batchno . '" 
                   data-current-num="' . $invoice->invoice_number . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editRboInvoiceNumModal">
                </i>';
        }
        
        $invoice_num_html .= '<br><a target="_BLANK" href="' . base_url() . 'Invoice_pdf_rbo/generatePDF/' . $invoice->inv_batchno . '">Format-2</a><br><a target="_BLANK" href="' . base_url() . 'Invoice_pdf_sbi/generatePDF_Pointforamat/' . $invoice->inv_batchno . '">Point Format-3</a>'; 


        // Prepare data for DataTables
        $data[] = [
            "sr_no" => $index + 1 + $start,
            "city_name" => $invoice->city_name,
            "rbo_name" => $invoice->rbo_name,
            "applicant_name" => $formattedApplicants,
            "loan_list" => '<a target="_BLANK" href="' . base_url() . 'admin/rbo_loan_list/' . $invoice->inv_batchno . '">View</a><br><a target="_BLANK" href="' . base_url() . 'Rbo_excel/export_excel_rbo_invoice_list/' . $invoice->inv_batchno . '">Download Excel</a>',
            "invoice_number" =>  $invoice_num_html,
            "bill_amount" => number_format($netPayamt, 2),
            "subtotal" => number_format($ninety90_col_sum, 2),
            "received_amount" => number_format($tot_paid_amt, 2),
            "balance" => number_format($rmain_bal, 2),
            "invoice_date" => $invoice_date_html,
            "payment_log" => $this->format_payment_log_rbo($invoiceLogs),
            "created_date" => date('d.m.Y', strtotime($invoice->add_date)),
            "payment_status" => '<span class="' . $badge_class . '">' . ucfirst($statusP) . '</span>',
            "created_by" => capitalize_first_three_words($created_by->staff_fullname),
            "edit_options" => $this->generate_edit_buttons_rbo($invoice->inv_batchno, $netPayamt, $rmain_bal, $invoice->invoice_number)
        ];
    }

    // Output to JSON format
    $output = [
        "draw" => $draw,
        "recordsTotal" => $totalInvoices,
        "recordsFiltered" => $totalInvoices,
        "data" => $data
    ];
    echo json_encode($output);
}


    // Helper method to format payment logs
    private function format_payment_log_rbo($paymentLogs) {
        $formattedLogs = '';
        foreach ($paymentLogs as $log) {
            $formattedLogs .= 'Pay Date: ' . date('d.m.Y', strtotime($log['payment_date'])) . '<br>';
            $formattedLogs .= 'Pay Amt: ' . number_format($log['pay_amt'], 2) . '<br>';
            $formattedLogs .= 'TDS Amt: ' . number_format($log['tds_amt'], 2) . '<br>';
            $formattedLogs .= 'Ref No/Cheq No: ' . $log['bank_details'] . '<br>';
            $formattedLogs .= 'Remark: ' . $log['remark'] . '<br><br>';
        }
        return $formattedLogs;
    }

    // Helper method to get the badge class based on payment status
    private function get_badge_class($status) {
        switch ($status) {
            case 'paid':
                return 'badge bg-success';
            case 'unpaid':
                return 'badge bg-danger';
            case 'partly paid':
                return 'badge bg-info';
            case 'excess paid':
                return 'badge bg-warning';
            default:
                return 'badge bg-secondary';
        }
    }

    // Helper method to generate edit buttons for each row
    private function generate_edit_buttons_rbo($invoiceNumber, $netPayAmt, $remainingBal, $invoiceNum) {
        $buttons = '<div class="d-flex align-items-center gap-3 fs-6">';
        // Edit payment status button
         if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13 || $_SESSION['staff_id'] == 1 || $_SESSION['staff_id'] == 538 || $_SESSION['staff_id'] == 889) {
            $buttons .= '<a href="javascript:;" class="text-primary edit-status" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Payment Status" aria-label="Views" onclick="openInvoiceModal(\'' . $invoiceNumber . '\',\'' . $netPayAmt . '\',\'' . $remainingBal . '\',\'' . $invoiceNum . '\')">';
            $buttons .= '<img src="' . base_url() . 'assets/site_img/payment.png" height="17" width="17"></a>';
         }
        // Delete payment log button
        if ($_SESSION['staff_id'] == 14) { 
        $buttons .= '<a href="javascript:;" class="text-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete Payment" aria-label="Views" onclick="DeletePaymentLog(\'' . $invoiceNumber . '\')">';
        $buttons .= '<img src="' . base_url() . 'assets/site_img/payment_delete.png" height="18" width="18"></a>';
        }
        // Print invoice button
        $buttons .= '<a href="' . base_url() . 'Invoice_pdf_sbi/generatePDF/' . $invoiceNumber . '" target="_BLANK" class="text-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="View Invoice" aria-label="Views">';
        $buttons .= '<i class="bi bi-printer"></i></a>';

        // Delete invoice button (conditionally displayed)
        if ($this->admin_profile->is_right_delete == 'yes') {
            $buttons .= '<a href="javascript:;" class="text-danger delete" data-id="' . $invoiceNumber . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_invoice_sbi">';
            $buttons .= '<i class="bi bi-trash-fill"></i></a>';
        }

        $buttons .= '</div>';
        return $buttons;
    }
    

public function rbo_loan_list($inv_batch) {
    $data['current_page'] = 'Invoices SBI';
    $data['title'] = 'RBO Loan List';
    
    // Fetching the data
    $invoices = $this->ccm->get_invoice_rbo_list($inv_batch);
    
    // Group and process data further before passing it to the view:
    $grouped_invoices = [];
    foreach ($invoices as $invoice) {
        // Determine the loan amount based on loan_type_id
        $loan_amount = $invoice['loan_type_id'] == 5 ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];
        
        // Calculate commission amounts and GST
        $commission_rate = floatval($invoice['sbi_commi']) / 100;
        $amt_100 = $loan_amount * $commission_rate;
        $amt_0_90 = $amt_100 * 0.90;
        $amt_0_10 = $amt_100 * 0.10;
        $gst_amt = $amt_0_90 * 0.18; // Assuming GST is 18%
        $total_amt = $amt_100 + $gst_amt;

        // Add to grouped invoices
        if (!isset($grouped_invoices[$invoice['branch_cnf']])) {
            $grouped_invoices[$invoice['branch_cnf']] = [
                'invoices' => [],
                'totals' => [
                    '100_amt' => 0,
                    '0_90_amt' => 0,
                    '0_10_amt' => 0,
                    'gst_amt' => 0,
                    'total_amt' => 0,
                ]
            ];
        }

        // Add the current invoice data
        $grouped_invoices[$invoice['branch_cnf']]['invoices'][] = array_merge($invoice, [
            'loan_amount' => $loan_amount,
            '100_amt' => $amt_100,
            '0_90_amt' => $amt_0_90,
            '0_10_amt' => $amt_0_10,
            'gst_amt' => $gst_amt,
            'total_amt' => $total_amt,
        ]);

        // Accumulate totals
        $grouped_invoices[$invoice['branch_cnf']]['totals']['100_amt'] += $amt_100;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['0_90_amt'] += $amt_0_90;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['0_10_amt'] += $amt_0_10;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['gst_amt'] += $gst_amt;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['total_amt'] += $total_amt;

        // If loan_type_id is 5 (Rinnraksha), calculate and add RR Commission totals
        if ($invoice['loan_type_id'] == 5) {
            $rr_commission = 0;
            $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $invoice['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
            if ($rr_main_account->sanction_amt == 5000000) {
                // If the sanction amount is exactly 50 lakh, set commission to 4000
                $rr_commission = 4000;
            } elseif ($rr_main_account->sanction_amt < 5000000) {
                $rr_commission = 4000;
            } elseif ($rr_main_account->sanction_amt >= 5000000 && $rr_main_account->sanction_amt < 10000000) {
                $rr_commission = 5000;
            } elseif ($rr_main_account->sanction_amt >= 10000000) {
                $rr_commission = 6000;
            }

            // 90% and 10% calculations for RR Commission
            $rr_commission_90 = $rr_commission * 0.90;
            $rr_commission_10 = $rr_commission * 0.10;
            $rr_gst_amt = $rr_commission_90 * 0.18; // Assuming GST is 18%
            $rr_total_amt = $rr_commission_90 + $rr_gst_amt;

            // Add RR Commission to totals
            $grouped_invoices[$invoice['branch_cnf']]['totals']['100_amt'] += $rr_commission;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['0_90_amt'] += $rr_commission_90;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['0_10_amt'] += $rr_commission_10;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['gst_amt'] += $rr_gst_amt;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['total_amt'] += $rr_total_amt;
        }
    }
    
    $data['invoice_batch'] = $inv_batch;
    $data['invoices'] = $grouped_invoices;
    $data['viewfile'] = "admin/manage_invoice_sbi/rbo_loan_list";
    $this->load->view('admin/layout', $data);
}   

/*public function rbo_loan_list($inv_batch) {
    $data['current_page'] = 'Invoices SBI';
    $data['title'] = 'RBO Loan List';
    
    // Fetching the data
    $invoices = $this->ccm->get_invoice_rbo_list($inv_batch);

    // Get the is_tenper_hold flag for this batch
    $first_invoice_no = $this->db->select("is_tenper_hold")->from('invoices')->where(['inv_batchno' => $inv_batch])->get()->row();
    $is_tenper_hold = $first_invoice_no->is_tenper_hold;

    // Group and process data further before passing it to the view:
    $grouped_invoices = [];
    foreach ($invoices as $invoice) {
        // Determine the loan amount based on loan_type_id
        $loan_amount = $invoice['loan_type_id'] == 5 ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];
        
        // Calculate commission amounts and GST
        $commission_rate = floatval($invoice['commission_amt']) / 100;
        $amt_100 = $loan_amount * $commission_rate;
        $amt_0_90 = $amt_100 * 0.90;
        $amt_0_10 = ($is_tenper_hold == 'Yes') ? $amt_100 * 0.10 : 0;  // Calculate only if 10% hold is 'Yes'
        $gst_amt = $amt_0_90 * 0.18; // Assuming GST is 18%
        $total_amt = $amt_100 + $gst_amt;

        // Add to grouped invoices
        if (!isset($grouped_invoices[$invoice['branch_cnf']])) {
            $grouped_invoices[$invoice['branch_cnf']] = [
                'invoices' => [],
                'totals' => [
                    '100_amt' => 0,
                    '0_90_amt' => 0,
                    '0_10_amt' => 0,
                    'gst_amt' => 0,
                    'total_amt' => 0,
                ]
            ];
        }

        // Add the current invoice data
        $grouped_invoices[$invoice['branch_cnf']]['invoices'][] = array_merge($invoice, [
            'loan_amount' => $loan_amount,
            '100_amt' => $amt_100,
            '0_90_amt' => $amt_0_90,
            '0_10_amt' => $amt_0_10,
            'gst_amt' => $gst_amt,
            'total_amt' => $total_amt,
        ]);

        // Accumulate totals
        $grouped_invoices[$invoice['branch_cnf']]['totals']['100_amt'] += $amt_100;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['0_90_amt'] += $amt_0_90;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['0_10_amt'] += $amt_0_10;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['gst_amt'] += $gst_amt;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['total_amt'] += $total_amt;

        // RR Commission logic (if loan_type_id is 5, i.e., Rinnraksha)
        if ($invoice['loan_type_id'] == 5) {
            $rr_commission = 0;
            $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $invoice['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
            
            if ($rr_main_account->sanction_amt < 5000000) {
                $rr_commission = 4000;
            } elseif ($rr_main_account->sanction_amt >= 5000000 && $rr_main_account->sanction_amt < 10000000) {
                $rr_commission = 5000;
            } elseif ($rr_main_account->sanction_amt >= 10000000) {
                $rr_commission = 6000;
            }

            // 90% and 10% calculations for RR Commission
            $rr_commission_90 = $rr_commission * 0.90;
            $rr_commission_10 = $rr_commission * 0.10;
            $rr_gst_amt = $rr_commission_90 * 0.18; // Assuming GST is 18%
            $rr_total_amt = $rr_commission_90 + $rr_gst_amt;

            // Add RR Commission to totals
            $grouped_invoices[$invoice['branch_cnf']]['totals']['100_amt'] += $rr_commission;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['0_90_amt'] += $rr_commission_90;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['0_10_amt'] += $rr_commission_10;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['gst_amt'] += $rr_gst_amt;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['total_amt'] += $rr_total_amt;

            // Add RR Commission row
            $grouped_invoices[$invoice['branch_cnf']]['invoices'][] = [
                'is_rr_commission' => true,
                'user_name' => $invoice['user_name'],
                'branch_name' => $invoice['branch_name'],
                'rr_cbs_acct_no' => $invoice['rr_cbs_acct_no'],
                'commission' => $rr_commission,
                'commission_90' => $rr_commission_90,
                'commission_10' => $rr_commission_10,
                'gst_amt' => $rr_gst_amt,
                'total_commission' => $rr_total_amt,
            ];
        }
    }

    // Pass the data to the view
    $data['invoice_batch'] = $inv_batch;
    $data['invoices'] = $grouped_invoices;
    $data['viewfile'] = "admin/manage_invoice_sbi/rbo_loan_list";
    $this->load->view('admin/layout', $data);
}

*/


public function received_invoice_sbi() {
    

    $data['current_page'] = 'Recevied Invoice SBI';

    $data['title'] = 'List Invoices';

    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();

    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $branch_id = $this->input->post('branch');   
     
    
    $data['inv_rece'] = $this->ccm->get_received_invoice_sbi($start_date, $end_date,$branch_id);

//       print("<pre>".print_r( $data['leads'],true)."</pre>"); die;

    $data['viewfile'] = "admin/manage_invoice_sbi/total_sbi_received";

    $this->load->view('admin/layout', $data);

}

public function paid_invoice_hlc() {
    

    $data['current_page'] = 'Paid Invoice HLC';

    $data['title'] = 'List Invoices';

    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();

    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
   
    $connector_id = $this->input->post('connector');   
     
    
    $data['inv_paid'] = $this->ccm->get_paid_invoice_hlc($start_date, $end_date,$connector_id);

//       print("<pre>".print_r( $data['leads'],true)."</pre>"); die;

    $data['viewfile'] = "admin/manage_invoice/paid_invoice_hlc";

    $this->load->view('admin/layout', $data);

}


public function partner_wise_business() {
    

    $data['current_page'] = 'Partner Business';
    $data['title'] = 'Partner Business';
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();


    $data['viewfile'] = "admin/manage_connectors/partener_business_report.php";
    $this->load->view('admin/layout', $data);

}

public function fetch_partner_business() {
    $year = $this->input->post('year');
    $connector_id = $this->input->post('connector');

    $limit = $this->input->post('length');
    $offset = $this->input->post('start');
    $search = $this->input->post('search')['value'];
    $order = $this->input->post('order');
    $column_order = $this->input->post('columns')[$order[0]['column']]['data'];
    $dir = $order[0]['dir'];

    $total_data = $this->Hlc_model->count_all_partner_business();
    $total_filtered = $this->Hlc_model->count_filtered_partner_business($search, $year, $connector_id);
    $report_data = $this->Hlc_model->get_partner_business_data($search, $year, $connector_id, $limit, $offset, $column_order, $dir);

    log_message('debug', 'Report Data: ' . print_r($report_data, true));

    $data = array();
    $sr_no = $offset + 1;
    $months = [
        'apr_' . $year, 'may_' . $year, 'jun_' . $year, 'jul_' . $year,
        'aug_' . $year, 'sep_' . $year, 'oct_' . $year, 'nov_' . $year,
        'dec_' . $year, 'jan_' . ($year + 1), 'feb_' . ($year + 1), 'mar_' . ($year + 1)
    ];

    $totals = [
        'login_case_total' => 0,
        'apr' => 0,
        'may' => 0,
        'jun' => 0,
        'jul' => 0,
        'aug' => 0,
        'sep' => 0,
        'oct' => 0,
        'nov' => 0,
        'dec' => 0,
        'jan' => 0,
        'feb' => 0,
        'mar' => 0,
        'total' => 0 // Added total calculation
    ];

    foreach ($report_data as $row) {
        $nestedData = [];
        $nestedData['sr_no'] = $sr_no++;
        $nestedData['connector_name'] = $row['connector_name'];
        $nestedData['city_name'] = $row['city_name'];
        $nestedData['login_case_total'] = $row['login_case_total'] ?? 0;

        $totals['login_case_total'] += $row['login_case_total'] ?? 0;

        $row_total = $nestedData['login_case_total']; // Start with login_case_total
        foreach ($months as $month) {
            $month_short = strtolower(explode('_', $month)[0]);
            $nestedData[$month] = $row[$month] ?? 0; // Safely handle missing keys
            $row_total += $row[$month] ?? 0; // Add monthly data to row total
            $totals[$month_short] += $row[$month] ?? 0;
        }

        $nestedData['total'] = $row_total; // Add total for the row
        $totals['total'] += $row_total; // Add to grand total

        $data[] = $nestedData;
    }

    $json_data = array(
        "draw" => intval($this->input->post('draw')),
        "recordsTotal" => intval($total_data),
        "recordsFiltered" => intval($total_filtered),
        "data" => $data,
        "totals" => $totals // Include totals in the response
    );

    echo json_encode($json_data);
}




public function manage_branch() {
    $staff_type = $this->session->userdata('staff_type');
    if ($staff_type == 0) {
        $data['current_page'] = 'Branch';
        $data['title'] = 'Branch Report';
        $data['viewfile'] = "admin/manage_branch/manage_branch";
        $this->load->view('admin/layout', $data);
    } else {
        redirect('admin/manage_users');
    }
}

public function get_branches() {
    $requestData = $_REQUEST;
    
    $columns = [
        0 => 'id',
        1 => 'branch_name',
        2 => 'branch_code',
        3 => 'c_name',
        4 => 'city_name',
        5 => 'state_name',
        6 => 'rbo_name', // Added column for RBO name
        7 => 'racpc_name', // Added column for RACPC name
        8 => 'action'
    ];

    // Fetch total records without any filtering
    $totalData = $this->db->count_all('branch');

    // Fetch filtered data
     $this->db->select('b.id, b.branch_name, b.branch_code, b.rbo, b.racpc, s.state_name, c.city_name, ci.c_name, r.rbo_name, ra.racpc_name'); // Include racpc_name
    $this->db->from('branch b');
    $this->db->join('mst_state s', 'b.state_id = s.id', 'left');
    $this->db->join('mst_city c', 'b.city_id = c.id', 'left');
    $this->db->join('mst_circle ci', 'b.circle_id = ci.id', 'left');
    $this->db->join('mst_rbo r', 'b.rbo_id = r.id', 'left'); // Join with mst_rbo
    $this->db->join('mst_racpc ra', 'b.racpc_id = ra.id', 'left'); // Join with mst_racpc for racpc_name

    if (!empty($requestData['search']['value'])) {
        $this->db->group_start();
        $this->db->like('b.branch_name', $requestData['search']['value']);
        $this->db->or_like('s.state_name', $requestData['search']['value']);
        $this->db->or_like('c.city_name', $requestData['search']['value']);
        $this->db->or_like('b.branch_code', $requestData['search']['value']);
        $this->db->or_like('ci.c_name', $requestData['search']['value']);
        $this->db->or_like('r.rbo_name', $requestData['search']['value']);
        $this->db->or_like('ra.racpc_name', $requestData['search']['value']);
        $this->db->group_end();
    }

    $totalFiltered = $this->db->get()->num_rows();

    $this->db->select('b.id, b.branch_name, b.branch_code, b.rbo, b.racpc, s.state_name, c.city_name, ci.c_name, r.rbo_name, ra.racpc_name'); // Include racpc_name
    $this->db->from('branch b');
    $this->db->join('mst_state s', 'b.state_id = s.id', 'left');
    $this->db->join('mst_city c', 'b.city_id = c.id', 'left');
    $this->db->join('mst_circle ci', 'b.circle_id = ci.id', 'left');
    $this->db->join('mst_rbo r', 'b.rbo_id = r.id', 'left'); // Join with mst_rbo
    $this->db->join('mst_racpc ra', 'b.racpc_id = ra.id', 'left'); // Join with mst_racpc for racpc_name

    if (!empty($requestData['search']['value'])) {
        $this->db->group_start();
        $this->db->like('b.branch_name', $requestData['search']['value']);
        $this->db->or_like('s.state_name', $requestData['search']['value']);
        $this->db->or_like('c.city_name', $requestData['search']['value']);
        $this->db->or_like('b.branch_code', $requestData['search']['value']);
        $this->db->or_like('ci.c_name', $requestData['search']['value']);
        $this->db->or_like('r.rbo_name', $requestData['search']['value']);
        $this->db->or_like('ra.racpc_name', $requestData['search']['value']);
        $this->db->group_end();
    }

    // Handle the case where length is set to -1 (i.e., "All")
    if ($requestData['length'] != -1) {
        $this->db->limit($requestData['length'], $requestData['start']);
    }

    $query = $this->db->get();

    $data = [];
    foreach ($query->result_array() as $key => $row) {
        $nestedData = [];
        $nestedData[] = $row['id']; // Sr.No
        $nestedData[] = $row['branch_name'];
        $nestedData[] = $row['branch_code'];
        $nestedData[] = $row['c_name'];
        $nestedData[] = $row['city_name'];
        $nestedData[] = $row['state_name'];
        $nestedData[] = $row['rbo_name']; // RBO name
        $nestedData[] = $row['racpc_name']; // RACPC name
        $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">
                            <a href="' . base_url('admin/branch_form/' . $row['id']) . '" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>
                            ' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_branch"><i class="bi bi-trash-fill"></i></a>' : '') . '
                         </div>';

        $data[] = $nestedData;
    }

    $json_data = [
        "draw"            => intval($requestData['draw']),
        "recordsTotal"    => intval($totalData),
        "recordsFiltered" => intval($totalFiltered),
        "data"            => $data
    ];

    echo json_encode($json_data);
}




public function branch_form($id = '') {
     

    $data['current_page'] = 'Branch';
     $data['circle'] = $this->db->select("*")->from('mst_circle')->where('active', 1)->get()->result_array();
     $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
     
    if ($id != '') {

        $data['title'] = 'Edit Branch';

        $data['branch'] = $this->ccm->get_single_row('branch', array('id' => $id));

    } else {

        $data['title'] = 'Add Branch';

    }

    $data['viewfile'] = 'admin/manage_branch/branch_form';

    $this->load->view('admin/layout', $data);

}


public function submit_branch() {





    if ($_POST) {



//            $user_image = '';

//            if ($_FILES) {

//                $config['upload_path'] = realpath('./assets/uploads/Connectors/');

//                $config['allowed_types'] = '*';

//                $image1 = date('dmYhis') . '_' . rand(0, 999999) . "_" . preg_replace('/\s+/', '-', $_FILES['e_image']['name']);

//                $config['file_name'] = $image1;

//                $this->upload->initialize($config);

//                if (!$this->upload->do_upload('e_image')) {

//                    $messge = $this->upload->display_errors();

//                    if ($messge != '<p>You did not select a file to upload.</p>') {

//                        $data = array('type' => 'error', 'message' => $messge, 'success' => 0);

//                        echo json_encode($data);

//                        exit;

//                    }

//                } else {

//                    $user_image = $image1;

//                }

//                unset($this->upload);

//            }

        $data = array(

            'branch_name' => $this->input->post('branch_name'),
            'circle_id' => $this->input->post('circle_id'),
            'branch_code' => $this->input->post('branch_code'),
            'branch_address' => $this->input->post('branch_address'),
            'state_id' => $this->input->post('state_id'),
            'city_id' => $this->input->post('city_id'),
            'rbo' => $this->input->post('rbo'),
            'racpc' => $this->input->post('racpc'),
            'racpc_id' => $this->input->post('racpc_id'),
            'rbo_id' => $this->input->post('rbo_id')

//                'e_image' => $user_image,

        );

        $data = array_filter($data);

        $data = $this->security->xss_clean($data);

        $e_id = 0;

        if ($_POST['id'] != '') {

            $e_id = $_POST['id'];

            $this->db->where('id', $_POST['id']);

            $res = $this->db->update('branch', $data);

            $msg = 'Updated Successfully..!';

        } else {

            if ($this->ccm->get_row_count('branch', array('branch_code' => $this->input->post('branch_code'))) != 0) {

                $data = array('type' => 'error', 'message' => 'Branch already exists Please change it...!', 'success' => 0);

                echo json_encode($data);

                exit;

            }

            $res = $this->db->insert('branch', $data);

            $msg = 'Added Successfully..!';

            $e_id = $this->db->insert_id();

        }

       

        if ($res == 1) {

            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);

            $this->session->set_flashdata('response_message', $message);

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Connectors Didnt Added, Please try after some time..!');

        }

    } else {

        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');

    }

    echo json_encode($message);

}

// Controller function to handle AJAX request for RBOs and RACPCs based on city_id
public function get_rbo_racpc() {
    $cityId = $this->input->post('city_id');

    if (!empty($cityId)) {
        // Fetch RBOs and RACPCs based on city_id
        $this->db->select('id, rbo_name');
        $this->db->where('city_id', $cityId);
        $rboQuery = $this->db->get('mst_rbo');
        $rboData = $rboQuery->result_array();

        $this->db->select('id, racpc_name');
        $this->db->where('city_id', $cityId);
        $racpcQuery = $this->db->get('mst_racpc');
        $racpcData = $racpcQuery->result_array();

        $response = [
            'rbo' => $rboData,
            'racpc' => $racpcData
        ];

        header('Content-Type: application/json');
        echo json_encode($response);
    } else {
        header('Content-Type: application/json');
        echo json_encode(['error' => 'Invalid city_id provided']);
    }
}


public function manage_rbo() {
    $staff_type = $this->session->userdata('staff_type');
    if ($staff_type == 0) {
        $data['current_page'] = 'RBO';
        $data['title'] = 'RBO List';
        $data['viewfile'] = "admin/manage_rbo/manage_rbo";
        $this->load->view('admin/layout', $data);
    } else {
        redirect('admin/manage_users');
    }
}

public function get_rbo_list() {
    $requestData = $_REQUEST;
    
    $columns = [
        0 => 'id',
        1 => 'rbo_name',       
        2 => 'c_name',
        3 => 'city_name',
        4 => 'state_name',      
        5 => 'action'
    ];

    // Fetch total records without any filtering
    $totalData = $this->db->count_all('mst_rbo');

    // Fetch filtered data
    $this->db->select('b.*, s.state_name, c.city_name, ci.c_name');
    $this->db->from('mst_rbo b');
    $this->db->join('mst_state s', 'b.state_id = s.id', 'left');
    $this->db->join('mst_city c', 'b.city_id = c.id', 'left');
    $this->db->join('mst_circle ci', 'b.circle_id = ci.id', 'left');

    if (!empty($requestData['search']['value'])) {
        $this->db->group_start();
        $this->db->like('b.rbo_name', $requestData['search']['value']);
        $this->db->or_like('s.state_name', $requestData['search']['value']);
        $this->db->or_like('c.city_name', $requestData['search']['value']);
        $this->db->or_like('ci.c_name', $requestData['search']['value']);
        $this->db->group_end();
    }

    $totalFiltered = $this->db->get()->num_rows();

    $this->db->select('b.*, s.state_name, c.city_name, ci.c_name');
    $this->db->from('mst_rbo b');
    $this->db->join('mst_state s', 'b.state_id = s.id', 'left');
    $this->db->join('mst_city c', 'b.city_id = c.id', 'left');
    $this->db->join('mst_circle ci', 'b.circle_id = ci.id', 'left');

    if (!empty($requestData['search']['value'])) {
        $this->db->group_start();
        $this->db->like('b.rbo_name', $requestData['search']['value']);
        $this->db->or_like('s.state_name', $requestData['search']['value']);
        $this->db->or_like('c.city_name', $requestData['search']['value']);
        $this->db->or_like('ci.c_name', $requestData['search']['value']);
        $this->db->group_end();
    }

    // Handle the case where length is set to -1 (i.e., "All")
    if ($requestData['length'] != -1) {
        $this->db->limit($requestData['length'], $requestData['start']);
    }

    $query = $this->db->get();

    $data = [];
    foreach ($query->result_array() as $key => $row) {
        $nestedData = [];
        $nestedData[] = $row['id']; // Sr.No
        $nestedData[] = $row['rbo_name'];      
        $nestedData[] = $row['c_name'];
        $nestedData[] = $row['city_name'];
        $nestedData[] = $row['state_name'];
        $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">
                            <a href="' . base_url('admin/rbo_form/' . $row['id']) . '" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>
                            ' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_rbo"><i class="bi bi-trash-fill"></i></a>' : '') . '
                         </div>';

        $data[] = $nestedData;
    }

    $json_data = [
        "draw"            => intval($requestData['draw']),
        "recordsTotal"    => intval($totalData),
        "recordsFiltered" => intval($totalFiltered),
        "data"            => $data
    ];

    echo json_encode($json_data);
}


public function rbo_form($id = '') {
    $data['current_page'] = 'RBO';
     $data['circle'] = $this->db->select("*")->from('mst_circle')->where('active', 1)->get()->result_array();
     $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    if ($id != '') {

        $data['title'] = 'Edit RBO';

        $data['branch'] = $this->ccm->get_single_row('mst_rbo', array('id' => $id));

    } else {

        $data['title'] = 'Add RBO';

    }

    $data['viewfile'] = 'admin/manage_rbo/rbo_form';

    $this->load->view('admin/layout', $data);

}


public function submit_rbo() {

    if ($_POST) {


        $data = array(

            'rbo_name' => $this->input->post('rbo_name'),
            'circle_id' => $this->input->post('circle_id'),
            'state_id' => $this->input->post('state_id'),
            'city_id' => $this->input->post('city_id')

//                'e_image' => $user_image,

        );

        $data = array_filter($data);

        $data = $this->security->xss_clean($data);

        $e_id = 0;

        if ($_POST['id'] != '') {

            $e_id = $_POST['id'];

            $this->db->where('id', $_POST['id']);

            $res = $this->db->update('mst_rbo', $data);

            $msg = 'Updated Successfully..!';

        } else {

            if ($this->ccm->get_row_count('mst_rbo', array('rbo_name' => $this->input->post('rbo_name'),'state_id'=>$this->input->post('state_id'),'city_id'=>$this->input->post('city_id'))) != 0) {

                $data = array('type' => 'error', 'message' => 'RBO already exists Please change it...!', 'success' => 0);

                echo json_encode($data);

                exit;

            }

            $res = $this->db->insert('mst_rbo', $data);

            $msg = 'Added Successfully..!';

            $e_id = $this->db->insert_id();

        }

       

        if ($res == 1) {

            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);

            $this->session->set_flashdata('response_message', $message);

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didnt Added, Please try after some time..!');

        }

    } else {

        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');

    }
    echo json_encode($message);
}


public function delete_rbo($id) {
    $this->db->where('id', $id);
    $res = $this->db->delete('mst_rbo');

    if ($res) {
        $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully...!');
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Failed to delete. Please try again later..!');
    }
    echo json_encode($message);
}


public function manage_racpc() {
    $staff_type = $this->session->userdata('staff_type');
    if ($staff_type == 0) {
        $data['current_page'] = 'RACPC';
        $data['title'] = 'RACPC List';
        $data['viewfile'] = "admin/manage_racpc/manage_racpc";
        $this->load->view('admin/layout', $data);
    } else {
        redirect('admin/manage_users');
    }
}

public function get_racpc_list() {
    $requestData = $_REQUEST;
    
    $columns = [
        0 => 'id',
        1 => 'racpc_name',       
        2 => 'c_name',
        3 => 'city_name',
        4 => 'state_name',      
        5 => 'action'
    ];

    // Fetch total records without any filtering
    $totalData = $this->db->count_all('mst_racpc');

    // Fetch filtered data
    $this->db->select('b.*, s.state_name, c.city_name, ci.c_name');
    $this->db->from('mst_racpc b');
    $this->db->join('mst_state s', 'b.state_id = s.id', 'left');
    $this->db->join('mst_city c', 'b.city_id = c.id', 'left');
    $this->db->join('mst_circle ci', 'b.circle_id = ci.id', 'left');

    if (!empty($requestData['search']['value'])) {
        $this->db->group_start();
        $this->db->like('b.racpc_name', $requestData['search']['value']);
        $this->db->or_like('s.state_name', $requestData['search']['value']);
        $this->db->or_like('c.city_name', $requestData['search']['value']);
        $this->db->or_like('ci.c_name', $requestData['search']['value']);
        $this->db->group_end();
    }

    $totalFiltered = $this->db->get()->num_rows();

    $this->db->select('b.*, s.state_name, c.city_name, ci.c_name');
    $this->db->from('mst_racpc b');
    $this->db->join('mst_state s', 'b.state_id = s.id', 'left');
    $this->db->join('mst_city c', 'b.city_id = c.id', 'left');
    $this->db->join('mst_circle ci', 'b.circle_id = ci.id', 'left');

    if (!empty($requestData['search']['value'])) {
        $this->db->group_start();
        $this->db->like('b.racpc_name', $requestData['search']['value']);
        $this->db->or_like('s.state_name', $requestData['search']['value']);
        $this->db->or_like('c.city_name', $requestData['search']['value']);
        $this->db->or_like('ci.c_name', $requestData['search']['value']);
        $this->db->group_end();
    }

    // Handle the case where length is set to -1 (i.e., "All")
    if ($requestData['length'] != -1) {
        $this->db->limit($requestData['length'], $requestData['start']);
    }

    $query = $this->db->get();

    $data = [];
    foreach ($query->result_array() as $key => $row) {
        $nestedData = [];
        $nestedData[] = $row['id']; // Sr.No
        $nestedData[] = $row['racpc_name'];      
        $nestedData[] = $row['c_name'];
        $nestedData[] = $row['city_name'];
        $nestedData[] = $row['state_name'];
        $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">
                            <a href="' . base_url('admin/racpc_form/' . $row['id']) . '" target="_blank" class="text-warning" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit info" aria-label="Edit"><i class="bi bi-pencil-fill"></i></a>
                            ' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_racpc"><i class="bi bi-trash-fill"></i></a>' : '') . '
                         </div>';

        $data[] = $nestedData;
    }

    $json_data = [
        "draw"            => intval($requestData['draw']),
        "recordsTotal"    => intval($totalData),
        "recordsFiltered" => intval($totalFiltered),
        "data"            => $data
    ];

    echo json_encode($json_data);
}


public function racpc_form($id = '') {
     $data['current_page'] = 'RACPC';
     $data['circle'] = $this->db->select("*")->from('mst_circle')->where('active', 1)->get()->result_array();
     $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    if ($id != '') {

        $data['title'] = 'Edit RACPC';

        $data['branch'] = $this->ccm->get_single_row('mst_racpc', array('id' => $id));

    } else {

        $data['title'] = 'Add racpc';

    }

    $data['viewfile'] = 'admin/manage_racpc/racpc_form';

    $this->load->view('admin/layout', $data);

}


public function submit_racpc() {

    if ($_POST) {


        $data = array(

            'racpc_name' => $this->input->post('racpc_name'),
            'circle_id' => $this->input->post('circle_id'),
            'state_id' => $this->input->post('state_id'),
            'city_id' => $this->input->post('city_id')

//                'e_image' => $user_image,

        );

        $data = array_filter($data);

        $data = $this->security->xss_clean($data);

        $e_id = 0;

        if ($_POST['id'] != '') {

            $e_id = $_POST['id'];

            $this->db->where('id', $_POST['id']);

            $res = $this->db->update('mst_racpc', $data);

            $msg = 'Updated Successfully..!';

        } else {

            if ($this->ccm->get_row_count('mst_racpc', array('racpc_name' => $this->input->post('racpc_name'),'state_id'=>$this->input->post('state_id'),'city_id'=>$this->input->post('city_id'))) != 0) {

                $data = array('type' => 'error', 'message' => 'racpc already exists Please change it...!', 'success' => 0);

                echo json_encode($data);

                exit;

            }

            $res = $this->db->insert('mst_racpc', $data);

            $msg = 'Added Successfully..!';

            $e_id = $this->db->insert_id();

        }

       

        if ($res == 1) {

            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);

            $this->session->set_flashdata('response_message', $message);

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didnt Added, Please try after some time..!');

        }

    } else {

        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');

    }
    echo json_encode($message);
}


public function delete_racpc($id) {
    $this->db->where('id', $id);
    $res = $this->db->delete('mst_racpc');

    if ($res) {
        $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully...!');
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Failed to delete. Please try again later..!');
    }
    echo json_encode($message);
}

public function manage_circle() {
   
    $staff_type = $this->session->userdata('staff_type');

    // Only proceed if staff_type is 0
    if ($staff_type == 0) {
    
    $data['current_page'] = 'Circle';
    $data['title'] = 'Circle Report';
    $data['circle'] = $this->ccm->get_all_data('mst_circle', '', 'id', '', 'c_name');
    $data['viewfile'] = "admin/manage_circle/manage_circle";

    $this->load->view('admin/layout', $data);
    } else {
        // Redirect or show an error message for unauthorized access
        redirect('admin/manage_users');
    }
}


public function circle_form($id = '') {
     

    $data['current_page'] = 'Circle';

    if ($id != '') {

        $data['title'] = 'Edit Circle';

        $data['circle'] = $this->ccm->get_single_row('mst_circle', array('id' => $id));

    } else {

        $data['title'] = 'Add Circle';

    }

    $data['viewfile'] = 'admin/manage_circle/circle_form';

    $this->load->view('admin/layout', $data);

}


public function submit_circle() {
    if ($_POST) {
        $data = $_POST;

        $data = array_filter($data);

        $data = $this->security->xss_clean($data);

        $e_id = 0;

        if ($_POST['id'] != '') {

            $e_id = $_POST['id'];

            $this->db->where('id', $_POST['id']);

            $res = $this->db->update('mst_circle', $data);

            $msg = 'Updated Successfully..!';

        } else {

            if ($this->ccm->get_row_count('mst_circle', array('c_name' => $this->input->post('c_name'))) != 0) {

                $data = array('type' => 'error', 'message' => 'already exists Please change it...!', 'success' => 0);

                echo json_encode($data);

                exit;

            }

            $res = $this->db->insert('mst_circle', $data);

            $msg = 'Added Successfully..!';

            $e_id = $this->db->insert_id();

        }

       

        if ($res == 1) {

            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);

            $this->session->set_flashdata('response_message', $message);

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didnt Added, Please try after some time..!');

        }

    } else {

        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');

    }

    echo json_encode($message);

}

public function active_circle($id, $status) {

        $data["active"] = $status;

        $this->db->where('id', $id);

        if ($this->db->update("mst_circle", $data)) {

            if ($status == 0) {

                $message = array('success' => '1', 'type' => 'success', 'message' => 'Circle Deactivated...!');

            } else {

                $message = array('success' => '1', 'type' => 'success', 'message' => 'Circle Activated...!');

            }

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Circle did not updated please try after some time..!');

        }

        echo json_encode($message);

    }
    
    
public function deleted_invoice_history() {
   
    $staff_type = $this->session->userdata('staff_type');

    // Only proceed if staff_type is 0
    if ($staff_type == 0) {
    
    $data['current_page'] = 'deleted_invoice_log';
    $data['title'] = 'Deleted Invoice Log';
    $data['deleted_invoice'] = $this->db->select('deleted_invoice_log.*, mst_staff.staff_fullname') // Select fields
    ->from('deleted_invoice_log') // From the deleted_invoice_log table
    ->join('mst_staff', 'mst_staff.staff_id = deleted_invoice_log.deleted_by', 'left') // Join with mst_staff on deleted_by = staff_id
   // ->group_by('deleted_invoice_log.inv_batchno') // Group by inv_batchno
    ->order_by('deleted_invoice_log.deleted_at', 'DESC') // Order by deleted_at in descending order
    ->get()
    ->result_array();



    $data['viewfile'] = "admin/manage_activity_log/manage_deleted_invoice";

    $this->load->view('admin/layout', $data);
    } else {
        // Redirect or show an error message for unauthorized access
        redirect('admin/manage_users');
    }
} 


public function deleted_payment_log() {
   
    $staff_type = $this->session->userdata('staff_type');

    // Only proceed if staff_type is 0
    if ($staff_type == 0) {
    
    $data['current_page'] = 'deleted_payment_log';
    $data['title'] = 'Deleted Payment Log';
    $data['deleted_payment'] = $this->db->select('deleted_payment_log.*, mst_staff.staff_fullname') // Select fields
    ->from('deleted_payment_log') // From the deleted_payment_log table
    ->join('mst_staff', 'mst_staff.staff_id = deleted_payment_log.deleted_by', 'left') // Join with mst_staff on deleted_by = staff_id
   // ->group_by('deleted_payment_log.inv_batchno') // Group by inv_batchno
    ->order_by('deleted_payment_log.deleted_date', 'DESC') // Order by deleted_at in descending order
    ->get()
    ->result_array();



    $data['viewfile'] = "admin/manage_activity_log/manage_deleted_payment";

    $this->load->view('admin/layout', $data);
    } else {
        // Redirect or show an error message for unauthorized access
        redirect('admin/manage_users');
    }
} 


public function deleted_applicant_log() {
   
    $staff_type = $this->session->userdata('staff_type');

    // Only proceed if staff_type is 0
    if ($staff_type == 0) {
    
    $data['current_page'] = 'deleted_user_log';
    $data['title'] = 'Deleted Applicant Log';
    $data['deleted_user'] = $this->db->select('deleted_user_log.*, mst_staff.staff_fullname as deleted_by_name') // Select fields
    ->from('deleted_user_log') 
    ->join('mst_staff', 'mst_staff.staff_id = deleted_user_log.deleted_by', 'left') // Join with mst_staff on deleted_by = staff_id
    ->order_by('deleted_user_log.deleted_date', 'DESC') // Order by deleted_at in descending order
    ->get()
    ->result_array();



    $data['viewfile'] = "admin/manage_activity_log/manage_deleted_user";

    $this->load->view('admin/layout', $data);
    } else {
        // Redirect or show an error message for unauthorized access
        redirect('admin/manage_users');
    }
} 


public function applicant_user_activity() {
    $staff_type = $this->session->userdata('staff_type');

    // Only proceed if staff_type is authorized (e.g., 0 for admin)
    if ($staff_type == 0) {
        $data['current_page'] = 'applicant_user_activity';
        $data['title'] = 'Applicant Activity Log';

        // Fetch activity logs with additional data for branch names
        $logs = $this->db->select('
                applicant_user_activity.*, 
                mst_staff.staff_fullname as updated_by_name, 
                mst_user.user_name as user_name, 
                connector_staff.staff_fullname as partner_name
            ')
            ->from('applicant_user_activity')
            ->join('mst_staff', 'mst_staff.staff_id = applicant_user_activity.updated_by', 'left') // Join with mst_staff for updated_by
            ->join('mst_user', 'mst_user.id = applicant_user_activity.user_id', 'left') // Join with mst_user for user_name
            ->join('mst_staff as connector_staff', 'connector_staff.staff_id = mst_user.connector_id', 'left') // Join with mst_staff for partner_name
            ->order_by('applicant_user_activity.updated_at', 'DESC') // Order by updated_at descending
            ->get()
            ->result_array();

        // Replace old_value and new_value for branch_id field with branch names
        foreach ($logs as &$log) {
            if ($log['field_name'] === 'branch_id') {
                // Fetch branch names for old_value and new_value
                $log['old_value'] = $this->get_branch_name($log['old_value']);
                $log['new_value'] = $this->get_branch_name($log['new_value']);
            }

            if ($log['field_name'] === 'loan_type_id') {
                // Fetch loan type names for old_value and new_value
                $log['old_value'] = $this->get_loan_type_name($log['old_value']);
                $log['new_value'] = $this->get_loan_type_name($log['new_value']);
            }
            
            if ($log['field_name'] === 'connector_id') {
                // Fetch loan type names for old_value and new_value
                $log['old_value'] = $this->get_connector_name($log['old_value']);
                $log['new_value'] = $this->get_connector_name($log['new_value']);
            }
        }

        $data['activity_logs'] = $logs;
        $data['viewfile'] = "admin/manage_activity_log/manage_applicant_form_log";

        $this->load->view('admin/layout', $data);
    } else {
        // Redirect or show an error message for unauthorized access
        redirect('admin/dashboard');
    }
}

/**
 * Helper function to get branch name by branch ID.
 */
private function get_branch_name($branch_id) {
    if (empty($branch_id)) {
        return 'N/A';
    }

    $branch = $this->db->select('branch_name')
        ->from('branch')
        ->where('id', $branch_id)
        ->get()
        ->row();

    return $branch ? $branch->branch_name : 'N/A';
}

private function get_connector_name($staff_id) {
    if (empty($staff_id)) {
        return 'N/A';
    }

    $connector = $this->db->select('staff_fullname')
        ->from('mst_staff')
        ->where('staff_id', $staff_id)
        ->get()
        ->row();

    return $connector ? $connector->staff_fullname : 'N/A';
}

private function get_loan_type_name($loan_type_id) {
    if (empty($loan_type_id)) {
        return 'N/A';
    }

    $loan_type = $this->db->select('name')
        ->from('mst_loan_type')
        ->where('id', $loan_type_id)
        ->get()
        ->row();

    return $loan_type ? $loan_type->name : 'N/A';
}






public function manage_loan_type() {
   
    $staff_type = $this->session->userdata('staff_type');

    // Only proceed if staff_type is 0
    if ($staff_type == 0) {
    
    $data['current_page'] = 'Loan Type';
    $data['title'] = 'Loan Type';
    $data['loan_type'] = $this->ccm->get_all_data('mst_loan_type', '', 'id', '', 'name');
    $data['viewfile'] = "admin/manage_loan_type/manage_loan_type";

    $this->load->view('admin/layout', $data);
    } else {
        // Redirect or show an error message for unauthorized access
        redirect('admin/manage_users');
    }
}


public function loan_type_form($id = '') {
     

    $data['current_page'] = 'Loan Type';

    if ($id != '') {

        $data['title'] = 'Edit Loan Type';

        $data['loan_type'] = $this->ccm->get_single_row('mst_loan_type', array('id' => $id));

    } else {

        $data['title'] = 'Add Loan Type';

    }

    $data['viewfile'] = 'admin/manage_loan_type/loan_type_form';

    $this->load->view('admin/layout', $data);

}


public function submit_loan_type() {
    if ($_POST) {
        $data = $_POST;

        $data = array_filter($data);

        $data = $this->security->xss_clean($data);

        $e_id = 0;

        if ($_POST['id'] != '') {

            $e_id = $_POST['id'];

            $this->db->where('id', $_POST['id']);

            $res = $this->db->update('mst_loan_type', $data);

            $msg = 'Updated Successfully..!';

        } else {

            if ($this->ccm->get_row_count('mst_loan_type', array('name' => $this->input->post('name'))) != 0) {

                $data = array('type' => 'error', 'message' => 'already exists Please change it...!', 'success' => 0);

                echo json_encode($data);

                exit;

            }

            $res = $this->db->insert('mst_loan_type', $data);

            $msg = 'Added Successfully..!';

            $e_id = $this->db->insert_id();

        }

       

        if ($res == 1) {

            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);

            $this->session->set_flashdata('response_message', $message);

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didnt Added, Please try after some time..!');

        }

    } else {

        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');

    }

    echo json_encode($message);

}

public function active_loan_type($id, $status) {

        $data["active"] = $status;

        $this->db->where('id', $id);

        if ($this->db->update("mst_loan_type", $data)) {

            if ($status == 0) {

                $message = array('success' => '1', 'type' => 'success', 'message' => 'Deactivated...!');

            } else {

                $message = array('success' => '1', 'type' => 'success', 'message' => 'Activated...!');

            }

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Circle did not updated please try after some time..!');

        }

        echo json_encode($message);

    }


/*public function get_last_invoice_number_sbi() {
    // Custom SQL query to retrieve the last invoice number
    $sql = "
        SELECT invoice_number 
        FROM invoices 
        WHERE invoice_type = 'inv_sbi' 
        ORDER BY CAST(SUBSTRING(invoice_number, 5) AS UNSIGNED) DESC 
        LIMIT 1
    ";

    // Execute the custom query
    $query = $this->db->query($sql);

    if ($query->num_rows() > 0) {
        // If there are existing invoices in the batch, extract the numeric part from the last invoice number
        $last_invoice_number = $query->row()->invoice_number;
        $numeric_part = intval(substr($last_invoice_number, 4)); // 4 characters for 'MBPL'

        // Increment the numeric part by 1
        $new_numeric_part = $numeric_part + 1;

        // Determine the length of the numeric part of the last invoice number
        $num_length = strlen(substr($last_invoice_number, 4));

        // Format the new invoice number
        $new_invoice_number = 'MBPL' . str_pad($new_numeric_part, $num_length, '0', STR_PAD_LEFT);

        return $new_invoice_number;
    } else {
        // If no invoices exist yet for the batch, start from 00001
        return 'MBPL00001'; // Start from 'MBPL00001' if no invoices exist
    }
}
*/


public function get_last_invoice_number_sbi() {
    $financial_year = '26'; // You can make this dynamic if needed
    $prefix = 'MBPL' . $financial_year;

    // Custom SQL query to retrieve the last invoice number starting with MBPL26
    $sql = "
        SELECT invoice_number 
        FROM invoices 
        WHERE invoice_type = 'inv_sbi' 
        AND invoice_number LIKE '{$prefix}%' 
        ORDER BY CAST(SUBSTRING(invoice_number, 7) AS UNSIGNED) DESC 
        LIMIT 1
    ";

    // Execute the custom query
    $query = $this->db->query($sql);

    if ($query->num_rows() > 0) {
        $last_invoice_number = $query->row()->invoice_number;

        // Extract numeric part after the 6th character (MBPL26)
        $numeric_part = intval(substr($last_invoice_number, 6));

        // Increment the numeric part
        $new_numeric_part = $numeric_part + 1;

        // Format the new invoice number
        $new_invoice_number = $prefix . str_pad($new_numeric_part, 4, '0', STR_PAD_LEFT);

        return $new_invoice_number;
    } else {
        // If no invoices exist yet for this financial year
        return $prefix . '0001';
    }
}



public function get_last_invoice_number_pb() {
    // Custom SQL query to retrieve the last invoice number with type 'inv_pb'
    $sql = "
        SELECT invoice_number 
        FROM invoices 
        WHERE invoice_type = 'inv_pb' 
        AND invoice_number LIKE 'MBPB%' 
        ORDER BY CAST(SUBSTRING(invoice_number, 7) AS UNSIGNED) DESC 
        LIMIT 1
    ";

    // Execute the query
    $query = $this->db->query($sql);

    // Define the financial year part
    $financial_year = '26'; // for 2025-26

    if ($query->num_rows() > 0) {
        // Get the last invoice number
        $last_invoice_number = $query->row()->invoice_number;

        // Extract numeric part after the year, starting from 7th character
        $numeric_part = intval(substr($last_invoice_number, 6));

        // Increment the number
        $new_numeric_part = $numeric_part + 1;

        // Pad the number with leading zeros to match desired length
        $padded_number = str_pad($new_numeric_part, 4, '0', STR_PAD_LEFT);

        // Construct the new invoice number
        return 'MBPB' . $financial_year . $padded_number;
    } else {
        // If no invoice found, start from MBPB260001
        return 'MBPB' . $financial_year . '0001';
    }
}


/*public function get_last_invoice_number_pb() {
    // Custom SQL query to retrieve the last invoice number
    $sql = "
        SELECT invoice_number 
        FROM invoices 
        WHERE invoice_type = 'inv_pb' 
        ORDER BY CAST(SUBSTRING(invoice_number, 5) AS UNSIGNED) DESC 
        LIMIT 1
    ";

    // Execute the custom query
    $query = $this->db->query($sql);

    if ($query->num_rows() > 0) {
        // If there are existing invoices in the batch, extract the numeric part from the last invoice number
        $last_invoice_number = $query->row()->invoice_number;
        $numeric_part = intval(substr($last_invoice_number, 2)); // 4 characters for 'MBPL'

        // Increment the numeric part by 1
        $new_numeric_part = $numeric_part + 1;

        // Determine the length of the numeric part of the last invoice number
        $num_length = strlen(substr($last_invoice_number, 2));

        // Format the new invoice number
        $new_invoice_number = 'MB' . str_pad($new_numeric_part, $num_length, '0', STR_PAD_LEFT);

        return $new_invoice_number;
    } else {
        // If no invoices exist yet for the batch, start from 00001
        return 'MB00001'; // Start from 'MBP00001' if no invoices exist
    }
}*/
  
  public function get_last_invoice_number_branch() {
    // Retrieve the last invoice number for the batch from the database
    $this->db->select('invoice_number');
    $this->db->from('invoices');
    $this->db->where('invoice_type', 'inv_branch');
    $this->db->order_by('id', 'DESC');
    $this->db->limit(1);
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        // If there are existing invoices in the batch, extract the numeric part from the last invoice number
        $last_invoice_number = $query->row()->invoice_number;
        $numeric_part = intval(substr($last_invoice_number, 4)); 

        // Increment the numeric part by 1
        $new_numeric_part = $numeric_part + 1;

        // Determine the length of the numeric part of the last invoice number
        $num_length = strlen(substr($last_invoice_number, 4));

        // Format the new invoice number
        $new_invoice_number = 'BRCF' . str_pad($new_numeric_part, $num_length, '0', STR_PAD_LEFT);

        return $new_invoice_number;
    } else {
        // If no invoices exist yet for the batch, start from 00001
        return 'BRCF00001';
    }
}

public function print_last_invoice_number_sbi() {
    // Retrieve the last invoice number for the batch from the database
    $this->db->select('invoice_number');
    $this->db->from('invoices');
    $this->db->where('invoice_type', 'inv_sbi');
    $this->db->order_by('id', 'DESC');
    $this->db->limit(1);
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
        // If there are existing invoices in the batch, extract the numeric part from the last invoice number
        $last_invoice_number = $query->row()->invoice_number;
        $numeric_part = intval(substr($last_invoice_number, 4)); 

        // Increment the numeric part by 1
        $new_numeric_part = $numeric_part + 1;

        // Determine the length of the numeric part of the last invoice number
        $num_length = strlen(substr($last_invoice_number, 4));

        // Format the new invoice number
        $new_invoice_number = 'MBPL' . str_pad($new_numeric_part, $num_length, '0', STR_PAD_LEFT);

        // Print the last invoice number
        echo "Last Invoice Number: " . $last_invoice_number . "<br>";

        // Print the new invoice number
        echo "New Invoice Number: " . $new_invoice_number . "<br>";

        return $new_invoice_number;
    } else {
        // If no invoices exist yet for the batch, print and start from MBPL00001
        $last_invoice_number = 'MBPL00000';
        echo "Last Invoice Number: " . $last_invoice_number . "<br>";

        $new_invoice_number = 'MBPL00001';
        //echo "New Invoice Number: " . $new_invoice_number . "<br>";

        return $new_invoice_number;
    }
}

  /* public function get_last_invoice_number_sbi() {
   
    $this->db->select('invoice_number');
    $this->db->from('invoices');
    $this->db->where('invoice_type', 'inv_sbi');
    $this->db->order_by('id', 'DESC');
    $this->db->limit(1);
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
      
        $last_invoice_number = $query->row()->invoice_number;
        $numeric_part = intval(substr($last_invoice_number, 7)); 

        // Increment the numeric part by 1
        $new_numeric_part = $numeric_part + 1;

        // Format the new invoice number
        $new_invoice_number = 'MBPL' . str_pad($new_numeric_part, 5, '0', STR_PAD_LEFT); 

        return $new_invoice_number;
    } else {
       
        return 'MBPL00001'; // Start from 'MBPL00001' if no invoices exist
    }
}*/




 // 2lack limit auto   
/*public function genrate_invoice() {
  
    $invoice_type = $this->input->post('inv_type');
    $invoice_date = $this->input->post('invoice_date');
    $response = array();
    $selectedRows = array();

    if ($invoice_type == 'inv_hlc') {
        $selectedRows = $this->db
            ->select("*")
            ->where('connector_id', $_SESSION['staff_id'])
            ->where('disb_status', 'yes')
            ->where('invoice_id', null)
            ->where('sanction_amt IS NOT NULL')
            ->where('disb_date IS NOT NULL')
            ->from('mst_user')
            ->get()
            ->result_array();

    } elseif ($invoice_type == 'inv_sbi') {
        $selectedRows = $this->db
            ->select("*")
            ->where('applicant_invoice_status', 'Generated')
            ->where('invoice_id IS NOT NULL')
            ->where('sbi_genrated', 'No') 
            ->from('mst_user')
            ->get()
            ->result_array();
    }

    $this->db->trans_start();        
        
    foreach ($selectedRows as $rowID) {  
        $user_data = $this->db->select("*")->where(['id' => $rowID['id']])->from('mst_user')->get()->row();
        $connector_data = $this->db->get_where('mst_staff', ['staff_id' => $user_data->connector_id])->row();
        $existingInvoiceHLC = $this->db->get_where('invoices', ['user_id' => $rowID['id'], 'invoice_type' => 'inv_hlc'])->row(); 
        $existingInvoiceSBI = $this->db->get_where('invoices', ['user_id' => $rowID['id'], 'invoice_type' => 'inv_sbi',])->row();
        
        if ($invoice_type == 'inv_hlc') {
            $batchInvoiceNumber = date("Y").'/00'.$user_data->connector_id;
        } elseif ($invoice_type == 'inv_sbi') {   
            $batchInvoiceNumber = $this->generate_invoice_number_sbi();
        }
        
        $currentDateTime = date("YmdHis");
        $batchNumber = $invoice_type . $currentDateTime;
        
        // Calculate total commission
        $loanAmt = $user_data->sanction_amt;
        $commissionRate = $connector_data->conn_commision;
        $totalCommission = $loanAmt * $commissionRate/100;
        $gstPercentage = empty($connector_data->gst_no) ? 0 : 18; // Check if GST number is empty
        $gst = $gstPercentage / 100 * $totalCommission;
        $netPayamt_hlc = $totalCommission + $gst;
        
        // Validate if invoice_date is after disb_date
        if ($user_data->disb_date > $invoice_date) {
            $response['status'] = 'error';
            $response['message'] = 'Invoice Date must be after Disbursement Date for ID: ' . $rowID['id'];
            continue; 
        }

        if ($invoice_type == 'inv_hlc') {
            if (!$existingInvoiceHLC) {                
                $data = array(                
                    'invoice_number' => $batchInvoiceNumber,
                    'inv_batchno' => $batchNumber,
                    'connector_id' => $user_data->connector_id,
                    'branch_id' => $user_data->branch_id,
                    'user_id' => $rowID['id'],
                    'loan_amt' => $loanAmt,
                    'loan_type_id' => $user_data->loan_type_id,
                    'commission_type' => 'Percent', 
                    'commission_amt' => $gstPercentage, 
                    'total_commission' => $totalCommission, 
                    'invoice_type' => $invoice_type, 
                    'invoice_date' => $invoice_date,    
                    'net_payment' => $netPayamt_hlc,
                    'created_by' => $_SESSION['staff_id']              
                );        
                
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Already generated';
            }
        }
        
        if ($invoice_type == 'inv_sbi') {
            if (!$existingInvoiceSBI) {
                $commissionSlabs = $this->getCommissionSlabs($loanAmt, $user_data->loan_type_id);
                $totalCommissionSBI = $this->calculateTotalCommission($loanAmt, $commissionSlabs);
                $commissionType = '';
                $commissionAmount = 0;
                if ($commissionSlabs) {
                    $commissionType = $commissionSlabs[0]->pay_type; 
                    $commissionAmount = $commissionSlabs[0]->amount;
                    $slab_id = $commissionSlabs[0]->id;
                } else {
                    $slab_id = null;
                }
                $ninetyPercentCommission = (90 / 100) * $totalCommissionSBI; // Calculate 90% of total commission
                $netPayamt_sbi = $ninetyPercentCommission+(9/100*$ninetyPercentCommission)+(9/100*$ninetyPercentCommission);

                // Limit net payment to 2,00,000
                if ($netPayamt_sbi > 200000) {
                    // Generate a new batch for this row where net payment exceeds 2,00,000
                    $newBatchNumber = $invoice_type . $currentDateTime . '_'. $rowID['id']; // New batch number
                    $data = array(                
                        'invoice_number' => $batchInvoiceNumber,
                        'inv_batchno' => $newBatchNumber,
                        'connector_id' => $user_data->connector_id,
                        'branch_id' => $user_data->branch_id,
                        'user_id' => $rowID['id'],
                        'loan_amt' => $loanAmt,
                        'loan_type_id' => $user_data->loan_type_id,
                        'slab_id' => $slab_id,
                        'commission_type' => $commissionType, 
                        'commission_amt' => $commissionAmount, 
                        'total_commission' => $totalCommissionSBI, 
                        'invoice_type' => $invoice_type,  
                        'invoice_date' => $invoice_date,            
                        'created_by' => $_SESSION['staff_id'],
                        'net_payment' => $netPayamt_sbi
                    );
                } else {
                    $data = array(                
                        'invoice_number' => $batchInvoiceNumber,
                        'inv_batchno' => $batchNumber,
                        'connector_id' => $user_data->connector_id,
                        'branch_id' => $user_data->branch_id,
                        'user_id' => $rowID['id'],
                        'loan_amt' => $loanAmt,
                        'loan_type_id' => $user_data->loan_type_id,
                        'slab_id' => $slab_id,
                        'commission_type' => $commissionType, 
                        'commission_amt' => $commissionAmount, 
                        'total_commission' => $totalCommissionSBI, 
                        'invoice_type' => $invoice_type,  
                        'invoice_date' => $invoice_date,            
                        'created_by' => $_SESSION['staff_id'],
                        'net_payment' => $netPayamt_sbi
                    );
                }       

            } else {
                $response['status'] = 'error';
                $response['message'] = 'Already generated';
            }
        }                 
            
        $this->db->insert('invoices', $data);
        $last_invoice_id = $this->db->insert_id();
        
        $updateData = array();
        if ($invoice_type == 'inv_hlc') {
            $updateData = ['invoice_id' => $last_invoice_id, 'applicant_invoice_status' => 'Generated','sbi_genrated'=>'No'];
           
        } elseif ($invoice_type == 'inv_sbi') {
            $updateData = ['invoice_id' => $last_invoice_id, 'sbi_genrated' => 'Yes'];
        }
        $this->db->where('id', $rowID['id']);
        $this->db->update('mst_user', $updateData);
        
        
        $response['status'] = 'success';
        $response['message'] = 'Invoices generated successfully';
    }

    $this->db->trans_complete();
      
    echo json_encode($response);
}*/


public function generate_invoice_branch() {
    $invoice_date = $this->input->post('invoice_date');
    $invoice_type = $this->input->post('inv_type');
    $signature_id = $this->input->post('signature_id');
    $selectedRows = json_decode($this->input->post('selectedRows'), true);
    $response = array();

    if (!empty($selectedRows)) {
        $this->db->trans_start();

        // Group selected rows by branch
        $branches = array();
        foreach ($selectedRows as $rowID) {
            $user_data = $this->db->select("*")->where(['id' => $rowID])->from('mst_user')->get()->row();
           
            // --- Financial Year Validation ---
            $session_fy = $this->session->userdata('financial_year'); // e.g., '24-25'
            $disb_date = new DateTime($user_data->disb_date);
            $disb_year = (int)$disb_date->format('Y');
            $disb_month = (int)$disb_date->format('m');
            
            if ($disb_month >= 4) {
                $disb_fy = substr($disb_year, -2) . '-' . substr($disb_year + 1, -2);
            } else {
                $disb_fy = substr($disb_year - 1, -2) . '-' . substr($disb_year, -2);
            }
            
            if ($disb_fy !== $session_fy) {
                $response['status'] = 'error';
                $response['message'] = 'Disbursement date does not belong to financial year ' . $session_fy . ' for ID: ' . $user_data->id;
                continue;
            }
            
            $branches[$user_data->branch_id][] = $user_data;
        }

        // Get the last global invoice number to start from
        $globalInvoiceNumber = $this->get_last_invoice_number_branch();

        foreach ($branches as $branch_id => $users) {
            // Generate a unique batch number for each branch
            $currentDateTime = date("YmdHis");
            $batchNumber = $invoice_type . $currentDateTime . $branch_id;

            // Assign the same invoice number to all users within this batch
            $batchInvoiceNumber = $globalInvoiceNumber;

            foreach ($users as $user_data) {
                $connector_data = $this->db->get_where('mst_staff', ['staff_id' => $user_data->connector_id])->row();

                // Check if the current account is an RR account associated with a main account
                $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $user_data->id, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();

                // Check conditions for generating invoice
                if (is_null($user_data->branch_genrated) &&
                    is_null($user_data->branch_invoice_id) &&
                    !is_null($user_data->sanction_amt) && 
                    !is_null($user_data->applicant_invoice_status) && 
                    !is_null($user_data->commi_slab) && 
                    !is_null($user_data->sbi_commi)) {

                    // Validate if invoice_date is after disb_date
                    if ($user_data->disb_date > $invoice_date) {
                        $response['status'] = 'error';
                        $response['message'] = 'Invoice Date must be after Disbursement Date for ID: ' . $user_data->id;
                        continue; // Skip to the next iteration if validation fails
                    }

                    $commission = 0;
                    if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                        $loan_type_id = 5;
                        $loanAmt = $rr_main_account->sanction_amt;
                        $sanction_loan_Amt = $user_data->rinnraksha_amt;
                        $premiumAmt = $user_data->rinnraksha_amt;
                        if ($loanAmt == 5000000) {
                            // If the loan amount is exactly 50 lakh, set commission to 4000
                            $commission = 4000;
                        } elseif ($loanAmt < 5000000) {
                            $commission = 4000;
                        } elseif ($loanAmt >= 5000000 && $loanAmt < 10000000) {
                            $commission = 5000;
                        } elseif ($loanAmt >= 10000000) {
                            $commission = 6000;
                        }

                    } else {
                        $sanction_loan_Amt = $user_data->sanction_amt;
                        $loan_type_id = $user_data->loan_type_id;
                        $loanAmt = $user_data->sanction_amt;
                    }

                    $commissionRate = $user_data->sbi_commi;
                    $totalCommission = $sanction_loan_Amt * $commissionRate / 100;

                    $ninetyPercentCommission = (90 / 100) * $totalCommission; 
                    $tenpercentCommi = (10 / 100) * $totalCommission;
                    $netPayamt_sbi = $ninetyPercentCommission + (18 / 100 * $ninetyPercentCommission);

                    $data = array(
                        'invoice_number' => $batchInvoiceNumber,
                        'inv_batchno' => $batchNumber,
                        'connector_id' => $user_data->connector_id,
                        'branch_id' => $user_data->branch_id,
                        'user_id' => $user_data->id,
                        'loan_amt' => $sanction_loan_Amt, 
                        'loan_type_id' => $loan_type_id,
                        'commission_type' => 'Percent', 
                        'commission_amt' => $user_data->sbi_commi,
                        'conn_commision_set' => $connector_data->conn_commision,
                        'rr_fix_commi' => $commission,
                        'total_commission' => $totalCommission, 
                        'invoice_type' => $invoice_type, 
                        'invoice_date' => $invoice_date, 
                        '90percent_commi' => $ninetyPercentCommission,
                        '10percent_commi' => $tenpercentCommi,
                        'net_payment' => $netPayamt_sbi, 
                        'signature_id' => $signature_id,
                        'created_by' => $_SESSION['staff_id']
                    );  
                    $this->db->insert('invoices', $data);
                    $last_invoice_id = $this->db->insert_id();

                    // Update user's record based on invoice type
                    $updateData = array();
                    if ($invoice_type == 'inv_branch') {
                        $updateData = ['branch_invoice_id' => $last_invoice_id, 'branch_genrated' => 'Yes'];
                    }
                    $this->db->where('id', $user_data->id);
                    $this->db->update('mst_user', $updateData);

                    $response['status'] = 'success';
                    $response['message'] = 'Invoices generated successfully';
                } else {
                    $response['status'] = 'error';
                    $response['message'] = 'Invalid row selected for invoice generation fill all data';
                }
            }

            // Increment the global invoice number after processing the entire batch
            $globalInvoiceNumber = $this->increment_invoice_number($globalInvoiceNumber);
        }

        $this->db->trans_complete();
    } else {
        $response['status'] = 'error';
        $response['message'] = 'No rows selected for invoice generation';
    }

    echo json_encode($response);
}



// Function to increment an invoice number
public function increment_invoice_number($current_invoice_number) {
    $numeric_part = intval(substr($current_invoice_number, 4)); 
    $new_numeric_part = $numeric_part + 1;
    $num_length = strlen(substr($current_invoice_number, 4));
    return 'BRCF' . str_pad($new_numeric_part, $num_length, '0', STR_PAD_LEFT);
}




public function generate_invoice_sbi() {
        $invoice_date = $this->input->post('invoice_date');
        $invoice_type = $this->input->post('inv_type');
        $signature_id = $this->input->post('signature_id');
        $is_tenper_hold = $this->input->post('is_tenper_hold');
        $selectedRows = json_decode($this->input->post('selectedRows'), true);
        $response = array();

        if (!empty($selectedRows)) {
            $this->db->trans_start();

            $lastRboId = null;
            $batchNumber = null; // Initialize batch number
            $invoiceNumber = null; // Initialize invoice number

            foreach ($selectedRows as $rowID) {
                $user_data = $this->db->select("*")->where(['id' => $rowID])->from('mst_user')->get()->row();
                $connector_data = $this->db->get_where('mst_staff', ['staff_id' => $user_data->connector_id])->row();
                $data_branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();
                $data_rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => $data_branch->rbo_id])->get()->row();
                   // Check if the current account is an RR account associated with a main account
                $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $rowID, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
                
                
                // --- Financial Year Validation ---
                $session_fy = $this->session->userdata('financial_year'); // e.g., '24-25'
                $disb_date = new DateTime($user_data->disb_date);
                $disb_year = (int)$disb_date->format('Y');
                $disb_month = (int)$disb_date->format('m');
                
                if ($disb_month >= 4) {
                    $disb_fy = substr($disb_year, -2) . '-' . substr($disb_year + 1, -2);
                } else {
                    $disb_fy = substr($disb_year - 1, -2) . '-' . substr($disb_year, -2);
                }
                
                if ($disb_fy !== $session_fy) {
                    $response['status'] = 'error';
                    $response['message'] = 'Disbursement date does not belong to financial year ' . $session_fy . ' for ID: ' . $rowID;
                    continue;
                }

                // Check if a new batch should be started
                if ($lastRboId !== $data_rbo->id || is_null($batchNumber)) {
                    $currentDateTime = date("Ymdhi");
                    $batchNumber = $invoice_type . $currentDateTime . (is_null($invoiceNumber) ? $this->get_last_invoice_number_sbi() : $invoiceNumber) . $data_rbo->id;
                    $lastRboId = $data_rbo->id;

                    if (is_null($invoiceNumber)) {
                        $invoiceNumber = $this->get_last_invoice_number_sbi();
                    } else {
                        $financial_year = '26'; // You can make this dynamic if needed
                        $prefix = 'MBPL' . $financial_year;
                        // Extract the numeric part after the prefix (starts from 6th character)
                        $numeric_part = substr($invoiceNumber, strlen($prefix));
                        // Increment numeric part
                        $incremented_numeric_part = intval($numeric_part) + 1;
                        // Reconstruct invoice number with proper padding
                        $invoiceNumber = $prefix . str_pad($incremented_numeric_part, strlen($numeric_part), '0', STR_PAD_LEFT);
                    }
                }
            
            // Check conditions for generating invoice
            if ($user_data->sbi_genrated == 'No' && 
                !is_null($user_data->invoice_id) && 
                !is_null($user_data->sanction_amt) && 
                !is_null($user_data->applicant_invoice_status) && 
                !is_null($user_data->commi_slab) && 
                !is_null($user_data->sbi_commi)) {
                
                // Validate if invoice_date is after disb_date
                if ($user_data->disb_date > $invoice_date) {
                    $response['status'] = 'error';
                    $response['message'] = 'Invoice Date must be after Disbursement Date for ID: ' . $rowID;
                    continue; // Skip to the next iteration if validation fails
                }
                
                
                $commission = 0;
                if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                    $loan_type_id = 5;
                    $loanAmt = $rr_main_account->sanction_amt;
                    $sanction_loan_Amt = $user_data->rinnraksha_amt;
                    $premiumAmt = $user_data->rinnraksha_amt;
                    if ($loanAmt == 5000000) {
                        // If the loan amount is exactly 50 lakh, set commission to 4000
                        $commission = 4000;
                    } elseif ($loanAmt < 5000000) {
                        $commission = 4000;
                    } elseif ($loanAmt >= 5000000 && $loanAmt < 10000000) {
                        $commission = 5000;
                    } elseif ($loanAmt >= 10000000) {
                        $commission = 6000;
                    }
                    
                    
                } else {
                        $sanction_loan_Amt = $user_data->sanction_amt;
                        $loan_type_id = $user_data->loan_type_id;
                        $loanAmt = $user_data->sanction_amt;
                }
                
                 $commissionRate = $user_data->sbi_commi;
                 $totalCommission = $sanction_loan_Amt * $commissionRate/100;
                 
                 $ninetyPercentCommission = (90 / 100) * $totalCommission; 
                 $tenpercentCommi = (10/100) * $totalCommission;
                 $netPayamt_sbi = $ninetyPercentCommission+(18/100*$ninetyPercentCommission);
                
                
                $data = array(                
                    'invoice_number' => $invoiceNumber,
                    'inv_batchno' => $batchNumber,
                    'connector_id' => $user_data->connector_id,
                    'branch_id' => $user_data->branch_id,
                    'user_id' => $rowID,
                    'loan_amt' => $sanction_loan_Amt, 
                    'loan_type_id' => $loan_type_id,
                    'commission_type' => 'Percent', 
                    'commission_amt' => $user_data->sbi_commi,
                    'conn_commision_set' => $connector_data->conn_commision,
                    'rr_fix_commi' => $commission,
                    'total_commission' => $totalCommission, 
                    'invoice_type' => $invoice_type, 
                    'invoice_date' => $invoice_date, 
                    '90percent_commi' => $ninetyPercentCommission,
                    '10percent_commi' => $tenpercentCommi,
                    'net_payment' => $netPayamt_sbi, 
                    'signature_id' => $signature_id,
                    'is_tenper_hold' => $is_tenper_hold,
                    'created_by' => $_SESSION['staff_id']              
                );  
                $this->db->insert('invoices', $data);
                $last_invoice_id = $this->db->insert_id();
                
                // Update user's record based on invoice type
                $updateData = array();
                if ($invoice_type == 'inv_sbi') {
                    $updateData = ['sbi_invoice_id' => $last_invoice_id,'sbi_genrated'=>'Yes'];
                }
                $this->db->where('id', $rowID);
                $this->db->update('mst_user', $updateData);
                
                $response['status'] = 'success';
                $response['message'] = 'Invoices generated successfully';
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Invalid row selected for invoice generation fill all data';
            }
        }

        $this->db->trans_complete();
    } else {
        $response['status'] = 'error';
        $response['message'] = 'No rows selected for invoice generation';
    }

    echo json_encode($response);
}
/*public function generate_invoice_hlc() {
    $invoice_date = $this->input->post('invoice_date');
    $invoice_type = $this->input->post('inv_type');
    $selectedRows = json_decode($this->input->post('selectedRows'), true);
    $response = array();

    if (!empty($selectedRows)) {
        $this->db->trans_start();
        
         $total_sanction_loan_amt = 0;
         $total_commision_subtotal = 0;
         $total_gst_amt =0;
         $gross_total =0;
          $emailed_batches = array(); // Array to track emailed batches
        foreach ($selectedRows as $rowID) {
            $user_data = $this->db->select("*")->where(['id' => $rowID])->from('mst_user')->get()->row();
            $connector_data = $this->db->get_where('mst_staff', ['staff_id' => $user_data->connector_id])->row();
            
            // Check if the current account is an RR account associated with a main account
             $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $rowID, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
             
            $currentDateTime = date("YmdHis");
            $batchNumber = $invoice_type . $currentDateTime;
           
            $invoiceNumber = $this->generate_same_invoice_number_within_batch($connector_data->hlc_code,$connector_data->staff_id,$batchNumber);

           
            
            // Check conditions for generating invoice
            if ($user_data->disb_status == 'yes' && 
                empty($user_data->invoice_id) && 
                !is_null($user_data->sanction_amt) && 
                empty($user_data->applicant_invoice_status) && 
                !is_null($user_data->disb_date)) {
                
                // Validate if invoice_date is after disb_date
                if ($user_data->disb_date > $invoice_date) {
                    $response['status'] = 'error';
                    $response['message'] = 'Invoice Date must be after Disbursement Date for ID: ' . $rowID;
                    continue; // Skip to the next iteration if validation fails
                }
                
               
                
                if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                    
                    $loan_type_id = 5;
                    $loanAmt = $rr_main_account->sanction_amt;
                    $sanction_loan_Amt = $user_data->rinnraksha_amt;
                    $premiumAmt = $user_data->rinnraksha_amt;
                    if ($loanAmt < 5000000) {
                        $commission = 4000;
                    } elseif ($loanAmt >= 5000000 && $loanAmt < 10000000) {
                        $commission = 5000;
                    } elseif ($loanAmt >= 10000000) {
                        $commission = 6000;
                    } else {
                        $commission = 0;
                    }
                    $hlc_comm = $premiumAmt * $connector_data->conn_commision/100;
                    $totalCommission = $commission + $hlc_comm;
                } else {
                        $sanction_loan_Amt = $user_data->sanction_amt;
                        $loan_type_id = $user_data->loan_type_id;
                        $loanAmt = $user_data->sanction_amt;
                        $commissionRate = $connector_data->conn_commision;
                        $totalCommission = $loanAmt * $commissionRate/100;
                }
                        $gstPercentage = empty($connector_data->gst_no) ? 0 : 18; // Check if GST number is empty
                        $gst = $gstPercentage / 100 * $totalCommission;
                        $netPayamt_hlc = $totalCommission + $gst;
                        
                        
                $total_sanction_loan_amt += $sanction_loan_Amt;
                $total_commision_subtotal += $totalCommission;
                $total_gst_amt += $gst;
                $gross_total += $netPayamt_hlc;
                
                $data = array(                
                    'invoice_number' => $invoiceNumber,
                    'inv_batchno' => $batchNumber,
                    'connector_id' => $user_data->connector_id,
                    'branch_id' => $user_data->branch_id,
                    'user_id' => $rowID,
                    'loan_amt' => $sanction_loan_Amt, 
                    'loan_type_id' => $loan_type_id,
                    'commission_type' => 'Percent', // You need to define $gstPercentage variable
                    'commission_amt' => $connector_data->conn_commision, 
                    'total_commission' => $totalCommission, // You need to define $totalCommission variable
                    'invoice_type' => $invoice_type, 
                    'invoice_date' => $invoice_date,    
                    'net_payment' => $netPayamt_hlc, // You need to define $netPayamt_hlc variable
                    'created_by' => $_SESSION['staff_id']              
                );  
                $this->db->insert('invoices', $data);
                $last_invoice_id = $this->db->insert_id();
                
                // Update user's record based on invoice type
                $updateData = array();
                if ($invoice_type == 'inv_hlc') {
                    $updateData = ['invoice_id' => $last_invoice_id, 'applicant_invoice_status' => 'Generated','sbi_genrated'=>'No'];
                    $last_inv_batch = $data['inv_batchno'];
                }
                $this->db->where('id', $rowID);
                $this->db->update('mst_user', $updateData);
                
                $tds_amt = $total_commision_subtotal*5/100;
                
                $emailData = array(
                'invoice_number' =>$invoiceNumber,
                'invoice_date'=>$invoice_date,
                'total_sanction_loan_amt' => $total_sanction_loan_amt,
                'total_commision_subtotal' => $total_commision_subtotal,
                'total_gst_amt' => $total_gst_amt,
                'gross_total_amount' => $gross_total,
                'tds_deducted' => $tds_amt,
                'net_receivable' => $total_commision_subtotal + $total_gst_amt - $tds_amt
            );
             if (!in_array($batchNumber, $emailed_batches)) {
                    $this->send_mail_hlc_generate_invoice($emailData, $connector_data->email, $connector_data->staff_fullname, $batchNumber);
                    $emailed_batches[] = $batchNumber; // Mark this batch as emailed
                }
                
                $response['status'] = 'success';
                $response['message'] = 'Invoices generated successfully';
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Invalid row selected for invoice generation fill all data';
            }
        }

        $this->db->trans_complete();
    } else {
        $response['status'] = 'error';
        $response['message'] = 'No rows selected for invoice generation';
    }

    echo json_encode($response);
}*/



/*public function generate_invoice_hlc() {
    $invoice_date = $this->input->post('invoice_date');
    $invoice_type = $this->input->post('inv_type');
    $selectedRows = json_decode($this->input->post('selectedRows'), true);
    $response = array();

    if (!empty($selectedRows)) {
        $this->db->trans_start();
        
        $batches = array();
        
        foreach ($selectedRows as $rowID) {
            $user_data = $this->db->select("*")->where(['id' => $rowID])->from('mst_user')->get()->row();
            $connector_data = $this->db->get_where('mst_staff', ['staff_id' => $user_data->connector_id])->row();
            
            // Check if the current account is an RR account associated with a main account
            $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $rowID, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
             
            $currentDateTime = date("YmdHis");
            $batchNumber = $invoice_type . $currentDateTime;
           
            $invoiceNumber = $this->generate_same_invoice_number_within_batch($connector_data->hlc_code, $connector_data->staff_id, $batchNumber);
            
            // Check conditions for generating invoice
            if ($user_data->disb_status == 'yes' && 
                empty($user_data->invoice_id) && 
                !is_null($user_data->sanction_amt) && 
                empty($user_data->applicant_invoice_status) && 
                !is_null($user_data->disb_date)) {
                
                // Validate if invoice_date is after disb_date
                if ($user_data->disb_date > $invoice_date) {
                    $response['status'] = 'error';
                    $response['message'] = 'Invoice Date must be after Disbursement Date for ID: ' . $rowID;
                    continue; // Skip to the next iteration if validation fails
                }
                
                if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                    $loan_type_id = 5;
                    $loanAmt = $rr_main_account->sanction_amt;
                    $sanction_loan_Amt = $user_data->rinnraksha_amt;
                    $premiumAmt = $user_data->rinnraksha_amt;
                    if ($loanAmt < 5000000) {
                        $commission = 4000;
                    } elseif ($loanAmt >= 5000000 && $loanAmt < 10000000) {
                        $commission = 5000;
                    } elseif ($loanAmt >= 10000000) {
                        $commission = 6000;
                    } else {
                        $commission = 0;
                    }
                    
                    if($rr_main_account->loan_type_id==4){
                        $commissionRate = 0.20;
                    }else{
                        $commissionRate = $connector_data->conn_commision;
                    }
                    
                    $hlc_comm = $premiumAmt * $commissionRate/100;
                    $totalCommission = $commission + $hlc_comm;
                } else {
                    $sanction_loan_Amt = $user_data->sanction_amt;
                    $loan_type_id = $user_data->loan_type_id;
                    $loanAmt = $user_data->sanction_amt;
                    if($user_data->loan_type_id==4){
                        $commissionRate = 0.20;
                    }else{
                        $commissionRate = $connector_data->conn_commision;
                    }
                    
                    $totalCommission = $loanAmt * $commissionRate/100;
                }
                
                $gstPercentage = empty($connector_data->gst_no) ? 0 : 18; // Check if GST number is empty
                $gst = $gstPercentage / 100 * $totalCommission;
                $netPayamt_hlc = $totalCommission + $gst;

                if (!isset($batches[$batchNumber])) {
                    $batches[$batchNumber] = array(
                        'connector_id' => $user_data->connector_id,
                        'email' => $connector_data->email,
                        'staff_fullname' => $connector_data->staff_fullname,
                        'total_sanction_loan_amt' => 0,
                        'total_commision_subtotal' => 0,
                        'total_gst_amt' => 0,
                        'gross_total' => 0,
                        'rows' => array()
                    );
                }
                
                $batches[$batchNumber]['total_sanction_loan_amt'] += $sanction_loan_Amt;
                $batches[$batchNumber]['total_commision_subtotal'] += $totalCommission;
                $batches[$batchNumber]['total_gst_amt'] += $gst;
                $batches[$batchNumber]['gross_total'] += $netPayamt_hlc;
                $batches[$batchNumber]['rows'][] = array(
                    'invoice_number' => $invoiceNumber,
                    'inv_batchno' => $batchNumber,
                    'connector_id' => $user_data->connector_id,
                    'branch_id' => $user_data->branch_id,
                    'user_id' => $rowID,
                    'loan_amt' => $sanction_loan_Amt,
                    'loan_type_id' => $loan_type_id,
                    'commission_type' => 'Percent',
                    'commission_amt' => $commissionRate,
                    'total_commission' => $totalCommission,
                    'invoice_type' => $invoice_type,
                    'invoice_date' => $invoice_date,
                    'net_payment' => $netPayamt_hlc,
                    'created_by' => $_SESSION['staff_id']
                );
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Invalid row selected for invoice generation. Fill all data';
            }
        }

        // Insert all data and send email per batch
        foreach ($batches as $batchNumber => $batchData) {
            foreach ($batchData['rows'] as $data) {
                $this->db->insert('invoices', $data);
                $last_invoice_id = $this->db->insert_id();
                
                // Update user's record based on invoice type
                $updateData = array();
                if ($invoice_type == 'inv_hlc') {
                    $updateData = ['invoice_id' => $last_invoice_id, 'applicant_invoice_status' => 'Generated', 'sbi_genrated' => 'No'];
                }
                $this->db->where('id', $data['user_id']);
                $this->db->update('mst_user', $updateData);
            }
            
            $tds_amt = $batchData['total_commision_subtotal'] * 5 / 100;
            $emailData = array(
                'invoice_number' => $batchData['rows'][0]['invoice_number'], // Using the first invoice number in the batch
                'invoice_date' => $invoice_date,
                'total_sanction_loan_amt' => $batchData['total_sanction_loan_amt'],
                'total_commision_subtotal' => $batchData['total_commision_subtotal'],
                'total_gst_amt' => $batchData['total_gst_amt'],
                'gross_total_amount' => $batchData['gross_total'],
                'tds_deducted' => $tds_amt,
                'net_receivable' => $batchData['total_commision_subtotal'] + $batchData['total_gst_amt'] - $tds_amt,
                'batch_number' => $batchData['rows'][0]['inv_batchno'] // Include the batch number
            );

            // Send email once per batch
            //$this->send_mail_hlc_generate_invoice($emailData, $batchData['email'], $batchData['staff_fullname'], $batchData['rows'][0]['inv_batchno']);
        }
        
        $this->db->trans_complete();
        
        $response['status'] = 'success';
        $response['message'] = 'Invoices generated and emails sent successfully';
    } else {
        $response['status'] = 'error';
        $response['message'] = 'No rows selected for invoice generation';
    }

    echo json_encode($response);
}*/


/*public function generate_invoice_hlc() {
    $invoice_date = $this->input->post('invoice_date');
    $invoice_type = $this->input->post('inv_type');
    $selectedRows = json_decode($this->input->post('selectedRows'), true);
    $response = array();

    if (!empty($selectedRows)) {
        $this->db->trans_start();  // Start transaction
        $batches = array();

        foreach ($selectedRows as $rowID) {
            $user_data = $this->db->select("*")->where(['id' => $rowID])->from('mst_user')->get()->row();
            $connector_data = $this->db->get_where('mst_staff', ['staff_id' => $user_data->connector_id])->row();
            $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $rowID, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
            $currentDateTime = date("YmdHis");
            $batchNumber = $invoice_type . $currentDateTime . '_' . $user_data->connector_id; // Unique batch number per connector
            $invoiceNumber = $this->generate_hlc_invoice_number($connector_data->hlc_code, $connector_data->staff_id, $batchNumber);

            if ($this->can_generate_invoice($user_data, $invoice_date)) {
                $invoice_data = $this->calculate_invoice_data($user_data, $connector_data, $rr_main_account, $invoice_date, $invoice_type, $batchNumber, $invoiceNumber);
                $this->add_to_batches($batches, $user_data->connector_id, $batchNumber, $invoice_data, $connector_data);
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Invalid row selected for invoice generation. Fill all data';
            }
        }

        $this->process_batches($batches, $invoice_date);

        $this->db->trans_complete();  // Complete transaction

        $response['status'] = 'success';
        $response['message'] = 'Invoices generated and emails sent successfully';
    } else {
        $response['status'] = 'error';
        $response['message'] = 'No rows selected for invoice generation';
    }

    echo json_encode($response);
}*/


public function generate_invoice_hlc() {
    $invoice_date = $this->input->post('invoice_date');
    $invoice_type = $this->input->post('inv_type');
    $selectedRows = json_decode($this->input->post('selectedRows'), true);
    $response = array();

    if (!empty($selectedRows)) {
        $this->db->trans_start();
        $batches = array();

        foreach ($selectedRows as $rowID) {
            $user_data = $this->db->select("*")->where(['id' => $rowID])->from('mst_user')->get()->row();
            $error_message = '';

            if ($this->can_generate_invoice($user_data, $invoice_date, $error_message)) {
                $connector_data = $this->db->get_where('mst_staff', ['staff_id' => $user_data->connector_id])->row();
                $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $rowID, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
                $currentDateTime = date("YmdHis");
                $batchNumber = $invoice_type . $currentDateTime . '_' . $user_data->connector_id;
                $invoiceNumber = $this->generate_hlc_invoice_number($connector_data->hlc_code, $connector_data->staff_id, $batchNumber);

                $invoice_data = $this->calculate_invoice_data($user_data, $connector_data, $rr_main_account, $invoice_date, $invoice_type, $batchNumber, $invoiceNumber);
                $this->add_to_batches($batches, $user_data->connector_id, $batchNumber, $invoice_data, $connector_data);
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Row ID ' . $rowID . ': ' . $error_message;
                echo json_encode($response);
                return;
            }
        }

        $this->process_batches($batches, $invoice_date);
        $this->db->trans_complete();

        $response['status'] = 'success';
        $response['message'] = 'Invoices generated and emails sent successfully';
    } else {
        $response['status'] = 'error';
        $response['message'] = 'No rows selected for invoice generation';
    }

    echo json_encode($response);
}


private function can_generate_invoice($user_data, $invoice_date, &$error_message) {
    // Example: session financial year stored like '24-25'
    $session_fy = $this->session->userdata('financial_year');

    // Convert disb_date to a DateTime object
    $disb_date = new DateTime($user_data->disb_date);
    $disb_year = (int)$disb_date->format('Y');
    $disb_month = (int)$disb_date->format('m');

    // Determine the financial year of disb_date
    if ($disb_month >= 4) {
        $disb_fy = substr($disb_year, -2) . '-' . substr($disb_year + 1, -2);
    } else {
        $disb_fy = substr($disb_year - 1, -2) . '-' . substr($disb_year, -2);
    }

    // Compare session FY with disbursement FY
    if ($disb_fy !== $session_fy) {
        $error_message = "Disbursement date doesn't belong to financial year $session_fy.";
        return false;
    }

    // Existing validations
    if ($user_data->disb_status !== 'yes') {
        $error_message = 'Disbursement status must be "yes".';
        return false;
    }
    if (!empty($user_data->invoice_id)) {
        $error_message = 'Invoice already generated for this user.';
        return false;
    }
    if ($user_data->loan_type_id == 5) {
        if (is_null($user_data->rinnraksha_amt) || $user_data->rinnraksha_amt === '0.00') {
            $error_message = 'Rinnraksha amount must be a valid non-zero amount for loan type ID 5.';
            return false;
        }
    } else {
        if (is_null($user_data->sanction_amt) || $user_data->sanction_amt === '0.00') {
            $error_message = 'Sanction amount must be a valid non-zero amount.';
            return false;
        }
    }
    if (!empty($user_data->applicant_invoice_status)) {
        $error_message = 'Applicant invoice status must be empty.';
        return false;
    }
    if (is_null($user_data->disb_date)) {
        $error_message = 'Disbursement date is missing.';
        return false;
    }
    if (is_null($user_data->part_payout) || $user_data->part_payout === '0.00') {
        $error_message = 'Part payout must be a valid non-zero amount.';
        return false;
    }
    if ($user_data->is_archive !== 'No') {
        $error_message = 'Archived records cannot be invoiced.';
        return false;
    }
    if ($user_data->disb_date > $invoice_date) {
        $error_message = 'Disbursement date is later than the invoice date.';
        return false;
    }

    return true;
}




private function calculate_invoice_data($user_data, $connector_data, $rr_main_account, $invoice_date, $invoice_type, $batchNumber, $invoiceNumber) {
    // Calculate commission, GST, and net payment amounts based on user and connector data
    // Return an array with the calculated invoice data
    $sanction_loan_Amt = $user_data->sanction_amt;
    $loan_type_id = $user_data->loan_type_id;
    $disb_date = $user_data->disb_date;
    $loanAmt = $user_data->sanction_amt;
    $commissionRate = $user_data->loan_type_id == 4 ? 0.20 : $user_data->part_payout;
    $totalCommission = $loanAmt * $commissionRate / 100;
    $gstPercentage = empty($connector_data->gst_no) ? 0 : 18;
    $gst = $gstPercentage / 100 * $totalCommission;
    $netPayamt_hlc = $totalCommission + $gst;
    
   $disb_timestamp = strtotime($disb_date);

// Get current year
$current_year = date('Y');

// If current month is before April, we are still in the financial year that ends this March
if (date('m') < 4) {
    $fy_start_year = $current_year - 1;
    $fy_end_year = $current_year;
} else {
    $fy_start_year = $current_year;
    $fy_end_year = $current_year + 1;
}

// Define November 1 of previous year and March 31 of current year
$start_nov = strtotime($fy_start_year . '-11-01');
$end_march = strtotime($fy_end_year . '-03-31');

if ($disb_timestamp >= $start_nov && $disb_timestamp <= $end_march) {
    $final_invoice_date = $fy_end_year . '-03-31';
} else {
    $final_invoice_date = $invoice_date;
}


    return array(
        'invoice_number' => $invoiceNumber,
        'inv_batchno' => $batchNumber,
        'connector_id' => $user_data->connector_id,
        'branch_id' => $user_data->branch_id,
        'user_id' => $user_data->id,
        'loan_amt' => $sanction_loan_Amt,
        'loan_type_id' => $loan_type_id,
        'commission_type' => 'Percent',
        'commission_amt' => $commissionRate,
        'total_commission' => $totalCommission,
        'invoice_type' => $invoice_type,
        'invoice_date' => $final_invoice_date,
        'net_payment' => $netPayamt_hlc,
        'created_by' => $_SESSION['staff_id']
    );
}

private function add_to_batches(&$batches, $connector_id, $batchNumber, $invoice_data, $connector_data) {
    // Add invoice data to the corresponding batch
    if (!isset($batches[$connector_id])) {
        $batches[$connector_id] = array();
    }

    if (!isset($batches[$connector_id][$batchNumber])) {
        $batches[$connector_id][$batchNumber] = array(
            'connector_id' => $invoice_data['connector_id'],
            'email' => $connector_data->email,
            'staff_fullname' => $connector_data->staff_fullname,
            'total_sanction_loan_amt' => 0,
            'total_commision_subtotal' => 0,
            'total_gst_amt' => 0,
            'gross_total' => 0,
            'rows' => array()
        );
    }

    $batches[$connector_id][$batchNumber]['total_sanction_loan_amt'] += $invoice_data['loan_amt'];
    $batches[$connector_id][$batchNumber]['total_commision_subtotal'] += $invoice_data['total_commission'];
    $batches[$connector_id][$batchNumber]['total_gst_amt'] += $invoice_data['net_payment'] - $invoice_data['total_commission'];
    $batches[$connector_id][$batchNumber]['gross_total'] += $invoice_data['net_payment'];
    $batches[$connector_id][$batchNumber]['rows'][] = $invoice_data;
}

private function process_batches($batches, $invoice_date) {
    // Process each batch: insert invoice data into the database and send email notifications
    foreach ($batches as $connector_batches) {
        foreach ($connector_batches as $batchNumber => $batchData) {
            foreach ($batchData['rows'] as $data) {
                $this->db->insert('invoices', $data);
                $last_invoice_id = $this->db->insert_id();
                $updateData = $this->get_update_data_for_user($data, $last_invoice_id);
                $this->db->where('id', $data['user_id']);
                $this->db->update('mst_user', $updateData);
            }
            $this->send_batch_email($batchData, $invoice_date);
        }
    }
}

private function get_update_data_for_user($data, $last_invoice_id) {
    // Get the update data for the user based on the invoice type
    if ($data['invoice_type'] == 'inv_hlc') {
        return ['invoice_id' => $last_invoice_id, 'applicant_invoice_status' => 'Generated', 'sbi_genrated' => 'No'];
    }
    // Add more conditions if needed
    return [];
}

private function send_batch_email($batchData, $invoice_date) {
    // Prepare email data and send email for the batch
    $tds_amt = $batchData['total_commision_subtotal'] * 5 / 100;
    $emailData = array(
        'invoice_number' => $batchData['rows'][0]['invoice_number'],
        'invoice_date' => $invoice_date,
        'total_sanction_loan_amt' => $batchData['total_sanction_loan_amt'],
        'total_commision_subtotal' => $batchData['total_commision_subtotal'],
        'total_gst_amt' => $batchData['total_gst_amt'],
        'gross_total_amount' => $batchData['gross_total'],
        'tds_deducted' => $tds_amt,
        'net_receivable' => $batchData['total_commision_subtotal'] + $batchData['total_gst_amt'] - $tds_amt,
        'batch_number' => $batchData['rows'][0]['inv_batchno']
    );
    // Uncomment the line below to send email
    // $this->send_mail_hlc_generate_invoice($emailData, $batchData['email'], $batchData['staff_fullname'], $batchData['rows'][0]['inv_batchno']);
}



public function send_mail_hlc_generate_invoice($data,$email,$name,$batchNumber){
$phpMailerLib = new PHPMailerLib();

    // Email content
    $to = $email;
    $bcc ='deepalisangale3@gmail.com';
    $subject = 'Your Invoice - ' . $data['invoice_number'] . ' for MortgageBuddy Has Been Generated';
    $message = "Dear " . $name . ",<br><br>";
    $message .= "Please find attached your invoice for MortgageBuddy.<br><br>";
    $message .= "<b>Invoice Details:</b><br><br>";
    $message .= "<b>Invoice Number:</b> " . $data['invoice_number'] . "<br>";
    $message .= "<b>Invoice Date:</b> " . $data['invoice_date'] . "<br>";
    $message .= "<b>Sub Total Amount:</b> " . $this->formatIndianNumber($data['total_commision_subtotal']) . "<br>";
    $message .= "<b>GST Amount:</b> " . $this->formatIndianNumber($data['total_gst_amt']) . "<br>";
    $message .= "<b>Gross Total Amount:</b> " . $data['gross_total_amount'] . "<br>";
    $message .= "<b>TDS Deducted:</b> " . $this->formatIndianNumber($data['tds_deducted']) . "<br>";
    $message .= "<b>Net Receivable:</b> " . $this->formatIndianNumber($data['net_receivable']) . "<br><br>";
    $message .= "Please reply with a <b>signed copy of this invoice</b> and other required documents to this email at the earliest so that I can process your payment.<br><br>";
    $message .= "<b>Note:</b> Payment will be processed only after receiving the compulsory documents.<br><br>";
    $message .= "<b>Thanks & Regards,</b><br>";
    $message .= "Accounts Team<br>";
    $message .= "MortgageBuddy Private Limited<br>";
    $message .= "<img src='" . base_url() . "assets/site_img/mailfooterlogo.jpg' alt='MortgageBuddy Logo'>";


     $pdf_path = $this->generate_and_save_pdf_hlc($batchNumber);
    // Send email
    if ($phpMailerLib->sendEmail_hlc_invoice($to, $subject, $message, $bcc, $pdf_path)) {
        // Delete the PDF after sending email
         unlink($pdf_path);
    } else {
        //echo 'Email could not be sent';
    }
}

public function generate_and_save_pdf_hlc($invoice_no) {
     $this->load->library('Invoice_order_hlc');
     
    $data['invoice_items'] = $this->db
    ->select('*')
    ->from('invoices')
    ->where(['inv_batchno' => $invoice_no])
    ->order_by('id', 'asc')
    ->get()
    ->result_array();

    $firstInvoiceItem = reset($data['invoice_items']);
    $connectorID = isset($firstInvoiceItem['connector_id']) ? $firstInvoiceItem['connector_id'] : null;
    $branchID = isset($firstInvoiceItem['branch_id']) ? $firstInvoiceItem['branch_id'] : null;
    $invoiceDate = isset($firstInvoiceItem['invoice_date']) ? $firstInvoiceItem['invoice_date'] : null;
    $invoiceType = isset($firstInvoiceItem['invoice_type']) ? $firstInvoiceItem['invoice_type'] : null;
    $invoiceNumber = isset($firstInvoiceItem['invoice_number']) ? $firstInvoiceItem['invoice_number'] : null;
    $connector = $this->db->select("*")->from('mst_staff')->where(['staff_id' => $connectorID, 'staff_type' => 1])->get()->row();
    $data['branch'] = $this->db->select("*")->from('branch')->where(['id' => $branchID])->get()->row();
    $paid_invoice = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoice_no])->order_by('add_date', 'DESC')->limit(1)->get()->row();
    $data['invoice_date'] = $invoiceDate;
    $data['invoice_type'] = $invoiceType;
    $data['invoice_num'] = $invoiceNumber;
    // Create new TCPDF instance
    $pdf = new Invoice_order_hlc('P', 'mm', 'A4', true, 'UTF-8', false);
    $inv_no = str_replace('/', '_', $invoiceNumber);
    // Set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Mortgagebuddy');
    $pdf->SetTitle($invoiceNumber);
    $pdf->SetSubject('Invoice');
    $pdf->SetKeywords('Invoice, PDF, Example');
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM); // Set auto page breaks
    // Set font
    $pdf->SetFont('dejavusans', '', 6);
    $pdf->SetCellPaddings(1, 2, 1, 1);
    $pdf->SetMargins(10, 20, 10);
    $pdf->AddPage();
    $pdf->SetMargins(10, 45, 10);
    // Set some content to display
    //$html = $this->load->view('admin/manage_invoice/invoice_hlc_pdf', $data, true);
    
    $html = '
        <table width="100%">
            <tr>
                <td style="text-align: left; padding-left: 0;">
                    <strong>From</strong><br>
                    Name: ' . $connector->staff_fullname . '<br>
                    Address: <address>' . $connector->staff_address . '</address><br>
                    PAN No.: ' . $connector->pan_no . '<br>
                    GSTIN No.:' . $connector->gst_no . '<br>
                    Mobile No.: ' . $connector->mobile . '<br>
                    E-mail ID:' . $connector->email . '
                </td>
                <td style="text-align: left; padding-left: 0;">
                    <strong>To</strong><br>
                    MORTGAGEBUDDY PRIVATE LIMITED<br>
                    GSTIN NO: 27AAQCM2355K1ZZ<br>
                    HSN Code:
                </td>
                <td style="text-align: left; padding-left: 0;">
                    <strong>Date:</strong> '.date('F d,Y',strtotime($data['invoice_date'])).'<br>
                    <strong>Invoice No:</strong> '.$invoiceNumber.'
                </td>
            </tr>
        </table>
        ';
        
        $html .= '<style>
    .table-bordered {
        border-collapse: collapse;
       
    }
    .table-bordered th,
    .table-bordered td {
        border: 0.1px solid #00; /* Border color */
        padding: 8px; /* Adjust padding as needed */
    }
</style>
<br><br><br>
<table class="table table-invoice table-bordered">
    <thead>
        <tr style="background-color: #d9e1f2;text-align:center;">
            <th style="width:4%;">Sr. No</th>
            <th style="width:12%;">Los ID</th>
            <th style="width:13%;">Name Of Customer</th>
            <th>Loan Type</th>
            <th>Branch Name</th>
            <th style="width:11%;">CBS A/C No</th>
            <th>Disburs Date</th>
            <th>Sanctioned Loan Amount</th>
            <th>Commission<br> %</th>
            <th>Commission Amount Rs</th>
        </tr>
    </thead>
    <tbody>
';
if (!empty($data['invoice_items'])) {
    $totalLoanAmt = 0;
    $totalCommisionAmt = 0;
    $cgst =0; $sgst =0; $igst =0;
    foreach ($data['invoice_items'] as $key => $row) {
        $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $row['user_id']])->get()->row();
        $type_data = $this->db->select("*")->from('mst_loan_type')->where(['id' => $user_data->loan_type_id])->get()->row();
        $branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();

        $totalLoanAmt += $row['loan_amt'];
        $totalCommisionAmt += $row['total_commission'];

        $mbgstcode = 13;
       
        if ($mbgstcode == $connector->circle_id) {
            $cgst = empty($connector->gst_no) ? 0 : (9 / 100 * $totalCommisionAmt);
            $sgst = empty($connector->gst_no) ? 0 : (9 / 100 * $totalCommisionAmt);
        } else {
            $igst = empty($connector->gst_no) ? 0 : (18 / 100 * $totalCommisionAmt);
        }

        $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $row['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();

        $html .= '
        <tr>
            <td style="width:4%;">' . ($key + 1) . '</td>
            <td style="width:12%;">' . $user_data->los_id . '</td>
            <td style="width:13%;">' . $user_data->user_name . '</td>
            <td>' . $type_data->name . '</td>
            <td>' . $branch->branch_name . ' [' . $branch->branch_code . ']</td>
            <td style="width:11%;">' . ($row['loan_type_id'] == 5 ? $user_data->rr_cbs_acct_no : $user_data->bank_acct_no) . '</td>
            <td>' . date('d.m.Y', strtotime($user_data->disb_date)) . '</td>
            <td>' . $this->formatIndianNumber($row['loan_amt']) . '</td>
            <td>' . $row['commission_amt'] . '%</td>
        ';

        if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
            $premiumAmt = $user_data->rinnraksha_amt;
            $premiumCommission = $premiumAmt * $row['commission_amt'] / 100;
            $html .= '<td>' . $this->formatIndianNumber($premiumCommission) . '</td>';
        } else {
            $html .= '<td>' . $this->formatIndianNumber($row['total_commission']) . '</td>';
        }

        $html .= '</tr>';

        if ($row['loan_type_id'] == 5) {
            $html .= '
            <tr>
                <td style="width:4%;"></td>
                <td style="width:12%;">' . $user_data->los_id . '</td>
                <td style="width:13%;">' . $user_data->user_name . '</td>
                <td style="text-align:left;">RR Commission</td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
            ';

            if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                $rr_sanction_amt = $this->db->select("*")->where(['id' => $rr_aact->id])->from('mst_user')->get()->row();
                $sanctionAmt = @$rr_sanction_amt->sanction_amt;
                $premiumAmt = $user_data->rinnraksha_amt;
                $premiumCommission = $premiumAmt * $user_data->part_payout / 100;

               if ($sanctionAmt == 5000000) {
                    // If the sanction amount is exactly 50 lakh, set commission to 4000
                    $commission = 4000;
                } elseif ($sanctionAmt >= 100000 && $sanctionAmt < 5000000) {
                    $commission = 4000;
                } elseif ($sanctionAmt > 5000000 && $sanctionAmt < 10000000) {
                    $commission = 5000;
                } elseif ($sanctionAmt >= 10000000) {
                    $commission = 6000;
                } else {
                    $commission = 0;
                }

                $html .= '<td>' . $this->formatIndianNumber($commission) . '</td>';
            } else {
                $html .= '<td>' . $this->formatIndianNumber($row['total_commission']) . '</td>';
            }

            $html .= '</tr>';
        }
        
    }
}
 $gstPercentage = empty($connector->gst_no) ? 0 : 18; 
 $gst = $gstPercentage / 100 * $totalCommisionAmt;
 $netPayamt = $totalCommisionAmt + $gst;
 $tds = $totalCommisionAmt*5/100;
 $netPayamtAll = $totalCommisionAmt + $gst - $tds;
 
 $html .='<tr>
          <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td>-</td>
           <td>-</td>
        </tr>
        <tr>
           <td colspan="5" rowspan="7">';
          if (@$paid_invoice->status == "paid") {
            $html .= '
                <table style="width:100%;">
                    <tr>
                        <td style="width:40%;">
                            <img src="'.base_url().'assets/site_img/paid-stamp.png" height="100">
                        </td>
                        <td style="width:60%; text-align:left;">
                            <p>Payment Date: '.date('d-m-Y',strtotime($paid_invoice->payment_date)).'</p>
                            <p>Payment Amount: Rs '.$paid_invoice->pay_amt.'</p>
                            <p>Ref No/Cheq No: '.$paid_invoice->bank_details.'</p>
                            <p>Remark: '.$paid_invoice->remark.'</p>
                        </td>
                    </tr>
                </table>';
        } else {
            $html .= 'unpaid';
        }
    $html .='</td>
           <td colspan="2" style="text-align:right;"><b>Sub Total</b></td>
            <td><strong>'.$this->formatIndianNumber($totalLoanAmt).'</strong></td>
           <td></td>
           <td><strong>'.$this->formatIndianNumber($totalCommisionAmt).'</strong></td>
        </tr>
        <tr>
           <td colspan="2" style="text-align:right;"><b>Tax Amount - CGST 9%</b></td>
            <td></td>
           <td>-</td>
           <td>'. (empty($cgst) ? '-' : $this->formatIndianNumber($cgst)) . '</td>
        </tr>
        <tr>
          
           <td colspan="2" style="text-align:right;"><b>Tax Amount - SGST 9%</b></td>
            <td></td>
          
           <td>-</td>
            <td>'. (empty($sgst) ? '-' : $this->formatIndianNumber($sgst)) . '</td>
        </tr>
         <tr>
         
           <td colspan="2" style="text-align:right;"><b>Tax Amount - IGST 18%</b></td>
            <td></td>
            <td>-</td>
            <td>'. (empty($igst) ? '-' : $this->formatIndianNumber($igst)) . '</td>
        </tr>
        <tr>
           
           <td colspan="2" style="text-align:right;"><b>Gross Total</b></td>
            <td></td>
           <td></td>
           <td><strong>'. $this->formatIndianNumber($netPayamt).'</strong></td>
        </tr>
        <tr>
           
           <td colspan="2" style="text-align:right;"><b>Less: TDS @ 5%</b></td>
            <td></td>
           <td></td>
           <td><strong>'.$this->formatIndianNumber($tds).'</strong></td>
        </tr>
        <tr>
          
           <td colspan="2" style="text-align:right;"><b>Net Total</b></td>
            <td></td>
           <td></td>
           <td><strong>'.$this->formatIndianNumber($netPayamtAll).'</strong></td>
        </tr>
                    
                   </tbody>
                </table>
 <p>I confrim that above housing proposal has been disbursed from mentioned branch on MortgageBuddy Private Limited HLC code(MUMHLC03147).</p>
 <br><br>
 <table class="table">
    <tr class="align-items-center mt-5">
       <td width="40%">
            <p class="mb-0"><strong>Rs.(In words): '. ucfirst($this->getIndianCurrency($netPayamtAll)) . ' only</strong></p>
        </td>
        <td width="30%">
           
        </td>
        <td width="40%" style="text-algin:right;">
            <p class="mb-0">Signature</p>
        </td>
    </tr>
</table>
<br><br><br><br>
 <table style="width:30%;">
            <tr>
                <td><strong>Type of Account :</strong></td>
                <td>'.$connector->bank_acct_type.'</td>
            </tr>
            <tr>
                <td><strong>Account No. :</strong></td>
                <td>'.$connector->bank_acct_no.'</td>
            </tr>
            <tr>
                <td><strong>IFSC code:</strong></td>
                <td>'.$connector->bank_ifsc.'</td>
            </tr>
        </table>
';

    // Write the HTML content to the PDF
    $pdf->writeHTML($html, true, false, true, false, '');
    
    $file_path = FCPATH . 'assets/uploads/invoices_hlc/' . $invoiceNumber . '.pdf';
    $pdf->Output($file_path, 'F'); // 'F' stands for file
    
     if (!file_exists($file_path)) {
        die('Error: The file could not be created.');
    }

    return $file_path;
}




private function generate_hlc_invoice_number($hlc_code, $staff_id) {
    // Start a transaction
    $this->db->trans_start();

    // Lock the table to prevent concurrent access
    $this->db->query('LOCK TABLES invoices WRITE');

    // Get the last invoice number for the given staff ID
    $lastInvoice = $this->db->select('invoice_number')
                            ->where('connector_id', $staff_id)
                            ->where('invoice_type', 'inv_hlc')
                            ->order_by('id', 'DESC')
                            ->limit(1)
                            ->get('invoices')
                            ->row();

    // Check if a valid invoice number is retrieved
    if ($lastInvoice) {
        // Extract the numeric part after the HLC code and increment it
        $lastInvoiceNumber = intval(substr($lastInvoice->invoice_number, strlen($hlc_code)));
    } else {
        // If no invoice number is found, start from 1
        $lastInvoiceNumber = 0;
    }

    // Increment the invoice number
    $nextInvoiceNumber = $lastInvoiceNumber + 1;

    // Concatenate with the HLC code and pad with zeros
    $nextInvoiceNumberPadded = str_pad($nextInvoiceNumber, 3, '0', STR_PAD_LEFT);

    // Concatenate with the HLC code
    $newInvoiceNumber = $hlc_code . $nextInvoiceNumberPadded;

    // Unlock the table
    $this->db->query('UNLOCK TABLES');

    // Complete the transaction
    $this->db->trans_complete();

    if ($this->db->trans_status() === FALSE) {
        // If there was any issue with the transaction, handle the error
        throw new Exception('Failed to generate a new invoice number');
    }

    return $newInvoiceNumber;
}



public function delete_invoice_hlc($inv_batchno) {
    $this->db->trans_start();

    // Fetch invoice data
    $invoice_data = $this->db->select("*")->where(['inv_batchno' => $inv_batchno])->from('invoices')->get()->result_array();
    // Fetch invoice log
    $invoice_log = $this->db->select("*")->where(['invoice_batchno' => $inv_batchno])->from('invoice_log')->get()->row();
    
    // If the invoice log is empty, proceed with deletion
    if (empty($invoice_log->invoice_batchno)) {
        foreach ($invoice_data as $invoice) {
            // Fetch user data associated with the invoice
            $user_data = $this->db->select("*")->where(['id' => $invoice['user_id']])->from('mst_user')->get()->row();

            if ($user_data->sbi_genrated != 'Yes') {
                // Update user data only if sbi_genrated is not 'Yes'
                $this->db->set('applicant_invoice_status', NULL);
                $this->db->set('invoice_id', NULL);
                //$this->db->set('disb_date', NULL);
                //$this->db->set('disb_status', 'no');
                $this->db->set('sbi_genrated', 'No');
                $this->db->where('id', $user_data->id);
                $this->db->update('mst_user');
                
                  $deleted_log = array(
                        'inv_batchno' => $invoice['inv_batchno'],
                        'invoice_number' => $invoice['invoice_number'],
                        'user_id' => $invoice['user_id'],
                        'invoice_date' => $invoice['invoice_date'],
                        'deleted_at' => date('Y-m-d H:i:s'),
                        'inv_type' => 'inv_hlc',
                        'deleted_by' => $this->session->userdata('staff_id'), // Assuming you have user session data
                        'invoice_data' => json_encode($invoice) // Encode the entire invoice as JSON
                    );
               
                $this->db->insert('deleted_invoice_log', $deleted_log);
                
            } else {
                // If sbi_genrated is 'Yes', roll back transaction and return error message
                $this->db->trans_rollback();
                $message = array('success' => '0', 'type' => 'error', 'message' => 'This invoice cannot be deleted as it is marked as SBI generated.');
                echo json_encode($message);
                return;
            }
        }

        // Delete the invoice from the database
        $this->db->where('inv_batchno', $inv_batchno);
        $this->db->delete('invoices');
    } else {
        // If invoice log is not empty, return appropriate message
        $message = array('success' => '0', 'type' => 'error', 'message' => 'This invoice is either under payment processing or has been paid.');
        echo json_encode($message);
        return;
    }

    // Complete transaction
    $this->db->trans_complete();

    if ($this->db->trans_status() === FALSE) {
        // If transaction fails, return error message
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Transaction failed. Please try again.');
    } else {
        // If transaction succeeds, return success message
        $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully.');
    }

    echo json_encode($message);
}


public function delete_invoice_sbi($inv_batchno) {
    $this->db->trans_start();

    $invoice_data = $this->db->select("*")->where(['inv_batchno' => $inv_batchno])->from('invoices')->get()->result_array();
    // Fetch invoice log
    $invoice_log = $this->db->select("*")->where(['invoice_batchno' => $inv_batchno])->from('invoice_log')->get()->row();
    
    // If the invoice log is empty, proceed with deletion
    if (empty($invoice_log->invoice_batchno)) {

        foreach ($invoice_data as $invoice) {
            $user_data = $this->db->select("*")->where(['id' => $invoice['user_id']])->from('mst_user')->get()->row();

            $this->db->set('sbi_genrated', 'No');
            //$this->db->set('sbi_commi', NULL);
            //$this->db->set('commi_slab', NULL);
            $this->db->where('id', $user_data->id);
            $this->db->update('mst_user');

            // Save deleted invoice log
            $deleted_log = array(
                'inv_batchno' => $invoice['inv_batchno'],
                'invoice_number' => $invoice['invoice_number'],
                'user_id' => $invoice['user_id'],
                'invoice_date' => $invoice['invoice_date'],
                'deleted_at' => date('Y-m-d H:i:s'),
                'inv_type' => 'inv_sbi',
                'deleted_by' => $this->session->userdata('staff_id'), // Assuming you have user session data
                'invoice_data' => json_encode($invoice) // Encode the entire invoice as JSON
            );
            $this->db->insert('deleted_invoice_log', $deleted_log);
        }

        // Delete invoices
        $this->db->where('inv_batchno', $inv_batchno);
        $this->db->delete('invoices');
    } else {
        // If invoice log is not empty, return appropriate message
        $message = array('success' => '0', 'type' => 'error', 'message' => 'This invoice is either under payment processing or has been paid.');
        echo json_encode($message);
        return;
    }

    $this->db->trans_complete();

    if ($this->db->trans_status() === FALSE) {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Transaction failed. Please try again.');
    } else {
        $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully.');
    }

    echo json_encode($message);
}



public function delete_invoice_branch($inv_batchno) {
    $this->db->trans_start();

    $invoice_data = $this->db->select("*")->where(['inv_batchno' => $inv_batchno])->from('invoices')->get()->result_array();
    // Fetch invoice log
    $invoice_log = $this->db->select("*")->where(['invoice_batchno' => $inv_batchno])->from('invoice_log')->get()->row();
    
    // If the invoice log is empty, proceed with deletion
    if (empty($invoice_log->invoice_batchno)) {

    foreach ($invoice_data as $invoice) {
        $user_data = $this->db->select("*")->where(['id' => $invoice['user_id']])->from('mst_user')->get()->row();

        //if ($user_data->sbi_genrated != 'Yes') {
            // Only update mst_user if sbi_genrated is not 'Yes'
            //$this->db->set('applicant_invoice_status', NULL);
            //$this->db->set('invoice_id', NULL);
            //$this->db->set('disb_date', NULL);
            //$this->db->set('disb_status', 'no');
            $this->db->set('branch_genrated', null);
            $this->db->set('branch_invoice_id', null);
            $this->db->where('id', $user_data->id);
            $this->db->update('mst_user');
            
             $deleted_log = array(
                        'inv_batchno' => $invoice['inv_batchno'],
                        'invoice_number' => $invoice['invoice_number'],
                        'user_id' => $invoice['user_id'],
                        'invoice_date' => $invoice['invoice_date'],
                        'deleted_at' => date('Y-m-d H:i:s'),
                        'inv_type' => 'inv_branch',
                        'deleted_by' => $this->session->userdata('staff_id'), // Assuming you have user session data
                        'invoice_data' => json_encode($invoice) // Encode the entire invoice as JSON
                    );
               
                $this->db->insert('deleted_invoice_log', $deleted_log);
       /* } else {
            // Invoice can't be deleted, set an appropriate message
            $this->db->trans_rollback();
            $message = array('success' => '0', 'type' => 'error', 'message' => 'This invoice cannot be deleted as it is marked as SBI generated.');
            echo json_encode($message);
            return;
        }*/
    }

    // Check if sbi_genrated is 'Yes' before attempting to delete
    $this->db->where('inv_batchno', $inv_batchno);
    
    $this->db->delete('invoices');
    
    } else {
        // If invoice log is not empty, return appropriate message
        $message = array('success' => '0', 'type' => 'error', 'message' => 'This invoice is either under payment processing or has been paid.');
        echo json_encode($message);
        return;
    }

    $this->db->trans_complete();

    if ($this->db->trans_status() === FALSE) {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Transaction failed. Please try again.');
    } else {
        $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully.');
    }

    echo json_encode($message);
}

public function save_invoice_log_hlc() {
    
    if ($this->input->is_ajax_request()) {
        // Retrieve form data
        $invoiceId = $this->input->post('invoiceId');
        $paymentDate = $this->input->post('payment_date');
        $totPayable = $this->input->post('total_payable');
        $payAmt = $this->input->post('pay_amt');
        $tdsAmt = $this->input->post('tds_amt'); // no need
        $remark = $this->input->post('remark');
        $bankDetails = $this->input->post('bank_details');
        
        // Get invoice and connector data
        $inv_type = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceId])->get()->row();
        $conn_data = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $inv_type->connector_id])->get()->row();
        
        $netpay = $totPayable;

        // Get previous invoice logs
        $data['invoice_log'] = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceId])->get()->result_array();
        $totalpayamt = 0;

        foreach ($data['invoice_log'] as $val) {
            $totalpayamt += $val['pay_amt'];
        }
     
        $payAmt = is_numeric($payAmt) ? $payAmt : 0;
        $tot_paid_amt = $totalpayamt + $payAmt;
        $rmain_bal = $netpay - $tot_paid_amt;

        $last_entry = $this->db->select('*')
            ->from('invoice_log')
            ->where('invoice_batchno', $invoiceId)
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row();

        // Check if the last entry status is 'paid'
        
       /* if ($last_entry && $last_entry->status === 'paid') {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'This invoice has already been paid.');
            echo json_encode($message);
            return;
        }*/

        // Define a small tolerance value
        $tolerance = 100; // Adjust this value as needed
        $tot_paid_amt = number_format($tot_paid_amt, 2, '.', '');
        $netpay = number_format($netpay, 2, '.', '');
        $difference = $tot_paid_amt - $netpay;

        // Determine the status based on the difference
        if (abs($difference) <= $tolerance) {
            $status = 'paid'; 
        } elseif ($difference > $tolerance) {
            $status = 'excess paid';
        } else {
            $status = 'partly paid';
        }
        
        $data = array(
            'invoice_batchno' => $invoiceId,
            'status' => $status,
            'invoice_type' => $inv_type->invoice_type,
            'net_pay' => $netpay,
            'connector_id' => $conn_data->staff_id,
            'payment_date' => $paymentDate,
            'pay_amt' => $payAmt,
            'tds_amt' => $tdsAmt,
            'remark' => $remark,
            'bank_details' => $bankDetails,
            'created_by' => isset($_SESSION['staff_id']) ? $_SESSION['staff_id'] : null
        );
        
        // Try to insert into the database
        try {
            if ($this->db->insert('invoice_log', $data)) {
                $u_data = array('hlc_status' => $status);
                $pay_applicant_data = array('hlc_payment_status' => $status);
                
                $this->db->where('inv_batchno', $invoiceId);
                $this->db->update('invoices', $u_data);
                
                $user_ids = $this->db->select('user_id')->from('invoices')->where('inv_batchno', $invoiceId)->get()->result_array();
                foreach ($user_ids as $user_id_val) {
                    $this->db->where('id', $user_id_val['user_id']);
                    $this->db->update('mst_user', $pay_applicant_data);
                }
            }
            $message = array('success' => '0', 'type' => 'success', 'message' => 'Payment data saved successfully.');
        } catch (Exception $e) {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'Database error: ' . $e->getMessage());
        }
    } else {
        // Handle non-AJAX requests if needed
        $message = array('success' => '1', 'type' => 'error', 'message' => 'Failed. Please try again.');
    }

    echo json_encode($message);
}



//Knokoff

/*public function save_invoice_log_hlc() {
    if ($this->input->is_ajax_request()) {
        $invoiceId = $this->input->post('invoiceId');
        $paymentDate = $this->input->post('payment_date');
        $totPayable = $this->input->post('total_payable');
        $payAmt = $this->input->post('pay_amt');
        $remark = $this->input->post('remark');
        $bankDetails = $this->input->post('bank_details');

        // Get invoice and connector data
        $inv_type = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceId])->get()->row();
        $conn_data = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $inv_type->connector_id])->get()->row();
        $connector_id = $conn_data->staff_id;

        $netpay = $totPayable;
        
        // Get all previous "partly paid" invoices for this connector and invoice type
        $previous_invoices = $this->db->select('*')
            ->from('invoice_log')
            ->where(['connector_id' => $connector_id, 'status' => 'partly paid', 'invoice_type' => 'inv_hlc'])
            ->get()
            ->result_array();

        // Calculate the total unpaid balance from previous invoices
        $previous_balance = 0;
        foreach ($previous_invoices as $prev_invoice) {
            $previous_balance += $prev_invoice['net_pay'] - $prev_invoice['pay_amt'];
        }

        // Calculate total required payment and cumulative payment
        $total_required_payment = $netpay + $previous_balance; // Total required amount including previous unpaid balance
        $cumulative_payment = $payAmt + $previous_balance; // Total payment made including previous balance

        // Define tolerance
        $tolerance = 100; 
        $cumulative_payment = number_format($cumulative_payment, 2, '.', '');
        $total_required_payment = number_format($total_required_payment, 2, '.', '');
        $difference = $cumulative_payment - $total_required_payment;

        // Determine the status based on cumulative payment and tolerance
        if ($cumulative_payment >= $total_required_payment || abs($difference) <= $tolerance) {
            $status = 'paid';

            // Update all previous "partly paid" invoices to "paid"
            foreach ($previous_invoices as $prev_invoice) {
                $this->db->where('id', $prev_invoice['id']);
                $this->db->update('invoice_log', ['status' => 'paid']);
            }
        } elseif ($cumulative_payment < $total_required_payment) {
            $status = 'partly paid';
        } else {
            $status = 'excess paid';
        }

        $data = array(
            'invoice_batchno' => $invoiceId,
            'status' => $status,
            'invoice_type' => $inv_type->invoice_type,
            'net_pay' => $netpay,
            'connector_id' => $connector_id,
            'payment_date' => $paymentDate,
            'pay_amt' => $payAmt,
            'remark' => $remark,
            'bank_details' => $bankDetails,
            'created_by' => isset($_SESSION['staff_id']) ? $_SESSION['staff_id'] : null
        );

        try {
            if ($this->db->insert('invoice_log', $data)) {
                // Update the current invoice status to the determined status
                $u_data = array('hlc_status' => $status);
                $pay_applicant_data = array('hlc_payment_status' => $status);

                $this->db->where('inv_batchno', $invoiceId);
                $this->db->update('invoices', $u_data);

                // Update the status of the users related to the invoice
                $user_ids = $this->db->select('user_id')->from('invoices')->where('inv_batchno', $invoiceId)->get()->result_array();
                foreach ($user_ids as $user_id_val) {
                    $this->db->where('id', $user_id_val['user_id']);
                    $this->db->update('mst_user', $pay_applicant_data);
                }
            }
            $message = array('success' => '0', 'type' => 'success', 'message' => 'Payment data saved successfully.');
        } catch (Exception $e) {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'Database error: ' . $e->getMessage());
        }
    } else {
        $message = array('success' => '1', 'type' => 'error', 'message' => 'Failed. Please try again.');
    }

    echo json_encode($message);
}
*/

//konkoff working
/*public function save_invoice_log_hlc() {
    if ($this->input->is_ajax_request()) {
        $invoiceId = $this->input->post('invoiceId');
        $paymentDate = $this->input->post('payment_date');
        $totPayable = $this->input->post('total_payable'); // Net Pay for the current invoice
        $payAmt = $this->input->post('pay_amt'); // Payment made in the current transaction
        $remark = $this->input->post('remark');
        $bankDetails = $this->input->post('bank_details');

        // Get invoice and connector data
        $inv_type = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceId])->get()->row();
        $connector_id = $inv_type->connector_id;

        // Current invoice details
        $netpay = $totPayable; // Net Pay for the current invoice

        // Check if the current invoice's pay_amt matches netpay
        if ($payAmt == $netpay) {
            $status = 'paid';
        } else {
            // If payment doesn't match exactly, calculate based on tolerance
            $previous_invoices = $this->db->select('*')
                ->from('invoice_log')
                ->where(['connector_id' => $connector_id, 'status' => 'partly paid', 'invoice_type' => 'inv_hlc'])
                ->get()
                ->result_array();

            // Calculate the total unpaid balance from previous invoices
            $previous_balance = 0;
            foreach ($previous_invoices as $prev_invoice) {
                $previous_balance += $prev_invoice['net_pay'] - $prev_invoice['pay_amt'];
            }

            $total_required_payment = $netpay + $previous_balance; // Total required amount including previous unpaid balance
            $cumulative_payment = $payAmt + $previous_balance; // Total payment made including previous balance

            // Define tolerance
            $tolerance = 100;

            // Format cumulative payment and total required payment for precision
            $cumulative_payment = number_format($cumulative_payment, 2, '.', '');
            $total_required_payment = number_format($total_required_payment, 2, '.', '');

            // Calculate the difference
            $difference = $total_required_payment - $cumulative_payment;

            // Determine status
            if ($difference <= $tolerance && $difference >= -$tolerance) {
                $status = 'paid';
            } elseif ($cumulative_payment > $total_required_payment) {
                $status = 'excess paid';
            } else {
                $status = 'partly paid';
            }
        }

        // Prepare data for the new invoice log
        $data = array(
            'invoice_batchno' => $invoiceId,
            'status' => $status,
            'invoice_type' => $inv_type->invoice_type,
            'net_pay' => $netpay,
            'connector_id' => $connector_id,
            'payment_date' => $paymentDate,
            'pay_amt' => $payAmt,
            'remark' => $remark,
            'bank_details' => $bankDetails,
            'created_by' => isset($_SESSION['staff_id']) ? $_SESSION['staff_id'] : null
        );

        try {
            if ($this->db->insert('invoice_log', $data)) {
                // Update the current invoice status to the determined status
                $u_data = array('hlc_status' => $status);
                $pay_applicant_data = array('hlc_payment_status' => $status);

                $this->db->where('inv_batchno', $invoiceId);
                $this->db->update('invoices', $u_data);

                // Update the status of the users related to the current invoice
                $user_ids = $this->db->select('user_id')->from('invoices')->where('inv_batchno', $invoiceId)->get()->result_array();
                foreach ($user_ids as $user_id_val) {
                    $this->db->where('id', $user_id_val['user_id']);
                    $this->db->update('mst_user', $pay_applicant_data); // Update `hlc_payment_status` in `mst_user`
                }
            }
            $message = array('success' => '0', 'type' => 'success', 'message' => 'Payment data saved successfully.');
        } catch (Exception $e) {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'Database error: ' . $e->getMessage());
        }
    } else {
        $message = array('success' => '1', 'type' => 'error', 'message' => 'Failed. Please try again.');
    }
    echo json_encode($message);
}
*/





public function save_invoice_log_sbi() {

    // Check if it's an AJAX request
    if ($this->input->is_ajax_request()) {
        // Retrieve form data
        $invoiceId = $this->input->post('invoiceId');
        $paymentDate = $this->input->post('payment_date');
        $totPayable = $this->input->post('total_payable');
        $payAmt = $this->input->post('pay_amt');
        $tdsAmt = $this->input->post('tds_amt');
        $remark = $this->input->post('remark');
        $bankDetails = $this->input->post('bank_details');
        $inv_type = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceId])->get()->row();
        $conn_data = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $inv_type->connector_id])->get()->row();
        
        $netPayamt = $totPayable - $tdsAmt;

        $netpay = $netPayamt;

        $data['invoice_log'] = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceId])->get()->result_array();
        $totalpayamt = 0;

        foreach ($data['invoice_log'] as $val) {
            $totalpayamt += $val['pay_amt'];
        }

        $payAmt = is_numeric($payAmt) ? $payAmt : 0;
        $tot_paid_amt = $totalpayamt + $payAmt;
        $rmain_bal = $netpay - $tot_paid_amt;

        $last_entry = $this->db->select('*')
            ->from('invoice_log')
            ->where('invoice_batchno', $invoiceId)
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row();

        if ($last_entry && $last_entry->status === 'paid') {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'This invoice has already been paid.');
            echo json_encode($message);
            return;
        }

        $tolerance = 100;
        $tot_paid_amt = number_format($tot_paid_amt, 2, '.', '');
        $netpay = number_format($netpay, 2, '.', '');
        $difference = $tot_paid_amt - $netpay;

        if ($difference >= -$tolerance && $difference <= $tolerance) {
            $status = 'paid';
        } elseif ($difference > $tolerance) {
            $status = 'excess paid';
        } else {
            $status = 'partly paid';
        }

        $data = array(
            'invoice_batchno' => $invoiceId,
            'status' => $status,
            'invoice_type' => $inv_type->invoice_type,
            'net_pay' => $netpay,
            'connector_id' => $conn_data->staff_id,
            'payment_date' => $paymentDate,
            'pay_amt' => $payAmt,
            'tds_amt' => $tdsAmt,
            'remark' => $remark,
            'bank_details' => $bankDetails,
            'created_by' => isset($_SESSION['staff_id']) ? $_SESSION['staff_id'] : null
        );

        try {
            if ($this->db->insert('invoice_log', $data)) {
                $u_data = array('sbi_status' => $status);
                $pay_applicant_data = array('sbi_payment_status' => $status);

                $this->db->where('inv_batchno', $invoiceId);
                $this->db->update('invoices', $u_data);

                $user_ids = $this->db->select('user_id')->from('invoices')->where('inv_batchno', $invoiceId)->get()->result_array();
                foreach ($user_ids as $user_id_val) {
                    $this->db->where('id', $user_id_val['user_id']);
                    $this->db->update('mst_user', $pay_applicant_data);
                }
            }

            $message = array('success' => '0', 'type' => 'success', 'message' => 'Payment data saved successfully.');
        } catch (Exception $e) {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'Database error: ' . $e->getMessage());
        }
    } else {
        $message = array('success' => '1', 'type' => 'error', 'message' => 'Failed. Please try again.');
    }

    echo json_encode($message);
}



public function user_profile() {
     
    $id = $_SESSION['staff_id'];
    $data['current_page'] = 'Profile';

    if ($id != '') {

        $data['title'] = 'Edit Profile';

        $data['profile'] = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $id])->get()->row();

    } else {

        $data['title'] = 'Add Profile';

    }

    $data['viewfile'] = 'admin/manage_profile/user_profile.php';

    $this->load->view('admin/layout', $data);

}

    public function get_invoice_log($invoiceId) {
        // Fetch invoice logs based on the provided $invoiceId
        $invoice_logs = $this->db->select("*")->where(['invoice_batchno' => $invoiceId])->from('invoice_log')->get()->result_array();

        // Return JSON response
        $this->output->set_content_type('application/json')->set_output(json_encode($invoice_logs));
    }



 public function manage_admin_acct() {
     
       if (!in_array('Admin Users', $this->menu_permission)) {
           echo 'You do not have permission to access this page.'; die;
        }
        

        if ($this->session->userdata('staff_type') == 0) {
        $where = ' and staff_type=0';
      

        $data['current_page'] = 'manage_admin_acct';

        $data['title'] = 'List Admins';

        $data['Connectors'] = $this->ccm->get_all_data('mst_staff', '', 'add_date', 'desc', 'mobile',$where);

//       print("<pre>".print_r( $data['leads'],true)."</pre>"); die;

        $data['viewfile'] = "admin/manage_admin_acct/manage_admin";

        $this->load->view('admin/layout', $data);

        }else{
            // Redirect or show an error message
            echo 'unauthorized_access'; 
            return;
        }
        

    }

 public function admin_form($id = '') {
        if (!in_array('Admin Users', $this->menu_permission)) {
           echo 'You do not have permission to access this page.'; die;
        }

        $data['current_page'] = 'manage_admin_acct';

        if ($id != '') {

            $data['title'] = 'Edit Admin';
            $data['Connectors'] = $this->ccm->get_single_row('mst_staff', array('staff_id' => $id));
          

        } else {
            $data['title'] = 'Add Admin';

        }
        
        $data['roles'] = $this->db->select("*")->from('role')->where('active', 1)->get()->result_array();
        $data['viewfile'] = 'admin/manage_admin_acct/admin_form';

        $this->load->view('admin/layout', $data);

    }



public function submit_admin() {
     if (!in_array('Admin Users', $this->menu_permission)) {
           echo 'You do not have permission to access this page.'; die;
        }
    if ($_POST) {
        $data = $_POST;
        $data['staff_type'] = 0;
       

        $data = array_filter($data);

        $data = $this->security->xss_clean($data);

        $e_id = 0;

        if ($_POST['staff_id'] != '') {

            $e_id = $_POST['staff_id'];

            $this->db->where('staff_id', $_POST['staff_id']);

            $res = $this->db->update('mst_staff', $data);

            $msg = 'Updated Successfully..!';

        } else {

            if ($this->ccm->get_row_count('mst_staff', array('email' => $this->input->post('email'))) != 0) {

                $data = array('type' => 'error', 'message' => 'Email id already exists Please change it...!', 'success' => 0);

                echo json_encode($data);

                exit;

            }

            $res = $this->db->insert('mst_staff', $data);

            $msg = 'Added Successfully..!';

            $e_id = $this->db->insert_id();

        }

       

        if ($res == 1) {

            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);

            $this->session->set_flashdata('response_message', $message);

        } else {

            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didnt Added, Please try after some time..!');

        }

    } else {

        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');

    }

    echo json_encode($message);

}

public function upload_apprisal_file() {
    // Get the user ID from the POST data
    $user_id = $this->input->post('user_id');

    // Check if a file was uploaded
    if(isset($_FILES['apprisal_letter']) && !empty($_FILES['apprisal_letter']['name'])) {
        // Configuration for file upload
        $upload_path = FCPATH . 'assets/uploads/documents/';
       // echo "Upload Path: $upload_path"; // Debugging

        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = 'pdf|doc|docx|jpg|jpeg|png';
        $config['max_size'] = 4072; // 3mb
        $config['file_name'] = 'apprisal_letter_'.$user_id;

        $this->upload->initialize($config);

        if ($this->upload->do_upload('apprisal_letter')) {
            // File uploaded successfully
            $data = $this->upload->data();
            $file_name = $data['file_name']; // Get only the file name

            // Get the previous apprisal_letter of the user
            $previous_apprisal_letter = $this->db->select('apprisal_letter')->where('id', $user_id)->get('mst_user')->row()->apprisal_letter;

            $filepath = FCPATH . 'assets/uploads/documents/' . $previous_apprisal_letter;
            if (file_exists($filepath)) {
                @unlink($filepath);
            }
            // Update the database with the new file name
          
            $fdata['apprisal_letter'] = $file_name;
            $this->db->where('id', $user_id);
            $res = $this->db->update('mst_user', $fdata);

            echo 'File uploaded successfully';
        } else {
            // Error uploading file
            $error = $this->upload->display_errors();
            echo 'Error uploading file: ' . $error;
        }
    } else {
        echo 'No file selected';
    }
}


public function manage_state() {
   
    $data['current_page'] = 'State';
    $data['title'] = 'State';
    $data['state'] = $this->ccm->get_all_data('mst_state', '', 'id', '', 'state_name');
    $data['viewfile'] = "admin/manage_state/manage_state";
    $this->load->view('admin/layout', $data);
}


public function state_form($id = '') {

    $data['current_page'] = 'State';

    if ($id != '') {

        $data['title'] = 'Edit State';
        $data['state'] = $this->ccm->get_single_row('mst_state', array('id' => $id));

    } else {

        $data['title'] = 'Add State';

    }
    $data['viewfile'] = 'admin/manage_state/state_form';
    $this->load->view('admin/layout', $data);

}


public function submit_state() {
    if ($_POST) {
        $data = $_POST;
        $data = array_filter($data);
        $data = $this->security->xss_clean($data);

        // Check for duplicate gst_state_code for both insert and update
        $existing_code = $this->db->get_where('mst_state', array('gst_state_code' => $data['gst_state_code']))->row();
        if ($existing_code && (!isset($_POST['id']) || $existing_code->id != $_POST['id'])) {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'GST State Code already exists.');
            echo json_encode($message);
            return;
        }

        // Check for duplicate state_name for both insert and update
        $existing_name = $this->db->get_where('mst_state', array('state_name' => $data['state_name']))->row();
        if ($existing_name && (!isset($_POST['id']) || $existing_name->id != $_POST['id'])) {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'State Name already exists.');
            echo json_encode($message);
            return;
        }

        $e_id = 0;
        if (isset($_POST['id']) && $_POST['id'] != '') {
            $e_id = $_POST['id'];
            $this->db->where('id', $_POST['id']);
            $res = $this->db->update('mst_state', $data);
            $msg = 'Updated Successfully..!';
        } else {
            // For insert, check for duplicates again
            $existing_code = $this->db->get_where('mst_state', array('gst_state_code' => $data['gst_state_code']))->row();
            $existing_name = $this->db->get_where('mst_state', array('state_name' => $data['state_name']))->row();

            if ($existing_code) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'GST State Code already exists.');
                echo json_encode($message);
                return;
            }

            if ($existing_name) {
                $message = array('success' => '0', 'type' => 'error', 'message' => 'State Name already exists.');
                echo json_encode($message);
                return;
            }

            $res = $this->db->insert('mst_state', $data);
            $msg = 'Added Successfully..!';
            $e_id = $this->db->insert_id();
        }

        if ($res == 1) {
            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
            $this->session->set_flashdata('response_message', $message);
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didn\'t Added, Please try after some time..!');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');
    }

    echo json_encode($message);
}


public function delete_branch($id) {
    $this->db->where('id', $id);
    $res = $this->db->delete('branch');

    if ($res) {
        $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully...!');
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Failed to delete. Please try again later..!');
    }
    echo json_encode($message);
}


public function delete_state($id) {
    $data["active"] = '2';
    $this->db->where('id', $id);
       $res = $this->db->update('mst_state',$data,array('id' =>$id));

    if ($res == 1) {
        $message = array('success' => '1', 'type' => 'error', 'message' => 'Deleted Successfully...!');
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'did not deleted please try after some time..!');
    }
    echo json_encode($message);
}

public function active_state($id, $status) {

        $data["active"] = $status;
        $this->db->where('id', $id);
        if ($this->db->update("mst_state", $data)) {
            if ($status == 0) {
                $message = array('success' => '1', 'type' => 'success', 'message' => 'State Deactivated...!'); } 
                else {
                $message = array('success' => '1', 'type' => 'success', 'message' => 'State Activated...!');
            }
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'State did not updated please try after some time..!');

        }
        echo json_encode($message);

    }


public function manage_city() {
   
    $data['current_page'] = 'City';
    $data['title'] = 'City';
    $data['city'] = $this->ccm->get_cities_with_states();
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
    $data['viewfile'] = "admin/manage_city/manage_city";
    $this->load->view('admin/layout', $data);
}


public function city_form($id) {

    $data['current_page'] = 'City';
    $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();

    if ($id != '') {

        $data['title'] = 'Edit City';
        $data['city'] = $this->ccm->get_single_row('mst_city', array('id' => $id));

    } else {

        $data['title'] = 'Add City';

    }

    $data['viewfile'] = 'admin/manage_city/city_form';

    $this->load->view('admin/layout', $data);

}


public function submit_city() {
    if ($_POST) {
        $data = $_POST;
        $data = array_filter($data);
        $data = $this->security->xss_clean($data);

        // Check for duplicate city_name under the same state_id
        $existing_city = $this->db->get_where('mst_city', array('state_id' => $data['state_id'], 'city_name' => $data['city_name']))->row();
        if ($existing_city && (!isset($_POST['id']) || $existing_city->id != $_POST['id'])) {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'City Name already exists for this state.');
            echo json_encode($message);
            return;
        }

        $e_id = 0;
        if (isset($_POST['id']) && $_POST['id'] != '') {
            $e_id = $_POST['id'];
            $this->db->where('id', $_POST['id']);
            $res = $this->db->update('mst_city', $data);
            $msg = 'Updated Successfully..!';
        } else {
            $res = $this->db->insert('mst_city', $data);
            $msg = 'Added Successfully..!';
            $e_id = $this->db->insert_id();
        }

        if ($res == 1) {
            $message = array('success' => '1', 'type' => 'success', 'message' => $msg);
            $this->session->set_flashdata('response_message', $message);
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'Didn\'t Added, Please try after some time..!');
        }
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Please Fill the details before submitting..!');
    }

    echo json_encode($message);
}



public function delete_city($id) {
    $data["active"] = '2';
    $this->db->where('id', $id);
       $res = $this->db->update('mst_city',$data,array('id' =>$id));

    if ($res == 1) {
        $message = array('success' => '1', 'type' => 'error', 'message' => 'Deleted Successfully...!');
    } else {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'did not deleted please try after some time..!');
    }
    echo json_encode($message);
}

public function active_city($id, $status) {

        $data["active"] = $status;
        $this->db->where('id', $id);
        if ($this->db->update("mst_city", $data)) {
            if ($status == 0) {
                $message = array('success' => '1', 'type' => 'success', 'message' => 'City Deactivated...!'); } 
                else {
                $message = array('success' => '1', 'type' => 'success', 'message' => 'City Activated...!');
            }
        } else {
            $message = array('success' => '0', 'type' => 'error', 'message' => 'City did not updated please try after some time..!');

        }
        echo json_encode($message);

    }
 
 public function get_cities() {
        if($this->input->post('state_id')) {
            $state_id = $this->input->post('state_id');
            $cities = $this->ccm->get_cities_by_state($state_id);
            echo json_encode($cities);
        }
    }
    
     public function get_cities_by_circle() {
        if($this->input->post('circle_id')) {
            $circle_id = $this->input->post('circle_id');
            $circles = $this->db->get_where('branch', array('circle_id' => $circle_id))->row();
            $state = $this->db->get_where('mst_state', array('id' => $circles->state_id))->row();
            $cities = $this->ccm->get_cities_by_state($state->id);
            echo json_encode($cities);
        }
    }
    
    
    
    function formatIndianNumber($number) {
  // Round up the number to two decimal places
    $rounded_number = round($number, 2);

    // Convert the rounded number to string
    $number_str = strval($rounded_number);

    // Split the number into integral and fractional parts
    $parts = explode('.', $number_str);

    // Format the integral part
    $integral_part = $parts[0];
    $formatted_integral = '';

    // Format the integral part with commas after every two digits if the number has six or more digits
    $len = strlen($integral_part);
    $i = $len - 1;
    $count = 0;
    while ($i >= 0) {
        $formatted_integral = $integral_part[$i] . $formatted_integral;
        $count++;
        if (($count == 3 || $count == 5 || $count == 7) && $i != 0) {
            $formatted_integral = ',' . $formatted_integral;
        }
        $i--;
    }

    // Format the fractional part
    $formatted_fractional = isset($parts[1]) ? '.' . str_pad($parts[1], 2, '0') : '.00';

    // Combine the formatted integral part with the formatted fractional part
    $formatted_number = $formatted_integral . $formatted_fractional;

    return $formatted_number;
}



 function getIndianCurrency(float $amount) {
    $num = floor($amount);
    $amount_after_decimal = round(($amount - $num) * 100);

    // Check if there is any number after decimal
    $amt_hundred = null;
    $count_length = strlen($num);
    $x = 0;
    $string = array();
    $change_words = array(
        0 => 'Zero', 1 => 'One', 2 => 'Two',
        3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
        7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
        10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
        13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
        16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
        19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
        40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
        70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
    );
    $here_digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
    while ($x < $count_length) {
        $get_divider = ($x == 2) ? 10 : 100;
        $amount = floor($num % $get_divider);
        $num = floor($num / $get_divider);
        $x += $get_divider == 10 ? 1 : 2;
        if ($amount) {
            $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
            $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
            $string[] = ($amount < 21) ? $change_words[$amount] . ' ' . $here_digits[$counter] . $add_plural . '
       ' . $amt_hundred : $change_words[floor($amount / 10) * 10] . ' ' . $change_words[$amount % 10] . '
       ' . $here_digits[$counter] . $add_plural . ' ' . $amt_hundred;
        } else {
            $string[] = null;
        }
    }
    $implode_to_Rupees = implode('', array_reverse($string));
    $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[floor($amount_after_decimal / 10)] . "
   " . $change_words[$amount_after_decimal % 10]) . ' Paise' : '';
    return ($implode_to_Rupees ? $implode_to_Rupees . ' Rupees ' : '') . $get_paise;
}




public function check_duplicate_cbs() {
    $account_no = $this->input->get('account_no');
    $record_id = $this->input->get('record_id');

    $this->db->group_start();
    $this->db->where('bank_acct_no', $account_no);
    $this->db->or_where('rr_cbs_acct_no', $account_no);
    $this->db->group_end();

    if (!empty($record_id)) {
        // Exclude the current record
        $this->db->where('id !=', $record_id);
    }
    $query = $this->db->get('mst_user');

    if ($query->num_rows() > 0) {
        echo json_encode(['exists' => true]);
    } else {
        echo json_encode(['exists' => false]);
    }
}


/*public function delete_payment_log_sbi() {
    $invoice_number = $this->input->post('invoice_number');

    // Start a transaction
    $this->db->trans_start();

    // Retrieve user_ids associated with the given invoice_number
    $this->db->select('user_id');
    $this->db->from('invoices');
    $this->db->where('inv_batchno', $invoice_number);
    $query = $this->db->get();
    $user_ids = $query->result_array();

    if (!empty($user_ids)) {
        $user_ids = array_column($user_ids, 'user_id');

        // Update hlc_status to null in the invoices table
        $this->db->where('invoice_number', $invoice_number);
        $this->db->update('invoices', ['sbi_status' => null]);

        // Update hlc_payment_status to null in the mst_user table
        $this->db->where_in('id', $user_ids);
        $this->db->update('mst_user', ['sbi_payment_status' => null]);
    }

    // Delete the payment log entry from the invoice_log table
    $this->db->where('invoice_batchno', $invoice_number);
    $this->db->delete('invoice_log');

    // Complete the transaction
    $this->db->trans_complete();

    // Check if the transaction was successful
    if ($this->db->trans_status() === FALSE) {
        // Transaction failed, return false
        echo json_encode(['success' => '0', 'message' => 'Failed to delete payment log.']);
    } else {
        // Transaction succeeded, return true
        echo json_encode(['success' => '1', 'message' => 'Payment log deleted successfully.']);
    }
}*/


public function delete_payment_log_sbi() {
    $invoice_number = $this->input->post('invoice_number');

    // Start a transaction
    $this->db->trans_start();

    // Retrieve all relevant data from the invoice_log table
    $this->db->select('*');
    $this->db->from('invoice_log');
    $this->db->where('invoice_batchno', $invoice_number);
    $query = $this->db->get();
    $invoice_log_data = $query->result_array();

    // Insert the fetched data into the deleted_payment_log table
    if (!empty($invoice_log_data)) {
        foreach ($invoice_log_data as $log_entry) {
            $inv_no = $this->db->select("invoice_number")
                    ->where(['inv_batchno' => $log_entry['invoice_batchno']])
                    ->from('invoices')
                    ->get()
                    ->row();
            $deleted_data = [
                'invoice_batchno' => $log_entry['invoice_batchno'],
                'invoice_number' => $inv_no->invoice_number,
                'invoice_type' => $log_entry['invoice_type'],
                'payment_log' => json_encode($log_entry), // Save as JSON for future reference
                'deleted_date' => date('Y-m-d H:i:s'),
                'deleted_by' => $this->session->userdata('staff_id') // Assuming session has user ID
            ];

            $this->db->insert('deleted_payment_log', $deleted_data);
        }
    }

    // Retrieve user_ids associated with the given invoice_number
    $this->db->select('user_id');
    $this->db->from('invoices');
    $this->db->where('inv_batchno', $invoice_number);
    $query = $this->db->get();
    $user_ids = $query->result_array();

    if (!empty($user_ids)) {
        $user_ids = array_column($user_ids, 'user_id');

        // Update sbi_status to null in the invoices table
        $this->db->where('inv_batchno', $invoice_number);
        $this->db->update('invoices', ['sbi_status' => null]);

        // Update sbi_payment_status to null in the mst_user table
        $this->db->where_in('id', $user_ids);
        $this->db->update('mst_user', ['sbi_payment_status' => null]);
    }

    // Delete the payment log entry from the invoice_log table
    $this->db->where('invoice_batchno', $invoice_number);
    $this->db->delete('invoice_log');

    // Complete the transaction
    $this->db->trans_complete();

    // Check if the transaction was successful
    if ($this->db->trans_status() === FALSE) {
        // Transaction failed, return false
        echo json_encode(['success' => '0', 'message' => 'Failed to delete payment log.']);
    } else {
        // Transaction succeeded, return true
        echo json_encode(['success' => '1', 'message' => 'Payment log deleted successfully.']);
    }
}


/*public function delete_payment_log_hlc() {
    $invoice_number = $this->input->post('invoice_number');

    // Start a transaction
    $this->db->trans_start();

    // Retrieve user_ids associated with the given invoice_number
    $this->db->select('user_id');
    $this->db->from('invoices');
    $this->db->where('inv_batchno', $invoice_number);
    $query = $this->db->get();
    $user_ids = $query->result_array();

    if (!empty($user_ids)) {
        $user_ids = array_column($user_ids, 'user_id');

        // Update hlc_status to null in the invoices table
        $this->db->where('invoice_number', $invoice_number);
        $this->db->update('invoices', ['hlc_status' => null]);

        // Update hlc_payment_status to null in the mst_user table
        $this->db->where_in('id', $user_ids);
        $this->db->update('mst_user', ['hlc_payment_status' => null]);
    }

    // Delete the payment log entry from the invoice_log table
    $this->db->where('invoice_batchno', $invoice_number);
    $this->db->delete('invoice_log');

    // Complete the transaction
    $this->db->trans_complete();

    // Check if the transaction was successful
    if ($this->db->trans_status() === FALSE) {
        // Transaction failed, return false
        echo json_encode(['success' => '0', 'message' => 'Failed to delete payment log.']);
    } else {
        // Transaction succeeded, return true
        echo json_encode(['success' => '1', 'message' => 'Payment log deleted successfully.']);
    }
}*/


public function delete_payment_log_hlc() {
    $invoice_number = $this->input->post('invoice_number');

    // Start a transaction
    $this->db->trans_start();

    // Retrieve all relevant data from the invoice_log table
    $this->db->select('*');
    $this->db->from('invoice_log');
    $this->db->where('invoice_batchno', $invoice_number);
    $query = $this->db->get();
    $invoice_log_data = $query->result_array();

    // Insert the fetched data into the deleted_payment_log table
    if (!empty($invoice_log_data)) {
        foreach ($invoice_log_data as $log_entry) {
            $inv_no = $this->db->select("invoice_number")
                    ->where(['inv_batchno' => $log_entry['invoice_batchno']])
                    ->from('invoices')
                    ->get()
                    ->row();
            $deleted_data = [
                'invoice_batchno' => $log_entry['invoice_batchno'],
                'invoice_number' => $inv_no->invoice_number,
                'invoice_type' => $log_entry['invoice_type'],
                'payment_log' => json_encode($log_entry), // Save the log as JSON
                'deleted_date' => date('Y-m-d H:i:s'),
                'deleted_by' => $this->session->userdata('staff_id') // Assuming session contains the user ID
            ];

            $this->db->insert('deleted_payment_log', $deleted_data);
        }
    }

    // Retrieve user_ids associated with the given invoice_number
    $this->db->select('user_id');
    $this->db->from('invoices');
    $this->db->where('inv_batchno', $invoice_number);
    $query = $this->db->get();
    $user_ids = $query->result_array();

    if (!empty($user_ids)) {
        $user_ids = array_column($user_ids, 'user_id');

        // Update hlc_status to null in the invoices table
        $this->db->where('inv_batchno', $invoice_number);
        $this->db->update('invoices', ['hlc_status' => null]);

        // Update hlc_payment_status to null in the mst_user table
        $this->db->where_in('id', $user_ids);
        $this->db->update('mst_user', ['hlc_payment_status' => null]);
    }

    // Delete the payment log entry from the invoice_log table
    $this->db->where('invoice_batchno', $invoice_number);
    $this->db->delete('invoice_log');

    // Complete the transaction
    $this->db->trans_complete();

    // Check if the transaction was successful
    if ($this->db->trans_status() === FALSE) {
        // Transaction failed, return false
        echo json_encode(['success' => '0', 'message' => 'Failed to delete payment log.']);
    } else {
        // Transaction succeeded, return true
        echo json_encode(['success' => '1', 'message' => 'Payment log deleted successfully.']);
    }
}


/*public function delete_payment_log_pb() {
    $invoice_number = $this->input->post('invoice_number');

    // Start a transaction
    $this->db->trans_start();

    // Retrieve user_ids associated with the given invoice_number
    $this->db->select('user_id');
    $this->db->from('invoices');
    $this->db->where('inv_batchno', $invoice_number);
    $query = $this->db->get();
    $user_ids = $query->result_array();

    if (!empty($user_ids)) {
        $user_ids = array_column($user_ids, 'user_id');

        // Update hlc_status to null in the invoices table
        $this->db->where('invoice_number', $invoice_number);
        $this->db->update('invoices', ['pb_pay_status' => null]);

       
        $this->db->where_in('id', $user_ids);
        $this->db->update('mst_user', ['pb_payment_status' => null]);
    }

    // Delete the payment log entrys from the invoice_log table
    $this->db->where('invoice_batchno', $invoice_number);
    $this->db->delete('invoice_log');

    // Complete the transaction
    $this->db->trans_complete();

    // Check if the transaction was successful
    if ($this->db->trans_status() === FALSE) {
        // Transaction failed, return false
        echo json_encode(['success' => '0', 'message' => 'Failed to delete payment log.']);
    } else {
        // Transaction succeeded, return true
        echo json_encode(['success' => '1', 'message' => 'Payment log deleted successfully.']);
    }
}
*/


public function delete_payment_log_pb() {
    $invoice_number = $this->input->post('invoice_number');

    // Start a transaction
    $this->db->trans_start();

    // Retrieve user_ids and payment log data from the invoice_log table
    $this->db->select('*');
    $this->db->from('invoice_log');
    $this->db->where('invoice_batchno', $invoice_number);
    $query = $this->db->get();
    $invoice_log_data = $query->result_array();

    // Insert the fetched data into the deleted_payment_log table
    if (!empty($invoice_log_data)) {
        foreach ($invoice_log_data as $log_entry) {
            $inv_no = $this->db->select("invoice_number")
                    ->where(['inv_batchno' => $log_entry['invoice_batchno']])
                    ->from('invoices')
                    ->get()
                    ->row();
            $deleted_data = [
                'invoice_batchno' => $log_entry['invoice_batchno'],
                'invoice_number' => $inv_no->invoice_number,
                'invoice_type' => $log_entry['invoice_type'],
                'payment_log' => json_encode($log_entry), // Save as JSON if structure needs preservation
                'deleted_date' => date('Y-m-d H:i:s'),
                'deleted_by' => $this->session->userdata('staff_id') // Assuming session contains user ID
            ];

            $this->db->insert('deleted_payment_log', $deleted_data);
        }
    }

    // Retrieve user_ids associated with the given invoice_number
    $this->db->select('user_id');
    $this->db->from('invoices');
    $this->db->where('inv_batchno', $invoice_number);
    $query = $this->db->get();
    $user_ids = $query->result_array();

    if (!empty($user_ids)) {
        $user_ids = array_column($user_ids, 'user_id');

        // Update hlc_status to null in the invoices table
        $this->db->where('inv_batchno', $invoice_number);
        $this->db->update('invoices', ['pb_pay_status' => null]);

        // Update pb_payment_status to null in the mst_user table
        $this->db->where_in('id', $user_ids);
        $this->db->update('mst_user', ['pb_payment_status' => null]);
    }

    // Delete the payment log entry from the invoice_log table
    $this->db->where('invoice_batchno', $invoice_number);
    $this->db->delete('invoice_log');

    // Complete the transaction
    $this->db->trans_complete();

    // Check if the transaction was successful
    if ($this->db->trans_status() === FALSE) {
        // Transaction failed, return false
        echo json_encode(['success' => '0', 'message' => 'Failed to delete payment log.']);
    } else {
        // Transaction succeeded, return true
        echo json_encode(['success' => '1', 'message' => 'Payment log deleted successfully.']);
    }
}

public function fetch_partner_code() {
    $staff_id = $this->input->post('staff_id');

    if ($staff_id) {
        // Fetch the partner code from the database
        $partner = $this->ccm->get_single_row('mst_staff', array('staff_id' => $staff_id));
        if ($partner) {
            echo json_encode(['status' => 'success', 'hlc_code' => $partner->hlc_code]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No partner found']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
    }
}




//PB invoice cases
/*public function manage_invoice_cases_pb_old() { 
      $this->load->model('Paisabazar_model');
        
    $data['current_page'] = 'create_pb_invoice';
    $data['title'] = 'Create Invoice PB';
    
    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();

    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $stauts = $this->input->post('status');
    $conn_id = $this->input->post('connector');
    $branch_id = $this->input->post('branch'); 
    $city_id = $this->input->post('city_id'); 
     $disb_month_year = $this->input->post('month');
     
    $offset = $this->input->get('per_page');

    
    $branch_genrated = '';
    $pb_genrated = 'No';
    $data['user'] = $this->Paisabazar_model->get_applicant_data_pb($start_date,$end_date,$stauts,$conn_id,$branch_id,'','','',$pb_genrated,'',$city_id,$branch_genrated,$disb_month_year);


    $data['viewfile'] = "admin/manage_invoice_cases_pb/manage_invoice_cases_pb";

    $this->load->view('admin/layout', $data);
    }
    */
    
    public function manage_invoice_cases_pb() { 
    
    $data['current_page'] = 'create_pb_invoice';
    $data['title'] = 'Create Invoice PB';
    
    $data['branch'] = $this->db->select("branch_name,id")->from('branch')->where('active', 1)->get()->result_array();
    $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();


    $data['viewfile'] = "admin/manage_invoice_cases_pb/manage_invoice_cases_pb";
    $this->load->view('admin/layout', $data);
    }


public function get_invoice_cases_pb_ajax() {
    $request = $_POST;
    $limit = $request['length'];
    $offset = $request['start'];
    $draw = $request['draw'];

    // Select columns
    $this->db->select('
        mst_user.*, 
        mst_staff.staff_fullname, 
        mst_loan_type.name as user_type,
        branch.branch_name, 
        mst_city.city_name, 
        mst_rbo.rbo_name,
        created_by_staff.staff_fullname as admin_created_hlc,
        verified_by_staff.staff_fullname as verified_by_name
    ');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id', 'left');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id', 'left');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    $this->db->join('mst_staff as created_by_staff', 'mst_staff.created_by = created_by_staff.staff_id', 'left');
    $this->db->join('mst_staff as verified_by_staff', 'mst_user.verify_by = verified_by_staff.staff_id', 'left'); 
    // Fixed Conditions
    $this->db->where('mst_user.is_verify', 1);
    $this->db->where('mst_user.pb_pending_approve', 1);
    $this->db->where('mst_user.login_code', 'PaisaBazaar');
    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.pb_genrated', 'No');

    if ($this->session->userdata('staff_type') == 1) {
        $this->db->where('mst_user.connector_id', $this->session->userdata('staff_id'));
    }

    // Apply filters dynamically
    if (!empty($request['start_date']) && !empty($request['end_date'])) {
        $this->db->where('mst_user.add_date >=', $request['start_date']);
        $this->db->where('mst_user.add_date <=', $request['end_date']);
    }
    if (!empty($request['branch'])) {
        $this->db->where('mst_user.branch_id', $request['branch']);
    }
    if (!empty($request['connector'])) {
        $this->db->where('mst_user.connector_id', $request['connector']);
    }
    if (!empty($request['status'])) {
        $this->db->where('mst_user.status', $request['status']);
    }
    if (!empty($request['month'])) {
        $this->db->where('MONTH(mst_user.disb_date)', date('m', strtotime($request['month'])));
        $this->db->where('YEAR(mst_user.disb_date)', date('Y', strtotime($request['month'])));
    }

    // Get total records count (before applying limit)
    $totalRecords = $this->db->count_all_results('', false);

    // Apply pagination
    if ($limit != -1) {
        $this->db->limit($limit, $offset);
    }
    
    if (!empty($request['search']['value'])) {
    $searchValue = $request['search']['value'];
    $this->db->group_start();
    $this->db->like('mst_staff.staff_fullname', $searchValue);
    $this->db->or_like('mst_user.user_name', $searchValue);
    $this->db->or_like('mst_user.los_id', $searchValue);
    $this->db->or_like('mst_user.bank_acct_no', $searchValue);
    $this->db->or_like('mst_user.rr_cbs_acct_no', $searchValue);
    $this->db->or_like('branch.branch_name', $searchValue);
    $this->db->or_like('mst_city.city_name', $searchValue);
    $this->db->or_like('mst_rbo.rbo_name', $searchValue);
    $this->db->or_like('mst_loan_type.name', $searchValue);
    $this->db->or_like('mst_user.sanction_amt', $searchValue);
    $this->db->or_like('mst_user.disb_date', $searchValue);
    $this->db->group_end();
}


    // Fetch filtered results
    $query = $this->db->get();
    $data = $query->result_array();

       foreach ($data as $key => $row) {
        // Serial Number Calculation
        $data[$key]['sr_no'] = $offset + $key + 1;  // Add serial number dynamically

        // Format Disbursement Date (DISB Date) to d-m-Y
        $data[$key]['disb_date'] = !empty($row['disb_date']) ? date('d-m-Y', strtotime($row['disb_date'])) : 'N/A';
        
        $data[$key]['bank_acct_no'] = ($row['loan_type_id'] == 5) ? $row['rr_cbs_acct_no'] : $row['bank_acct_no'];

        // **Verified Status**
        $verifiedStatus = ($row['is_verify'] == 1) ? 
            '<span class="badge rounded-pill bg-success">Verified</span>' :
            '<span class="badge rounded-pill bg-danger">Non-Verified</span>';
            
        $data[$key]['verified_by'] = !empty($row['verified_by_name']) ? $row['verified_by_name'] : 'N/A';

        // **Approval Select Dropdown**
        $approvalClass = ($row['pb_pending_approve'] == 1) ? 'bg-success' : 'bg-warning';
        $approvalDropdown = '<select class="form-select form-select-sm commoon_active_pb_approve ' . $approvalClass . '" 
                                data-id="' . $row['id'] . '" 
                                action="active_pb_approval">
                                <option value="1" ' . ($row['pb_pending_approve'] == 1 ? 'selected' : '') . '>Approved</option>
                                <option value="0" ' . ($row['pb_pending_approve'] == 0 ? 'selected' : '') . '>Pending</option>
                            </select>';

        // **Appraisal, FSL, and Proof of Disbursement Links**
        $appraisalLetter = $this->db->select('appraisal_letter')->from('appraisal_letters')
                                    ->where('user_id', $row['id'])->where('appraisal_letter IS NOT NULL')->get()->row();
        $appraisalLink = !empty($appraisalLetter->appraisal_letter) ? 
                        '<a href="' . base_url('assets/uploads/documents/' . $appraisalLetter->appraisal_letter) . '" target="_blank">View</a>' : 'N/A';

        $fslLetter = $this->db->select('final_sanction_letter')->from('appraisal_letters')
                              ->where('user_id', $row['id'])->where('final_sanction_letter IS NOT NULL')->get()->row();
        $fslLink = !empty($fslLetter->final_sanction_letter) ? 
                        '<a href="' . base_url('assets/uploads/documents/' . $fslLetter->final_sanction_letter) . '" target="_blank">View</a>' : 'N/A';

        $proofDisb = $this->db->select('proof_disb')->from('appraisal_letters')
                              ->where('user_id', $row['id'])->where('proof_disb IS NOT NULL')->get()->row();
        $proofDisbLink = !empty($proofDisb->proof_disb) ? 
                        '<a href="' . base_url('assets/uploads/documents/' . $proofDisb->proof_disb) . '" target="_blank">View</a>' : 'N/A';

        // **Edit Action Button**
        $data[$key]['action'] = '
            <a href="' . base_url('admin/pb_user_form/' . $row['id']) . '" class="text-info" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Edit">
                <i class="bi bi-pencil-fill"></i>
            </a>';
            
         $remarkInput = '<input type="text" class="form-control remark-input" data-id="' . $row['id'] . '" value="' . $row['remark'] . '" style="width: 300px;" />';

        // Assign values
        $data[$key]['verify'] = $verifiedStatus;
        $data[$key]['pb_pending_approve'] = $approvalDropdown;
        $data[$key]['remark'] = $remarkInput;
        $data[$key]['appraisal'] = $appraisalLink;
        $data[$key]['fsl'] = $fslLink;
        $data[$key]['proof_disb'] = $proofDisbLink;
        $data[$key]['add_date'] = !empty($row['add_date']) ? date('d-m-Y', strtotime($row['add_date'])) : 'N/A';
    }
    
    

    // Return JSON response for DataTable
    $response = [
        "draw" => intval($draw),
        "recordsTotal" => $totalRecords,
        "recordsFiltered" => $totalRecords,
        "data" => $data
    ];

    // Send JSON output
    header("Content-Type: application/json");
    echo json_encode($response);
}





public function generate_invoice_pb() {
        $invoice_date = $this->input->post('invoice_date');
        $invoice_type = $this->input->post('inv_type');
        $signature_id = $this->input->post('signature_id');
        $selectedRows = json_decode($this->input->post('selectedRows'), true);
        $response = array();

        if (!empty($selectedRows)) {
            $this->db->trans_start();

            $lastRboId = null;
            $batchNumber = null; // Initialize batch number
            $invoiceNumber = null; // Initialize invoice number
           
            $currentDateTime = date("Ymdhi");
            $batchNumber = $invoice_type . $currentDateTime . (is_null($invoiceNumber) ? $this->get_last_invoice_number_pb() : $invoiceNumber);
            $invoiceNumber = $this->get_last_invoice_number_pb();
            
            foreach ($selectedRows as $rowID) {
                $user_data = $this->db->select("*")->where(['id' => $rowID])->from('mst_user')->get()->row();
                $connector_data = $this->db->get_where('mst_staff', ['staff_id' => $user_data->connector_id])->row();
                $data_branch = $this->db->select("*")->from('branch')->where(['id' => $user_data->branch_id])->get()->row();
                $data_rbo = $this->db->select("*")->from('mst_rbo')->where(['id' => $data_branch->rbo_id])->get()->row();
                
                
                // --- Financial Year Validation ---
                $session_fy = $this->session->userdata('financial_year'); // e.g., '24-25'
                $disb_date = new DateTime($user_data->disb_date);
                $disb_year = (int)$disb_date->format('Y');
                $disb_month = (int)$disb_date->format('m');
                
                if ($disb_month >= 4) {
                    $disb_fy = substr($disb_year, -2) . '-' . substr($disb_year + 1, -2);
                } else {
                    $disb_fy = substr($disb_year - 1, -2) . '-' . substr($disb_year, -2);
                }
                
                if ($disb_fy !== $session_fy) {
                    $response['status'] = 'error';
                    $response['message'] = 'Disbursement date does not belong to financial year ' . $session_fy . ' for ID: ' . $rowID;
                    continue;
                }
             
                // Check if a new batch should be started
                /*if ($lastRboId !== $data_rbo->id || is_null($batchNumber)) {
                   // $currentDateTime = date("Ymdhi");
                   // $batchNumber = $invoice_type . $currentDateTime . (is_null($invoiceNumber) ? $this->get_last_invoice_number_pb() : $invoiceNumber);
                    $lastRboId = $data_rbo->id;

                    if (is_null($invoiceNumber)) {
                        $invoiceNumber = $this->get_last_invoice_number_pb();
                    } else {
                       $prefix = 'MB'; // Assuming 'MBP' is a static prefix
                        $numeric_part = substr($invoiceNumber, strlen($prefix)); // Extract the numeric part
                        $incremented_numeric_part = intval($numeric_part) + 1; // Convert to integer and increment
                        $invoiceNumber = $prefix . str_pad($incremented_numeric_part, strlen($numeric_part), '0', STR_PAD_LEFT); // Pad with zeros to maintain length
                    }
                }*/
            
            // Check conditions for generating invoice
            if ($user_data->pb_genrated == 'No' && 
                !is_null($user_data->sanction_amt) && 
                $user_data->is_verify==1 && 
                $user_data->is_archive =='No' &&
                $user_data->pb_pending_approve==1) {
                
                // Validate if invoice_date is after disb_date
                if ($user_data->disb_date > $invoice_date) {
                    $response['status'] = 'error';
                    $response['message'] = 'Invoice Date must be after Disbursement Date for ID: ' . $rowID;
                    continue; // Skip to the next iteration if validation fails
                }
                
                
                $data = array(                
                    'invoice_number' => $invoiceNumber,
                    'inv_batchno' => $batchNumber,
                    'connector_id' => $user_data->connector_id,
                    'branch_id' => $user_data->branch_id,
                    'user_id' => $rowID,
                    'invoice_type' => $invoice_type, 
                    'invoice_date' => $invoice_date, 
                    'signature_id' => $signature_id,
                    'created_by' => $_SESSION['staff_id']              
                );  
                $this->db->insert('invoices', $data);
                $last_invoice_id = $this->db->insert_id();
                
                // Update user's record based on invoice type
                $updateData = array();
                if ($invoice_type == 'inv_pb') {
                    $updateData = ['pb_invoice_id' => $last_invoice_id,'pb_genrated'=>'Yes'];
                }
                $this->db->where('id', $rowID);
                $this->db->update('mst_user', $updateData);
                
                $response['status'] = 'success';
                $response['message'] = 'Invoices generated successfully';
            } else {
                $response['status'] = 'error';
                $response['message'] = 'Invalid row selected for invoice generation fill all data';
            }
        }

        $this->db->trans_complete();
    } else {
        $response['status'] = 'error';
        $response['message'] = 'No rows selected for invoice generation';
    }

    echo json_encode($response);
}

//List PB
public function manage_invoice_pb() {
  

    $data['current_page'] = 'Invoices PB';

    $data['title'] = 'List Invoices PB';

    $data['branch'] = $this->db->select("*")->from('branch')->where('active', 1)->get()->result_array();
        $data['connector'] = $this->db->select("*")->from('mst_staff')->where(['active' => 1, 'staff_type' => 1])->get()->result_array();
        $data['state'] = $this->db->select("*")->from('mst_state')->where('active', 1)->get()->result_array();
        
    $data['viewfile'] = "admin/manage_invoice_cases_pb/list_invoice_cases_pb.php";

    $this->load->view('admin/layout', $data);

}


public function fetch_invoice_data_pb() {
     // DataTables parameters
     $this->load->model('PBInvoice_model');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $order = $this->input->post("order");
    $search = $this->input->post("search")['value'];

    // Filter parameters from the form
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');
    $branch = $this->input->post('branch');
    $connector = $this->input->post('connector');
    $pb_paid_status = $this->input->post('pb_pay_status');
    $state_id = $this->input->post('state_id');
    $city_id = $this->input->post('city_id');
    $month = $this->input->post('month');
    $payment_month_pb = $this->input->post('payment_month_pb');
    $invoice_month = $this->input->post('invoice_month');

    // Fetch records from model
    $invoices = $this->PBInvoice_model->get_filtered_invoices($start, $length, $order, $search, $start_date, $end_date, $branch, $connector, $pb_paid_status, $state_id, $city_id, $month, $payment_month_pb,$invoice_month);
    $totalInvoices = $this->PBInvoice_model->get_total_invoices($search, $start_date, $end_date, $branch, $connector, $pb_paid_status, $state_id, $city_id, $month, $payment_month_pb,$invoice_month);

    // Prepare the data for JSON response
    $data = [];
    foreach ($invoices as $index => $invoice) {
        // Perform Calculations
        $totalLoanAmt = 0;
      $sumTotalCommiCol = 0;
      $sum_fix_commi_rr = 0;

        // Fetch related invoice items to perform detailed calculations
        $invoiceItems = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoice->inv_batchno])->get()->result_array();
        $applicantLog = $this->db->select('invoices.*, mst_user.user_name, mst_user.disb_date,mst_user.id as link_user_id,mst_user.login_code, mst_loan_type.name as loan_type_name')
                            ->from('invoices')
                            ->join('mst_user', 'invoices.user_id = mst_user.id')
                            ->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id')  // Join with mst_loan_type on loan_type_id
                            ->where(['invoices.inv_batchno' => $invoice->inv_batchno])
                            ->order_by('mst_user.disb_date', 'ASC')
                            ->get()
                            ->result_array();
                            
                              
                                // Generate formatted applicants list
                                    $formattedApplicants = '';
                                    foreach ($applicantLog as $sr => $val) {
                                        $link = ($val['login_code'] === 'PaisaBazaar') 
                                            ? base_url('admin/pb_user_form/' . $val['link_user_id']) 
                                            : base_url('admin/applicant_form/' . $val['link_user_id']);
                                    
                                        $formattedApplicants .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' . $val['user_name'] . '</a> (' . $val['loan_type_name'] . ') ';
                                    
                                       if (isset($_SESSION['staff_id']) && ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13 || $_SESSION['staff_id'] == 538)) {
                                            $formattedApplicants .= ' <i class="bi bi-trash text-danger" style="cursor: pointer;" onclick="deleteApplicantPBInvoice(' . $val['id'] . ', ' . $val['user_id'] . ', \'' . addslashes($val['user_name']) . '\')"></i>';
                                        }
                                    
                                        $formattedApplicants .= '<br>';
                                    }

                                
                                $applicant_names = '';
        foreach ($applicant_log as $sr => $val) {
            $link = ($val['login_code'] === 'PaisaBaazar') 
                ? base_url('admin/pb_user_form/' . $val['id']) 
                : base_url('admin/applicant_form/' . $val['id']);
            
            $applicant_names .= ($sr + 1) . ') <a href="' . $link . '" target="_blank">' . $val['user_name'] . '</a><br>';
        }



        
        foreach ($invoiceItems as $item) {
            $user_data = $this->db->select("*")->from('mst_user')->where(['id' => $item['user_id']])->get()->row();
            $created_by = $this->db->select("*")->where(['staff_id' => $item['created_by']])->from('mst_staff')->get()->row();
            $loanAmount = $user_data->loan_type_id == 5 ? $user_data->rinnraksha_amt : $user_data->sanction_amt;
            $totalLoanAmt += $loanAmount;
         
            if ($user_data->loan_type_id == 5) {
                $rr_aact = $this->db->select("*")->where(['applicant_rr_id' => $user_data->id, 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
                
                if ($user_data->rinnraksha_status == 'Yes' && empty($user_data->applicant_rr_id)) {
                    $rr_sanction_amt = $this->db->select("*")->where(['id' => @$rr_aact->id])->from('mst_user')->get()->row();
                    $sanctionAmt = $rr_sanction_amt->sanction_amt ?? 0;

                    
                                    $special_account_rr = [43649502244,43595982432,43658580288]; 
                                   
                                        // Check if bank account is in special accounts
                                        if (in_array($rr_aact->rr_cbs_acct_no, $special_account_rr)) {
                                            $commission = 4000;
                                        } elseif ($sanctionAmt < 5000000) { // Below 50 Lacs
                                            $commission = 4000;
                                        } elseif ($sanctionAmt == 5000000) { // Exactly 50 Lacs
                                            $commission = 5000;
                                        } elseif ($sanctionAmt > 5000000 && $sanctionAmt <= 10000000) { // Above 50 Lacs to 1 Cr
                                            $commission = 5000;
                                        } elseif ($sanctionAmt > 10000000) { // Above 1 Cr
                                            $commission = 6000;
                                        }

                    $sum_fix_commi_rr += $commission;
 
                }
            }


         
        
            // General Commission Calculations
if ($user_data->loan_type_id == 4) {
    $pb_commi = 0.20; // Use decimal value for calculations
} elseif ($user_data->loan_type_id == 6) {
    $pb_commi = 0.30;
} else {
    $pb_commi = $user_data->pb_commi;
}

// Special accounts with fixed commission
$special_accounts = [43659801785, 43640311043];

if (in_array($user_data->bank_acct_no, $special_accounts)) {
    $total_commi_row = 2000; // Fixed commission for special accounts
} else {
    $total_commi_row = ($loanAmount * $pb_commi) / 100; // Commission based on loan amount
}

// Add total commission row to column sum
$sumTotalCommiCol += $total_commi_row;
           
        }

        // Net Payable Amount Calculation
        $ninety95_col_sum = ($sumTotalCommiCol + $sum_fix_commi_rr);
        $netPayamt = $ninety95_col_sum + $ninety95_col_sum * 0.18;  // Including tax

        // Calculate Total Paid Amount and Remaining Balance
        $invoiceLogs = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoice->inv_batchno])->get()->result_array();
        $totalpayamt = 0;
        $totalTDSamt = 0;

        foreach ($invoiceLogs as $log) {
            $totalpayamt += $log['pay_amt'];
            $totalTDSamt += $log['tds_amt'];
        }

        $tot_paid_amt = $totalpayamt;
        $TDS_amt = $totalTDSamt;
        $rmain_bal = $netPayamt - $TDS_amt - $tot_paid_amt;

        // Determine payment status and corresponding badge class
        $payment = $this->db->select("*")->where(['invoice_batchno' => $invoice->inv_batchno, 'invoice_type' => 'inv_pb'])->from('invoice_log')->order_by('add_date', 'DESC')->get()->row();
        $statusP = isset($payment) && isset($payment->status) ? $payment->status : "unpaid";
        $badge_class = $this->get_badge_class($statusP);
        
        
        
        $allowed_staff_ids = [14, 13, 538, 889];
        $session_staff_id = $this->session->userdata('staff_id');
        
        $pbinvoice_date_html = '
                    <span class="editable-pbinvoice-date" 
                          data-invoice="' .  $invoice->inv_batchno . '" 
                          data-current-date="' . $invoice->invoice_date . '">
                        ' . date('d.m.Y', strtotime($invoice->invoice_date)) . '
                    </span>';
                
                if (in_array($session_staff_id, $allowed_staff_ids)) {
            $pbinvoice_date_html .= '
                <i class="bi bi-pencil-square edit-pbinvoice-date-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Date"
                   data-invoice="' . $invoice->inv_batchno . '" 
                   data-current-date="' . $invoice->invoice_date . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editPbInvoiceDateModal">
                </i>';
        }
        
        $pbinvoice_num_html = '<a target="_BLANK" href="' . base_url() . 'Invoice_pdf_pb/generatePDF/' . $invoice->inv_batchno . '">' . $invoice->invoice_number . '</a>';
       
        if (in_array($session_staff_id, $allowed_staff_ids = [14])) {
            $pbinvoice_num_html .= '
                <i class="bi bi-pencil-square edit-pbinvoice-num-btn" 
                   style="cursor: pointer; margin-left: 6px;" 
                   title="Edit Invoice Number"
                   data-invoice="' . $invoice->inv_batchno . '" 
                   data-current-num="' . $invoice->invoice_number . '" 
                   data-bs-toggle="modal" 
                   data-bs-target="#editPbInvoiceNumModal">
                </i>';
        }



        // Prepare data for DataTables
        $data[] = [
            "sr_no" => $index + 1 + $start,
           /* "city_name" => $invoice->city_name,
            "rbo_name" => $invoice->rbo_name,*/
            "applicant_name" => $formattedApplicants,
            "loan_list" => '<!--<a target="_BLANK" href="' . base_url() . 'admin/pb_loan_list/' . $invoice->inv_batchno . '">View</a><br>--><a target="_BLANK" href="' . base_url() . 'Pb_excel/export_excel_pb_invoice_list/' . $invoice->inv_batchno . '">Format Excel 1</a><br><a target="_BLANK" href="' . base_url() . 'Pb_excel/export_excel_pb_invoice_format2/' . $invoice->inv_batchno . '">Format Excel 2</a>',
            "invoice_number" => $pbinvoice_num_html,
            "bill_amount" => number_format($netPayamt, 2),
            "subtotal" => number_format($sumTotalCommiCol + $sum_fix_commi_rr, 2),
            "received_amount" => number_format($tot_paid_amt, 2),
            "balance" => number_format($rmain_bal, 2),
            "invoice_date" => $pbinvoice_date_html,
            "payment_log" => $this->format_payment_log_rbo($invoiceLogs),
            "created_date" => date('d.m.Y', strtotime($invoice->add_date)),
            "payment_status" => '<span class="' . $badge_class . '">' . ucfirst($statusP) . '</span>',
            "created_by" => $created_by->staff_fullname,
            "edit_options" => $this->generate_edit_buttons_pb($invoice->inv_batchno, $netPayamt, $rmain_bal, $invoice->invoice_number)
        ];
    }

    // Output to JSON format
    $output = [
        "draw" => $draw,
        "recordsTotal" => $totalInvoices,
        "recordsFiltered" => $totalInvoices,
        "data" => $data
    ];
    echo json_encode($output);
}



 // Helper method to generate edit buttons for each row
    private function generate_edit_buttons_pb($invoiceNumber, $netPayAmt, $remainingBal, $invoiceNum) {
        $buttons = '<div class="d-flex align-items-center gap-3 fs-6">';
        // Edit payment status button
         if ($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13 || $_SESSION['staff_id'] == 1 || $_SESSION['staff_id'] == 538) {
            $buttons .= '<a href="javascript:;" class="text-primary edit-status" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Payment Status" aria-label="Views" onclick="openInvoiceModal(\'' . $invoiceNumber . '\',\'' . $netPayAmt . '\',\'' . $remainingBal . '\',\'' . $invoiceNum . '\')">';
            $buttons .= '<img src="' . base_url() . 'assets/site_img/payment.png" height="17" width="17"></a>';
         }
        // Delete payment log button
        if ($_SESSION['staff_id'] == 14) { 
        $buttons .= '<a href="javascript:;" class="text-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete Payment" aria-label="Views" onclick="DeletePaymentLog(\'' . $invoiceNumber . '\')">';
        $buttons .= '<img src="' . base_url() . 'assets/site_img/payment_delete.png" height="18" width="18"></a>';
        }
        // Print invoice button
        $buttons .= '<a href="' . base_url() . 'Invoice_pdf_pb/generatePDF/' . $invoiceNumber . '" target="_BLANK" class="text-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="View Invoice" aria-label="Views">';
        $buttons .= '<i class="bi bi-printer"></i></a>';

        // Delete invoice button (conditionally displayed)
        if ($this->admin_profile->is_right_delete == 'yes') {
            $buttons .= '<a href="javascript:;" class="text-danger delete" data-id="' . $invoiceNumber . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_invoice_pb">';
            $buttons .= '<i class="bi bi-trash-fill"></i></a>';
        }

        $buttons .= '</div>';
        return $buttons;
    }

    // Helper method to format payment logs
    private function format_payment_log_pb($paymentLogs) {
        $formattedLogs = '';
        foreach ($paymentLogs as $log) {
            $formattedLogs .= 'Pay Date: ' . date('d.m.Y', strtotime($log['payment_date'])) . '<br>';
            $formattedLogs .= 'Pay Amt: ' . number_format($log['pay_amt'], 2) . '<br>';
            $formattedLogs .= 'TDS Amt: ' . number_format($log['tds_amt'], 2) . '<br>';
            $formattedLogs .= 'Ref No/Cheq No: ' . $log['bank_details'] . '<br>';
            $formattedLogs .= 'Remark: ' . $log['remark'] . '<br><br>';
        }
        return $formattedLogs;
    }





public function save_invoice_log_pb() {

    if ($this->input->is_ajax_request()) {
        // Retrieve form data
        $invoiceId = $this->input->post('invoiceId');
        $paymentDate = $this->input->post('payment_date');
        $totPayable = $this->input->post('total_payable');
        $payAmt = $this->input->post('pay_amt');
        $tdsAmt = $this->input->post('tds_amt');
        $remark = $this->input->post('remark');
        $bankDetails = $this->input->post('bank_details');
        $inv_type = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceId])->get()->row();
        $conn_data = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $inv_type->connector_id])->get()->row();
        
        $netPayamt = $totPayable - $tdsAmt;

        $netpay = $netPayamt;

        $data['invoice_log'] = $this->db->select('*')->from('invoice_log')->where(['invoice_batchno' => $invoiceId])->get()->result_array();
        $totalpayamt = 0;

        foreach ($data['invoice_log'] as $val) {
            $totalpayamt += $val['pay_amt'];
        }

        $payAmt = is_numeric($payAmt) ? $payAmt : 0;
        $tot_paid_amt = $totalpayamt + $payAmt;
        $rmain_bal = $netpay - $tot_paid_amt;

        $last_entry = $this->db->select('*')
            ->from('invoice_log')
            ->where('invoice_batchno', $invoiceId)
            ->order_by('add_date', 'DESC')
            ->limit(1)
            ->get()
            ->row();

        if ($last_entry && $last_entry->status === 'paid') {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'This invoice has already been paid.');
            echo json_encode($message);
            return;
        }

        $tolerance = 100;
        $tot_paid_amt = number_format($tot_paid_amt, 2, '.', '');
        $netpay = number_format($netpay, 2, '.', '');
        $difference = $tot_paid_amt - $netpay;

        if ($difference >= -$tolerance && $difference <= $tolerance) {
            $status = 'paid';
        } elseif ($difference > $tolerance) {
            $status = 'excess paid';
        } else {
            $status = 'partly paid';
        }

        $data = array(
            'invoice_batchno' => $invoiceId,
            'status' => $status,
            'invoice_type' => $inv_type->invoice_type,
            'net_pay' => $netpay,
            'connector_id' => $conn_data->staff_id,
            'payment_date' => $paymentDate,
            'pay_amt' => $payAmt,
            'tds_amt' => $tdsAmt,
            'remark' => $remark,
            'bank_details' => $bankDetails,
            'created_by' => isset($_SESSION['staff_id']) ? $_SESSION['staff_id'] : null
        );

        try {
            if ($this->db->insert('invoice_log', $data)) {
                $u_data = array('pb_pay_status' => $status);
                $pay_applicant_data = array('pb_payment_status' => $status);

                $this->db->where('inv_batchno', $invoiceId);
                $this->db->update('invoices', $u_data);

                $user_ids = $this->db->select('user_id')->from('invoices')->where('inv_batchno', $invoiceId)->get()->result_array();
                foreach ($user_ids as $user_id_val) {
                    $this->db->where('id', $user_id_val['user_id']);
                    $this->db->update('mst_user', $pay_applicant_data);
                }
            }

            $message = array('success' => '0', 'type' => 'success', 'message' => 'Payment data saved successfully.');
        } catch (Exception $e) {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'Database error: ' . $e->getMessage());
        }
    } else {
        $message = array('success' => '1', 'type' => 'error', 'message' => 'Failed. Please try again.');
    }

    echo json_encode($message);
}


/*public function save_invoice_log_pb() {
    if ($this->input->is_ajax_request()) {
        // Retrieve form data
        $invoiceId = $this->input->post('invoiceId');
        $paymentDate = $this->input->post('payment_date');
        $totPayable = $this->input->post('total_payable');
        $payAmt = $this->input->post('pay_amt');
        $tdsAmt = $this->input->post('tds_amt');
        $remark = $this->input->post('remark');
        $bankDetails = $this->input->post('bank_details');

        // Get invoice and connector data
        $inv_type = $this->db->select('*')->from('invoices')->where(['inv_batchno' => $invoiceId])->get()->row();
        $conn_data = $this->db->select('*')->from('mst_staff')->where(['staff_id' => $inv_type->connector_id])->get()->row();
        $connector_id = $conn_data->staff_id;

        $netPayamt = $totPayable - $tdsAmt;
        $netpay = $netPayamt;

        // Get all previous "partly paid" invoices for this connector and invoice type
        $previous_invoices = $this->db->select('*')
            ->from('invoice_log')
            ->where(['connector_id' => $connector_id, 'status' => 'partly paid', 'invoice_type' => 'inv_pb'])
            ->get()
            ->result_array();

        // Calculate the total unpaid balance from previous invoices
        $previous_balance = 0;
        foreach ($previous_invoices as $prev_invoice) {
            $previous_balance += $prev_invoice['net_pay'] - $prev_invoice['pay_amt'];
        }

        // Calculate total required payment and cumulative payment
        $total_required_payment = $netpay + $previous_balance; // Total required amount including previous unpaid balance
        $cumulative_payment = $payAmt + $previous_balance; // Total payment made including previous balance

        // Define tolerance
        $tolerance = 100;
        $cumulative_payment = number_format($cumulative_payment, 2, '.', '');
        $total_required_payment = number_format($total_required_payment, 2, '.', '');
        $difference = $cumulative_payment - $total_required_payment;

        // Determine the status based on cumulative payment and tolerance
        if ($cumulative_payment >= $total_required_payment || abs($difference) <= $tolerance) {
            $status = 'paid';

            // Update all previous "partly paid" invoices to "paid"
            foreach ($previous_invoices as $prev_invoice) {
                $this->db->where('id', $prev_invoice['id']);
                $this->db->update('invoice_log', ['status' => 'paid']);

                // Update `pb_payment_status` in `mst_user` for users associated with the previous "partly paid" invoice
                $user_ids = $this->db->select('user_id')->from('invoices')->where('inv_batchno', $prev_invoice['invoice_batchno'])->get()->result_array();
                foreach ($user_ids as $user_id_val) {
                    $this->db->where('id', $user_id_val['user_id']);
                    $this->db->update('mst_user', ['pb_payment_status' => 'paid']);
                }
            }
        } elseif ($cumulative_payment < $total_required_payment) {
            $status = 'partly paid';
        } else {
            $status = 'excess paid';
        }

        $data = array(
            'invoice_batchno' => $invoiceId,
            'status' => $status,
            'invoice_type' => $inv_type->invoice_type,
            'net_pay' => $netpay,
            'connector_id' => $connector_id,
            'payment_date' => $paymentDate,
            'pay_amt' => $payAmt,
            'tds_amt' => $tdsAmt,
            'remark' => $remark,
            'bank_details' => $bankDetails,
            'created_by' => isset($_SESSION['staff_id']) ? $_SESSION['staff_id'] : null
        );

        try {
            if ($this->db->insert('invoice_log', $data)) {
                // Update the current invoice status to the determined status
                $u_data = array('pb_pay_status' => $status);
                $pay_applicant_data = array('pb_payment_status' => $status);

                $this->db->where('inv_batchno', $invoiceId);
                $this->db->update('invoices', $u_data);

                // Update the status of the users related to the current invoice
                $user_ids = $this->db->select('user_id')->from('invoices')->where('inv_batchno', $invoiceId)->get()->result_array();
                foreach ($user_ids as $user_id_val) {
                    $this->db->where('id', $user_id_val['user_id']);
                    $this->db->update('mst_user', $pay_applicant_data);
                }
            }

            $message = array('success' => '0', 'type' => 'success', 'message' => 'Payment data saved successfully.');
        } catch (Exception $e) {
            $message = array('success' => '1', 'type' => 'error', 'message' => 'Database error: ' . $e->getMessage());
        }
    } else {
        $message = array('success' => '1', 'type' => 'error', 'message' => 'Failed. Please try again.');
    }
    echo json_encode($message);
}*/


public function delete_invoice_pb($inv_batchno) {
    $this->db->trans_start();

    $invoice_data = $this->db->select("*")->where(['inv_batchno' => $inv_batchno])->from('invoices')->get()->result_array();
    // Fetch invoice log
    $invoice_log = $this->db->select("*")->where(['invoice_batchno' => $inv_batchno])->from('invoice_log')->get()->row();
    
    // If the invoice log is empty, proceed with deletion
    if (empty($invoice_log->invoice_batchno)) {

        foreach ($invoice_data as $invoice) {
            $user_data = $this->db->select("*")->where(['id' => $invoice['user_id']])->from('mst_user')->get()->row();

            $this->db->set('pb_genrated', 'No');
          
            $this->db->where('id', $user_data->id);
            $this->db->update('mst_user');

            // Save deleted invoice log
            $deleted_log = array(
                'inv_batchno' => $invoice['inv_batchno'],
                'invoice_number' => $invoice['invoice_number'],
                'user_id' => $invoice['user_id'],
                'invoice_date' => $invoice['invoice_date'],
                'deleted_at' => date('Y-m-d H:i:s'),
                'inv_type' => 'inv_pb',
                'deleted_by' => $this->session->userdata('staff_id'), // Assuming you have user session data
                'invoice_data' => json_encode($invoice) // Encode the entire invoice as JSON
            );
            $this->db->insert('deleted_invoice_log', $deleted_log);
        }

        // Delete invoices
        $this->db->where('inv_batchno', $inv_batchno);
        $this->db->delete('invoices');
    } else {
        // If invoice log is not empty, return appropriate message
        $message = array('success' => '0', 'type' => 'error', 'message' => 'This invoice is either under payment processing or has been paid.');
        echo json_encode($message);
        return;
    }

    $this->db->trans_complete();

    if ($this->db->trans_status() === FALSE) {
        $message = array('success' => '0', 'type' => 'error', 'message' => 'Transaction failed. Please try again.');
    } else {
        $message = array('success' => '1', 'type' => 'success', 'message' => 'Deleted Successfully.');
    }

    echo json_encode($message);
}




public function pb_loan_list($inv_batch) {
    $data['current_page'] = 'Invoices PB';
    $data['title'] = 'PB Loan List';
    
    // Fetching the data
    $invoices = $this->ccm->get_invoice_pb_list($inv_batch);
    
    // Group and process data further before passing it to the view:
    $grouped_invoices = [];
    foreach ($invoices as $invoice) {
        // Determine the loan amount based on loan_type_id
        $loan_amount = $invoice['loan_type_id'] == 5 ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];
        
        // Calculate commission amounts and total
        $commission_rate = floatval($invoice['pb_commi']);
        $amt_100 = $loan_amount * $commission_rate / 100;
        $total_amt = $amt_100;

        // Ensure the branch_code key is initialized correctly
        if (!isset($grouped_invoices[$invoice['branch_code']])) {
            $grouped_invoices[$invoice['branch_code']] = [
                'invoices' => [],
                'totals' => [
                    '100_amt' => 0,
                    'total_amt' => 0,
                ]
            ];
        }

        // Add the current invoice data
        $grouped_invoices[$invoice['branch_code']]['invoices'][] = array_merge($invoice, [
            'loan_amount' => $loan_amount,
            '100_amt' => $amt_100,
            'total_amt' => $total_amt,
        ]);

        // Accumulate totals
        $grouped_invoices[$invoice['branch_code']]['totals']['100_amt'] += $amt_100;
        $grouped_invoices[$invoice['branch_code']]['totals']['total_amt'] += $total_amt;

        // If loan_type_id is 5 (Rinnraksha), calculate and add RR Commission totals
        if ($invoice['loan_type_id'] == 5) {
            $rr_commission = 0;
            $rr_main_account = $this->db->select("*")
                ->where(['applicant_rr_id' => $invoice['user_id'], 'rinnraksha_status' => 'Yes'])
                ->from('mst_user')
                ->get()
                ->row();

            if ($rr_main_account && $rr_main_account->sanction_amt == 5000000) {
                // If the sanction amount is exactly 50 lakh, set commission to 4000
                $rr_commission = 4000;
            } elseif ($rr_main_account && $rr_main_account->sanction_amt < 5000000) {
                $rr_commission = 4000;
            } elseif ($rr_main_account && $rr_main_account->sanction_amt > 5000000 && $rr_main_account->sanction_amt < 10000000) {
                $rr_commission = 5000;
            } elseif ($rr_main_account && $rr_main_account->sanction_amt >= 10000000) {
                $rr_commission = 6000;
            }

            
            // Add RR Commission to totals
            $grouped_invoices[$invoice['branch_code']]['totals']['100_amt'] += $rr_commission;
        }
    }

    $data['invoice_batch'] = $inv_batch;
    $data['invoices'] = $grouped_invoices;
    $data['viewfile'] = "admin/manage_invoice_cases_pb/pb_loan_list";
    $this->load->view('admin/layout', $data);
}


public function delete_appraisal_letter_one($letter_id)
{
    $this->db->where('id', $letter_id);
    $letter = $this->db->get('appraisal_letters')->row();

    if ($letter) {
        $file_path = FCPATH . 'assets/uploads/documents/' . $letter->appraisal_letter;

        if (file_exists($file_path)) {
            unlink($file_path);
        }

        $this->db->where('id', $letter_id);
        $this->db->delete('appraisal_letters');
        $this->session->set_flashdata('message', 'Appraisal letter deleted successfully.');
    } else {
        $this->session->set_flashdata('message', 'Appraisal letter not found.');
    }

    redirect($_SERVER['HTTP_REFERER']);
}

public function delete_appraisal_letter_two($letter_id)
{
    $this->db->where('id', $letter_id);
    $letter = $this->db->get('appraisal_letters')->row();

    if ($letter) {
        $file_path = FCPATH . 'assets/uploads/documents/' . $letter->apprisal_letter_two;

        if (file_exists($file_path)) {
            unlink($file_path);
        }

        $this->db->where('id', $letter_id);
        $this->db->delete('appraisal_letters');
        $this->session->set_flashdata('message', 'Appraisal letter deleted successfully.');
    } else {
        $this->session->set_flashdata('message', 'Appraisal letter not found.');
    }

    redirect($_SERVER['HTTP_REFERER']);
}


public function delete_final_sanction_letter($letter_id)
{
    // Fetch the final sanction letter entry from the database
    $this->db->where('id', $letter_id);
    $letter = $this->db->get('appraisal_letters')->row();

    if ($letter) {
        // Define file path
        $file_path = FCPATH . 'assets/uploads/documents/' . $letter->final_sanction_letter;

        // Check if file exists, then delete it
        if (file_exists($file_path)) {
            unlink($file_path); // Delete the file
        }

        // Delete the entire record from the database
        $this->db->where('id', $letter_id);
        $this->db->delete('appraisal_letters');

        // Set success message and redirect
        $this->session->set_flashdata('message', 'Final sanction letter deleted successfully.');
    } else {
        // Set error message if the file doesn't exist
        $this->session->set_flashdata('message', 'Final sanction letter not found.');
    }

    // Redirect back to the previous page
    redirect($_SERVER['HTTP_REFERER']);
}


public function delete_proof_disb($letter_id)
{
    // Fetch the proof of disbursement entry from the database
    $this->db->where('id', $letter_id);
    $letter = $this->db->get('appraisal_letters')->row();

    if ($letter) {
        // Define file path
        $file_path = FCPATH . 'assets/uploads/documents/' . $letter->proof_disb;

        // Check if file exists, then delete it
        if (file_exists($file_path)) {
            unlink($file_path); // Delete the file
        }

        // Delete the entire record from the database
        $this->db->where('id', $letter_id);
        $this->db->delete('appraisal_letters');

        // Set success message and redirect
        $this->session->set_flashdata('message', 'Proof of disbursement deleted successfully.');
    } else {
        // Set error message if the file doesn't exist
        $this->session->set_flashdata('message', 'Proof of disbursement not found.');
    }

    // Redirect back to the previous page
    redirect($_SERVER['HTTP_REFERER']);
}



public function delete_appraisal_letter_for_user_zero() {
    // Load the database
    $this->load->database();

    // Get all appraisal letters where user_id is 0
    $query = $this->db->select('id, appraisal_letter')
                      ->where('user_id', 0)
                      ->get('appraisal_letters');

    // Check if there are any results
    if ($query->num_rows() > 0) {
        foreach ($query->result() as $row) {
            // Define the file path to the appraisal letter
            $file_path = FCPATH . 'assets/uploads/documents/' . $row->appraisal_letter; // Adjust the path according to your folder structure

            // Check if the file exists
            if (file_exists($file_path)) {
                // Delete the file from the folder
                if (unlink($file_path)) {
                    echo 'Deleted file: ' . $file_path . '<br>';
                } else {
                    echo 'Error deleting file: ' . $file_path . '<br>';
                }
            } else {
                echo 'File not found: ' . $file_path . '<br>';
            }

            // Now delete the record from the database
            $this->db->where('id', $row->id);
            $this->db->delete('appraisal_letters');

            if ($this->db->affected_rows() > 0) {
               // echo 'Deleted record with ID: ' . $row->id . '<br>';
            } else {
               // echo 'Failed to delete record with ID: ' . $row->id . '<br>';
            }
        }

       // echo 'Appraisal letters and records with user_id = 0 successfully deleted.';
    } else {
      //  echo 'No records found with user_id = 0.';
    }
}



/*public function manage_dash_reports() {  
    $data['current_page'] = 'dash_reports';
    $data['title'] = 'Report';
    
    // Determine the financial year range dynamically
    $currentMonth = date('m');
    $currentYear = date('Y');
    if ($currentMonth >= 4) {
        $financialYearStart = $currentYear . '-04-01';
        $financialYearEnd = ($currentYear + 1) . '-03-31';
    } else {
        $financialYearStart = ($currentYear - 1) . '-04-01';
        $financialYearEnd = $currentYear . '-03-31';
    }

    // Pass the financial year start and end to the method
    $monthly_totals = $this->Hlc_model->get_monthly_totals_mb_pb($financialYearStart, $financialYearEnd);
    
    $data['monthly_totals'] = $monthly_totals;
    
    
     // Fetch monthly case counts paisabazzar
    $data['monthly_data'] = $this->ccm->get_monthly_case_counts();
    
    $data['monthly_data_rbo'] = $this->ccm->get_monthly_rbo_cases_data();
   // $data['get_rbo_cases_data_monthly'] = $this->ccm->get_rbo_cases_data_monthly();
   

    $data['viewfile'] = "admin/manage_dash_data/pb_dash_report";
    $this->load->view('admin/layout', $data);
}*/


public function manage_dash_reports() {  
    $data['current_page'] = 'dash_reports';
    $data['title'] = 'Report';

    // Get financial year from user selection (default to current financial year)
    $selected_fy = $this->input->get('fy') ?? '24-25'; // Default to 2024-25

    // Determine start and end date based on the selected financial year
    if ($selected_fy == '24-25') {
        $financialYearStart = '2024-04-01';
        $financialYearEnd = '2025-03-31';
    } elseif ($selected_fy == '25-26') {
        $financialYearStart = '2025-04-01';
        $financialYearEnd = '2026-03-31';
    } else {
        $financialYearStart = '2024-04-01';
        $financialYearEnd = '2025-03-31'; // Default to 2024-25 if no valid selection
    }

    // Fetch data for selected financial year
    $monthly_totals = $this->Hlc_model->get_monthly_totals_mb_pb($financialYearStart, $financialYearEnd);
    
    $data['monthly_totals'] = $monthly_totals;
    $data['selected_fy'] = $selected_fy;

    // Fetch monthly case counts
    $data['monthly_data'] = $this->ccm->get_monthly_case_counts($financialYearStart,$financialYearEnd);
    $data['monthly_data_rbo'] = $this->ccm->get_monthly_rbo_cases_data();

    // Load the view
    $data['viewfile'] = "admin/manage_dash_data/pb_dash_report";
    $this->load->view('admin/layout', $data);
}


public function manage_dashboard_1() {  
   $data['current_page'] = 'manage_dashboard_1';
    $data['title'] = 'Report';

    // Get financial year from user selection (default to current financial year)
    $selected_fy = $this->input->get('fy') ?? '24-25'; // Default to 2024-25

    // Determine start and end date based on the selected financial year
    if ($selected_fy == '24-25') {
        $financialYearStart = '2024-04-01';
        $financialYearEnd = '2025-03-31';
    } elseif ($selected_fy == '25-26') {
        $financialYearStart = '2025-04-01';
        $financialYearEnd = '2026-03-31';
    } else {
        $financialYearStart = '2024-04-01';
        $financialYearEnd = '2025-03-31'; // Default to 2024-25 if no valid selection
    }

    // Fetch data for selected financial year
    $monthly_totals = $this->Hlc_model->get_monthly_totals_mb_pb($financialYearStart, $financialYearEnd);
    
    $data['monthly_totals'] = $monthly_totals;
    $data['selected_fy'] = $selected_fy;
    
    // Fetch monthly case counts Paisabazar
    $data['monthly_data'] = $this->ccm->get_monthly_case_counts($financialYearStart,$financialYearEnd);
    $data['monthly_data_rbo'] = $this->ccm->get_monthly_rbo_cases_data();
    
    // **Existing City-Wise Logic**
    $cities = $this->db->select('id, city_name')->get('mst_city')->result_array();
    $this->db->select("
        MONTH(user.disb_date) AS month,
        mst_city.city_name,
        mst_city.id AS city_id,
        SUM(CASE WHEN user.loan_type_id = 5 THEN user.rinnraksha_amt ELSE user.sanction_amt END) AS total_amount
    ");
    $this->db->from('mst_user AS user');
    $this->db->join('branch', 'branch.id = user.branch_id', 'inner');
    $this->db->join('mst_city', 'mst_city.id = branch.city_id', 'inner');
    //$this->db->where('YEAR(user.disb_date)', 'YEAR(CURDATE())', FALSE);
    $this->db->where('user.disb_date >=', $financialYearStart);
    $this->db->where('user.disb_date <=', $financialYearEnd);
    $this->db->where('user.login_code', 'PaisaBazaar');
    $this->db->where('user.status', 'Disb Case');
    $this->db->where('user.is_archive', 'No');
   // $this->db->where('user.disb_date IS NOT NULL', null, false);
    $this->db->group_by(["MONTH(user.disb_date)", "branch.city_id"]);
    $this->db->order_by("MONTH(user.disb_date), mst_city.city_name");
    $loans = $this->db->get()->result_array();

    // Prepare City-Wise Data for View
    $loanData = [];
    $monthTotals = [];
    $cityTotals = [];
    foreach ($loans as $loan) {
        $month = (int)$loan['month'];
        $cityKey = $loan['city_name'] . " (" . $loan['city_id'] . ")";

        $loanData[$month][$cityKey] = $loan['total_amount'];

        // Calculate Month-Wise Totals
        if (!isset($monthTotals[$month])) {
            $monthTotals[$month] = 0;
        }
        $monthTotals[$month] += $loan['total_amount'];

        // Calculate City-Wise Totals
        if (!isset($cityTotals[$cityKey])) {
            $cityTotals[$cityKey] = 0;
        }
        $cityTotals[$cityKey] += $loan['total_amount'];
    }

    // Filter Empty Months and Cities
    $filteredMonths = array_filter(array_keys($monthTotals), function ($month) use ($monthTotals) {
        return $monthTotals[$month] > 0;
    });

    $filteredCities = array_filter($cities, function ($city) use ($cityTotals) {
        $cityKey = $city['city_name'] . " (" . $city['id'] . ")";
        return isset($cityTotals[$cityKey]) && $cityTotals[$cityKey] > 0;
    });

    // Pass City-Wise Data to View
    $data['cities'] = $filteredCities;
    $data['loanData'] = $loanData;
    $data['filteredMonths'] = $filteredMonths;
    $data['cityTotals'] = $cityTotals;


     // Fetch staff data for mapping
    $this->db->select('staff.staff_id, staff.staff_fullname AS connector_name, created_by_staff.staff_fullname AS created_by_name');
    $this->db->from('mst_staff AS staff');
    $this->db->join('mst_staff AS created_by_staff', 'staff.created_by = created_by_staff.staff_id', 'left');
    $staff = $this->db->get()->result_array();

    // Map `created_by` names
    $staffMap = [];
    foreach ($staff as $person) {
        $staffMap[$person['staff_id']] = $person['created_by_name'] ?? 'Unknown';
    }

    // Fetch loans grouped by `created_by`
    $this->db->select("
        MONTH(user.disb_date) AS month,
        created_by_staff.staff_id AS created_by_id,
        created_by_staff.staff_fullname AS created_by_name,
        SUM(CASE WHEN user.loan_type_id = 5 THEN user.rinnraksha_amt ELSE user.sanction_amt END) AS total_amount
    ");
    $this->db->from('mst_user AS user');
    $this->db->join('mst_staff AS staff', 'user.connector_id = staff.staff_id', 'inner');
    $this->db->join('mst_staff AS created_by_staff', 'staff.created_by = created_by_staff.staff_id', 'inner');
    $this->db->where('user.disb_date >=', $financialYearStart);
    $this->db->where('user.disb_date <=', $financialYearEnd);
    $this->db->where('user.login_code', 'PaisaBazaar');
    $this->db->where('user.status', 'Disb Case');
    $this->db->where('user.is_archive', 'No');
    $this->db->where('user.disb_date IS NOT NULL', null, false);
    $this->db->group_by(["MONTH(user.disb_date)", "created_by_staff.staff_id"]);
    $this->db->order_by("MONTH(user.disb_date), created_by_staff.staff_fullname");
    $createdByLoans = $this->db->get()->result_array();

    // Prepare data for "Created By" table
    $createdByData = [];
    $createdByTotals = [];
    foreach ($createdByLoans as $loan) {
        $month = (int)$loan['month'];
        $createdByName = $loan['created_by_name'] ?? 'Unknown';

        // Save loan amount
        $createdByData[$month][$createdByName] = $loan['total_amount'];

        // Calculate totals for each `Created By`
        if (!isset($createdByTotals[$createdByName])) {
            $createdByTotals[$createdByName] = 0;
        }
        $createdByTotals[$createdByName] += $loan['total_amount'];
    }

    // Filter `Created By` with totals > 0
    $filteredCreatedBy = array_filter(array_keys($createdByTotals), function ($createdBy) use ($createdByTotals) {
        return $createdByTotals[$createdBy] > 0;
    });

    // Pass data to the view
    $data['filteredCreatedBy'] = $filteredCreatedBy;
    $data['createdByData'] = $createdByData;
    $data['createdByTotals'] = $createdByTotals;
    $data['filteredMonths'] = array_keys($createdByData); // Months with valid data


   
    // Load the View
    $data['viewfile'] = "admin/manage_dash_data/dashboard_1.php";
    $this->load->view('admin/layout', $data);
}



public function get_partner_by_code()
{
    $hlc_code = $this->input->post('hlc_code'); // Get the HLC code from the AJAX request
    $partner = $this->ccm->get_single_row('mst_staff', array('hlc_code' => $hlc_code)); // Query to fetch the partner

    if ($partner) {
        echo json_encode(['status' => 'success', 'partner' => $partner]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Partner not found.']);
    }
}


public function delete_invoice_pb_applicant() {
    $invoiceId = $this->input->post('invoice_id');
    $userId = $this->input->post('user_id');

    // Step 0: Check if pb_payment_status is "Paid" or "Excess Paid"
    $user = $this->db->select('pb_payment_status')
                     ->from('mst_user')
                     ->where('id', $userId)
                     ->get()
                     ->row();

    if ($user && (strtolower($user->pb_payment_status) === 'paid' || strtolower($user->pb_payment_status) === 'excess paid')) {
        echo json_encode(['success' => false, 'message' => 'Cannot delete: Payment status is Paid or Excess Paid.']);
        return;
    }

    // Begin transaction
    $this->db->trans_start();

    try {
        // Step 1: Delete the invoice entry
        $this->db->where('id', $invoiceId);
        if (!$this->db->delete('invoices')) {
            throw new Exception('Failed to delete invoice. DB error: ' . $this->db->error()['message']);
        }

        // Step 2: Update the user in mst_user table
        $this->db->where('id', $userId);
        if (!$this->db->update('mst_user', [
            'pb_genrated' => 'No',
            'pb_invoice_id' => NULL
        ])) {
            throw new Exception('Failed to update user. DB error: ' . $this->db->error()['message']);
        }

        // Complete transaction
        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            throw new Exception('Transaction failed.');
        }

        echo json_encode(['success' => true, 'message' => 'Invoice deleted successfully.']);
    } catch (Exception $e) {
        // Rollback and log the error
        $this->db->trans_rollback();
        log_message('error', $e->getMessage());
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
}



public function delete_invoice_branch_applicant() {
    $invoiceId = $this->input->post('invoice_id');
    $userId = $this->input->post('user_id');

    // Step 0: Check if pb_payment_status is "Paid" or "Excess Paid"
    $user = $this->db->select('sbi_payment_status')
                     ->from('mst_user')
                     ->where('id', $userId)
                     ->get()
                     ->row();

    if ($user && (strtolower($user->sbi_payment_status) === 'paid' || strtolower($user->sbi_payment_status) === 'excess paid')) {
        echo json_encode(['success' => false, 'message' => 'Cannot delete: SBI Payment status is Paid or Excess Paid This Applicant']);
        return;
    }

    // Begin transaction
    $this->db->trans_start();

    try {
        // Step 1: Delete the invoice entry
        $this->db->where('id', $invoiceId);
        if (!$this->db->delete('invoices')) {
            throw new Exception('Failed to delete invoice. DB error: ' . $this->db->error()['message']);
        }

        // Step 2: Update the user in mst_user table
        $this->db->where('id', $userId);
        if (!$this->db->update('mst_user', [
            'branch_genrated' => NULL,
            'branch_invoice_id' => NULL
        ])) {
            throw new Exception('Failed to update user. DB error: ' . $this->db->error()['message']);
        }

        // Complete transaction
        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            throw new Exception('Transaction failed.');
        }

        echo json_encode(['success' => true, 'message' => 'Invoice deleted successfully.']);
    } catch (Exception $e) {
        // Rollback and log the error
        $this->db->trans_rollback();
        log_message('error', $e->getMessage());
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
}


public function delete_invoice_rbo_applicant() {
    $invoiceId = $this->input->post('invoice_id');
    $userId = $this->input->post('user_id');

    // Step 0: Check if pb_payment_status is "Paid" or "Excess Paid"
    $user = $this->db->select('sbi_payment_status')
                     ->from('mst_user')
                     ->where('id', $userId)
                     ->get()
                     ->row();

    if ($user && (strtolower($user->sbi_payment_status) === 'paid' || strtolower($user->sbi_payment_status) === 'excess paid')) {
        echo json_encode(['success' => false, 'message' => 'Cannot delete: SBI Payment status is Paid or Excess Paid This Applicant']);
        return;
    }

    // Begin transaction
    $this->db->trans_start();

    try {
        // Step 1: Delete the invoice entry
        $this->db->where('id', $invoiceId);
        if (!$this->db->delete('invoices')) {
            throw new Exception('Failed to delete invoice. DB error: ' . $this->db->error()['message']);
        }

        // Step 2: Update the user in mst_user table
        $this->db->where('id', $userId);
        if (!$this->db->update('mst_user', [
            'sbi_genrated' => 'No',
            'sbi_invoice_id' => NULL
        ])) {
            throw new Exception('Failed to update user. DB error: ' . $this->db->error()['message']);
        }

        // Complete transaction
        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            throw new Exception('Transaction failed.');
        }

        echo json_encode(['success' => true, 'message' => 'Invoice deleted successfully.']);
    } catch (Exception $e) {
        // Rollback and log the error
        $this->db->trans_rollback();
        log_message('error', $e->getMessage());
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
}


public function updateInvoiceSBIManuallyPaid($batchNo, $status = 'paid')
{
   
    // Start transaction for safe updates
    $this->db->trans_start();

    // Update invoice_log table
    $this->db->set('status', $status)
             ->where('invoice_batchno', $batchNo)
             ->update('invoice_log');

    // Update invoices table
    $this->db->set('sbi_status', $status)
             ->where('inv_batchno', $batchNo)
             ->update('invoices');

    // Update mst_user table
    $this->db->set('sbi_payment_status', $status)
             ->where_in('id', function ($query) use ($batchNo) {
                 $query->select('user_id')
                       ->from('invoices')
                       ->where('inv_batchno', $batchNo);
             })
             ->update('mst_user');

    // Complete transaction
    $this->db->trans_complete();

    // Check if transaction succeeded
    if ($this->db->trans_status() === FALSE) {
        // Log error and rollback transaction
        log_message('error', 'Failed to update statuses for batch: ' . $batchNo);
        return false;
    }

    return true;
}


public function globle_update_sbi_commi()
{
    // Loan Type 1: sanction_amt < 10,000,000 and sbi_commi IS NULL or 0.00
    $this->db->set('sbi_commi', 0.65);
    $this->db->where('loan_type_id', 1);
    $this->db->where('sanction_amt <', 10000000);
    $this->db->group_start();
    $this->db->where('sbi_commi IS NULL');
    $this->db->or_where('sbi_commi', 0.00);
    $this->db->group_end();
    $this->db->update('mst_user');
    //echo "Query 1: " . $this->db->last_query() . "<br>";

    // Loan Type 1: sanction_amt >= 10,000,000 and sbi_commi IS NULL or 0.00
    $this->db->set('sbi_commi', 0.75);
    $this->db->where('loan_type_id', 1);
    $this->db->where('sanction_amt >=', 10000000);
    $this->db->group_start();
    $this->db->where('sbi_commi IS NULL');
    $this->db->or_where('sbi_commi', 0.00);
    $this->db->group_end();
    $this->db->update('mst_user');
    //echo "Query 2: " . $this->db->last_query() . "<br>";
 
    // Loan Type 2: sbi_commi = 0.80 and sbi_commi IS NULL or 0.00  Takeover
    $this->db->set('sbi_commi', 0.80);
    $this->db->where('loan_type_id', 2);
    $this->db->group_start();
    $this->db->where('sbi_commi IS NULL');
    $this->db->or_where('sbi_commi', 0.00);
    $this->db->group_end();
    $this->db->update('mst_user');
    //echo "Query 3: " . $this->db->last_query() . "<br>";

    // Loan Type 3: sbi_commi = 0.80 and sbi_commi IS NULL or 0.00 takeover +topup
    $this->db->set('sbi_commi', 0.80);
    $this->db->where('loan_type_id', 3);
    $this->db->group_start();
    $this->db->where('sbi_commi IS NULL');
    $this->db->or_where('sbi_commi', 0.00);
    $this->db->group_end();
    $this->db->update('mst_user');
   // echo "Query 4: " . $this->db->last_query() . "<br>";

    // Loan Type 4: sbi_commi = 0.20 and sbi_commi IS NULL or 0.00
    $this->db->set('sbi_commi', 0.20);
    $this->db->where('loan_type_id', 4);
    $this->db->group_start();
    $this->db->where('sbi_commi IS NULL');
    $this->db->or_where('sbi_commi', 0.00);
    $this->db->group_end();
    $this->db->update('mst_user');
   //echo "Query 5: " . $this->db->last_query() . "<br>";
   
   // Loan Type 6: sbi_commi = 0.30 and sbi_commi IS NULL or 0.00 LAP
    $this->db->set('sbi_commi', 0.30);
    $this->db->where('loan_type_id', 6);
    $this->db->group_start();
    $this->db->where('sbi_commi IS NULL');
    $this->db->or_where('sbi_commi', 0.00);
    $this->db->group_end();
    $this->db->update('mst_user');
    //echo "Query 3: " . $this->db->last_query() . "<br>";

  
// Loan Type 5: Apply main account's sbi_commi to sub-accounts RR
$loan_type_5_accounts = $this->db->select('id, los_id')
    ->where('loan_type_id', 5)
    ->get('mst_user')
    ->result();

foreach ($loan_type_5_accounts as $sub_account) {
    // Find the main account where this sub-account's ID is stored as applicant_rr_id
    $main_account = $this->db->select('sbi_commi')
        ->where('applicant_rr_id', $sub_account->id) // Match sub-account ID
        ->get('mst_user')
        ->row();

    if ($main_account && !is_null($main_account->sbi_commi) && $main_account->sbi_commi != 0.00) {
        // Update the sub-account's sbi_commi with the main account's sbi_commi
        $this->db->set('sbi_commi', $main_account->sbi_commi)
            ->where('id', $sub_account->id)
            ->update('mst_user');
        //echo "Updated Sub-account ID: {$sub_account->id} with Main-account's sbi_commi: {$main_account->sbi_commi}<br>";
    } else {
        //echo "Skipped Sub-account ID: {$sub_account->id} - No valid main account or sbi_commi found<br>";
    }
}



}




public function updatePartPayout(){
   
    // SQL query equivalent in CodeIgniter
    $this->db->query("
        UPDATE `mst_user` u
        JOIN `mst_staff` s ON u.connector_id = s.staff_id
        SET u.part_payout = s.conn_commision
        WHERE u.part_payout = 0.00
    ");
}

 public function manage_web() {
        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 0) {
            $data['current_page'] = 'Web';
            $data['title'] = 'Web Form List';
            $data['viewfile'] = "admin/manage_web/manage_web";
            $this->load->view('admin/layout', $data);
        } else {
            redirect('admin/manage_users');
        }
    }
    
    public function get_eligibility() {
        $requestData = $_REQUEST;
        
        $columns = [
            0 => 'id',
            1 => 'mobile',
            2 => 'email',
            3 => 'agree',
            4 => 'created_at',
            5 => 'action'
        ];
    
        // Fetch total records without any filtering
        $totalData = $this->db->count_all('mb_check_eligibility');
    
        // Fetch filtered data
         $this->db->select('ch.id, ch.mobile, ch.email, ch.agree, ch.created_at'); 
        $this->db->from('mb_check_eligibility ch');
       
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('ch.mobile', $requestData['search']['value']);
            $this->db->or_like('ch.email', $requestData['search']['value']);
            $this->db->or_like('ch.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $totalFiltered = $this->db->get()->num_rows();
    
        $this->db->select('ch.id, ch.mobile, ch.email, ch.created_at, ch.agree'); 
        $this->db->from('mb_check_eligibility ch');
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('ch.mobile', $requestData['search']['value']);
            $this->db->or_like('ch.email', $requestData['search']['value']);
            $this->db->or_like('ch.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        // Handle the case where length is set to -1 (i.e., "All")
        if ($requestData['length'] != -1) {
            $this->db->limit($requestData['length'], $requestData['start']);
        }
    
        $query = $this->db->get();
    
        $data = [];
        foreach ($query->result_array() as $key => $row) {
            $nestedData = [];
            $nestedData[] = $row['id']; // Sr.No
            $nestedData[] = $row['mobile'];
            $nestedData[] = $row['email'];
            $nestedData[] = $row['agree'];
            $nestedData[] = $row['created_at'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete_eli" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_eligibility"><i class="bi bi-trash-fill"></i></a>' : '') . '
                             </div>';
    
            $data[] = $nestedData;
        }
    
        $json_data = [
            "draw"            => intval($requestData['draw']),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        ];
    
        echo json_encode($json_data);
    }
    
    public function get_freequote() {
        $requestData = $_REQUEST;
        
        $columns = [
            0 => 'id',
            1 => 'name',
            2 => 'mobile',
            3 => 'email',
            3 => 'loanamount',
            4 => 'created_at',
            5 => 'action'
        ];
    
        // Fetch total records without any filtering
        $totalData = $this->db->count_all('mb_freequote');
    
        // Fetch filtered data
         $this->db->select('fq.id, fq.name, fq.mobile, fq.email, fq.loanamount, fq.created_at'); 
        $this->db->from('mb_freequote fq');
       
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('fq.name', $requestData['search']['value']);
            $this->db->or_like('fq.mobile', $requestData['search']['value']);
            $this->db->or_like('fq.email', $requestData['search']['value']);
            $this->db->or_like('fq.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $totalFiltered = $this->db->get()->num_rows();
    
        $this->db->select('fq.id, fq.name, fq.mobile, fq.email, fq.loanamount, fq.created_at'); 
        $this->db->from('mb_freequote fq');
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('fq.mobile', $requestData['search']['value']);
            $this->db->or_like('fq.email', $requestData['search']['value']);
            $this->db->or_like('fq.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        // Handle the case where length is set to -1 (i.e., "All")
        if ($requestData['length'] != -1) {
            $this->db->limit($requestData['length'], $requestData['start']);
        }
    
        $query = $this->db->get();
    
        $data = [];
        foreach ($query->result_array() as $key => $row) {
            $nestedData = [];
            $nestedData[] = $row['id']; // Sr.No
            $nestedData[] = $row['name'];
            $nestedData[] = $row['mobile'];
            $nestedData[] = $row['email'];
            $nestedData[] = $row['loanamount'];
            $nestedData[] = $row['created_at'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete_quote" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_freequote"><i class="bi bi-trash-fill"></i></a>' : '') . '
                             </div>';
    
            $data[] = $nestedData;
        }
    
        $json_data = [
            "draw"            => intval($requestData['draw']),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        ];
    
        echo json_encode($json_data);
    }
    
    public function get_partner() {
        $requestData = $_REQUEST;
        
        $columns = [
            0 => 'id',
            1 => 'name',
            2 => 'mobile',
            3 => 'email',
            4 => 'address',
            5 => 'city',
            6 => 'created_at',
            7 => 'action'
        ];
    
        // Fetch total records without any filtering
        $totalData = $this->db->count_all('mb_become_partner');
    
        // Fetch filtered data
         $this->db->select('p.id, p.name, p.mobile, p.email, p.address, p.city, p.created_at'); 
        $this->db->from('mb_become_partner p');
       
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('p.name', $requestData['search']['value']);
            $this->db->or_like('p.mobile', $requestData['search']['value']);
            $this->db->or_like('p.email', $requestData['search']['value']);
            $this->db->or_like('p.address', $requestData['search']['value']);
            $this->db->or_like('p.city', $requestData['search']['value']);
            $this->db->or_like('p.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $totalFiltered = $this->db->get()->num_rows();
    
        $this->db->select('p.id, p.name, p.mobile, p.email, p.address, p.city, p.created_at'); 
        $this->db->from('mb_become_partner p');
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('p.name', $requestData['search']['value']);
            $this->db->or_like('p.mobile', $requestData['search']['value']);
            $this->db->or_like('p.email', $requestData['search']['value']);
            $this->db->or_like('p.address', $requestData['search']['value']);
            $this->db->or_like('p.city', $requestData['search']['value']);
            $this->db->or_like('p.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        // Handle the case where length is set to -1 (i.e., "All")
        if ($requestData['length'] != -1) {
            $this->db->limit($requestData['length'], $requestData['start']);
        }
    
        $query = $this->db->get();
    
        $data = [];
        foreach ($query->result_array() as $key => $row) {
            $nestedData = [];
            $nestedData[] = $row['id']; // Sr.No
            $nestedData[] = $row['name'];
            $nestedData[] = $row['mobile'];
            $nestedData[] = $row['email'];
            $nestedData[] = $row['address'];
            $nestedData[] = $row['city'];
            $nestedData[] = $row['created_at'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete_partner" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_partner"><i class="bi bi-trash-fill"></i></a>' : '') . '
                             </div>';
    
            $data[] = $nestedData;
        }
    
        $json_data = [
            "draw"            => intval($requestData['draw']),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        ];
    
        echo json_encode($json_data);
    }
    
    public function get_loanenqury() {
        $requestData = $_REQUEST;
        
        $columns = [
            0 => 'id',
            1 => 'name',
            2 => 'mobile',
            3 => 'loanamount',
            4 => 'pincode',
            5 => 'loan_type',
            6 => 'created_at',
            7 => 'action'
        ];
    
        // Fetch total records without any filtering
        $totalData = $this->db->count_all('mb_home_loan');
    
        // Fetch filtered data
         $this->db->select('l.id, l.name, l.mobile, l.loan_amount, l.pincode, l.loan_type, l.created_at'); 
        $this->db->from('mb_home_loan l');
       
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('l.name', $requestData['search']['value']);
            $this->db->or_like('l.mobile', $requestData['search']['value']);
            $this->db->or_like('l.loan_amount', $requestData['search']['value']);
            $this->db->or_like('l.pincode', $requestData['search']['value']);
            $this->db->or_like('l.loan_type', $requestData['search']['value']);
            $this->db->or_like('l.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $totalFiltered = $this->db->get()->num_rows();
    
        $this->db->select('l.id, l.name, l.mobile, l.loan_amount, l.pincode, l.loan_type, l.created_at'); 
        $this->db->from('mb_home_loan l');
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('l.name', $requestData['search']['value']);
            $this->db->or_like('l.mobile', $requestData['search']['value']);
            $this->db->or_like('l.loan_amount', $requestData['search']['value']);
            $this->db->or_like('l.pincode', $requestData['search']['value']);
            $this->db->or_like('l.loan_type', $requestData['search']['value']);
            $this->db->or_like('l.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        // Handle the case where length is set to -1 (i.e., "All")
        if ($requestData['length'] != -1) {
            $this->db->limit($requestData['length'], $requestData['start']);
        }
    
        $query = $this->db->get();
    
        $data = [];
        foreach ($query->result_array() as $key => $row) {
            $nestedData = [];
            $nestedData[] = $row['id']; // Sr.No
            $nestedData[] = $row['name'];
            $nestedData[] = $row['mobile'];
            $nestedData[] = $row['loan_amount'];
            $nestedData[] = $row['pincode'];
            $nestedData[] = $row['loan_type'];
            $nestedData[] = $row['created_at'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete_loanenq" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_enqloan"><i class="bi bi-trash-fill"></i></a>' : '') . '
                             </div>';
    
            $data[] = $nestedData;
        }
    
        $json_data = [
            "draw"            => intval($requestData['draw']),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        ];
    
        echo json_encode($json_data);
    }
    
    public function get_career() {
        $requestData = $_REQUEST;
        
        $columns = [
            0 => 'id',
            1 => 'name',
            2 => 'mobile',
            3 => 'email',
            4 => 'about',
            5 => 'resume',
            6 => 'created_at',
            7 => 'action'
        ];
    
        // Fetch total records without any filtering
        $totalData = $this->db->count_all('mb_career');
    
        // Fetch filtered data
         $this->db->select('c.id, c.name, c.mobile, c.email, c.about, c.resume, c.created_at'); 
        $this->db->from('mb_career c');
       
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('c.name', $requestData['search']['value']);
            $this->db->or_like('c.mobile', $requestData['search']['value']);
            $this->db->or_like('c.email', $requestData['search']['value']);
            $this->db->or_like('c.about', $requestData['search']['value']);
            $this->db->or_like('c.resume', $requestData['search']['value']);
            $this->db->or_like('c.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $totalFiltered = $this->db->get()->num_rows();
        
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('c.name', $requestData['search']['value']);
            $this->db->or_like('c.mobile', $requestData['search']['value']);
            $this->db->or_like('c.email', $requestData['search']['value']);
            $this->db->or_like('c.about', $requestData['search']['value']);
            $this->db->or_like('c.resume', $requestData['search']['value']);
            $this->db->or_like('c.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $this->db->select('c.id, c.name, c.mobile, c.email, c.about, c.resume, c.created_at'); 
        $this->db->from('mb_career c');
    
        // Handle the case where length is set to -1 (i.e., "All")
        if ($requestData['length'] != -1) {
            $this->db->limit($requestData['length'], $requestData['start']);
        }
    
        $query = $this->db->get();
    
        $data = [];
        foreach ($query->result_array() as $key => $row) {
            $nestedData = [];
            $nestedData[] = $row['id']; // Sr.No
            $nestedData[] = $row['name'];
            $nestedData[] = $row['mobile'];
            $nestedData[] = $row['email'];
            $nestedData[] = $row['about'];
            $nestedData[] = '<a href="' . base_url('../resume/' . $row['resume']) . '">'. $row['resume'].'</a>';
            $nestedData[] = $row['created_at'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete_career" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_career"><i class="bi bi-trash-fill"></i></a>' : '') . '
                             </div>';
    
            $data[] = $nestedData;
        }
    
        $json_data = [
            "draw"            => intval($requestData['draw']),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        ];
    
        echo json_encode($json_data);
    }
    
    public function get_call() {
        $requestData = $_REQUEST;
        
        $columns = [
            0 => 'id',
            1 => 'mobile',
            2 => 'created_at',
            3 => 'action'
        ];
    
        // Fetch total records without any filtering
        $totalData = $this->db->count_all('mb_quick_call');
    
        // Fetch filtered data
         $this->db->select('cl.id, cl.mobile, cl.created_at'); 
        $this->db->from('mb_quick_call cl');
       
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('cl.mobile', $requestData['search']['value']);
            $this->db->or_like('cl.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $totalFiltered = $this->db->get()->num_rows();
    
        $this->db->select('cl.id, cl.mobile, cl.created_at'); 
        $this->db->from('mb_quick_call cl');
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('cl.mobile', $requestData['search']['value']);
            $this->db->or_like('cl.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        // Handle the case where length is set to -1 (i.e., "All")
        if ($requestData['length'] != -1) {
            $this->db->limit($requestData['length'], $requestData['start']);
        }
    
        $query = $this->db->get();
    
        $data = [];
        foreach ($query->result_array() as $key => $row) {
            $nestedData = [];
            $nestedData[] = $row['id']; // Sr.No
            $nestedData[] = $row['mobile'];
            $nestedData[] = $row['created_at'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete_call" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_call"><i class="bi bi-trash-fill"></i></a>' : '') . '
                             </div>';
    
            $data[] = $nestedData;
        }
    
        $json_data = [
            "draw"            => intval($requestData['draw']),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        ];
    
        echo json_encode($json_data);
    }
    
    public function get_contact() {
        $requestData = $_REQUEST;
        
        $columns = [
            0 => 'id',
            1 => 'name',
            2 => 'mobile',
            3 => 'email',
            4 => 'address',
            5 => 'city',
            6 => 'created_at',
            7 => 'action'
        ];
    
        // Fetch total records without any filtering
        $totalData = $this->db->count_all('mb_contact');
    
        
        // Fetch filtered data
         $this->db->select('cn.id, cn.name, cn.mobile, cn.email, cn.address, cn.city, cn.created_at'); 
        $this->db->from('mb_contact cn');
       
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('cn.name', $requestData['search']['value']);
            $this->db->or_like('cn.mobile', $requestData['search']['value']);
            $this->db->or_like('cn.email', $requestData['search']['value']);
            $this->db->or_like('cn.address', $requestData['search']['value']);
            $this->db->or_like('cn.city', $requestData['search']['value']);
            $this->db->or_like('cn.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $totalFiltered = $this->db->get()->num_rows();
    
        $this->db->select('cn.id, cn.name, cn.mobile, cn.email, cn.address, cn.city, cn.created_at'); 
        $this->db->from('mb_contact cn');
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('cn.name', $requestData['search']['value']);
            $this->db->or_like('cn.mobile', $requestData['search']['value']);
            $this->db->or_like('cn.email', $requestData['search']['value']);
            $this->db->or_like('cn.address', $requestData['search']['value']);
            $this->db->or_like('cn.city', $requestData['search']['value']);
            $this->db->or_like('cn.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        // Handle the case where length is set to -1 (i.e., "All")
        if ($requestData['length'] != -1) {
            $this->db->limit($requestData['length'], $requestData['start']);
        }
    
        $query = $this->db->get();
    
        $data = [];
        foreach ($query->result_array() as $key => $row) {
            $nestedData = [];
            $nestedData[] = $row['id']; // Sr.No
            $nestedData[] = $row['name'];
            $nestedData[] = $row['mobile'];
            $nestedData[] = $row['email'];
            $nestedData[] = $row['address'];
            $nestedData[] = $row['city'];
            $nestedData[] = $row['created_at'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete_contact" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_contact"><i class="bi bi-trash-fill"></i></a>' : '') . '
                             </div>';
    
            $data[] = $nestedData;
        }
    
        $json_data = [
            "draw"            => intval($requestData['draw']),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        ];
    
        echo json_encode($json_data);
    }
    
    public function get_applyloan() {
        $requestData = $_REQUEST;
        
        $columns = [
            0 => 'id',
            1 => 'fname',
            2 => 'lname',
            3 => 'mobile',
            4 => 'email',
            5 => 'maritalstatus',
            6 => 'gender',
            7 => 'address',
            8 => 'state',
            9 => 'city',
            10 => 'pincode',
            11 => 'property',
            12 => 'bankservice',
            13 => 'propertyvalue',
            14 => 'propertypin',
            15 => 'loanamount',
            16 => 'employment',
            17 => 'annualincome',
            18 => 'appincome', 
            19 => 'emi',
            20 => 'incometax',
            21 => 'agreebox',
            22 => 'created_at',
            23 => 'action'
        ];
    
        // Fetch total records without any filtering
        $totalData = $this->db->count_all('mb_apply_loan');
    
        // Fetch filtered data
        $this->db->select('al.id, al.fname, al.lname, al.mobile, al.email,al.maritalstatus, al.gender, al.address, al.state, al.city,al.pincode, al.property, al.bankservice, al.propertyvalue, al.propertypin,al.loanamount, al.employment, al.annualincome, al.appincome, al.emi, al.incometax, al.agreebox, al.created_at'); 
        $this->db->from('mb_apply_loan al');
    
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('al.fname', $requestData['search']['value']);
            $this->db->or_like('al.lname', $requestData['search']['value']);
            $this->db->or_like('al.mobile', $requestData['search']['value']);
            $this->db->or_like('al.email', $requestData['search']['value']);
            $this->db->or_like('al.maritalstatus', $requestData['search']['value']);
            $this->db->or_like('al.gender', $requestData['search']['value']);
            $this->db->or_like('al.address', $requestData['search']['value']);
            $this->db->or_like('al.state', $requestData['search']['value']);
            $this->db->or_like('al.city', $requestData['search']['value']);
            $this->db->or_like('al.pincode', $requestData['search']['value']);
            $this->db->or_like('al.property', $requestData['search']['value']);
            $this->db->or_like('al.bankservice', $requestData['search']['value']);
            $this->db->or_like('al.propertyvalue', $requestData['search']['value']);
            $this->db->or_like('al.propertypin', $requestData['search']['value']);
            $this->db->or_like('al.loanamount', $requestData['search']['value']);
            $this->db->or_like('al.employment', $requestData['search']['value']);
            $this->db->or_like('al.annualincome', $requestData['search']['value']);
            $this->db->or_like('al.appincome', $requestData['search']['value']);
            $this->db->or_like('al.emi', $requestData['search']['value']);
            $this->db->or_like('al.incometax', $requestData['search']['value']);
            $this->db->or_like('al.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
    
        $totalFiltered = $this->db->get()->num_rows();
        
        if (!empty($requestData['search']['value'])) {
            $this->db->group_start();
            $this->db->like('al.fname', $requestData['search']['value']);
            $this->db->or_like('al.lname', $requestData['search']['value']);
            $this->db->or_like('al.mobile', $requestData['search']['value']);
            $this->db->or_like('al.email', $requestData['search']['value']);
            $this->db->or_like('al.maritalstatus', $requestData['search']['value']);
            $this->db->or_like('al.gender', $requestData['search']['value']);
            $this->db->or_like('al.address', $requestData['search']['value']);
            $this->db->or_like('al.state', $requestData['search']['value']);
            $this->db->or_like('al.city', $requestData['search']['value']);
            $this->db->or_like('al.pincode', $requestData['search']['value']);
            $this->db->or_like('al.property', $requestData['search']['value']);
            $this->db->or_like('al.bankservice', $requestData['search']['value']);
            $this->db->or_like('al.propertyvalue', $requestData['search']['value']);
            $this->db->or_like('al.propertypin', $requestData['search']['value']);
            $this->db->or_like('al.loanamount', $requestData['search']['value']);
            $this->db->or_like('al.employment', $requestData['search']['value']);
            $this->db->or_like('al.annualincome', $requestData['search']['value']);
            $this->db->or_like('al.appincome', $requestData['search']['value']);
            $this->db->or_like('al.emi', $requestData['search']['value']);
            $this->db->or_like('al.incometax', $requestData['search']['value']);
            $this->db->or_like('al.created_at', $requestData['search']['value']);
            $this->db->group_end();
        }
        $this->db->select('al.id, al.fname, al.lname, al.mobile, al.email,al.maritalstatus, al.gender, al.address, al.state, al.city,al.pincode, al.property, al.bankservice, al.propertyvalue, al.propertypin,al.loanamount, al.employment, al.annualincome, al.appincome, al.emi, al.incometax, al.agreebox, al.created_at'); 
        $this->db->from('mb_apply_loan al');
    
    
        // Handle the case where length is set to -1 (i.e., "All")
        if ($requestData['length'] != -1) {
            $this->db->limit($requestData['length'], $requestData['start']);
        }
    
        $query = $this->db->get();
    
        $data = [];
        foreach ($query->result_array() as $key => $row) {
            $nestedData = [];
            $nestedData[] = $row['id']; // Sr.No
            $nestedData[] = $row['fname'];
            $nestedData[] = $row['lname'];
            $nestedData[] = $row['mobile'];
            $nestedData[] = $row['email'];
            $nestedData[] = $row['maritalstatus'];
            $nestedData[] = $row['gender'];
            $nestedData[] = $row['address'];
            $nestedData[] = $row['state'];
            $nestedData[] = $row['city'];
            $nestedData[] = $row['pincode'];
            $nestedData[] = $row['property'];
            $nestedData[] = $row['bankservice'];
            $nestedData[] = $row['propertyvalue'];
            $nestedData[] = $row['propertypin'];
            $nestedData[] = $row['loanamount'];
            $nestedData[] = $row['employment'];
            $nestedData[] = $row['annualincome'];
            $nestedData[] = $row['appincome'];
            $nestedData[] = $row['emi'];
            $nestedData[] = $row['incometax'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">
                                <a href="' . base_url('admin/view_docs/' . $row['id']) . '" class="text-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="View Documents" aria-label="View"><i class="bi bi-eye-fill"></i></a>
                            </div>';
            $nestedData[] = $row['agreebox'] ? 'yes' : 'no';
            $nestedData[] = $row['created_at'];
            $nestedData[] = '<div class="d-flex align-items-center gap-3 fs-6">' . ($this->admin_profile->is_right_delete == 'yes' ? '<a href="javascript:;" class="text-danger delete_apploan" data-id="' . $row['id'] . '" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete" aria-label="Delete" action="delete_applyloan"><i class="bi bi-trash-fill"></i></a>' : '') . '
                             </div>';
    
            $data[] = $nestedData;
        }
    
        $json_data = [
            "draw"            => intval($requestData['draw']),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        ];
    
        echo json_encode($json_data);
    }
    
    public function view_docs($id = '') {
     

    $data['current_page'] = 'View Documents';
    $data['title'] = 'Documents';
    //$data['docs'] = $this->ccm->get_single_row('mb_apply_loan', array('id' => $id));
    
    $data['docs'] = $this->db->select("*")->from('mb_apply_loan')->get()->result_array();
      
    if ($id != '') {
        $data['docs'] = $this->ccm->get_single_row('mb_apply_loan', array('id' => $id));

    } 

    $data['viewfile'] = 'admin/manage_web/view_docs';

    $this->load->view('admin/layout', $data);

}



/*public function transfer_users_to_year() 
{
    $target_year = $this->input->post('year'); 
    $selected_ids = $this->input->post('selected_ids'); 

    if (empty($target_year) || empty($selected_ids)) {
        echo json_encode(['status' => false, 'message' => 'Missing financial year or selected records.']);
        return;
    }

    $target_db_group = ($target_year === '24_25') ? 'default' : 'fin_' . $target_year;

    $source_db = $this->load->database($this->session->userdata('db_group'), TRUE);
    $target_db = $this->load->database($target_db_group, TRUE);

    $success = 0;
    $fail = 0;
    $duplicate = 0;
    $blocked = 0;
    $blocked_ids = [];

    $rr_id_map_by_los = []; // los_id => new_rr_id

    // Step 1: Transfer RR accounts (loan_type_id = 5)
    foreach ($selected_ids as $id) {
        $user = $source_db->where('id', $id)->get('mst_user')->row_array();
        if (!$user || $user['loan_type_id'] != 5) continue;

        if (
            (isset($user['applicant_invoice_status']) && strtolower($user['applicant_invoice_status']) == 'generated') ||
            (isset($user['pb_genrated']) && strtolower($user['pb_genrated']) == 'yes')
        ) {
            $blocked++;
            $blocked_ids[] = $user['user_name'] ?? "ID: $id";
            continue;
        }

        $account_value = $user['rr_cbs_acct_no'] ?? null;
        if ($account_value) {
            $exists = $target_db
                ->where('loan_type_id', 5)
                ->where('rr_cbs_acct_no', $account_value)
                ->get('mst_user')
                ->num_rows();
            if ($exists > 0) {
                $duplicate++;
                continue;
            }
        }

        $old_id = $user['id'];
        $los_id = $user['los_id'];
        unset($user['id']);

        if ($target_db->insert('mst_user', $user)) {
            $new_id = $target_db->insert_id();
            $rr_id_map_by_los[$los_id] = $new_id;
            $source_db->where('id', $old_id)->delete('mst_user');
            $success++;
        } else {
            $fail++;
        }
    }

    // Step 2: Transfer main accounts
    foreach ($selected_ids as $id) {
        $user = $source_db->where('id', $id)->get('mst_user')->row_array();
        if (!$user || $user['loan_type_id'] == 5) continue;

        if (
            (isset($user['applicant_invoice_status']) && strtolower($user['applicant_invoice_status']) == 'generated') ||
            (isset($user['pb_genrated']) && strtolower($user['pb_genrated']) == 'yes')
        ) {
            $blocked++;
            $blocked_ids[] = $user['user_name'] ?? "ID: $id";
            continue;
        }

        $account_value = $user['bank_acct_no'] ?? null;
        if ($account_value) {
            $exists = $target_db
                ->where('loan_type_id', $user['loan_type_id'])
                ->where('bank_acct_no', $account_value)
                ->get('mst_user')
                ->num_rows();
            if ($exists > 0) {
                $duplicate++;
                continue;
            }
        }

        // ✅ Update applicant_rr_id using los_id mapping
        $los_id = $user['los_id'];
        if (isset($rr_id_map_by_los[$los_id])) {
            $user['applicant_rr_id'] = $rr_id_map_by_los[$los_id];
        }

        unset($user['id']);

        if ($target_db->insert('mst_user', $user)) {
            $source_db->where('id', $id)->delete('mst_user');
            $success++;
        } else {
            $fail++;
        }
    }

    echo json_encode([
        'status' => true,
        'message' => "$success transferred, $duplicate duplicate(s), $fail failed, $blocked blocked due to invoice/PB.",
        'blocked_users' => $blocked_ids
    ]);
}*/



public function transfer_users_to_year() 
{
    $target_year = $this->input->post('year'); 
    $selected_ids = $this->input->post('selected_ids'); 

    if (empty($target_year) || empty($selected_ids)) {
        echo json_encode(['status' => false, 'message' => 'Missing financial year or selected records.']);
        return;
    }

    $target_db_group = ($target_year === '24_25') ? 'default' : 'fin_' . $target_year;

    $source_db = $this->load->database($this->session->userdata('db_group'), TRUE);
    $target_db = $this->load->database($target_db_group, TRUE);

    $success = 0;
    $fail = 0;
    $duplicate = 0;
    $blocked = 0;
    $blocked_ids = [];

    $rr_id_map_by_los = []; // los_id => new_rr_id

    // Step 1: Transfer RR accounts (loan_type_id = 5)
    foreach ($selected_ids as $id) {
        $user = $source_db->where('id', $id)->get('mst_user')->row_array();
        if (!$user || $user['loan_type_id'] != 5) continue;

        if (
            (isset($user['applicant_invoice_status']) && strtolower($user['applicant_invoice_status']) == 'generated') ||
            (isset($user['pb_genrated']) && strtolower($user['pb_genrated']) == 'yes')
        ) {
            $blocked++;
            $blocked_ids[] = $user['user_name'] ?? "ID: $id";
            continue;
        }

        $account_value = $user['rr_cbs_acct_no'] ?? null;
        if ($account_value) {
            $exists = $target_db
                ->where('loan_type_id', 5)
                ->where('rr_cbs_acct_no', $account_value)
                ->get('mst_user')
                ->num_rows();
            if ($exists > 0) {
                $duplicate++;
                continue;
            }
        }

        $old_id = $user['id'];
        $los_id = $user['los_id'];
        unset($user['id']);

        if ($target_db->insert('mst_user', $user)) {
            $new_id = $target_db->insert_id();
            $rr_id_map_by_los[$los_id] = $new_id;

            // ✅ Transfer related documents
            $documents = $source_db->where('user_id', $old_id)->get('appraisal_letters')->result_array();
            foreach ($documents as $doc) {
                unset($doc['id']);
                $doc['user_id'] = $new_id;
                $target_db->insert('appraisal_letters', $doc);
                
            }
            $source_db->where('user_id', $old_id)->delete('appraisal_letters');
            $source_db->where('id', $old_id)->delete('mst_user');
            $success++;
        } else {
            $fail++;
        }
    }

    // Step 2: Transfer main accounts
    foreach ($selected_ids as $id) {
        $user = $source_db->where('id', $id)->get('mst_user')->row_array();
        if (!$user || $user['loan_type_id'] == 5) continue;

        if (
            (isset($user['applicant_invoice_status']) && strtolower($user['applicant_invoice_status']) == 'generated') ||
            (isset($user['pb_genrated']) && strtolower($user['pb_genrated']) == 'yes')
        ) {
            $blocked++;
            $blocked_ids[] = $user['user_name'] ?? "ID: $id";
            continue;
        }

        $account_value = $user['bank_acct_no'] ?? null;
        if ($account_value) {
            $exists = $target_db
                ->where('loan_type_id', $user['loan_type_id'])
                ->where('bank_acct_no', $account_value)
                ->get('mst_user')
                ->num_rows();
            if ($exists > 0) {
                $duplicate++;
                continue;
            }
        }

        // ✅ Update applicant_rr_id using los_id mapping
        $los_id = $user['los_id'];
        if (isset($rr_id_map_by_los[$los_id])) {
            $user['applicant_rr_id'] = $rr_id_map_by_los[$los_id];
        }

        $old_id = $user['id'];
        unset($user['id']);

        if ($target_db->insert('mst_user', $user)) {
            $new_id = $target_db->insert_id();

            // ✅ Transfer related documents
            $documents = $source_db->where('user_id', $old_id)->get('appraisal_letters')->result_array();
            foreach ($documents as $doc) {
                unset($doc['id']);
                $doc['user_id'] = $new_id;
                $target_db->insert('appraisal_letters', $doc);
            }
            
            $source_db->where('user_id', $old_id)->delete('appraisal_letters');
            $source_db->where('id', $old_id)->delete('mst_user');
            $success++;
        } else {
            $fail++;
        }
    }

    echo json_encode([
        'status' => true,
        'message' => "$success transferred, $duplicate duplicate(s), $fail failed, $blocked blocked due to invoice/PB.",
        'blocked_users' => $blocked_ids
    ]);
}



  public function delete_partner()
    {
        $id = $this->input->post('id');
    
        if ($id) {
            $this->db->where('id', $id);
            $deleted = $this->db->delete('multi_user');
    
            echo json_encode(['success' => $deleted]);
        } else {
            echo json_encode(['success' => false]);
        }
    }


}



?>