<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="row">
        <div class="col-xl-12 mx-auto">
            <div class="card">
                <div class="card-body">
                    <form id="forms" method="post" action="<?= base_url('admin/submit_split_payment') ?>">
                        <input type="hidden" name="id" value="<?= (isset($user)) ? $user->id : '' ?>">
                        <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">HLC <span style="color:red">*</span></label>
                                    <select id="connector_id" name="connector_id" class="single-select" required>
                                        <option value="">-Select-</option>
                                        <?php foreach ($connector as $value) { ?>
                                            <option value="<?= $value['staff_id']; ?>" <?php if (@$value['staff_id'] == @$user->connector_id) echo 'selected'; ?>>
                                                <?= $value['staff_fullname']; ?>[<?= @$value['conn_commision'] ?>%]
                                            </option>
                                        <?php } ?>
                                    </select>
                                    <span class="error"></span>
                                </div>
                                
                                <div class="col-md-5 mb-3">
                                    <label class="form-label">Sub HLC <span style="color:red">*</span></label>
                                    <select id="sub_hlc_id" name="sub_hlc_id[]" class="multiple-select select2" multiple required>
                                        <option value="">-Select-</option>
                                        <?php
                                        $subhlcids = isset($user) ? json_decode($user->sub_hlc_id) : [];
                                        $selected_connector_id = isset($user->connector_id) ? $user->connector_id : null;
                                        foreach ($connector as $value) {
                                            if ($value['staff_id'] != $selected_connector_id) {
                                                $selected = in_array($value['staff_id'], $subhlcids) ? 'selected' : '';
                                                echo "<option value=\"{$value['staff_id']}\" $selected>{$value['staff_fullname']}</option>";
                                            }
                                        }
                                        ?>
                                    </select>
                                    <span class="error"></span>
                                </div>

                           </div> 
                            <div class="mb-3">
                                 <a href="<?= base_url() ?>admin/manage_split_payment"><button type="button" class="btn btn-primary px-5 radius-30" >Back</button></a>
                                    <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">
                            </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end row-->
</main>

<script>
$(document).ready(function() {
   
    $('#connector_id').change(function() {
        var selectedConnectorId = $(this).val();
        $('#sub_hlc_id option').each(function() {
            if ($(this).val() == selectedConnectorId) {
                $(this).prop('disabled', true).hide();
            } else {
                $(this).prop('disabled', false).show();
            }
        });
        $('#sub_hlc_id').select2(); // Refresh the Select2
    });

    // Trigger change event to set the initial state
    $('#connector_id').trigger('change');
});
</script>
