<main class="page-content">

    <!--breadcrumb-->

    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">

        <div class="breadcrumb-title pe-3"><?= $title ?></div>

    </div>

    <!--end breadcrumb-->

    <div class="row">
        <div class="col-xl-12 mx-auto">
            <div class="card">
                <div class="card-body">
                    <form id="forms" method="post" action="<?= base_url('admin/submit_racpc') ?>">
                    <input type="hidden" name="id" value="<?= (isset($branch)) ? $branch->id : '' ?>">
                        <div class="row">
                             <div class="col-md-3 mb-3">
                            <label class="form-label">State</label>
                            <select name="state_id" class="single-select" id="stateSelect" required>
                                <option value="">-Select-</option>
                               <?php  foreach ($state as  $value) { ?>
                                   <option value="<?= $value['id']; ?>" <?php if(@$value['id']==@$branch->state_id) echo 'selected';?>><?=$value['state_name'];?></option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div> 
                      
                        <div class="col-md-3 mb-3">
                            <label class="form-label">City</label>
                            <select name="city_id" class="single-select" id="citySelect" required>
                                <option value="">-Select-</option>
                            </select>
                            <span class="error"></span>
                        </div> 
                     
                             <div class="col-md-3 mb-3">
                                        <label class="form-label">Circle</label>
                                        <select id="circleSelect" name="circle_id" class="form-control" required>
                                            <option value="">-Select-</option>
                                            <?php foreach($circle as $val) { ?>
                                                <option value="<?= $val['id']; ?>" <?php if(@$branch->circle_id==$val['id']) echo 'selected';?>><?= $val['c_name']; ?>(<?= $val['c_code']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    <span class="error"></span>
                                </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">RACPC Name</label>
                                <input type="text" class="form-control inputs" placeholder="Enter Name" 
                                       name="racpc_name" required value="<?= (isset($branch)) ? $branch->racpc_name : '' ?>">
                                <span class="error"></span>

                            </div>
                            <div class="mb-3">

                                <button type="button" class="btn btn-primary px-5 radius-30" onclick="go_back()">Back</button>

                                <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">

                            </div>

                    </form>

                </div>

            </div>

        </div>



    </div>

</div>

<!--end row-->

</main>

<script>
$(document).ready(function(){
    $('#stateSelect').change(function(){
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('admin/get_cities') ?>',
                type: 'POST',
                data: {state_id: stateId},
                dataType: 'json',
                success: function(data) {
                    $('#citySelect').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#citySelect').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });

                    // Get the customer's city ID
                    var customerCityId = <?= (isset($branch) && $branch->city_id !== null) ? $branch->city_id : 'null' ?>;
                    
                    // Set the selected city in the dropdown
                    if (customerCityId !== null) {
                        $('#citySelect').val(customerCityId);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#citySelect').empty().append('<option value="">-Select-</option>');
        }
    });

    // Trigger change event on page load if state is already selected
    $('#stateSelect').trigger('change');

    // Check if user is editing profile and city ID is null
    var isEditing = <?= (isset($branch) && $branch->id) ? 'true' : 'false' ?>;
    var cityId = <?= (isset($branch) && $branch->city_id !== null) ? $branch->city_id : 'null' ?>;

    if (isEditing && cityId === null) {
        // Display cities state-wise
        $('#stateSelect').trigger('change');
    }
    
    
    
});



</script>