
<div class="modal fade" id="editRboInvoiceDateModal" tabindex="-1" aria-labelledby="editRboInvoiceDateModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="invoiceRboDateForm">
        <div class="modal-header">
          <h5 class="modal-title">Edit Invoice Date</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="invoice_batchno" id="invoice_batchno">
          <label for="invoice_date">Invoice Date</label>
          <input type="date" name="invoice_date" id="invoice_date" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="modal fade" id="editRboInvoiceNumModal" tabindex="-1" aria-labelledby="editRboInvoiceNumModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="invoiceRboNumForm">
        <div class="modal-header">
          <h5 class="modal-title">Edit Invoice Number</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="invoice_batchno" id="invoice_batchno_num">
          <label for="invoice_num">Invoice Number</label>
          <input type="text" name="invoice_num" id="invoice_num" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>


<main class="page-content">
  <!--breadcrumb-->
  <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3"> <?= $title ?> </div>
  </div>
  <!--end breadcrumb-->
  <div class="card">
    <div class="card-body">
      <form action="<?php echo base_url('admin/manage_invoice_sbi'); ?>" method="post">
        <div class="row">
          <div class="col-md-2">
            <label for="start_date">Start Date:</label>
            <input class="form-control" type="date" name="start_date" value="
							<?php echo isset($_POST['start_date']) ? $_POST['start_date'] : ''; ?>">
          </div>
          <div class="col-md-2">
            <label for="end_date">End Date:</label>
            <input class="form-control" type="date" name="end_date" value="
								<?php echo isset($_POST['end_date']) ? $_POST['end_date'] : ''; ?>">
          </div>
          <!-- Branch Select Dropdown -->
           <div class="col-md-2">
            <label for="branch">Branch</label>
            <select class="single-select" id="branch" name="branch">
                <option value="">Select Branch</option>
                <?php $otherBranch = null; ?>
                <?php foreach ($branch as $branchItem) : ?>
                    <?php if ($branchItem['id'] == 100) : ?>
                        <?php $otherBranch = $branchItem; ?>
                    <?php else : ?>
                        <option value="<?= $branchItem['id']; ?>" <?php echo isset($_POST['branch']) && $_POST['branch'] === $branchItem['id'] ? 'selected' : ''; ?>>
                            <?= $branchItem['branch_name']; ?>
                        </option>
                    <?php endif; ?>
                <?php endforeach; ?>
        
                <?php if ($otherBranch !== null) : ?>
                    <!-- Display "Other" at the end if the id is 100 -->
                    <option value="<?= $otherBranch['id']; ?>" <?php echo isset($_POST['branch']) && $_POST['branch'] === $otherBranch['id'] ? 'selected' : ''; ?>>
                        <?= $otherBranch['branch_name']; ?>
                    </option>
                <?php endif; ?>
            </select>
        </div>
          <!-- Connector Select Dropdown --> 
          <?php if($_SESSION['staff_type']==0){ ?> 
          <div class="col-md-2">
            <label for="connector">Partner</label>
            <select class="single-select" id="connector" name="connector">
              <option value="">Select Partner</option> 
              <?php foreach ($connector as $connectorItem) : ?> 
              <option value="<?= $connectorItem['staff_id']; ?>" <?php echo isset($_POST['connector']) && $_POST['connector'] === $connectorItem['staff_id'] ? 'selected' : ''; ?>> 
				<?= $connectorItem['staff_fullname']; ?> </option> 
				<?php endforeach; ?>
            </select>
          </div> <?php } ?>
          
            <div class="col-md-2">
                <label for="sbi_status">Payment SBI Status</label>
               <select name="sbi_status" class="form-control">
                    <option value="">--Select--</option>
                    <option value="paid" <?php echo isset($_POST['sbi_status']) && $_POST['sbi_status'] === 'paid' ? 'selected' : ''; ?>>Paid</option>
                    <option value="unpaid" <?php echo isset($_POST['sbi_status']) && $_POST['sbi_status'] === 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                    <option value="partly paid" <?php echo isset($_POST['sbi_status']) && $_POST['sbi_status'] === 'partly paid' ? 'selected' : ''; ?>>Partly Paid</option>
                    <option value="excess paid" <?php echo isset($_POST['sbi_status']) && $_POST['sbi_status'] === 'excess paid' ? 'selected' : ''; ?>>Excess paid</option>
                </select>
            </div>
          
           <div class="col-md-2 mb-3">
                            <label class="">State</label>
                            <select name="state_id" class="single-select" id="stateSelect">
                                <option value="">-Select-</option>
                               <?php  foreach ($state as  $value) { ?>
                                   <option value="<?= $value['id']; ?>"<?php echo isset($_POST['state_id']) && $_POST['state_id'] === $value['id'] ? 'selected' : ''; ?>><?=$value['state_name'];?></option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div> 
                      
                        <div class="col-md-2 mb-3">
                            <label class="form-label">City</label>
                            <select name="city_id" class="single-select" id="citySelect">
                                <option value="">-Select-</option>
                            </select>
                        </div>
                        <div class="col-md-2 mb-3">
                            <label class="form-label">Month</label>
                            <input type="month" name="month" class="form-control" value="<?php echo isset($_POST['month']) ? $_POST['month'] : ''; ?>">
                        </div>
          <!--<div class="col-md-3">
            <label for="inv_type">Invoice Type</label>
            <select name="inv_type" class="form-control">
              <option value="">--Select--</option>
              <option value="inv_hlc" <?php echo isset($_POST['inv_type']) && $_POST['inv_type'] === 'inv_hlc' ? 'selected' : ''; ?>>Invoice Partner </option>
              <option value="inv_sbi" <?php echo isset($_POST['inv_type']) && $_POST['inv_type'] === 'inv_sbi' ? 'selected' : ''; ?>>Invoice SBI </option>
            </select>
          </div>-->
           <div class="col-md-2">
            <label for="start_date">SBI Payment Date:</label>
            <input class="form-control" type="date" id="payment_date" name="payment_date" value="<?php echo isset($_POST['payment_date']) ? $_POST['payment_date'] : ''; ?>">
          </div>
          <div class="col-md-2">
            <label for="start_date">SBI Payment Amt:</label>
            <input class="form-control" type="text" id="payment_amount" name="payment_amount" value="<?php echo isset($_POST['payment_amount']) ? $_POST['payment_amount'] : ''; ?>">
          </div>
          <div class="col-md-2">
            <label for="invoice_month">Invoice Month:</label>
            <input class="form-control" type="month" id="invoice_month" name="invoice_month" value="<?php echo isset($_POST['invoice_month']) ? $_POST['invoice_month'] : ''; ?>">
          </div>
          <div class="col-md-2">
            <br>
            <input class="btn btn-success" type="submit" value="Submit">
            <input class="btn btn-info" id="resetButton" type="button" value="Reset">
          </div>
      </form>
      <hr class="mt-3">
    <!--  <ul class="nav nav-tabs" id="myTabs">
        <li class="nav-item">
          <a class="nav-link active" id="unclear-tab" data-bs-toggle="tab" href="#unclear">Invoices</a>
        </li>
       <li class="nav-item">
          <a class="nav-link" id="paid-tab" data-bs-toggle="tab" href="#paid">Paid</a>
        </li>
      </ul>-->
      <!-- Bootstrap Tab Content -->
      <div class="tab-content mt-2">
        <div class="tab-pane fade show active" id="unclear">
          <!--<h2>Unclear Invoices</h2>-->
           <!--<form id="perPageForm" method="post" action="<?php echo base_url('admin/manage_invoice_sbi'); ?>">
              <select id="itemsPerPageSelector" name="per_page" onchange="updatePerPage()">
                <option value="">--select--</option>
                <option value="20">20 per page</option>
                <option value="100">100 per page</option>
                <option value="500">500 per page</option>
               
              </select>
            </form>-->
                <div class="table-responsive">
                    <table class="table align-middle table-striped" id="Table">
                        <thead>
                            <tr>
                                <th>Sr.No</th>
                                <th>City</th>
                                <th>RBO</th>
                                <th>Applicant</th>
                                <th>Loan List</th>
                                <th>Inv Number</th>
                                <th>Bill Amt</th>
                                <th>Basic Amt</th>
                                <th>Received Amt</th>
                                <th>Balance</th>
                                <th>Invoice Date</th>
                                <th>Payment Log</th>
                                <th>Created Date</th>
                                <th>Payment Status</th>
                                <th>Created By</th>
                                <th>Edit</th>
                            </tr>
                        </thead>
                        <tbody>
                        <!-- Data will be loaded here via AJAX -->
                        </tbody>
                     <!--  <tfoot>
                            <tr>
                                <th colspan="6" style="text-align:right">Total:</th>
                                <th></th>
                                <th></th> 
                                <th></th> 
                                <th colspan="6"></th>
                            </tr>
                        </tfoot>-->
                    </table>
                </div> <?//= $pagination ?>
          <!-- Display Total Outside Table -->
<div class="row mt-4">
   <!-- <div class="col-12">
        <?php   $result_sbi = calculate_sbi_invoice_balance($this->db, $this->ccm);
               
                $total_pay_amt = $result_sbi['total_pay_amt']; 
                $total_tds_amt = $result_sbi['total_tds_amt']; ?>
       
        <h6>Total Paid Amt: <?= formatIndianNumber($total_pay_amt);   ?></h6>
        <h6>Total TDS Amt: <?= formatIndianNumber($total_tds_amt);   ?></h6>
    </div>-->
</div>
        </div>

    
      </div>
    </div>
  </div>
</main>
<div class="modal fade" id="invoiceModal" tabindex="-1" aria-labelledby="invoiceModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content" style="overflow-y: auto !important; max-height: inherit;">
      <div class="modal-header">
        <h5 class="modal-title" id="invoiceModalLabel">Payment Status <span id="invoiceNumberLabel"></span></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="invoiceForm" action="<?php echo base_url()?>admin/save_invoice_log_sbi" method="post" enctype="multipart/form-data">
        <div class="modal-body">
          <div class="row">
              <input type="hidden" id="invoiceId" name="invoiceId" value="">
            
              <input type="hidden" id="total_payable" name="total_payable" value="">
              <!--<div class="col-lg-4">
                   <label for="invoiceStatus" class="form-label">Invoice Status</label>
                      <select class="form-select"  name="status" required>
                        <option value="">--Select--</option>
                        <option value="Paid">Paid</option>
                        <option value="Processing">Processing</option>
                      </select>
              </div>-->
              <div class="col-lg-4">
                      <label class="form-label">Bill Amt</label>
                      <input type="text" class="form-control" id="tot_pay" value="" readonly>
              </div>
               <div class="col-lg-4">
                      <label class="form-label">TDS Amt</label>
                      <input type="text" class="form-control" id="tds_amt" name="tds_amt" value="" required>
                      <div id="error_message_tds" style="color: red;"></div>
              </div>
              <div class="col-lg-4">
                      <label class="form-label">Remaining Amt</label>
                      <input type="text" class="form-control" id="rem_amt" value="" readonly>
              </div>
              <div class="col-lg-4">
                    <label for="pay_amt" class="form-label">Recevied Amt</label>
                    <input type="text" class="form-control" id="pay_amt" name="pay_amt" required>
                    <div id="error_message" style="color: red;"></div>
              </div>
               <div class="col-lg-4">
                    <label for="payment_date" class="form-label">Payment Date</label>
                    <input type="date" class="form-control"  id="payment_date" name="payment_date" required>
              </div>
              <!-- <div class="col-lg-6">
                    <label for="attachment" class="form-label">Attachment</label>
                    <input type="file" class="form-control" id="attachment" name="attachment">
               </div>-->
          </div>
           <div class="row">
              <div class="col-lg-6">
                  <label for="remark" class="form-label">Remark</label>
                   <textarea class="form-control" id="remark" name="remark" rows="2"></textarea>
              </div>
              <div class="col-lg-6">
                    <label for="bankDetails" class="form-label">Ref No/Cheq No</label>
                   <textarea class="form-control"  name="bank_details" rows="2"></textarea>
              </div>
          </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Submit</button>
      </div>
      </form>
      <hr>
     
      <div class="container table-responsive">
        <h6>Payment History</h6>
               <table class="table" id="paymentHistoryTable">
                  <thead>
                    <tr>
                      <th>Sr. No.</th>
                      <th>Payment Date</th>
                      <th>Pay Amt</th>
                      <th>Bank Details</th>
                      <th>Remark</th>
                   <!--   <th>Attachment</th>-->
                      <th>Status</th>
                    </tr>
                  </thead>
                  <tbody id="paymentHistoryBody">
                    <!-- Payment history rows will be inserted here dynamically -->
                  </tbody>
                </table>
         </div>
         
    </div>
  </div>
</div>



<script>
 $(document).ready(function() {
    $('#tds_amt').on('input', function() {
        var tdsAmt = parseFloat($(this).val());
        var totalPayable = parseFloat($('#tot_pay').val());

        if (isNaN(tdsAmt)) {
            $('#error_message_tds').text('Please enter a valid amount.');
            $(this).val('');
        } else {
            $('#error_message_tds').text('');
            updateRemainingAmount();
        }
    });
    
     $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });

    $('#pay_amt').on('input', function() {
        var payAmt = parseFloat($(this).val());
        var remAmt = parseFloat($('#rem_amt').val());

        if (isNaN(payAmt)) {
            $('#error_message').text('Please enter a valid amount.');
            $(this).val('');
        } else {
            $('#error_message').text('');
        }
    });

    function updateRemainingAmount() {
        var totalPayable = parseFloat($('#tot_pay').val());
        var tdsAmt = parseFloat($('#tds_amt').val());
        if (!isNaN(totalPayable) && !isNaN(tdsAmt)) {
            var remainingAmount = totalPayable - tdsAmt;
            $('#rem_amt').val(remainingAmount.toFixed(2));
        }
    }

    $("#invoiceForm").submit(function(event) {
        event.preventDefault();

        var payAmt = parseFloat($("#pay_amt").val());
        if (payAmt === 0) {
            alert('Pay Amount cannot be zero.');
            return;
        }

        var formData = new FormData($(this)[0]);
        $.ajax({
            type: 'POST',
            url: $(this).attr('action'),
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                var parsedResponse = JSON.parse(response);
                if (parsedResponse.success === '0') {
                    alert(parsedResponse.message);
                    $('#invoiceModal').modal('hide');
                    table.ajax.reload(null, false);
                } else {
                    alert(parsedResponse.message);
                }
            },
            error: function(error) {
                console.error(error);
            }
        });
    });
});

function openInvoiceModal(invoiceId, totalpayable, rem_amt, InvNum) {
    totalpayable = parseFloat(totalpayable).toFixed(2);
    rem_amt = parseFloat(rem_amt).toFixed(2);

    $("#invoiceId").val(invoiceId);
    $("#total_payable").val(totalpayable);
    $("#tot_pay").val(totalpayable);
    $("#rem_amt").val(rem_amt);
    $("#invoiceNumberLabel").text('Invoice No: ' + InvNum);

    $('#invoiceForm :input:not(#invoiceId):not(#total_payable):not(#tot_pay):not(#rem_amt)').val('');
    $('#invoiceModal').modal('show');

    $.ajax({
        type: 'GET',
        url: '<?php echo base_url()?>admin/get_invoice_log/' + invoiceId,
        success: function(response) {
            updatePaymentHistoryTable(response);
        },
        error: function(error) {
            console.error(error);
        }
    });
}

  function formatDate(dateString) {
    // Parse the date in its current format (assuming it's in 'yyyy-mm-dd' format)
    var parts = dateString.split("-");
    var formattedDate = parts[2] + "-" + parts[1] + "-" + parts[0];
    return formattedDate;
}

function updatePaymentHistoryTable(paymentHistory) {
    // Clear existing rows and reset total
    $('#paymentHistoryBody').empty();
    var totalPayAmt = 0;

    // Append new rows based on payment history data
    $.each(paymentHistory, function(index, payment) {
        // Format payment date
        var formattedDate = formatDate(payment.payment_date);

        // Parse pay_amt as a float and accumulate totalPayAmt
        var payAmt = parseFloat(payment.pay_amt);
        totalPayAmt += payAmt;

        var row = '<tr>' +
            '<td>' + (index + 1) + '</td>' +
            '<td>' + formattedDate + '</td>' +
            '<td>' + payAmt.toFixed(2) + '</td>' + // Format payAmt with two decimal places
            '<td>' + payment.bank_details + '</td>' +
            '<td>' + payment.remark + '</td>' +
           /* '<td>' + (payment.attachment ? '<a href="<?php echo base_url()?>assets/uploads/attachment/' + payment.attachment + '" target="_blank">View</a>' : 'N/A') + '</td>' +*/
           
            '</tr>';

        $('#paymentHistoryBody').append(row);
    });

    // Format totalPayAmt with two decimal places
    var formattedTotal = totalPayAmt.toFixed(2);

    // Display total at the end of the table
    var totalRow = '<tr>' +
        '<td colspan="2"><strong>Total PayAmt:</strong></td>' +
        '<td><strong>' + formattedTotal + '</strong></td>' + // Display formattedTotal
        '<td colspan="5"></td>' +
        '</tr>';

    $('#paymentHistoryBody').append(totalRow);
}

</script>

<script>
    // Get the input element
    var paymentDateInput = document.getElementById('payment_date');

    // Get the current date
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1; // January is 0
    var yyyy = today.getFullYear();

    if (dd < 10) {
        dd = '0' + dd;
    }

    if (mm < 10) {
        mm = '0' + mm;
    }

    today = yyyy + '-' + mm + '-' + dd;

    // Set the max attribute to today, so past dates are disabled
    paymentDateInput.setAttribute('max', today);
</script>

<script>
function DeletePaymentLog(invoiceNumber) {
    Swal.fire({
        title: 'Are you sure?',
        text: 'Do you want to delete this payment log?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            // Perform the AJAX request to delete the log
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url()?>admin/delete_payment_log_sbi',
                data: { invoice_number: invoiceNumber },
                success: function(response) {
                    var parsedResponse = JSON.parse(response);
                    if (parsedResponse.success === '1') {
                        Swal.fire(
                            'Deleted!',
                            'The payment log has been deleted.',
                            'success'
                        );
                        table.ajax.reload(null, false);  // Reload the page to reflect the changes
                    } else {
                        Swal.fire(
                            'Error!',
                            parsedResponse.message,
                            'error'
                        );
                    }
                },
                error: function(error) {
                    Swal.fire(
                        'Error!',
                        'There was an error deleting the payment log.',
                        'error'
                    );
                    console.error(error);
                }
            });
        }
    });
}
</script>

<!--<script>
  function updatePerPage() {
    var formElement = document.getElementById("perPageForm");

    if (formElement !== null) {
      formElement.submit();
    } else {
      console.error("Form with ID 'perPageForm' not found");
    }
  }
</script>-->

<script>
$(document).ready(function() {
    
     $(document).on('click', '.delete', function () {
    var element = $(this);
    var id = element.attr('data-id'); // Use data-id attribute to get the ID
    var action = element.attr('action');

    Swal.fire({
        title: 'Are you sure?',
        text: "Are you sure you want to delete this Invoice?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                type: 'POST',
                url: base_url + 'admin/' + action + '/' + id,
                dataType: 'json',
                success: function (res) {
                    if (res.success == '1') {
                        notify(res.type, res.message);
                        table.ajax.reload(null, false);  // Reload the table data without resetting pagination
                    } else {
                        notify(res.type, res.message);
                    }
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                    alert('Error occurred while deleting data. Please try again.');
                }
            });
        }
    });
  });
                    
  var table = $('#Table').DataTable({
    "processing": true,
    "serverSide": true,
    "ajax": {
        "url": "<?= base_url('admin/fetch_invoice_data_rbo') ?>",
        "type": "POST",
        "data": function (d) {
            // Read values from the filter form inputs
            d.start_date = $('input[name="start_date"]').val();
            d.end_date = $('input[name="end_date"]').val();
            d.branch = $('select[name="branch"]').val();
            d.connector = $('select[name="connector"]').val();
            d.sbi_status = $('select[name="sbi_status"]').val();
            d.state_id = $('select[name="state_id"]').val();
            d.city_id = $('select[name="city_id"]').val();
            d.month = $('input[name="month"]').val();
            d.payment_amount = $('input[name="payment_amount"]').val();
            d.payment_date = $('input[name="payment_date"]').val();
            d.invoice_month = $('input[name="invoice_month"]').val();
        }
    },
    "columns": [
        { "data": "sr_no" },
        { "data": "city_name" },
        { "data": "rbo_name" },
        { "data": "applicant_name" },
        { "data": "loan_list" },
        { "data": "invoice_number" },
        { "data": "bill_amount", "className": "sum-bill" },
        { "data": "subtotal", "className": "sub-total" },
        { "data": "received_amount", "className": "sum-received" },
        { "data": "balance", "className": "sum-balance" },
        { "data": "invoice_date" },
        { "data": "payment_log" },
        { "data": "created_date" },
        { "data": "payment_status" },
        { "data": "created_by" },
        { "data": "edit_options" }
    ],
    "lengthChange": true,
    "order": [[0, 'desc']],
   // "lengthMenu": [[50, 100, 500, 1000, -1], [50, 100, 500, 1000, "All"]],
    "lengthMenu": [[50, 100, 300], [50, 100, 300]],
    "pageLength": 50,
    "dom": 'lBfrtip',
    "scrollX": true,
    "fixedColumns": {
        leftColumns: 0,
        rightColumns: 1,
    },
    "buttons": [
        { extend: 'excel', text: 'Excel' }
    ],
    "drawCallback": function(settings) {
        $('[data-bs-toggle="tooltip"]').tooltip();

        // Adjust the height of the fixed columns to match the scrollable columns
        setTimeout(function() {
            var scrollBodyHeight = $('.dataTables_scrollBody').height();
            $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
            $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

            // Adjust the row heights to match
            $('#invoiceTable tbody tr').each(function(index) {
                var rowHeight = $(this).height();
                $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
                $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
            });
        }, 10);
        
         var api = this.api();

        // Helper function to calculate the sum of a column
        var sumColumn = function(selector) {
            return api.column(selector, { page: 'current' }).data()
                .reduce(function(a, b) {
                    // Remove commas from the values and convert to floats
                    var x = parseFloat(a.toString().replace(/,/g, '')) || 0;
                    var y = parseFloat(b.toString().replace(/,/g, '')) || 0;
                    return x + y;
                }, 0);
        };

        // Sum the columns
        var totalBill = sumColumn('.sum-bill');
        var totalSubtotal = sumColumn('.sub-total');
        var totalReceived = sumColumn('.sum-received');
        var totalBalance = sumColumn('.sum-balance');

        // Update the footer with the totals formatted with commas
        $(api.column(6).footer()).html('' + totalBill.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
        $(api.column(7).footer()).html('' + totalSubtotal.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
        $(api.column(8).footer()).html('' + totalReceived.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
        $(api.column(9).footer()).html('' + totalBalance.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
        
    }
});

// Reload table on form submission
$('form').on('submit', function (e) {
    e.preventDefault();  // Prevent form from reloading the page
    table.draw();  // Redraw the DataTable with new filters
});

   
   
   $('#resetButton').on('click', function (e) {
    e.preventDefault(); // Prevent form submission

    // Clear all filter inputs
    $('input[name="start_date"]').val('');
    $('input[name="end_date"]').val('');
    $('select[name="branch"]').val('').trigger('change'); // Trigger change for select2 dropdowns
    $('select[name="connector"]').val('').trigger('change');
    $('select[name="sbi_status"]').val('').trigger('change');
    $('select[name="state_id"]').val('').trigger('change');
    $('select[name="city_id"]').val('').trigger('change');
    $('input[name="month"]').val('');
    $('input[name="payment_amount"]').val('');
    $('input[name="payment_date"]').val('');
    $('input[name="invoice_month"]').val('');
    // Reload the DataTable
    table.ajax.reload();
});

});




</script>

<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
</style>


<script>
$(document).ready(function(){
    $('#stateSelect').change(function(){
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('admin/get_cities') ?>',
                type: 'POST',
                data: {state_id: stateId},
                dataType: 'json',
                success: function(data) {
                    $('#citySelect').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#citySelect').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });

                    // Get the customer's city ID
                    var customerCityId = <?= (isset($user) && $user->city_id !== null) ? $user->city_id : 'null' ?>;
                    
                    // Set the selected city in the dropdown
                    if (customerCityId !== null) {
                        $('#citySelect').val(customerCityId);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#citySelect').empty().append('<option value="">-Select-</option>');
        }
    });

    // Trigger change event on page load if state is already selected
    $('#stateSelect').trigger('change');

  
});



$(document).on('click', '.edit-rboinvoice-date-btn', function () {
    let invoice = $(this).data('invoice');
    let currentDate = $(this).data('current-date');
    $('#invoice_batchno').val(invoice);
    $('#invoice_date').val(currentDate);
});
$('#invoiceRboDateForm').on('submit', function (e) {
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('admin/update_invoice_date') ?>',
        type: 'POST',
        data: $(this).serialize(),
        success: function (response) {
            let res = JSON.parse(response);
            if (res.success) {
                Swal.fire('Success', res.message, 'success');
                $('#editRboInvoiceDateModal').modal('hide');
                $('#Table').DataTable().ajax.reload(null, false);
            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});

  
 $(document).on('click', '.edit-rboinvoice-num-btn', function () {
     let invoice = $(this).data('invoice');
    let currentNum = $(this).data('current-num');

    $('#invoice_batchno_num').val(invoice);
    $('#invoice_num').val(currentNum);

    $('#editRboInvoiceNumModal').modal('show');
});
$('#invoiceRboNumForm').on('submit', function (e) {
    e.preventDefault();
  
    $.ajax({
        url: '<?= base_url('admin/update_invoice_number') ?>',
        type: 'POST',
        data: $(this).serialize(),
        success: function (response) {
            let res = JSON.parse(response);
            if (res.success) {
                Swal.fire('Success', res.message, 'success');
                $('#editRboInvoiceNumModal').modal('hide');
                $('#Table').DataTable().ajax.reload(null, false);
            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});



</script>

<style>
  .dataTables_length {
      margin-bottom: 13px;
  }
  .dataTables_filter {
      margin-top: 12px;
  }


  .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

  

</style>


<script>
 function deleteApplicantRBOInvoice(invoiceId, userId, applicantName) {
     if (confirm('Are you sure you want to delete this invoice for ' + applicantName + '?')) {
        console.log({ invoice_id: invoiceId, user_id: userId });
        $.ajax({
            url: '<?= base_url("admin/delete_invoice_rbo_applicant") ?>',
            type: 'POST',
            dataType: 'json', // Specify the expected data type
            data: {
                invoice_id: invoiceId,
                user_id: userId
            },
            success: function(response) {
                console.log(response);
                if (response.success) {
                    alert(response.message || 'Invoices Applicant deleted successfully!');
                    table.ajax.reload();
                } else {
                    alert(response.message || 'Cannot delete: SBI Payment status is Paid');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                alert('Error occurred while processing the request.');
            }
        });
    }
}


</script>
