<main class="page-content">
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                    <a href="<?= base_url('admin/connectors_form/') ?>">
                        <button type="button" class="btn btn-outline-primary radius-30">Add Partner</button>
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="Table" width="100%">
                    <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Partner Code</th>
                            <th>Full Name</th>
                            <th>Payout %</th>
                            <th>DOB</th>
                            <th>Mobile</th>
                            <th>Email</th>
                            <th>Pan Number</th>
                            <th>Pan Card</th>
                            <th>Adhar Card</th>
                            <th>GST Certificate</th>
                            <th>Cancelled Cheque</th>
                            <th>Agreement Copy</th>
                            <th>State</th>
                            <th>City</th>
                            <th>Remark</th>
                            <th>Created By</th>
                            <th>Created Date</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var staffId = <?php echo $_SESSION['staff_id']; ?>;
    var columns = [
        { "data": 0 },
        { "data": 1 },
        { "data": 2 },
        { "data": 3, "visible": (staffId == 1 || staffId == 14) },
        { "data": 4, "visible": (staffId == 13  || staffId == 14) },
        { "data": 5, "visible": (staffId == 1  || staffId == 14) },
        { "data": 6, "visible": ( staffId == 1 || staffId == 13 || staffId == 14) },
        { "data": 7, "visible": (staffId == 1 || staffId == 13 || staffId == 14) },
        { "data": 8, "visible": (staffId == 1 || staffId == 13 || staffId == 14) },
        { "data": 9, "visible": (staffId == 13 || staffId == 14) },
        { "data": 10, "visible": (staffId == 13 || staffId == 14) },
        { "data": 11, "visible": (staffId == 13 || staffId == 14) },
        { "data": 12 },
        { "data": 13 },
        { "data": 14 },
        { "data": 15, "visible": (staffId == 1) },
        { "data": 16 },
        { "data": 17 },
        { "data": 18, "visible": (staffId == 14) },
        { "data": 19 }
    ];

    var buttons = [];

    if (staffId == 13 || staffId == 14 || staffId == 1) {
        buttons.push({ extend: 'excel', text: 'Excel' });
    }

    var table = $('#Table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/fetch_connectors') ?>",
            "type": "POST"
        },
        "pageLength": 200,
        "columns": columns,
        "lengthChange": true,
        "lengthMenu": [[200, 100, 200, 500, -1], [200, 100, 200, 500, "All"]],
        "dom": 'lBfrtip',
        "scrollX": true,
        "fixedColumns": {
          leftColumns: 0,
          rightColumns: 2,
        },
        "buttons": buttons,
         "drawCallback": function(settings) {
     
      // Adjust the height of the fixed columns to match the scrollable columns
      setTimeout(function() {
        var scrollBodyHeight = $('.dataTables_scrollBody').height();
        $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
        $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

        // Adjust the row heights to match
        $('#Table tbody tr').each(function(index) {
          var rowHeight = $(this).height();
          $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
          $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
        });
      }, 10);
      
        
     }
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
    
     $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });

$(document).on('change', '.commoon_active_partner', function () {
    var element = $(this);
    var nextStatus = element.val(); // Get the selected status
    var id = element.data('id');
    var action = element.attr('action');

    $.ajax({
        type: 'POST',
        url: base_url + 'Admin/' + action + '/' + id + '/' + nextStatus,
    }).done(function (response) {
        var res = $.parseJSON(response);
        if (res.success === '1') {
            notify(res.type, res.message);

            // Optionally, you can update the select element styling based on the status.
            element.removeClass('bg-success bg-danger bg-warning');
            if (nextStatus === '1') {
                element.addClass('bg-success');
            } else if (nextStatus === '0') {
                element.addClass('bg-danger');
            } else if (nextStatus === '3') {
                element.addClass('bg-warning');
            }
        } else {
            notify(res.type, res.message);
        }
    }).fail(function () {
        alert("error");
    });
});

});
</script>





<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
    
    
  .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

  
</style>

