<main class="page-content">
    <!-- Breadcrumb -->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= htmlspecialchars($title) ?></div>
    </div>
    <!-- End Breadcrumb -->

    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3"></div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
    <table class="table align-middle table-striped" id="Table">
    <thead>
        <tr>
            <th>Sr. No</th>
            <th>Partner Name</th>
            <th>Applicant Name</th>
            <th>Field Name</th>
            <th>Old Value</th>
            <th>New Value</th>
            <th>Updated By</th>
            <th>Updated At</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($activity_logs)) : 
            $sr_no = 1;
            foreach ($activity_logs as $log) : 
                // Skip the entry if the field_name is 'other_branch_circle_id'
                if ($log['field_name'] === 'other_branch_circle_id') {
                    continue;
                }
            ?>
                <tr>
                    <td><?= $sr_no++ ?></td>
                    <td><?= htmlspecialchars($log['partner_name'] ?? 'N/A') ?></td>
                    <td><?= htmlspecialchars($log['user_name'] ?? 'N/A') ?></td>
                   <td>
                        <?= htmlspecialchars(
                            $log['field_name'] === 'branch_id' ? 'Branch Name' :
                            ($log['field_name'] === 'connector_id' ? 'Partner Name' :
                            ($log['field_name'] === 'loan_type_id' ? 'Loan Type' :
                            ($log['field_name'] === 'sanction_amt' ? 'Sanction Amt' :
                            ($log['field_name'] === 'user_name' ? 'Applicant Name' :
                            ($log['field_name'] === 'los_id' ? 'Los Id / RLMS' :
                            ($log['field_name'] === 'part_payout' ? 'Part. Payout' :
                            ($log['field_name'] === 'disb_date' ? 'Disb Date' :
                            ($log['field_name'] === 'rinnraksha_amt' ? 'RR Amt' :
                            ($log['field_name'] === 'rr_cbs_acct_no' ? 'RR CBS No' :
                            ($log['field_name'] === 'login_code' ? 'Login Code' :
                            ($log['field_name'] === 'bank_acct_no' ? 'CBS Acct No' : $log['field_name'])))))))))))
                        ) ?>
                    </td>

                    <td><?= htmlspecialchars($log['old_value'] ?? 'N/A') ?></td>
                    <td><?= htmlspecialchars($log['new_value'] ?? 'N/A') ?></td>
                    <td><?= htmlspecialchars($log['updated_by_name'] ?? 'N/A') ?></td>
                    <td><?= date('F d, Y h:i A', strtotime($log['updated_at'])) ?></td>
                </tr>
            <?php endforeach;
        else : ?>
            <tr>
                <td colspan="8" align="center">No activity logs available!</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>


            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "lengthChange": true,
        "searching": true,
        "lengthMenu": [[10, 25, 50, 200, -1], [10, 25, 50, 200, "All"]],
        "buttons": [
            { extend: 'copy', text: 'Copy' },
            { extend: 'excel', text: 'Excel' },
            { extend: 'pdf', text: 'PDF' },
            {
                extend: 'print',
                text: 'Print',
                customize: function(win) {
                    $(win.document.body).find('h1').text('Applicant Activity Log');
                }
            },
            { extend: 'colvis', text: 'Column Visibility' }
        ]
    });

    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
});
</script>
