<?php
  $isVerified = isset($user->is_verify) && $user->is_verify == 1;
  $canSubmit = isset($_SESSION['staff_id']) && in_array($_SESSION['staff_id'], [13, 14, 1]);

?>

<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?>
        <?php if(isset($selectedLoginType) && !empty($selectedLoginType)) : ?>
            - <?= $selectedLoginType ?>
        <?php endif; ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="row">
        <div class="col-xl-12 mx-auto">
            <div class="card">
                <div class="card-body">
                     <?php if ($this->session->flashdata('message')): ?>
                            <script>
                                alert("<?= $this->session->flashdata('message'); ?>");
                            </script>
                        <?php endif; ?>
                         <form id="forms" method="post" action="<?= base_url('admin/submit_pb_user') ?>">
                            
                        <input type="hidden" name="id" value="<?= (isset($user)) ? $user->id : '' ?>">
                        <input type="hidden" name="applicant_rr_id" value="<?= (isset($user)) ? $user->applicant_rr_id : '' ?>">
                       
                        <div class="row">
                             <div class="col-md-3 mb-3">
                            <label class="form-label">Login Code <span style="color:red">*</span></label>
                            <select name="login_code" class="form-select" required>
                            <option value="PaisaBazaar" <?php if(isset($user) && $user->login_code == 'PaisaBazaar') echo 'selected'; elseif(isset($selectedLoginType) && $selectedLoginType == 'PaisaBazaar') echo 'selected'; ?>>PaisaBazaar</option>
                            <?php if ($_SESSION['staff_type']=='0') { ?>
                              <option value="Mortgagebuddy" <?php if(isset($user) && $user->login_code == 'Mortgagebuddy') echo 'selected'; elseif(isset($selectedLoginType) && $selectedLoginType == 'Mortgagebuddy') echo 'selected'; ?>>Mortgagebuddy</option>
                             <?php } ?>
                        </select>
                             
                            <span class="error"></span>
                        </div> 
                        <?php if ($_SESSION['staff_type']=='0') { ?>
                       
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Partner <span style="color:red">*</span></label>
                            <select name="connector_id" class="single-select" id="connector_id" required>
                                <option value="">-Select-</option>
                               <?php  foreach ($connector as  $value) { ?>
                                   <option value="<?= $value['staff_id']; ?>" <?php if(@$value['staff_id']==@$user->connector_id) echo 'selected';?>><?= $value['staff_fullname'];?></option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div> 
                        
                           <div class="mb-3 col-md-2">
                                <label class="form-label">Partner Code</label>
                                <?php @$conn = $this->ccm->get_single_row('mst_staff', array('staff_id' => @$user->connector_id)); ?>
                                <input type="text" class="form-control inputs" 
                                       value="<?= (isset($user)) ? $conn->hlc_code : '' ?>" id="partner_code">
                                <span class="error"></span>
                            </div>
                            
                        <?php }else{ ?>
                                <input type="hidden" name="connector_id" value="<?= $_SESSION['staff_id']; ?>">
                              <?php } ?>
                         <div class="col-md-3 mb-3">
                            <label class="form-label">Branch <span style="color:red">*</span></label>
                            <select name="branch_id" class="single-select" id="branchSelect" required>
                                <option value="">-Select-</option>
                                <?php foreach ($branch as $value) {
                                    if (!empty($value['branch_code'])) {
                                        $branchCode = ' (' . $value['branch_code'] . ')';
                                    } else {
                                        $branchCode = '';
                                    }
                                    $selected = '';
                                    if (isset($user) && isset($user->branch_id) && $value['id'] == $user->branch_id) {
                                        $selected = 'selected';
                                    }
                                    ?>
                                    <option value="<?= $value['id']; ?>" <?= $selected ?>>
                                        <?= $value['branch_name'] . $branchCode; ?>
                                    </option>
                                <?php } ?>
                             
                            </select>
                            <span class="error"></span>
                        </div>


                       <?php $dip = (!empty($user->other_branch)) ? 'block' : 'none'; ?>

                        <div id="otherBranch" class="col-md-3 mb-3" style="display: <?= $dip; ?>;">
                            <label class="form-label">Other Branch Name <span style="color:red">*</span></label>
                            <input type="text" name="other_branch" class="form-control" value="<?= (isset($user)) ? @$user->other_branch : ''; ?>">
                            <span class="error"></span>
                        </div>
                        <div id="otherBranchCode" class="col-md-3 mb-3" style="display: <?= $dip; ?>;">
                            <label class="form-label">Branch Code <span style="color:red">*</span></label>
                            <input type="number" name="other_branch_code" class="form-control" value="<?= (isset($user)) ? @$user->other_branch_code : ''; ?>">
                            <span class="error"></span>
                        </div>
                         <div id="otherBranchState" class="col-md-3 mb-3" style="display: <?= $dip; ?>;">
                            <label class="form-label">Branch State <span style="color:red">*</span></label>
                            <select name="other_branch_state_id" class="single-select" id="stateSelectotherBranch">
                                <option value="">-Select-</option>
                               <?php  foreach ($state as  $value) { ?>
                                   <option value="<?= $value['id']; ?>" <?php if(@$value['id']==@$user->other_branch_state_id) echo 'selected';?>><?=$value['state_name'];?></option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div> 
                      
                        <div id="otherBranchCity" class="col-md-3 mb-3" style="display: <?= $dip; ?>;">
                            <label class="form-label">Branch City/District <span style="color:red">*</span></label>
                            <select name="other_branch_city_id" class="single-select" id="citySelectotherBranch">
                                <option value="">-Select-</option>
                            </select>
                            <span class="error"></span>
                        </div> 
                        <div id="otherBranchCircle" class="col-md-3 mb-3" style="display: <?= $dip; ?>;">
                            <label class="form-label">Branch Circle <span style="color:red">*</span></label>
                            <select name="other_branch_circle_id" class="single-select">
                                <option value="">-Select-</option>
                               <?php  foreach ($circle as  $value) { ?>
                                   <option value="<?= $value['id']; ?>"><?=$value['c_name'];?>(<?=$value['c_code'];?>)</option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div> 

                        <div class="col-md-3 mb-3">
                            <label class="form-label">Loan Type <span style="color:red">*</span></label>
                            <select name="loan_type_id" class="form-control" required>
                               <?php  foreach ($loan_type as  $value) { ?>
                                   <option value="<?= $value['id']; ?>" <?php if(@$value['id']==@$user->loan_type_id) echo 'selected';?>><?=$value['name'];?></option>
                              <?php } ?> 
                                                          
                            </select>
                            <span class="error"></span>
                        </div> 
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Applicant Name <span style="color:red">*</span></label>
                                <input type="text" class="form-control inputs" placeholder="Applicant Name" 
                                       name="user_name" required value="<?= (isset($user)) ? $user->user_name : '' ?>">
                                <span class="error"></span>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Mobile Number</label>
                                <input type="tel" class="form-control inputs" placeholder="Mobile number" 
                                       name="user_phone"  pattern="[0-9]{10}" title="Please enter a 10-digit mobile number" value="<?= (isset($user)) ? $user->user_phone : '' ?>">
                                <span class="error"></span>
                            </div>
                           

                            <div class="mb-3 col-md-3">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control inputs" placeholder="Email Id" 
                                       name="user_email"  value="<?= (isset($user)) ? $user->user_email : '' ?>">
                                <span class="error"></span>
                            </div>
                            <div class="col-md-3 mb-3">
                            <label class="form-label">State <span style="color:red">*</span></label>
                            <select name="state_id" class="single-select" id="stateSelect" required>
                                <option value="">-Select-</option>
                               <?php  foreach ($state as  $value) { ?>
                                   <option value="<?= $value['id']; ?>" <?php if(@$value['id']==@$user->state_id) echo 'selected';?>><?=$value['state_name'];?></option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div> 
                      
                        <div class="col-md-3 mb-3">
                            <label class="form-label">City <span style="color:red">*</span></label>
                            <select name="city_id" class="single-select" id="citySelect" required>
                                <option value="">-Select-</option>
                            </select>
                            <span class="error"></span>
                        </div> 
                            <div class="mb-3 col-md-4">
                                <label class="form-label">Address</label>
                                <textarea type="text" class="form-control inputs" placeholder="Address" 
                                          name="user_address"><?= (isset($user)) ? $user->user_address : '' ?></textarea>
                                <span class="error"></span>
                            </div>
                         
                           
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Los Id / RLMS <span style="color:red">*</span></label>
                                <input type="number" class="form-control inputs" placeholder="Los Id / RLMS" 
                                        name="los_id" required value="<?= (isset($user)) ? $user->los_id	 : '' ?>">
                                <span class="error"></span>
                            </div>
                             <div class="mb-3 col-md-3">
                                <label class="form-label">Disb Date</label>
                                <input type="date" class="form-control inputs" placeholder="Disb Date" 
                                        name="disb_date" max="<?= date('Y-m-d') ?>" value="<?= (isset($user)) ? $user->disb_date	 : null ?>">
                                <span class="error"></span>
                            </div>
                          <div class="mb-3 col-md-3">
                            <label class="form-label">CBS Account No.</label>
                            <input type="text" class="form-control inputs"
                                   placeholder="CBS Acct.No"
                                   name="bank_acct_no"
                                   pattern="\d{11,}" 
                                   oninvalid="setCustomValidity(\'CBS Account No. must be 11 digits or more\')" 
                                   onchange="setCustomValidity(\'\')" 
                                   title="CBS Account No. must be 11 digits or more" value="<?= (isset($user)) ? $user->bank_acct_no : '' ?>">
                            <span class="error"></span>
                            <span id="account-error" class="error"></span>
                        </div>
                        <input type="hidden" id="cbs-id" value="<?= (isset($user)) ? $user->id : '' ?>">
                           <div class="mb-3 col-md-3">
                                <label class="form-label">Loan / Sanction Amount <span style="color:red">*</span></label>
                                <input type="text" id="amountInput" class="form-control inputs" placeholder="Sanction Loan Amount" 
                                        name="sanction_amt" required value="<?= (isset($user)) ? $user->sanction_amt	 : '' ?>">
                                <span class="error"></span>
                                <span id="amountInWords" class="text-muted"><?= @convertAmountToWords($user->sanction_amt) ?></span>
                            </div>
                            
                            <?php if(empty($user->applicant_rr_id)){ ?>
                          
                             <div class="col-md-3 mb-3">
                                <label class="form-label">RinnRaksha <span style="color:red">*</span></label>
                                <div>
                                    <select name="rinnraksha_status" id="rinnraksha_status" class="form-control" required>
                                        <option value="">-Select-</option>
                                        <option value="Yes" <?php if(@$user->rinnraksha_status=='Yes') echo 'selected';?>>Yes</option>
                                        <option value="No" <?php if(@$user->rinnraksha_status=='No') echo 'selected';?>>No</option>
                                    </select>
                                </div>
                            </div>
                            
                            
                            
                             <?php 
                                $rs = (@$user->rinnraksha_status == 'Yes') ? 'block' : 'none'; 
                                $readonly = (isset($user->applicant_invoice_status) && $user->applicant_invoice_status == 'Generated') || 
                                            (isset($_SESSION['staff_id']) && !in_array($_SESSION['staff_id'], [1, 14, 13, 538])) ? 'readonly' : ''; 
                                ?>
                                
                                <div id="rinnraksha_amt_div" class="col-md-3 mb-3" style="display: <?= $rs; ?>;">
                                    <label class="form-label">RinnRaksha Premium Amt <span style="color:red">*</span></label>
                                    <input type="text" name="rinnraksha_amt" id="rinnraksha_amt" class="form-control" 
                                        value="<?= isset($user) ? $user->rinnraksha_amt : ''; ?>"
                                        <?= (isset($user->rinnraksha_status) && $user->rinnraksha_status == 'Yes') ? 'required' : ''; ?>>
                                    <span class="error"></span>
                                </div>

                            
                            
                            <div id="rinnraksha_cbs_div" class="col-md-3 mb-3" style="display: <?= $rs; ?>;">
                                <label class="form-label">RinnRaksha CBS Acct. No <span style="color:red">*</span></label>
                                <input type="number" name="rr_cbs_acct_no" id="rr_cbs_acct_no" class="form-control" value="<?= (isset($user)) ? @$user->rr_cbs_acct_no : ''; ?>" <?php if(@$user->rinnraksha_status=='Yes') echo 'required'; ?>>
                                <span class="error"></span>
                            </div>
                            
                           <?php } else{ ?>
                                        <div class="col-md-3 mb-3">
                                            <br>
                                            <h6 class="text-info">RR Account Created This Account.</h6>
                                        </div>
                           <?php } ?>
                          
<div class="mb-3 col-md-3">
    <label class="form-label">Appraisal Letter (Page 1)</label>
    <input type="file" class="form-control inputs" name="apprisal_letter_file[]" accept=".jpg,.png,.jpeg,.pdf" multiple> 
    <span class="error"></span>
    
    <?php if (!empty($appraisal_letters)) { 
        $file_count1 = 1; ?>
        <?php foreach ($appraisal_letters as $letter) { ?>
            <?php if (!empty($letter->appraisal_letter)) { ?>
                <a href="<?= base_url() . 'assets/uploads/documents/' . $letter->appraisal_letter ?>" target="_blank" class="btn btn-link">
                    View Appraisal File <?= $file_count1++ ?>
                </a>
                <?php if ($_SESSION['staff_id']=='14' || $_SESSION['staff_id']=='13' || $_SESSION['staff_id']=='538' || $_SESSION['staff_id']=='1') {  ?>
                    <a href="<?= base_url('admin/delete_appraisal_letter_one/' . $letter->id) ?>" class="text-danger" onclick="return confirm('Are you sure you want to delete this file?')">
                        <i class="bi bi-trash"></i>
                    </a>
                <?php } ?>
            <?php } ?>
        <?php } ?>
    <?php } ?>
</div>


<?php if($_SESSION['staff_id']=='1' || $_SESSION['staff_id']=='14') { ?>
<div class="mb-3 col-md-3">
    <label class="form-label">Final Sanction Letter</label>
    <input type="file" class="form-control inputs" name="final_sanction_letter[]" accept=".jpg,.png,.jpeg,.pdf" multiple> 
    <span class="error"></span>
    
    <?php if (!empty($final_sanction_letter)) { 
        $file_count2 = 1; ?>
        <?php foreach ($final_sanction_letter as $letter) { ?>
            <?php if (!empty($letter->final_sanction_letter)) { ?>
                <a href="<?= base_url() . 'assets/uploads/documents/' . $letter->final_sanction_letter; ?>" target="_blank" class="btn btn-link">
                    Final Sanction Letter <?= $file_count2++ ?>
                </a>
                <?php if ($_SESSION['staff_id']=='14' || $_SESSION['staff_id']=='13' || $_SESSION['staff_id']=='538' || $_SESSION['staff_id']=='1') {  ?>
                    <a href="<?= base_url('admin/delete_final_sanction_letter/' . $letter->id) ?>" class="text-danger" onclick="return confirm('Are you sure you want to delete this file?')">
                        <i class="bi bi-trash"></i>
                    </a>
                <?php } ?>
            <?php } ?>
        <?php } ?>
    <?php } ?>
</div>
<?php } ?>

                        <div class="mb-3 col-md-3">
                            <label class="form-label">Proof Of Disbursement</label>
                            <input type="file" class="form-control inputs" name="proof_disb[]" accept=".jpg,.png,.jpeg,.pdf" multiple> 
                            <span class="error"></span>
                            
                            <?php if (!empty($proof_disb)) { 
                                $file_count3 = 1; ?>
                                <?php foreach ($proof_disb as $letter) { ?>
                                    <?php if (!empty($letter->proof_disb)) { ?>
                                        <a href="<?= base_url() . 'assets/uploads/documents/' . $letter->proof_disb; ?>" target="_blank" class="btn btn-link">
                                            Proof Of Disbursement <?= $file_count3++ ?>
                                        </a>
                                        <?php if ($_SESSION['staff_id']=='14' || $_SESSION['staff_id']=='13' || $_SESSION['staff_id']=='538' || $_SESSION['staff_id']=='1') {  ?>
                                            <a href="<?= base_url('admin/delete_proof_disb/' . $letter->id) ?>" class="text-danger" onclick="return confirm('Are you sure you want to delete this file?')" style="font-size: 14px;">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>
                        </div>

                            <div class="col-md-3 mb-3">
                                <label class="form-label">Status <span style="color:red">*</span></label>
                                <div>
                                    <select name="status" class="form-control" required>
                                        <option value="">-Select-</option>
                                        <option value="Login Case" <?php if(@$user->status=='Login Case') echo 'selected';?>>Login Case</option>
                                        <!--<option value="Sanction" <?php if(@$user->status=='Sanction') echo 'selected';?>>Sanction</option>-->
                                        <option value="Disb Case" <?php if(@$user->status=='Disb Case') echo 'selected';?>>Disb Case</option>
                                        <!--<option value="Reject" <?php if(@$user->status=='Reject') echo 'selected';?>>Reject</option>-->
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3 col-md-3">
                            <label class="form-label">Remark</label>
                            <input type="text" class="form-control inputs" placeholder="Remarks" 
                                    name="remark"  value="<?= (isset($user)) ? $user->remark : '' ?>">
                            <span class="error"></span>
                            </div>
                            
                            <?php if ($_SESSION['staff_id']=='14' || $_SESSION['staff_id']=='1') {  ?>
                                <div class="mb-3 col-md-3">
                                <label class="form-label">SBI Commision</label>
                               <select name="sbi_commi" class="form-select">
                                                    <option value="">Select</option>
                                                    <option value="0.20" <?php if(@$user->sbi_commi=='0.20')echo 'selected'; ?>>0.20%</option>
                                                    <option value="0.30" <?php if(@$user->sbi_commi=='0.30')echo 'selected'; ?>>0.30%</option>
                                                    <option value="0.35" <?php if(@$user->sbi_commi=='0.35')echo 'selected'; ?>>0.35%</option>
                                                    <option value="0.40" <?php if(@$user->sbi_commi=='0.40')echo 'selected'; ?>>0.40%</option>
                                                   
                                                    <option value="0.45" <?php if(@$user->sbi_commi=='0.45')echo 'selected'; ?>>0.45%</option>
                                                    <option value="0.50" <?php if(@$user->sbi_commi=='0.50')echo 'selected'; ?>>0.50%</option>
                                                    <option value="0.55" <?php if(@$user->sbi_commi=='0.55')echo 'selected'; ?>>0.55%</option>
                                                    <option value="0.60" <?php if(@$user->sbi_commi=='0.60')echo 'selected'; ?>>0.60%</option>
                                                    <option value="0.65" <?php if(@$user->sbi_commi=='0.65')echo 'selected'; ?>>0.65%</option>
                                                    <option value="0.70" <?php if(@$user->sbi_commi=='0.70')echo 'selected'; ?>>0.70%</option>
                                                    <option value="0.75" <?php if(@$user->sbi_commi=='0.75')echo 'selected'; ?>>0.75%</option>
                                                    <option value="0.80" <?php if(@$user->sbi_commi=='0.80')echo 'selected'; ?>>0.80%</option>
                                                </select>
                                <span class="error"></span>
                                </div>
                                <?php
                                }else{ ?>
                                     <input type="hidden" class="form-control inputs" name="sbi_commi" value="<?= @$user->sbi_commi; ?>">
                               <?php } ?>

                                 <?php if ($_SESSION['staff_id']=='14' || $_SESSION['staff_id']=='13' || $_SESSION['staff_id']=='538' || $_SESSION['staff_id']=='28' || $_SESSION['staff_id']=='1') {  ?>
                                <div class="mb-3 col-md-3">
                                <label class="form-label">Partner Payout Commission</label>
                              <select name="part_payout" class="form-select">
                                                    <option value="">Select</option>
                                                    <option value="0.20" <?php if(@$user->part_payout=='0.20')echo 'selected'; ?>>0.20%</option>
                                                    <option value="0.28" <?php if(@$user->part_payout=='0.28')echo 'selected'; ?>>0.28%</option>
                                                    <option value="0.30" <?php if(@$user->part_payout=='0.30')echo 'selected'; ?>>0.30%</option>
                                                    <option value="0.35" <?php if(@$user->part_payout=='0.35')echo 'selected'; ?>>0.35%</option>
                                                    <option value="0.40" <?php if(@$user->part_payout=='0.40')echo 'selected'; ?>>0.40%</option>
                                                    <option value="0.45" <?php if(@$user->part_payout=='0.45')echo 'selected'; ?>>0.45%</option>
                                                     <option value="0.47" <?php if(@$user->part_payout=='0.47')echo 'selected'; ?>>0.47%</option>
                                                    <option value="0.50" <?php if(@$user->part_payout=='0.50')echo 'selected'; ?>>0.50%</option>
                                                    <option value="0.55" <?php if(@$user->part_payout=='0.55')echo 'selected'; ?>>0.55%</option>
                                                     <option value="0.52" <?php if(@$user->part_payout=='0.52')echo 'selected'; ?>>0.52%</option>
                                                    <option value="0.60" <?php if(@$user->part_payout=='0.60')echo 'selected'; ?>>0.60%</option>
                                                    <option value="0.65" <?php if(@$user->part_payout=='0.65')echo 'selected'; ?>>0.65%</option>
                                                    <option value="0.70" <?php if(@$user->part_payout=='0.70')echo 'selected'; ?>>0.70%</option>
                                                    <option value="0.75" <?php if(@$user->part_payout=='0.75')echo 'selected'; ?>>0.75%</option>
                                                    <option value="0.77" <?php if(@$user->part_payout=='0.77')echo 'selected'; ?>>0.77%</option>
                                                    <option value="0.78" <?php if(@$user->part_payout=='0.78')echo 'selected'; ?>>0.78%</option>
                                                    <option value="0.79" <?php if(@$user->part_payout=='0.79')echo 'selected'; ?>>0.79%</option>
                                                    <option value="0.80" <?php if(@$user->part_payout=='0.80')echo 'selected'; ?>>0.80%</option>
                                                    <option value="0.81" <?php if(@$user->part_payout=='0.81')echo 'selected'; ?>>0.81%</option>
                                                    <option value="0.82" <?php if(@$user->part_payout=='0.82')echo 'selected'; ?>>0.82%</option>
                                                    <option value="0.83" <?php if(@$user->part_payout=='0.83')echo 'selected'; ?>>0.83%</option>
                                                    <option value="0.84" <?php if(@$user->part_payout=='0.84')echo 'selected'; ?>>0.84%</option>
                                                    <option value="0.85" <?php if(@$user->part_payout=='0.85')echo 'selected'; ?>>0.85%</option>
                                                    <option value="0.86" <?php if(@$user->part_payout=='0.86')echo 'selected'; ?>>0.86%</option>
                                                    <option value="0.87" <?php if(@$user->part_payout=='0.87')echo 'selected'; ?>>0.87%</option>
                                                    <option value="0.88" <?php if(@$user->part_payout=='0.88')echo 'selected'; ?>>0.88%</option>
                                                    <option value="0.89" <?php if(@$user->part_payout=='0.89')echo 'selected'; ?>>0.89%</option>
                                                    <option value="0.90" <?php if(@$user->part_payout=='0.90')echo 'selected'; ?>>0.90%</option>
                                                </select>
                                <span class="error"></span>
                                </div>
                                <?php
                                }else{ ?>
                                     <input type="hidden" class="form-control inputs" name="part_payout" value="<?= @$user->part_payout; ?>">
                               <?php } ?>
                                
                                <div class="mb-3">
                                     <a href="<?= base_url() ?>admin/manage_pb_users"><button type="button" class="btn btn-primary px-5 radius-30" >Back</button></a>
                                       <?php if (@$user->pb_genrated == 'Yes' && isset($_SESSION['staff_id']) && 
                                            in_array($_SESSION['staff_id'], [1, 14, 13, 538, 651])) { ?>
                                        <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">
                                        <h6 class="text-danger">This invoice is generated for the applicant. If you make any changes to the information, please delete the invoice first.</h6>
                                    <?php } elseif (@$user->pb_genrated != 'Yes') { ?>
                                        <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">
                                    <?php } else { ?>
                                        <h6 class="text-danger">This invoice is generated for the applicant. If you make any changes to the information, please delete the invoice first.</h6>
                                    <?php } ?>
                               </div>
                               
                                 <div class="mb-3">
                                
                                
                                 <!--   <?php if (!$isVerified || $canSubmit) { ?>
                                        <?php if (@$user->pb_genrated == 'Yes' && isset($_SESSION['staff_id']) && 
                                            in_array($_SESSION['staff_id'], [1, 14, 13, 538, 651])) { ?>
                                            <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">
                                            <h6 class="text-danger">This invoice is generated for the applicant. If you make any changes, please delete the invoice first.</h6>
                                        <?php } elseif (@$user->pb_genrated != 'Yes') { ?>
                                            <input type="submit" class="btn btn-primary px-5 radius-30" id="btnSubmit" value="Submit">
                                        <?php } else { ?>
                                            <h6 class="text-danger">This invoice is generated for the applicant. If you make any changes, please delete the invoice first.</h6>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <h6 class="text-danger">This form is verified.You can't change it.Contact to the Administrator </h6>
                                    <?php } ?>-->
                                </div>

                            
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
<!--end row-->
</main>
<?php
function convertAmountToWords($number) {
    $decimal = round($number - ($no = floor($number)), 2) * 100;
    $hundred = null;
    $digits_length = strlen($no);
    $i = 0;
    $str = array();
    $words = array(0 => '', 1 => 'one', 2 => 'two',
        3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
        7 => 'seven', 8 => 'eight', 9 => 'nine',
        10 => 'ten', 11 => 'eleven', 12 => 'twelve',
        13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
        16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
        19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
        40 => 'forty', 50 => 'fifty', 60 => 'sixty',
        70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
    $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
    while ($i < $digits_length) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            $str [] = ($number < 21) ? ucfirst($words[$number]) . ' ' . ucfirst($digits[$counter]) . $plural . ' ' . $hundred : ucfirst($words[floor($number / 10) * 10]) . ' ' . ucfirst($words[$number % 10]) . ' ' . ucfirst($digits[$counter]) . $plural . ' ' . $hundred;
        } else
            $str[] = null;
    }
    $Rupees = implode('', array_reverse($str));
    $paise = ($decimal > 0) ? "." . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
    return ($Rupees ? $Rupees . ' ' : '') . $paise;
}
?>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        var mobileNumberInput = document.querySelector('input[name="user_phone"]');
        var appliedLoanAmountInput = document.querySelector('input[name="sanction_amt"]');
        var applicantNameInput = document.querySelector('input[name="user_name"]');
        var losIdInput = document.querySelector('input[name="los_id"]');
        var bankAcctNoInput = document.querySelector('input[name="bank_acct_no"]');
        var commissionInput = document.querySelector('input[name="commission"]');

        function setCustomValidityForMobile(input) {
            if (input.validity.patternMismatch) {
                input.setCustomValidity("Please enter a 10-digit mobile number");
            } else {
                input.setCustomValidity("");
            }
        }

         function setCustomValidityForAppliedLoanAmount(input) {
                var amountStr = input.value.trim().replace(/,/g, ''); // Remove leading/trailing spaces and commas
                var amount = parseInt(amountStr, 10); // Parse as integer
                var minAmount = 200000; // 2 lakhs
                var maxAmount = 150000000; // 15 crores
            
                if (isNaN(amount) || amount < minAmount || amount > maxAmount) {
                    input.setCustomValidity("Applied Loan Amount should be between 2 lakhs and 15 crores");
                } else {
                    input.setCustomValidity("");
                }
            }


        function setCustomValidityForApplicantName(input) {
            var containsNumber = /\d/.test(input.value);
            if (containsNumber) {
                input.setCustomValidity("Applicant Name should not contain numbers");
            } else {
                input.setCustomValidity("");
                input.value = capitalizeWords(input.value);
            }
        }

        function setCustomValidityForLosId(input) {
            var isValid = /^\d+$/.test(input.value);
            if (!isValid) {
                input.setCustomValidity("Los Id should only contain digits");
            } else {
                input.setCustomValidity("");
            }
        }
        
        <?php if(@$user->disb_status=='yes'){ ?>

        function setCustomValidityForBankAcctNo(input) {
            if (input.value === losIdInput.value) {
                input.setCustomValidity("Los Id and Bank Account No should not be the same");
            } else {
                input.setCustomValidity("");
            }
        }
        <?php } ?>

        

        mobileNumberInput.addEventListener("input", function (event) {
            setCustomValidityForMobile(mobileNumberInput);
        });

        appliedLoanAmountInput.addEventListener("input", function (event) {
            setCustomValidityForAppliedLoanAmount(appliedLoanAmountInput);
        });

        applicantNameInput.addEventListener("input", function (event) {
            setCustomValidityForApplicantName(applicantNameInput);
        });

        losIdInput.addEventListener("input", function (event) {
            setCustomValidityForLosId(losIdInput);
            setCustomValidityForBankAcctNo(bankAcctNoInput);
        });

        bankAcctNoInput.addEventListener("input", function (event) {
            setCustomValidityForBankAcctNo(bankAcctNoInput);
        });


    });
    
    function capitalizeWords(str) {
    return str.toLowerCase().replace(/(?:^|\s)\S/g, function(a) {
        return a.toUpperCase();
    });
}
function convertAmountToWords(amount) {
    var a = ['','one ','two ','three ','four ','five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
    var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];

    if ((amount = amount.toString()).length > 9) return 'overflow';
    n = ('000000000' + amount).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return;
    var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lakh ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
    return str.trim();
}

// Add event listener for input change
document.getElementById("amountInput").addEventListener("input", function() {
    let amountInput = document.getElementById("amountInput");
    let amountInWordsSpan = document.getElementById("amountInWords");
    let amount = parseFloat(amountInput.value);
    if (!isNaN(amount)) {
        let amountInWords = convertAmountToWords(amount);
        amountInWordsSpan.innerText = amountInWords;
    } else {
        amountInWordsSpan.innerText = "";
    }
});


</script>

<!--<script>
        async function checkDuplicateAccount(input) {
            const accountNumber = input.value;
            const errorSpan = document.getElementById('account-error');
            const recordId = document.getElementById('cbs-id').value;

            if (accountNumber.length >= 11) {
                try {
                    const response = await fetch(`<?= base_url('admin/check_duplicate_cbs') ?>?account_no=${accountNumber}&record_id=${recordId}`);
                    const result = await response.json();

                    if (result.exists) {
                        input.setCustomValidity('This CBS Account No. already exists.');
                        errorSpan.textContent = 'This CBS Account No. already exists.';
                    } else {
                        input.setCustomValidity('');
                        errorSpan.textContent = '';
                    }
                } catch (error) {
                    console.error('Error checking account number:', error);
                }
            } else {
                input.setCustomValidity('');
                errorSpan.textContent = '';
            }
        }
        document.addEventListener('DOMContentLoaded', (event) => {
            const accountInput = document.querySelector('input[name="bank_acct_no"]');
            accountInput.addEventListener('input', function() {
                checkDuplicateAccount(this);
            });
           
            accountInput.addEventListener('change', function() {
                checkDuplicateAccount(this);
            });
          
            checkDuplicateAccount(accountInput);
        });
    </script>-->

<script>
document.addEventListener("DOMContentLoaded", function () {
    // Initialize Select2 for the branch select
    $('#branchSelect').select2();

    var branchSelect = document.getElementById('branchSelect');
    var otherBranchDiv = document.getElementById('otherBranch');
    var otherBranchCodeDiv = document.getElementById('otherBranchCode');
    
    var otherBranchState = document.getElementById('otherBranchState');
    var otherBranchCity = document.getElementById('otherBranchCity');
    
    var otherBranchCircle = document.getElementById('otherBranchCircle');
    
    var otherBranchInput = document.querySelector('input[name="other_branch"]');
    var otherBranchCodeInput = document.querySelector('input[name="other_branch_code"]');
    
    var errorSpan = document.getElementById('branchCodeError');
    
    function toggleOtherBranch() {
        var selectedBranchValue = $('#branchSelect').val();
        var displayStyle = (selectedBranchValue === '100') ? 'block' : 'none';
        otherBranchDiv.style.display = displayStyle;
        otherBranchCodeDiv.style.display = displayStyle;
        otherBranchState.style.display = displayStyle;
        otherBranchCity.style.display = displayStyle;
        otherBranchCircle.style.display = displayStyle;

        // Update required attribute based on visibility
        otherBranchInput.required = (displayStyle === 'block');
        otherBranchCodeInput.required = (displayStyle === 'block');
        
        if(selectedBranchValue === '100'){
            document.getElementsByName('other_branch_code')[0].disabled = false;
            document.getElementsByName('other_branch_state_id')[0].required = true;
            document.getElementsByName('other_branch_city_id')[0].required = true;
            document.getElementsByName('other_branch_circle_id')[0].required = true;
            
        }else{
             document.getElementsByName('other_branch_code')[0].disabled = true;
             document.getElementsByName('other_branch_state_id')[0].required = false;
             document.getElementsByName('other_branch_city_id')[0].required = false;
             document.getElementsByName('other_branch_circle_id')[0].required = false;
        }
    }
    
    function validateBranchCode() {
        let branchCode = otherBranchCodeInput.value;

        // Check if the branch code length is less than 5 digits
        if (branchCode.length < 5) {
            otherBranchCodeInput.setCustomValidity('Five digit code is mandatory, please PREFIX "ZERO" if code is not five digits. For example, write "05555" for branch code "5555".');
            if (errorSpan) {
                errorSpan.textContent = 'Five digit code is mandatory, please PREFIX "ZERO" if code is not five digits. For example, write "05555" for branch code "5555".';
            }
            return;
        }

        // Prefix zeros if necessary
        if (branchCode.length < 5) {
            branchCode = branchCode.padStart(5, '0');
            otherBranchCodeInput.value = branchCode;
        }

        // Check if the branch code is valid
        if (!isBranchCodeValid(branchCode)) {
            otherBranchCodeInput.setCustomValidity('Invalid branch code.');
            if (errorSpan) {
                errorSpan.textContent = 'Invalid branch code.';
            }
        } else {
            otherBranchCodeInput.setCustomValidity('');
            if (errorSpan) {
                errorSpan.textContent = '';
            }
        }
    }


    // Example function to check if the branch code is valid
    function isBranchCodeValid(branchCode) {
        return /^\d{5}$/.test(branchCode); // Example validation for a five-digit code
    }

    // Initial display based on selected value
    toggleOtherBranch();

    // Listen for changes using Select2 event
    $('#branchSelect').on('select2:select select2:unselect', function () {
        toggleOtherBranch();
    });

    // Add event listeners for branch code validation
    otherBranchCodeInput.addEventListener('input', validateBranchCode);
    otherBranchCodeInput.addEventListener('change', validateBranchCode);
    
    // Initial validation in case the form is pre-populated
    validateBranchCode();
});
</script>


<script>
    document.getElementById('rinnraksha_status').addEventListener('change', function() {
        var rinnraksha_amt_div = document.getElementById('rinnraksha_amt_div');
        var rinnraksha_amt_input = document.getElementById('rinnraksha_amt');
        var rinnraksha_cbs_div = document.getElementById('rinnraksha_cbs_div');
        var rinnraksha_cbs_input = document.getElementById('rr_cbs_acct_no');
        if (this.value === 'Yes') {
            rinnraksha_amt_div.style.display = 'block';
            rinnraksha_amt_input.required = true;
            rinnraksha_cbs_div.style.display = 'block';
            rinnraksha_cbs_input.required = true;
        } else {
            rinnraksha_amt_div.style.display = 'none';
            rinnraksha_amt_input.required = false;
            rinnraksha_cbs_div.style.display = 'none';
            rinnraksha_cbs_input.required = false;
        }
    });
</script>



<script>
$(document).ready(function(){
    $('#stateSelect').change(function(){
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('admin/get_cities') ?>',
                type: 'POST',
                data: {state_id: stateId},
                dataType: 'json',
                success: function(data) {
                    $('#citySelect').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#citySelect').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });

                    // Get the customer's city ID
                    var customerCityId = <?= (isset($user) && $user->city_id !== null) ? $user->city_id : 'null' ?>;
                    
                    // Set the selected city in the dropdown
                    if (customerCityId !== null) {
                        $('#citySelect').val(customerCityId);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#citySelect').empty().append('<option value="">-Select-</option>');
        }
    });

    // Trigger change event on page load if state is already selected
    $('#stateSelect').trigger('change');

    // Check if user is editing profile and city ID is null
    var isEditing = <?= (isset($user) && $user->id) ? 'true' : 'false' ?>;
    var cityId = <?= (isset($user) && $user->city_id !== null) ? $user->city_id : 'null' ?>;

    if (isEditing && cityId === null) {
        // Display cities state-wise
        $('#stateSelect').trigger('change');
    }
});



</script>

<script>
$(document).ready(function(){
    $('#stateSelectotherBranch').change(function(){
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('admin/get_cities') ?>',
                type: 'POST',
                data: {state_id: stateId},
                dataType: 'json',
                success: function(data) {
                    $('#citySelectotherBranch').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#citySelectotherBranch').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });

                    // Get the customer's city ID
                    var customerCityId = <?= (isset($user) && $user->city_id !== null) ? $user->city_id : 'null' ?>;
                    
                    // Set the selected city in the dropdown
                    if (customerCityId !== null) {
                        $('#citySelectotherBranch').val(customerCityId);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#citySelectotherBranch').empty().append('<option value="">-Select-</option>');
        }
    });

    // Trigger change event on page load if state is already selected
    $('#stateSelectotherBranch').trigger('change');

    // Check if user is editing profile and city ID is null
    var isEditing = <?= (isset($user) && $user->id) ? 'true' : 'false' ?>;
    var cityId = <?= (isset($user) && $user->city_id !== null) ? $user->city_id : 'null' ?>;

    if (isEditing && cityId === null) {
        // Display cities state-wise
        $('#stateSelectotherBranch').trigger('change');
    }
});
</script>

<?php if(isset($user) && $user->id){ ?>
    <script>document.getElementsByName('other_branch_code')[0].disabled = true;</script>
<?php } ?>

<script type="text/javascript">
$(document).ready(function(){
    $('select[name="loan_type_id"]').on('change', function(){
        var selectedLoanType = $(this).val();
        if (selectedLoanType == '9') {
             $(this).val(''); 
            window.location.href = '<?= base_url("admin/pending_rr_form/") ?>';
        }
    });
});
</script>

<script>
document.getElementById('rinnraksha_amt').addEventListener('input', function (e) {
    // Replace any character that is not a digit or decimal point
    this.value = this.value.replace(/[^0-9.]/g, '');
});
document.getElementById('amountInput').addEventListener('input', function (e) {
    // Replace any character that is not a digit or decimal point
    this.value = this.value.replace(/[^0-9.]/g, '');
});
</script>




<script>
$(document).ready(function() {
    // When the dropdown value changes
    $('#connector_id').change(function() {
        // Get the selected value
        var staff_id = $(this).val();

        // If a partner is selected, make an AJAX request
        if (staff_id !== '') {
            $.ajax({
                url: '<?= base_url("admin/fetch_partner_code") ?>', // Replace with your controller/method
                type: 'POST',
                data: { staff_id: staff_id },
                dataType: 'json',
                success: function(response) {
                    if (response.status == 'success') {
                        // Update the input field with the fetched partner code
                        $('#partner_code').val(response.hlc_code);
                    } else {
                        $('#partner_code').val(''); // Clear the input if no data found
                    }
                },
                error: function() {
                    alert('Error fetching partner code.');
                }
            });
        } else {
            $('#partner_code').val(''); // Clear the input if no partner selected
        }
    });
});


$(document).ready(function () {
    // Attach onchange event to the Partner Code input field
    $('#partner_code').on('change', function () {
        const inputHlcCode = $(this).val().trim(); // Get the entered HLC code

        if (inputHlcCode !== "") {
            // Perform AJAX request to fetch partner details
            $.ajax({
                url: '<?= base_url("admin/get_partner_by_code"); ?>', // Replace with your endpoint
                type: 'POST',
                data: { hlc_code: inputHlcCode },
                dataType: 'json',
                success: function (response) {
                    if (response.status === 'success') {
                        var partner = response.partner;

                        // Update the dropdown selection
                        $('#connector_id').val(partner.staff_id).change();

                        // Ensure the Partner Code field reflects the correct value
                        $('#partner_code').val(partner.hlc_code);
                    } else {
                        // Clear the dropdown if no partner is found
                        $('#connector_id').val('').change();

                        // Optional: Provide feedback (e.g., console log or visual cue)
                        console.log('Partner not found');
                    }
                },
                error: function () {
                    console.error('An error occurred while fetching the partner.');
                }
            });
        } else {
            // Clear the dropdown if the input is empty
            $('#connector_id').val('').change();
        }
    });

    // Synchronize dropdown changes to Partner Code field
    $('#connector_id').on('change', function () {
        const selectedOption = $(this).find('option:selected');
        const hlcCode = selectedOption.data('hlc') || ''; // Get HLC code of selected option
        $('#partner_code').val(hlcCode); // Update the Partner Code field
    });
});

</script>
