<main class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <!--end breadcrumb-->
    <div class="card">
        
        <div class="card-body">
            <div class="top-controls">
    
            <div class="left-area">
                 <div class="export-buttons"></div>
            </div>
        
                <div class="right-area">
                    <input type="text" class="search-box" id="tableSearch" placeholder="🔍 Search">
                    
                    <!-- FIX: button inside anchor removed -->
                    <a href="<?= base_url('admin/racpc_form/') ?>" class="role-btn">+ Add RACPC</a>
        
                </div>
            </div>
           
            <div class="table-responsive mobile-scroll">
              <table class="table align-middle table-striped" id="Table">
                <thead>
                    <tr>
                        <th>Sr.No</th>
                        <th>RACPC Name</th>
                        <th>Circle</th>
                        <th>City</th>
                        <th>State</th>
                        <th>Created By</th> 
                        <th>Modified By</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
            </div>
           
        </div>
    </div>
</main>


<script>
$(document).ready(function() {
    var table = $('#Table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/get_racpc_list') ?>",
            "type": "POST"
        },
       
        "paging": false,
        "lengthChange": false,
        "info": false,
        "ordering": true,
        "dom": 'Bfrtip', // basic dom for buttons
        "buttons": [
            {
                extend: 'excel',
                text: '<img src="<?= base_url("admin_assets/images/icons/excel.png") ?>" class="export-icon">',
                titleAttr: 'Export to Excel',
                className: 'export-btn'
            },
            {
                extend: 'pdf',
                text: '<img src="<?= base_url("admin_assets/images/icons/pdf.png") ?>" class="export-icon">',
                titleAttr: 'Export to PDF',
                className: 'export-btn',
                orientation: 'landscape'
            },
            {
                extend: 'print',
                text: '<img src="<?= base_url("admin_assets/images/icons/print.png") ?>" class="export-icon">',
                titleAttr: 'Print',
                className: 'export-btn',
                orientation: 'landscape'
            }
        ]
    });

     // Move buttons into left-area
    table.buttons().container().appendTo($('.export-buttons'));

    // Search box
    $("#tableSearch").on("keyup", function () {
        table.search(this.value).draw();
    });
    
    // Move buttons container to a specific location if needed
    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');

    // Event delegation for delete button
    $(document).on('click', '.delete', function () {
        var element = $(this);
        var id = element.data('id'); // Use data-id attribute to get the ID
        var action = element.attr('action');
       
        Swal.fire({
            title: 'Are you sure?',
            text: "Are you sure you want to delete this account?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    url: base_url + 'Admin/' + action + '/' + id,
                    dataType: 'json',
                    success: function(res) {
                        if (res.success == '1') {
                            notify(res.type, res.message);
                            table.ajax.reload();  // Reload the table data after deletion
                        } else {
                            notify(res.type, res.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                        alert('Error occurred while deleting data. Please try again.');
                    }
                });
            }
        });
    });
});

</script>
<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
</style>