<!-- Applicant Modal -->
<div class="modal fade" id="batchApplicantModal" tabindex="-1" aria-labelledby="batchModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Applicants in Batch</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="modal_applicant_list">
        Loading...
      </div>
    </div>
  </div>
</div>

<main class="page-content">

    <div class="card">
              <div class="card-body">
            <form id="filterForm" action="<?php echo base_url('admin/manage_pb_sbi_branch_download_list'); ?>" method="post">
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label for="start_date">Start Date:</label>
                        <input class="form-control" type="date" id="start_date" name="start_date" value="<?php echo isset($_POST['start_date']) ? $_POST['start_date'] : ''; ?>">
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="end_date">End Date:</label>
                        <input class="form-control" type="date" id="end_date" name="end_date" value="<?php echo isset($_POST['end_date']) ? $_POST['end_date'] : ''; ?>">
                    </div>
                   
                    <?php if($_SESSION['staff_type']==0){ ?>
                  <!--  <div class="col-md-2 mb-3">
                        <label for="connector">Partner</label>
                        <select class="single-select" id="connector" name="connector">
                            <option value="">Select Partner</option>
                            <?php foreach ($connector as $connectorItem) : ?>
                                <option value="<?= $connectorItem['staff_id']; ?>" <?php echo isset($_POST['connector']) && $_POST['connector'] === $connectorItem['staff_id'] ? 'selected' : ''; ?>><?= $connectorItem['staff_fullname']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label for="created_by_part">Created By Part.</label>
                        <select class="single-select" id="created_by_part" name="created_by_part">
                            <option value="">Select</option>
                            <?php foreach ($connector_created as $connectorItem1) : ?>
                                <option value="<?= $connectorItem1['staff_fullname']; ?>" <?php echo isset($_POST['created_by_part']) && $_POST['created_by_part'] === $connectorItem1['staff_fullname'] ? 'selected' : ''; ?>><?= $connectorItem1['staff_fullname']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>-->
                    
                    <?php } ?>

                    <!--<div class="col-md-2 mb-3">
                        <label for="hlc_status">Payment Partner Status</label>
                        <select name="hlc_status" id="hlc_status" class="form-control">
                            <option value="">--Select--</option>
                            <option value="paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'paid' ? 'selected' : ''; ?>>Paid</option>
                            <option value="unpaid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                            <option value="partly paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'partly paid' ? 'selected' : ''; ?>>Partly Paid</option>
                            <option value="excess paid" <?php echo isset($_POST['hlc_status']) && $_POST['hlc_status'] === 'excess paid' ? 'selected' : ''; ?>>Excess paid</option>
                        </select>
                    </div>-->
                    
                    
                   
                   <!-- <div class="col-md-2 mb-3">
                        <label for="month">Month</label>
                        <input type="month" name="month" id="month" class="form-control" value="<?php echo isset($_POST['month']) ? $_POST['month'] : ''; ?>">
                    </div>-->

                    <div class="col-md-3 mb-3">
                        <br>
                        <button type="button" class="btn btn-success" id="filterSubmit">Filter</button>
                        <button class="btn btn-info" type="button" id="resetButton">Reset</button>
                    </div>
                </div>
            </form>
            
           
            <div class="table-responsive">

                <table class="table align-middle table-striped" id="userTable">
                  

                     <thead>
                        <tr>
                          <!--  <th><input type="checkbox" id="select-all"></th>-->
                            <th>Sr.No</th>
                            <th>Batch No</th>
                            <th>Total Applicants</th>
                            <th>Total Sanction Loan Amt</th>
                            <th>Download Date</th>
                          <!--  <th>Verify</th>-->
                            <th>Downloaded By</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>          
                             
                   </tbody>
                  
                </div>
  </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
$(document).ready(function () {
    const staffType = <?= $_SESSION['staff_type']; ?>;
    const staffId = <?= $_SESSION['staff_id']; ?>;

    const columns = [
        { "data": "sr_no" },
        { "data": "pbsbi_branch_annx_download_key" },
        { "data": "total_applicants" },
        { "data": "sanction_loan_amt" },
        { "data": "pbsbi_branch_annx_download_date" },
        { "data": "pbsbi_branch_annx_download_by" },
        { "data": "action" }
    ];

    const table = $('#userTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?= base_url('admin/fetch_pb_sbi_branch_download_list'); ?>",
            type: "POST",
            data: function (d) {
                d.start_date = $('#start_date').val();
                d.end_date = $('#end_date').val();
               
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.error("Error loading data: ", textStatus, errorThrown);
            }
        },
        language: {
            processing: "<div class='spinner-border text-primary' role='status'></div> Loading..."
        },
        columns: columns,
        lengthMenu: [[50, 100, 200, 300], [50, 100, 200, 300]],
        pageLength: 50,
        order: [[0, 'desc']],
        scrollX: true,
        buttons: [
            { extend: 'colvis', text: 'Column Visibility' }
        ]
    });

    // Handle filter submit
    $('#filterSubmit').click(function () {
        const selectedMonth = $('#month').val();
        if (selectedMonth) {
            table.page.len(-1).draw();
        } else {
            table.draw();
        }
    });

    // Handle reset
    $('#resetButton').click(function () {
        $('#filterForm')[0].reset();
        $('.single-select, .multiple-select').val('').trigger('change');
        table.ajax.reload();
    });

    // Dependent City dropdown
    $('#state_id').change(function () {
        const stateId = $(this).val();
        if (stateId !== '') {
            $.ajax({
                url: '<?= base_url('Admin/get_cities') ?>',
                type: 'POST',
                data: { state_id: stateId },
                dataType: 'json',
                success: function (data) {
                    $('#city_id').empty().append('<option value="">-Select-</option>');
                    $.each(data, function (key, value) {
                        $('#city_id').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });
                },
                error: function (xhr) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#city_id').empty().append('<option value="">-Select-</option>');
        }
    });

    $('#state_id').trigger('change');

    // Handle checkbox selection
    const selectedCheckboxes = new Set();

    $('#select-all').on('click', function () {
        const isChecked = this.checked;
        $('.row-checkbox').each(function () {
            this.checked = isChecked;
            const val = $(this).val();
            isChecked ? selectedCheckboxes.add(val) : selectedCheckboxes.delete(val);
        });
    });

    $('#userTable').on('click', '.row-checkbox', function () {
        const val = $(this).val();
        this.checked ? selectedCheckboxes.add(val) : selectedCheckboxes.delete(val);
        $('#select-all').prop('checked', $('.row-checkbox:checked').length === $('.row-checkbox').length);
    });
});



$(document).on('click', '.view-batch', function () {
    const batchKey = $(this).data('batch');
    $('#modal_applicant_list').html('Loading...');

    $.ajax({
        url: base_url + 'admin/fetch_batch_applicant_names',
        type: 'POST',
        data: { batch_key: batchKey },
        success: function (res) {
            $('#modal_applicant_list').html(res);
            $('#batchApplicantModal').modal('show');
        }
    });
});


 // When user clicks upload icon
$(document).on('click', '.upload-excel', function () {
  var batchKey = $(this).data('batch');

  // Trigger the hidden file input for this batch
  $(this).siblings('input.excel-upload-input[data-batch="' + batchKey + '"]').click();
});

$(document).on('change', '.excel-upload-input', function () {
  var file = this.files[0];
  var batchKey = $(this).data('batch');

  if (!file) return;

  var allowedTypes = [
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'application/vnd.ms-excel'
  ];

  if (!allowedTypes.includes(file.type)) {
    alert('Only Excel files are allowed.');
    return;
  }

  var formData = new FormData();
  formData.append('file', file);
  formData.append('batch_key', batchKey);

  $.ajax({
    url: '<?= base_url('admin/upload_excel_pb_sbi_branch_download_list') ?>',
    method: 'POST',
    data: formData,
    contentType: false,
    processData: false,
    dataType: 'json', // Ensures response is treated as JSON
    success: function (res) {
      if (res.status) {
        alert(res.message); // ✅ Shows exact success message from PHP
        $('#userTable').DataTable().ajax.reload(null, false);
      } else {
        alert(res.message || 'Upload failed.'); // ✅ Shows exact error from PHP
      }
    },
    error: function (xhr, status, error) {
      alert('Upload failed due to server error: ' + error); // fallback for server failure
    }
  });
});


</script>

<style>
   .dataTables_length {
      margin-bottom: 13px;
  }
  .dataTables_filter {
      margin-top: 12px;
  }

</style>







<style>
/* Hide default radio button appearance */
.form-check-input {
    position: absolute;
    opacity: 0;
   
}
.form-check {
    display: block;
    min-height: 1.5rem;
    padding-left: 0px !important;
    margin-bottom: .125rem;
}

/* Style the card as selectable */
.custom-card {
    cursor: pointer;
    width: 150px;
    margin-bottom: 20px;
    border: 2px solid #ccc;
    border-radius: 5px;
    transition: all 0.3s ease;
    display: inline-block;
    text-align: center;
}

/* Change border color and background when selected */
.form-check-input:checked + .custom-label {
    border-color: green;
    background-color: green;
    color: white;
    padding: 10px;
    border-radius: 5px;
    display: inline-block;
}

/* Style for the label to appear like a card */
.custom-label {
    display: inline-block;
    padding: 10px;
    border-radius: 5px;
    border: 2px solid #ccc;
    transition: all 0.3s ease;
    width: 100%;
}

/* Hover effect for the card */
.custom-card:hover .custom-label {
    border-color: green;
}

.dataTables_processing .spinner-border {
    width: 2rem;
    height: 2rem;
    margin-right: 10px;
    vertical-align: middle;
}
</style>
