<!-- Edit Payment Log Modal (Bootstrap 5) -->
<!-- Bootstrap 5 Modal -->
<div class="modal fade" id="editPaymentModal" tabindex="-1" aria-labelledby="editPaymentModalLabel" aria-hidden="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editPaymentModalLabel">Edit Payment Log</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editPaymentForm">
                    <input type="hidden" id="edit_invoice_batchno" name="invoice_batchno">
                    <input type="hidden" id="edit_invoice_no_id" name="invoice_no_id">
                    
                    <div class="mb-3">
                        <label class="form-label">Pay Date:</label>
                        <input type="date" class="form-control" id="edit_payment_date" name="payment_date" required>
                    </div>

                   <!-- <div class="mb-3">
                        <label class="form-label">Pay Amount:</label>
                        <input type="number" step="0.01" class="form-control" id="edit_pay_amt" name="pay_amt" required>
                    </div>-->

                    <div class="mb-3">
                        <label class="form-label">Ref No/Cheq No:</label>
                         <textarea class="form-control" id="edit_bank_details" name="bank_details"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Remark:</label>
                        <textarea class="form-control" id="edit_remark" name="remark"></textarea>
                    </div>

                    <button type="submit" class="btn btn-success">Update Payment</button>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="editInvoiceDateModal" tabindex="-1" aria-labelledby="editInvoiceDateModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="invoiceDateForm">
        <div class="modal-header">
          <h5 class="modal-title">Edit Invoice Date</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="invoice_batchno" id="invoice_batchno">
          <label for="invoice_date">Invoice Date</label>
          <input type="date" name="invoice_date" id="invoice_date" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="modal fade" id="editInvoiceNumModal" tabindex="-1" aria-labelledby="editInvoiceNumModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="invoiceNumForm">
        <div class="modal-header">
          <h5 class="modal-title">Edit Invoice Number</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="invoice_batchno" id="invoice_batchno_num">
          <label for="invoice_num">Invoice Number</label>
          <input type="text" name="invoice_num" id="invoice_num" class="form-control" required>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<main class="page-content">
  <!--breadcrumb-->
  <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3"> <?= $title ?> </div>
  </div>
  <!--end breadcrumb-->
  <div class="card">
    <div class="card-body">
    <form id="filterForm" method="post">
        <div class="row">
          <div class="col-md-2">
            <label for="start_date">Start Date:</label>
            <input class="form-control" type="date" id="start_date" name="start_date">
          </div>
          <div class="col-md-2">
            <label for="end_date">End Date:</label>
            <input class="form-control" type="date" id="end_date" name="end_date">
          </div>
          <div class="col-md-2">
            <label for="branch">Branch</label>
            <select class="single-select" id="branch" name="branch">
                <option value="">Select Branch</option>
                <?php foreach ($branch as $branchItem) : ?>
                    <option value="<?= $branchItem['id']; ?>"><?= $branchItem['branch_name']; ?></option>
                <?php endforeach; ?>
            </select>
          </div>
          <?php if($_SESSION['staff_type']==0){ ?>
          <div class="col-md-2">
            <label for="connector">Partner</label>
            <select class="single-select" id="connector" name="connector">
              <option value="">Select Partner</option> 
              <?php foreach ($connector as $connectorItem) : ?> 
              <option value="<?= $connectorItem['staff_id']; ?>"><?= $connectorItem['staff_fullname']; ?></option>
              <?php endforeach; ?>
            </select>
          </div> 
          <?php } ?>
          <div class="col-md-2">
            <label for="hlc_status">Payment Partner Status</label>
                <select name="hlc_status[]" id="hlc_status" class="multiple-select select2-hidden-accessible" multiple data-placeholder="--Select--">
                   
                    <option value="paid" <?php echo (isset($_POST['hlc_status']) && in_array('paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Paid</option>
                    <option value="unpaid" <?php echo (isset($_POST['hlc_status']) && in_array('unpaid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Unpaid</option>
                    <option value="partly paid" <?php echo (isset($_POST['hlc_status']) && in_array('partly paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Partly Paid</option>
                    <option value="excess paid" <?php echo (isset($_POST['hlc_status']) && in_array('excess paid', $_POST['hlc_status'])) ? 'selected' : ''; ?>>Excess paid</option>
                </select>
           <!-- <label for="hlc_status">Payment Partner Status</label>
            <select name="hlc_status" class="form-control" id="hlc_status">
              <option value="">--Select--</option>
              <option value="paid">Paid</option>
              <option value="unpaid">Unpaid</option>
              <option value="partly paid">Partly Paid</option>
              <option value="excess paid">Excess paid</option>
            </select>-->
          </div>
          <div class="col-md-2 mb-3">
            <label class="">State</label>
            <select name="state_id" class="single-select" id="state_id">
              <option value="">-Select-</option>
              <?php foreach ($state as $value) { ?>
              <option value="<?= $value['id']; ?>"><?= $value['state_name']; ?></option>
              <?php } ?>                           
            </select>                               
          </div> 
          <div class="col-md-2 mb-3">
           <label for="city_id">City</label>
                    <select name="city_id[]" id="city_id" class="single-select" multiple>
                        <option value="">-Select-</option>
                    </select>
          <!--  <label class="form-label">City</label>
            <select name="city_id" class="single-select" id="citySelect">
              <option value="">-Select-</option>
            </select>-->
          </div>
          <div class="col-md-2 mb-3">
            <label class="form-label">Disb Month</label>
            <input type="month" name="month" class="form-control" id="month">
          </div>
          <div class="col-md-2 mb-3">
            <label class="form-label">Payment Month</label>
            <input type="month" name="payment_month_hlc" class="form-control" id="payment_month_hlc">
          </div>
          <div class="col-md-3 mb-3">
              <br>
            <button class="btn btn-success" type="button" id="filterButton">Filter</button>
            <button class="btn btn-info" type="button" id="resetButton">Reset</button>
          </div>
        </div>
      </form>

      <hr class="mt-3">
     <!-- <ul class="nav nav-tabs" id="myTabs">
        <li class="nav-item">
          <a class="nav-link active" id="unclear-tab" data-bs-toggle="tab" href="#unclear">Invoices</a>
        </li>
       <li class="nav-item">
          <a class="nav-link" id="paid-tab" data-bs-toggle="tab" href="#paid">Paid</a>
        </li>
      
      </ul>-->
      <!-- Bootstrap Tab Content -->
      <div class="tab-content mt-2">
        <div class="tab-pane fade show active" id="unclear">
          <!--<h2>Unclear Invoices</h2>-->
         <!-- <form id="perPageForm" method="post" action="<?php echo base_url('admin/manage_invoice'); ?>">
              <select id="itemsPerPageSelector" name="per_page" onchange="updatePerPage()">
                <option value="">--select--</option>
                <option value="20">20 per page</option>
                <option value="100">100 per page</option>
                <option value="500">500 per page</option>
              </select>
            </form>-->
            
     <div class="table-responsive">
    <table class="table align-middle table-striped" id="invoiceTable">
       <div class="d-flex align-items-center">
    <?php if($_SESSION['staff_id'] == 14 || $_SESSION['staff_id'] == 13){ ?>
        <!--<div class="me-2 mb-3">
            <!-- Use a button with an onclick handler -->
            <!--<button type="button" class="btn btn-success btn-sm" id="excelBtn" onclick="downloadExcel()">
                <i class="bi bi-file-excel"></i> Export Partner Paid
            </button>
        </div>-->
        
        <div class="me-2 mb-3">
            <button type="button" class="btn btn-success btn-sm" id="exportPayoutBtn" onclick="downloadExcelPayout()">
                <i class="bi bi-file-excel"></i> Export to Payout
            </button>
        </div>
        
    <?php } ?>
</div>

<script>

function downloadExcelPayout() {
    let selectedIds = [];
    document.querySelectorAll("input[name='partner_id[]']:checked").forEach((el) => {
        selectedIds.push(el.value);
    });

    if (selectedIds.length === 0) {
        alert("Please select at least one partner to export.");
        return;
    }

    $.ajax({
        url: "<?= base_url('admin/export_payout_excel') ?>",
        type: "POST",
        data: { "partner_id": selectedIds },
        xhrFields: { responseType: 'blob' }, // 👈 important for Excel
        success: function (data, status, xhr) {
            // Get filename from headers
            let filename = "";
            let disposition = xhr.getResponseHeader('Content-Disposition');
            if (disposition && disposition.indexOf('filename=') !== -1) {
                filename = disposition.split('filename=')[1].replace(/"/g, '');
            }

            // Download file
            let blob = new Blob([data], { type: xhr.getResponseHeader('Content-Type') });
            let link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = filename || "export.xlsx";
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);

            // 👇 reload after download
            setTimeout(() => {
                $('#invoiceTable').DataTable().ajax.reload();
            }, 1000);
        }
    });
}


async function downloadExcel() {
  const btn = document.getElementById('excelBtn');
  btn.disabled = true;
  btn.innerText = 'Please wait file downloading...';

  try {
    // Gather the filter form data as a query string
    const form = document.getElementById('filterForm');
    const formData = new FormData(form);
    const queryString = new URLSearchParams(formData).toString();
   console.log('Query String:', queryString); // Check the query parameters

    // Send the request to Mb_hlc_paid_excel with query params
    const response = await fetch('<?php echo base_url(); ?>Mb_hlc_paid_excel?' + queryString, {
      method: 'GET'
    });

    if (!response.ok) {
      throw new Error('Download failed');
    }

    // Convert the response to a Blob
    const blob = await response.blob();

    // Create a temporary URL for the Blob
    const url = window.URL.createObjectURL(blob);

    // Create a temporary link element
    const a = document.createElement('a');
    a.href = url;
    a.download = 'MB_HLC_Paid_List.xlsx'; // The filename for the download
    document.body.appendChild(a);
    a.click();

    // Clean up
    window.URL.revokeObjectURL(url);
    document.body.removeChild(a);

    // Re-enable the button and restore text
    btn.disabled = false;
    btn.innerText = 'Export Partner Paid';

  } catch (error) {
    console.error(error);
    alert('An error occurred while downloading the file.');
    // Re-enable the button if there's an error
    btn.disabled = false;
    btn.innerText = 'Export Partner Paid';
  }
}
</script>
        <thead>
            <tr>
                <th><input type="checkbox" id="checkAll"></th>
                <th>Sr.No</th>
                <th>Partner Name</th>
                <th>City</th>
                <th>Applicant</th>
                <th>Inv Number</th>
                <th>Basic Amt</th>
                <th>CGST 9%</th>
                <th>SGST 9%</th>
                <th>IGST 18%</th>
                <th>Net Pay Amt</th>
                <th>TDS Amt</th>
                <th>Paid Amt</th>
                <th>Balance</th>
                <th>Invoice Date</th>
                <th>Payment Log</th>
                <th>Created Date</th>
                <th>Payment Status</th>
                <th>Created By</th>
               <!-- <th>Actions</th>-->
            </tr>
        </thead>
        <tbody>          
                             
        </tbody>
    </table>
</div>

<!-- Display Total Outside Table -->

        </div>
       <!-- <div class="tab-pane fade" id="paid">
        
        </div>-->
     
      </div>
    </div>
  </div>
</main>


<div class="modal fade" id="invoiceModal" tabindex="-1" aria-labelledby="invoiceModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content" style="overflow-y: auto !important; max-height: inherit;">
      <div class="modal-header">
        <h5 class="modal-title" id="invoiceModalLabel">Payment Status <span id="invoiceNumberLabel"></span></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="invoiceForm" action="<?php echo base_url()?>admin/save_invoice_log_hlc" method="post" enctype="multipart/form-data">
        <div class="modal-body">
          <div class="row">
              <input type="hidden" id="invoiceId" name="invoiceId" value="">
            
              <input type="hidden" id="total_payable" name="total_payable" value="">
              <!--<div class="col-lg-4">
                   <label for="invoiceStatus" class="form-label">Invoice Status</label>
                      <select class="form-select"  name="status" required>
                        <option value="">--Select--</option>
                        <option value="Paid">Paid</option>
                        <option value="Processing">Processing</option>
                      </select>
              </div>-->
              <div class="col-lg-4">
                      <label class="form-label">Net Pay Amt</label>
                      <input type="text" class="form-control" id="tot_pay" value="" readonly>
              </div>
              <div class="col-lg-4">
                      <label class="form-label">Remaining Amt</label>
                      <input type="text" class="form-control" id="rem_amt" value="" readonly>
              </div>
              <div class="col-lg-4">
                    <label for="pay_amt" class="form-label">Pay Amount</label>
                    <input type="text" class="form-control" id="pay_amt" name="pay_amt" required>
                    <div id="error_message" style="color: red;"></div>
              </div>
              <div class="col-lg-4">
                    <label for="payment_date" class="form-label">Payment Date</label>
                    <input type="date" class="form-control" id="payment_date" name="payment_date" required>
              </div>
             <!--  <div class="col-lg-6">
                    <label for="attachment" class="form-label">Attachment</label>
                    <input type="file" class="form-control" id="attachment" name="attachment">
               </div>-->
          </div>
           <div class="row">
                <div class="col-lg-6">
                    <label for="bankDetails" class="form-label">Ref No/Cheq No</label>
                   <textarea class="form-control"  name="bank_details" rows="2"></textarea>
              </div>
              <div class="col-lg-6">
                  <label for="remark" class="form-label">Remark</label>
                   <textarea class="form-control" id="remark" name="remark" rows="2"></textarea>
              </div>
             
          </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Submit</button>
      </div>
      </form>
      <hr>
     
      <div class="container table-responsive">
        <h6>Payment History </h6>
               <table class="table" id="paymentHistoryTable">
                  <thead>
                    <tr>
                      <th>Sr. No.</th>
                      <th>Payment Date</th>
                      <th>Pay Amt</th>
                      <th>Ref No/Cheq No</th>
                      <th>Remark</th>
                      <th>Status</th>
                    </tr>
                  </thead>
                  <tbody id="paymentHistoryBody">
                    <!-- Payment history rows will be inserted here dynamically -->
                  </tbody>
                </table>
         </div>
         
    </div>
  </div>
</div>




<script>
$(document).ready(function() {
  function getFilterParams() {
    return {
      start_date: $('#start_date').val(),
      end_date: $('#end_date').val(),
      branch: $('#branch').val(),
      connector: $('#connector').val(),
      hlc_status: $('#hlc_status').val(),
      state_id: $('#state_id').val(),
      city_id: $('#city_id').val(),
      month: $('#month').val(),
      payment_month_hlc: $('#payment_month_hlc').val(),
    };
  }

  var table = $('#invoiceTable').DataTable({
    "processing": true,
    "serverSide": true,
    "ajax": {
      "url": "<?= base_url('admin/fetch_payout_invoice_data_hlc') ?>",
      "type": "POST",
      "data": function(d) {
        return $.extend({}, d, getFilterParams());
      }
    },
    "columns": [
      { "data": "checkbox" },  
      { "data": "sr_no" },
      { "data": "hlc_name" },
      { "data": "city" },
      { "data": "applicant" },
      { "data": "inv_number" },
      { "data": "subtotal" },
      { "data": "cgst" },
      { "data": "sgst" },
      { "data": "igst" },
      { "data": "net_pay_amt" },
      { "data": "tds" },
      { "data": "paid_amt" },
      { "data": "balance" },
      { "data": "invoice_date" },
      { "data": "payment_log" },
      { "data": "created_date" },
      { "data": "payment_status" },
      { "data": "created_by" },
     /* { "data": "edit" }*/
    ],
    "order": [[10, 'desc']],
    "lengthChange": true,
    "lengthMenu": [[50,100, 300,1000], [50,100, 300,1000]],
    "pageLength": 50,
    "dom": 'lBfrtip',
    "scrollX": true,
    "fixedColumns": {
      leftColumns: 0,
      rightColumns: 1,
    },
    "buttons": [
      { extend: 'excel', text: 'Excel' }
    ],
   
    "drawCallback": function(settings) {
      $('[data-bs-toggle="tooltip"]').tooltip();

      // Adjust the height of the fixed columns to match the scrollable columns
      setTimeout(function() {
        var scrollBodyHeight = $('.dataTables_scrollBody').height();
        $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
        $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

        // Adjust the row heights to match
        $('#invoiceTable tbody tr').each(function(index) {
          var rowHeight = $(this).height();
          $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
          $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
        });
      }, 10);

       // Calculate and display totals
       calculateAndDisplayTotals();

    }
  });

  table.buttons().container().appendTo('#invoiceTable_wrapper .col-md-6:eq(0)');

  

  $('#filterButton').on('click', function() {
    table.ajax.reload();
  });

   $('#resetButton').on('click', function() {
    
        $('.single-select, .multiple-select').each(function() {
            $(this).val('').trigger('change');
        });
    $('#filterForm')[0].reset();
    table.ajax.reload();
  });

  // Fetch cities on state change
  $('#state_id').change(function() {
    var stateId = $(this).val();
    if (stateId !== '') {
      $.ajax({
        url: '<?= base_url('admin/get_cities') ?>',
        type: 'POST',
        data: { state_id: stateId },
        dataType: 'json',
        success: function(data) {
          $('#city_id').empty().append('<option value="">-Select-</option>');
          $.each(data, function(key, value) {
            $('#city_id').append('<option value="' + value.id + '">' + value.city_name + '</option>');
          });
        },
        error: function(xhr, status, error) {
          console.error(xhr.responseText);
        }
      });
    } else {
      $('#city_id').empty().append('<option value="">-Select-</option>');
    }
  });

  // Trigger change event on page load if state is already selected
  $('#state_id').trigger('change');

  function calculateAndDisplayTotals() {
    var totalNetPayAmt = 0;
    var totalTdsPer = 0 ;
    var totalPaidAmt = 0;
    var totalBalance = 0;
    var totaltdsAmt = 0;

    $('#invoiceTable tbody tr').each(function() {
      var netPayAmt = parseFloat($(this).find('td').eq(5).text().replace(/[^0-9.-]+/g,""));
      var paidAmt = parseFloat($(this).find('td').eq(6).text().replace(/[^0-9.-]+/g,""));
      var balance = parseFloat($(this).find('td').eq(7).text().replace(/[^0-9.-]+/g,""));
     // var TdsPer = parseFloat($(this).find('td').eq(8).text().replace(/[^0-9.-]+/g,""));
      var tdsAmt = parseFloat($(this).find('td').eq(8).text().replace(/[^0-9.-]+/g,""));

      if (!isNaN(netPayAmt)) totalNetPayAmt += netPayAmt;
      if (!isNaN(paidAmt)) totalPaidAmt += paidAmt;
      if (!isNaN(balance)) totalBalance += balance;
     // if (!isNaN(TdsPer)) totalTdsPer += TdsPer;
      if (!isNaN(tdsAmt)) totaltdsAmt += tdsAmt;
    });

    $('#invoiceTable tfoot').remove(); // Remove existing tfoot if any

    var tfootHtml = `
      <tfoot>
        <tr>
          <th colspan="5">Total</th>
          <th>${totalNetPayAmt.toFixed(2)}</th>
          <th>${totalPaidAmt.toFixed(2)}</th>
          <th>${totalBalance.toFixed(2)}</th>
          
          <th>${totaltdsAmt.toFixed(2)}</th>
          <th colspan="5"></th>
        </tr>
      </tfoot>
    `;

    $('#invoiceTable').append(tfootHtml);
  }


  // Intercept the form submission
  $("#invoiceForm").submit(function(event) {
    // Prevent the default form submission
    event.preventDefault();

    // Get the values of pay_amt and total_payable
    var payAmt = $("#pay_amt").val();
    var totalPayable = $("#tot_pay").val();
    var rem_amt = $("#rem_amt").val();

    // Validate that pay_amt is not zero
    if (payAmt === 0) {
      // Display an error message to the user
      alert('Pay Amount cannot be zero.');
      return; // Do not proceed with form submission
    }

    // Get form data
    var formData = new FormData($(this)[0]);

    // Make an AJAX request
    $.ajax({
      type: 'POST',
      url: $(this).attr('action'),
      data: formData,
      contentType: false,
      processData: false,
      success: function(response) {
        // Handle the response here, if needed
        var parsedResponse = JSON.parse(response);

        if (parsedResponse.success === '0') {
          // Display success message to the user
          alert(parsedResponse.message);
          $('#invoiceModal').modal('hide');
          table.ajax.reload(null, false); // Reload DataTable
        } else {
          // Display error message to the user
          alert(parsedResponse.message);
        }
      },
      error: function(error) {
        // Handle errors here, if needed
        console.error(error);
      }
    });
  });

  // Function to open invoice modal and fetch payment history
  window.openInvoiceModal = function(invoiceId, totalpayable, rem_amt, InvNum) {
    // Convert totalpayable and rem_amt to numbers
    totalpayable = parseFloat(totalpayable);
    rem_amt = parseFloat(rem_amt);

    // Check if totalpayable and rem_amt are valid numbers
    if (isNaN(totalpayable) || isNaN(rem_amt)) {
        console.error('Invalid totalpayable or rem_amt:', totalpayable, rem_amt);
        return;
    }

    // Format totalpayable and rem_amt to two decimal places
    totalpayable = totalpayable.toFixed(2);
    rem_amt = rem_amt.toFixed(2);

    // Set the invoiceId
    $("#invoiceId").val(invoiceId);
    $("#total_payable").val(totalpayable);
    $("#tot_pay").val(totalpayable);
    $("#rem_amt").val(rem_amt);
    $("#invoiceNumberLabel").text('Invoice No: ' + InvNum);

    // Reset the form, excluding the invoiceId field
    $('#invoiceForm :input:not(#invoiceId):not(#total_payable):not(#tot_pay):not(#rem_amt)').val('');

    // Open the modal
    $('#invoiceModal').modal('show');
    
    // Fetch payment history based on invoice_batchno
    $.ajax({
      type: 'GET',
      url: '<?php echo base_url()?>admin/get_invoice_log/' + invoiceId,
      success: function(response) {
        // Update the payment history table
        updatePaymentHistoryTable(response);
      },
      error: function(error) {
        console.error(error);
      }
    });
  };


  
  function formatDate(dateString) {
    // Parse the date in its current format (assuming it's in 'yyyy-mm-dd' format)
    var parts = dateString.split("-");
    var formattedDate = parts[2] + "-" + parts[1] + "-" + parts[0];
    return formattedDate;
  }

  function updatePaymentHistoryTable(paymentHistory) {
    // Clear existing rows and reset total
    $('#paymentHistoryBody').empty();
    var totalPayAmt = 0;

    // Append new rows based on payment history data
    $.each(paymentHistory, function(index, payment) {
        // Format payment date
        var formattedDate = formatDate(payment.payment_date);

        // Parse pay_amt as a float and accumulate totalPayAmt
        var payAmt = parseFloat(payment.pay_amt);
        totalPayAmt += payAmt;

        var row = '<tr>' +
            '<td>' + (index + 1) + '</td>' +
            '<td>' + formattedDate + '</td>' +
            '<td>' + payAmt.toFixed(2) + '</td>' + // Format payAmt with two decimal places
            '<td>' + payment.bank_details + '</td>' +
            '<td>' + payment.remark + '</td>' +
            '</tr>';

        $('#paymentHistoryBody').append(row);
    });

    // Format totalPayAmt with two decimal places
    var formattedTotal = totalPayAmt.toFixed(2);

    // Display total at the end of the table
    var totalRow = '<tr>' +
        '<td colspan="2"><strong>Total PayAmt:</strong></td>' +
        '<td><strong>' + formattedTotal + '</strong></td>' + // Display formattedTotal
        '<td colspan="5"></td>' +
        '</tr>';

    $('#paymentHistoryBody').append(totalRow);
  }

  window.DeletePaymentLog = function(invoiceNumber) {
    Swal.fire({
        title: 'Are you sure?',
        text: 'Do you want to delete this payment log?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            // Perform the AJAX request to delete the log
            $.ajax({
                type: 'POST',
                url: '<?php echo base_url()?>admin/delete_payment_log_hlc',
                data: { invoice_number: invoiceNumber },
                success: function(response) {
                    var parsedResponse = JSON.parse(response);
                    if (parsedResponse.success === '1') {
                        Swal.fire(
                            'Deleted!',
                            'The payment log has been deleted.',
                            'success'
                        );
                        table.ajax.reload(null, false);
                    } else {
                        Swal.fire(
                            'Error!',
                            parsedResponse.message,
                            'error'
                        );
                    }
                },
                error: function(error) {
                    Swal.fire(
                        'Error!',
                        'There was an error deleting the payment log.',
                        'error'
                    );
                    console.error(error);
                }
            });
        }
    });
  };



  $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });

  // Ensure the form validation is correct for the pay amount
  $('#pay_amt').on('input', function() {
    var payAmt = parseFloat($(this).val());
    var remAmt = parseFloat($('#rem_amt').val());

    if (isNaN(payAmt)) {
        $('#error_message').text('Please enter a valid number.');
        $(this).val('');
    } /*else if (payAmt > remAmt) {
        $('#error_message').text('Pay Amount cannot be greater than Remaining Amount');
        $(this).val('');
    }*/ else {
        $('#error_message').text('');
    }
  });

  // Handle delete action with confirmation
  $(document).on('click', '.delete', function () {
    var element = $(this);
    var id = element.attr('data-id'); // Use data-id attribute to get the ID
    var action = element.attr('action');

    Swal.fire({
        title: 'Are you sure?',
        text: "Are you sure you want to delete this Invoice?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                type: 'POST',
                url: base_url + 'admin/' + action + '/' + id,
                dataType: 'json',
                success: function (res) {
                    if (res.success == '1') {
                        notify(res.type, res.message);
                        table.ajax.reload(null, false);  // Reload the table data without resetting pagination
                    } else {
                        notify(res.type, res.message);
                    }
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                    alert('Error occurred while deleting data. Please try again.');
                }
            });
        }
    });
  });
});


   $(document).on("click", ".edit-payment-log", function () {
 
    // Fetch values from data attributes
    let invoiceBatchNo = $(this).data("invoice") || "";
    let invoice_no_id = $(this).data("invoice_no_id") || "";
    let paymentDate = $(this).data("payment_date") || "";
    let payAmt = $(this).data("pay_amt") || "";
    let bankDetails = $(this).data("bank_details") || "";
    let remark = $(this).data("remark") || "";


    // Populate the modal fields
    $("#edit_invoice_batchno").val(invoiceBatchNo);
    $("#edit_invoice_no_id").val(invoice_no_id);
    $("#edit_payment_date").val(paymentDate);
    $("#edit_pay_amt").val(payAmt);
    $("#edit_bank_details").val(bankDetails);
    $("#edit_remark").val(remark);

    // Ensure Bootstrap modal is correctly initialized and shown
    /*let modal = new bootstrap.Modal(document.getElementById("editPaymentModal"));
    modal.show();*/
});



$(document).on("submit", "#editPaymentForm", function (e) {
    e.preventDefault(); // Prevent default form submission

    let formData = $(this).serialize(); // Serialize form data

    $.ajax({
        url: "<?= base_url('admin/update_payment_log') ?>", // Replace with actual controller name
        type: "POST",
        data: formData,
        dataType: "json",
        success: function (response) {
            if (response.status === "success") {
                alert("Payment log updated successfully!");
                $("#editPaymentModal").modal("hide"); // Close modal

                // Reload DataTable without full page refresh
                $('#invoiceTable').DataTable().ajax.reload(null, false);
            } else {
                alert("Error: " + response.message);
            }
        },
        error: function () {
            alert("An error occurred while updating payment.");
        },
    });
});



$(document).on('click', '.edit-invoice-date-btn', function () {
    let invoice = $(this).data('invoice');
    let currentDate = $(this).data('current-date');
    $('#invoice_batchno').val(invoice);
    $('#invoice_date').val(currentDate);
});
$('#invoiceDateForm').on('submit', function (e) {
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('admin/update_invoice_date') ?>',
        type: 'POST',
        data: $(this).serialize(),
        success: function (response) {
            let res = JSON.parse(response);
            if (res.success) {
                Swal.fire('Success', res.message, 'success');
                $('#editInvoiceDateModal').modal('hide');
                $('#invoiceTable').DataTable().ajax.reload(null, false);
            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});


$(document).on('click', '.edit-invoice-num-btn', function () {
     let invoice = $(this).data('invoice');
    let currentNum = $(this).data('current-num');

    $('#invoice_batchno_num').val(invoice);
    $('#invoice_num').val(currentNum);

    $('#editInvoiceNumModal').modal('show');
});
$('#invoiceNumForm').on('submit', function (e) {
    e.preventDefault();
    
      // 🔍 Log values to browser console
 //   console.log("invoice_batchno:", $('#invoice_batchno').val());
 //   console.log("invoice_num:", $('#invoice_num').val());
    
    $.ajax({
        url: '<?= base_url('admin/update_invoice_number') ?>',
        type: 'POST',
        data: $(this).serialize(),
        success: function (response) {
            let res = JSON.parse(response);
            if (res.success) {
                Swal.fire('Success', res.message, 'success');
                $('#editInvoiceNumModal').modal('hide');
                $('#invoiceTable').DataTable().ajax.reload(null, false);
            } else {
                Swal.fire('Error', res.message, 'error');
            }
        }
    });
});


// ✅ Handle "Check All" click (only current page rows)
/*$('#checkAll').on('change', function () {
    let isChecked = this.checked;
    $('#invoiceTable tbody input[name="partner_id[]"]').prop('checked', isChecked);
});

// ✅ Keep header checkbox in sync if a row is unchecked
$('#invoiceTable tbody').on('change', 'input[name="partner_id[]"]', function () {
    let all = $('#invoiceTable tbody input[name="partner_id[]"]').length;
    let checked = $('#invoiceTable tbody input[name="partner_id[]"]:checked').length;
    $('#checkAll').prop('checked', all > 0 && all === checked);
});*/


</script>

<script>
 function deleteApplicantMBInvoice(invoiceId, userId, applicantName) {
     if (confirm('Are you sure you want to delete this invoice for ' + applicantName + '?')) {
        console.log({ invoice_id: invoiceId, user_id: userId });
        $.ajax({
            url: '<?= base_url("admin/delete_invoice_mb_applicant") ?>',
            type: 'POST',
            dataType: 'json', // Specify the expected data type
            data: {
                invoice_id: invoiceId,
                user_id: userId
            },
            success: function(response) {
                console.log(response);
                if (response.success) {
                    alert(response.message || 'Invoices Applicant deleted successfully!');
                    table.ajax.reload(null, false);
                } else {
                    alert(response.message || 'Cannot delete: MB Payment status is Paid');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                alert('Error occurred while processing the request.');
            }
        });
    }
}


</script>


<style>
  .dataTables_length {
      margin-bottom: 13px;
  }
  .dataTables_filter {
      margin-top: 12px;
  }


  .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

  

</style>

