<main class="page-content">
    <div class="card">
        <div class="card-body">
            <form id="filterForm" method="POST">
                <div class="row">
                    <div class="col-md-3">
                        <label for="year">Financial Year:</label>
                        <select class="form-control" name="year" id="year">
                            <?php
                            $currentYear = date('Y');
                            $currentMonth = date('n');
                            $startYear = ($currentMonth < 4) ? $currentYear - 1 : $currentYear;
                            for ($i = $startYear; $i >= ($startYear - 1); $i--) {
                                $financialYear = $i . '-' . ($i + 1);
                                echo "<option value=\"$i\">$financialYear</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="connector">Partner:</label>
                        <select class="single-select" id="connector" name="connector">
                            <option value="">Select Partner</option>
                            <?php foreach ($connector as $connectorItem): ?>
                                <option value="<?= $connectorItem['staff_id']; ?>"><?= $connectorItem['staff_fullname']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3 mt-3">
                        <button type="submit" class="btn btn-primary">Filter</button>
                        <button type="reset" class="btn btn-secondary">Reset</button>
                    </div>
                </div>
            </form>
            <hr class="mt-3">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="Table" class="table table-striped table-bordered">
                        <thead id="table-header"></thead>
                        <tbody></tbody>
                        <tfoot id="table-footer"></tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    const months = ['apr','may','jun','jul','aug','sep','oct','nov','dec','jan','feb','mar'];

    function generateTableHeaders(year) {
        let header = `<tr>
            <th>Sr.No.</th>
            <th>Partner Name</th>
            <th>City</th>
            <th>Login Case Total Amt</th>`;
        months.forEach((m, i) => {
            const y = (i < 9) ? year : parseInt(year) + 1;
            const display = m.charAt(0).toUpperCase() + m.slice(1);
            header += `<th>${display}-${y.toString().slice(-2)}</th>`;
        });
        header += `<th>Total</th></tr>`;
        document.getElementById('table-header').innerHTML = header;

        let footer = `<tr>
            <th>Total</th><th></th><th></th>
            <th id="total_login_case_total"></th>`;
        months.forEach((m, i) => {
            const y = (i < 9) ? year : parseInt(year) + 1;
            footer += `<th id="footer_${m}_${y}">0</th>`;
        });
        footer += `<th id="footer_total">0</th></tr>`;
        document.getElementById('table-footer').innerHTML = footer;
    }

    function getColumns(year) {
        const columns = [
            { data: "sr_no" },
            { data: "connector_name" },
            { data: "city_name" },
            { data: "login_case_total" }
        ];
        months.forEach((m, i) => {
            const y = (i < 9) ? year : parseInt(year) + 1;
            columns.push({ data: `${m}_${y}` });
        });
        columns.push({ data: "total" });
        return columns;
    }

    function updateFooterTotals(totals, year) {
        $('#total_login_case_total').text(totals.login_case_total);
        let sum = 0;
        months.forEach((m, i) => {
            const y = (i < 9) ? year : parseInt(year) + 1;
            const val = totals[m] || 0;
            $(`#footer_${m}_${y}`).text(val);
            sum += parseFloat(val);
        });
        $('#footer_total').text(sum);
    }

    let table;

    $(document).ready(function () {
        const selectedYear = $('#year').val();
        generateTableHeaders(selectedYear);

        table = $('#Table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?= base_url('admin/fetch_partner_business'); ?>",
                type: "POST",
                data: function (d) {
                    d.year = $('#year').val();
                    d.connector = $('#connector').val();
                },
                dataSrc: function (json) {
                    updateFooterTotals(json.totals, $('#year').val());
                    return json.data;
                }
            },
            columns: getColumns(selectedYear),
            lengthChange: true,
            lengthMenu: [[200, 400, 500, 700, -1], [200, 400, 500, 700, "All"]],
            pageLength: -1,
            order: [[2, 'asc']],
            dom: 'lBfrtip',
            buttons: [
                { extend: 'copy', text: 'Copy' },
                { extend: 'excel', text: 'Excel' },
                { extend: 'pdf', text: 'PDF' },
                { extend: 'print', text: 'Print' }
            ]
        });

        $('#filterForm').on('submit', function (e) {
            e.preventDefault();
            const year = $('#year').val();
            generateTableHeaders(year);
            table.clear().destroy();
            table = $('#Table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?= base_url('admin/fetch_partner_business'); ?>",
                    type: "POST",
                    data: function (d) {
                        d.year = $('#year').val();
                        d.connector = $('#connector').val();
                    },
                    dataSrc: function (json) {
                        updateFooterTotals(json.totals, $('#year').val());
                        return json.data;
                    }
                },
                columns: getColumns(year),
                lengthChange: true,
                lengthMenu: [[200, 400, 500, 700, -1], [200, 400, 500, 700, "All"]],
                pageLength: -1,
                order: [[2, 'asc']],
                dom: 'lBfrtip',
                buttons: [
                    { extend: 'copy', text: 'Copy' },
                    { extend: 'excel', text: 'Excel' },
                    { extend: 'pdf', text: 'PDF' },
                    { extend: 'print', text: 'Print' }
                ]
            });
        });

        $('#filterForm').on('reset', function (e) {
            e.preventDefault();
            const currentMonth = new Date().getMonth() + 1;
            const fy = currentMonth < 4 ? new Date().getFullYear() - 1 : new Date().getFullYear();
            $('#year').val(fy);
            $('#connector').val('');
            $('#filterForm').submit(); // Trigger filter
        });
    });
</script>

<style>
    .dataTables_length { margin-bottom: 13px; }
    .dataTables_filter { margin-top: 12px; }
</style>
