<main class="page-content">
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="breadcrumb-title pe-3"><?= $title ?></div>
    </div>
    <div class="card">
        <div class="card-header py-3">
            <div class="row align-items-center m-0">
                <div class="col-md-4 col-12 me-auto mb-md-0 mb-3">
                    <a href="<?= base_url('admin/connectors_form/') ?>">
                        <button type="button" class="btn btn-outline-primary radius-30">Add Partner</button>
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            
              <form id="filterForm" method="post">
    <div class="row g-2">
        <div class="col-md-2">
            <label for="start_date">Start Date:</label>
            <input class="form-control" type="date" id="start_date" name="start_date" value="<?php echo set_value('start_date'); ?>">
        </div>

        <div class="col-md-2">
            <label for="end_date">End Date:</label>
            <input class="form-control" type="date" id="end_date" name="end_date" value="<?php echo set_value('end_date'); ?>">
        </div>
        
           <div class="col-md-2 mb-3">
                <label for="state_id">State</label>
                <select name="state_id" id="state_id" class="single-select">
                    <option value="">-Select-</option>
                    <?php foreach ($state as $value) { ?>
                        <option value="<?= $value['id']; ?>" <?php echo isset($_POST['state_id']) && $_POST['state_id'] === $value['id'] ? 'selected' : ''; ?>><?= $value['state_name']; ?></option>
                    <?php } ?>
                </select>
            </div>

            <div class="col-md-2 mb-3">
                <label for="city_id">City</label>
                <select name="city_id" id="city_id" class="single-select">
                    <option value="">-Select-</option>
                </select>
            </div>

        <div class="col-md-2">
            <label for="sales_coordinator">Sales Coordinator</label>
            <select class="form-select" id="sales_coordinator" name="sales_coordinator">
                <option value="">-Select-</option>
                <?php foreach($SalesCo as $s): ?>
                    <option value="<?php echo $s['staff_id']; ?>"><?php echo $s['staff_fullname']; ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label for="area_sales_mgr">Area Sales Manager</label>
            <select class="form-select" id="area_sales_mgr" name="area_sales_mgr">
                <option value="">-Select-</option>
                <?php foreach($ASM as $s): ?>
                    <option value="<?php echo $s['staff_id']; ?>"><?php echo $s['staff_fullname']; ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label for="sales_director">Sales Director</label>
            <select class="form-select" id="sales_director" name="sales_director">
                <option value="">-Select-</option>
                <?php foreach($sales_director_mgr as $s): ?>
                    <option value="<?php echo $s['staff_id']; ?>"><?php echo $s['staff_fullname']; ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-2 mb-2">
            <label for="sales_aggr">Sales Aggregator</label>
            <select class="form-select" id="sales_aggr" name="sales_aggr">
                <option value="">-Select-</option>
                <?php foreach($aggr as $s): ?>
                    <option value="<?php echo $s['staff_id']; ?>"><?php echo $s['staff_fullname']; ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-3 mb-3 align-self-end">
            <button type="button" class="btn btn-success" id="filterSubmit">Filter</button>
            <button type="button" class="btn btn-info" id="resetButton">Reset</button>
        </div>
    </div>
</form>

            
            <div class="table-responsive">
                <table class="table align-middle table-striped" id="Table" width="100%">
                    <thead>
                        <tr>
                            <th>Sr.No</th>
                            <th>Partner Code</th>
                            <th>Full Name</th>
                            <th>Payout %</th>
                            <th>DOB</th>
                            <th>Mobile</th>
                            <th>Email</th>
                            <th>Pan Number</th>
                            <th>Pan Card</th>
                            <th>Adhar Card</th>
                            <th>GST Certificate</th>
                            <th>Cancelled Cheque</th>
                            <th>Agreement Copy</th>
                            <th>Sales Coordinator</th>
                            <th>Area Sales Manager</th>
                            <th>Sales Director</th>
                            <th>Sales Aggregator</th>
                            <th>State</th>
                            <th>City</th>
                            <th>Remark</th>
                            <th>Created By</th>
                            <th>Modified By</th>
                            <th>Created Date</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<script>
$(document).ready(function() {
    var staffId = <?php echo $_SESSION['staff_id']; ?>;
    var columns = [
        { "data": 0 },
        { "data": 1 },
        { "data": 2 },
        { "data": 3, "visible": (staffId == 1 || staffId == 14) },
        { "data": 4, "visible": (staffId == 13  || staffId == 14) },
        { "data": 5, "visible": (staffId == 1  || staffId == 14) },
        { "data": 6, "visible": ( staffId == 1 || staffId == 13 || staffId == 14) },
        { "data": 7, "visible": (staffId == 1 || staffId == 13 || staffId == 14) },
        { "data": 8, "visible": (staffId == 1 || staffId == 13 || staffId == 14) },
        { "data": 9, "visible": (staffId == 13 || staffId == 14) },
        { "data": 10, "visible": (staffId == 13 || staffId == 14) },
        { "data": 11, "visible": (staffId == 13 || staffId == 14) },
        { "data": 12 },
        { "data": 13 },
        { "data": 14 },
        { "data": 15 },
        { "data": 16 },
        { "data": 17 },
        { "data": 18 },
        { "data": 19, "visible": (staffId == 1) },
        { "data": 20 },
        { "data": 21 },
        { "data": 22 },
        { "data": 23, "visible": (staffId == 14) },
        { "data": 24 }
    ];

    var buttons = [];

    if (staffId == 13 || staffId == 14 || staffId == 1) {
        buttons.push({ extend: 'excel', text: 'Excel' });
    }

    var table = $('#Table').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?= base_url('admin/fetch_connectors') ?>",
            "type": "POST",
             "data": function(d) {
            d.start_date         = $('#start_date').val();    // ✅ date filter
            d.end_date           = $('#end_date').val();      // ✅ date filter
            d.sales_coordinator  = $('#sales_coordinator').val();
            d.area_sales_mgr     = $('#area_sales_mgr').val();
            d.sales_director     = $('#sales_director').val();
            d.sales_aggr         = $('#sales_aggr').val();
            d.state_id            = $('#state_id').val();
            d.city_id          = $('#city_id').val();

    // If you use CI CSRF, uncomment and adjust:
    // d['<?php echo $this->security->get_csrf_token_name(); ?>'] = '<?php echo $this->security->get_csrf_hash(); ?>';
}

        },
        "pageLength": 200,
        "columns": columns,
        "lengthChange": true,
        "lengthMenu": [[200, 100, 200, 500, -1], [200, 100, 200, 500, "All"]],
        "dom": 'lBfrtip',
        "scrollX": true,
        /*"fixedColumns": {
          leftColumns: 0,
          rightColumns: 2,
        },*/
        "buttons": buttons,
         "drawCallback": function(settings) {
     
      // Adjust the height of the fixed columns to match the scrollable columns
      setTimeout(function() {
        var scrollBodyHeight = $('.dataTables_scrollBody').height();
        $('.DTFC_LeftBodyWrapper').height(scrollBodyHeight);
        $('.DTFC_RightBodyWrapper').height(scrollBodyHeight);

        // Adjust the row heights to match
        $('#Table tbody tr').each(function(index) {
          var rowHeight = $(this).height();
          $('.DTFC_LeftBodyWrapper tbody tr').eq(index).height(rowHeight);
          $('.DTFC_RightBodyWrapper tbody tr').eq(index).height(rowHeight);
        });
      }, 10);
      
        
     }
    });
    
     $('#filterSubmit').on('click', function() {
        $('#Table').DataTable().ajax.reload(); // ✅ Reload the table
    });
    
    // Add class="filter-select" to all your filter selects in the form
// <select class="form-select filter-select" id="sales_coordinator" ...>

// Reset button handler (clears selects by class)
$('#resetButton').on('click', function(e) {
    e.preventDefault();

    // 1) Reset normal form controls (dates, text inputs)
    if (document.querySelector('#filterForm')) {
        $('#filterForm')[0].reset();
    }

    // 2) Clear all selects that have the class .filter-select
    $('.filter-select').each(function() {
        var $el = $(this);

        // If Select2 initialized on this element
        if ($el.hasClass('select2-hidden-accessible')) {
            $el.val(null).trigger('change'); // Select2 clear
            return;
        }

        // If bootstrap-select / selectpicker is used
        if ($el.hasClass('selectpicker')) {
            $el.val('');               // clear value
            $el.selectpicker('refresh'); // refresh UI
            return;
        }

        // Default plain select
        $el.val('');
        $el.trigger('change'); // trigger change for any listeners
    });

    // 3) Clear DataTables search & reload table
    var tbl = $('#Table').DataTable();
    // Clear global and column searches then redraw (this will trigger ajax)
    tbl.search('').columns().search('').draw();
});



    table.buttons().container().appendTo('#Table_wrapper .col-md-6:eq(0)');
    
    
    
    $('#state_id').change(function() {
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('Admin/get_cities') ?>',
                type: 'POST',
                data: { state_id: stateId },
                dataType: 'json',
                success: function(data) {
                    $('#city_id').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#city_id').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#city_id').empty().append('<option value="">-Select-</option>');
        }
    });

    $('#state_id').trigger('change');
    
     $('.dataTables_scrollBody').on('scroll', function() {
    var $scrollBody = $(this);
    var $fixedColumnsRight = $('.DTFC_RightBodyWrapper');
    var scrollLeft = $scrollBody.scrollLeft();
    var scrollWidth = $scrollBody[0].scrollWidth;
    var clientWidth = $scrollBody[0].clientWidth;
    
    var isScrolledToEnd = scrollLeft + clientWidth >= scrollWidth - 1; // -1 to account for rounding issues
    
    if (isScrolledToEnd) {
        $fixedColumnsRight.hide();
    } else {
        $fixedColumnsRight.show();
    }
  });

$(document).on('change', '.commoon_active_partner', function () {
    var element = $(this);
    var nextStatus = element.val(); // Get the selected status
    var id = element.data('id');
    var action = element.attr('action');

    $.ajax({
        type: 'POST',
        url: base_url + 'Admin/' + action + '/' + id + '/' + nextStatus,
    }).done(function (response) {
        var res = $.parseJSON(response);
        if (res.success === '1') {
            notify(res.type, res.message);

            // Optionally, you can update the select element styling based on the status.
            element.removeClass('bg-success bg-danger bg-warning');
            if (nextStatus === '1') {
                element.addClass('bg-success');
            } else if (nextStatus === '0') {
                element.addClass('bg-danger');
            } else if (nextStatus === '3') {
                element.addClass('bg-warning');
            }
        } else {
            notify(res.type, res.message);
        }
    }).fail(function () {
        alert("error");
    });
});

});


</script>





<style>
    .dataTables_length{
        margin-bottom:13px;
    }
    .dataTables_filter{
        margin-top:12px;
    }
    
    
  .DTFC_RightBodyWrapper table,
  .DTFC_LeftBodyWrapper table {
      width: 100% !important;
  }

  .dataTables_scrollBody {
      overflow: auto;
  }

  .DTFC_LeftBodyLiner,
  .DTFC_RightBodyLiner {
      overflow: hidden !important;
  }

  .DTFC_LeftBodyWrapper,
  .DTFC_RightBodyWrapper {
      top: 0 !important;
  }

  .DTFC_RightBodyWrapper {
      right: 0 !important;
  }

  .DTFC_RightBodyLiner {
      overflow: hidden;
      position: absolute;
      right: 0;
      top: -11px !important;
      background-color: white !important;
  }

  .DTFC_LeftBodyLiner {
      overflow: hidden;
      position: absolute;
      left: 0;
  }

  .dataTables_scrollHeadInner, .dataTables_scrollHead, .dataTables_scrollBody {
      margin-bottom: 0 !important;
  }

  .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody {
      background: white;
  }


  table.dataTable tr:nth-child(even) {
      background-color: #ffff;
  }

  table.dataTable tr:nth-child(odd) {
      background-color: #ffffff;
  }

  
</style>

