<main class="page-content">

    <!--breadcrumb-->

    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">

        <div class="breadcrumb-title pe-3"><?= $title ?></div>

    </div>

    <!--end breadcrumb-->

    <div class="row">

        <div class="col-xl-12 mx-auto">

            <div class="card">

                <div class="card-body">

                    <form id="forms" method="post" action="<?= base_url('admin/submit_branch') ?>">
                    <input type="hidden" name="id" value="<?= (isset($branch)) ? $branch->id : '' ?>">
                        <div class="row">
                            
                             <div class="col-md-3 mb-3">
                            <label class="form-label">State</label>
                            <select name="state_id" class="single-select" id="stateSelect" required>
                                <option value="">-Select-</option>
                               <?php  foreach ($state as  $value) { ?>
                                   <option value="<?= $value['id']; ?>" <?php if(@$value['id']==@$branch->state_id) echo 'selected';?>><?=$value['state_name'];?></option>
                              <?php } ?>                           
                            </select>                               
                            <span class="error"></span>
                        </div> 
                      
                        <div class="col-md-3 mb-3">
                            <label class="form-label">City</label>
                            <select name="city_id" class="single-select" id="citySelect" required>
                                <option value="">-Select-</option>
                            </select>
                            <span class="error"></span>
                        </div> 
                        
                        <div class="col-md-3 mb-3">
                            <label class="form-label">RBO</label>
                            <select name="rbo_id" class="single-select" id="rboSelect">
                                <option value="">-Select-</option>
                            </select>
                            <span class="error"></span>
                        </div> 
                        
                        <div class="col-md-3 mb-3">
                            <label class="form-label">RACPC</label>
                            <select name="racpc_id" class="single-select" id="racpcSelect">
                                <option value="">-Select-</option>
                            </select>
                            <span class="error"></span>
                        </div> 
                     
                             <div class="col-md-3 mb-3">
                                        <label class="form-label">Circle</label>
                                        <select id="circleSelect" name="circle_id" class="form-control" required>
                                            <option value="">-Select-</option>
                                            <?php foreach($circle as $val) { ?>
                                                <option value="<?= $val['id']; ?>" <?php if(@$branch->circle_id==$val['id']) echo 'selected';?>><?= $val['c_name']; ?>(<?= $val['c_code']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    <span class="error"></span>
                                </div>
                                
                          
                                
                            <div class="mb-3 col-md-3">

                                <label class="form-label">Branch Name</label>

                                <input type="text" class="form-control inputs" placeholder="Enter Branch Name" 

                                       name="branch_name" required value="<?= (isset($branch)) ? $branch->branch_name : '' ?>">

                                <span class="error"></span>

                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">Branch Code</label>
                                <input type="number" class="form-control inputs" placeholder="Enter Branch Code" 
                                       name="branch_code" required value="<?= (isset($branch)) ? $branch->branch_code : '' ?>"  id="branchCode">
                                <span class="error"></span>
                            </div>
                           <!-- <div class="mb-3 col-md-3">
                                <label class="form-label">RBO</label>
                                <input type="text" class="form-control inputs" placeholder="Enter RBO" 
                                       name="rbo" value="<?= (isset($branch)) ? $branch->rbo : '' ?>">
                                <span class="error"></span>
                            </div>
                            <div class="mb-3 col-md-3">
                                <label class="form-label">RACPC</label>
                                <input type="text" class="form-control inputs" placeholder="Enter RACPC" 
                                       name="racpc"  value="<?= (isset($branch)) ? $branch->racpc : '' ?>">
                                <span class="error"></span>
                            </div>-->
                            <div class="mb-3 col-md-4">
                                <label class="form-label">Branch Address</label>
                                <textarea type="text" class="form-control inputs" placeholder="Branch Address" 
                                          name="branch_address"><?= (isset($branch)) ? $branch->branch_address : '' ?></textarea>
                                <span class="error"></span>
                            </div>

                           

                     
                            <div class="mb-3">
                              <button class="btn-back-white" onclick="go_back()">Back</button>
                                <input type="submit" class="btn-submit">
                            </div>

                    </form>

                </div>

            </div>

        </div>



    </div>

</div>

<!--end row-->

</main>

<script>
$(document).ready(function(){
    $('#stateSelect').change(function(){
        var stateId = $(this).val();
        if(stateId !== '') {
            $.ajax({
                url: '<?= base_url('admin/get_cities') ?>',
                type: 'POST',
                data: {state_id: stateId},
                dataType: 'json',
                success: function(data) {
                    $('#citySelect').empty().append('<option value="">-Select-</option>');
                    $.each(data, function(key, value) {
                        $('#citySelect').append('<option value="' + value.id + '">' + value.city_name + '</option>');
                    });

                    // Get the customer's city ID
                    var customerCityId = <?= (isset($branch) && $branch->city_id !== null) ? $branch->city_id : 'null' ?>;
                    
                    // Set the selected city in the dropdown
                    if (customerCityId !== null) {
                        $('#citySelect').val(customerCityId);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        } else {
            $('#citySelect').empty().append('<option value="">-Select-</option>');
        }
    });

    // Trigger change event on page load if state is already selected
    $('#stateSelect').trigger('change');
    $('#citySelect').trigger('change');

    // Check if user is editing profile and city ID is null
    var isEditing = <?= (isset($branch) && $branch->id) ? 'true' : 'false' ?>;
    var cityId = <?= (isset($branch) && $branch->city_id !== null) ? $branch->city_id : 'null' ?>;

    if (isEditing && cityId === null) {
        // Display cities state-wise
        $('#stateSelect').trigger('change');
        $('#citySelect').trigger('change');
    }
    
    
     // Validate and format branch code on form submission
    $('#forms').submit(function(event) {
        var branchCodeInput = $('#branchCode');
        var branchCode = branchCodeInput.val();
        
        if (branchCode.length < 5) {
            branchCode = branchCode.padStart(5, '0');
            branchCodeInput.val(branchCode);
        }
        
        if (branchCode.length !== 5) {
            branchCodeInput[0].setCustomValidity('Five digit code is mandatory, please PREFIX "ZERO" if code is not five digit. For eg write "05555" for branch code "5555"');
        } else {
            branchCodeInput[0].setCustomValidity('');
        }
    });

    // Clear custom validity message on input
    $('#branchCode').on('input', function() {
        this.setCustomValidity('');
    });
    
});



// Fetch RBOs and RACPCs based on selected city
$('#citySelect').change(function(){
    
     var selectedCityId = <?= (isset($branch) && $branch->city_id !== null) ? $branch->city_id : 'null' ?>;
    if (selectedCityId !== null) {
        var cityId = selectedCityId;
    }else{
         var cityId = $(this).val();
    }
    if(cityId !== '') {
        $.ajax({
            url: '<?= base_url('admin/get_rbo_racpc') ?>',
            type: 'POST',
            data: {city_id: cityId},
            dataType: 'json',
            success: function(data) {
                $('#rboSelect').empty().append('<option value="">-Select-</option>');
                $('#racpcSelect').empty().append('<option value="">-Select-</option>');

                // Populate RBO options
                $.each(data.rbo, function(key, value) {
                    $('#rboSelect').append('<option value="' + value.id + '">' + value.rbo_name + '</option>');
                });

                // Populate RACPC options
                $.each(data.racpc, function(key, value) {
                    $('#racpcSelect').append('<option value="' + value.id + '">' + value.racpc_name + '</option>');
                });

                // Set selected RBO and RACPC if editing
                var selectedRboId = <?= (isset($branch) && $branch->rbo_id !== null) ? $branch->rbo_id : 'null' ?>;
                var selectedRacpcId = <?= (isset($branch) && $branch->racpc_id !== null) ? $branch->racpc_id : 'null' ?>;
                if (selectedRboId !== null) {
                    $('#rboSelect').val(selectedRboId);
                }
                if (selectedRacpcId !== null) {
                    $('#racpcSelect').val(selectedRacpcId);
                }
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText);
            }
        });
    } else {
        // Reset dropdowns if city is not selected
        $('#rboSelect').empty().append('<option value="">-Select-</option>');
        $('#racpcSelect').empty().append('<option value="">-Select-</option>');
    }
});




</script>