<?php

class Allnon_model extends CI_Model {

    public function __construct() {
        parent::__construct();
       
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        date_default_timezone_set('Asia/Kolkata');
    }

    /**
     * Apply all filters in one place
     */
    private function apply_filters($filters) {
        if (!empty($filters['start_date']) && !empty($filters['end_date'])) {
            $this->db->where("mst_user.add_date >=", $filters['start_date']);
            $this->db->where("mst_user.add_date <=", date('Y-m-d', strtotime($filters['end_date'] . ' +1 day')));
        }

        if (!empty($filters['status'])) {
            $this->db->where('mst_user.status', $filters['status']);
        }

        if (!empty($filters['conn_id'])) {
            $this->db->where('mst_user.connector_id', $filters['conn_id']);
        }

        if (!empty($filters['branch_id'])) {
            $this->db->where('mst_user.branch_id', $filters['branch_id']);
        }

        if (!empty($filters['applicant_invoice_status'])) {
            $this->db->where('mst_user.applicant_invoice_status IS NULL', null, false);
        }

     
        if (!empty($filters['hlc_invoice_status'])) {
            $this->db->where('mst_user.applicant_invoice_status', $filters['hlc_invoice_status']);
        }

        if (!empty($filters['city_id'])) {
            $this->db->where_in('branch.city_id', $filters['city_id']);
        }

        // HLC paid status (supports 'unpaid')
        if (!empty($filters['hlc_status'])) {
            $this->db->group_start();
            if (is_array($filters['hlc_status']) && in_array('unpaid', $filters['hlc_status'])) {
                $this->db->or_where('mst_user.hlc_payment_status IS NULL', null, false);
                $this->db->where('mst_user.disb_status', 'yes');
            }
            $other = is_array($filters['hlc_status']) ? array_diff($filters['hlc_status'], ['unpaid']) : [];
            if (!empty($other)) {
                $this->db->or_where_in('mst_user.hlc_payment_status', $other);
            }
            $this->db->group_end();
        }

   

        if (!empty($filters['disb_month_year'])) {
            list($year, $month) = explode('-', $filters['disb_month_year']);
            $this->db->where('MONTH(mst_user.disb_date)', $month);
            $this->db->where('YEAR(mst_user.disb_date)', $year);
        }

    
        if (isset($filters['partner_generated'])) {
            if ($filters['partner_generated'] === 'No') {
                $this->db->where('mst_user.applicant_invoice_status IS NULL', null, false);
            } elseif ($filters['partner_generated'] === 'Yes') {
                $this->db->where('mst_user.applicant_invoice_status', 'Generated');
            }
        }


        // Search block
        if (!empty($filters['search'])) {
            $this->db->group_start();
            $this->db->like('mst_user.user_name', $filters['search']);
            $this->db->or_like('mst_user.los_id', $filters['search']);
            $this->db->or_like('mst_user.bank_acct_no', $filters['search']);
            $this->db->or_like('mst_user.user_phone', $filters['search']);
            $this->db->or_like('mst_user.user_email', $filters['search']);
            $this->db->or_like('mst_user.user_address', $filters['search']);
            $this->db->or_like('mst_user.applicant_rr_id', $filters['search']);
            $this->db->or_like('mst_user.rr_cbs_acct_no', $filters['search']);
            $this->db->or_like('mst_user.sanction_amt', $filters['search']);
            $this->db->or_like('mst_user.status', $filters['search']);
            $this->db->or_like('mst_user.disb_status', $filters['search']);
            $this->db->or_like('mst_user.hlc_payment_status', $filters['search']);
          //  $this->db->or_like('mst_user.sbi_payment_status', $filters['search']);
            $this->db->or_like('mst_user.login_code', $filters['search']);
            $this->db->or_like('branch.branch_name', $filters['search']);
            $this->db->or_like('branch.branch_code', $filters['search']);
            $this->db->or_like('mst_city.city_name', $filters['search']);
            $this->db->or_like('mst_rbo.rbo_name', $filters['search']);
            $this->db->or_like('mst_loan_type.name', $filters['search']);
            $this->db->or_like('mst_staff.staff_fullname', $filters['search']);
            $this->db->or_like('mst_staff.hlc_code', $filters['search']);
            $this->db->group_end();
        }

        // Staff restriction
        $staff_type = $this->session->userdata('staff_type');
        if ($staff_type == 1) {
            $this->db->where('mst_user.connector_id', $this->session->userdata('staff_id'));
        }
    }

    public function get_applicant_data(array $filters = []) {
        $limit  = isset($filters['limit']) ? $filters['limit'] : -1;
        $offset = $filters['offset'] ?? '';
    
         $this->db->select('
            mst_user.*, 
            mst_staff.staff_fullname, 
            mst_loan_type.name as user_type, 
            branch.branch_name, 
            branch.branch_code, 
            mst_city.city_name, 
            mst_rbo.rbo_name
        ');
        $this->db->from('mst_user');
        $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
        $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
        $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
        $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
        $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');
    
        $this->db->where('mst_user.is_archive', 'No');
        $this->db->where('mst_user.is_verify', 0);
    
        // ✅ Do NOT filter login_code here (All means everything)
    
        $this->apply_filters($filters);
    
        if (!empty($filters['limit']) && $filters['limit'] != -1) {
            if (!empty($filters['offset'])) {
                $this->db->limit($filters['limit'], $filters['offset']);
            } else {
                $this->db->limit($filters['limit']);
            }
        }
    
       
        // ✅ Apply PB / MB / All filters
        if (!empty($filters['pb_only'])) {
            $this->db->where('mst_user.login_code', 'PaisaBazaar');
        } elseif (!empty($filters['mb_only'])) {
            $this->db->where('mst_user.login_code !=', 'PaisaBazaar');
        }
    
        // ✅ Apply common filters
        $this->apply_filters($filters);
    
        // ✅ Limit + offset
        if ($limit != -1) {
            if ($limit !== '' && $offset !== '') {
                $this->db->limit($limit, $offset);
            } elseif ($limit !== '') {
                $this->db->limit($limit);
            }
        }
    
        $this->db->order_by('mst_user.add_date', 'desc');
        return $this->db->get()->result_array();
}


public function count_applicant_data(array $filters = []) {
    $this->db->select('COUNT(*) as total');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');

    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.is_verify', 0);

    // ✅ Apply PB / MB / All filters
    if (!empty($filters['pb_only'])) {
        $this->db->where('mst_user.login_code', 'PaisaBazaar');
    } elseif (!empty($filters['mb_only'])) {
        $this->db->where('mst_user.login_code !=', 'PaisaBazaar');
    }

    $this->apply_filters($filters);

    return (int) $this->db->get()->row()->total;
}


public function get_all_applicant_data($filters) {
    $this->db->select('
        mst_user.*, 
        mst_staff.staff_fullname, 
        mst_loan_type.name as user_type, 
        branch.branch_name, 
        branch.branch_code, 
        mst_city.city_name, 
        mst_rbo.rbo_name
    ');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');

    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.is_verify', 0);

    // ✅ Do NOT filter login_code here (All means everything)

    $this->apply_filters($filters);

    if (!empty($filters['limit']) && $filters['limit'] != -1) {
        if (!empty($filters['offset'])) {
            $this->db->limit($filters['limit'], $filters['offset']);
        } else {
            $this->db->limit($filters['limit']);
        }
    }

    $this->db->order_by('mst_user.add_date', 'desc');
    return $this->db->get()->result_array();
}


public function count_all_applicant_data($filters) {
    $this->db->select('COUNT(*) as total');
    $this->db->from('mst_user');
    $this->db->join('mst_staff', 'mst_user.connector_id = mst_staff.staff_id');
    $this->db->join('mst_loan_type', 'mst_user.loan_type_id = mst_loan_type.id');
    $this->db->join('branch', 'mst_user.branch_id = branch.id', 'left');
    $this->db->join('mst_city', 'branch.city_id = mst_city.id', 'left');
    $this->db->join('mst_rbo', 'branch.rbo_id = mst_rbo.id', 'left');

    $this->db->where('mst_user.is_archive', 'No');
    $this->db->where('mst_user.is_verify', 0);

    // ✅ Do NOT filter login_code here (All means everything)

    $this->apply_filters($filters);

    return (int) $this->db->get()->row()->total;
}

}
