<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Include the Composer autoloader
require_once FCPATH . 'vendor_new/autoload.php';

// Import PhpSpreadsheet classes
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Rbo_excel extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $db_group = $this->session->userdata('db_group') ?? 'default';
        $this->db = $this->load->database($db_group, TRUE);
        $this->load->model('common_model', 'ccm'); // Load your model
    }

    public function export_excel_rbo_invoice_list($inv_batch) {
    // Fetch data
    $invoices = $this->ccm->get_invoice_rbo_list($inv_batch);
    $first_invoice_no = $this->db->select("invoice_number,is_tenper_hold")->from('invoices')->where(['inv_batchno' => $inv_batch])->get()->row();
    $is_tenper_hold = $first_invoice_no->is_tenper_hold;

    // Group and process data
    $grouped_invoices = [];
    foreach ($invoices as $invoice) {
        $loan_amount = ($invoice['loan_type_id'] == 5) ? $invoice['rinnraksha_amt'] : $invoice['sanction_amt'];
        $commission_rate = floatval($invoice['sbi_commi']) / 100;
                if ($invoice['loan_type_id'] == 4 && $loan_amount >= 100000 && $loan_amount < 1000000) {
             
            $amt_100 = 2000; // Fixed amount
        } else {
            $amt_100 = $loan_amount * $commission_rate; // Calculate commission rate
        }
        $amt_0_90 = $amt_100 * 0.90;
        $amt_0_10 = ($is_tenper_hold == 'Yes') ? $amt_100 * 0.10 : 0;
        $gst_amt = $amt_0_90 * 0.18; // Assuming GST is 18%
        $total_amt = $amt_0_90 + $gst_amt;

        if (!isset($grouped_invoices[$invoice['branch_cnf']])) {
            $grouped_invoices[$invoice['branch_cnf']] = [
                'invoices' => [],
                'totals' => [
                    '100_amt' => 0,
                    '0_90_amt' => 0,
                    '0_10_amt' => 0,
                    'gst_amt' => 0,
                    'total_amt' => 0,
                ]
            ];
        }

        // Add the current invoice data
        $grouped_invoices[$invoice['branch_cnf']]['invoices'][] = array_merge($invoice, [
            'loan_amount' => $loan_amount,
            '100_amt' => $amt_100,
            '0_90_amt' => $amt_0_90,
            '0_10_amt' => $amt_0_10,
            'gst_amt' => $gst_amt,
            'total_amt' => $total_amt,
        ]);

        // Accumulate totals
        $grouped_invoices[$invoice['branch_cnf']]['totals']['100_amt'] += $amt_100;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['0_90_amt'] += $amt_0_90;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['0_10_amt'] += $amt_0_10;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['gst_amt'] += $gst_amt;
        $grouped_invoices[$invoice['branch_cnf']]['totals']['total_amt'] += $total_amt;

        // Check for RinnRaksha and add RR Commission logic
        if ($invoice['loan_type_id'] == 5) {
            $rr_commission = 0;
            $rr_main_account = $this->db->select("*")->where(['applicant_rr_id' => $invoice['user_id'], 'rinnraksha_status' => 'Yes'])->from('mst_user')->get()->row();
            if ($rr_main_account->sanction_amt < 5000000) {
                $rr_commission = 4000;
            } elseif ($rr_main_account->sanction_amt >= 5000000 && $rr_main_account->sanction_amt < 10000000) {
                $rr_commission = 5000;
            } elseif ($rr_main_account->sanction_amt >= 10000000) {
                $rr_commission = 6000;
            }

            // 90% and 10% calculations for RR Commission
            $rr_commission_90 = $rr_commission * 0.90;
            $rr_commission_10 = ($is_tenper_hold == 'Yes') ? $rr_commission * 0.10 : 0;
            $rr_gst_amt = $rr_commission_90 * 0.18; // Assuming GST is 18%
            $rr_total_amt = $rr_commission_90 + $rr_gst_amt;

            // Add RR Commission to totals
            $grouped_invoices[$invoice['branch_cnf']]['totals']['100_amt'] += $rr_commission;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['0_90_amt'] += $rr_commission_90;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['0_10_amt'] += $rr_commission_10;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['gst_amt'] += $rr_gst_amt;
            $grouped_invoices[$invoice['branch_cnf']]['totals']['total_amt'] += $rr_total_amt;

            // Add RR Commission row to invoices
            $grouped_invoices[$invoice['branch_cnf']]['invoices'][] = [
                'is_rr_commission' => true,
                'branch_name' => $invoice['branch_name'],
                'branch_cnf' => $invoice['branch_cnf'],
                'los_id' => $invoice['los_id'],
                'rr_cbs_acct_no' => $invoice['rr_cbs_acct_no'],
                'user_name' => $invoice['user_name'],
                'disb_date' => $invoice['disb_date'],
                'invoice_date' => $invoice['invoice_date'],
                'commission' => $rr_commission,
                'commission_90' => $rr_commission_90,
                'commission_10' => $rr_commission_10,
                'gst_amt' => $rr_gst_amt,
                'total_amt' => $rr_total_amt
            ];
        }
    }

    // Create a new spreadsheet instance
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Set table header
    $headers = [
        'S.N.', 'DATE', 'BRANCH', 'BRANCH CNF', 'LOS/RLMS NO', 
        'CBS / ACC NO', 'CUSTOMER NAME', 'LOAN AMOUNT', 
        'ACCOUNT TYPE', 'DATE OF DISBURSEMENT', 'SLAB', 
        'COMMISSION %', '100.00', '0.90', 'GST', 'TOTAL'
    ];

    // Add the "0.10" column header if is_tenper_hold is "Yes"
    if ($is_tenper_hold == 'Yes') {
        array_splice($headers, 14, 0, '0.10');  // Insert '0.10' before 'GST'
    }
    
    // Set the header in row 1 and apply bold style
    $colIndex = 'A';
    foreach ($headers as $header) {
        $sheet->setCellValue($colIndex . '1', $header);
        $sheet->getStyle($colIndex . '1')->getFont()->setBold(true);
        $colIndex++;
    }

    // Write data to the sheet
    $row = 2;
    $serial_number = 1;
    foreach ($grouped_invoices as $branch_cnf => $group) {
        foreach ($group['invoices'] as $invoice) {
            if (isset($invoice['is_rr_commission'])) {
                // RR Commission row
                $sheet->setCellValue('A' . $row, $serial_number++);
                $sheet->setCellValue('B' . $row, date('d/m/Y', strtotime($invoice['invoice_date'])));  // RR Commission date
                $sheet->setCellValue('C' . $row, $invoice['branch_name']);
                $sheet->setCellValue('D' . $row, $invoice['branch_cnf']);
                $sheet->setCellValue('E' . $row, $invoice['los_id']);
                $sheet->setCellValue('F' . $row, $invoice['rr_cbs_acct_no']);
                $sheet->setCellValue('G' . $row, $invoice['user_name']);
                $sheet->setCellValue('H' . $row, '');  // Empty for RR Commission
                $sheet->setCellValue('I' . $row, 'RinnRaksha');  // Set ACCOUNT TYPE to RR Commission
                $sheet->setCellValue('J' . $row, date('d/m/Y', strtotime($invoice['disb_date'])));
                $sheet->setCellValue('K' . $row, '');
                $sheet->setCellValue('L' . $row, '');
                $sheet->setCellValue('M' . $row, $invoice['commission']);
                $sheet->setCellValue('N' . $row, $invoice['commission_90']);
                
                // Add the 0.10 column only if is_tenper_hold is 'Yes'
                if ($is_tenper_hold == 'Yes') {
                    $sheet->setCellValue('O' . $row, $invoice['commission_10']);
                    $sheet->setCellValue('P' . $row, $invoice['gst_amt']);
                    $sheet->setCellValue('Q' . $row, $invoice['total_amt']);
                } else {
                    $sheet->setCellValue('O' . $row, $invoice['gst_amt']);
                    $sheet->setCellValue('P' . $row, $invoice['total_amt']);
                }

                // Apply number formatting
                $sheet->getStyle('M' . $row . ':Q' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
            } else {
                // Regular invoice row
                $sheet->setCellValue('A' . $row, $serial_number++);
                $sheet->setCellValue('B' . $row, date('d/m/Y', strtotime($invoice['invoice_date'])));
                $sheet->setCellValue('C' . $row, $invoice['branch_name']);
                $sheet->setCellValue('D' . $row, $branch_cnf);
                $sheet->setCellValue('E' . $row, $invoice['los_id']);
                $sheet->setCellValue('F' . $row, ($invoice['loan_type_id'] == 5) ? $invoice['rr_cbs_acct_no'] : $invoice['bank_acct_no']);
                $sheet->setCellValue('G' . $row, $invoice['user_name']);
                $sheet->setCellValue('H' . $row, $invoice['loan_amount']);
                $sheet->setCellValue('I' . $row, $invoice['account_type']);
                $sheet->setCellValue('J' . $row, date('d/m/Y', strtotime($invoice['disb_date'])));
                $sheet->setCellValue('K' . $row, $invoice['commi_slab']);
                $sheet->setCellValue('L' . $row, $invoice['sbi_commi'] . '%');
                $sheet->setCellValue('M' . $row, $invoice['100_amt']);
                $sheet->setCellValue('N' . $row, $invoice['0_90_amt']);
                
                // Add the 0.10 column only if is_tenper_hold is 'Yes'
                if ($is_tenper_hold == 'Yes') {
                    $sheet->setCellValue('O' . $row, $invoice['0_10_amt']);
                    $sheet->setCellValue('P' . $row, $invoice['gst_amt']);
                    $sheet->setCellValue('Q' . $row, $invoice['total_amt']);
                } else {
                    $sheet->setCellValue('O' . $row, $invoice['gst_amt']);
                    $sheet->setCellValue('P' . $row, $invoice['total_amt']);
                }

                // Apply number formatting for regular invoice row
                $sheet->getStyle('H' . $row . ':Q' . $row)->getNumberFormat()->setFormatCode('#,##0.00');
            }

            $row++;
        }

        // If there is more than one invoice for the branch, display the totals
        if (count($group['invoices']) > 1) {
            $sheet->setCellValue('M' . $row, $group['totals']['100_amt']);
            $sheet->setCellValue('N' . $row, $group['totals']['0_90_amt']);
            
            if ($is_tenper_hold == 'Yes') {
                $sheet->setCellValue('O' . $row, $group['totals']['0_10_amt']);
                $sheet->setCellValue('P' . $row, $group['totals']['gst_amt']);
                $sheet->setCellValue('Q' . $row, $group['totals']['total_amt']);
            } else {
                $sheet->setCellValue('O' . $row, $group['totals']['gst_amt']);
                $sheet->setCellValue('P' . $row, $group['totals']['total_amt']);
            }

            // Apply bold style to the totals row
            $sheet->getStyle('M' . $row . ':Q' . $row)->getFont()->setBold(true);

            // Apply number formatting to totals row
            $sheet->getStyle('M' . $row . ':Q' . $row)->getNumberFormat()->setFormatCode('#,##0.00');

            $row++;
        }

        // Add a separator row between groups
        $row++;
    }

    // Auto-size columns for readability
    foreach (range('A', 'Q') as $columnID) {
        $sheet->getColumnDimension($columnID)->setAutoSize(true);
    }

    // Set headers for downloading the file
    $filename = "RBO_LOAN_LIST_" . $first_invoice_no->invoice_number . ".xlsx";
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');
    header('Cache-Control: max-age=1'); // If serving to IE 9

    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}

}

